# -*- coding: UTF-8 -*-
"""
Fonctions de gestion des locks Eole
"""
from os import unlink, system
from os.path import join, isfile

def add_lock(lock_path, lock_name, content=''):
    """création d'un lock
    renvoie False si le fichier n'a pas pu être créé
    """
    lock_file = join(lock_path, lock_name)
    with open(lock_file, 'w') as lock:
        lock.write(content)
    if not check_lock(lock_path, lock_name, content=content):
        return False
    return True

def del_lock(lock_path, lock_name):
    """suppression d'un lock
    True si existant, False sinon
    """
    lock_file = join(lock_path, lock_name)
    if isfile(lock_file):
        try:
            unlink(lock_file)
        except OSError:
            return False
    return True

def check_lock(lock_path, lock_name, extended=False, content=''):
    """Test d'existence d'un lock
    """
    status = False
    lock_file = join(lock_path, lock_name)
    try:
        with open(lock_file, 'r') as lock:
            if extended == True:
                status = lock.read() == content
            else:
                status = True
    except IOError:
        status = False
    return status
