# -*- coding: UTF-8 -*-
"""
utilitaires de lancement de processus
"""
import sys
import socket
import subprocess
from os.path import isfile
from creole2 import config

def _gen_container_cmd(cmd, container, context, env=None, pty=False):
    """
    génération de la commande en mode conteneur
    """
    if isfile(config.containers_file):
        dico_container = {}
        execfile(config.containers_file, {}, dico_container)
        if dico_container.has_key('container_path_%s' % container):
            if context == False:
                path = dico_container['container_path_%s' % container]
                if path != "":
                    cmd = ['chroot', path] + cmd
            else:
                ip_address = dico_container['container_ip_%s' % container]
                if ip_address != '127.0.0.1':
                    if not test_conteneur(container, ip_address):
                        raise Exception('Conteneur {0} inaccessible'.format(container))
                    escaped_cmd = []
                    if env != None:
                        for key, value in env.items():
                            escaped_cmd.append('%s=%s'%(key, value))
                    # échappement des doubles-quotes et des antislashes pour #757 et #1439
                    for elt in cmd:
                        escaped_cmd.append('"%s"' % elt.replace('\\', '\\\\').replace('"', '\\"'))
                    cmd = ['/usr/bin/ssh']
                    if pty:
                        cmd.append('-t')
                    cmd.extend(['-q', '-o', 'LogLevel=ERROR',
                                '-o', 'StrictHostKeyChecking=no',
                                'root@%s' % ip_address])
                    cmd.extend(escaped_cmd)
    return cmd

def system_code(cmd, stdin=None, container=config.VIRTMASTER, context=True, env=None, pty=False):
    """
    exécution d'une commande shell :
    - affichage des messages (stdout/stderr) "à l'écran"
    - retourne le code de retour sous la forme d'un entier
    @cmd : commande sous la forme d'une liste
    @stdin : chaine à passer à stdin ou None
    @container : conteneur dans lequel exécuter la commande
    @context : conservation du contexte (dans un conteneur)
    """
    # fix pour éviter "IOError: [Errno 9] Bad file descriptor" (EAD)
    if sys.stdout.mode == 'wb':
        print "Sortie binaire détectée => affichage masqué"
        return system_out(cmd, stdin=stdin, container=container, context=context)[0]
    if container != config.VIRTMASTER:
        cmd = _gen_container_cmd(cmd, container, context, env, pty)
    if pty:
        import pty
        if stdin != None:
            raise Exception('Utilisation de pty et stdin ensemble est impossible')
        master, slave = pty.openpty()
        process = subprocess.Popen(cmd, stdin=master, stderr=slave, env=env)
        process.communicate()
    else:
        process = subprocess.Popen(cmd, stdin=subprocess.PIPE, env=env)
        process.communicate(stdin)
    return process.returncode

def system_out(cmd, stdin=None, container=config.VIRTMASTER, context=True, env=None, pty=False):
    """
    exécution d'une commande shell :
    - retourne un tuple contenant :
        - le code de retour sous la forme d'un entier
        - stdout
        - stderr
    @cmd : commande sous la forme d'une liste
    @stdin : chaine à passer à stdin ou None
    @container : conteneur dans lequel exécuter la commande
    @context : conservation du contexte (dans un conteneur)
    """
    if container != config.VIRTMASTER:
        cmd = _gen_container_cmd(cmd, container, context, env, pty)
    if pty:
        import pty
        if stdin != None:
            raise Exception('Utilisation de pty et stdin ensemble est impossible')
        master, slave = pty.openpty()
        process = subprocess.Popen(cmd, stdin=master,
                               stdout=subprocess.PIPE,
                               stderr=slave,
                               env=env)
        stdout, stderr = process.communicate()
    else:
        process = subprocess.Popen(cmd, stdin=subprocess.PIPE,
                               stdout=subprocess.PIPE,
                               stderr=subprocess.PIPE,
                               env=env)
        stdout, stderr = process.communicate(stdin)
    return (process.returncode, stdout, stderr)

def is_installed(package, container=config.VIRTMASTER, context=True):
    """ vérifie si un paquet est installé ou pas"""
    cmd = ["/usr/bin/dpkg", "--get-selections", package.strip()]
    code, stdout, _ = system_out(cmd, container=container, context=context)
    if code != 0:
        # paquet non installé
        return False
    pkg_ret = stdout.strip().split('\n')[-1].split()
    if pkg_ret == [] or len(pkg_ret) != 2:
        return False
    pkg_status = pkg_ret[1].lower()
    #pkg_status is install, desinstall, hold or purge
    if pkg_status not in ['install', 'deinstall', 'hold', 'purge']:
        raise Exception ('unknown status for package %s : %s'%(package,
                        pkg_status))
    if pkg_status in ['install', 'hold']:
        return True
    return False

def tcpcheck(ip_address, port, timeout=1):
    """
    Teste la réponse d'un couple adresse IP - Port
    """
    try:
        soc = socket.socket()
        soc.settimeout(int(timeout))
        soc.connect((ip_address, int(port)))
        soc.close()
    except socket.error:
        return False
    return True

def test_conteneur(container, ip_address=None):
    """
    Teste si le conteneur "container" est démarré
    et que son port SSH est bien ouvert
    """
    if container == config.VIRTMASTER:
        return True
    dico_container = {}
    execfile(config.containers_file, {}, dico_container)
    try:
        path = dico_container['container_path_%s' % container]
    except:
        print "Conteneur {0} inconnu".format(container)
        return False
    if path == '':
        return True
    splitpath = path.split('/')
    groupname = splitpath[len(splitpath)-2]
    cmd = ['/usr/bin/lxc-info', '-n', groupname]
    if not system_out(cmd)[1].strip().lower().endswith(' is running'):
        return False
    if ip_address == None:
        ip_address = dico_container['container_ip_%s' % container]
    if not tcpcheck(ip_address, '22', '2'):
        return False
    return True
