# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# ent_rpc.py
#  
# fonctions xmlrpc pour la gestion des plages d'identifiants ent
#       
###########################################################################
"""module de gestion des identifiants ent
"""
from zephir.backend.db_utils import *
from zephir.backend import config
from zephir.backend.config import u, log
from zephir.backend.entid import IdPoolManager
from zephir.backend.xmlrpceole import XMLRPCEole as XMLRPC

class ENTRPC(XMLRPC):
    """serveur XMLRPC zephir pour la gestion centralisé des identifiants ENT
    """

    def __init__(self, parent):
        self.dbpool = db_connect()
        self.dbpool.noisy = 0
        self.parent = parent
        self.id_manager = IdPoolManager(self.parent.s_pool)
        XMLRPC.__init__(self)

    def xmlrpc_get_id_pools(self, cred_user, code_ent = None):
        """renvoie des informations sur les pools d'identifiants ENT"""
        return u(self.id_manager.get_pool(code_ent))

    def xmlrpc_get_code_ent(self, cred_user):
        """renvoie des informations sur les pools d'identifiants ENT"""
        return 1, u(self.id_manager.get_code_ent())

    def xmlrpc_get_id_range(self, cred_user, id_serveur, cle_pub, nb_id = 100):
        """réserve une plage d'identifiant pour un établissement donné (serveur scribe)"""
        return u(self.id_manager.get_id_range(id_serveur, cle_pub, nb_id))

    def xmlrpc_validate_id_range(self, cred_user, code_ent, id_serveur, md5, ranges):
        """confirme la prise en compte d'une plage d'identifiants côté établissement"""
        return u(self.id_manager.validate_id_range(code_ent, id_serveur, md5, ranges))

    def xmlrpc_reserve_range(self, cred_user, min, max):
        """Réserve manuellement une plage d'identifiants"""
        return u(self.id_manager.reserve_range(min, max))
