# -*- coding: UTF-8 -*-

"""
Classe parente d'un agent python
"""

import time, os
from zephir.monitor.utils import createfile
from zephir.monitor.config import Config


class Agent:
    def __init__(self):
        """
        - append_mode : 0 par défaut mode écrasement (pas d'ajout à la suite par le scheduler)
        - xml_filename : sortie xml
        - hml_filename : sortie html
        - satus : etat de l'agent (up|down)
        """
        cfg = Config()
        self.append_mode = 0
        self.date = time.strftime("%d/%m/%Y", time.localtime())
        self.xml_filename = cfg.get_xml_name(self.name) 
        self.html_filename = cfg.get_html_name(self.name) 
        self.status = "1"
        self.contenu_xml=""
        self.contenu_html=""

    # template de la sortie XML
    XML = """
<agent nom="%s" date="%s" description="%s" status="%s">
%s
</agent>
"""

    # template de la sortie HTML
    HTML = """
<div class="titlediv">
<h1 class="newstitle">
%s
</h1>
<a name="%s"/>
</div>
<div class="bodydiv">
%s
</div>
"""

    def first_time(self):
        """Permet un comportement différent de write_xml
        suivant la valeur du mode ajout 
        """
        if os.path.isfile(self.xml_filename):
            return False
        else:
            return True

    def set_status(self, status):
        """Fixe l'état de l'agent (up ou down)
        """
        if status == "1" or status == "0":
            self.status = status
        else :
            raise Exception, "statut errone"
    
    def write_xml(self):
        """Ecriture du xml dans un fichier
        """
        test_first = False

        if self.first_time():
            test_first = True

        if not self.append_mode:
            fh = open(self.xml_filename, "w")
        else:
            fh = open(self.xml_filename, "a")

        if test_first or not self.append_mode:
            fh.write("""<?xml version="1.0" encoding="%s"?>\n""" % config.charset)

        fh.write( self.XML % (self.name,self.date,self.description,self.status,self.contenu_xml) )
        fh.close()

    def write_html(self):
        """Ecriture du html dans un fichier 
        """
        createfile( self.html_filename, self.HTML % (self.description,self.name,self.contenu_html) )
    
    def __str__(self):
        return """<Agent : %s>""" % self.name


class MicroAgent:
    def __init__(self):
        """
        - satus : etat du micro-agent (up|down)
        """
        self.status = "1"
        self.contenu_xml=""
        self.contenu_html=""

    def set_status(self, status):
        """Fixe l'état de l'agent (up ou down)
        """
        if status == "1" or status == "0":
            self.status = status
        else :
            raise Exception, "statut errone"
    
    def _status_to_diode(self):
        """Retourne la balise image en fonction de l'état
        """
        if self.status=="1" :
            image="./images/b_vert.png"
        else:
            image="./images/b_rouge.png"
        return "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<img src=\""+image+"\">"
        
    def dump_xml(self):
        """sortie en xml
        """
        XML_DATA = """<variable name="%s" value="%s"/>"""
        self.contenu_xml=XML_DATA % (self.name, self.status)
        
    def dump_html(self):
        """sortie en html
        """
        HTML_DATA = """<tr><td>%s&nbsp;</td><td>%s</td></tr>"""
        self.contenu_html=HTML_DATA % (self.description, self._status_to_diode())

if __name__ == "__main__":
    pass
