# -*- coding: UTF-8 -*-

"""Fonctionnement de L'EAD
"""
from zephir.monitor.agent.agent import MicroAgent
import commands,dico

class Ead(MicroAgent):
    """Test EAD
    """
    def __init__(self):
        self.name="ead"
        self.description="""Fonctionnement de l'outil d'administration (EAD)"""

        MicroAgent.__init__(self)
        self._system()
        self.dump_xml()
        self.dump_html()

    def _system(self):
        """Récupère une sortie système
        """
        ip_eth0 = dico.DicoEole().get_value('adresse_ip_eth0')
        exec_cmd = "tcpcheck 3 "+ip_eth0+":8501"
        s = commands.getoutput(exec_cmd)
        if s.count("alive") > 0:
            return 1
        self.set_status("0")
        return 0

if __name__ == "__main__":
    Ead()
