# -*- coding: UTF-8 -*-
"""Etat de la mémoire
"""

import os, time
from zephir.monitor.utils import list2list_to_table
from agent import Agent

class MemAgent(Agent):
    """Bilan de l'etat de la memoire
    """
    def __init__(self,exec_cmd="/bin/cat /proc/meminfo"):
        self.exec_cmd = exec_cmd
        self.name = "mem"
        self.description="""Bilan de la mémoire"""
        Agent.__init__(self)

        # traitements particuliers
        brut = self._mem()
        self.contenu_xml  = list2list_to_table(brut)
        self.contenu_html = self.contenu_xml #list2list_to_table(self.brut)
        
        # écriture dans les fichiers
        self.write_html()
        self.write_xml()


    def _cat(self):
        sortie = os.popen(self.exec_cmd)
        resultat = sortie.read()
        sortie.close()
        return resultat.split("\n")

    def _mega(self,val):
        """ transfo de la valeur passée (string en octets) en Mo
        """
        return (int(val)/1024/1024)

    def _pourcent(self,use,tot):
        """ calcul du pourcentage de mémoire utilisée
        """
        return (str(int(use)*100/int(tot))+"%")

    def _mem(self):
        """ effectue les traitements et revoie le résultat dans une liste de listes
        """
        l = self._cat()
        liste = [['type', 'utilisation', 'libre (mo)','utilisé (mo)','taille (mo)']]
        physique=l[1].split()
        liste.append(['Mémoire Physique', self._pourcent(physique[2],physique[1]),self._mega(physique[3]), self._mega(physique[2]), self._mega(physique[1])])
        swap=l[2].split()
        liste.append(['Swap disque', self._pourcent(swap[2],swap[1]), self._mega(swap[3]), self._mega(swap[2]), self._mega(swap[1])])
        # Alerte si swap disque atteint plus de XX (%)
        if int(self._pourcent(swap[2],swap[1])[:-1]) > 90:
            self.set_status("0")
        
        return liste


if __name__ == "__main__":
    MemAgent()
