# -*- coding: UTF-8 -*-

"""Informations sur l'utilisation du système
"""
import commands
import os

from agent import Agent
from zephir.monitor.utils import list_to_table

class Uptime(Agent):
    """Infos cpu
    """
    def __init__(self):
        self.name="uptime"
        self.description="""Informations d'utilisation système"""
        Agent.__init__(self)
        # traitements (à restructurer si possible)
        self.contenu_xml = self._dump_xml()
        self.contenu_html= self._dump_html()
        # écriture dans les fichiers
        self.write_html()
        self.write_xml()

    def _uptime(self):
        """Récupère une sortie système
        """
        exec_cmd = "/usr/bin/uptime"
        s = commands.getoutput(exec_cmd)
        lignes = s.splitlines()
        # On parse la sortie standard de la commande
        ligne = lignes[0]
        # nombre d'utilisateurs
        champs=ligne[:ligne.index('user')]
        users=int(champs[champs.rindex(',')+1:])
        # on récupère le temps d'uptime
        uptime_str = champs[:champs.rindex(',')]
        uptime_str = uptime_str[champs.index('up')+2:].strip()

        return uptime_str,users


    def _dump_xml(self):
        """sortie en xml
        """
        
        UPT_DATA = """<variable name="uptime" value="%s"/>
        <variable name="utilisateurs" value="%s"/>"""

        return UPT_DATA % (self._uptime())
        
    def _dump_html(self):
        """sortie en html
        """
        uptime,users = self._uptime()

        UPT_HTM = """<ul>
        <li>serveur en marche depuis : %s</li>
        <li>nombre d'utilisateurs actuel : %s</li>
        </ul>"""
        
        return UPT_HTM % (uptime, users)


if __name__ == "__main__":
    Uptime()
    # print res._dump_xml()
