# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# collecteur.py
#  
# Récupère les fichiers xml d'un répertoire d'un serveur
#       
###########################################################################

import os

from twisted.persisted import dirdbm

from zephir.config import PATH_ZEPHIR
from zephir.monitor import xmlite

class AgentCollecteur:
    """Concerne les informations de type *tableau de bord* de tous les agents sur un serveur
    """
    def __init__(self, id_serveur):
        self.id_serveur = id_serveur
        xml_dir = PATH_ZEPHIR + 'sites/' + str(self.id_serveur) + "/xml/"
        list_xml = os.listdir(xml_dir)
        self.xml_name_list = []
        for fic in list_xml:
            if fic.endswith('.xml'):
                self.xml_name_list .append(xml_dir+fic)

        # construction de l'arborescence dirdbm
        self.shelf = self._make_dirdbm()

        # pickle
        self._serveur_pickle()


    def _make_dirdbm(self):
        """Construis l'arborescence dirdbm pour le serveur
        si elle n'existe pas encore
        """
        self.dirdbm_path = PATH_ZEPHIR + "sites/" + str(self.id_serveur) + "/dirdbm"
        if os.path.isdir(self.dirdbm_path):
            pass
        else : 
            os.makedirs(self.dirdbm_path)

        return dirdbm.Shelf(self.dirdbm_path)
        
        
    def get_agent_info(self, xml_name):
        """Récupère les attributs de la balise agent
        """
        l = xmlite.load(xml_name) 
        # dictionnaire des attributs de la balise agent
        attrs = l[1][1]

        return attrs['nom'], attrs['description'], attrs['status'], attrs['date']

    def get_serveur(self) :
        """Récupère les informations de type tableau de bord pour un serveur
        """
        l = []
        for xml_name in self.xml_name_list:
            l.append(self.get_agent_info(xml_name))

        return l

    def _serveur_pickle(self):
        """Persistence d'un serveur dans une arborescence dirDBM 
        """
        for l in self.get_serveur():
            self.shelf[l[0]] = (l[1], l[2], l[3])


class ServeurStatus:
    """Statut d'un serveur et récupération des informations
    # FIXME
    """
    def __init__(self, id_serveur):
        self.id_serveur = id_serveur
        self.dirdbm_path = PATH_ZEPHIR + "sites/" + str(self.id_serveur) + "/dirdbm"
        self.shelf = dirdbm.Shelf(self.dirdbm_path)
        self.data = self._serveur_unpickle()
            
    def _serveur_unpickle(self):
        """Les informations pour le tableau de bord
        """
        d = {}
        for agent_name in self.shelf.keys():
            d[agent_name] = self.shelf[agent_name]

        return d

    def get_status(self):
        """Un statut pour le serveur dans son ensemble
        """
        for l in self.data.values():
            if int(l[1]) == 0:
                return 0
        return 1

    def get_agents_status(self):
        """etat d'un agent particulier
        """
        return self.data


if __name__ == "__main__":
    # AgentCollecteur("abcdef")
    # print ServeurStatus("abcdef").get_status()
    pass

