#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# website.py
#  
# Creation du site web à partir de la sortie des agents (deprecated)
#       
###########################################################################
import time
import os,sys

from utils import readfile, createfile
from zephir.monitor.config import Config

try:
    from zephir.lib_zephir import *
except:
    sys.exit("erreur, librairie zephir introuvable")
    
import widgets # pour le design de la page

class Navigation:
    """Navigation dans le site
    (page d'agents ou sous-pages)
    """

    NAVIGATION_WIDGET = """
    <img src="./images/site.jpg" alt="eole" align="center"/>
    <div class="leftcol">
    <div class="otherboxtitle">Navigation</div>
    <div class="otherbox">
    %s
    </div>
    </div>
    """

    def __init__(self):
        self.cfg = Config()
        self.group_list = self.cfg.get_group_list()

    def get_agent_anchor(self, group_name):
        """Construis la liste des agents d'un groupe
        [ ( agent_name, agent description ) ]
        """
        agent_list = self.cfg.get_agent_group(group_name)
        l = []
        for agent in agent_list:
            l.append(
                (agent, self.cfg.get_agent_desc(agent))
                )
        l.sort()
        return l

    def agent_widget(self, agent, description, group):
        """Construis les ancres internes à une page
        (correspondant aux agents)
        """
        AGENT_WIDGET = """
        <a href="%s#%s">%s</a> : %s<br/>
        """
        page = self.cfg.get_html_relative_name(group)
        return AGENT_WIDGET % (page, agent, agent,description)

    def group_widget(self, page, group, description):
        """Construis les liens de navigation par page
        """
        GROUP_WIDGET = """
        <h1><a href="%s">%s</a></h1>
        <h2>%s</h2>
        <p>
        %s
        </p>
        """

        l = []
        for liste in self.get_agent_anchor(group):
            l.append(
                self.agent_widget(liste[0], liste[1], group)
                )
        s = "".join(l)

        return GROUP_WIDGET %(page, group, description, s)

    def render(self):
        """Renvoie le html de la navigation box
        """
        # liens sur les page de groupes
        group_links = []
        for group_name in self.group_list :
            group_links.append(
                (group_name, self.cfg.get_html_relative_name(group_name), self.cfg.get_group_desc(group_name))
                )
        group_links.sort()
        # formatage html
        l = []
        for liste in group_links:
            group_name, filename, description = liste
            l.append(
                self.group_widget(filename, group_name, description)
                )
        content = "\n".join(l)
        return self.NAVIGATION_WIDGET % content


    def render_accueil(self):
        """Renvoie le html de la navigation pour la page index
        """
        # liens sur les page de groupes
        group_links = []
        for group_name in self.group_list :
            group_links.append(
                (group_name, self.cfg.get_html_relative_name(group_name), self.cfg.get_group_desc(group_name))
                )
        group_links.sort()
        # formatage html
        l = []
        for liste in group_links:
            group_name, filename, description = liste
            l.append(
                self.group_widget(filename, group_name, description)
                )
        content = "\n".join(l)
        return content


    
class Page:
    """Constitution des pages du site
    """
    def __init__(self, group_name):
        self.group_name = group_name
        self.navigation = Navigation().render()        
        self.cfg = Config()
        self._write_page()

    def _get_content(self):
        """Récupère les bribes de html issues des agents d'un groupe
        """
        agent_list = self.cfg.get_agent_group(self.group_name)
        agent_list.sort()
        l = []
        for agent in agent_list:

            html_file = self.cfg.get_html_name(agent)
            l.append(
                readfile(html_file)
                )
        return "\n".join(l)
    
    def _write_page(self):
        """Ecriture de la page dans le répertoire site
        """
        page_name = self.cfg.get_html_site(self.group_name)
        PAGE = widgets.PAGE_WIDGET
        d = {} 
        d["title"] = self.cfg.get_group_desc(self.group_name)
        d["date"] = time.strftime("%d/%m/%Y : %Hh%M", time.localtime())
        d["NAVIGATION_WIDGET"] = self.navigation
        d["CENTRAL_WIDGET"] = self._get_content()
        page = PAGE % d
        createfile(page_name, page)

class PageAccueil:
    """index.html
    """
    def __init__(self):
        self.navigation = Navigation().render()
        self.liens = Navigation().render_accueil()
        self.cfg = Config()
        self._write_page()

    def _get_content(self):
        """Récupère les bribes de html issues des agents d'un groupe
        """
        HTML = """
<div class="titlediv">
<h1 class="newstitle">
Liste des agents pour la surveillance du serveur
</h1>
<a name="%s"/>
</div>
<div class="bodydiv">
%s
</div>
"""

        return HTML % ("index" , self.liens + "<br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>")
    
    def _write_page(self):
        """Ecriture de la page dans le répertoire site
        """
        page_name = self.cfg.get_html_site("index")
        PAGE = widgets.PAGE_WIDGET
        d = {} 
        d["title"] = "index"
        d["date"] = time.strftime("%d/%m/%Y : %Hh%M", time.localtime())
        d["NAVIGATION_WIDGET"] = self.navigation
        d["CENTRAL_WIDGET"] = self._get_content()
        page = PAGE % d
        createfile(page_name, page)

class Site:
    """Création du site web
    et envoi des données à Zephir
    """
    def __init__(self):
        self.group_list = Config().get_group_list()
        self.set_page()
        # creation de index.htm
        PageAccueil()
        # self.send_zephir()
        

    def set_page(self):
        """Appelle toutes les pages des groupes
        """
        for group in self.group_list:
            Page(group)

    def send_zephir(self):
        """Créé une archive du site et des données XML
        """
        # on permet de continuer sans données zephir pour les tests
        # sys.exit("erreur, librairie zephir introuvable")
        # on récupère le n° du serveur et on crée l'archive
        # /usr/share/eole/zephir doit être dans le pythonpath
        try:
            try:
                reload(conf)
            except:
                import zephir.zephir_conf.zephir_conf as conf
        except:
            # serveur non enregistré
            return 1
        # préparation de l'archive
        cmd_tar = """/bin/tar -cvf /tmp/site%s.tar site xml >> /dev/null""" % conf.id_serveur
        res = os.system(cmd_tar)
        # lancement de l'appel à zephir
        os.system('/usr/share/zephir/scripts/zephir_client call')
        
	# print '\nresultat tar : '+str(res)

    def page_accueil(self):
        """
        """
        titre = "test_titre"
        # FIXME :  mettre le contenu de cette page en template aussi

if __name__ == "__main__":
    Site()
