#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# add_user.py
#  
# Utilitaire de création d'utilisateurs LDAP pour zephir
#       
###########################################################################

import getpass
from zephir.utils.ldap_user import add_user, encrypt_passwd


if __name__ == '__main__':
    # on demande le nom et mot de passe du nouvel utilisateur
    login = raw_input("nom de connexion du nouvel utilisateur : ")
    # mot de passe du nouvel utilisateur
    pass_ok = 0
    while pass_ok == 0:
        passwd = getpass.getpass("mot de passe pour l'utilisateur "+login+" : ")
        passwd2 = getpass.getpass("saisissez à nouveau ce mot de passe : ")
        if passwd == passwd2 and passwd != "":
            pass_ok = 1
        else:
            print ("\n Les mots de passe ne correspondent pas, recommencez\n")

    # encryptage du mot de passe (SSHA)
    enc_passwd = encrypt_passwd(passwd)
    # création de l'utilisateur
    add_user(login, enc_passwd)
