# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# config.py
#
# Fichier de conf de l'application web Zephir
#
###########################################################################
from zephir.config import *
from zephir.eolerpclib import EoleProxy
from ConfigParser import ConfigParser

# paths

TEMPLATE_DIR = ROOT_DIR + "web/template/"
IMAGE_DIR = ROOT_DIR + "web/images/"
CSS_DIR = ROOT_DIR + "web/css/"
FONTS_DIR = ROOT_DIR + "web/fonts/"
HELP_DIR = ROOT_DIR + "web/aide/"
FLASKDIR = "/usr/share/eole/flask"
SERVEUR_ZEPHIR = ADRESSE_ZEPHIR
DEFAULT_TIMEOUT = "30"
try:
    SESSION_TIMEOUT = int(conf.get_creole('zephir_web_timeout')) * 60
    assert SESSION_TIMEOUT > 0
except:
    SESSION_TIMEOUT = 1800

# gestion des couleurs/themes
selected_theme = conf.get_creole('zephir_web_theme', 'genConfig')
# lecture des couleurs
col_file = ROOT_DIR + "web/themes/%s/colors.ini" % selected_theme
colors = ConfigParser()
colors.read(col_file)

web_colors = {}
web_colors['main_color'] = colors.get('zephir_web','main_color')
web_colors['menu_color'] = colors.get('zephir_web','menu_color')
web_colors['group_color'] = colors.get('zephir_web','group_color')
web_colors['bg_color'] = colors.get('zephir_web','bg_color')
web_colors['table_color'] = colors.get('zephir_web','table_color')
web_colors['link_color'] = colors.get('zephir_web','link_color')
web_colors['hover_color'] = colors.get('zephir_web','hover_color')

# Version actuelle des paquets Zéphir
import os
cmd = """echo -n "zephir-parc - " > /usr/share/zephir/.version ; /usr/bin/dpkg-query -W zephir-common | cut -f2 >> /usr/share/zephir/.version"""
res=os.system(cmd)
f=open('/usr/share/zephir/.version')
VERSION_ZEPHIR = f.read()
f.close()

file_icons = {"missing":"stock_calc-cancel.png",
              "dir":"folder.png",
              "file":"gnome-mime-text.png"}

def build_proxy(cred_user, cred_password):
    """construction d'un proxy xmlrpc vers le backend local
    """
    return EoleProxy("http://{0}:{1}@localhost:{2}/".format(cred_user, cred_password, str(int(PORT_ZEPHIR) + 1)))

# navigation web
class Navigation:
    def __init__(self,aide=""):
        self.liens = [
            ("accueil", "/"),
            ("serveurs", "/serveur"),
            ("établissements", "/etab"),
            ("modules", "/module"),
            ("administration","/administration"),
            ("déconnexion","/logout"),
            ]
        if aide != "":
            self.liens.insert(-1,("aide","""javascript:void(window.open('/aide/%s','rapport','scrollbars=yes,resizable=yes,location=no,directories=no,status=no'))""" % aide))

    def render(self):
        l = []
        l.append("""<center><font face="Tahoma" color="FFFFFF">""")
        for lien in self.liens :
            s = "<a href=%s>%s</a><br/>" %(lien[1], lien[0])
            l.append(s)
        l.append("</font></center>")
        return ("\n").join(l)


    def menu(self):
        l = ["""<center><table border="0" cellspacing="1" cellpadding="0"><tr>"""]
        for lien in self.liens :
            str = """<td>|</td><td><a href="%s">%s</a></td>""" % (lien[1], lien[0])
            l.append(str)
        l.append("<td>|</td></table></center>")
        return ("\n").join(l)

server_sort_keys = {'rne':"code RNE",
                    'module_actuel':"module",
                    'variante':"variante",
                    'id':"identifiant",
                    'libelle':"nom de serveur",
                    'installateur':"installateur",
                    'nb_cmd':"nb de commandes",
                    'maj':"paquets non à jour",
                    'md5s':"md5 de la configuration",
                    'dicos':"dictionnaire non activés",
                    'detail':"détail des erreurs",
                    'etat':"Etat général du serveur",
                   }
etabs_sort_keys = {'rne':"Identifiant",
                   'libelle':"Libellé",
                   'ville':"Ville",
                   'cp':"CP",
                   'type':"Type",
                  }

# aide sur la recherche avec wildcards
ilike_syntax ="""Caractères spéciaux : _ remplace un caractère,  % un nombre indéfini de caractères (<a href="javascript:void(window.open('http://docs.postgresqlfr.org/8.4/functions-matching.html','site', 'resizable=yes, location=no, directories=no, status=no, scrollbars=yes'))">plus de détails</a>)"""
