# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# backend_tap.py
#  
# création et démarrage des services backend zephir
#       
###########################################################################
from twisted.application import internet, service
from twisted.web import server,static
from twisted.web.resource import Resource
from twisted.python import usage
import sys
reload(sys)
sys.setdefaultencoding('utf-8')

from zephir.backend.config import PATH_ZEPHIR, log, NO_LOCAL_AGENTS
from zephir.certificats import ServerContextFactory
from zephir.monitor.agentmanager import config as cfg
from zephir.monitor.agentmanager.zephirservice import ZephirService

from zephir.backend import etabs_rpc
from zephir.backend import users_rpc
from zephir.backend import modules_rpc
from zephir.backend import serveurs_rpc
from zephir.backend import uucp_rpc
from zephir.backend import services_rpc
from zephir.backend import prelude_rpc
from zephir.backend import scheduler_rpc
from zephir.backend import sentinelle_rpc
from zephir.backend import ent_rpc
from zephir.backend import aaf_rpc
from zephir.backend import local_rpc
from zephir.backend import dicos_rpc

from zephir.utils.ldap_user import check_local_ldap_admin_password

# options ligne de commande

class Options(usage.Options):
    optParameters = [["portRPC", "x", 7080, "Numero de port pour le serveur xmlrpc."],
                     ["portHTTP", "p", 8090, "Numero de port pour le serveur HTTP"],
                     ["config", None, cfg.DEFAULT_CONFIG['config_dir'],
                      "Directory to search for configurations when loading agents"],
                     ["data", None, cfg.DEFAULT_CONFIG['state_dir'],
                      "Directory where state data will be stored"],
                     ["archive", None, cfg.DEFAULT_CONFIG['uucp_dir'],
                      "Directory where the upload archive will be created"],
                     ["static", None, cfg.DEFAULT_CONFIG['static_web_dir'],
                      "Directory for static web data (graphics, stylesheets...)"],
                    ]

def makeService(config):
    config_ag = cfg.DEFAULT_CONFIG.copy()
    # log.startLogging(sys.stdout)
    # this could use some os.path.expanduser() and os.path.expandvars()
    config_ag['config_dir'] = "monitor/configs"
    config_ag['action_dir'] = "monitor/actions"
    config_ag['state_dir'] = "/var/lib/zephir/data"
    config_ag['uucp_dir'] = "/tmp"
    config_ag['static_web_dir'] = "/var/lib/zephir/sites"
    config_ag['static_base_url'] = "/sites"
    config_ag['tmp_data_dir'] = "monitor/data"
    # port TCP à écouter
    portRPC = int(config["portRPC"])
    portHTTP = int(config["portHTTP"])
    check_local_ldap_admin_password()

    root = Resource()
    # service des agents
    if NO_LOCAL_AGENTS == "oui":
        Server3 = ZephirService(config_ag,root_resource=root).with_publisher()
    else:
        Server3 = ZephirService(config_ag,root_resource=root).with_updater_and_publisher()
    zephir_users = users_rpc.RPCUsers()
    # serveurs XMLRPC
    zephir_etabs = etabs_rpc.RPCEtabs(zephir_users)
    zephir_modules = modules_rpc.RPCModules(zephir_users)
    zephir_serveurs = serveurs_rpc.RPCServeurs(zephir_users, Server3.publisher.manager)
    zephir_uucp = uucp_rpc.RPCUucp(zephir_users, Server3.publisher.manager)
    zephir_services = services_rpc.RPCServices(zephir_users)
    zephir_prelude = prelude_rpc.RPCPrelude(zephir_users)
    zephir_scheduler = scheduler_rpc.RPCScheduler(zephir_users)
    zephir_sentinelle = sentinelle_rpc.RPCSentinelle(zephir_users, Server3.publisher.manager)
    zephir_entid = ent_rpc.ENTRPC(zephir_users)
    zephir_aaf = aaf_rpc.AAFRPC(zephir_users)
    zephir_local = local_rpc.RPCLocal(zephir_users)
    zephir_dicos = dicos_rpc.RPCDicos(zephir_users)
    # mise en place des modules de gestion zephir
    zephir_users.putSubHandler('etabs',zephir_etabs)
    zephir_users.putSubHandler('modules',zephir_modules)
    zephir_users.putSubHandler('serveurs',zephir_serveurs)
    zephir_users.putSubHandler('uucp',zephir_uucp)
    zephir_users.putSubHandler('services',zephir_services)
    zephir_users.putSubHandler('prelude',zephir_prelude)
    zephir_users.putSubHandler('scheduler',zephir_scheduler)
    zephir_users.putSubHandler('sentinelle',zephir_sentinelle)
    zephir_users.putSubHandler('entid',zephir_entid)
    zephir_users.putSubHandler('aaf',zephir_aaf)
    zephir_users.putSubHandler('local',zephir_local)
    zephir_users.putSubHandler('dicos',zephir_dicos)
    rpc_server = server.Site(zephir_users)
    rpc_server.timeOut = 600
    # pages html de surveillance des serveurs
    root.putChild('sites',static.File(PATH_ZEPHIR+"sites/"))
    root.putChild('client',static.File(PATH_ZEPHIR+"sites/client"))
    root.putChild('static',static.File(PATH_ZEPHIR+"sites/"))

    appli = service.Application("zephir_backend")
    myService = service.IServiceCollection(appli)
    Server3.setServiceParent(myService)
    # création des services
    site = server.Site(root)
    site.timeOut = 600
    Server2 = internet.SSLServer(portHTTP, site, ServerContextFactory())
    Server2.setServiceParent(myService)
    Server1 = internet.SSLServer(portRPC, rpc_server, ServerContextFactory())
    Server1.startService = zephir_modules.startup
    Server1.stopService = zephir_modules.stop
    Server1local = internet.TCPServer(portRPC + 1, rpc_server, interface='localhost')
    Server1.setServiceParent(myService)
    Server1local.setServiceParent(myService)
    return myService
