# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# modules_rpc.py
#  
# fonctions xmlrpc pour la gestion des modules dans Zephir
#       
###########################################################################
"""module de gestion des modules Eole
"""
from zephir.backend.db_utils import *
from zephir.backend import config
from zephir.backend.config import u, log
from zephir.backend.xmlrpceole import XMLRPCEole as XMLRPC
from zephir.backend.lib_backend import ResourceAuthError

class RPCScheduler(XMLRPC):
    """serveur XMLRPC zephir pour la gestion des tâches
    """

    def __init__(self,parent):
        self.dbpool = db_connect()
        self.dbpool.noisy = 0
        self.parent = parent
        # mise à jour des modules si besoin
        XMLRPC.__init__(self)

    def xmlrpc_get_tasks(self,cred_user,id_res=None,type_res='serveur',all=False):
        """récupère le contenu d'une variante sur un autre zephir"""
        tasks = self.parent.scheduler.get_tasks(id_res,type_res,all)
        tasks = [str(t) for t in tasks]
        return 1,u(tasks)

    def xmlrpc_add_single(self, cred_user, name, cmd, month, day, hour, min):
        """ajoute une tâche unique"""
        id_task = self.parent.scheduler.add_task(name, cmd, month, day, hour, min, 'null', 0)
        return 1, id_task

    def xmlrpc_add_loop(self, cred_user, name, cmd, day, hour, min):
        """ajoute une tâche lancée à intervalle régulier"""
        id_task = self.parent.scheduler.add_task(name, cmd, 'null', day, hour, min, 'null', 1)
        return 1, id_task

    def xmlrpc_add_daily(self, cred_user, name, cmd, hour, min):
        """ajoute un tâche journalière"""
        id_task = self.parent.scheduler.add_task(name, cmd, 'null', 'null', hour, min, 'null', 2)
        return 1, id_task

    def xmlrpc_add_weekly(self, cred_user, name, cmd, hour, min, week_day):
        """ajoute un tâche hebdomadaire"""
        id_task = self.parent.scheduler.add_task(name, cmd, 'null', 'null', hour, min, week_day, 3)
        return 1, id_task

    def xmlrpc_add_monthly(self, cred_user, name, cmd, day, hour, min):
        """ajoute un tâche mensuelle"""
        id_task = self.parent.scheduler.add_task(name, cmd, 'null', day, hour, min, 'null', 4)
        return 1, id_task

    def xmlrpc_del_task(self, cred_user, id_task):
        """suppression d'une tâche"""
        if self.parent.scheduler.del_task(id_task):
            return 1, "OK"
        else:
            return 0, u("""Erreur lors de la  suppression""")

    def xmlrpc_assign_task(self, cred_user, id_task, id_res, type_res='serveur'):
        """assignation d'une tâche à une ressource (groupe ou serveur)"""
        return self.parent.scheduler.assign_task(cred_user, id_task, id_res, type_res)

    def xmlrpc_unassign_task(self, cred_user, id_task, id_res, type_res='serveur'):
        """dé-assignation d'une tâche à une ressource (groupe ou serveur)"""
        return self.parent.scheduler.unassign_task(cred_user, id_task, id_res, type_res)
