package App::Manoc::Form::TraitFor::Horizontal;
#ABSTRACT: Role for Manoc horizontal forms

use HTML::FormHandler::Moose::Role;

our $VERSION = '2.99.3'; ##TRIAL VERSION


sub build_form_element_class { ['form-horizontal'] }


sub build_form_tags {
    {
        'layout_classes' => {
            element_wrapper_class => ['col-sm-10'],
            label_class           => ['col-sm-2'],
        }
    };
}


no HTML::FormHandler::Moose::Role;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Form::TraitFor::Horizontal - Role for Manoc horizontal forms

=head1 VERSION

version 2.99.3

=head1 DESCRIPTION

Include this role to create a Bootstrap 3 horizontal forms, using col-sm-2 for labels.

=head1 METHDOS

=head2 build_form_element_class

Set form class to form-horizontal

=head2 build_form_tags

Set layout_classes with element_wrapper_class to 'col-sm-10' and
label_class to 'col-sm-2'

=head1 SEE ALSO

L<App::Manoc::Form::TraitFor::Theme>
L<HTML::FormHandler::Widget::Theme::Bootstrap3>

=head1 AUTHOR

Manoc Team

=head1 LICENSE

This library is free software. You can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
