# Tests for WARC library POD					# -*- CPerl -*-

use File::Find;
use Pod::Checker;
use Test::More;

my @PODS = ();
find({wanted => sub { push @PODS, $File::Find::name
			if -f $File::Find::name and m/(?:pm|pod)$/ },
      no_chdir => 1}, 'lib');

plan tests => scalar @PODS;

foreach my $pod_file (@PODS) {
  my $checker = new Pod::Checker -warnings => 2;
  $checker->parse_from_file($pod_file, '>&STDERR');
  ok($checker->name
     && $checker->num_errors == 0 && $checker->num_warnings == 0,
     'POD text in '.$pod_file.' for '.($checker->name or '???'));
}
