package Business::EDI::CodeList::ContractAndCarriageConditionCode;

use base 'Business::EDI::CodeList';
my $VERSION     = 0.01;
my $list_number = 4065;
my $usage       = 'B';

# 4065  Contract and carriage condition code                    [B]
# Desc: Code to identify the conditions of contract and
# carriage.
# Repr: an..3

my %code_hash = (
'1' => [ 'AVC conditions',
    'General conditions of transport 1983, latest revision laid down by the Stichting Vervoeradres The Hague.' ],
'2' => [ 'Special agreement for parcels transport',
    'Appliance of a non published special agreement signed between a customer and the carrier (mandatory requested by the consignor) for parcels transport.' ],
'3' => [ 'Special agreement for full loading transport',
    'Appliance of a non published special agreement signed between a customer and the carrier (mandatory requested by the consignor) for full load transport.' ],
'4' => [ 'Combined transport',
    'A transport which involves more than one mode of transportation.' ],
'5' => [ 'FIATA combined transport bill of lading',
    'Standard conditions of a combined transport bill of lading issued by FIATA.' ],
'6' => [ 'Freight forwarders national conditions',
    'The contract and carriage conditions as established by freight forwarders on a national basis.' ],
'7' => [ 'Normal tariff, parcels transport',
    'Appliance of the published legal tariff in case of parcels transport (required or not by the consignor.' ],
'8' => [ 'Normal tariff, full loading transport',
    'Appliance of the published legal tariff in case of full load transport (required or not by the consignor).' ],
'9' => [ 'Ordinary',
    'Carrier will choose the cheapest tariff in the legally published tariffs for parcels or full load transports (no tariff required by the consignor).' ],
'10' => [ 'Port to port',
    'The transport will only be port to port, no inland transport would have to be provided under the contract.' ],
'11' => [ 'CMR carnet',
    'Conditions in accordance with the convention of the contract for the international carriage of goods by road.' ],
'12' => [ 'Special tariff, parcels transport',
    'Appliance of the legally published "special" tariff in case or parcels transport (tariff requested by the consignor).' ],
'13' => [ 'Special tariff, full transport',
    'Appliance of the legally published "special tariff" in case of full load transport (tariff requested by the consignor).' ],
'14' => [ 'Through transport',
    'The transport that is contracted not only from port to port, but from one inland location to another inland location.' ],
'15' => [ 'Cancel space allocation',
    'Indication that space previously allocated on a flight is to be cancelled.' ],
'16' => [ 'Report sale of space',
    'Indication that a sale has been made against a space allocation on a specific flight.' ],
'17' => [ 'Alternative space allocation',
    'Indication that space is being requested for a specific flight and that an alternative is acceptable.' ],
'18' => [ 'No alternative space allocation',
    'Indication that space is being requested for a specific flight and that an alternative is not acceptable.' ],
'19' => [ 'Allotment sale',
    'Indication that space is being sold against a space allocation allotment on a specific flight.' ],
'20' => [ 'Confirmation of space',
    'Indication that space requested has been confirmed on a specific flight.' ],
'21' => [ 'Unable to confirm',
    'Indication that airline is unable to confirm the space allocation on a specific flight.' ],
'22' => [ 'Non-operative flight',
    'Indication that airline is unable to confirm space on a specific flight since the flight does not operate.' ],
'23' => [ 'Wait list',
    'Indication that the space allocation request has been assigned to a wait list.' ],
'24' => [ 'Prior space allocation request',
    'Indication that a space allocation on a specific flight has already been requested.' ],
'25' => [ 'Holding confirmed space allocation',
    'Indication that space is being held as confirmed on a specific flight.' ],
'26' => [ 'Holding wait list',
    'Indication that space allocation request on a specific flight has been assigned to a wait list.' ],
'27' => [ 'Door-to-door',
    'The carrier is responsible for the intermodal carriage of cargo including both the pre-carriage and the on- carriage.' ],
'28' => [ 'Door-to-pier',
    'The carrier is responsible for the intermodal carriage of cargo including the pre-carriage, but excluding the on-carriage.' ],
'29' => [ 'Pier-to-door',
    'The carrier is responsible for the intermodal carriage of cargo including the on-carriage, but excluding the pre-carriage.' ],
'30' => [ 'Pier-to-pier',
    'The carrier of intermodal cargo is only responsible for the main carriage.' ],
'31' => [ 'Space cancellation noted',
    'Indication that space previously allocated on a means of transport has been cancelled.' ],
'32' => [ 'Mini landbridge service',
    'Cargo moving from a coastal port for delivery at an inland location or cargo received at an inland location moving to a coastal port for subsequent ocean transportation.' ],
'34' => [ 'Speed level - required',
    'Maximum speed required on an itinerary or part of this itinerary to be able to assume some services.' ],
'35' => [ 'Speed level - adopted',
    'Real speed used on an itinerary or part of this itinerary (for technical reasons, some limitation can be imposed or some higher speed could be used).' ],
'36' => [ 'Normal tariff, less than full load transport',
    'Application of the published legal tariff in case of less than full load transport (required or not by the consignor).' ],
'37' => [ 'Re-expedition special tariff',
    'Indication that a special tariff must be used in the case of a re-expedition.' ],
'38' => [ 'Transport arrangement by the requester',
    'The service requester has the responsibility of making transport arrangement.' ],
'39' => [ 'Transport arrangement by the provider',
    'The service provider has the responsibility of making transport arrangement.' ],
'40' => [ 'Transport arrangement by the patient',
    'The patient has the responsibility of making transport arrangement.' ],
);
sub get_codes { return \%code_hash; }

1;
