#!/usr/bin/perl

use strict;
use warnings;
use lib 't/lib';

use Test::Deep;
use Test::Exception;
use Test::More;
use Test::NoWarnings;

use FusionInventory::Test::Inventory;
use FusionInventory::Agent::Task::Inventory::Linux::Storages::MegacliWithSmartctl;

my %pdlist_tests = (
    set6_PDlist => {
        '7' => {
            'Coerced Size' => '1.818 TB [0xe8d00000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'GS0D',
            'Device Id' => '7',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '29C (84.20 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s position' => 'DiskGroup: 2, Span: 3, Arm: 1',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'SEAGATE ST2000NM0023    GS0DZ1X2BTDA',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '1.818 TB [0xe8d088b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '1.819 TB [0xe8e088b0 Sectors]',
            'SAS Address(0)' => '0x5000c500589a2ccd',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '7',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000C500589A2CCC',
            '__arm' => '1',
            '__diskgroup' => '2',
            '__span' => '3',
        },
        '11' => {
            'Coerced Size' => '223.0 GB [0x1be00000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'DC32',
            'Device Id' => '11',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '24C (75.20 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive' => 'Not Certified',
            'Drive\'s NCQ setting' => 'N/A',
            'Drive\'s position' => 'DiskGroup: 1, Span: 0, Arm: 0',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'CVDA406302Z92403GN  INTEL SSDSC2BW240A4                     DC32',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Solid State Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '223.070 GB [0x1be244b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SATA',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '6.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '223.570 GB [0x1bf244b0 Sectors]',
            'SAS Address(0)' => '0x500056b36789abe7',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '11',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '55cd2e404b93e5e1',
            '__arm' => '0',
            '__diskgroup' => '1',
            '__span' => '0',
        },
        '3' => {
            'Coerced Size' => '1.818 TB [0xe8d00000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'GS0D',
            'Device Id' => '3',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '28C (82.40 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s position' => 'DiskGroup: 2, Span: 1, Arm: 1',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'SEAGATE ST2000NM0023    GS0DZ1X2BT51',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '1.818 TB [0xe8d088b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '1.819 TB [0xe8e088b0 Sectors]',
            'SAS Address(0)' => '0x5000c500589a2929',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '3',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000C500589A2928',
            '__arm' => '1',
            '__diskgroup' => '2',
            '__span' => '1',
        },
        '2' => {
            'Coerced Size' => '1.818 TB [0xe8d00000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'GS0D',
            'Device Id' => '2',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '30C (86.00 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s position' => 'DiskGroup: 2, Span: 1, Arm: 0',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'SEAGATE ST2000NM0023    GS0DZ1X29V1C',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '1.818 TB [0xe8d088b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '1.819 TB [0xe8e088b0 Sectors]',
            'SAS Address(0)' => '0x5000c5005899b429',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '2',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000C5005899B428',
            '__arm' => '0',
            '__diskgroup' => '2',
            '__span' => '1',
        },
        '1' => {
            'Coerced Size' => '1.818 TB [0xe8d00000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'GS0D',
            'Device Id' => '1',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '30C (86.00 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s position' => 'DiskGroup: 2, Span: 0, Arm: 1',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'SEAGATE ST2000NM0023    GS0DZ1X2BSXN',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '1.818 TB [0xe8d088b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '1.819 TB [0xe8e088b0 Sectors]',
            'SAS Address(0)' => '0x5000c500589a31d9',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '1',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000C500589A31D8',
            '__arm' => '1',
            '__diskgroup' => '2',
            '__span' => '0',
        },
        '10' => {
            'Coerced Size' => '1.818 TB [0xe8d00000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'GS0D',
            'Device Id' => '10',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '27C (80.60 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Unconfigured(good), Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'SEAGATE ST2000NM0023    GS0DZ1X2C3QQ',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '1.818 TB [0xe8d088b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '1.819 TB [0xe8e088b0 Sectors]',
            'SAS Address(0)' => '0x5000c50058999e65',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '1',
            'Shield Counter' => '0',
            'Slot Number' => '10',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000C50058999E64',
        },
        '4' => {
            'Coerced Size' => '1.818 TB [0xe8d00000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'GS0D',
            'Device Id' => '4',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '29C (84.20 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s position' => 'DiskGroup: 2, Span: 2, Arm: 0',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'SEAGATE ST2000NM0023    GS0DZ1X2BSRQ',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '1.818 TB [0xe8d088b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '1.819 TB [0xe8e088b0 Sectors]',
            'SAS Address(0)' => '0x5000c500589a3a4d',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '4',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000C500589A3A4C',
            '__arm' => '0',
            '__diskgroup' => '2',
            '__span' => '2',
        },
        '12' => {
            'Coerced Size' => '558.375 GB [0x45cc0000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'A703',
            'Device Id' => '12',
            'Device Speed' => 'Unknown',
            'Drive Temperature' => '54C (129.20 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive' => 'Not Certified',
            'Drive\'s position' => 'DiskGroup: 0, Span: 0, Arm: 0',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUC156060CSS200 A7030XH97LXP',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '12',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '558.411 GB [0x45cd2fb0 Sectors]',
            'Other Error Count' => '31',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '558.911 GB [0x45dd2fb0 Sectors]',
            'SAS Address(0)' => '0x5000cca059492da5',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '12',
            'Shield Counter' => '0',
            'Slot Number' => '12',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA059492DA7',
            '__arm' => '0',
            '__diskgroup' => '0',
            '__span' => '0',
        },
        '8' => {
            'Coerced Size' => '1.818 TB [0xe8d00000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'GS0D',
            'Device Id' => '8',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '28C (82.40 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s position' => 'DiskGroup: 2, Span: 4, Arm: 0',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'SEAGATE ST2000NM0023    GS0DZ1X2BTGA',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '1.818 TB [0xe8d088b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '1.819 TB [0xe8e088b0 Sectors]',
            'SAS Address(0)' => '0x5000c500589a23d9',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '8',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000C500589A23D8',
            '__arm' => '0',
            '__diskgroup' => '2',
            '__span' => '4',
        },
        '6' => {
            'Coerced Size' => '1.818 TB [0xe8d00000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'GS0D',
            'Device Id' => '6',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '28C (82.40 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s position' => 'DiskGroup: 2, Span: 3, Arm: 0',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'SEAGATE ST2000NM0023    GS0DZ1X2BT6W',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '1.818 TB [0xe8d088b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '1.819 TB [0xe8e088b0 Sectors]',
            'SAS Address(0)' => '0x5000c500589a23b9',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '6',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000C500589A23B8',
            '__arm' => '0',
            '__diskgroup' => '2',
            '__span' => '3',
        },
        '0' => {
            'Coerced Size' => '1.818 TB [0xe8d00000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'GS0D',
            'Device Id' => '0',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '29C (84.20 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s position' => 'DiskGroup: 2, Span: 0, Arm: 0',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'SEAGATE ST2000NM0023    GS0DZ1X2BTVZ',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '1.818 TB [0xe8d088b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '1.819 TB [0xe8e088b0 Sectors]',
            'SAS Address(0)' => '0x5000c500589a3325',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '0',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000C500589A3324',
            '__arm' => '0',
            '__diskgroup' => '2',
            '__span' => '0',
        },
        '5' => {
            'Coerced Size' => '1.818 TB [0xe8d00000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'GS0D',
            'Device Id' => '5',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '29C (84.20 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s position' => 'DiskGroup: 2, Span: 2, Arm: 1',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'SEAGATE ST2000NM0023    GS0DZ1X2BTA0',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '1.818 TB [0xe8d088b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '1.819 TB [0xe8e088b0 Sectors]',
            'SAS Address(0)' => '0x5000c500589a2521',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '5',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000C500589A2520',
            '__arm' => '1',
            '__diskgroup' => '2',
            '__span' => '2',
        },
        '13' => {
            'Coerced Size' => '558.375 GB [0x45cc0000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'DE09',
            'Device Id' => '13',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '48C (118.40 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s position' => 'DiskGroup: 0, Span: 0, Arm: 1',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'Exit Code' => '0x00',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'TOSHIBA AL13SEB600      DE09X3N0A00TFRD4',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '558.411 GB [0x45cd2fb0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '558.911 GB [0x45dd2fb0 Sectors]',
            'SAS Address(0)' => '0x500003951828912e',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '12',
            'Shield Counter' => '0',
            'Slot Number' => '13',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '500003951828912D',
            '__arm' => '1',
            '__diskgroup' => '0',
            '__span' => '0',
        },
        '9' => {
            'Coerced Size' => '1.818 TB [0xe8d00000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'GS0D',
            'Device Id' => '9',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '29C (84.20 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s position' => 'DiskGroup: 2, Span: 4, Arm: 1',
            'Enclosure Device ID' => '32',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'SEAGATE ST2000NM0023    GS0DZ1X2BTA3',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '1.818 TB [0xe8d088b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => 'Unknown',
            'Predictive Failure Count' => '0',
            'Raw Size' => '1.819 TB [0xe8e088b0 Sectors]',
            'SAS Address(0)' => '0x5000c500589a1f25',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '0',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '9',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000C500589A1F24',
            '__arm' => '1',
            '__diskgroup' => '2',
            '__span' => '4',
        }
    },
    set7_PDlist => {
        '5' => {
            'Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'NS07',
            'Device Id' => '5',
            'Device Speed' => '12.0Gb/s',
            'Drive Temperature' => '26C (78.80 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'Yes',
            'Drive\'s position' => 'DiskGroup: 5, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUH721212AL5200 NS07D5G8GVBL',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '12.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'PI with type 2',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '12.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '10.692 TB [0x558a00000 Sectors]',
            'SAS Address(0)' => '0x5000cca2940f6add',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '5',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA2940F6ADF',
            '__arm' => '0',
            '__diskgroup' => '5',
            '__span' => '0',
        },
        '10' => {
            'Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'NS07',
            'Device Id' => '10',
            'Device Speed' => '12.0Gb/s',
            'Drive Temperature' => '28C (82.40 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'Yes',
            'Drive\'s position' => 'DiskGroup: 10, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUH721212AL5200 NS07D5G8K2XL',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '12.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'PI with type 2',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '12.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '10.692 TB [0x558a00000 Sectors]',
            'SAS Address(0)' => '0x5000cca2940f8c8d',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '10',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA2940F8C8F',
            '__arm' => '0',
            '__diskgroup' => '10',
            '__span' => '0',
        },
        '3' => {
            'Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'NS07',
            'Device Id' => '3',
            'Device Speed' => '12.0Gb/s',
            'Drive Temperature' => '27C (80.60 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'Yes',
            'Drive\'s position' => 'DiskGroup: 3, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUH721212AL5200 NS07D5G8GMXL',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '12.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'PI with type 2',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '12.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '10.692 TB [0x558a00000 Sectors]',
            'SAS Address(0)' => '0x5000cca2940f67bd',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '3',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA2940F67BF',
            '__arm' => '0',
            '__diskgroup' => '3',
            '__span' => '0',
        },
        '7' => {
            'Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'NS07',
            'Device Id' => '7',
            'Device Speed' => '12.0Gb/s',
            'Drive Temperature' => '27C (80.60 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'Yes',
            'Drive\'s position' => 'DiskGroup: 7, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUH721212AL5200 NS07D5G8DYUL',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '12.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'PI with type 2',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '12.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '10.692 TB [0x558a00000 Sectors]',
            'SAS Address(0)' => '0x5000cca2940f4e81',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '7',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA2940F4E83',
            '__arm' => '0',
            '__diskgroup' => '7',
            '__span' => '0',
        },
        '9' => {
            'Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'NS07',
            'Device Id' => '9',
            'Device Speed' => '12.0Gb/s',
            'Drive Temperature' => '28C (82.40 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'Yes',
            'Drive\'s position' => 'DiskGroup: 9, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUH721212AL5200 NS07D5G8KHWL',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '12.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'PI with type 2',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '12.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '10.692 TB [0x558a00000 Sectors]',
            'SAS Address(0)' => '0x5000cca2940f92d5',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '9',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA2940F92D7',
            '__arm' => '0',
            '__diskgroup' => '9',
            '__span' => '0',
        },
        '0' => {
            'Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'NS07',
            'Device Id' => '0',
            'Device Speed' => '12.0Gb/s',
            'Drive Temperature' => '28C (82.40 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'Yes',
            'Drive\'s position' => 'DiskGroup: 0, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUH721212AL5200 NS07D5G7WG8L',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '12.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'PI with type 2',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '12.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '10.692 TB [0x558a00000 Sectors]',
            'SAS Address(0)' => '0x5000cca2940e56b9',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '0',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA2940E56BB',
            '__arm' => '0',
            '__diskgroup' => '0',
            '__span' => '0',
        },
        '2' => {
            'Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'NS07',
            'Device Id' => '2',
            'Device Speed' => '12.0Gb/s',
            'Drive Temperature' => '27C (80.60 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'Yes',
            'Drive\'s position' => 'DiskGroup: 2, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUH721212AL5200 NS07D5G8L8VL',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '12.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'PI with type 2',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '12.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '10.692 TB [0x558a00000 Sectors]',
            'SAS Address(0)' => '0x5000cca2940f9e71',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '2',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA2940F9E73',
            '__arm' => '0',
            '__diskgroup' => '2',
            '__span' => '0',
        },
        '11' => {
            'Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'NS07',
            'Device Id' => '11',
            'Device Speed' => '12.0Gb/s',
            'Drive Temperature' => '28C (82.40 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'Yes',
            'Drive\'s position' => 'DiskGroup: 11, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUH721212AL5200 NS07D5G8JV8L',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '12.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'PI with type 2',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '12.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '10.692 TB [0x558a00000 Sectors]',
            'SAS Address(0)' => '0x5000cca2940f88d9',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '11',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA2940F88DB',
            '__arm' => '0',
            '__diskgroup' => '11',
            '__span' => '0',
        },
        '12' => {
            'Coerced Size' => '446.625 GB [0x37d40000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'DL65',
            'Device Id' => '12',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '34C (93.20 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s NCQ setting' => 'Enabled',
            'Drive\'s position' => 'DiskGroup: 12, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'BTYG95130FL3480BGN  SSDSC2KG480G8R                          XCV1DL65',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Solid State Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '446.630 GB [0x37d436b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SATA',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '6.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '447.130 GB [0x37e436b0 Sectors]',
            'SAS Address(0)' => '0x500056b3ae3358cc',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '12',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '55cd2e4151c19791',
            '__arm' => '0',
            '__diskgroup' => '12',
            '__span' => '0',
        },
        '6' => {
            'Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'NS07',
            'Device Id' => '6',
            'Device Speed' => '12.0Gb/s',
            'Drive Temperature' => '27C (80.60 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'Yes',
            'Drive\'s position' => 'DiskGroup: 6, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUH721212AL5200 NS07D5G8BHWL',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '12.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'PI with type 2',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '12.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '10.692 TB [0x558a00000 Sectors]',
            'SAS Address(0)' => '0x5000cca2940f38bd',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '6',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA2940F38BF',
            '__arm' => '0',
            '__diskgroup' => '6',
            '__span' => '0',
        },
        '8' => {
            'Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'NS07',
            'Device Id' => '8',
            'Device Speed' => '12.0Gb/s',
            'Drive Temperature' => '26C (78.80 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'Yes',
            'Drive\'s position' => 'DiskGroup: 8, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUH721212AL5200 NS07D5G8JXXL',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '12.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'PI with type 2',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '12.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '10.692 TB [0x558a00000 Sectors]',
            'SAS Address(0)' => '0x5000cca2940f8a21',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '8',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA2940F8A23',
            '__arm' => '0',
            '__diskgroup' => '8',
            '__span' => '0',
        },
        '13' => {
            'Coerced Size' => '446.625 GB [0x37d40000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'DL65',
            'Device Id' => '13',
            'Device Speed' => '6.0Gb/s',
            'Drive Temperature' => '34C (93.20 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'No',
            'Drive\'s NCQ setting' => 'Enabled',
            'Drive\'s position' => 'DiskGroup: 13, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'Exit Code' => '0x00',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'BTYG95130JEY480BGN  SSDSC2KG480G8R                          XCV1DL65',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '6.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Solid State Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '446.630 GB [0x37d436b0 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SATA',
            'PI Eligibility' => 'No',
            'PI' => 'No PI',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '6.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '447.130 GB [0x37e436b0 Sectors]',
            'SAS Address(0)' => '0x500056b3ae3358cd',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '13',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '55cd2e4151c1b272',
            '__arm' => '0',
            '__diskgroup' => '13',
            '__span' => '0',
        },
        '4' => {
            'Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'NS07',
            'Device Id' => '4',
            'Device Speed' => '12.0Gb/s',
            'Drive Temperature' => '26C (78.80 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'Yes',
            'Drive\'s position' => 'DiskGroup: 4, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUH721212AL5200 NS07D5G8A2WL',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '12.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'PI with type 2',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '12.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '10.692 TB [0x558a00000 Sectors]',
            'SAS Address(0)' => '0x5000cca2940f236d',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '4',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA2940F236F',
            '__arm' => '0',
            '__diskgroup' => '4',
            '__span' => '0',
        },
        '1' => {
            'Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Connected Port Number' => '0(path0)',
            'Device Firmware Level' => 'NS07',
            'Device Id' => '1',
            'Device Speed' => '12.0Gb/s',
            'Drive Temperature' => '27C (80.60 F)',
            'Drive has flagged a S.M.A.R.T alert' => 'No',
            'Drive is formatted for PI information' => 'Yes',
            'Drive\'s position' => 'DiskGroup: 1, Span: 0, Arm: 0',
            'Enclosure Device ID' => '64',
            'Enclosure position' => '1',
            'FDE Capable' => 'Not Capable',
            'FDE Enable' => 'Disable',
            'Firmware state' => 'Online, Spun Up',
            'Foreign State' => 'None',
            'Inquiry Data' => 'HGST    HUH721212AL5200 NS07D5G89KNL',
            'Last Predictive Failure Event Seq Number' => '0',
            'Link Speed' => '12.0Gb/s',
            'Locked' => 'Unlocked',
            'Media Error Count' => '0',
            'Media Type' => 'Hard Disk Device',
            'Needs EKM Attention' => 'No',
            'Non Coerced Size' => '10.691 TB [0x558900000 Sectors]',
            'Other Error Count' => '0',
            'PD Type' => 'SAS',
            'PI Eligibility' => 'No',
            'PI' => 'PI with type 2',
            'Port status' => 'Active',
            'Port\'s Linkspeed' => '12.0Gb/s',
            'Predictive Failure Count' => '0',
            'Raw Size' => '10.692 TB [0x558a00000 Sectors]',
            'SAS Address(0)' => '0x5000cca2940f1b91',
            'SAS Address(1)' => '0x0',
            'Sector Size' => '512',
            'Secured' => 'Unsecured',
            'Sequence Number' => '2',
            'Shield Counter' => '0',
            'Slot Number' => '1',
            'Successful diagnostics completion on' => 'N/A',
            'WWN' => '5000CCA2940F1B93',
            '__arm' => '0',
            '__diskgroup' => '1',
            '__span' => '0',
        }
    }
);

my %ldinfo_tests = (
    set6_LDinfo => {
        '0' => {
            'Is VD Cached' => 'Yes',
            'Strip Size' => '64 KB',
            'State' => 'Optimal',
            'Mirror Data' => '558.375 GB',
            'Encryption Type' => 'None',
            'LD\'s IO profile supports MAX power savings with cached writes' => 'No',
            'Default Access Policy' => 'Read/Write',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Name' => 'Virtual Disk 0',
            'Bad Blocks Exist' => 'No',
            'Current Access Policy' => 'Read/Write',
            'Default Power Savings Policy' => 'Controller Defined',
            'RAID Level' => 'Primary-1, Secondary-0, RAID Level Qualifier-0',
            'Virtual Drive' => '0 (Target Id: 0)',
            'Current Power Savings Policy' => 'None',
            'Number Of Drives' => '2',
            'Span Depth' => '1',
            'Can spin up in 1 minute' => 'Yes',
            'Cache Cade Type' => 'Read Only',
            'Sector Size' => '512',
            'LD has drives that support T10 power conditions' => 'Yes',
            'Current Cache Policy' => 'WriteBack, ReadAdaptive, Direct, No Write Cache if Bad BBU',
            'Default Cache Policy' => 'WriteBack, ReadAdaptive, Direct, No Write Cache if Bad BBU',
            'Size' => '558.375 GB'
        },
        '1' => {
            'State' => 'Optimal',
            'Strip Size' => '64 KB',
            'Is VD Cached' => 'No',
            'Bad Blocks Exist' => 'No',
            'Default Power Savings Policy' => 'Controller Defined',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Current Access Policy' => 'Read/Write',
            'Name' => 'Virtual Disk 1',
            'Default Access Policy' => 'Read/Write',
            'Disk Cache Policy' => 'Enabled',
            'Encryption Type' => 'None',
            'LD\'s IO profile supports MAX power savings with cached writes' => 'No',
            'Number Of Drives' => '1',
            'Current Power Savings Policy' => 'None',
            'Virtual Drive' => '1 (Target Id: 1)',
            'Parity Size' => '0',
            'Size' => '223.0 GB',
            'Default Cache Policy' => 'WriteBack, ReadAdaptive, Direct, No Write Cache if Bad BBU',
            'Current Cache Policy' => 'WriteBack, ReadAdaptive, Direct, No Write Cache if Bad BBU',
            'LD has drives that support T10 power conditions' => 'No',
            'Sector Size' => '512',
            'Can spin up in 1 minute' => 'No',
            'Span Depth' => '1'
        },
        '2' => {
            'Span Depth' => '5',
            'Exit Code' => '0x00',
            'Sector Size' => '512',
            'Can spin up in 1 minute' => 'Yes',
            'Cache Cade Type' => 'Read Only',
            'Number Of Drives per span' => '2',
            'Current Cache Policy' => 'WriteBack, ReadAdaptive, Direct, No Write Cache if Bad BBU',
            'LD has drives that support T10 power conditions' => 'Yes',
            'Size' => '8.984 TB',
            'Default Cache Policy' => 'WriteBack, ReadAdaptive, Direct, No Write Cache if Bad BBU',
            'Current Power Savings Policy' => 'None',
            'Virtual Drive' => '2 (Target Id: 2)',
            'Encryption Type' => 'None',
            'LD\'s IO profile supports MAX power savings with cached writes' => 'No',
            'Name' => 'Virtual Disk 2',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Default Access Policy' => 'Read/Write',
            'Bad Blocks Exist' => 'No',
            'Default Power Savings Policy' => 'Controller Defined',
            'Current Access Policy' => 'Read/Write',
            'RAID Level' => 'Primary-1, Secondary-0, RAID Level Qualifier-0',
            'Is VD Cached' => 'Yes',
            'Strip Size' => '64 KB',
            'State' => 'Optimal',
            'Mirror Data' => '8.984 TB'
        }
    },
    set7_LDinfo => {
        '6' => {
            'Strip Size' => '256 KB',
            'Bad Blocks Exist' => 'No',
            'Number Of Drives' => '1',
            'Virtual Drive' => '6 (Target Id: 6)',
            'Encryption Type' => 'None',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Size' => '10.692 TB',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Name' => 'NonRAID Disk 6',
            'Span Depth' => '1',
            'Parity Size' => '0',
            'Is VD Cached' => 'No',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Sector Size' => '512',
            'Current Access Policy' => 'Read/Write',
            'Default Access Policy' => 'Read/Write',
            'State' => 'Optimal'
        },
        '4' => {
            'Disk Cache Policy' => 'Disk\'s Default',
            'Size' => '10.692 TB',
            'Virtual Drive' => '4 (Target Id: 4)',
            'Encryption Type' => 'None',
            'Strip Size' => '256 KB',
            'Bad Blocks Exist' => 'No',
            'Number Of Drives' => '1',
            'Current Access Policy' => 'Read/Write',
            'Default Access Policy' => 'Read/Write',
            'State' => 'Optimal',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Is VD Cached' => 'No',
            'Sector Size' => '512',
            'Parity Size' => '0',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Name' => 'NonRAID Disk 4',
            'Span Depth' => '1'
        },
        '9' => {
            'Parity Size' => '0',
            'Name' => 'NonRAID Disk 9',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Span Depth' => '1',
            'Current Access Policy' => 'Read/Write',
            'Default Access Policy' => 'Read/Write',
            'State' => 'Optimal',
            'Is VD Cached' => 'No',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Sector Size' => '512',
            'Strip Size' => '256 KB',
            'Bad Blocks Exist' => 'No',
            'Number Of Drives' => '1',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Size' => '10.692 TB',
            'Virtual Drive' => '9 (Target Id: 9)',
            'Encryption Type' => 'None'
        },
        '0' => {
            'Default Access Policy' => 'Read/Write',
            'Current Access Policy' => 'Read/Write',
            'State' => 'Optimal',
            'Sector Size' => '512',
            'Is VD Cached' => 'No',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Parity Size' => '0',
            'Span Depth' => '1',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Name' => 'NonRAID Disk 0',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Size' => '10.692 TB',
            'Encryption Type' => 'None',
            'Virtual Drive' => '0 (Target Id: 0)',
            'Bad Blocks Exist' => 'No',
            'Number Of Drives' => '1',
            'Strip Size' => '256 KB'
        },
        '3' => {
            'Size' => '10.692 TB',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Virtual Drive' => '3 (Target Id: 3)',
            'Encryption Type' => 'None',
            'Strip Size' => '256 KB',
            'Number Of Drives' => '1',
            'Bad Blocks Exist' => 'No',
            'State' => 'Optimal',
            'Default Access Policy' => 'Read/Write',
            'Current Access Policy' => 'Read/Write',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Is VD Cached' => 'No',
            'Sector Size' => '512',
            'Parity Size' => '0',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Name' => 'NonRAID Disk 3',
            'Span Depth' => '1'
        },
        '11' => {
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Name' => 'NonRAID Disk 11',
            'Span Depth' => '1',
            'Parity Size' => '0',
            'Is VD Cached' => 'No',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Sector Size' => '512',
            'State' => 'Optimal',
            'Current Access Policy' => 'Read/Write',
            'Default Access Policy' => 'Read/Write',
            'Strip Size' => '256 KB',
            'Number Of Drives' => '1',
            'Bad Blocks Exist' => 'No',
            'Virtual Drive' => '11 (Target Id: 11)',
            'Encryption Type' => 'None',
            'Size' => '10.692 TB',
            'Disk Cache Policy' => 'Disk\'s Default'
        },
        '8' => {
            'Strip Size' => '256 KB',
            'Bad Blocks Exist' => 'No',
            'Number Of Drives' => '1',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Size' => '10.692 TB',
            'Virtual Drive' => '8 (Target Id: 8)',
            'Encryption Type' => 'None',
            'Parity Size' => '0',
            'Name' => 'NonRAID Disk 8',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Span Depth' => '1',
            'Current Access Policy' => 'Read/Write',
            'Default Access Policy' => 'Read/Write',
            'State' => 'Optimal',
            'Is VD Cached' => 'No',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Sector Size' => '512'
        },
        '2' => {
            'State' => 'Optimal',
            'Default Access Policy' => 'Read/Write',
            'Current Access Policy' => 'Read/Write',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Is VD Cached' => 'No',
            'Sector Size' => '512',
            'Parity Size' => '0',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Name' => 'NonRAID Disk 2',
            'Span Depth' => '1',
            'Size' => '10.692 TB',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Virtual Drive' => '2 (Target Id: 2)',
            'Encryption Type' => 'None',
            'Strip Size' => '256 KB',
            'Number Of Drives' => '1',
            'Bad Blocks Exist' => 'No'
        },
        '7' => {
            'Sector Size' => '512',
            'Is VD Cached' => 'No',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'State' => 'Optimal',
            'Current Access Policy' => 'Read/Write',
            'Default Access Policy' => 'Read/Write',
            'Span Depth' => '1',
            'Name' => 'NonRAID Disk 7',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Parity Size' => '0',
            'Encryption Type' => 'None',
            'Virtual Drive' => '7 (Target Id: 7)',
            'Size' => '10.692 TB',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Number Of Drives' => '1',
            'Bad Blocks Exist' => 'No',
            'Strip Size' => '256 KB'
        },
        '5' => {
            'Parity Size' => '0',
            'Name' => 'NonRAID Disk 5',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Span Depth' => '1',
            'Default Access Policy' => 'Read/Write',
            'Current Access Policy' => 'Read/Write',
            'State' => 'Optimal',
            'Is VD Cached' => 'No',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Sector Size' => '512',
            'Strip Size' => '256 KB',
            'Bad Blocks Exist' => 'No',
            'Number Of Drives' => '1',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Size' => '10.692 TB',
            'Virtual Drive' => '5 (Target Id: 5)',
            'Encryption Type' => 'None'
        },
        '10' => {
            'Sector Size' => '512',
            'Is VD Cached' => 'No',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Default Access Policy' => 'Read/Write',
            'Current Access Policy' => 'Read/Write',
            'State' => 'Optimal',
            'Span Depth' => '1',
            'Name' => 'NonRAID Disk 10',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Parity Size' => '0',
            'Encryption Type' => 'None',
            'Virtual Drive' => '10 (Target Id: 10)',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Size' => '10.692 TB',
            'Bad Blocks Exist' => 'No',
            'Number Of Drives' => '1',
            'Strip Size' => '256 KB'
        },
        '12' => {
            'Default Access Policy' => 'Read/Write',
            'Current Access Policy' => 'Read/Write',
            'State' => 'Optimal',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Is VD Cached' => 'No',
            'Sector Size' => '512',
            'Parity Size' => '0',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Name' => 'NonRAID Disk 12',
            'Span Depth' => '1',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Size' => '447.130 GB',
            'Virtual Drive' => '12 (Target Id: 12)',
            'Encryption Type' => 'None',
            'Strip Size' => '256 KB',
            'Bad Blocks Exist' => 'No',
            'Number Of Drives' => '1'
        },
        '13' => {
            'Current Access Policy' => 'Read/Write',
            'Default Access Policy' => 'Read/Write',
            'State' => 'Optimal',
            'Sector Size' => '512',
            'Is VD Cached' => 'No',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Parity Size' => '0',
            'Span Depth' => '1',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Name' => 'NonRAID Disk 13',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Size' => '447.130 GB',
            'Exit Code' => '0x00',
            'Encryption Type' => 'None',
            'Virtual Drive' => '13 (Target Id: 13)',
            'Bad Blocks Exist' => 'No',
            'Number Of Drives' => '1',
            'Strip Size' => '256 KB'
        },
        '1' => {
            'Strip Size' => '256 KB',
            'Bad Blocks Exist' => 'No',
            'Number Of Drives' => '1',
            'Disk Cache Policy' => 'Disk\'s Default',
            'Size' => '10.692 TB',
            'Virtual Drive' => '1 (Target Id: 1)',
            'Encryption Type' => 'None',
            'Parity Size' => '0',
            'Default Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Current Cache Policy' => 'WriteThrough, ReadAheadNone, Direct, No Write Cache if Bad BBU',
            'Name' => 'NonRAID Disk 1',
            'Span Depth' => '1',
            'Current Access Policy' => 'Read/Write',
            'Default Access Policy' => 'Read/Write',
            'State' => 'Optimal',
            'RAID Level' => 'Primary-0, Secondary-0, RAID Level Qualifier-0',
            'Is VD Cached' => 'No',
            'Sector Size' => '512'
        }
    }
);

my %adppciinfo_tests = (
    'set6_AdpPciInfo' => {
        'Bus Number' => '3',
        'Device Number' => '0',
        'Exit Code' => '0x00',
        'Function Number' => '0'
    },
    set7_AdpPciInfo => {
        'Device Number' => '0',
        'Bus Number' => '3b',
        'Exit Code' => '0x00',
        'Function Number' => '0'
    }
);

plan tests =>
    (scalar keys %pdlist_tests) +
    (scalar keys %ldinfo_tests) +
    (scalar keys %adppciinfo_tests) +
    1;

foreach my $test (keys %pdlist_tests) {
    my $file = "resources/linux/megacli/$test";
    my $results = FusionInventory::Agent::Task::Inventory::Linux::Storages::MegacliWithSmartctl::_getPDlist(file => $file);
    cmp_deeply($results, $pdlist_tests{$test}, "$test: `megacli -PDlist' parsing");
}

foreach my $test (keys %ldinfo_tests) {
    my $file = "resources/linux/megacli/$test";
    my $results = FusionInventory::Agent::Task::Inventory::Linux::Storages::MegacliWithSmartctl::_getLDinfo(file => $file);
    cmp_deeply($results, $ldinfo_tests{$test}, "$test: `megacli -LDInfo -lAll' parsing");
}

foreach my $test (keys %adppciinfo_tests) {
    my $file = "resources/linux/megacli/$test";
    my $results = FusionInventory::Agent::Task::Inventory::Linux::Storages::MegacliWithSmartctl::_getAdpPciInfo(file => $file);
    cmp_deeply($results, $adppciinfo_tests{$test}, "$test: `megacli -AdpGetPciInfo' parsing");
}
