/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.background;

import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;

public abstract class BasicJavaScriptJob
implements JavaScriptJob {
    private Integer id_;
    private final int initialDelay_;
    private final Integer period_;
    private final boolean executeAsap_;
    private long targetExecutionTime_;

    public BasicJavaScriptJob() {
        this(0, null);
    }

    BasicJavaScriptJob(int initialDelay, Integer period) {
        this.initialDelay_ = initialDelay;
        this.period_ = period;
        this.setTargetExecutionTime((long)initialDelay + System.currentTimeMillis());
        this.executeAsap_ = initialDelay == 0;
    }

    @Override
    public void setId(Integer id) {
        this.id_ = id;
    }

    @Override
    public Integer getId() {
        return this.id_;
    }

    public int getInitialDelay() {
        return this.initialDelay_;
    }

    @Override
    public Integer getPeriod() {
        return this.period_;
    }

    @Override
    public boolean isPeriodic() {
        return this.period_ != null;
    }

    @Override
    public boolean isExecuteAsap() {
        return this.executeAsap_;
    }

    public String toString() {
        return "JavaScript Job " + this.id_;
    }

    @Override
    public int compareTo(JavaScriptJob other) {
        boolean xhr1 = this.executeAsap_;
        boolean xhr2 = other.isExecuteAsap();
        if (xhr1 && xhr2) {
            return this.getId() - other.getId();
        }
        if (xhr1) {
            return -1;
        }
        if (xhr2) {
            return 1;
        }
        return (int)(this.targetExecutionTime_ - other.getTargetExecutionTime());
    }

    @Override
    public long getTargetExecutionTime() {
        return this.targetExecutionTime_;
    }

    @Override
    public void setTargetExecutionTime(long targetExecutionTime) {
        this.targetExecutionTime_ = targetExecutionTime;
    }
}

