package ICANN::RST;
# ABSTRACT: a module for interacting with the Registry System Testing (RST) test specifications.
use ICANN::RST::Spec;
use common::sense;

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

ICANN::RST - a module for interacting with the Registry System Testing (RST) test specifications.

=head1 VERSION

version 0.01

=head1 DESCRIPTION

Registry System Testing (RST) ensures that a Registry Operator (RO) is able to
operate a generic Top-Level Domain in a stable and secure manner.

Every RO must demonstrate that it has established operations in accordance with
the applicable technical and operational criteria prior to (a) delegation into
the root zone of the Internet, (b) transition of the TLD between Registry
Service Providers (RSPs), and (c) introduction of certain registry services.

Version 2.0 of the RST system introduced a machine-readable representation of
the test specifications, allowing automated construction and execution of test
plans.

This module

=head1 USAGE

The example below generates a list of all the test cases that will be executed
for the C<StandardPreDelegationTest> test plan.

    use ICANN::RST;

    my $spec = ICANN::RST::Spec->new;

    my $plan = $spec->plan(q{StandardPreDelegationTest});

    foreach my $case ($plan->cases) {
        say $case->id;
    }

For more information, see L<ICANN::RST::Spec> which is the main entry point to
the test specifications.

=head1 SEE ALSO

=item * L<ICAN::RST::Base>
=item * L<ICAN::RST::Case>
=item * L<ICAN::RST::ChangeLog>
=item * L<ICAN::RST::DataProvider>
=item * L<ICAN::RST::DataProvider::Column>
=item * L<ICAN::RST::Error>
=item * L<ICAN::RST::Graph>
=item * L<ICAN::RST::Input>
=item * L<ICAN::RST::Plan>
=item * L<ICAN::RST::Resource>
=item * L<ICAN::RST::Spec>
=item * L<ICAN::RST::Suite>
=item * L<ICAN::RST::Text>

=head1 AUTHOR

Gavin Brown <gavin.brown@icann.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2025 by Internet Corporation for Assigned Names and Number (ICANN).

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
