# Generated by default/object.tt
package Paws::CloudWatch::CompositeAlarm;
  use Moose;
  has ActionsEnabled => (is => 'ro', isa => 'Bool');
  has AlarmActions => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has AlarmArn => (is => 'ro', isa => 'Str');
  has AlarmConfigurationUpdatedTimestamp => (is => 'ro', isa => 'Str');
  has AlarmDescription => (is => 'ro', isa => 'Str');
  has AlarmName => (is => 'ro', isa => 'Str');
  has AlarmRule => (is => 'ro', isa => 'Str');
  has InsufficientDataActions => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has OKActions => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has StateReason => (is => 'ro', isa => 'Str');
  has StateReasonData => (is => 'ro', isa => 'Str');
  has StateUpdatedTimestamp => (is => 'ro', isa => 'Str');
  has StateValue => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudWatch::CompositeAlarm

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudWatch::CompositeAlarm object:

  $service_obj->Method(Att1 => { ActionsEnabled => $value, ..., StateValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudWatch::CompositeAlarm object:

  $result = $service_obj->Method(...);
  $result->Att1->ActionsEnabled

=head1 DESCRIPTION

The details about a composite alarm.

=head1 ATTRIBUTES


=head2 ActionsEnabled => Bool

Indicates whether actions should be executed during any changes to the
alarm state.


=head2 AlarmActions => ArrayRef[Str|Undef]

The actions to execute when this alarm transitions to the ALARM state
from any other state. Each action is specified as an Amazon Resource
Name (ARN).


=head2 AlarmArn => Str

The Amazon Resource Name (ARN) of the alarm.


=head2 AlarmConfigurationUpdatedTimestamp => Str

The time stamp of the last update to the alarm configuration.


=head2 AlarmDescription => Str

The description of the alarm.


=head2 AlarmName => Str

The name of the alarm.


=head2 AlarmRule => Str

The rule that this alarm uses to evaluate its alarm state.


=head2 InsufficientDataActions => ArrayRef[Str|Undef]

The actions to execute when this alarm transitions to the
INSUFFICIENT_DATA state from any other state. Each action is specified
as an Amazon Resource Name (ARN).


=head2 OKActions => ArrayRef[Str|Undef]

The actions to execute when this alarm transitions to the OK state from
any other state. Each action is specified as an Amazon Resource Name
(ARN).


=head2 StateReason => Str

An explanation for the alarm state, in text format.


=head2 StateReasonData => Str

An explanation for the alarm state, in JSON format.


=head2 StateUpdatedTimestamp => Str

The time stamp of the last update to the alarm state.


=head2 StateValue => Str

The state value for the alarm.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudWatch>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

