# Print Gentoo packages providing given commands list.
# USAGE: dependencies_commands_list_gentoo $dependencies_commands
dependencies_commands_list_gentoo() {
	local dependencies_commands
	dependencies_commands="$1"

	local dependency_command
	while read -r dependency_command; do
		dependencies_command_single_gentoo "$dependency_command"
	done <<- EOL
	$(printf '%s' "$dependencies_commands")
	EOL
}

# Print Gentoo packages providing given single command.
# USAGE: dependencies_command_single_gentoo $dependency_command
dependencies_command_single_gentoo() {
	local dependency_command
	dependency_command="$1"

	local package_names
	case "$dependency_command" in
		('7za')
			package_names='
			app-arch/p7zip'
		;;
		('corsix-th')
			package_names='
			games-simulation/corsix-th'
		;;
		('dos2unix')
			package_names='
			app-text/dos2unix'
		;;
		('dosbox')
			package_names='
			games-emulation/dosbox'
		;;
		('godot3-runner')
			## TODO: Some version constraint might be required
			package_names='
			dev-games/godot'
		;;
		('firefox')
			package_names='
			|| ( www-client/firefox www-client/firefox-bin )'
		;;
		('java')
			package_names='
			virtual/jre'
		;;
		('julius')
			## Warning: The command provided on Gentoo is "julius-game", not "julius".
			package_names='
			games-strategy/julius'
		;;
		('mono')
			package_names='
			dev-lang/mono'
		;;
		('mpv')
			package_names='
			media-video/mpv'
		;;
		('openmw-iniimporter')
			package_names='
			games-engines/openmw'
		;;
		('openmw-launcher')
			package_names='
			games-engines/openmw'
		;;
		('pidwait')
			package_names='
			sys-process/procps'
		;;
		('pulseaudio')
			package_names='
			media-sound/pulseaudio'
		;;
		('python3')
			package_names='
			dev-lang/python'
		;;
		('renpy')
			package_names='
			games-engines/renpy'
		;;
		('scummvm')
			package_names='
			games-engines/scummvm[mp3,truetype,opengl,vorbis,theora]'
		;;
		('sed')
			package_names='
			sys-apps/sed'
		;;
		('setxkbmap')
			package_names='
			x11-apps/setxkbmap'
		;;
		('terminal_wrapper')
			package_names='
			x11-terms/xterm'
		;;
		('vcmilauncher')
			dependency_gentoo_overlays_add 'https://cgit.gentoo.org/proj/gamerlay.git'
			package_names='
			games-strategy/vcmi'
		;;
		('wine')
			local package package_architecture
			package=$(current_package)
			package_architecture=$(package_architecture "$package")
			case "$package_architecture" in
				('32')
					package_names='
					virtual/wine[abi_x86_32]'
				;;
				('64')
					package_names='
					virtual/wine[abi_x86_64]'
				;;
			esac
		;;
		('winetricks')
			package_names='
			app-emulation/winetricks'
		;;
		('xgamma')
			package_names='
			x11-apps/xgamma'
		;;
		('xrandr')
			package_names='
			x11-apps/xrandr'
		;;
		(*)
			dependencies_unknown_command_add "$dependency_command"
			return 0
		;;
	esac

	printf '%s\n' "$package_names"
}

