/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Font;
import java.net.URL;
import java.util.Vector;
import javax.swing.JComboBox;

public class MemoryComboBox
extends JComboBox {
    public static final int MAX_MEM_LEN = 30;
    private Vector order;

    public MemoryComboBox(Vector v) {
        super(v);
        this.setEditable(true);
        this.order = new Vector();
        for (int i = 0; i < v.size(); ++i) {
            this.order.add(v.get(i));
        }
        this.setFont(new Font(null, 0, 12));
    }

    public void addURL(Object item) {
        this.removeItem(item);
        this.insertItemAt(item, 0);
        this.setSelectedItem(item);
        if (this.getItemCount() > 30) {
            this.removeItemAt(this.getItemCount() - 1);
        }
        this.order.add(item);
    }

    public void setLastIndex(Object anObject) {
        if (this.order.contains(anObject)) {
            this.order.remove(anObject);
            this.order.trimToSize();
            this.order.add(anObject);
        }
    }

    protected boolean isBackPage() {
        int currentIndex = this.order.indexOf(this.getSelectedItem());
        return this.order.size() > 1 && currentIndex >= 1;
    }

    protected boolean isForwardPage() {
        int currentIndex = this.order.indexOf(this.getSelectedItem());
        return currentIndex < this.order.size() - 1;
    }

    public boolean isItem(Object item) {
        int nitems = this.getItemCount();
        for (int i = 0; i < nitems; ++i) {
            if (!item.equals(this.getItemAt(i))) continue;
            return true;
        }
        return false;
    }

    public int getIndexOf(Object item) {
        return this.order.indexOf(item);
    }

    public URL getURLAt(int index) {
        return (URL)this.order.get(index);
    }
}

