
(require 'ert)
(require 'eshell-up)

(ert-deftest linux-common-usage-test ()
  (skip-unless (string= system-type "gnu/linux"))
  (let ((current-path "/home/user/first/second/third/current/"))
    (should (equal "/home/user/first/" (eshell-up-find-parent-dir "st" current-path)))
    (should (equal "/home/user/first/second/" (eshell-up-find-parent-dir "s" current-path)))
    (should (equal "/home/user/first/second/third/" (eshell-up-find-parent-dir "h" current-path)))
    (should (equal "/home/user/" (eshell-up-find-parent-dir "ser" current-path)))
    (should (equal "/home/" (eshell-up-find-parent-dir "hom" current-path)))
    (should (equal nil (eshell-up-find-parent-dir "homme" current-path)))))

(ert-deftest linux-closest-parent-dir-test ()
  (skip-unless (string= system-type "gnu/linux"))
  (should (equal "/first/second/" (eshell-up-closest-parent-dir "/first/second/third" )))
  (should (equal "/first/second/" (eshell-up-closest-parent-dir "/first/second/third/" )))
  (should (equal "/home/" (eshell-up-closest-parent-dir "~" )))
  (should (equal "/" (eshell-up-closest-parent-dir "/home/" )))
  (should (equal "/" (eshell-up-closest-parent-dir "/" ))))

(ert-deftest windowsx-common-usage-test ()
  (skip-unless (string= system-type "windows-nt"))
  (let ((current-path "c:\\Program Files\\WindowsApps\\first\\current\\"))
    (should (equal "c:/Program Files/WindowsApps/first/" (eshell-up-find-parent-dir "fi" current-path)))
    (should (equal "c:/Program Files/WindowsApps/" (eshell-up-find-parent-dir "sA" current-path)))
    (should (equal "c:/Program Files/" (eshell-up-find-parent-dir " " current-path)))
    (should (equal nil (eshell-up-find-parent-dir "Programm" current-path)))))
;; Windows users use 'cd \\' to go to the dribe

(ert-deftest case-test ()
  (skip-unless (string= system-type "gnu/linux"))
  (let ((current-path "/path/paTh/pATh/PATH/current/"))
    (setq eshell-up-ignore-case t)
    (should (equal "/path/paTh/pATh/PATH/" (eshell-up-find-parent-dir "pa" current-path)))
    (setq eshell-up-ignore-case nil)
    (should (equal "/path/paTh/" (eshell-up-find-parent-dir "pa" current-path)))
    (should (equal "/path/paTh/pATh/PATH/" (eshell-up-find-parent-dir "PATH" current-path)))
    (should (equal "/path/" (eshell-up-find-parent-dir "pat" current-path)))))

(ert-deftest closest-parent-skipped-test ()
  (skip-unless (string= system-type "gnu/linux"))
  (let ((current-path "/abc/def/ghi/abc/"))
    (should (equal "/abc/" (eshell-up-find-parent-dir "a" current-path)))))
