#ifndef __GBEMOL_PLAYLIST_H_
#define __GBEMOL_PLAYLIST_H_

#include <gtk/gtkwidget.h>
#include <gtk/gtkvbox.h>
#include "gbemol-mpd.h"
#include "gbemol-locale.h"

 /*
  *  Type macros.
  */

G_BEGIN_DECLS

#define GBEMOL_TYPE_PLAYLIST         (gbemol_playlist_get_type ())
#define GBEMOL_PLAYLIST(o)           (G_TYPE_CHECK_INSTANCE_CAST ((o), GBEMOL_TYPE_PLAYLIST, GbemolPlaylist))
#define GBEMOL_PLAYLIST_CLASS(k)     (G_TYPE_CHECK_CLASS_CAST((k), GBEMOL_TYPE_PLAYLIST, GbemolPlaylistClass))
#define GBEMOL_IS_PLAYLIST(o)        (G_TYPE_CHECK_INSTANCE_TYPE ((o), GBEMOL_TYPE_PLAYLIST))
#define GBEMOL_IS_PLAYLIST_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), GBEMOL_TYPE_PLAYLIST))
#define GBEMOL_PLAYLIST_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), GBEMOL_TYPE_PLAYLIST, GbemolPlaylistClass))

#define N_COLUMNS 12

typedef struct _GbemolPlaylist GbemolPlaylist;
typedef struct _GbemolPlaylistClass GbemolPlaylistClass;
typedef struct _GbemolPlaylistPrivate GbemolPlaylistPrivate;

typedef enum 
{
	GBEMOL_PLAYLIST_MODE_COLUMNS,
	GBEMOL_PLAYLIST_MODE_LINES,
	N_PLAYLIST_MODES
} GbemolPlaylistMode;

struct _GbemolPlaylist {
	GtkVBox parent;
	gchar* playlist_modes[N_PLAYLIST_MODES];
	GbemolPlaylistPrivate *priv;
};

struct _GbemolPlaylistClass {
	GtkVBoxClass parent;
};


GType gbemol_playlist_get_type (void);
GbemolPlaylist* gbemol_playlist_new (GbemolMpd* mpd);
void gbemol_playlist_bold_song (GbemolPlaylist *pls, gint song_id);
gboolean gbemol_playlist_current_is_selected (GbemolPlaylist* pls);
void gbemol_playlist_set_mode (GbemolPlaylist* pls, GbemolPlaylistMode mode);
void gbemol_playlist_update_songs (GbemolPlaylist *pls);
void gbemol_playlist_populate_playlists (GbemolPlaylist* pls);
void gbemol_playlist_set_sensitive (GbemolPlaylist* pls, gboolean sensitive);
G_END_DECLS

#endif
