/*
 * This file is part of Ginkgo CADx
 *
 * Copyright (c) 2015-2016 Gert Wollny
 * Copyright (c) 2008-2014 MetaEmotion S.L. All rights reserved.
 *
 * Ginkgo CADx is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser Public License
 * along with Ginkgo CADx; if not, see <http://www.gnu.org/licenses/>.
 *
 */

#pragma once


/*
** Fixed Tags in ascending (gggg,eeee" order.
** Number of entries: 3250
** Tags with a repeating component (repeating tags" are listed later.
*/
#define GKDCM_CommandGroupLength                   "0000|0000"
#define GKDCM_ACR_NEMA_CommandGroupLengthToEnd     "0000|0001"
#define GKDCM_AffectedSOPClassUID                  "0000|0002"
#define GKDCM_RequestedSOPClassUID                 "0000|0003"
#define GKDCM_ACR_NEMA_CommandRecognitionCode      "0000|0010"
#define GKDCM_CommandField                         "0000|0100"
#define GKDCM_MessageID                            "0000|0110"
#define GKDCM_MessageIDBeingRespondedTo            "0000|0120"
#define GKDCM_ACR_NEMA_Initiator                   "0000|0200"
#define GKDCM_ACR_NEMA_Receiver                    "0000|0300"
#define GKDCM_ACR_NEMA_FindLocation                "0000|0400"
#define GKDCM_MoveDestination                      "0000|0600"
#define GKDCM_Priority                             "0000|0700"
#define GKDCM_DataSetType                          "0000|0800"
#define GKDCM_ACR_NEMA_NumberOfMatches             "0000|0850"
#define GKDCM_ACR_NEMA_ResponseSequenceNumber      "0000|0860"
#define GKDCM_Status                               "0000|0900"
#define GKDCM_OffendingElement                     "0000|0901"
#define GKDCM_ErrorComment                         "0000|0902"
#define GKDCM_ErrorID                              "0000|0903"
#define GKDCM_AffectedSOPInstanceUID               "0000|1000"
#define GKDCM_RequestedSOPInstanceUID              "0000|1001"
#define GKDCM_EventTypeID                          "0000|1002"
#define GKDCM_AttributeIdentifierList              "0000|1005"
#define GKDCM_ActionTypeID                         "0000|1008"
#define GKDCM_NumberOfRemainingSubOperations       "0000|1020"
#define GKDCM_NumberOfCompletedSubOperations       "0000|1021"
#define GKDCM_NumberOfFailedSubOperations          "0000|1022"
#define GKDCM_NumberOfWarningSubOperations         "0000|1023"
#define GKDCM_MoveOriginatorApplicationEntityTitle "0000|1030"
#define GKDCM_MoveOriginatorMessageID              "0000|1031"
#define GKDCM_ACR_NEMA_DialogReceiver              "0000|4000"
#define GKDCM_ACR_NEMA_TerminalType                "0000|4010"
#define GKDCM_ACR_NEMA_MessageSetID                "0000|5010"
#define GKDCM_ACR_NEMA_EndMessageSet               "0000|5020"
#define GKDCM_ACR_NEMA_DisplayFormat               "0000|5110"
#define GKDCM_ACR_NEMA_PagePositionID              "0000|5120"
#define GKDCM_ACR_NEMA_TextFormatID                "0000|5130"
#define GKDCM_ACR_NEMA_NormalReverse               "0000|5140"
#define GKDCM_ACR_NEMA_AddGrayScale                "0000|5150"
#define GKDCM_ACR_NEMA_Borders                     "0000|5160"
#define GKDCM_ACR_NEMA_Copies                      "0000|5170"
#define GKDCM_ACR_NEMA_MagnificationType           "0000|5180"
#define GKDCM_ACR_NEMA_Erase                       "0000|5190"
#define GKDCM_ACR_NEMA_Print                       "0000|51a0"
#define GKDCM_ACR_NEMA_Overlays                    "0000|51b0"
#define GKDCM_FileMetaInformationGroupLength       "0002|0000"
#define GKDCM_FileMetaInformationVersion           "0002|0001"
#define GKDCM_MediaStorageSOPClassUID              "0002|0002"
#define GKDCM_MediaStorageSOPInstanceUID           "0002|0003"
#define GKDCM_TransferSyntaxUID                    "0002|0010"
#define GKDCM_ImplementationClassUID               "0002|0012"
#define GKDCM_ImplementationVersionName            "0002|0013"
#define GKDCM_SourceApplicationEntityTitle         "0002|0016"
#define GKDCM_PrivateInformationCreatorUID         "0002|0100"
#define GKDCM_PrivateInformation                   "0002|0102"
#define GKDCM_FileSetID                            "0004|1130"
#define GKDCM_FileSetDescriptorFileID              "0004|1141"
#define GKDCM_SpecificCharacterSetOfFileSetDescriptorFile "0004|1142"
#define GKDCM_OffsetOfTheFirstDirectoryRecordOfTheRootDirectoryEntity "0004|1200"
#define GKDCM_OffsetOfTheLastDirectoryRecordOfTheRootDirectoryEntity "0004|1202"
#define GKDCM_FileSetConsistencyFlag               "0004|1212"
#define GKDCM_DirectoryRecordSequence              "0004|1220"
#define GKDCM_OffsetOfTheNextDirectoryRecord       "0004|1400"
#define GKDCM_RecordInUseFlag                      "0004|1410"
#define GKDCM_OffsetOfReferencedLowerLevelDirectoryEntity "0004|1420"
#define GKDCM_DirectoryRecordType                  "0004|1430"
#define GKDCM_PrivateRecordUID                     "0004|1432"
#define GKDCM_ReferencedFileID                     "0004|1500"
#define GKDCM_RETIRED_MRDRDirectoryRecordOffset    "0004|1504"
#define GKDCM_ReferencedSOPClassUIDInFile          "0004|1510"
#define GKDCM_ReferencedSOPInstanceUIDInFile       "0004|1511"
#define GKDCM_ReferencedTransferSyntaxUIDInFile    "0004|1512"
#define GKDCM_ReferencedRelatedGeneralSOPClassUIDInFile "0004|151a"
#define GKDCM_RETIRED_NumberOfReferences           "0004|1600"
#define GKDCM_ACR_NEMA_IdentifyingGroupLengthToEnd "0008|0001"
#define GKDCM_SpecificCharacterSet                 "0008|0005"
#define GKDCM_LanguageCodeSequence                 "0008|0006"
#define GKDCM_ImageType                            "0008|0008"
#define GKDCM_ACR_NEMA_RecognitionCode             "0008|0010"
#define GKDCM_InstanceCreationDate                 "0008|0012"
#define GKDCM_InstanceCreationTime                 "0008|0013"
#define GKDCM_InstanceCreatorUID                   "0008|0014"
#define GKDCM_SOPClassUID                          "0008|0016"
#define GKDCM_SOPInstanceUID                       "0008|0018"
#define GKDCM_RelatedGeneralSOPClassUID            "0008|001a"
#define GKDCM_OriginalSpecializedSOPClassUID       "0008|001b"
#define GKDCM_StudyDate                            "0008|0020"
#define GKDCM_SeriesDate                           "0008|0021"
#define GKDCM_AcquisitionDate                      "0008|0022"
#define GKDCM_ContentDate                          "0008|0023"
#define GKDCM_RETIRED_OverlayDate                  "0008|0024"
#define GKDCM_RETIRED_CurveDate                    "0008|0025"
#define GKDCM_AcquisitionDateTime                  "0008|002a"
#define GKDCM_StudyTime                            "0008|0030"
#define GKDCM_SeriesTime                           "0008|0031"
#define GKDCM_AcquisitionTime                      "0008|0032"
#define GKDCM_ContentTime                          "0008|0033"
#define GKDCM_RETIRED_OverlayTime                  "0008|0034"
#define GKDCM_RETIRED_CurveTime                    "0008|0035"
#define GKDCM_ACR_NEMA_OldDataSetType              "0008|0040"
#define GKDCM_ACR_NEMA_DataSetSubtype              "0008|0041"
#define GKDCM_RETIRED_NuclearMedicineSeriesType    "0008|0042"
#define GKDCM_AccessionNumber                      "0008|0050"
#define GKDCM_IssuerOfAccessionNumberSequence      "0008|0051"
#define GKDCM_QueryRetrieveLevel                   "0008|0052"
#define GKDCM_RetrieveAETitle                      "0008|0054"
#define GKDCM_InstanceAvailability                 "0008|0056"
#define GKDCM_FailedSOPInstanceUIDList             "0008|0058"
#define GKDCM_Modality                             "0008|0060"
#define GKDCM_ModalitiesInStudy                    "0008|0061"
#define GKDCM_SOPClassesInStudy                    "0008|0062"
#define GKDCM_ConversionType                       "0008|0064"
#define GKDCM_PresentationIntentType               "0008|0068"
#define GKDCM_Manufacturer                         "0008|0070"
#define GKDCM_InstitutionName                      "0008|0080"
#define GKDCM_InstitutionAddress                   "0008|0081"
#define GKDCM_InstitutionCodeSequence              "0008|0082"
#define GKDCM_ReferringPhysicianName               "0008|0090"
#define GKDCM_ReferringPhysicianAddress            "0008|0092"
#define GKDCM_ReferringPhysicianTelephoneNumbers   "0008|0094"
#define GKDCM_ReferringPhysicianIdentificationSequence "0008|0096"
#define GKDCM_CodeValue                            "0008|0100"
#define GKDCM_CodingSchemeDesignator               "0008|0102"
#define GKDCM_CodingSchemeVersion                  "0008|0103"
#define GKDCM_CodeMeaning                          "0008|0104"
#define GKDCM_MappingResource                      "0008|0105"
#define GKDCM_ContextGroupVersion                  "0008|0106"
#define GKDCM_ContextGroupLocalVersion             "0008|0107"
#define GKDCM_ContextGroupExtensionFlag            "0008|010b"
#define GKDCM_CodingSchemeUID                      "0008|010c"
#define GKDCM_ContextGroupExtensionCreatorUID      "0008|010d"
#define GKDCM_ContextIdentifier                    "0008|010f"
#define GKDCM_CodingSchemeIdentificationSequence   "0008|0110"
#define GKDCM_CodingSchemeRegistry                 "0008|0112"
#define GKDCM_CodingSchemeExternalID               "0008|0114"
#define GKDCM_CodingSchemeName                     "0008|0115"
#define GKDCM_CodingSchemeResponsibleOrganization  "0008|0116"
#define GKDCM_ContextUID                           "0008|0117"
#define GKDCM_TimezoneOffsetFromUTC                "0008|0201"
#define GKDCM_ACR_NEMA_NetworkID                   "0008|1000"
#define GKDCM_StationName                          "0008|1010"
#define GKDCM_StudyDescription                     "0008|1030"
#define GKDCM_ProcedureCodeSequence                "0008|1032"
#define GKDCM_SeriesDescription                    "0008|103e"
#define GKDCM_SeriesDescriptionCodeSequence        "0008|103f"
#define GKDCM_InstitutionalDepartmentName          "0008|1040"
#define GKDCM_PhysiciansOfRecord                   "0008|1048"
#define GKDCM_PhysiciansOfRecordIdentificationSequence "0008|1049"
#define GKDCM_PerformingPhysicianName              "0008|1050"
#define GKDCM_PerformingPhysicianIdentificationSequence "0008|1052"
#define GKDCM_NameOfPhysiciansReadingStudy         "0008|1060"
#define GKDCM_PhysiciansReadingStudyIdentificationSequence "0008|1062"
#define GKDCM_OperatorsName                        "0008|1070"
#define GKDCM_OperatorIdentificationSequence       "0008|1072"
#define GKDCM_AdmittingDiagnosesDescription        "0008|1080"
#define GKDCM_AdmittingDiagnosesCodeSequence       "0008|1084"
#define GKDCM_ManufacturerModelName                "0008|1090"
#define GKDCM_RETIRED_ReferencedResultsSequence    "0008|1100"
#define GKDCM_ReferencedStudySequence              "0008|1110"
#define GKDCM_ReferencedPerformedProcedureStepSequence "0008|1111"
#define GKDCM_ReferencedSeriesSequence             "0008|1115"
#define GKDCM_ReferencedPatientSequence            "0008|1120"
#define GKDCM_ReferencedVisitSequence              "0008|1125"
#define GKDCM_RETIRED_ReferencedOverlaySequence    "0008|1130"
#define GKDCM_ReferencedStereometricInstanceSequence "0008|1134"
#define GKDCM_ReferencedWaveformSequence           "0008|113a"
#define GKDCM_ReferencedImageSequence              "0008|1140"
#define GKDCM_RETIRED_ReferencedCurveSequence      "0008|1145"
#define GKDCM_ReferencedInstanceSequence           "0008|114a"
#define GKDCM_ReferencedRealWorldValueMappingInstanceSequence "0008|114b"
#define GKDCM_ReferencedSOPClassUID                "0008|1150"
#define GKDCM_ReferencedSOPInstanceUID             "0008|1155"
#define GKDCM_SOPClassesSupported                  "0008|115a"
#define GKDCM_ReferencedFrameNumber                "0008|1160"
#define GKDCM_SimpleFrameList                      "0008|1161"
#define GKDCM_CalculatedFrameList                  "0008|1162"
#define GKDCM_TimeRange                            "0008|1163"
#define GKDCM_FrameExtractionSequence              "0008|1164"
#define GKDCM_MultiFrameSourceSOPInstanceUID       "0008|1167"
#define GKDCM_TransactionUID                       "0008|1195"
#define GKDCM_FailureReason                        "0008|1197"
#define GKDCM_FailedSOPSequence                    "0008|1198"
#define GKDCM_ReferencedSOPSequence                "0008|1199"
#define GKDCM_StudiesContainingOtherReferencedInstancesSequence "0008|1200"
#define GKDCM_RelatedSeriesSequence                "0008|1250"
#define GKDCM_RETIRED_LossyImageCompressionRetired "0008|2110"
#define GKDCM_DerivationDescription                "0008|2111"
#define GKDCM_SourceImageSequence                  "0008|2112"
#define GKDCM_StageName                            "0008|2120"
#define GKDCM_StageNumber                          "0008|2122"
#define GKDCM_NumberOfStages                       "0008|2124"
#define GKDCM_ViewName                             "0008|2127"
#define GKDCM_ViewNumber                           "0008|2128"
#define GKDCM_NumberOfEventTimers                  "0008|2129"
#define GKDCM_NumberOfViewsInStage                 "0008|212a"
#define GKDCM_EventElapsedTimes                    "0008|2130"
#define GKDCM_EventTimerNames                      "0008|2132"
#define GKDCM_EventTimerSequence                   "0008|2133"
#define GKDCM_EventTimeOffset                      "0008|2134"
#define GKDCM_EventCodeSequence                    "0008|2135"
#define GKDCM_StartTrim                            "0008|2142"
#define GKDCM_StopTrim                             "0008|2143"
#define GKDCM_RecommendedDisplayFrameRate          "0008|2144"
#define GKDCM_RETIRED_TransducerPosition           "0008|2200"
#define GKDCM_RETIRED_TransducerOrientation        "0008|2204"
#define GKDCM_RETIRED_AnatomicStructure            "0008|2208"
#define GKDCM_AnatomicRegionSequence               "0008|2218"
#define GKDCM_AnatomicRegionModifierSequence       "0008|2220"
#define GKDCM_PrimaryAnatomicStructureSequence     "0008|2228"
#define GKDCM_AnatomicStructureSpaceOrRegionSequence "0008|2229"
#define GKDCM_PrimaryAnatomicStructureModifierSequence "0008|2230"
#define GKDCM_RETIRED_TransducerPositionSequence   "0008|2240"
#define GKDCM_RETIRED_TransducerPositionModifierSequence "0008|2242"
#define GKDCM_RETIRED_TransducerOrientationSequence "0008|2244"
#define GKDCM_RETIRED_TransducerOrientationModifierSequence "0008|2246"
#define GKDCM_RETIRED_AnatomicStructureSpaceOrRegionCodeSequenceTrial "0008|2251"
#define GKDCM_RETIRED_AnatomicPortalOfEntranceCodeSequenceTrial "0008|2253"
#define GKDCM_RETIRED_AnatomicApproachDirectionCodeSequenceTrial "0008|2255"
#define GKDCM_RETIRED_AnatomicPerspectiveDescriptionTrial "0008|2256"
#define GKDCM_RETIRED_AnatomicPerspectiveCodeSequenceTrial "0008|2257"
#define GKDCM_RETIRED_AnatomicLocationOfExaminingInstrumentDescriptionTrial "0008|2258"
#define GKDCM_RETIRED_AnatomicLocationOfExaminingInstrumentCodeSequenceTrial "0008|2259"
#define GKDCM_RETIRED_AnatomicStructureSpaceOrRegionModifierCodeSequenceTrial "0008|225a"
#define GKDCM_RETIRED_OnAxisBackgroundAnatomicStructureCodeSequenceTrial "0008|225c"
#define GKDCM_AlternateRepresentationSequence      "0008|3001"
#define GKDCM_IrradiationEventUID                  "0008|3010"
#define GKDCM_ACR_NEMA_IdentifyingComments         "0008|4000"
#define GKDCM_FrameType                            "0008|9007"
#define GKDCM_ReferencedImageEvidenceSequence      "0008|9092"
#define GKDCM_ReferencedRawDataSequence            "0008|9121"
#define GKDCM_CreatorVersionUID                    "0008|9123"
#define GKDCM_DerivationImageSequence              "0008|9124"
#define GKDCM_SourceImageEvidenceSequence          "0008|9154"
#define GKDCM_PixelPresentation                    "0008|9205"
#define GKDCM_VolumetricProperties                 "0008|9206"
#define GKDCM_VolumeBasedCalculationTechnique      "0008|9207"
#define GKDCM_ComplexImageComponent                "0008|9208"
#define GKDCM_AcquisitionContrast                  "0008|9209"
#define GKDCM_DerivationCodeSequence               "0008|9215"
#define GKDCM_ReferencedPresentationStateSequence  "0008|9237"
#define GKDCM_ReferencedOtherPlaneSequence         "0008|9410"
#define GKDCM_FrameDisplaySequence                 "0008|9458"
#define GKDCM_RecommendedDisplayFrameRateInFloat   "0008|9459"
#define GKDCM_SkipFrameRangeFlag                   "0008|9460"
#define GKDCM_PatientName                          "0010|0010"
#define GKDCM_PatientID                            "0010|0020"
#define GKDCM_IssuerOfPatientID                    "0010|0021"
#define GKDCM_TypeOfPatientID                      "0010|0022"
#define GKDCM_IssuerOfPatientIDQualifiersSequence  "0010|0024"
#define GKDCM_PatientBirthDate                     "0010|0030"
#define GKDCM_PatientBirthTime                     "0010|0032"
#define GKDCM_PatientSex                           "0010|0040"
#define GKDCM_PatientInsurancePlanCodeSequence     "0010|0050"
#define GKDCM_PatientPrimaryLanguageCodeSequence   "0010|0101"
#define GKDCM_PatientPrimaryLanguageModifierCodeSequence "0010|0102"
#define GKDCM_OtherPatientIDs                      "0010|1000"
#define GKDCM_OtherPatientNames                    "0010|1001"
#define GKDCM_OtherPatientIDsSequence              "0010|1002"
#define GKDCM_PatientBirthName                     "0010|1005"
#define GKDCM_PatientAge                           "0010|1010"
#define GKDCM_PatientSize                          "0010|1020"
#define GKDCM_PatientSizeCodeSequence              "0010|1021"
#define GKDCM_PatientWeight                        "0010|1030"
#define GKDCM_PatientAddress                       "0010|1040"
#define GKDCM_ACR_NEMA_InsurancePlanIdentification "0010|1050"
#define GKDCM_PatientMotherBirthName               "0010|1060"
#define GKDCM_MilitaryRank                         "0010|1080"
#define GKDCM_BranchOfService                      "0010|1081"
#define GKDCM_MedicalRecordLocator                 "0010|1090"
#define GKDCM_MedicalAlerts                        "0010|2000"
#define GKDCM_Allergies                            "0010|2110"
#define GKDCM_CountryOfResidence                   "0010|2150"
#define GKDCM_RegionOfResidence                    "0010|2152"
#define GKDCM_PatientTelephoneNumbers              "0010|2154"
#define GKDCM_EthnicGroup                          "0010|2160"
#define GKDCM_Occupation                           "0010|2180"
#define GKDCM_SmokingStatus                        "0010|21a0"
#define GKDCM_AdditionalPatientHistory             "0010|21b0"
#define GKDCM_PregnancyStatus                      "0010|21c0"
#define GKDCM_LastMenstrualDate                    "0010|21d0"
#define GKDCM_PatientReligiousPreference           "0010|21f0"
#define GKDCM_PatientSpeciesDescription            "0010|2201"
#define GKDCM_PatientSpeciesCodeSequence           "0010|2202"
#define GKDCM_PatientSexNeutered                   "0010|2203"
#define GKDCM_AnatomicalOrientationType            "0010|2210"
#define GKDCM_PatientBreedDescription              "0010|2292"
#define GKDCM_PatientBreedCodeSequence             "0010|2293"
#define GKDCM_BreedRegistrationSequence            "0010|2294"
#define GKDCM_BreedRegistrationNumber              "0010|2295"
#define GKDCM_BreedRegistryCodeSequence            "0010|2296"
#define GKDCM_ResponsiblePerson                    "0010|2297"
#define GKDCM_ResponsiblePersonRole                "0010|2298"
#define GKDCM_ResponsibleOrganization              "0010|2299"
#define GKDCM_PatientComments                      "0010|4000"
#define GKDCM_ExaminedBodyThickness                "0010|9431"
#define GKDCM_ClinicalTrialSponsorName             "0012|0010"
#define GKDCM_ClinicalTrialProtocolID              "0012|0020"
#define GKDCM_ClinicalTrialProtocolName            "0012|0021"
#define GKDCM_ClinicalTrialSiteID                  "0012|0030"
#define GKDCM_ClinicalTrialSiteName                "0012|0031"
#define GKDCM_ClinicalTrialSubjectID               "0012|0040"
#define GKDCM_ClinicalTrialSubjectReadingID        "0012|0042"
#define GKDCM_ClinicalTrialTimePointID             "0012|0050"
#define GKDCM_ClinicalTrialTimePointDescription    "0012|0051"
#define GKDCM_ClinicalTrialCoordinatingCenterName  "0012|0060"
#define GKDCM_PatientIdentityRemoved               "0012|0062"
#define GKDCM_DeidentificationMethod               "0012|0063"
#define GKDCM_DeidentificationMethodCodeSequence   "0012|0064"
#define GKDCM_ClinicalTrialSeriesID                "0012|0071"
#define GKDCM_ClinicalTrialSeriesDescription       "0012|0072"
#define GKDCM_ClinicalTrialProtocolEthicsCommitteeName "0012|0081"
#define GKDCM_ClinicalTrialProtocolEthicsCommitteeApprovalNumber "0012|0082"
#define GKDCM_ConsentForClinicalTrialUseSequence   "0012|0083"
#define GKDCM_DistributionType                     "0012|0084"
#define GKDCM_ConsentForDistributionFlag           "0012|0085"
#define GKDCM_ContrastBolusAgent                   "0018|0010"
#define GKDCM_ContrastBolusAgentSequence           "0018|0012"
#define GKDCM_ContrastBolusAdministrationRouteSequence "0018|0014"
#define GKDCM_BodyPartExamined                     "0018|0015"
#define GKDCM_ScanningSequence                     "0018|0020"
#define GKDCM_SequenceVariant                      "0018|0021"
#define GKDCM_ScanOptions                          "0018|0022"
#define GKDCM_MRAcquisitionType                    "0018|0023"
#define GKDCM_SequenceName                         "0018|0024"
#define GKDCM_AngioFlag                            "0018|0025"
#define GKDCM_InterventionDrugInformationSequence  "0018|0026"
#define GKDCM_InterventionDrugStopTime             "0018|0027"
#define GKDCM_InterventionDrugDose                 "0018|0028"
#define GKDCM_InterventionDrugCodeSequence         "0018|0029"
#define GKDCM_AdditionalDrugSequence               "0018|002a"
#define GKDCM_RETIRED_Radionuclide                 "0018|0030"
#define GKDCM_Radiopharmaceutical                  "0018|0031"
#define GKDCM_RETIRED_EnergyWindowCenterline       "0018|0032"
#define GKDCM_RETIRED_EnergyWindowTotalWidth       "0018|0033"
#define GKDCM_InterventionDrugName                 "0018|0034"
#define GKDCM_InterventionDrugStartTime            "0018|0035"
#define GKDCM_InterventionSequence                 "0018|0036"
#define GKDCM_RETIRED_TherapyType                  "0018|0037"
#define GKDCM_InterventionStatus                   "0018|0038"
#define GKDCM_RETIRED_TherapyDescription           "0018|0039"
#define GKDCM_InterventionDescription              "0018|003a"
#define GKDCM_CineRate                             "0018|0040"
#define GKDCM_InitialCineRunState                  "0018|0042"
#define GKDCM_SliceThickness                       "0018|0050"
#define GKDCM_KVP                                  "0018|0060"
#define GKDCM_CountsAccumulated                    "0018|0070"
#define GKDCM_AcquisitionTerminationCondition      "0018|0071"
#define GKDCM_EffectiveDuration                    "0018|0072"
#define GKDCM_AcquisitionStartCondition            "0018|0073"
#define GKDCM_AcquisitionStartConditionData        "0018|0074"
#define GKDCM_AcquisitionTerminationConditionData  "0018|0075"
#define GKDCM_RepetitionTime                       "0018|0080"
#define GKDCM_EchoTime                             "0018|0081"
#define GKDCM_InversionTime                        "0018|0082"
#define GKDCM_NumberOfAverages                     "0018|0083"
#define GKDCM_ImagingFrequency                     "0018|0084"
#define GKDCM_ImagedNucleus                        "0018|0085"
#define GKDCM_EchoNumbers                          "0018|0086"
#define GKDCM_MagneticFieldStrength                "0018|0087"
#define GKDCM_SpacingBetweenSlices                 "0018|0088"
#define GKDCM_NumberOfPhaseEncodingSteps           "0018|0089"
#define GKDCM_DataCollectionDiameter               "0018|0090"
#define GKDCM_EchoTrainLength                      "0018|0091"
#define GKDCM_PercentSampling                      "0018|0093"
#define GKDCM_PercentPhaseFieldOfView              "0018|0094"
#define GKDCM_PixelBandwidth                       "0018|0095"
#define GKDCM_DeviceSerialNumber                   "0018|1000"
#define GKDCM_DeviceUID                            "0018|1002"
#define GKDCM_DeviceID                             "0018|1003"
#define GKDCM_PlateID                              "0018|1004"
#define GKDCM_GeneratorID                          "0018|1005"
#define GKDCM_GridID                               "0018|1006"
#define GKDCM_CassetteID                           "0018|1007"
#define GKDCM_GantryID                             "0018|1008"
#define GKDCM_SecondaryCaptureDeviceID             "0018|1010"
#define GKDCM_RETIRED_HardcopyCreationDeviceID     "0018|1011"
#define GKDCM_DateOfSecondaryCapture               "0018|1012"
#define GKDCM_TimeOfSecondaryCapture               "0018|1014"
#define GKDCM_SecondaryCaptureDeviceManufacturer   "0018|1016"
#define GKDCM_RETIRED_HardcopyDeviceManufacturer   "0018|1017"
#define GKDCM_SecondaryCaptureDeviceManufacturerModelName "0018|1018"
#define GKDCM_SecondaryCaptureDeviceSoftwareVersions "0018|1019"
#define GKDCM_RETIRED_HardcopyDeviceSoftwareVersion "0018|101a"
#define GKDCM_RETIRED_HardcopyDeviceManufacturerModelName "0018|101b"
#define GKDCM_SoftwareVersions                     "0018|1020"
#define GKDCM_VideoImageFormatAcquired             "0018|1022"
#define GKDCM_DigitalImageFormatAcquired           "0018|1023"
#define GKDCM_ProtocolName                         "0018|1030"
#define GKDCM_ContrastBolusRoute                   "0018|1040"
#define GKDCM_ContrastBolusVolume                  "0018|1041"
#define GKDCM_ContrastBolusStartTime               "0018|1042"
#define GKDCM_ContrastBolusStopTime                "0018|1043"
#define GKDCM_ContrastBolusTotalDose               "0018|1044"
#define GKDCM_SyringeCounts                        "0018|1045"
#define GKDCM_ContrastFlowRate                     "0018|1046"
#define GKDCM_ContrastFlowDuration                 "0018|1047"
#define GKDCM_ContrastBolusIngredient              "0018|1048"
#define GKDCM_ContrastBolusIngredientConcentration "0018|1049"
#define GKDCM_SpatialResolution                    "0018|1050"
#define GKDCM_TriggerTime                          "0018|1060"
#define GKDCM_TriggerSourceOrType                  "0018|1061"
#define GKDCM_NominalInterval                      "0018|1062"
#define GKDCM_FrameTime                            "0018|1063"
#define GKDCM_CardiacFramingType                   "0018|1064"
#define GKDCM_FrameTimeVector                      "0018|1065"
#define GKDCM_FrameDelay                           "0018|1066"
#define GKDCM_ImageTriggerDelay                    "0018|1067"
#define GKDCM_MultiplexGroupTimeOffset             "0018|1068"
#define GKDCM_TriggerTimeOffset                    "0018|1069"
#define GKDCM_SynchronizationTrigger               "0018|106a"
#define GKDCM_SynchronizationChannel               "0018|106c"
#define GKDCM_TriggerSamplePosition                "0018|106e"
#define GKDCM_RadiopharmaceuticalRoute             "0018|1070"
#define GKDCM_RadiopharmaceuticalVolume            "0018|1071"
#define GKDCM_RadiopharmaceuticalStartTime         "0018|1072"
#define GKDCM_RadiopharmaceuticalStopTime          "0018|1073"
#define GKDCM_RadionuclideTotalDose                "0018|1074"
#define GKDCM_RadionuclideHalfLife                 "0018|1075"
#define GKDCM_RadionuclidePositronFraction         "0018|1076"
#define GKDCM_RadiopharmaceuticalSpecificActivity  "0018|1077"
#define GKDCM_RadiopharmaceuticalStartDateTime     "0018|1078"
#define GKDCM_RadiopharmaceuticalStopDateTime      "0018|1079"
#define GKDCM_BeatRejectionFlag                    "0018|1080"
#define GKDCM_LowRRValue                           "0018|1081"
#define GKDCM_HighRRValue                          "0018|1082"
#define GKDCM_IntervalsAcquired                    "0018|1083"
#define GKDCM_IntervalsRejected                    "0018|1084"
#define GKDCM_PVCRejection                         "0018|1085"
#define GKDCM_SkipBeats                            "0018|1086"
#define GKDCM_HeartRate                            "0018|1088"
#define GKDCM_CardiacNumberOfImages                "0018|1090"
#define GKDCM_TriggerWindow                        "0018|1094"
#define GKDCM_ReconstructionDiameter               "0018|1100"
#define GKDCM_DistanceSourceToDetector             "0018|1110"
#define GKDCM_DistanceSourceToPatient              "0018|1111"
#define GKDCM_EstimatedRadiographicMagnificationFactor "0018|1114"
#define GKDCM_GantryDetectorTilt                   "0018|1120"
#define GKDCM_GantryDetectorSlew                   "0018|1121"
#define GKDCM_TableHeight                          "0018|1130"
#define GKDCM_TableTraverse                        "0018|1131"
#define GKDCM_TableMotion                          "0018|1134"
#define GKDCM_TableVerticalIncrement               "0018|1135"
#define GKDCM_TableLateralIncrement                "0018|1136"
#define GKDCM_TableLongitudinalIncrement           "0018|1137"
#define GKDCM_TableAngle                           "0018|1138"
#define GKDCM_TableType                            "0018|113a"
#define GKDCM_RotationDirection                    "0018|1140"
#define GKDCM_RETIRED_AngularPosition              "0018|1141"
#define GKDCM_RadialPosition                       "0018|1142"
#define GKDCM_ScanArc                              "0018|1143"
#define GKDCM_AngularStep                          "0018|1144"
#define GKDCM_CenterOfRotationOffset               "0018|1145"
#define GKDCM_RETIRED_RotationOffset               "0018|1146"
#define GKDCM_FieldOfViewShape                     "0018|1147"
#define GKDCM_FieldOfViewDimensions                "0018|1149"
#define GKDCM_ExposureTime                         "0018|1150"
#define GKDCM_XRayTubeCurrent                      "0018|1151"
#define GKDCM_Exposure                             "0018|1152"
#define GKDCM_ExposureInuAs                        "0018|1153"
#define GKDCM_AveragePulseWidth                    "0018|1154"
#define GKDCM_RadiationSetting                     "0018|1155"
#define GKDCM_RectificationType                    "0018|1156"
#define GKDCM_RadiationMode                        "0018|115a"
#define GKDCM_ImageAndFluoroscopyAreaDoseProduct   "0018|115e"
#define GKDCM_FilterType                           "0018|1160"
#define GKDCM_TypeOfFilters                        "0018|1161"
#define GKDCM_IntensifierSize                      "0018|1162"
#define GKDCM_ImagerPixelSpacing                   "0018|1164"
#define GKDCM_Grid                                 "0018|1166"
#define GKDCM_GeneratorPower                       "0018|1170"
#define GKDCM_CollimatorGridName                   "0018|1180"
#define GKDCM_CollimatorType                       "0018|1181"
#define GKDCM_FocalDistance                        "0018|1182"
#define GKDCM_XFocusCenter                         "0018|1183"
#define GKDCM_YFocusCenter                         "0018|1184"
#define GKDCM_FocalSpots                           "0018|1190"
#define GKDCM_AnodeTargetMaterial                  "0018|1191"
#define GKDCM_BodyPartThickness                    "0018|11a0"
#define GKDCM_CompressionForce                     "0018|11a2"
#define GKDCM_DateOfLastCalibration                "0018|1200"
#define GKDCM_TimeOfLastCalibration                "0018|1201"
#define GKDCM_ConvolutionKernel                    "0018|1210"
#define GKDCM_ACR_NEMA_UpperLowerPixelValues       "0018|1240"
#define GKDCM_ActualFrameDuration                  "0018|1242"
#define GKDCM_CountRate                            "0018|1243"
#define GKDCM_PreferredPlaybackSequencing          "0018|1244"
#define GKDCM_ReceiveCoilName                      "0018|1250"
#define GKDCM_TransmitCoilName                     "0018|1251"
#define GKDCM_PlateType                            "0018|1260"
#define GKDCM_PhosphorType                         "0018|1261"
#define GKDCM_ScanVelocity                         "0018|1300"
#define GKDCM_WholeBodyTechnique                   "0018|1301"
#define GKDCM_ScanLength                           "0018|1302"
#define GKDCM_AcquisitionMatrix                    "0018|1310"
#define GKDCM_InPlanePhaseEncodingDirection        "0018|1312"
#define GKDCM_FlipAngle                            "0018|1314"
#define GKDCM_VariableFlipAngleFlag                "0018|1315"
#define GKDCM_SAR                                  "0018|1316"
#define GKDCM_dBdt                                 "0018|1318"
#define GKDCM_AcquisitionDeviceProcessingDescription "0018|1400"
#define GKDCM_AcquisitionDeviceProcessingCode      "0018|1401"
#define GKDCM_CassetteOrientation                  "0018|1402"
#define GKDCM_CassetteSize                         "0018|1403"
#define GKDCM_ExposuresOnPlate                     "0018|1404"
#define GKDCM_RelativeXRayExposure                 "0018|1405"
#define GKDCM_ExposureIndex                        "0018|1411"
#define GKDCM_TargetExposureIndex                  "0018|1412"
#define GKDCM_DeviationIndex                       "0018|1413"
#define GKDCM_ColumnAngulation                     "0018|1450"
#define GKDCM_TomoLayerHeight                      "0018|1460"
#define GKDCM_TomoAngle                            "0018|1470"
#define GKDCM_TomoTime                             "0018|1480"
#define GKDCM_TomoType                             "0018|1490"
#define GKDCM_TomoClass                            "0018|1491"
#define GKDCM_NumberOfTomosynthesisSourceImages    "0018|1495"
#define GKDCM_PositionerMotion                     "0018|1500"
#define GKDCM_PositionerType                       "0018|1508"
#define GKDCM_PositionerPrimaryAngle               "0018|1510"
#define GKDCM_PositionerSecondaryAngle             "0018|1511"
#define GKDCM_PositionerPrimaryAngleIncrement      "0018|1520"
#define GKDCM_PositionerSecondaryAngleIncrement    "0018|1521"
#define GKDCM_DetectorPrimaryAngle                 "0018|1530"
#define GKDCM_DetectorSecondaryAngle               "0018|1531"
#define GKDCM_ShutterShape                         "0018|1600"
#define GKDCM_ShutterLeftVerticalEdge              "0018|1602"
#define GKDCM_ShutterRightVerticalEdge             "0018|1604"
#define GKDCM_ShutterUpperHorizontalEdge           "0018|1606"
#define GKDCM_ShutterLowerHorizontalEdge           "0018|1608"
#define GKDCM_CenterOfCircularShutter              "0018|1610"
#define GKDCM_RadiusOfCircularShutter              "0018|1612"
#define GKDCM_VerticesOfThePolygonalShutter        "0018|1620"
#define GKDCM_ShutterPresentationValue             "0018|1622"
#define GKDCM_ShutterOverlayGroup                  "0018|1623"
#define GKDCM_ShutterPresentationColorCIELabValue  "0018|1624"
#define GKDCM_CollimatorShape                      "0018|1700"
#define GKDCM_CollimatorLeftVerticalEdge           "0018|1702"
#define GKDCM_CollimatorRightVerticalEdge          "0018|1704"
#define GKDCM_CollimatorUpperHorizontalEdge        "0018|1706"
#define GKDCM_CollimatorLowerHorizontalEdge        "0018|1708"
#define GKDCM_CenterOfCircularCollimator           "0018|1710"
#define GKDCM_RadiusOfCircularCollimator           "0018|1712"
#define GKDCM_VerticesOfThePolygonalCollimator     "0018|1720"
#define GKDCM_AcquisitionTimeSynchronized          "0018|1800"
#define GKDCM_TimeSource                           "0018|1801"
#define GKDCM_TimeDistributionProtocol             "0018|1802"
#define GKDCM_NTPSourceAddress                     "0018|1803"
#define GKDCM_PageNumberVector                     "0018|2001"
#define GKDCM_FrameLabelVector                     "0018|2002"
#define GKDCM_FramePrimaryAngleVector              "0018|2003"
#define GKDCM_FrameSecondaryAngleVector            "0018|2004"
#define GKDCM_SliceLocationVector                  "0018|2005"
#define GKDCM_DisplayWindowLabelVector             "0018|2006"
#define GKDCM_NominalScannedPixelSpacing           "0018|2010"
#define GKDCM_DigitizingDeviceTransportDirection   "0018|2020"
#define GKDCM_RotationOfScannedFilm                "0018|2030"
#define GKDCM_IVUSAcquisition                      "0018|3100"
#define GKDCM_IVUSPullbackRate                     "0018|3101"
#define GKDCM_IVUSGatedRate                        "0018|3102"
#define GKDCM_IVUSPullbackStartFrameNumber         "0018|3103"
#define GKDCM_IVUSPullbackStopFrameNumber          "0018|3104"
#define GKDCM_LesionNumber                         "0018|3105"
#define GKDCM_ACR_NEMA_AcquisitionComments         "0018|4000"
#define GKDCM_OutputPower                          "0018|5000"
#define GKDCM_TransducerData                       "0018|5010"
#define GKDCM_FocusDepth                           "0018|5012"
#define GKDCM_ProcessingFunction                   "0018|5020"
#define GKDCM_RETIRED_PostprocessingFunction       "0018|5021"
#define GKDCM_MechanicalIndex                      "0018|5022"
#define GKDCM_BoneThermalIndex                     "0018|5024"
#define GKDCM_CranialThermalIndex                  "0018|5026"
#define GKDCM_SoftTissueThermalIndex               "0018|5027"
#define GKDCM_SoftTissueFocusThermalIndex          "0018|5028"
#define GKDCM_SoftTissueSurfaceThermalIndex        "0018|5029"
#define GKDCM_ACR_NEMA_DynamicRange                "0018|5030"
#define GKDCM_ACR_NEMA_TotalGain                   "0018|5040"
#define GKDCM_DepthOfScanField                     "0018|5050"
#define GKDCM_PatientPosition                      "0018|5100"
#define GKDCM_ViewPosition                         "0018|5101"
#define GKDCM_ProjectionEponymousNameCodeSequence  "0018|5104"
#define GKDCM_RETIRED_ImageTransformationMatrix    "0018|5210"
#define GKDCM_RETIRED_ImageTranslationVector       "0018|5212"
#define GKDCM_Sensitivity                          "0018|6000"
#define GKDCM_SequenceOfUltrasoundRegions          "0018|6011"
#define GKDCM_RegionSpatialFormat                  "0018|6012"
#define GKDCM_RegionDataType                       "0018|6014"
#define GKDCM_RegionFlags                          "0018|6016"
#define GKDCM_RegionLocationMinX0                  "0018|6018"
#define GKDCM_RegionLocationMinY0                  "0018|601a"
#define GKDCM_RegionLocationMaxX1                  "0018|601c"
#define GKDCM_RegionLocationMaxY1                  "0018|601e"
#define GKDCM_ReferencePixelX0                     "0018|6020"
#define GKDCM_ReferencePixelY0                     "0018|6022"
#define GKDCM_PhysicalUnitsXDirection              "0018|6024"
#define GKDCM_PhysicalUnitsYDirection              "0018|6026"
#define GKDCM_ReferencePixelPhysicalValueX         "0018|6028"
#define GKDCM_ReferencePixelPhysicalValueY         "0018|602a"
#define GKDCM_PhysicalDeltaX                       "0018|602c"
#define GKDCM_PhysicalDeltaY                       "0018|602e"
#define GKDCM_TransducerFrequency                  "0018|6030"
#define GKDCM_TransducerType                       "0018|6031"
#define GKDCM_PulseRepetitionFrequency             "0018|6032"
#define GKDCM_DopplerCorrectionAngle               "0018|6034"
#define GKDCM_SteeringAngle                        "0018|6036"
#define GKDCM_RETIRED_DopplerSampleVolumeXPositionRetired "0018|6038"
#define GKDCM_DopplerSampleVolumeXPosition         "0018|6039"
#define GKDCM_RETIRED_DopplerSampleVolumeYPositionRetired "0018|603a"
#define GKDCM_DopplerSampleVolumeYPosition         "0018|603b"
#define GKDCM_RETIRED_TMLinePositionX0Retired      "0018|603c"
#define GKDCM_TMLinePositionX0                     "0018|603d"
#define GKDCM_RETIRED_TMLinePositionY0Retired      "0018|603e"
#define GKDCM_TMLinePositionY0                     "0018|603f"
#define GKDCM_RETIRED_TMLinePositionX1Retired      "0018|6040"
#define GKDCM_TMLinePositionX1                     "0018|6041"
#define GKDCM_RETIRED_TMLinePositionY1Retired      "0018|6042"
#define GKDCM_TMLinePositionY1                     "0018|6043"
#define GKDCM_PixelComponentOrganization           "0018|6044"
#define GKDCM_PixelComponentMask                   "0018|6046"
#define GKDCM_PixelComponentRangeStart             "0018|6048"
#define GKDCM_PixelComponentRangeStop              "0018|604a"
#define GKDCM_PixelComponentPhysicalUnits          "0018|604c"
#define GKDCM_PixelComponentDataType               "0018|604e"
#define GKDCM_NumberOfTableBreakPoints             "0018|6050"
#define GKDCM_TableOfXBreakPoints                  "0018|6052"
#define GKDCM_TableOfYBreakPoints                  "0018|6054"
#define GKDCM_NumberOfTableEntries                 "0018|6056"
#define GKDCM_TableOfPixelValues                   "0018|6058"
#define GKDCM_TableOfParameterValues               "0018|605a"
#define GKDCM_RWaveTimeVector                      "0018|6060"
#define GKDCM_DetectorConditionsNominalFlag        "0018|7000"
#define GKDCM_DetectorTemperature                  "0018|7001"
#define GKDCM_DetectorType                         "0018|7004"
#define GKDCM_DetectorConfiguration                "0018|7005"
#define GKDCM_DetectorDescription                  "0018|7006"
#define GKDCM_DetectorMode                         "0018|7008"
#define GKDCM_DetectorID                           "0018|700a"
#define GKDCM_DateOfLastDetectorCalibration        "0018|700c"
#define GKDCM_TimeOfLastDetectorCalibration        "0018|700e"
#define GKDCM_ExposuresOnDetectorSinceLastCalibration "0018|7010"
#define GKDCM_ExposuresOnDetectorSinceManufactured "0018|7011"
#define GKDCM_DetectorTimeSinceLastExposure        "0018|7012"
#define GKDCM_DetectorActiveTime                   "0018|7014"
#define GKDCM_DetectorActivationOffsetFromExposure "0018|7016"
#define GKDCM_DetectorBinning                      "0018|701a"
#define GKDCM_DetectorElementPhysicalSize          "0018|7020"
#define GKDCM_DetectorElementSpacing               "0018|7022"
#define GKDCM_DetectorActiveShape                  "0018|7024"
#define GKDCM_DetectorActiveDimensions             "0018|7026"
#define GKDCM_DetectorActiveOrigin                 "0018|7028"
#define GKDCM_DetectorManufacturerName             "0018|702a"
#define GKDCM_DetectorManufacturerModelName        "0018|702b"
#define GKDCM_FieldOfViewOrigin                    "0018|7030"
#define GKDCM_FieldOfViewRotation                  "0018|7032"
#define GKDCM_FieldOfViewHorizontalFlip            "0018|7034"
#define GKDCM_GridAbsorbingMaterial                "0018|7040"
#define GKDCM_GridSpacingMaterial                  "0018|7041"
#define GKDCM_GridThickness                        "0018|7042"
#define GKDCM_GridPitch                            "0018|7044"
#define GKDCM_GridAspectRatio                      "0018|7046"
#define GKDCM_GridPeriod                           "0018|7048"
#define GKDCM_GridFocalDistance                    "0018|704c"
#define GKDCM_FilterMaterial                       "0018|7050"
#define GKDCM_FilterThicknessMinimum               "0018|7052"
#define GKDCM_FilterThicknessMaximum               "0018|7054"
#define GKDCM_FilterBeamPathLengthMinimum          "0018|7056"
#define GKDCM_FilterBeamPathLengthMaximum          "0018|7058"
#define GKDCM_ExposureControlMode                  "0018|7060"
#define GKDCM_ExposureControlModeDescription       "0018|7062"
#define GKDCM_ExposureStatus                       "0018|7064"
#define GKDCM_PhototimerSetting                    "0018|7065"
#define GKDCM_ExposureTimeInuS                     "0018|8150"
#define GKDCM_XRayTubeCurrentInuA                  "0018|8151"
#define GKDCM_ContentQualification                 "0018|9004"
#define GKDCM_PulseSequenceName                    "0018|9005"
#define GKDCM_MRImagingModifierSequence            "0018|9006"
#define GKDCM_EchoPulseSequence                    "0018|9008"
#define GKDCM_InversionRecovery                    "0018|9009"
#define GKDCM_FlowCompensation                     "0018|9010"
#define GKDCM_MultipleSpinEcho                     "0018|9011"
#define GKDCM_MultiPlanarExcitation                "0018|9012"
#define GKDCM_PhaseContrast                        "0018|9014"
#define GKDCM_TimeOfFlightContrast                 "0018|9015"
#define GKDCM_Spoiling                             "0018|9016"
#define GKDCM_SteadyStatePulseSequence             "0018|9017"
#define GKDCM_EchoPlanarPulseSequence              "0018|9018"
#define GKDCM_TagAngleFirstAxis                    "0018|9019"
#define GKDCM_MagnetizationTransfer                "0018|9020"
#define GKDCM_T2Preparation                        "0018|9021"
#define GKDCM_BloodSignalNulling                   "0018|9022"
#define GKDCM_SaturationRecovery                   "0018|9024"
#define GKDCM_SpectrallySelectedSuppression        "0018|9025"
#define GKDCM_SpectrallySelectedExcitation         "0018|9026"
#define GKDCM_SpatialPresaturation                 "0018|9027"
#define GKDCM_Tagging                              "0018|9028"
#define GKDCM_OversamplingPhase                    "0018|9029"
#define GKDCM_TagSpacingFirstDimension             "0018|9030"
#define GKDCM_GeometryOfKSpaceTraversal            "0018|9032"
#define GKDCM_SegmentedKSpaceTraversal             "0018|9033"
#define GKDCM_RectilinearPhaseEncodeReordering     "0018|9034"
#define GKDCM_TagThickness                         "0018|9035"
#define GKDCM_PartialFourierDirection              "0018|9036"
#define GKDCM_CardiacSynchronizationTechnique      "0018|9037"
#define GKDCM_ReceiveCoilManufacturerName          "0018|9041"
#define GKDCM_MRReceiveCoilSequence                "0018|9042"
#define GKDCM_ReceiveCoilType                      "0018|9043"
#define GKDCM_QuadratureReceiveCoil                "0018|9044"
#define GKDCM_MultiCoilDefinitionSequence          "0018|9045"
#define GKDCM_MultiCoilConfiguration               "0018|9046"
#define GKDCM_MultiCoilElementName                 "0018|9047"
#define GKDCM_MultiCoilElementUsed                 "0018|9048"
#define GKDCM_MRTransmitCoilSequence               "0018|9049"
#define GKDCM_TransmitCoilManufacturerName         "0018|9050"
#define GKDCM_TransmitCoilType                     "0018|9051"
#define GKDCM_SpectralWidth                        "0018|9052"
#define GKDCM_ChemicalShiftReference               "0018|9053"
#define GKDCM_VolumeLocalizationTechnique          "0018|9054"
#define GKDCM_MRAcquisitionFrequencyEncodingSteps  "0018|9058"
#define GKDCM_Decoupling                           "0018|9059"
#define GKDCM_DecoupledNucleus                     "0018|9060"
#define GKDCM_DecouplingFrequency                  "0018|9061"
#define GKDCM_DecouplingMethod                     "0018|9062"
#define GKDCM_DecouplingChemicalShiftReference     "0018|9063"
#define GKDCM_KSpaceFiltering                      "0018|9064"
#define GKDCM_TimeDomainFiltering                  "0018|9065"
#define GKDCM_NumberOfZeroFills                    "0018|9066"
#define GKDCM_BaselineCorrection                   "0018|9067"
#define GKDCM_ParallelReductionFactorInPlane       "0018|9069"
#define GKDCM_CardiacRRIntervalSpecified           "0018|9070"
#define GKDCM_AcquisitionDuration                  "0018|9073"
#define GKDCM_FrameAcquisitionDateTime             "0018|9074"
#define GKDCM_DiffusionDirectionality              "0018|9075"
#define GKDCM_DiffusionGradientDirectionSequence   "0018|9076"
#define GKDCM_ParallelAcquisition                  "0018|9077"
#define GKDCM_ParallelAcquisitionTechnique         "0018|9078"
#define GKDCM_InversionTimes                       "0018|9079"
#define GKDCM_MetaboliteMapDescription             "0018|9080"
#define GKDCM_PartialFourier                       "0018|9081"
#define GKDCM_EffectiveEchoTime                    "0018|9082"
#define GKDCM_MetaboliteMapCodeSequence            "0018|9083"
#define GKDCM_ChemicalShiftSequence                "0018|9084"
#define GKDCM_CardiacSignalSource                  "0018|9085"
#define GKDCM_DiffusionBValue                      "0018|9087"
#define GKDCM_DiffusionGradientOrientation         "0018|9089"
#define GKDCM_VelocityEncodingDirection            "0018|9090"
#define GKDCM_VelocityEncodingMinimumValue         "0018|9091"
#define GKDCM_VelocityEncodingAcquisitionSequence  "0018|9092"
#define GKDCM_NumberOfKSpaceTrajectories           "0018|9093"
#define GKDCM_CoverageOfKSpace                     "0018|9094"
#define GKDCM_SpectroscopyAcquisitionPhaseRows     "0018|9095"
#define GKDCM_RETIRED_ParallelReductionFactorInPlaneRetired "0018|9096"
#define GKDCM_TransmitterFrequency                 "0018|9098"
#define GKDCM_ResonantNucleus                      "0018|9100"
#define GKDCM_FrequencyCorrection                  "0018|9101"
#define GKDCM_MRSpectroscopyFOVGeometrySequence    "0018|9103"
#define GKDCM_SlabThickness                        "0018|9104"
#define GKDCM_SlabOrientation                      "0018|9105"
#define GKDCM_MidSlabPosition                      "0018|9106"
#define GKDCM_MRSpatialSaturationSequence          "0018|9107"
#define GKDCM_MRTimingAndRelatedParametersSequence "0018|9112"
#define GKDCM_MREchoSequence                       "0018|9114"
#define GKDCM_MRModifierSequence                   "0018|9115"
#define GKDCM_MRDiffusionSequence                  "0018|9117"
#define GKDCM_CardiacSynchronizationSequence       "0018|9118"
#define GKDCM_MRAveragesSequence                   "0018|9119"
#define GKDCM_MRFOVGeometrySequence                "0018|9125"
#define GKDCM_VolumeLocalizationSequence           "0018|9126"
#define GKDCM_SpectroscopyAcquisitionDataColumns   "0018|9127"
#define GKDCM_DiffusionAnisotropyType              "0018|9147"
#define GKDCM_FrameReferenceDateTime               "0018|9151"
#define GKDCM_MRMetaboliteMapSequence              "0018|9152"
#define GKDCM_ParallelReductionFactorOutOfPlane    "0018|9155"
#define GKDCM_SpectroscopyAcquisitionOutOfPlanePhaseSteps "0018|9159"
#define GKDCM_RETIRED_BulkMotionStatus             "0018|9166"
#define GKDCM_ParallelReductionFactorSecondInPlane "0018|9168"
#define GKDCM_CardiacBeatRejectionTechnique        "0018|9169"
#define GKDCM_RespiratoryMotionCompensationTechnique "0018|9170"
#define GKDCM_RespiratorySignalSource              "0018|9171"
#define GKDCM_BulkMotionCompensationTechnique      "0018|9172"
#define GKDCM_BulkMotionSignalSource               "0018|9173"
#define GKDCM_ApplicableSafetyStandardAgency       "0018|9174"
#define GKDCM_ApplicableSafetyStandardDescription  "0018|9175"
#define GKDCM_OperatingModeSequence                "0018|9176"
#define GKDCM_OperatingModeType                    "0018|9177"
#define GKDCM_OperatingMode                        "0018|9178"
#define GKDCM_SpecificAbsorptionRateDefinition     "0018|9179"
#define GKDCM_GradientOutputType                   "0018|9180"
#define GKDCM_SpecificAbsorptionRateValue          "0018|9181"
#define GKDCM_GradientOutput                       "0018|9182"
#define GKDCM_FlowCompensationDirection            "0018|9183"
#define GKDCM_TaggingDelay                         "0018|9184"
#define GKDCM_RespiratoryMotionCompensationTechniqueDescription "0018|9185"
#define GKDCM_RespiratorySignalSourceID            "0018|9186"
#define GKDCM_RETIRED_ChemicalShiftMinimumIntegrationLimitInHz "0018|9195"
#define GKDCM_RETIRED_ChemicalShiftMaximumIntegrationLimitInHz "0018|9196"
#define GKDCM_MRVelocityEncodingSequence           "0018|9197"
#define GKDCM_FirstOrderPhaseCorrection            "0018|9198"
#define GKDCM_WaterReferencedPhaseCorrection       "0018|9199"
#define GKDCM_MRSpectroscopyAcquisitionType        "0018|9200"
#define GKDCM_RespiratoryCyclePosition             "0018|9214"
#define GKDCM_VelocityEncodingMaximumValue         "0018|9217"
#define GKDCM_TagSpacingSecondDimension            "0018|9218"
#define GKDCM_TagAngleSecondAxis                   "0018|9219"
#define GKDCM_FrameAcquisitionDuration             "0018|9220"
#define GKDCM_MRImageFrameTypeSequence             "0018|9226"
#define GKDCM_MRSpectroscopyFrameTypeSequence      "0018|9227"
#define GKDCM_MRAcquisitionPhaseEncodingStepsInPlane "0018|9231"
#define GKDCM_MRAcquisitionPhaseEncodingStepsOutOfPlane "0018|9232"
#define GKDCM_SpectroscopyAcquisitionPhaseColumns  "0018|9234"
#define GKDCM_CardiacCyclePosition                 "0018|9236"
#define GKDCM_SpecificAbsorptionRateSequence       "0018|9239"
#define GKDCM_RFEchoTrainLength                    "0018|9240"
#define GKDCM_GradientEchoTrainLength              "0018|9241"
#define GKDCM_ChemicalShiftMinimumIntegrationLimitInppm "0018|9295"
#define GKDCM_ChemicalShiftMaximumIntegrationLimitInppm "0018|9296"
#define GKDCM_CTAcquisitionTypeSequence            "0018|9301"
#define GKDCM_AcquisitionType                      "0018|9302"
#define GKDCM_TubeAngle                            "0018|9303"
#define GKDCM_CTAcquisitionDetailsSequence         "0018|9304"
#define GKDCM_RevolutionTime                       "0018|9305"
#define GKDCM_SingleCollimationWidth               "0018|9306"
#define GKDCM_TotalCollimationWidth                "0018|9307"
#define GKDCM_CTTableDynamicsSequence              "0018|9308"
#define GKDCM_TableSpeed                           "0018|9309"
#define GKDCM_TableFeedPerRotation                 "0018|9310"
#define GKDCM_SpiralPitchFactor                    "0018|9311"
#define GKDCM_CTGeometrySequence                   "0018|9312"
#define GKDCM_DataCollectionCenterPatient          "0018|9313"
#define GKDCM_CTReconstructionSequence             "0018|9314"
#define GKDCM_ReconstructionAlgorithm              "0018|9315"
#define GKDCM_ConvolutionKernelGroup               "0018|9316"
#define GKDCM_ReconstructionFieldOfView            "0018|9317"
#define GKDCM_ReconstructionTargetCenterPatient    "0018|9318"
#define GKDCM_ReconstructionAngle                  "0018|9319"
#define GKDCM_ImageFilter                          "0018|9320"
#define GKDCM_CTExposureSequence                   "0018|9321"
#define GKDCM_ReconstructionPixelSpacing           "0018|9322"
#define GKDCM_ExposureModulationType               "0018|9323"
#define GKDCM_EstimatedDoseSaving                  "0018|9324"
#define GKDCM_CTXRayDetailsSequence                "0018|9325"
#define GKDCM_CTPositionSequence                   "0018|9326"
#define GKDCM_TablePosition                        "0018|9327"
#define GKDCM_ExposureTimeInms                     "0018|9328"
#define GKDCM_CTImageFrameTypeSequence             "0018|9329"
#define GKDCM_XRayTubeCurrentInmA                  "0018|9330"
#define GKDCM_ExposureInmAs                        "0018|9332"
#define GKDCM_ConstantVolumeFlag                   "0018|9333"
#define GKDCM_FluoroscopyFlag                      "0018|9334"
#define GKDCM_DistanceSourceToDataCollectionCenter "0018|9335"
#define GKDCM_ContrastBolusAgentNumber             "0018|9337"
#define GKDCM_ContrastBolusIngredientCodeSequence  "0018|9338"
#define GKDCM_ContrastAdministrationProfileSequence "0018|9340"
#define GKDCM_ContrastBolusUsageSequence           "0018|9341"
#define GKDCM_ContrastBolusAgentAdministered       "0018|9342"
#define GKDCM_ContrastBolusAgentDetected           "0018|9343"
#define GKDCM_ContrastBolusAgentPhase              "0018|9344"
#define GKDCM_CTDIvol                              "0018|9345"
#define GKDCM_CTDIPhantomTypeCodeSequence          "0018|9346"
#define GKDCM_CalciumScoringMassFactorPatient      "0018|9351"
#define GKDCM_CalciumScoringMassFactorDevice       "0018|9352"
#define GKDCM_EnergyWeightingFactor                "0018|9353"
#define GKDCM_CTAdditionalXRaySourceSequence       "0018|9360"
#define GKDCM_ProjectionPixelCalibrationSequence   "0018|9401"
#define GKDCM_DistanceSourceToIsocenter            "0018|9402"
#define GKDCM_DistanceObjectToTableTop             "0018|9403"
#define GKDCM_ObjectPixelSpacingInCenterOfBeam     "0018|9404"
#define GKDCM_PositionerPositionSequence           "0018|9405"
#define GKDCM_TablePositionSequence                "0018|9406"
#define GKDCM_CollimatorShapeSequence              "0018|9407"
#define GKDCM_XAXRFFrameCharacteristicsSequence    "0018|9412"
#define GKDCM_FrameAcquisitionSequence             "0018|9417"
#define GKDCM_XRayReceptorType                     "0018|9420"
#define GKDCM_AcquisitionProtocolName              "0018|9423"
#define GKDCM_AcquisitionProtocolDescription       "0018|9424"
#define GKDCM_ContrastBolusIngredientOpaque        "0018|9425"
#define GKDCM_DistanceReceptorPlaneToDetectorHousing "0018|9426"
#define GKDCM_IntensifierActiveShape               "0018|9427"
#define GKDCM_IntensifierActiveDimensions          "0018|9428"
#define GKDCM_PhysicalDetectorSize                 "0018|9429"
#define GKDCM_PositionOfIsocenterProjection        "0018|9430"
#define GKDCM_FieldOfViewSequence                  "0018|9432"
#define GKDCM_FieldOfViewDescription               "0018|9433"
#define GKDCM_ExposureControlSensingRegionsSequence "0018|9434"
#define GKDCM_ExposureControlSensingRegionShape    "0018|9435"
#define GKDCM_ExposureControlSensingRegionLeftVerticalEdge "0018|9436"
#define GKDCM_ExposureControlSensingRegionRightVerticalEdge "0018|9437"
#define GKDCM_ExposureControlSensingRegionUpperHorizontalEdge "0018|9438"
#define GKDCM_ExposureControlSensingRegionLowerHorizontalEdge "0018|9439"
#define GKDCM_CenterOfCircularExposureControlSensingRegion "0018|9440"
#define GKDCM_RadiusOfCircularExposureControlSensingRegion "0018|9441"
#define GKDCM_VerticesOfThePolygonalExposureControlSensingRegion "0018|9442"
#define GKDCM_ColumnAngulationPatient              "0018|9447"
#define GKDCM_BeamAngle                            "0018|9449"
#define GKDCM_FrameDetectorParametersSequence      "0018|9451"
#define GKDCM_CalculatedAnatomyThickness           "0018|9452"
#define GKDCM_CalibrationSequence                  "0018|9455"
#define GKDCM_ObjectThicknessSequence              "0018|9456"
#define GKDCM_PlaneIdentification                  "0018|9457"
#define GKDCM_FieldOfViewDimensionsInFloat         "0018|9461"
#define GKDCM_IsocenterReferenceSystemSequence     "0018|9462"
#define GKDCM_PositionerIsocenterPrimaryAngle      "0018|9463"
#define GKDCM_PositionerIsocenterSecondaryAngle    "0018|9464"
#define GKDCM_PositionerIsocenterDetectorRotationAngle "0018|9465"
#define GKDCM_TableXPositionToIsocenter            "0018|9466"
#define GKDCM_TableYPositionToIsocenter            "0018|9467"
#define GKDCM_TableZPositionToIsocenter            "0018|9468"
#define GKDCM_TableHorizontalRotationAngle         "0018|9469"
#define GKDCM_TableHeadTiltAngle                   "0018|9470"
#define GKDCM_TableCradleTiltAngle                 "0018|9471"
#define GKDCM_FrameDisplayShutterSequence          "0018|9472"
#define GKDCM_AcquiredImageAreaDoseProduct         "0018|9473"
#define GKDCM_CArmPositionerTabletopRelationship   "0018|9474"
#define GKDCM_XRayGeometrySequence                 "0018|9476"
#define GKDCM_IrradiationEventIdentificationSequence "0018|9477"
#define GKDCM_XRay3DFrameTypeSequence              "0018|9504"
#define GKDCM_ContributingSourcesSequence          "0018|9506"
#define GKDCM_XRay3DAcquisitionSequence            "0018|9507"
#define GKDCM_PrimaryPositionerScanArc             "0018|9508"
#define GKDCM_SecondaryPositionerScanArc           "0018|9509"
#define GKDCM_PrimaryPositionerScanStartAngle      "0018|9510"
#define GKDCM_SecondaryPositionerScanStartAngle    "0018|9511"
#define GKDCM_PrimaryPositionerIncrement           "0018|9514"
#define GKDCM_SecondaryPositionerIncrement         "0018|9515"
#define GKDCM_StartAcquisitionDateTime             "0018|9516"
#define GKDCM_EndAcquisitionDateTime               "0018|9517"
#define GKDCM_ApplicationName                      "0018|9524"
#define GKDCM_ApplicationVersion                   "0018|9525"
#define GKDCM_ApplicationManufacturer              "0018|9526"
#define GKDCM_AlgorithmType                        "0018|9527"
#define GKDCM_AlgorithmDescription                 "0018|9528"
#define GKDCM_XRay3DReconstructionSequence         "0018|9530"
#define GKDCM_ReconstructionDescription            "0018|9531"
#define GKDCM_PerProjectionAcquisitionSequence     "0018|9538"
#define GKDCM_DiffusionBMatrixSequence             "0018|9601"
#define GKDCM_DiffusionBValueXX                    "0018|9602"
#define GKDCM_DiffusionBValueXY                    "0018|9603"
#define GKDCM_DiffusionBValueXZ                    "0018|9604"
#define GKDCM_DiffusionBValueYY                    "0018|9605"
#define GKDCM_DiffusionBValueYZ                    "0018|9606"
#define GKDCM_DiffusionBValueZZ                    "0018|9607"
#define GKDCM_DecayCorrectionDateTime              "0018|9701"
#define GKDCM_StartDensityThreshold                "0018|9715"
#define GKDCM_StartRelativeDensityDifferenceThreshold "0018|9716"
#define GKDCM_StartCardiacTriggerCountThreshold    "0018|9717"
#define GKDCM_StartRespiratoryTriggerCountThreshold "0018|9718"
#define GKDCM_TerminationCountsThreshold           "0018|9719"
#define GKDCM_TerminationDensityThreshold          "0018|9720"
#define GKDCM_TerminationRelativeDensityThreshold  "0018|9721"
#define GKDCM_TerminationTimeThreshold             "0018|9722"
#define GKDCM_TerminationCardiacTriggerCountThreshold "0018|9723"
#define GKDCM_TerminationRespiratoryTriggerCountThreshold "0018|9724"
#define GKDCM_DetectorGeometry                     "0018|9725"
#define GKDCM_TransverseDetectorSeparation         "0018|9726"
#define GKDCM_AxialDetectorDimension               "0018|9727"
#define GKDCM_RadiopharmaceuticalAgentNumber       "0018|9729"
#define GKDCM_PETFrameAcquisitionSequence          "0018|9732"
#define GKDCM_PETDetectorMotionDetailsSequence     "0018|9733"
#define GKDCM_PETTableDynamicsSequence             "0018|9734"
#define GKDCM_PETPositionSequence                  "0018|9735"
#define GKDCM_PETFrameCorrectionFactorsSequence    "0018|9736"
#define GKDCM_RadiopharmaceuticalUsageSequence     "0018|9737"
#define GKDCM_AttenuationCorrectionSource          "0018|9738"
#define GKDCM_NumberOfIterations                   "0018|9739"
#define GKDCM_NumberOfSubsets                      "0018|9740"
#define GKDCM_PETReconstructionSequence            "0018|9749"
#define GKDCM_PETFrameTypeSequence                 "0018|9751"
#define GKDCM_TimeOfFlightInformationUsed          "0018|9755"
#define GKDCM_ReconstructionType                   "0018|9756"
#define GKDCM_DecayCorrected                       "0018|9758"
#define GKDCM_AttenuationCorrected                 "0018|9759"
#define GKDCM_ScatterCorrected                     "0018|9760"
#define GKDCM_DeadTimeCorrected                    "0018|9761"
#define GKDCM_GantryMotionCorrected                "0018|9762"
#define GKDCM_PatientMotionCorrected               "0018|9763"
#define GKDCM_CountLossNormalizationCorrected      "0018|9764"
#define GKDCM_RandomsCorrected                     "0018|9765"
#define GKDCM_NonUniformRadialSamplingCorrected    "0018|9766"
#define GKDCM_SensitivityCalibrated                "0018|9767"
#define GKDCM_DetectorNormalizationCorrection      "0018|9768"
#define GKDCM_IterativeReconstructionMethod        "0018|9769"
#define GKDCM_AttenuationCorrectionTemporalRelationship "0018|9770"
#define GKDCM_PatientPhysiologicalStateSequence    "0018|9771"
#define GKDCM_PatientPhysiologicalStateCodeSequence "0018|9772"
#define GKDCM_DepthsOfFocus                        "0018|9801"
#define GKDCM_ExcludedIntervalsSequence            "0018|9803"
#define GKDCM_ExclusionStartDatetime               "0018|9804"
#define GKDCM_ExclusionDuration                    "0018|9805"
#define GKDCM_USImageDescriptionSequence           "0018|9806"
#define GKDCM_ImageDataTypeSequence                "0018|9807"
#define GKDCM_DataType                             "0018|9808"
#define GKDCM_TransducerScanPatternCodeSequence    "0018|9809"
#define GKDCM_AliasedDataType                      "0018|980b"
#define GKDCM_PositionMeasuringDeviceUsed          "0018|980c"
#define GKDCM_TransducerGeometryCodeSequence       "0018|980d"
#define GKDCM_TransducerBeamSteeringCodeSequence   "0018|980e"
#define GKDCM_TransducerApplicationCodeSequence    "0018|980f"
#define GKDCM_ContributingEquipmentSequence        "0018|a001"
#define GKDCM_ContributionDateTime                 "0018|a002"
#define GKDCM_ContributionDescription              "0018|a003"
#define GKDCM_StudyInstanceUID                     "0020|000d"
#define GKDCM_SeriesInstanceUID                    "0020|000e"
#define GKDCM_StudyID                              "0020|0010"
#define GKDCM_SeriesNumber                         "0020|0011"
#define GKDCM_AcquisitionNumber                    "0020|0012"
#define GKDCM_InstanceNumber                       "0020|0013"
#define GKDCM_RETIRED_IsotopeNumber                "0020|0014"
#define GKDCM_RETIRED_PhaseNumber                  "0020|0015"
#define GKDCM_RETIRED_IntervalNumber               "0020|0016"
#define GKDCM_RETIRED_TimeSlotNumber               "0020|0017"
#define GKDCM_RETIRED_AngleNumber                  "0020|0018"
#define GKDCM_ItemNumber                           "0020|0019"
#define GKDCM_PatientOrientation                   "0020|0020"
#define GKDCM_RETIRED_OverlayNumber                "0020|0022"
#define GKDCM_RETIRED_CurveNumber                  "0020|0024"
#define GKDCM_RETIRED_LUTNumber                    "0020|0026"
#define GKDCM_ACR_NEMA_ImagePosition               "0020|0030"
#define GKDCM_ImagePositionPatient                 "0020|0032"
#define GKDCM_ACR_NEMA_ImageOrientation            "0020|0035"
#define GKDCM_ImageOrientationPatient              "0020|0037"
#define GKDCM_ACR_NEMA_Location                    "0020|0050"
#define GKDCM_FrameOfReferenceUID                  "0020|0052"
#define GKDCM_Laterality                           "0020|0060"
#define GKDCM_ImageLaterality                      "0020|0062"
#define GKDCM_ACR_NEMA_ImageGeometryType           "0020|0070"
#define GKDCM_ACR_NEMA_MaskingImage                "0020|0080"
#define GKDCM_TemporalPositionIdentifier           "0020|0100"
#define GKDCM_NumberOfTemporalPositions            "0020|0105"
#define GKDCM_TemporalResolution                   "0020|0110"
#define GKDCM_SynchronizationFrameOfReferenceUID   "0020|0200"
#define GKDCM_SOPInstanceUIDOfConcatenationSource  "0020|0242"
#define GKDCM_RETIRED_SeriesInStudy                "0020|1000"
#define GKDCM_ACR_NEMA_AcquisitionsInSeries        "0020|1001"
#define GKDCM_ImagesInAcquisition                  "0020|1002"
#define GKDCM_ACR_NEMA_ImagesInSeries              "0020|1003"
#define GKDCM_RETIRED_AcquisitionsInStudy          "0020|1004"
#define GKDCM_ACR_NEMA_ImagesInStudy               "0020|1005"
#define GKDCM_ACR_NEMA_Reference                   "0020|1020"
#define GKDCM_PositionReferenceIndicator           "0020|1040"
#define GKDCM_SliceLocation                        "0020|1041"
#define GKDCM_RETIRED_OtherStudyNumbers            "0020|1070"
#define GKDCM_NumberOfPatientRelatedStudies        "0020|1200"
#define GKDCM_NumberOfPatientRelatedSeries         "0020|1202"
#define GKDCM_NumberOfPatientRelatedInstances      "0020|1204"
#define GKDCM_NumberOfStudyRelatedSeries           "0020|1206"
#define GKDCM_NumberOfStudyRelatedInstances        "0020|1208"
#define GKDCM_NumberOfSeriesRelatedInstances       "0020|1209"
#define GKDCM_ACR_NEMA_ModifyingDeviceID           "0020|3401"
#define GKDCM_ACR_NEMA_ModifiedImageID             "0020|3402"
#define GKDCM_ACR_NEMA_ModifiedImageDate           "0020|3403"
#define GKDCM_ACR_NEMA_ModifyingDeviceManufacturer "0020|3404"
#define GKDCM_ACR_NEMA_ModifiedImageTime           "0020|3405"
#define GKDCM_ACR_NEMA_ModifiedImageDescription    "0020|3406"
#define GKDCM_ImageComments                        "0020|4000"
#define GKDCM_ACR_NEMA_OriginalImageIdentification "0020|5000"
#define GKDCM_ACR_NEMA_OriginalImageIdentificationNomenclature "0020|5002"
#define GKDCM_StackID                              "0020|9056"
#define GKDCM_InStackPositionNumber                "0020|9057"
#define GKDCM_FrameAnatomySequence                 "0020|9071"
#define GKDCM_FrameLaterality                      "0020|9072"
#define GKDCM_FrameContentSequence                 "0020|9111"
#define GKDCM_PlanePositionSequence                "0020|9113"
#define GKDCM_PlaneOrientationSequence             "0020|9116"
#define GKDCM_TemporalPositionIndex                "0020|9128"
#define GKDCM_NominalCardiacTriggerDelayTime       "0020|9153"
#define GKDCM_FrameAcquisitionNumber               "0020|9156"
#define GKDCM_DimensionIndexValues                 "0020|9157"
#define GKDCM_FrameComments                        "0020|9158"
#define GKDCM_ConcatenationUID                     "0020|9161"
#define GKDCM_InConcatenationNumber                "0020|9162"
#define GKDCM_InConcatenationTotalNumber           "0020|9163"
#define GKDCM_DimensionOrganizationUID             "0020|9164"
#define GKDCM_DimensionIndexPointer                "0020|9165"
#define GKDCM_FunctionalGroupPointer               "0020|9167"
#define GKDCM_DimensionIndexPrivateCreator         "0020|9213"
#define GKDCM_DimensionOrganizationSequence        "0020|9221"
#define GKDCM_DimensionIndexSequence               "0020|9222"
#define GKDCM_ConcatenationFrameOffsetNumber       "0020|9228"
#define GKDCM_FunctionalGroupPrivateCreator        "0020|9238"
#define GKDCM_NominalPercentageOfCardiacPhase      "0020|9241"
#define GKDCM_NominalPercentageOfRespiratoryPhase  "0020|9245"
#define GKDCM_StartingRespiratoryAmplitude         "0020|9246"
#define GKDCM_StartingRespiratoryPhase             "0020|9247"
#define GKDCM_EndingRespiratoryAmplitude           "0020|9248"
#define GKDCM_EndingRespiratoryPhase               "0020|9249"
#define GKDCM_RespiratoryTriggerType               "0020|9250"
#define GKDCM_RRIntervalTimeNominal                "0020|9251"
#define GKDCM_ActualCardiacTriggerDelayTime        "0020|9252"
#define GKDCM_RespiratorySynchronizationSequence   "0020|9253"
#define GKDCM_RespiratoryIntervalTime              "0020|9254"
#define GKDCM_NominalRespiratoryTriggerDelayTime   "0020|9255"
#define GKDCM_RespiratoryTriggerDelayThreshold     "0020|9256"
#define GKDCM_ActualRespiratoryTriggerDelayTime    "0020|9257"
#define GKDCM_ImagePositionVolume                  "0020|9301"
#define GKDCM_ImageOrientationVolume               "0020|9302"
#define GKDCM_UltrasoundAcquisitionGeometry        "0020|9307"
#define GKDCM_ApexPosition                         "0020|9308"
#define GKDCM_VolumeToTransducerMappingMatrix      "0020|9309"
#define GKDCM_VolumeToTableMappingMatrix           "0020|930a"
#define GKDCM_PatientFrameOfReferenceSource        "0020|930c"
#define GKDCM_TemporalPositionTimeOffset           "0020|930d"
#define GKDCM_PlanePositionVolumeSequence          "0020|930e"
#define GKDCM_PlaneOrientationVolumeSequence       "0020|930f"
#define GKDCM_TemporalPositionSequence             "0020|9310"
#define GKDCM_DimensionOrganizationType            "0020|9311"
#define GKDCM_VolumeFrameOfReferenceUID            "0020|9312"
#define GKDCM_TableFrameOfReferenceUID             "0020|9313"
#define GKDCM_DimensionDescriptionLabel            "0020|9421"
#define GKDCM_PatientOrientationInFrameSequence    "0020|9450"
#define GKDCM_FrameLabel                           "0020|9453"
#define GKDCM_AcquisitionIndex                     "0020|9518"
#define GKDCM_ContributingSOPInstancesReferenceSequence "0020|9529"
#define GKDCM_ReconstructionIndex                  "0020|9536"
#define GKDCM_LightPathFilterPassThroughWavelength "0022|0001"
#define GKDCM_LightPathFilterPassBand              "0022|0002"
#define GKDCM_ImagePathFilterPassThroughWavelength "0022|0003"
#define GKDCM_ImagePathFilterPassBand              "0022|0004"
#define GKDCM_PatientEyeMovementCommanded          "0022|0005"
#define GKDCM_PatientEyeMovementCommandCodeSequence "0022|0006"
#define GKDCM_SphericalLensPower                   "0022|0007"
#define GKDCM_CylinderLensPower                    "0022|0008"
#define GKDCM_CylinderAxis                         "0022|0009"
#define GKDCM_EmmetropicMagnification              "0022|000a"
#define GKDCM_IntraOcularPressure                  "0022|000b"
#define GKDCM_HorizontalFieldOfView                "0022|000c"
#define GKDCM_PupilDilated                         "0022|000d"
#define GKDCM_DegreeOfDilation                     "0022|000e"
#define GKDCM_StereoBaselineAngle                  "0022|0010"
#define GKDCM_StereoBaselineDisplacement           "0022|0011"
#define GKDCM_StereoHorizontalPixelOffset          "0022|0012"
#define GKDCM_StereoVerticalPixelOffset            "0022|0013"
#define GKDCM_StereoRotation                       "0022|0014"
#define GKDCM_AcquisitionDeviceTypeCodeSequence    "0022|0015"
#define GKDCM_IlluminationTypeCodeSequence         "0022|0016"
#define GKDCM_LightPathFilterTypeStackCodeSequence "0022|0017"
#define GKDCM_ImagePathFilterTypeStackCodeSequence "0022|0018"
#define GKDCM_LensesCodeSequence                   "0022|0019"
#define GKDCM_ChannelDescriptionCodeSequence       "0022|001a"
#define GKDCM_RefractiveStateSequence              "0022|001b"
#define GKDCM_MydriaticAgentCodeSequence           "0022|001c"
#define GKDCM_RelativeImagePositionCodeSequence    "0022|001d"
#define GKDCM_StereoPairsSequence                  "0022|0020"
#define GKDCM_LeftImageSequence                    "0022|0021"
#define GKDCM_RightImageSequence                   "0022|0022"
#define GKDCM_AxialLengthOfTheEye                  "0022|0030"
#define GKDCM_OphthalmicFrameLocationSequence      "0022|0031"
#define GKDCM_ReferenceCoordinates                 "0022|0032"
#define GKDCM_DepthSpatialResolution               "0022|0035"
#define GKDCM_MaximumDepthDistortion               "0022|0036"
#define GKDCM_AlongScanSpatialResolution           "0022|0037"
#define GKDCM_MaximumAlongScanDistortion           "0022|0038"
#define GKDCM_OphthalmicImageOrientation           "0022|0039"
#define GKDCM_DepthOfTransverseImage               "0022|0041"
#define GKDCM_MydriaticAgentConcentrationUnitsSequence "0022|0042"
#define GKDCM_AcrossScanSpatialResolution          "0022|0048"
#define GKDCM_MaximumAcrossScanDistortion          "0022|0049"
#define GKDCM_MydriaticAgentConcentration          "0022|004e"
#define GKDCM_IlluminationWaveLength               "0022|0055"
#define GKDCM_IlluminationPower                    "0022|0056"
#define GKDCM_IlluminationBandwidth                "0022|0057"
#define GKDCM_MydriaticAgentSequence               "0022|0058"
#define GKDCM_OphthalmicAxialMeasurementsRightEyeSequence "0022|1007"
#define GKDCM_OphthalmicAxialMeasurementsLeftEyeSequence "0022|1008"
#define GKDCM_OphthalmicAxialMeasurementsDeviceType "0022|1009"
#define GKDCM_OphthalmicAxialLengthMeasurementsType "0022|1010"
#define GKDCM_OphthalmicAxialLengthSequence        "0022|1012"
#define GKDCM_OphthalmicAxialLength                "0022|1019"
#define GKDCM_LensStatusCodeSequence               "0022|1024"
#define GKDCM_VitreousStatusCodeSequence           "0022|1025"
#define GKDCM_IOLFormulaCodeSequence               "0022|1028"
#define GKDCM_IOLFormulaDetail                     "0022|1029"
#define GKDCM_KeratometerIndex                     "0022|1033"
#define GKDCM_SourceofOphthalmicAxialLengthCodeSequence "0022|1035"
#define GKDCM_TargetRefraction                     "0022|1037"
#define GKDCM_RefractiveProcedureOccurred          "0022|1039"
#define GKDCM_RefractiveSurgeryTypeCodeSequence    "0022|1040"
#define GKDCM_OphthalmicUltrasoundMethodCodeSequence "0022|1044"
#define GKDCM_OphthalmicAxialLengthMeasurementsSequence "0022|1050"
#define GKDCM_IOLPower                             "0022|1053"
#define GKDCM_PredictedRefractiveError             "0022|1054"
#define GKDCM_OphthalmicAxialLengthVelocity        "0022|1059"
#define GKDCM_LensStatusDescription                "0022|1065"
#define GKDCM_VitreousStatusDescription            "0022|1066"
#define GKDCM_IOLPowerSequence                     "0022|1090"
#define GKDCM_LensConstantSequence                 "0022|1092"
#define GKDCM_IOLManufacturer                      "0022|1093"
#define GKDCM_ImplantName                          "0022|1095"
#define GKDCM_KeratometryMeasurementTypeCodeSequence "0022|1096"
#define GKDCM_ImplantPartNumber                    "0022|1097"
#define GKDCM_ReferencedOphthalmicAxialMeasurementsSequence "0022|1100"
#define GKDCM_OphthalmicAxialLengthMeasurementsSegmentNameCodeSequence "0022|1101"
#define GKDCM_RefractiveErrorBeforeRefractiveSurgeryCodeSequence "0022|1103"
#define GKDCM_IOLPowerForExactEmmetropia           "0022|1121"
#define GKDCM_IOLPowerForExactTargetRefraction     "0022|1122"
#define GKDCM_AnteriorChamberDepthDefinitionCodeSequence "0022|1125"
#define GKDCM_LensThicknessSequence                "0022|1127"
#define GKDCM_AnteriorChamberDepthSequence         "0022|1128"
#define GKDCM_LensThickness                        "0022|1130"
#define GKDCM_AnteriorChamberDepth                 "0022|1131"
#define GKDCM_SourceofLensThicknessDataCodeSequence "0022|1132"
#define GKDCM_SourceofAnteriorChamberDepthDataCodeSequence "0022|1133"
#define GKDCM_SourceofRefractiveMeasurementsSequence "0022|1134"
#define GKDCM_SourceofRefractiveMeasurementsCodeSequence "0022|1135"
#define GKDCM_OphthalmicAxialLengthMeasurementModified "0022|1140"
#define GKDCM_OphthalmicAxialLengthDataSourceCodeSequence "0022|1150"
#define GKDCM_SignaltoNoiseRatio                   "0022|1155"
#define GKDCM_OphthalmicAxialLengthDataSourceDescription "0022|1159"
#define GKDCM_OphthalmicAxialLengthMeasurementsTotalLengthSequence "0022|1210"
#define GKDCM_OphthalmicAxialLengthMeasurementsSegmentalLengthSequence "0022|1211"
#define GKDCM_OphthalmicAxialLengthMeasurementsLengthSummationSequence "0022|1212"
#define GKDCM_UltrasoundOphthalmicAxialLengthMeasurementsSequence "0022|1220"
#define GKDCM_OpticalOphthalmicAxialLengthMeasurementsSequence "0022|1225"
#define GKDCM_UltrasoundSelectedOphthalmicAxialLengthSequence "0022|1230"
#define GKDCM_OphthalmicAxialLengthSelectionMethodCodeSequence "0022|1250"
#define GKDCM_OpticalSelectedOphthalmicAxialLengthSequence "0022|1255"
#define GKDCM_SelectedSegmentalOphthalmicAxialLengthSequence "0022|1257"
#define GKDCM_SelectedTotalOphthalmicAxialLengthSequence "0022|1260"
#define GKDCM_OphthalmicAxialLengthQualityMetricSequence "0022|1262"
#define GKDCM_OphthalmicAxialLengthQualityMetricTypeCodeSequence "0022|1265"
#define GKDCM_IntraocularLensCalculationsRightEyeSequence "0022|1300"
#define GKDCM_IntraocularLensCalculationsLeftEyeSequence "0022|1310"
#define GKDCM_ReferencedOphthalmicAxialLengthMeasurementQCImageSequence "0022|1330"
#define GKDCM_VisualFieldHorizontalExtent          "0024|0010"
#define GKDCM_VisualFieldVerticalExtent            "0024|0011"
#define GKDCM_VisualFieldShape                     "0024|0012"
#define GKDCM_ScreeningTestModeCodeSequence        "0024|0016"
#define GKDCM_MaximumStimulusLuminance             "0024|0018"
#define GKDCM_BackgroundLuminance                  "0024|0020"
#define GKDCM_StimulusColorCodeSequence            "0024|0021"
#define GKDCM_BackgroundIlluminationColorCodeSequence "0024|0024"
#define GKDCM_StimulusArea                         "0024|0025"
#define GKDCM_StimulusPresentationTime             "0024|0028"
#define GKDCM_FixationSequence                     "0024|0032"
#define GKDCM_FixationMonitoringCodeSequence       "0024|0033"
#define GKDCM_VisualFieldCatchTrialSequence        "0024|0034"
#define GKDCM_FixationCheckedQuantity              "0024|0035"
#define GKDCM_PatientNotProperlyFixatedQuantity    "0024|0036"
#define GKDCM_PresentedVisualStimuliDataFlag       "0024|0037"
#define GKDCM_NumberOfVisualStimuli                "0024|0038"
#define GKDCM_ExcessiveFixationLossesDataFlag      "0024|0039"
#define GKDCM_ExcessiveFixationLosses              "0024|0040"
#define GKDCM_StimuliRetestingQuantity             "0024|0042"
#define GKDCM_CommentsOnPatientPerformanceOfVisualField "0024|0044"
#define GKDCM_FalseNegativesEstimateFlag           "0024|0045"
#define GKDCM_FalseNegativesEstimate               "0024|0046"
#define GKDCM_NegativeCatchTrialsQuantity          "0024|0048"
#define GKDCM_FalseNegativesQuantity               "0024|0050"
#define GKDCM_ExcessiveFalseNegativesDataFlag      "0024|0051"
#define GKDCM_ExcessiveFalseNegatives              "0024|0052"
#define GKDCM_FalsePositivesEstimateFlag           "0024|0053"
#define GKDCM_FalsePositivesEstimate               "0024|0054"
#define GKDCM_CatchTrialsDataFlag                  "0024|0055"
#define GKDCM_PositiveCatchTrialsQuantity          "0024|0056"
#define GKDCM_TestPointNormalsDataFlag             "0024|0057"
#define GKDCM_TestPointNormalsSequence             "0024|0058"
#define GKDCM_GlobalDeviationProbabilityNormalsFlag "0024|0059"
#define GKDCM_FalsePositivesQuantity               "0024|0060"
#define GKDCM_ExcessiveFalsePositivesDataFlag      "0024|0061"
#define GKDCM_ExcessiveFalsePositives              "0024|0062"
#define GKDCM_VisualFieldTestNormalsFlag           "0024|0063"
#define GKDCM_ResultsNormalsSequence               "0024|0064"
#define GKDCM_AgeCorrectedSensitivityDeviationAlgorithmSequence "0024|0065"
#define GKDCM_GlobalDeviationFromNormal            "0024|0066"
#define GKDCM_GeneralizedDefectSensitivityDeviationAlgorithmSequence "0024|0067"
#define GKDCM_LocalizedDeviationfromNormal         "0024|0068"
#define GKDCM_PatientReliabilityIndicator          "0024|0069"
#define GKDCM_VisualFieldMeanSensitivity           "0024|0070"
#define GKDCM_GlobalDeviationProbability           "0024|0071"
#define GKDCM_LocalDeviationProbabilityNormalsFlag "0024|0072"
#define GKDCM_LocalizedDeviationProbability        "0024|0073"
#define GKDCM_ShortTermFluctuationCalculated       "0024|0074"
#define GKDCM_ShortTermFluctuation                 "0024|0075"
#define GKDCM_ShortTermFluctuationProbabilityCalculated "0024|0076"
#define GKDCM_ShortTermFluctuationProbability      "0024|0077"
#define GKDCM_CorrectedLocalizedDeviationFromNormalCalculated "0024|0078"
#define GKDCM_CorrectedLocalizedDeviationFromNormal "0024|0079"
#define GKDCM_CorrectedLocalizedDeviationFromNormalProbabilityCalculated "0024|0080"
#define GKDCM_CorrectedLocalizedDeviationFromNormalProbability "0024|0081"
#define GKDCM_GlobalDeviationProbabilitySequence   "0024|0083"
#define GKDCM_LocalizedDeviationProbabilitySequence "0024|0085"
#define GKDCM_FovealSensitivityMeasured            "0024|0086"
#define GKDCM_FovealSensitivity                    "0024|0087"
#define GKDCM_VisualFieldTestDuration              "0024|0088"
#define GKDCM_VisualFieldTestPointSequence         "0024|0089"
#define GKDCM_VisualFieldTestPointXCoordinate      "0024|0090"
#define GKDCM_VisualFieldTestPointYCoordinate      "0024|0091"
#define GKDCM_AgeCorrectedSensitivityDeviationValue "0024|0092"
#define GKDCM_StimulusResults                      "0024|0093"
#define GKDCM_SensitivityValue                     "0024|0094"
#define GKDCM_RetestStimulusSeen                   "0024|0095"
#define GKDCM_RetestSensitivityValue               "0024|0096"
#define GKDCM_VisualFieldTestPointNormalsSequence  "0024|0097"
#define GKDCM_QuantifiedDefect                     "0024|0098"
#define GKDCM_GeneralizedDefectCorrectedSensitivityDeviationFlag "0024|0102"
#define GKDCM_GeneralizedDefectCorrectedSensitivityDeviationValue "0024|0103"
#define GKDCM_GeneralizedDefectCorrectedSensitivityDeviationProbabilityValue "0024|0104"
#define GKDCM_MinimumSensitivityValue              "0024|0105"
#define GKDCM_BlindSpotLocalized                   "0024|0106"
#define GKDCM_BlindSpotXCoordinate                 "0024|0107"
#define GKDCM_BlindSpotYCoordinate                 "0024|0108"
#define GKDCM_VisualAcuityMeasurementSequence      "0024|0110"
#define GKDCM_RefractiveParametersUsedOnPatientSequence "0024|0112"
#define GKDCM_MeasurementLaterality                "0024|0113"
#define GKDCM_OphthalmicPatientClinicalInformationLeftEyeSequence "0024|0114"
#define GKDCM_OphthalmicPatientClinicalInformationRightEyeSequence "0024|0115"
#define GKDCM_FovealPointNormativeDataFlag         "0024|0117"
#define GKDCM_FovealPointProbabilityValue          "0024|0118"
#define GKDCM_ScreeningBaselineMeasured            "0024|0120"
#define GKDCM_ScreeningBaselineMeasuredSequence    "0024|0122"
#define GKDCM_ScreeningBaselineType                "0024|0124"
#define GKDCM_ScreeningBaselineValue               "0024|0126"
#define GKDCM_AlgorithmSource                      "0024|0202"
#define GKDCM_DataSetName                          "0024|0306"
#define GKDCM_DataSetVersion                       "0024|0307"
#define GKDCM_DataSetSource                        "0024|0308"
#define GKDCM_DataSetDescription                   "0024|0309"
#define GKDCM_VisualFieldTestReliabilityGlobalIndexSequence "0024|0317"
#define GKDCM_VisualFieldGlobalResultsIndexSequence "0024|0320"
#define GKDCM_DataObservationSequence              "0024|0325"
#define GKDCM_IndexNormalsFlag                     "0024|0338"
#define GKDCM_IndexProbability                     "0024|0341"
#define GKDCM_IndexProbabilitySequence             "0024|0344"
#define GKDCM_SamplesPerPixel                      "0028|0002"
#define GKDCM_SamplesPerPixelUsed                  "0028|0003"
#define GKDCM_PhotometricInterpretation            "0028|0004"
#define GKDCM_ACR_NEMA_ImageDimensions             "0028|0005"
#define GKDCM_PlanarConfiguration                  "0028|0006"
#define GKDCM_NumberOfFrames                       "0028|0008"
#define GKDCM_FrameIncrementPointer                "0028|0009"
#define GKDCM_FrameDimensionPointer                "0028|000a"
#define GKDCM_Rows                                 "0028|0010"
#define GKDCM_Columns                              "0028|0011"
#define GKDCM_RETIRED_Planes                       "0028|0012"
#define GKDCM_UltrasoundColorDataPresent           "0028|0014"
#define GKDCM_PixelSpacing                         "0028|0030"
#define GKDCM_ImagerPixelSpacing                   "0018|1164"
#define GKDCM_ZoomFactor                           "0028|0031"
#define GKDCM_ZoomCenter                           "0028|0032"
#define GKDCM_PixelAspectRatio                     "0028|0034"
#define GKDCM_ACR_NEMA_ImageFormat                 "0028|0040"
#define GKDCM_ACR_NEMA_ManipulatedImage            "0028|0050"
#define GKDCM_CorrectedImage                       "0028|0051"
#define GKDCM_ACR_NEMA_2C_CompressionRecognitionCode "0028|005f"
#define GKDCM_ACR_NEMA_CompressionCode             "0028|0060"
#define GKDCM_ACR_NEMA_2C_CompressionOriginator    "0028|0061"
#define GKDCM_ACR_NEMA_2C_CompressionLabel         "0028|0062"
#define GKDCM_ACR_NEMA_2C_CompressionDescription   "0028|0063"
#define GKDCM_ACR_NEMA_2C_CompressionSequence      "0028|0065"
#define GKDCM_ACR_NEMA_2C_CompressionStepPointers  "0028|0066"
#define GKDCM_ACR_NEMA_2C_RepeatInterval           "0028|0068"
#define GKDCM_ACR_NEMA_2C_BitsGrouped              "0028|0069"
#define GKDCM_ACR_NEMA_2C_PerimeterTable           "0028|0070"
#define GKDCM_ACR_NEMA_2C_PerimeterValue           "0028|0071"
#define GKDCM_ACR_NEMA_2C_PredictorRows            "0028|0080"
#define GKDCM_ACR_NEMA_2C_PredictorColumns         "0028|0081"
#define GKDCM_ACR_NEMA_2C_PredictorConstants       "0028|0082"
#define GKDCM_ACR_NEMA_2C_BlockedPixels            "0028|0090"
#define GKDCM_ACR_NEMA_2C_BlockRows                "0028|0091"
#define GKDCM_ACR_NEMA_2C_BlockColumns             "0028|0092"
#define GKDCM_ACR_NEMA_2C_RowOverlap               "0028|0093"
#define GKDCM_ACR_NEMA_2C_ColumnOverlap            "0028|0094"
#define GKDCM_BitsAllocated                        "0028|0100"
#define GKDCM_BitsStored                           "0028|0101"
#define GKDCM_HighBit                              "0028|0102"
#define GKDCM_PixelRepresentation                  "0028|0103"
#define GKDCM_ACR_NEMA_SmallestValidPixelValue     "0028|0104"
#define GKDCM_ACR_NEMA_LargestValidPixelValue      "0028|0105"
#define GKDCM_SmallestImagePixelValue              "0028|0106"
#define GKDCM_LargestImagePixelValue               "0028|0107"
#define GKDCM_SmallestPixelValueInSeries           "0028|0108"
#define GKDCM_LargestPixelValueInSeries            "0028|0109"
#define GKDCM_RETIRED_SmallestImagePixelValueInPlane "0028|0110"
#define GKDCM_RETIRED_LargestImagePixelValueInPlane "0028|0111"
#define GKDCM_PixelPaddingValue                    "0028|0120"
#define GKDCM_PixelPaddingRangeLimit               "0028|0121"
#define GKDCM_ACR_NEMA_ImageLocation               "0028|0200"
#define GKDCM_QualityControlImage                  "0028|0300"
#define GKDCM_BurnedInAnnotation                   "0028|0301"
#define GKDCM_ACR_NEMA_2C_TransformLabel           "0028|0400"
#define GKDCM_ACR_NEMA_2C_TransformVersionNumber   "0028|0401"
#define GKDCM_ACR_NEMA_2C_NumberOfTransformSteps   "0028|0402"
#define GKDCM_ACR_NEMA_2C_SequenceOfCompressedData "0028|0403"
#define GKDCM_ACR_NEMA_2C_DetailsOfCoefficients    "0028|0404"
#define GKDCM_ACR_NEMA_2C_RowsForNthOrderCoefficients "0028|0410"
#define GKDCM_ACR_NEMA_2C_ColumnsForNthOrderCoefficients "0028|0411"
#define GKDCM_ACR_NEMA_2C_CoefficientCoding        "0028|0412"
#define GKDCM_ACR_NEMA_2C_CoefficientCodingPointers "0028|0413"
#define GKDCM_ACR_NEMA_2C_DCTLabel                 "0028|0700"
#define GKDCM_ACR_NEMA_2C_DataBlockDescription     "0028|0701"
#define GKDCM_ACR_NEMA_2C_DataBlock                "0028|0702"
#define GKDCM_ACR_NEMA_2C_NormalizationFactorFormat "0028|0710"
#define GKDCM_ACR_NEMA_2C_ZonalMapNumberFormat     "0028|0720"
#define GKDCM_ACR_NEMA_2C_ZonalMapLocation         "0028|0721"
#define GKDCM_ACR_NEMA_2C_ZonalMapFormat           "0028|0722"
#define GKDCM_ACR_NEMA_2C_AdaptiveMapFormat        "0028|0730"
#define GKDCM_ACR_NEMA_2C_CodeNumberFormat         "0028|0740"
#define GKDCM_ACR_NEMA_2C_CodeLabel                "0028|0800"
#define GKDCM_ACR_NEMA_2C_NumberOfTables           "0028|0802"
#define GKDCM_ACR_NEMA_2C_CodeTableLocation        "0028|0803"
#define GKDCM_ACR_NEMA_2C_BitsForCodeWord          "0028|0804"
#define GKDCM_ACR_NEMA_2C_ImageDataLocation        "0028|0808"
#define GKDCM_PixelSpacingCalibrationType          "0028|0a02"
#define GKDCM_PixelSpacingCalibrationDescription   "0028|0a04"
#define GKDCM_PixelIntensityRelationship           "0028|1040"
#define GKDCM_PixelIntensityRelationshipSign       "0028|1041"
#define GKDCM_WindowCenter                         "0028|1050"
#define GKDCM_WindowWidth                          "0028|1051"
#define GKDCM_RescaleIntercept                     "0028|1052"
#define GKDCM_RescaleSlope                         "0028|1053"
#define GKDCM_RescaleType                          "0028|1054"
#define GKDCM_WindowCenterWidthExplanation         "0028|1055"
#define GKDCM_VOILUTFunction                       "0028|1056"
#define GKDCM_ACR_NEMA_GrayScale                   "0028|1080"
#define GKDCM_RecommendedViewingMode               "0028|1090"
#define GKDCM_ACR_NEMA_GrayLookupTableDescriptor   "0028|1100"
#define GKDCM_RedPaletteColorLookupTableDescriptor "0028|1101"
#define GKDCM_GreenPaletteColorLookupTableDescriptor "0028|1102"
#define GKDCM_BluePaletteColorLookupTableDescriptor "0028|1103"
#define GKDCM_AlphaPaletteColorLookupTableDescriptor "0028|1104"
#define GKDCM_RETIRED_LargeRedPaletteColorLookupTableDescriptor "0028|1111"
#define GKDCM_RETIRED_LargeGreenPaletteColorLookupTableDescriptor "0028|1112"
#define GKDCM_RETIRED_LargeBluePaletteColorLookupTableDescriptor "0028|1113"
#define GKDCM_PaletteColorLookupTableUID           "0028|1199"
#define GKDCM_ACR_NEMA_GrayLookupTableData         "0028|1200"
#define GKDCM_RedPaletteColorLookupTableData       "0028|1201"
#define GKDCM_GreenPaletteColorLookupTableData     "0028|1202"
#define GKDCM_BluePaletteColorLookupTableData      "0028|1203"
#define GKDCM_AlphaPaletteColorLookupTableData     "0028|1204"
#define GKDCM_RETIRED_LargeRedPaletteColorLookupTableData "0028|1211"
#define GKDCM_RETIRED_LargeGreenPaletteColorLookupTableData "0028|1212"
#define GKDCM_RETIRED_LargeBluePaletteColorLookupTableData "0028|1213"
#define GKDCM_RETIRED_LargePaletteColorLookupTableUID "0028|1214"
#define GKDCM_SegmentedRedPaletteColorLookupTableData "0028|1221"
#define GKDCM_SegmentedGreenPaletteColorLookupTableData "0028|1222"
#define GKDCM_SegmentedBluePaletteColorLookupTableData "0028|1223"
#define GKDCM_BreastImplantPresent                 "0028|1300"
#define GKDCM_PartialView                          "0028|1350"
#define GKDCM_PartialViewDescription               "0028|1351"
#define GKDCM_PartialViewCodeSequence              "0028|1352"
#define GKDCM_SpatialLocationsPreserved            "0028|135a"
#define GKDCM_DataFrameAssignmentSequence          "0028|1401"
#define GKDCM_DataPathAssignment                   "0028|1402"
#define GKDCM_BitsMappedToColorLookupTable         "0028|1403"
#define GKDCM_BlendingLUT1Sequence                 "0028|1404"
#define GKDCM_BlendingLUT1TransferFunction         "0028|1405"
#define GKDCM_BlendingWeightConstant               "0028|1406"
#define GKDCM_BlendingLookupTableDescriptor        "0028|1407"
#define GKDCM_BlendingLookupTableData              "0028|1408"
#define GKDCM_EnhancedPaletteColorLookupTableSequence "0028|140b"
#define GKDCM_BlendingLUT2Sequence                 "0028|140c"
#define GKDCM_BlendingLUT2TransferFunction         "0028|140d"
#define GKDCM_DataPathID                           "0028|140e"
#define GKDCM_RGBLUTTransferFunction               "0028|140f"
#define GKDCM_AlphaLUTTransferFunction             "0028|1410"
#define GKDCM_ICCProfile                           "0028|2000"
#define GKDCM_LossyImageCompression                "0028|2110"
#define GKDCM_LossyImageCompressionRatio           "0028|2112"
#define GKDCM_LossyImageCompressionMethod          "0028|2114"
#define GKDCM_ModalityLUTSequence                  "0028|3000"
#define GKDCM_LUTDescriptor                        "0028|3002"
#define GKDCM_LUTExplanation                       "0028|3003"
#define GKDCM_ModalityLUTType                      "0028|3004"
#define GKDCM_LUTData                              "0028|3006"
#define GKDCM_VOILUTSequence                       "0028|3010"
#define GKDCM_SoftcopyVOILUTSequence               "0028|3110"
#define GKDCM_ACR_NEMA_ImagePresentationComments   "0028|4000"
#define GKDCM_RETIRED_BiPlaneAcquisitionSequence   "0028|5000"
#define GKDCM_RepresentativeFrameNumber            "0028|6010"
#define GKDCM_FrameNumbersOfInterest               "0028|6020"
#define GKDCM_FrameOfInterestDescription           "0028|6022"
#define GKDCM_FrameOfInterestType                  "0028|6023"
#define GKDCM_RETIRED_MaskPointers                 "0028|6030"
#define GKDCM_RWavePointer                         "0028|6040"
#define GKDCM_MaskSubtractionSequence              "0028|6100"
#define GKDCM_MaskOperation                        "0028|6101"
#define GKDCM_ApplicableFrameRange                 "0028|6102"
#define GKDCM_MaskFrameNumbers                     "0028|6110"
#define GKDCM_ContrastFrameAveraging               "0028|6112"
#define GKDCM_MaskSubPixelShift                    "0028|6114"
#define GKDCM_TIDOffset                            "0028|6120"
#define GKDCM_MaskOperationExplanation             "0028|6190"
#define GKDCM_PixelDataProviderURL                 "0028|7fe0"
#define GKDCM_DataPointRows                        "0028|9001"
#define GKDCM_DataPointColumns                     "0028|9002"
#define GKDCM_SignalDomainColumns                  "0028|9003"
#define GKDCM_RETIRED_LargestMonochromePixelValue  "0028|9099"
#define GKDCM_DataRepresentation                   "0028|9108"
#define GKDCM_PixelMeasuresSequence                "0028|9110"
#define GKDCM_FrameVOILUTSequence                  "0028|9132"
#define GKDCM_PixelValueTransformationSequence     "0028|9145"
#define GKDCM_SignalDomainRows                     "0028|9235"
#define GKDCM_DisplayFilterPercentage              "0028|9411"
#define GKDCM_FramePixelShiftSequence              "0028|9415"
#define GKDCM_SubtractionItemID                    "0028|9416"
#define GKDCM_PixelIntensityRelationshipLUTSequence "0028|9422"
#define GKDCM_FramePixelDataPropertiesSequence     "0028|9443"
#define GKDCM_GeometricalProperties                "0028|9444"
#define GKDCM_GeometricMaximumDistortion           "0028|9445"
#define GKDCM_ImageProcessingApplied               "0028|9446"
#define GKDCM_MaskSelectionMode                    "0028|9454"
#define GKDCM_LUTFunction                          "0028|9474"
#define GKDCM_MaskVisibilityPercentage             "0028|9478"
#define GKDCM_PixelShiftSequence                   "0028|9501"
#define GKDCM_RegionPixelShiftSequence             "0028|9502"
#define GKDCM_VerticesOfTheRegion                  "0028|9503"
#define GKDCM_MultiFramePresentationSequence       "0028|9505"
#define GKDCM_PixelShiftFrameRange                 "0028|9506"
#define GKDCM_LUTFrameRange                        "0028|9507"
#define GKDCM_ImageToEquipmentMappingMatrix        "0028|9520"
#define GKDCM_EquipmentCoordinateSystemIdentification "0028|9537"
#define GKDCM_RETIRED_StudyStatusID                "0032|000a"
#define GKDCM_RETIRED_StudyPriorityID              "0032|000c"
#define GKDCM_RETIRED_StudyIDIssuer                "0032|0012"
#define GKDCM_RETIRED_StudyVerifiedDate            "0032|0032"
#define GKDCM_RETIRED_StudyVerifiedTime            "0032|0033"
#define GKDCM_RETIRED_StudyReadDate                "0032|0034"
#define GKDCM_RETIRED_StudyReadTime                "0032|0035"
#define GKDCM_RETIRED_ScheduledStudyStartDate      "0032|1000"
#define GKDCM_RETIRED_ScheduledStudyStartTime      "0032|1001"
#define GKDCM_RETIRED_ScheduledStudyStopDate       "0032|1010"
#define GKDCM_RETIRED_ScheduledStudyStopTime       "0032|1011"
#define GKDCM_RETIRED_ScheduledStudyLocation       "0032|1020"
#define GKDCM_RETIRED_ScheduledStudyLocationAETitle "0032|1021"
#define GKDCM_RETIRED_ReasonForStudy               "0032|1030"
#define GKDCM_RequestingPhysicianIdentificationSequence "0032|1031"
#define GKDCM_RequestingPhysician                  "0032|1032"
#define GKDCM_RequestingService                    "0032|1033"
#define GKDCM_RequestingServiceCodeSequence        "0032|1034"
#define GKDCM_RETIRED_StudyArrivalDate             "0032|1040"
#define GKDCM_RETIRED_StudyArrivalTime             "0032|1041"
#define GKDCM_RETIRED_StudyCompletionDate          "0032|1050"
#define GKDCM_RETIRED_StudyCompletionTime          "0032|1051"
#define GKDCM_RETIRED_StudyComponentStatusID       "0032|1055"
#define GKDCM_RequestedProcedureDescription        "0032|1060"
#define GKDCM_RequestedProcedureCodeSequence       "0032|1064"
#define GKDCM_RequestedContrastAgent               "0032|1070"
#define GKDCM_RETIRED_StudyComments                "0032|4000"
#define GKDCM_ReferencedPatientAliasSequence       "0038|0004"
#define GKDCM_VisitStatusID                        "0038|0008"
#define GKDCM_AdmissionID                          "0038|0010"
#define GKDCM_RETIRED_IssuerOfAdmissionID          "0038|0011"
#define GKDCM_IssuerOfAdmissionIDSequence          "0038|0014"
#define GKDCM_RouteOfAdmissions                    "0038|0016"
#define GKDCM_RETIRED_ScheduledAdmissionDate       "0038|001a"
#define GKDCM_RETIRED_ScheduledAdmissionTime       "0038|001b"
#define GKDCM_RETIRED_ScheduledDischargeDate       "0038|001c"
#define GKDCM_RETIRED_ScheduledDischargeTime       "0038|001d"
#define GKDCM_RETIRED_ScheduledPatientInstitutionResidence "0038|001e"
#define GKDCM_AdmittingDate                        "0038|0020"
#define GKDCM_AdmittingTime                        "0038|0021"
#define GKDCM_RETIRED_DischargeDate                "0038|0030"
#define GKDCM_RETIRED_DischargeTime                "0038|0032"
#define GKDCM_RETIRED_DischargeDiagnosisDescription "0038|0040"
#define GKDCM_RETIRED_DischargeDiagnosisCodeSequence "0038|0044"
#define GKDCM_SpecialNeeds                         "0038|0050"
#define GKDCM_ServiceEpisodeID                     "0038|0060"
#define GKDCM_RETIRED_IssuerOfServiceEpisodeID     "0038|0061"
#define GKDCM_ServiceEpisodeDescription            "0038|0062"
#define GKDCM_IssuerOfServiceEpisodeIDSequence     "0038|0064"
#define GKDCM_PertinentDocumentsSequence           "0038|0100"
#define GKDCM_CurrentPatientLocation               "0038|0300"
#define GKDCM_PatientInstitutionResidence          "0038|0400"
#define GKDCM_PatientState                         "0038|0500"
#define GKDCM_PatientClinicalTrialParticipationSequence "0038|0502"
#define GKDCM_VisitComments                        "0038|4000"
#define GKDCM_WaveformOriginality                  "003a|0004"
#define GKDCM_NumberOfWaveformChannels             "003a|0005"
#define GKDCM_NumberOfWaveformSamples              "003a|0010"
#define GKDCM_SamplingFrequency                    "003a|001a"
#define GKDCM_MultiplexGroupLabel                  "003a|0020"
#define GKDCM_ChannelDefinitionSequence            "003a|0200"
#define GKDCM_WaveformChannelNumber                "003a|0202"
#define GKDCM_ChannelLabel                         "003a|0203"
#define GKDCM_ChannelStatus                        "003a|0205"
#define GKDCM_ChannelSourceSequence                "003a|0208"
#define GKDCM_ChannelSourceModifiersSequence       "003a|0209"
#define GKDCM_SourceWaveformSequence               "003a|020a"
#define GKDCM_ChannelDerivationDescription         "003a|020c"
#define GKDCM_ChannelSensitivity                   "003a|0210"
#define GKDCM_ChannelSensitivityUnitsSequence      "003a|0211"
#define GKDCM_ChannelSensitivityCorrectionFactor   "003a|0212"
#define GKDCM_ChannelBaseline                      "003a|0213"
#define GKDCM_ChannelTimeSkew                      "003a|0214"
#define GKDCM_ChannelSampleSkew                    "003a|0215"
#define GKDCM_ChannelOffset                        "003a|0218"
#define GKDCM_WaveformBitsStored                   "003a|021a"
#define GKDCM_FilterLowFrequency                   "003a|0220"
#define GKDCM_FilterHighFrequency                  "003a|0221"
#define GKDCM_NotchFilterFrequency                 "003a|0222"
#define GKDCM_NotchFilterBandwidth                 "003a|0223"
#define GKDCM_WaveformDataDisplayScale             "003a|0230"
#define GKDCM_WaveformDisplayBackgroundCIELabValue "003a|0231"
#define GKDCM_WaveformPresentationGroupSequence    "003a|0240"
#define GKDCM_PresentationGroupNumber              "003a|0241"
#define GKDCM_ChannelDisplaySequence               "003a|0242"
#define GKDCM_ChannelRecommendedDisplayCIELabValue "003a|0244"
#define GKDCM_ChannelPosition                      "003a|0245"
#define GKDCM_DisplayShadingFlag                   "003a|0246"
#define GKDCM_FractionalChannelDisplayScale        "003a|0247"
#define GKDCM_AbsoluteChannelDisplayScale          "003a|0248"
#define GKDCM_MultiplexedAudioChannelsDescriptionCodeSequence "003a|0300"
#define GKDCM_ChannelIdentificationCode            "003a|0301"
#define GKDCM_ChannelMode                          "003a|0302"
#define GKDCM_ScheduledStationAETitle              "0040|0001"
#define GKDCM_ScheduledProcedureStepStartDate      "0040|0002"
#define GKDCM_ScheduledProcedureStepStartTime      "0040|0003"
#define GKDCM_ScheduledProcedureStepEndDate        "0040|0004"
#define GKDCM_ScheduledProcedureStepEndTime        "0040|0005"
#define GKDCM_ScheduledPerformingPhysicianName     "0040|0006"
#define GKDCM_ScheduledProcedureStepDescription    "0040|0007"
#define GKDCM_ScheduledProtocolCodeSequence        "0040|0008"
#define GKDCM_ScheduledProcedureStepID             "0040|0009"
#define GKDCM_StageCodeSequence                    "0040|000a"
#define GKDCM_ScheduledPerformingPhysicianIdentificationSequence "0040|000b"
#define GKDCM_ScheduledStationName                 "0040|0010"
#define GKDCM_ScheduledProcedureStepLocation       "0040|0011"
#define GKDCM_PreMedication                        "0040|0012"
#define GKDCM_ScheduledProcedureStepStatus         "0040|0020"
#define GKDCM_OrderPlacerIdentifierSequence        "0040|0026"
#define GKDCM_OrderFillerIdentifierSequence        "0040|0027"
#define GKDCM_LocalNamespaceEntityID               "0040|0031"
#define GKDCM_UniversalEntityID                    "0040|0032"
#define GKDCM_UniversalEntityIDType                "0040|0033"
#define GKDCM_IdentifierTypeCode                   "0040|0035"
#define GKDCM_AssigningFacilitySequence            "0040|0036"
#define GKDCM_AssigningJurisdictionCodeSequence    "0040|0039"
#define GKDCM_AssigningAgencyOrDepartmentCodeSequence "0040|003a"
#define GKDCM_ScheduledProcedureStepSequence       "0040|0100"
#define GKDCM_ReferencedNonImageCompositeSOPInstanceSequence "0040|0220"
#define GKDCM_PerformedStationAETitle              "0040|0241"
#define GKDCM_PerformedStationName                 "0040|0242"
#define GKDCM_PerformedLocation                    "0040|0243"
#define GKDCM_PerformedProcedureStepStartDate      "0040|0244"
#define GKDCM_PerformedProcedureStepStartTime      "0040|0245"
#define GKDCM_PerformedProcedureStepEndDate        "0040|0250"
#define GKDCM_PerformedProcedureStepEndTime        "0040|0251"
#define GKDCM_PerformedProcedureStepStatus         "0040|0252"
#define GKDCM_PerformedProcedureStepID             "0040|0253"
#define GKDCM_PerformedProcedureStepDescription    "0040|0254"
#define GKDCM_PerformedProcedureTypeDescription    "0040|0255"
#define GKDCM_PerformedProtocolCodeSequence        "0040|0260"
#define GKDCM_PerformedProtocolType                "0040|0261"
#define GKDCM_ScheduledStepAttributesSequence      "0040|0270"
#define GKDCM_RequestAttributesSequence            "0040|0275"
#define GKDCM_CommentsOnThePerformedProcedureStep  "0040|0280"
#define GKDCM_PerformedProcedureStepDiscontinuationReasonCodeSequence "0040|0281"
#define GKDCM_QuantitySequence                     "0040|0293"
#define GKDCM_Quantity                             "0040|0294"
#define GKDCM_MeasuringUnitsSequence               "0040|0295"
#define GKDCM_BillingItemSequence                  "0040|0296"
#define GKDCM_TotalTimeOfFluoroscopy               "0040|0300"
#define GKDCM_TotalNumberOfExposures               "0040|0301"
#define GKDCM_EntranceDose                         "0040|0302"
#define GKDCM_ExposedArea                          "0040|0303"
#define GKDCM_DistanceSourceToEntrance             "0040|0306"
#define GKDCM_RETIRED_DistanceSourceToSupport      "0040|0307"
#define GKDCM_ExposureDoseSequence                 "0040|030e"
#define GKDCM_CommentsOnRadiationDose              "0040|0310"
#define GKDCM_XRayOutput                           "0040|0312"
#define GKDCM_HalfValueLayer                       "0040|0314"
#define GKDCM_OrganDose                            "0040|0316"
#define GKDCM_OrganExposed                         "0040|0318"
#define GKDCM_BillingProcedureStepSequence         "0040|0320"
#define GKDCM_FilmConsumptionSequence              "0040|0321"
#define GKDCM_BillingSuppliesAndDevicesSequence    "0040|0324"
#define GKDCM_RETIRED_ReferencedProcedureStepSequence "0040|0330"
#define GKDCM_PerformedSeriesSequence              "0040|0340"
#define GKDCM_CommentsOnTheScheduledProcedureStep  "0040|0400"
#define GKDCM_ProtocolContextSequence              "0040|0440"
#define GKDCM_ContentItemModifierSequence          "0040|0441"
#define GKDCM_ScheduledSpecimenSequence            "0040|0500"
#define GKDCM_RETIRED_SpecimenAccessionNumber      "0040|050a"
#define GKDCM_ContainerIdentifier                  "0040|0512"
#define GKDCM_IssuerOfTheContainerIdentifierSequence "0040|0513"
#define GKDCM_AlternateContainerIdentifierSequence "0040|0515"
#define GKDCM_ContainerTypeCodeSequence            "0040|0518"
#define GKDCM_ContainerDescription                 "0040|051a"
#define GKDCM_ContainerComponentSequence           "0040|0520"
#define GKDCM_RETIRED_SpecimenSequence             "0040|0550"
#define GKDCM_SpecimenIdentifier                   "0040|0551"
#define GKDCM_RETIRED_SpecimenDescriptionSequenceTrial "0040|0552"
#define GKDCM_RETIRED_SpecimenDescriptionTrial     "0040|0553"
#define GKDCM_SpecimenUID                          "0040|0554"
#define GKDCM_AcquisitionContextSequence           "0040|0555"
#define GKDCM_AcquisitionContextDescription        "0040|0556"
#define GKDCM_SpecimenDescriptionSequence          "0040|0560"
#define GKDCM_IssuerOfTheSpecimenIdentifierSequence "0040|0562"
#define GKDCM_SpecimenTypeCodeSequence             "0040|059a"
#define GKDCM_SpecimenShortDescription             "0040|0600"
#define GKDCM_SpecimenDetailedDescription          "0040|0602"
#define GKDCM_SpecimenPreparationSequence          "0040|0610"
#define GKDCM_SpecimenPreparationStepContentItemSequence "0040|0612"
#define GKDCM_SpecimenLocalizationContentItemSequence "0040|0620"
#define GKDCM_RETIRED_SlideIdentifier              "0040|06fa"
#define GKDCM_ImageCenterPointCoordinatesSequence  "0040|071a"
#define GKDCM_XOffsetInSlideCoordinateSystem       "0040|072a"
#define GKDCM_YOffsetInSlideCoordinateSystem       "0040|073a"
#define GKDCM_ZOffsetInSlideCoordinateSystem       "0040|074a"
#define GKDCM_RETIRED_PixelSpacingSequence         "0040|08d8"
#define GKDCM_RETIRED_CoordinateSystemAxisCodeSequence "0040|08da"
#define GKDCM_MeasurementUnitsCodeSequence         "0040|08ea"
#define GKDCM_RETIRED_VitalStainCodeSequenceTrial  "0040|09f8"
#define GKDCM_RequestedProcedureID                 "0040|1001"
#define GKDCM_ReasonForTheRequestedProcedure       "0040|1002"
#define GKDCM_RequestedProcedurePriority           "0040|1003"
#define GKDCM_PatientTransportArrangements         "0040|1004"
#define GKDCM_RequestedProcedureLocation           "0040|1005"
#define GKDCM_RETIRED_PlacerOrderNumberProcedure   "0040|1006"
#define GKDCM_RETIRED_FillerOrderNumberProcedure   "0040|1007"
#define GKDCM_ConfidentialityCode                  "0040|1008"
#define GKDCM_ReportingPriority                    "0040|1009"
#define GKDCM_ReasonForRequestedProcedureCodeSequence "0040|100a"
#define GKDCM_NamesOfIntendedRecipientsOfResults   "0040|1010"
#define GKDCM_IntendedRecipientsOfResultsIdentificationSequence "0040|1011"
#define GKDCM_ReasonForPerformedProcedureCodeSequence "0040|1012"
#define GKDCM_PersonIdentificationCodeSequence     "0040|1101"
#define GKDCM_PersonAddress                        "0040|1102"
#define GKDCM_PersonTelephoneNumbers               "0040|1103"
#define GKDCM_RequestedProcedureComments           "0040|1400"
#define GKDCM_RETIRED_ReasonForTheImagingServiceRequest "0040|2001"
#define GKDCM_IssueDateOfImagingServiceRequest     "0040|2004"
#define GKDCM_IssueTimeOfImagingServiceRequest     "0040|2005"
#define GKDCM_RETIRED_PlacerOrderNumberImagingServiceRequestRetired "0040|2006"
#define GKDCM_RETIRED_FillerOrderNumberImagingServiceRequestRetired "0040|2007"
#define GKDCM_OrderEnteredBy                       "0040|2008"
#define GKDCM_OrderEntererLocation                 "0040|2009"
#define GKDCM_OrderCallbackPhoneNumber             "0040|2010"
#define GKDCM_PlacerOrderNumberImagingServiceRequest "0040|2016"
#define GKDCM_FillerOrderNumberImagingServiceRequest "0040|2017"
#define GKDCM_ImagingServiceRequestComments        "0040|2400"
#define GKDCM_ConfidentialityConstraintOnPatientDataDescription "0040|3001"
#define GKDCM_GeneralPurposeScheduledProcedureStepStatus "0040|4001"
#define GKDCM_GeneralPurposePerformedProcedureStepStatus "0040|4002"
#define GKDCM_GeneralPurposeScheduledProcedureStepPriority "0040|4003"
#define GKDCM_ScheduledProcessingApplicationsCodeSequence "0040|4004"
#define GKDCM_ScheduledProcedureStepStartDateTime  "0040|4005"
#define GKDCM_MultipleCopiesFlag                   "0040|4006"
#define GKDCM_PerformedProcessingApplicationsCodeSequence "0040|4007"
#define GKDCM_HumanPerformerCodeSequence           "0040|4009"
#define GKDCM_ScheduledProcedureStepModificationDateTime "0040|4010"
#define GKDCM_ExpectedCompletionDateTime           "0040|4011"
#define GKDCM_ResultingGeneralPurposePerformedProcedureStepsSequence "0040|4015"
#define GKDCM_ReferencedGeneralPurposeScheduledProcedureStepSequence "0040|4016"
#define GKDCM_ScheduledWorkitemCodeSequence        "0040|4018"
#define GKDCM_PerformedWorkitemCodeSequence        "0040|4019"
#define GKDCM_InputAvailabilityFlag                "0040|4020"
#define GKDCM_InputInformationSequence             "0040|4021"
#define GKDCM_RelevantInformationSequence          "0040|4022"
#define GKDCM_ReferencedGeneralPurposeScheduledProcedureStepTransactionUID "0040|4023"
#define GKDCM_ScheduledStationNameCodeSequence     "0040|4025"
#define GKDCM_ScheduledStationClassCodeSequence    "0040|4026"
#define GKDCM_ScheduledStationGeographicLocationCodeSequence "0040|4027"
#define GKDCM_PerformedStationNameCodeSequence     "0040|4028"
#define GKDCM_PerformedStationClassCodeSequence    "0040|4029"
#define GKDCM_PerformedStationGeographicLocationCodeSequence "0040|4030"
#define GKDCM_RequestedSubsequentWorkitemCodeSequence "0040|4031"
#define GKDCM_NonDICOMOutputCodeSequence           "0040|4032"
#define GKDCM_OutputInformationSequence            "0040|4033"
#define GKDCM_ScheduledHumanPerformersSequence     "0040|4034"
#define GKDCM_ActualHumanPerformersSequence        "0040|4035"
#define GKDCM_HumanPerformerOrganization           "0040|4036"
#define GKDCM_HumanPerformerName                   "0040|4037"
#define GKDCM_RawDataHandling                      "0040|4040"
#define GKDCM_EntranceDoseInmGy                    "0040|8302"
#define GKDCM_ReferencedImageRealWorldValueMappingSequence "0040|9094"
#define GKDCM_RealWorldValueMappingSequence        "0040|9096"
#define GKDCM_PixelValueMappingCodeSequence        "0040|9098"
#define GKDCM_LUTLabel                             "0040|9210"
#define GKDCM_RealWorldValueLastValueMapped        "0040|9211"
#define GKDCM_RealWorldValueLUTData                "0040|9212"
#define GKDCM_RealWorldValueFirstValueMapped       "0040|9216"
#define GKDCM_RealWorldValueIntercept              "0040|9224"
#define GKDCM_RealWorldValueSlope                  "0040|9225"
#define GKDCM_RelationshipType                     "0040|a010"
#define GKDCM_VerifyingOrganization                "0040|a027"
#define GKDCM_VerificationDateTime                 "0040|a030"
#define GKDCM_ObservationDateTime                  "0040|a032"
#define GKDCM_ValueType                            "0040|a040"
#define GKDCM_ConceptNameCodeSequence              "0040|a043"
#define GKDCM_ContinuityOfContent                  "0040|a050"
#define GKDCM_VerifyingObserverSequence            "0040|a073"
#define GKDCM_VerifyingObserverName                "0040|a075"
#define GKDCM_AuthorObserverSequence               "0040|a078"
#define GKDCM_ParticipantSequence                  "0040|a07a"
#define GKDCM_CustodialOrganizationSequence        "0040|a07c"
#define GKDCM_ParticipationType                    "0040|a080"
#define GKDCM_ParticipationDateTime                "0040|a082"
#define GKDCM_ObserverType                         "0040|a084"
#define GKDCM_VerifyingObserverIdentificationCodeSequence "0040|a088"
#define GKDCM_RETIRED_EquivalentCDADocumentSequence "0040|a090"
#define GKDCM_ReferencedWaveformChannels           "0040|a0b0"
#define GKDCM_DateTime                             "0040|a120"
#define GKDCM_Date                                 "0040|a121"
#define GKDCM_Time                                 "0040|a122"
#define GKDCM_PersonName                           "0040|a123"
#define GKDCM_UID                                  "0040|a124"
#define GKDCM_TemporalRangeType                    "0040|a130"
#define GKDCM_ReferencedSamplePositions            "0040|a132"
#define GKDCM_ReferencedFrameNumbers               "0040|a136"
#define GKDCM_ReferencedTimeOffsets                "0040|a138"
#define GKDCM_ReferencedDateTime                   "0040|a13a"
#define GKDCM_TextValue                            "0040|a160"
#define GKDCM_ConceptCodeSequence                  "0040|a168"
#define GKDCM_PurposeOfReferenceCodeSequence       "0040|a170"
#define GKDCM_AnnotationGroupNumber                "0040|a180"
#define GKDCM_ModifierCodeSequence                 "0040|a195"
#define GKDCM_MeasuredValueSequence                "0040|a300"
#define GKDCM_NumericValueQualifierCodeSequence    "0040|a301"
#define GKDCM_NumericValue                         "0040|a30a"
#define GKDCM_RETIRED_AddressTrial                 "0040|a353"
#define GKDCM_RETIRED_TelephoneNumberTrial         "0040|a354"
#define GKDCM_PredecessorDocumentsSequence         "0040|a360"
#define GKDCM_ReferencedRequestSequence            "0040|a370"
#define GKDCM_PerformedProcedureCodeSequence       "0040|a372"
#define GKDCM_CurrentRequestedProcedureEvidenceSequence "0040|a375"
#define GKDCM_PertinentOtherEvidenceSequence       "0040|a385"
#define GKDCM_HL7StructuredDocumentReferenceSequence "0040|a390"
#define GKDCM_CompletionFlag                       "0040|a491"
#define GKDCM_CompletionFlagDescription            "0040|a492"
#define GKDCM_VerificationFlag                     "0040|a493"
#define GKDCM_ArchiveRequested                     "0040|a494"
#define GKDCM_PreliminaryFlag                      "0040|a496"
#define GKDCM_ContentTemplateSequence              "0040|a504"
#define GKDCM_IdenticalDocumentsSequence           "0040|a525"
#define GKDCM_ContentSequence                      "0040|a730"
#define GKDCM_WaveformAnnotationSequence           "0040|b020"
#define GKDCM_TemplateIdentifier                   "0040|db00"
#define GKDCM_RETIRED_TemplateVersion              "0040|db06"
#define GKDCM_RETIRED_TemplateLocalVersion         "0040|db07"
#define GKDCM_RETIRED_TemplateExtensionFlag        "0040|db0b"
#define GKDCM_RETIRED_TemplateExtensionOrganizationUID "0040|db0c"
#define GKDCM_RETIRED_TemplateExtensionCreatorUID  "0040|db0d"
#define GKDCM_ReferencedContentItemIdentifier      "0040|db73"
#define GKDCM_HL7InstanceIdentifier                "0040|e001"
#define GKDCM_HL7DocumentEffectiveTime             "0040|e004"
#define GKDCM_HL7DocumentTypeCodeSequence          "0040|e006"
#define GKDCM_RetrieveURI                          "0040|e010"
#define GKDCM_RetrieveLocationUID                  "0040|e011"
#define GKDCM_DocumentTitle                        "0042|0010"
#define GKDCM_EncapsulatedDocument                 "0042|0011"
#define GKDCM_MIMETypeOfEncapsulatedDocument       "0042|0012"
#define GKDCM_SourceInstanceSequence               "0042|0013"
#define GKDCM_ListOfMIMETypes                      "0042|0014"
#define GKDCM_ProductPackageIdentifier             "0044|0001"
#define GKDCM_SubstanceAdministrationApproval      "0044|0002"
#define GKDCM_ApprovalStatusFurtherDescription     "0044|0003"
#define GKDCM_ApprovalStatusDateTime               "0044|0004"
#define GKDCM_ProductTypeCodeSequence              "0044|0007"
#define GKDCM_ProductName                          "0044|0008"
#define GKDCM_ProductDescription                   "0044|0009"
#define GKDCM_ProductLotIdentifier                 "0044|000a"
#define GKDCM_ProductExpirationDateTime            "0044|000b"
#define GKDCM_SubstanceAdministrationDateTime      "0044|0010"
#define GKDCM_SubstanceAdministrationNotes         "0044|0011"
#define GKDCM_SubstanceAdministrationDeviceID      "0044|0012"
#define GKDCM_ProductParameterSequence             "0044|0013"
#define GKDCM_SubstanceAdministrationParameterSequence "0044|0019"
#define GKDCM_LensDescription                      "0046|0012"
#define GKDCM_RightLensSequence                    "0046|0014"
#define GKDCM_LeftLensSequence                     "0046|0015"
#define GKDCM_UnspecifiedLateralityLensSequence    "0046|0016"
#define GKDCM_CylinderSequence                     "0046|0018"
#define GKDCM_PrismSequence                        "0046|0028"
#define GKDCM_HorizontalPrismPower                 "0046|0030"
#define GKDCM_HorizontalPrismBase                  "0046|0032"
#define GKDCM_VerticalPrismPower                   "0046|0034"
#define GKDCM_VerticalPrismBase                    "0046|0036"
#define GKDCM_LensSegmentType                      "0046|0038"
#define GKDCM_OpticalTransmittance                 "0046|0040"
#define GKDCM_ChannelWidth                         "0046|0042"
#define GKDCM_PupilSize                            "0046|0044"
#define GKDCM_CornealSize                          "0046|0046"
#define GKDCM_AutorefractionRightEyeSequence       "0046|0050"
#define GKDCM_AutorefractionLeftEyeSequence        "0046|0052"
#define GKDCM_DistancePupillaryDistance            "0046|0060"
#define GKDCM_NearPupillaryDistance                "0046|0062"
#define GKDCM_IntermediatePupillaryDistance        "0046|0063"
#define GKDCM_OtherPupillaryDistance               "0046|0064"
#define GKDCM_KeratometryRightEyeSequence          "0046|0070"
#define GKDCM_KeratometryLeftEyeSequence           "0046|0071"
#define GKDCM_SteepKeratometricAxisSequence        "0046|0074"
#define GKDCM_RadiusOfCurvature                    "0046|0075"
#define GKDCM_KeratometricPower                    "0046|0076"
#define GKDCM_KeratometricAxis                     "0046|0077"
#define GKDCM_FlatKeratometricAxisSequence         "0046|0080"
#define GKDCM_BackgroundColor                      "0046|0092"
#define GKDCM_Optotype                             "0046|0094"
#define GKDCM_OptotypePresentation                 "0046|0095"
#define GKDCM_SubjectiveRefractionRightEyeSequence "0046|0097"
#define GKDCM_SubjectiveRefractionLeftEyeSequence  "0046|0098"
#define GKDCM_AddNearSequence                      "0046|0100"
#define GKDCM_AddIntermediateSequence              "0046|0101"
#define GKDCM_AddOtherSequence                     "0046|0102"
#define GKDCM_AddPower                             "0046|0104"
#define GKDCM_ViewingDistance                      "0046|0106"
#define GKDCM_VisualAcuityTypeCodeSequence         "0046|0121"
#define GKDCM_VisualAcuityRightEyeSequence         "0046|0122"
#define GKDCM_VisualAcuityLeftEyeSequence          "0046|0123"
#define GKDCM_VisualAcuityBothEyesOpenSequence     "0046|0124"
#define GKDCM_ViewingDistanceType                  "0046|0125"
#define GKDCM_VisualAcuityModifiers                "0046|0135"
#define GKDCM_DecimalVisualAcuity                  "0046|0137"
#define GKDCM_OptotypeDetailedDefinition           "0046|0139"
#define GKDCM_ReferencedRefractiveMeasurementsSequence "0046|0145"
#define GKDCM_SpherePower                          "0046|0146"
#define GKDCM_CylinderPower                        "0046|0147"
#define GKDCM_ImagedVolumeWidth                    "0048|0001"
#define GKDCM_ImagedVolumeHeight                   "0048|0002"
#define GKDCM_ImagedVolumeDepth                    "0048|0003"
#define GKDCM_TotalPixelMatrixColumns              "0048|0006"
#define GKDCM_TotalPixelMatrixRows                 "0048|0007"
#define GKDCM_TotalPixelMatrixOriginSequence       "0048|0008"
#define GKDCM_SpecimenLabelInImage                 "0048|0010"
#define GKDCM_FocusMethod                          "0048|0011"
#define GKDCM_ExtendedDepthOfField                 "0048|0012"
#define GKDCM_NumberOfFocalPlanes                  "0048|0013"
#define GKDCM_DistanceBetweenFocalPlanes           "0048|0014"
#define GKDCM_RecommendedAbsentPixelCIELabValue    "0048|0015"
#define GKDCM_IlluminatorTypeCodeSequence          "0048|0100"
#define GKDCM_ImageOrientationSlide                "0048|0102"
#define GKDCM_OpticalPathSequence                  "0048|0105"
#define GKDCM_OpticalPathIdentifier                "0048|0106"
#define GKDCM_OpticalPathDescription               "0048|0107"
#define GKDCM_IlluminationColorCodeSequence        "0048|0108"
#define GKDCM_SpecimenReferenceSequence            "0048|0110"
#define GKDCM_CondenserLensPower                   "0048|0111"
#define GKDCM_ObjectiveLensPower                   "0048|0112"
#define GKDCM_ObjectiveLensNumericalAperture       "0048|0113"
#define GKDCM_PaletteColorLookupTableSequence      "0048|0120"
#define GKDCM_ReferencedImageNavigationSequence    "0048|0200"
#define GKDCM_TopLeftHandCornerOfLocalizerArea     "0048|0201"
#define GKDCM_BottomRightHandCornerOfLocalizerArea "0048|0202"
#define GKDCM_OpticalPathIdentificationSequence    "0048|0207"
#define GKDCM_PlanePositionSlideSequence           "0048|021a"
#define GKDCM_ColumnPositionInTotalImagePixelMatrix "0048|021e"
#define GKDCM_RowPositionInTotalImagePixelMatrix   "0048|021f"
#define GKDCM_PixelOriginInterpretation            "0048|0301"
#define GKDCM_CalibrationImage                     "0050|0004"
#define GKDCM_DeviceSequence                       "0050|0010"
#define GKDCM_ContainerComponentTypeCodeSequence   "0050|0012"
#define GKDCM_ContainerComponentThickness          "0050|0013"
#define GKDCM_DeviceLength                         "0050|0014"
#define GKDCM_ContainerComponentWidth              "0050|0015"
#define GKDCM_DeviceDiameter                       "0050|0016"
#define GKDCM_DeviceDiameterUnits                  "0050|0017"
#define GKDCM_DeviceVolume                         "0050|0018"
#define GKDCM_InterMarkerDistance                  "0050|0019"
#define GKDCM_ContainerComponentMaterial           "0050|001a"
#define GKDCM_ContainerComponentID                 "0050|001b"
#define GKDCM_ContainerComponentLength             "0050|001c"
#define GKDCM_ContainerComponentDiameter           "0050|001d"
#define GKDCM_ContainerComponentDescription        "0050|001e"
#define GKDCM_DeviceDescription                    "0050|0020"
#define GKDCM_EnergyWindowVector                   "0054|0010"
#define GKDCM_NumberOfEnergyWindows                "0054|0011"
#define GKDCM_EnergyWindowInformationSequence      "0054|0012"
#define GKDCM_EnergyWindowRangeSequence            "0054|0013"
#define GKDCM_EnergyWindowLowerLimit               "0054|0014"
#define GKDCM_EnergyWindowUpperLimit               "0054|0015"
#define GKDCM_RadiopharmaceuticalInformationSequence "0054|0016"
#define GKDCM_ResidualSyringeCounts                "0054|0017"
#define GKDCM_EnergyWindowName                     "0054|0018"
#define GKDCM_DetectorVector                       "0054|0020"
#define GKDCM_NumberOfDetectors                    "0054|0021"
#define GKDCM_DetectorInformationSequence          "0054|0022"
#define GKDCM_PhaseVector                          "0054|0030"
#define GKDCM_NumberOfPhases                       "0054|0031"
#define GKDCM_PhaseInformationSequence             "0054|0032"
#define GKDCM_NumberOfFramesInPhase                "0054|0033"
#define GKDCM_PhaseDelay                           "0054|0036"
#define GKDCM_PauseBetweenFrames                   "0054|0038"
#define GKDCM_PhaseDescription                     "0054|0039"
#define GKDCM_RotationVector                       "0054|0050"
#define GKDCM_NumberOfRotations                    "0054|0051"
#define GKDCM_RotationInformationSequence          "0054|0052"
#define GKDCM_NumberOfFramesInRotation             "0054|0053"
#define GKDCM_RRIntervalVector                     "0054|0060"
#define GKDCM_NumberOfRRIntervals                  "0054|0061"
#define GKDCM_GatedInformationSequence             "0054|0062"
#define GKDCM_DataInformationSequence              "0054|0063"
#define GKDCM_TimeSlotVector                       "0054|0070"
#define GKDCM_NumberOfTimeSlots                    "0054|0071"
#define GKDCM_TimeSlotInformationSequence          "0054|0072"
#define GKDCM_TimeSlotTime                         "0054|0073"
#define GKDCM_SliceVector                          "0054|0080"
#define GKDCM_NumberOfSlices                       "0054|0081"
#define GKDCM_AngularViewVector                    "0054|0090"
#define GKDCM_TimeSliceVector                      "0054|0100"
#define GKDCM_NumberOfTimeSlices                   "0054|0101"
#define GKDCM_StartAngle                           "0054|0200"
#define GKDCM_TypeOfDetectorMotion                 "0054|0202"
#define GKDCM_TriggerVector                        "0054|0210"
#define GKDCM_NumberOfTriggersInPhase              "0054|0211"
#define GKDCM_ViewCodeSequence                     "0054|0220"
#define GKDCM_ViewModifierCodeSequence             "0054|0222"
#define GKDCM_RadionuclideCodeSequence             "0054|0300"
#define GKDCM_AdministrationRouteCodeSequence      "0054|0302"
#define GKDCM_RadiopharmaceuticalCodeSequence      "0054|0304"
#define GKDCM_CalibrationDataSequence              "0054|0306"
#define GKDCM_EnergyWindowNumber                   "0054|0308"
#define GKDCM_ImageID                              "0054|0400"
#define GKDCM_PatientOrientationCodeSequence       "0054|0410"
#define GKDCM_PatientOrientationModifierCodeSequence "0054|0412"
#define GKDCM_PatientGantryRelationshipCodeSequence "0054|0414"
#define GKDCM_SliceProgressionDirection            "0054|0500"
#define GKDCM_SeriesType                           "0054|1000"
#define GKDCM_Units                                "0054|1001"
#define GKDCM_CountsSource                         "0054|1002"
#define GKDCM_ReprojectionMethod                   "0054|1004"
#define GKDCM_RandomsCorrectionMethod              "0054|1100"
#define GKDCM_AttenuationCorrectionMethod          "0054|1101"
#define GKDCM_DecayCorrection                      "0054|1102"
#define GKDCM_ReconstructionMethod                 "0054|1103"
#define GKDCM_DetectorLinesOfResponseUsed          "0054|1104"
#define GKDCM_ScatterCorrectionMethod              "0054|1105"
#define GKDCM_AxialAcceptance                      "0054|1200"
#define GKDCM_AxialMash                            "0054|1201"
#define GKDCM_TransverseMash                       "0054|1202"
#define GKDCM_DetectorElementSize                  "0054|1203"
#define GKDCM_CoincidenceWindowWidth               "0054|1210"
#define GKDCM_SecondaryCountsType                  "0054|1220"
#define GKDCM_FrameReferenceTime                   "0054|1300"
#define GKDCM_PrimaryPromptsCountsAccumulated      "0054|1310"
#define GKDCM_SecondaryCountsAccumulated           "0054|1311"
#define GKDCM_SliceSensitivityFactor               "0054|1320"
#define GKDCM_DecayFactor                          "0054|1321"
#define GKDCM_DoseCalibrationFactor                "0054|1322"
#define GKDCM_ScatterFractionFactor                "0054|1323"
#define GKDCM_DeadTimeFactor                       "0054|1324"
#define GKDCM_ImageIndex                           "0054|1330"
#define GKDCM_RETIRED_CountsIncluded               "0054|1400"
#define GKDCM_RETIRED_DeadTimeCorrectionFlag       "0054|1401"
#define GKDCM_HistogramSequence                    "0060|3000"
#define GKDCM_HistogramNumberOfBins                "0060|3002"
#define GKDCM_HistogramFirstBinValue               "0060|3004"
#define GKDCM_HistogramLastBinValue                "0060|3006"
#define GKDCM_HistogramBinWidth                    "0060|3008"
#define GKDCM_HistogramExplanation                 "0060|3010"
#define GKDCM_HistogramData                        "0060|3020"
#define GKDCM_SegmentationType                     "0062|0001"
#define GKDCM_SegmentSequence                      "0062|0002"
#define GKDCM_SegmentedPropertyCategoryCodeSequence "0062|0003"
#define GKDCM_SegmentNumber                        "0062|0004"
#define GKDCM_SegmentLabel                         "0062|0005"
#define GKDCM_SegmentDescription                   "0062|0006"
#define GKDCM_SegmentAlgorithmType                 "0062|0008"
#define GKDCM_SegmentAlgorithmName                 "0062|0009"
#define GKDCM_SegmentIdentificationSequence        "0062|000a"
#define GKDCM_ReferencedSegmentNumber              "0062|000b"
#define GKDCM_RecommendedDisplayGrayscaleValue     "0062|000c"
#define GKDCM_RecommendedDisplayCIELabValue        "0062|000d"
#define GKDCM_MaximumFractionalValue               "0062|000e"
#define GKDCM_SegmentedPropertyTypeCodeSequence    "0062|000f"
#define GKDCM_SegmentationFractionalType           "0062|0010"
#define GKDCM_DeformableRegistrationSequence       "0064|0002"
#define GKDCM_SourceFrameOfReferenceUID            "0064|0003"
#define GKDCM_DeformableRegistrationGridSequence   "0064|0005"
#define GKDCM_GridDimensions                       "0064|0007"
#define GKDCM_GridResolution                       "0064|0008"
#define GKDCM_VectorGridData                       "0064|0009"
#define GKDCM_PreDeformationMatrixRegistrationSequence "0064|000f"
#define GKDCM_PostDeformationMatrixRegistrationSequence "0064|0010"
#define GKDCM_NumberOfSurfaces                     "0066|0001"
#define GKDCM_SurfaceSequence                      "0066|0002"
#define GKDCM_SurfaceNumber                        "0066|0003"
#define GKDCM_SurfaceComments                      "0066|0004"
#define GKDCM_SurfaceProcessing                    "0066|0009"
#define GKDCM_SurfaceProcessingRatio               "0066|000a"
#define GKDCM_SurfaceProcessingDescription         "0066|000b"
#define GKDCM_RecommendedPresentationOpacity       "0066|000c"
#define GKDCM_RecommendedPresentationType          "0066|000d"
#define GKDCM_FiniteVolume                         "0066|000e"
#define GKDCM_Manifold                             "0066|0010"
#define GKDCM_SurfacePointsSequence                "0066|0011"
#define GKDCM_SurfacePointsNormalsSequence         "0066|0012"
#define GKDCM_SurfaceMeshPrimitivesSequence        "0066|0013"
#define GKDCM_NumberOfSurfacePoints                "0066|0015"
#define GKDCM_PointCoordinatesData                 "0066|0016"
#define GKDCM_PointPositionAccuracy                "0066|0017"
#define GKDCM_MeanPointDistance                    "0066|0018"
#define GKDCM_MaximumPointDistance                 "0066|0019"
#define GKDCM_PointsBoundingBoxCoordinates         "0066|001a"
#define GKDCM_AxisOfRotation                       "0066|001b"
#define GKDCM_CenterOfRotation                     "0066|001c"
#define GKDCM_NumberOfVectors                      "0066|001e"
#define GKDCM_VectorDimensionality                 "0066|001f"
#define GKDCM_VectorAccuracy                       "0066|0020"
#define GKDCM_VectorCoordinateData                 "0066|0021"
#define GKDCM_TrianglePointIndexList               "0066|0023"
#define GKDCM_EdgePointIndexList                   "0066|0024"
#define GKDCM_VertexPointIndexList                 "0066|0025"
#define GKDCM_TriangleStripSequence                "0066|0026"
#define GKDCM_TriangleFanSequence                  "0066|0027"
#define GKDCM_LineSequence                         "0066|0028"
#define GKDCM_PrimitivePointIndexList              "0066|0029"
#define GKDCM_SurfaceCount                         "0066|002a"
#define GKDCM_ReferencedSurfaceSequence            "0066|002b"
#define GKDCM_ReferencedSurfaceNumber              "0066|002c"
#define GKDCM_SegmentSurfaceGenerationAlgorithmIdentificationSequence "0066|002d"
#define GKDCM_SegmentSurfaceSourceInstanceSequence "0066|002e"
#define GKDCM_AlgorithmFamilyCodeSequence          "0066|002f"
#define GKDCM_AlgorithmNameCodeSequence            "0066|0030"
#define GKDCM_AlgorithmVersion                     "0066|0031"
#define GKDCM_AlgorithmParameters                  "0066|0032"
#define GKDCM_FacetSequence                        "0066|0034"
#define GKDCM_SurfaceProcessingAlgorithmIdentificationSequence "0066|0035"
#define GKDCM_AlgorithmName                        "0066|0036"
#define GKDCM_ImplantSize                          "0068|6210"
#define GKDCM_ImplantTemplateVersion               "0068|6221"
#define GKDCM_ReplacedImplantTemplateSequence      "0068|6222"
#define GKDCM_ImplantType                          "0068|6223"
#define GKDCM_DerivationImplantTemplateSequence    "0068|6224"
#define GKDCM_OriginalImplantTemplateSequence      "0068|6225"
#define GKDCM_EffectiveDateTime                    "0068|6226"
#define GKDCM_ImplantTargetAnatomySequence         "0068|6230"
#define GKDCM_InformationFromManufacturerSequence  "0068|6260"
#define GKDCM_NotificationFromManufacturerSequence "0068|6265"
#define GKDCM_InformationIssueDateTime             "0068|6270"
#define GKDCM_InformationSummary                   "0068|6280"
#define GKDCM_ImplantRegulatoryDisapprovalCodeSequence "0068|62a0"
#define GKDCM_OverallTemplateSpatialTolerance      "0068|62a5"
#define GKDCM_HPGLDocumentSequence                 "0068|62c0"
#define GKDCM_HPGLDocumentID                       "0068|62d0"
#define GKDCM_HPGLDocumentLabel                    "0068|62d5"
#define GKDCM_ViewOrientationCodeSequence          "0068|62e0"
#define GKDCM_ViewOrientationModifier              "0068|62f0"
#define GKDCM_HPGLDocumentScaling                  "0068|62f2"
#define GKDCM_HPGLDocument                         "0068|6300"
#define GKDCM_HPGLContourPenNumber                 "0068|6310"
#define GKDCM_HPGLPenSequence                      "0068|6320"
#define GKDCM_HPGLPenNumber                        "0068|6330"
#define GKDCM_HPGLPenLabel                         "0068|6340"
#define GKDCM_HPGLPenDescription                   "0068|6345"
#define GKDCM_RecommendedRotationPoint             "0068|6346"
#define GKDCM_BoundingRectangle                    "0068|6347"
#define GKDCM_ImplantTemplate3DModelSurfaceNumber  "0068|6350"
#define GKDCM_SurfaceModelDescriptionSequence      "0068|6360"
#define GKDCM_SurfaceModelLabel                    "0068|6380"
#define GKDCM_SurfaceModelScalingFactor            "0068|6390"
#define GKDCM_MaterialsCodeSequence                "0068|63a0"
#define GKDCM_CoatingMaterialsCodeSequence         "0068|63a4"
#define GKDCM_ImplantTypeCodeSequence              "0068|63a8"
#define GKDCM_FixationMethodCodeSequence           "0068|63ac"
#define GKDCM_MatingFeatureSetsSequence            "0068|63b0"
#define GKDCM_MatingFeatureSetID                   "0068|63c0"
#define GKDCM_MatingFeatureSetLabel                "0068|63d0"
#define GKDCM_MatingFeatureSequence                "0068|63e0"
#define GKDCM_MatingFeatureID                      "0068|63f0"
#define GKDCM_MatingFeatureDegreeOfFreedomSequence "0068|6400"
#define GKDCM_DegreeOfFreedomID                    "0068|6410"
#define GKDCM_DegreeOfFreedomType                  "0068|6420"
#define GKDCM_TwoDMatingFeatureCoordinatesSequence "0068|6430"
#define GKDCM_ReferencedHPGLDocumentID             "0068|6440"
#define GKDCM_TwoDMatingPoint                      "0068|6450"
#define GKDCM_TwoDMatingAxes                       "0068|6460"
#define GKDCM_TwoDDegreeOfFreedomSequence          "0068|6470"
#define GKDCM_ThreeDDegreeOfFreedomAxis            "0068|6490"
#define GKDCM_RangeOfFreedom                       "0068|64a0"
#define GKDCM_ThreeDMatingPoint                    "0068|64c0"
#define GKDCM_ThreeDMatingAxes                     "0068|64d0"
#define GKDCM_TwoDDegreeOfFreedomAxis              "0068|64f0"
#define GKDCM_PlanningLandmarkPointSequence        "0068|6500"
#define GKDCM_PlanningLandmarkLineSequence         "0068|6510"
#define GKDCM_PlanningLandmarkPlaneSequence        "0068|6520"
#define GKDCM_PlanningLandmarkID                   "0068|6530"
#define GKDCM_PlanningLandmarkDescription          "0068|6540"
#define GKDCM_PlanningLandmarkIdentificationCodeSequence "0068|6545"
#define GKDCM_TwoDPointCoordinatesSequence         "0068|6550"
#define GKDCM_TwoDPointCoordinates                 "0068|6560"
#define GKDCM_ThreeDPointCoordinates               "0068|6590"
#define GKDCM_TwoDLineCoordinatesSequence          "0068|65a0"
#define GKDCM_TwoDLineCoordinates                  "0068|65b0"
#define GKDCM_ThreeDLineCoordinates                "0068|65d0"
#define GKDCM_TwoDPlaneCoordinatesSequence         "0068|65e0"
#define GKDCM_TwoDPlaneIntersection                "0068|65f0"
#define GKDCM_ThreeDPlaneOrigin                    "0068|6610"
#define GKDCM_ThreeDPlaneNormal                    "0068|6620"
#define GKDCM_GraphicAnnotationSequence            "0070|0001"
#define GKDCM_GraphicLayer                         "0070|0002"
#define GKDCM_BoundingBoxAnnotationUnits           "0070|0003"
#define GKDCM_AnchorPointAnnotationUnits           "0070|0004"
#define GKDCM_GraphicAnnotationUnits               "0070|0005"
#define GKDCM_UnformattedTextValue                 "0070|0006"
#define GKDCM_TextObjectSequence                   "0070|0008"
#define GKDCM_GraphicObjectSequence                "0070|0009"
#define GKDCM_BoundingBoxTopLeftHandCorner         "0070|0010"
#define GKDCM_BoundingBoxBottomRightHandCorner     "0070|0011"
#define GKDCM_BoundingBoxTextHorizontalJustification "0070|0012"
#define GKDCM_AnchorPoint                          "0070|0014"
#define GKDCM_AnchorPointVisibility                "0070|0015"
#define GKDCM_GraphicDimensions                    "0070|0020"
#define GKDCM_NumberOfGraphicPoints                "0070|0021"
#define GKDCM_GraphicData                          "0070|0022"
#define GKDCM_GraphicType                          "0070|0023"
#define GKDCM_GraphicFilled                        "0070|0024"
#define GKDCM_RETIRED_ImageRotationRetired         "0070|0040"
#define GKDCM_ImageHorizontalFlip                  "0070|0041"
#define GKDCM_ImageRotation                        "0070|0042"
#define GKDCM_RETIRED_DisplayedAreaTopLeftHandCornerTrial "0070|0050"
#define GKDCM_RETIRED_DisplayedAreaBottomRightHandCornerTrial "0070|0051"
#define GKDCM_DisplayedAreaTopLeftHandCorner       "0070|0052"
#define GKDCM_DisplayedAreaBottomRightHandCorner   "0070|0053"
#define GKDCM_DisplayedAreaSelectionSequence       "0070|005a"
#define GKDCM_GraphicLayerSequence                 "0070|0060"
#define GKDCM_GraphicLayerOrder                    "0070|0062"
#define GKDCM_GraphicLayerRecommendedDisplayGrayscaleValue "0070|0066"
#define GKDCM_RETIRED_GraphicLayerRecommendedDisplayRGBValue "0070|0067"
#define GKDCM_GraphicLayerDescription              "0070|0068"
#define GKDCM_ContentLabel                         "0070|0080"
#define GKDCM_ContentDescription                   "0070|0081"
#define GKDCM_PresentationCreationDate             "0070|0082"
#define GKDCM_PresentationCreationTime             "0070|0083"
#define GKDCM_ContentCreatorName                   "0070|0084"
#define GKDCM_ContentCreatorIdentificationCodeSequence "0070|0086"
#define GKDCM_AlternateContentDescriptionSequence  "0070|0087"
#define GKDCM_PresentationSizeMode                 "0070|0100"
#define GKDCM_PresentationPixelSpacing             "0070|0101"
#define GKDCM_PresentationPixelAspectRatio         "0070|0102"
#define GKDCM_PresentationPixelMagnificationRatio  "0070|0103"
#define GKDCM_GraphicGroupLabel                    "0070|0207"
#define GKDCM_GraphicGroupDescription              "0070|0208"
#define GKDCM_CompoundGraphicSequence              "0070|0209"
#define GKDCM_CompoundGraphicInstanceID            "0070|0226"
#define GKDCM_FontName                             "0070|0227"
#define GKDCM_FontNameType                         "0070|0228"
#define GKDCM_CSSFontName                          "0070|0229"
#define GKDCM_RotationAngle                        "0070|0230"
#define GKDCM_TextStyleSequence                    "0070|0231"
#define GKDCM_LineStyleSequence                    "0070|0232"
#define GKDCM_FillStyleSequence                    "0070|0233"
#define GKDCM_GraphicGroupSequence                 "0070|0234"
#define GKDCM_TextColorCIELabValue                 "0070|0241"
#define GKDCM_HorizontalAlignment                  "0070|0242"
#define GKDCM_VerticalAlignment                    "0070|0243"
#define GKDCM_ShadowStyle                          "0070|0244"
#define GKDCM_ShadowOffsetX                        "0070|0245"
#define GKDCM_ShadowOffsetY                        "0070|0246"
#define GKDCM_ShadowColorCIELabValue               "0070|0247"
#define GKDCM_Underlined                           "0070|0248"
#define GKDCM_Bold                                 "0070|0249"
#define GKDCM_Italic                               "0070|0250"
#define GKDCM_PatternOnColorCIELabValue            "0070|0251"
#define GKDCM_PatternOffColorCIELabValue           "0070|0252"
#define GKDCM_LineThickness                        "0070|0253"
#define GKDCM_LineDashingStyle                     "0070|0254"
#define GKDCM_LinePattern                          "0070|0255"
#define GKDCM_FillPattern                          "0070|0256"
#define GKDCM_FillMode                             "0070|0257"
#define GKDCM_ShadowOpacity                        "0070|0258"
#define GKDCM_GapLength                            "0070|0261"
#define GKDCM_DiameterOfVisibility                 "0070|0262"
#define GKDCM_RotationPoint                        "0070|0273"
#define GKDCM_TickAlignment                        "0070|0274"
#define GKDCM_ShowTickLabel                        "0070|0278"
#define GKDCM_TickLabelAlignment                   "0070|0279"
#define GKDCM_CompoundGraphicUnits                 "0070|0282"
#define GKDCM_PatternOnOpacity                     "0070|0284"
#define GKDCM_PatternOffOpacity                    "0070|0285"
#define GKDCM_MajorTicksSequence                   "0070|0287"
#define GKDCM_TickPosition                         "0070|0288"
#define GKDCM_TickLabel                            "0070|0289"
#define GKDCM_CompoundGraphicType                  "0070|0294"
#define GKDCM_GraphicGroupID                       "0070|0295"
#define GKDCM_ShapeType                            "0070|0306"
#define GKDCM_RegistrationSequence                 "0070|0308"
#define GKDCM_MatrixRegistrationSequence           "0070|0309"
#define GKDCM_MatrixSequence                       "0070|030a"
#define GKDCM_FrameOfReferenceTransformationMatrixType "0070|030c"
#define GKDCM_RegistrationTypeCodeSequence         "0070|030d"
#define GKDCM_FiducialDescription                  "0070|030f"
#define GKDCM_FiducialIdentifier                   "0070|0310"
#define GKDCM_FiducialIdentifierCodeSequence       "0070|0311"
#define GKDCM_ContourUncertaintyRadius             "0070|0312"
#define GKDCM_UsedFiducialsSequence                "0070|0314"
#define GKDCM_GraphicCoordinatesDataSequence       "0070|0318"
#define GKDCM_FiducialUID                          "0070|031a"
#define GKDCM_FiducialSetSequence                  "0070|031c"
#define GKDCM_FiducialSequence                     "0070|031e"
#define GKDCM_GraphicLayerRecommendedDisplayCIELabValue "0070|0401"
#define GKDCM_BlendingSequence                     "0070|0402"
#define GKDCM_RelativeOpacity                      "0070|0403"
#define GKDCM_ReferencedSpatialRegistrationSequence "0070|0404"
#define GKDCM_BlendingPosition                     "0070|0405"
#define GKDCM_HangingProtocolName                  "0072|0002"
#define GKDCM_HangingProtocolDescription           "0072|0004"
#define GKDCM_HangingProtocolLevel                 "0072|0006"
#define GKDCM_HangingProtocolCreator               "0072|0008"
#define GKDCM_HangingProtocolCreationDateTime      "0072|000a"
#define GKDCM_HangingProtocolDefinitionSequence    "0072|000c"
#define GKDCM_HangingProtocolUserIdentificationCodeSequence "0072|000e"
#define GKDCM_HangingProtocolUserGroupName         "0072|0010"
#define GKDCM_SourceHangingProtocolSequence        "0072|0012"
#define GKDCM_NumberOfPriorsReferenced             "0072|0014"
#define GKDCM_ImageSetsSequence                    "0072|0020"
#define GKDCM_ImageSetSelectorSequence             "0072|0022"
#define GKDCM_ImageSetSelectorUsageFlag            "0072|0024"
#define GKDCM_SelectorAttribute                    "0072|0026"
#define GKDCM_SelectorValueNumber                  "0072|0028"
#define GKDCM_TimeBasedImageSetsSequence           "0072|0030"
#define GKDCM_ImageSetNumber                       "0072|0032"
#define GKDCM_ImageSetSelectorCategory             "0072|0034"
#define GKDCM_RelativeTime                         "0072|0038"
#define GKDCM_RelativeTimeUnits                    "0072|003a"
#define GKDCM_AbstractPriorValue                   "0072|003c"
#define GKDCM_AbstractPriorCodeSequence            "0072|003e"
#define GKDCM_ImageSetLabel                        "0072|0040"
#define GKDCM_SelectorAttributeVR                  "0072|0050"
#define GKDCM_SelectorSequencePointer              "0072|0052"
#define GKDCM_SelectorSequencePointerPrivateCreator "0072|0054"
#define GKDCM_SelectorAttributePrivateCreator      "0072|0056"
#define GKDCM_SelectorATValue                      "0072|0060"
#define GKDCM_SelectorCSValue                      "0072|0062"
#define GKDCM_SelectorISValue                      "0072|0064"
#define GKDCM_SelectorLOValue                      "0072|0066"
#define GKDCM_SelectorLTValue                      "0072|0068"
#define GKDCM_SelectorPNValue                      "0072|006a"
#define GKDCM_SelectorSHValue                      "0072|006c"
#define GKDCM_SelectorSTValue                      "0072|006e"
#define GKDCM_SelectorUTValue                      "0072|0070"
#define GKDCM_SelectorDSValue                      "0072|0072"
#define GKDCM_SelectorFDValue                      "0072|0074"
#define GKDCM_SelectorFLValue                      "0072|0076"
#define GKDCM_SelectorULValue                      "0072|0078"
#define GKDCM_SelectorUSValue                      "0072|007a"
#define GKDCM_SelectorSLValue                      "0072|007c"
#define GKDCM_SelectorSSValue                      "0072|007e"
#define GKDCM_SelectorCodeSequenceValue            "0072|0080"
#define GKDCM_NumberOfScreens                      "0072|0100"
#define GKDCM_NominalScreenDefinitionSequence      "0072|0102"
#define GKDCM_NumberOfVerticalPixels               "0072|0104"
#define GKDCM_NumberOfHorizontalPixels             "0072|0106"
#define GKDCM_DisplayEnvironmentSpatialPosition    "0072|0108"
#define GKDCM_ScreenMinimumGrayscaleBitDepth       "0072|010a"
#define GKDCM_ScreenMinimumColorBitDepth           "0072|010c"
#define GKDCM_ApplicationMaximumRepaintTime        "0072|010e"
#define GKDCM_DisplaySetsSequence                  "0072|0200"
#define GKDCM_DisplaySetNumber                     "0072|0202"
#define GKDCM_DisplaySetLabel                      "0072|0203"
#define GKDCM_DisplaySetPresentationGroup          "0072|0204"
#define GKDCM_DisplaySetPresentationGroupDescription "0072|0206"
#define GKDCM_PartialDataDisplayHandling           "0072|0208"
#define GKDCM_SynchronizedScrollingSequence        "0072|0210"
#define GKDCM_DisplaySetScrollingGroup             "0072|0212"
#define GKDCM_NavigationIndicatorSequence          "0072|0214"
#define GKDCM_NavigationDisplaySet                 "0072|0216"
#define GKDCM_ReferenceDisplaySets                 "0072|0218"
#define GKDCM_ImageBoxesSequence                   "0072|0300"
#define GKDCM_ImageBoxNumber                       "0072|0302"
#define GKDCM_ImageBoxLayoutType                   "0072|0304"
#define GKDCM_ImageBoxTileHorizontalDimension      "0072|0306"
#define GKDCM_ImageBoxTileVerticalDimension        "0072|0308"
#define GKDCM_ImageBoxScrollDirection              "0072|0310"
#define GKDCM_ImageBoxSmallScrollType              "0072|0312"
#define GKDCM_ImageBoxSmallScrollAmount            "0072|0314"
#define GKDCM_ImageBoxLargeScrollType              "0072|0316"
#define GKDCM_ImageBoxLargeScrollAmount            "0072|0318"
#define GKDCM_ImageBoxOverlapPriority              "0072|0320"
#define GKDCM_CineRelativeToRealTime               "0072|0330"
#define GKDCM_FilterOperationsSequence             "0072|0400"
#define GKDCM_FilterByCategory                     "0072|0402"
#define GKDCM_FilterByAttributePresence            "0072|0404"
#define GKDCM_FilterByOperator                     "0072|0406"
#define GKDCM_StructuredDisplayBackgroundCIELabValue "0072|0420"
#define GKDCM_EmptyImageBoxCIELabValue             "0072|0421"
#define GKDCM_StructuredDisplayImageBoxSequence    "0072|0422"
#define GKDCM_StructuredDisplayTextBoxSequence     "0072|0424"
#define GKDCM_ReferencedFirstFrameSequence         "0072|0427"
#define GKDCM_ImageBoxSynchronizationSequence      "0072|0430"
#define GKDCM_SynchronizedImageBoxList             "0072|0432"
#define GKDCM_TypeOfSynchronization                "0072|0434"
#define GKDCM_BlendingOperationType                "0072|0500"
#define GKDCM_ReformattingOperationType            "0072|0510"
#define GKDCM_ReformattingThickness                "0072|0512"
#define GKDCM_ReformattingInterval                 "0072|0514"
#define GKDCM_ReformattingOperationInitialViewDirection "0072|0516"
#define GKDCM_ThreeDRenderingType                  "0072|0520"
#define GKDCM_SortingOperationsSequence            "0072|0600"
#define GKDCM_SortByCategory                       "0072|0602"
#define GKDCM_SortingDirection                     "0072|0604"
#define GKDCM_DisplaySetPatientOrientation         "0072|0700"
#define GKDCM_VOIType                              "0072|0702"
#define GKDCM_PseudoColorType                      "0072|0704"
#define GKDCM_ShowGrayscaleInverted                "0072|0706"
#define GKDCM_ShowImageTrueSizeFlag                "0072|0710"
#define GKDCM_ShowGraphicAnnotationFlag            "0072|0712"
#define GKDCM_ShowPatientDemographicsFlag          "0072|0714"
#define GKDCM_ShowAcquisitionTechniquesFlag        "0072|0716"
#define GKDCM_DisplaySetHorizontalJustification    "0072|0717"
#define GKDCM_DisplaySetVerticalJustification      "0072|0718"
#define GKDCM_UnifiedProcedureStepState            "0074|1000"
#define GKDCM_UnifiedProcedureStepProgressInformationSequence "0074|1002"
#define GKDCM_UnifiedProcedureStepProgress         "0074|1004"
#define GKDCM_UnifiedProcedureStepProgressDescription "0074|1006"
#define GKDCM_UnifiedProcedureStepCommunicationsURISequence "0074|1008"
#define GKDCM_ContactURI                           "0074|100a"
#define GKDCM_ContactDisplayName                   "0074|100c"
#define GKDCM_UnifiedProcedureStepDiscontinuationReasonCodeSequence "0074|100e"
#define GKDCM_BeamTaskSequence                     "0074|1020"
#define GKDCM_BeamTaskType                         "0074|1022"
#define GKDCM_BeamOrderIndex                       "0074|1024"
#define GKDCM_DeliveryVerificationImageSequence    "0074|1030"
#define GKDCM_VerificationImageTiming              "0074|1032"
#define GKDCM_DoubleExposureFlag                   "0074|1034"
#define GKDCM_DoubleExposureOrdering               "0074|1036"
#define GKDCM_DoubleExposureMeterset               "0074|1038"
#define GKDCM_DoubleExposureFieldDelta             "0074|103a"
#define GKDCM_RelatedReferenceRTImageSequence      "0074|1040"
#define GKDCM_GeneralMachineVerificationSequence   "0074|1042"
#define GKDCM_ConventionalMachineVerificationSequence "0074|1044"
#define GKDCM_IonMachineVerificationSequence       "0074|1046"
#define GKDCM_FailedAttributesSequence             "0074|1048"
#define GKDCM_OverriddenAttributesSequence         "0074|104a"
#define GKDCM_ConventionalControlPointVerificationSequence "0074|104c"
#define GKDCM_IonControlPointVerificationSequence  "0074|104e"
#define GKDCM_AttributeOccurrenceSequence          "0074|1050"
#define GKDCM_AttributeOccurrencePointer           "0074|1052"
#define GKDCM_AttributeItemSelector                "0074|1054"
#define GKDCM_AttributeOccurrencePrivateCreator    "0074|1056"
#define GKDCM_ScheduledProcedureStepPriority       "0074|1200"
#define GKDCM_WorklistLabel                        "0074|1202"
#define GKDCM_ProcedureStepLabel                   "0074|1204"
#define GKDCM_ScheduledProcessingParametersSequence "0074|1210"
#define GKDCM_PerformedProcessingParametersSequence "0074|1212"
#define GKDCM_UnifiedProcedureStepPerformedProcedureSequence "0074|1216"
#define GKDCM_RelatedProcedureStepSequence         "0074|1220"
#define GKDCM_ProcedureStepRelationshipType        "0074|1222"
#define GKDCM_DeletionLock                         "0074|1230"
#define GKDCM_ReceivingAE                          "0074|1234"
#define GKDCM_RequestingAE                         "0074|1236"
#define GKDCM_ReasonForCancellation                "0074|1238"
#define GKDCM_SCPStatus                            "0074|1242"
#define GKDCM_SubscriptionListStatus               "0074|1244"
#define GKDCM_UnifiedProcedureStepListStatus       "0074|1246"
#define GKDCM_ImplantAssemblyTemplateName          "0076|0001"
#define GKDCM_ImplantAssemblyTemplateIssuer        "0076|0003"
#define GKDCM_ImplantAssemblyTemplateVersion       "0076|0006"
#define GKDCM_ReplacedImplantAssemblyTemplateSequence "0076|0008"
#define GKDCM_ImplantAssemblyTemplateType          "0076|000a"
#define GKDCM_OriginalImplantAssemblyTemplateSequence "0076|000c"
#define GKDCM_DerivationImplantAssemblyTemplateSequence "0076|000e"
#define GKDCM_ImplantAssemblyTemplateTargetAnatomySequence "0076|0010"
#define GKDCM_ProcedureTypeCodeSequence            "0076|0020"
#define GKDCM_SurgicalTechnique                    "0076|0030"
#define GKDCM_ComponentTypesSequence               "0076|0032"
#define GKDCM_ComponentTypeCodeSequence            "0076|0034"
#define GKDCM_ExclusiveComponentType               "0076|0036"
#define GKDCM_MandatoryComponentType               "0076|0038"
#define GKDCM_ComponentSequence                    "0076|0040"
#define GKDCM_ComponentID                          "0076|0055"
#define GKDCM_ComponentAssemblySequence            "0076|0060"
#define GKDCM_Component1ReferencedID               "0076|0070"
#define GKDCM_Component1ReferencedMatingFeatureSetID "0076|0080"
#define GKDCM_Component1ReferencedMatingFeatureID  "0076|0090"
#define GKDCM_Component2ReferencedID               "0076|00a0"
#define GKDCM_Component2ReferencedMatingFeatureSetID "0076|00b0"
#define GKDCM_Component2ReferencedMatingFeatureID  "0076|00c0"
#define GKDCM_ImplantTemplateGroupName             "0078|0000"
#define GKDCM_ImplantTemplateGroupDescription      "0078|0010"
#define GKDCM_ImplantTemplateGroupIssuer           "0078|0020"
#define GKDCM_ImplantTemplateGroupVersion          "0078|0024"
#define GKDCM_ReplacedImplantTemplateGroupSequence "0078|0026"
#define GKDCM_ImplantTemplateGroupTargetAnatomySequence "0078|0028"
#define GKDCM_ImplantTemplateGroupMembersSequence  "0078|002a"
#define GKDCM_ImplantTemplateGroupMemberID         "0078|002e"
#define GKDCM_ThreeDImplantTemplateGroupMemberMatchingPoint "0078|0050"
#define GKDCM_ThreeDImplantTemplateGroupMemberMatchingAxes "0078|0060"
#define GKDCM_ImplantTemplateGroupMemberMatching2DCoordinatesSequence "0078|0070"
#define GKDCM_TwoDImplantTemplateGroupMemberMatchingPoint "0078|0090"
#define GKDCM_TwoDImplantTemplateGroupMemberMatchingAxes "0078|00a0"
#define GKDCM_ImplantTemplateGroupVariationDimensionSequence "0078|00b0"
#define GKDCM_ImplantTemplateGroupVariationDimensionName "0078|00b2"
#define GKDCM_ImplantTemplateGroupVariationDimensionRankSequence "0078|00b4"
#define GKDCM_ReferencedImplantTemplateGroupMemberID "0078|00b6"
#define GKDCM_ImplantTemplateGroupVariationDimensionRank "0078|00b8"
#define GKDCM_StorageMediaFileSetID                "0088|0130"
#define GKDCM_StorageMediaFileSetUID               "0088|0140"
#define GKDCM_IconImageSequence                    "0088|0200"
#define GKDCM_RETIRED_TopicTitle                   "0088|0904"
#define GKDCM_RETIRED_TopicSubject                 "0088|0906"
#define GKDCM_RETIRED_TopicAuthor                  "0088|0910"
#define GKDCM_RETIRED_TopicKeywords                "0088|0912"
#define GKDCM_SOPInstanceStatus                    "0100|0410"
#define GKDCM_SOPAuthorizationDateTime             "0100|0420"
#define GKDCM_SOPAuthorizationComment              "0100|0424"
#define GKDCM_AuthorizationEquipmentCertificationNumber "0100|0426"
#define GKDCM_MACIDNumber                          "0400|0005"
#define GKDCM_MACCalculationTransferSyntaxUID      "0400|0010"
#define GKDCM_MACAlgorithm                         "0400|0015"
#define GKDCM_DataElementsSigned                   "0400|0020"
#define GKDCM_DigitalSignatureUID                  "0400|0100"
#define GKDCM_DigitalSignatureDateTime             "0400|0105"
#define GKDCM_CertificateType                      "0400|0110"
#define GKDCM_CertificateOfSigner                  "0400|0115"
#define GKDCM_Signature                            "0400|0120"
#define GKDCM_CertifiedTimestampType               "0400|0305"
#define GKDCM_CertifiedTimestamp                   "0400|0310"
#define GKDCM_DigitalSignaturePurposeCodeSequence  "0400|0401"
#define GKDCM_ReferencedDigitalSignatureSequence   "0400|0402"
#define GKDCM_ReferencedSOPInstanceMACSequence     "0400|0403"
#define GKDCM_MAC                                  "0400|0404"
#define GKDCM_EncryptedAttributesSequence          "0400|0500"
#define GKDCM_EncryptedContentTransferSyntaxUID    "0400|0510"
#define GKDCM_EncryptedContent                     "0400|0520"
#define GKDCM_ModifiedAttributesSequence           "0400|0550"
#define GKDCM_OriginalAttributesSequence           "0400|0561"
#define GKDCM_AttributeModificationDateTime        "0400|0562"
#define GKDCM_ModifyingSystem                      "0400|0563"
#define GKDCM_SourceOfPreviousValues               "0400|0564"
#define GKDCM_ReasonForTheAttributeModification    "0400|0565"
#define GKDCM_ACR_NEMA_2C_CodeTableGroupLength     "1000|0000"
#define GKDCM_ACR_NEMA_2C_EscapeTriplet            "1000|0010"
#define GKDCM_ACR_NEMA_2C_RunLengthTriplet         "1000|0011"
#define GKDCM_ACR_NEMA_2C_HuffmanTableSize         "1000|0012"
#define GKDCM_ACR_NEMA_2C_HuffmanTableTriplet      "1000|0013"
#define GKDCM_ACR_NEMA_2C_ShiftTableSize           "1000|0014"
#define GKDCM_ACR_NEMA_2C_ShiftTableTriplet        "1000|0015"
#define GKDCM_ACR_NEMA_2C_ZonalMapGroupLength      "1010|0000"
#define GKDCM_ACR_NEMA_2C_ZonalMap                 "1010|0004"
#define GKDCM_NumberOfCopies                       "2000|0010"
#define GKDCM_PrinterConfigurationSequence         "2000|001e"
#define GKDCM_PrintPriority                        "2000|0020"
#define GKDCM_MediumType                           "2000|0030"
#define GKDCM_FilmDestination                      "2000|0040"
#define GKDCM_FilmSessionLabel                     "2000|0050"
#define GKDCM_MemoryAllocation                     "2000|0060"
#define GKDCM_MaximumMemoryAllocation              "2000|0061"
#define GKDCM_RETIRED_ColorImagePrintingFlag       "2000|0062"
#define GKDCM_RETIRED_CollationFlag                "2000|0063"
#define GKDCM_RETIRED_AnnotationFlag               "2000|0065"
#define GKDCM_RETIRED_ImageOverlayFlag             "2000|0067"
#define GKDCM_RETIRED_PresentationLUTFlag          "2000|0069"
#define GKDCM_RETIRED_ImageBoxPresentationLUTFlag  "2000|006a"
#define GKDCM_MemoryBitDepth                       "2000|00a0"
#define GKDCM_PrintingBitDepth                     "2000|00a1"
#define GKDCM_MediaInstalledSequence               "2000|00a2"
#define GKDCM_OtherMediaAvailableSequence          "2000|00a4"
#define GKDCM_SupportedImageDisplayFormatsSequence "2000|00a8"
#define GKDCM_ReferencedFilmBoxSequence            "2000|0500"
#define GKDCM_RETIRED_ReferencedStoredPrintSequence "2000|0510"
#define GKDCM_ImageDisplayFormat                   "2010|0010"
#define GKDCM_AnnotationDisplayFormatID            "2010|0030"
#define GKDCM_FilmOrientation                      "2010|0040"
#define GKDCM_FilmSizeID                           "2010|0050"
#define GKDCM_PrinterResolutionID                  "2010|0052"
#define GKDCM_DefaultPrinterResolutionID           "2010|0054"
#define GKDCM_MagnificationType                    "2010|0060"
#define GKDCM_SmoothingType                        "2010|0080"
#define GKDCM_DefaultMagnificationType             "2010|00a6"
#define GKDCM_OtherMagnificationTypesAvailable     "2010|00a7"
#define GKDCM_DefaultSmoothingType                 "2010|00a8"
#define GKDCM_OtherSmoothingTypesAvailable         "2010|00a9"
#define GKDCM_BorderDensity                        "2010|0100"
#define GKDCM_EmptyImageDensity                    "2010|0110"
#define GKDCM_MinDensity                           "2010|0120"
#define GKDCM_MaxDensity                           "2010|0130"
#define GKDCM_Trim                                 "2010|0140"
#define GKDCM_ConfigurationInformation             "2010|0150"
#define GKDCM_ConfigurationInformationDescription  "2010|0152"
#define GKDCM_MaximumCollatedFilms                 "2010|0154"
#define GKDCM_Illumination                         "2010|015e"
#define GKDCM_ReflectedAmbientLight                "2010|0160"
#define GKDCM_PrinterPixelSpacing                  "2010|0376"
#define GKDCM_ReferencedFilmSessionSequence        "2010|0500"
#define GKDCM_ReferencedImageBoxSequence           "2010|0510"
#define GKDCM_ReferencedBasicAnnotationBoxSequence "2010|0520"
#define GKDCM_ImageBoxPosition                     "2020|0010"
#define GKDCM_Polarity                             "2020|0020"
#define GKDCM_RequestedImageSize                   "2020|0030"
#define GKDCM_RequestedDecimateCropBehavior        "2020|0040"
#define GKDCM_RequestedResolutionID                "2020|0050"
#define GKDCM_RequestedImageSizeFlag               "2020|00a0"
#define GKDCM_DecimateCropResult                   "2020|00a2"
#define GKDCM_BasicGrayscaleImageSequence          "2020|0110"
#define GKDCM_BasicColorImageSequence              "2020|0111"
#define GKDCM_RETIRED_ReferencedImageOverlayBoxSequence "2020|0130"
#define GKDCM_RETIRED_ReferencedVOILUTBoxSequence  "2020|0140"
#define GKDCM_AnnotationPosition                   "2030|0010"
#define GKDCM_TextString                           "2030|0020"
#define GKDCM_RETIRED_ReferencedOverlayPlaneSequence "2040|0010"
#define GKDCM_RETIRED_ReferencedOverlayPlaneGroups "2040|0011"
#define GKDCM_RETIRED_OverlayPixelDataSequence     "2040|0020"
#define GKDCM_RETIRED_OverlayMagnificationType     "2040|0060"
#define GKDCM_RETIRED_OverlaySmoothingType         "2040|0070"
#define GKDCM_RETIRED_OverlayOrImageMagnification  "2040|0072"
#define GKDCM_RETIRED_MagnifyToNumberOfColumns     "2040|0074"
#define GKDCM_RETIRED_OverlayForegroundDensity     "2040|0080"
#define GKDCM_RETIRED_OverlayBackgroundDensity     "2040|0082"
#define GKDCM_RETIRED_OverlayMode                  "2040|0090"
#define GKDCM_RETIRED_ThresholdDensity             "2040|0100"
#define GKDCM_RETIRED_ReferencedImageBoxSequenceRetired "2040|0500"
#define GKDCM_PresentationLUTSequence              "2050|0010"
#define GKDCM_PresentationLUTShape                 "2050|0020"
#define GKDCM_ReferencedPresentationLUTSequence    "2050|0500"
#define GKDCM_RETIRED_PrintJobID                   "2100|0010"
#define GKDCM_ExecutionStatus                      "2100|0020"
#define GKDCM_ExecutionStatusInfo                  "2100|0030"
#define GKDCM_CreationDate                         "2100|0040"
#define GKDCM_CreationTime                         "2100|0050"
#define GKDCM_Originator                           "2100|0070"
#define GKDCM_RETIRED_DestinationAE                "2100|0140"
#define GKDCM_OwnerID                              "2100|0160"
#define GKDCM_NumberOfFilms                        "2100|0170"
#define GKDCM_RETIRED_ReferencedPrintJobSequencePullStoredPrint "2100|0500"
#define GKDCM_PrinterStatus                        "2110|0010"
#define GKDCM_PrinterStatusInfo                    "2110|0020"
#define GKDCM_PrinterName                          "2110|0030"
#define GKDCM_RETIRED_PrintQueueID                 "2110|0099"
#define GKDCM_RETIRED_QueueStatus                  "2120|0010"
#define GKDCM_RETIRED_PrintJobDescriptionSequence  "2120|0050"
#define GKDCM_RETIRED_ReferencedPrintJobSequence   "2120|0070"
#define GKDCM_RETIRED_PrintManagementCapabilitiesSequence "2130|0010"
#define GKDCM_RETIRED_PrinterCharacteristicsSequence "2130|0015"
#define GKDCM_RETIRED_FilmBoxContentSequence       "2130|0030"
#define GKDCM_RETIRED_ImageBoxContentSequence      "2130|0040"
#define GKDCM_RETIRED_AnnotationContentSequence    "2130|0050"
#define GKDCM_RETIRED_ImageOverlayBoxContentSequence "2130|0060"
#define GKDCM_RETIRED_PresentationLUTContentSequence "2130|0080"
#define GKDCM_RETIRED_ProposedStudySequence        "2130|00a0"
#define GKDCM_RETIRED_OriginalImageSequence        "2130|00c0"
#define GKDCM_LabelUsingInformationExtractedFromInstances "2200|0001"
#define GKDCM_LabelText                            "2200|0002"
#define GKDCM_LabelStyleSelection                  "2200|0003"
#define GKDCM_MediaDisposition                     "2200|0004"
#define GKDCM_BarcodeValue                         "2200|0005"
#define GKDCM_BarcodeSymbology                     "2200|0006"
#define GKDCM_AllowMediaSplitting                  "2200|0007"
#define GKDCM_IncludeNonDICOMObjects               "2200|0008"
#define GKDCM_IncludeDisplayApplication            "2200|0009"
#define GKDCM_PreserveCompositeInstancesAfterMediaCreation "2200|000a"
#define GKDCM_TotalNumberOfPiecesOfMediaCreated    "2200|000b"
#define GKDCM_RequestedMediaApplicationProfile     "2200|000c"
#define GKDCM_ReferencedStorageMediaSequence       "2200|000d"
#define GKDCM_FailureAttributes                    "2200|000e"
#define GKDCM_AllowLossyCompression                "2200|000f"
#define GKDCM_RequestPriority                      "2200|0020"
#define GKDCM_RTImageLabel                         "3002|0002"
#define GKDCM_RTImageName                          "3002|0003"
#define GKDCM_RTImageDescription                   "3002|0004"
#define GKDCM_ReportedValuesOrigin                 "3002|000a"
#define GKDCM_RTImagePlane                         "3002|000c"
#define GKDCM_XRayImageReceptorTranslation         "3002|000d"
#define GKDCM_XRayImageReceptorAngle               "3002|000e"
#define GKDCM_RTImageOrientation                   "3002|0010"
#define GKDCM_ImagePlanePixelSpacing               "3002|0011"
#define GKDCM_RTImagePosition                      "3002|0012"
#define GKDCM_RadiationMachineName                 "3002|0020"
#define GKDCM_RadiationMachineSAD                  "3002|0022"
#define GKDCM_RadiationMachineSSD                  "3002|0024"
#define GKDCM_RTImageSID                           "3002|0026"
#define GKDCM_SourceToReferenceObjectDistance      "3002|0028"
#define GKDCM_FractionNumber                       "3002|0029"
#define GKDCM_ExposureSequence                     "3002|0030"
#define GKDCM_MetersetExposure                     "3002|0032"
#define GKDCM_DiaphragmPosition                    "3002|0034"
#define GKDCM_FluenceMapSequence                   "3002|0040"
#define GKDCM_FluenceDataSource                    "3002|0041"
#define GKDCM_FluenceDataScale                     "3002|0042"
#define GKDCM_PrimaryFluenceModeSequence           "3002|0050"
#define GKDCM_FluenceMode                          "3002|0051"
#define GKDCM_FluenceModeID                        "3002|0052"
#define GKDCM_DVHType                              "3004|0001"
#define GKDCM_DoseUnits                            "3004|0002"
#define GKDCM_DoseType                             "3004|0004"
#define GKDCM_DoseComment                          "3004|0006"
#define GKDCM_NormalizationPoint                   "3004|0008"
#define GKDCM_DoseSummationType                    "3004|000a"
#define GKDCM_GridFrameOffsetVector                "3004|000c"
#define GKDCM_DoseGridScaling                      "3004|000e"
#define GKDCM_RTDoseROISequence                    "3004|0010"
#define GKDCM_DoseValue                            "3004|0012"
#define GKDCM_TissueHeterogeneityCorrection        "3004|0014"
#define GKDCM_DVHNormalizationPoint                "3004|0040"
#define GKDCM_DVHNormalizationDoseValue            "3004|0042"
#define GKDCM_DVHSequence                          "3004|0050"
#define GKDCM_DVHDoseScaling                       "3004|0052"
#define GKDCM_DVHVolumeUnits                       "3004|0054"
#define GKDCM_DVHNumberOfBins                      "3004|0056"
#define GKDCM_DVHData                              "3004|0058"
#define GKDCM_DVHReferencedROISequence             "3004|0060"
#define GKDCM_DVHROIContributionType               "3004|0062"
#define GKDCM_DVHMinimumDose                       "3004|0070"
#define GKDCM_DVHMaximumDose                       "3004|0072"
#define GKDCM_DVHMeanDose                          "3004|0074"
#define GKDCM_StructureSetLabel                    "3006|0002"
#define GKDCM_StructureSetName                     "3006|0004"
#define GKDCM_StructureSetDescription              "3006|0006"
#define GKDCM_StructureSetDate                     "3006|0008"
#define GKDCM_StructureSetTime                     "3006|0009"
#define GKDCM_ReferencedFrameOfReferenceSequence   "3006|0010"
#define GKDCM_RTReferencedStudySequence            "3006|0012"
#define GKDCM_RTReferencedSeriesSequence           "3006|0014"
#define GKDCM_ContourImageSequence                 "3006|0016"
#define GKDCM_StructureSetROISequence              "3006|0020"
#define GKDCM_ROINumber                            "3006|0022"
#define GKDCM_ReferencedFrameOfReferenceUID        "3006|0024"
#define GKDCM_ROIName                              "3006|0026"
#define GKDCM_ROIDescription                       "3006|0028"
#define GKDCM_ROIDisplayColor                      "3006|002a"
#define GKDCM_ROIVolume                            "3006|002c"
#define GKDCM_RTRelatedROISequence                 "3006|0030"
#define GKDCM_RTROIRelationship                    "3006|0033"
#define GKDCM_ROIGenerationAlgorithm               "3006|0036"
#define GKDCM_ROIGenerationDescription             "3006|0038"
#define GKDCM_ROIContourSequence                   "3006|0039"
#define GKDCM_ContourSequence                      "3006|0040"
#define GKDCM_ContourGeometricType                 "3006|0042"
#define GKDCM_ContourSlabThickness                 "3006|0044"
#define GKDCM_ContourOffsetVector                  "3006|0045"
#define GKDCM_NumberOfContourPoints                "3006|0046"
#define GKDCM_ContourNumber                        "3006|0048"
#define GKDCM_AttachedContours                     "3006|0049"
#define GKDCM_ContourData                          "3006|0050"
#define GKDCM_RTROIObservationsSequence            "3006|0080"
#define GKDCM_ObservationNumber                    "3006|0082"
#define GKDCM_ReferencedROINumber                  "3006|0084"
#define GKDCM_ROIObservationLabel                  "3006|0085"
#define GKDCM_RTROIIdentificationCodeSequence      "3006|0086"
#define GKDCM_ROIObservationDescription            "3006|0088"
#define GKDCM_RelatedRTROIObservationsSequence     "3006|00a0"
#define GKDCM_RTROIInterpretedType                 "3006|00a4"
#define GKDCM_ROIInterpreter                       "3006|00a6"
#define GKDCM_ROIPhysicalPropertiesSequence        "3006|00b0"
#define GKDCM_ROIPhysicalProperty                  "3006|00b2"
#define GKDCM_ROIPhysicalPropertyValue             "3006|00b4"
#define GKDCM_ROIElementalCompositionSequence      "3006|00b6"
#define GKDCM_ROIElementalCompositionAtomicNumber  "3006|00b7"
#define GKDCM_ROIElementalCompositionAtomicMassFraction "3006|00b8"
#define GKDCM_FrameOfReferenceRelationshipSequence "3006|00c0"
#define GKDCM_RelatedFrameOfReferenceUID           "3006|00c2"
#define GKDCM_FrameOfReferenceTransformationType   "3006|00c4"
#define GKDCM_FrameOfReferenceTransformationMatrix "3006|00c6"
#define GKDCM_FrameOfReferenceTransformationComment "3006|00c8"
#define GKDCM_MeasuredDoseReferenceSequence        "3008|0010"
#define GKDCM_MeasuredDoseDescription              "3008|0012"
#define GKDCM_MeasuredDoseType                     "3008|0014"
#define GKDCM_MeasuredDoseValue                    "3008|0016"
#define GKDCM_TreatmentSessionBeamSequence         "3008|0020"
#define GKDCM_TreatmentSessionIonBeamSequence      "3008|0021"
#define GKDCM_CurrentFractionNumber                "3008|0022"
#define GKDCM_TreatmentControlPointDate            "3008|0024"
#define GKDCM_TreatmentControlPointTime            "3008|0025"
#define GKDCM_TreatmentTerminationStatus           "3008|002a"
#define GKDCM_TreatmentTerminationCode             "3008|002b"
#define GKDCM_TreatmentVerificationStatus          "3008|002c"
#define GKDCM_ReferencedTreatmentRecordSequence    "3008|0030"
#define GKDCM_SpecifiedPrimaryMeterset             "3008|0032"
#define GKDCM_SpecifiedSecondaryMeterset           "3008|0033"
#define GKDCM_DeliveredPrimaryMeterset             "3008|0036"
#define GKDCM_DeliveredSecondaryMeterset           "3008|0037"
#define GKDCM_SpecifiedTreatmentTime               "3008|003a"
#define GKDCM_DeliveredTreatmentTime               "3008|003b"
#define GKDCM_ControlPointDeliverySequence         "3008|0040"
#define GKDCM_IonControlPointDeliverySequence      "3008|0041"
#define GKDCM_SpecifiedMeterset                    "3008|0042"
#define GKDCM_DeliveredMeterset                    "3008|0044"
#define GKDCM_MetersetRateSet                      "3008|0045"
#define GKDCM_MetersetRateDelivered                "3008|0046"
#define GKDCM_ScanSpotMetersetsDelivered           "3008|0047"
#define GKDCM_DoseRateDelivered                    "3008|0048"
#define GKDCM_TreatmentSummaryCalculatedDoseReferenceSequence "3008|0050"
#define GKDCM_CumulativeDoseToDoseReference        "3008|0052"
#define GKDCM_FirstTreatmentDate                   "3008|0054"
#define GKDCM_MostRecentTreatmentDate              "3008|0056"
#define GKDCM_NumberOfFractionsDelivered           "3008|005a"
#define GKDCM_OverrideSequence                     "3008|0060"
#define GKDCM_ParameterSequencePointer             "3008|0061"
#define GKDCM_OverrideParameterPointer             "3008|0062"
#define GKDCM_ParameterItemIndex                   "3008|0063"
#define GKDCM_MeasuredDoseReferenceNumber          "3008|0064"
#define GKDCM_ParameterPointer                     "3008|0065"
#define GKDCM_OverrideReason                       "3008|0066"
#define GKDCM_CorrectedParameterSequence           "3008|0068"
#define GKDCM_CorrectionValue                      "3008|006a"
#define GKDCM_CalculatedDoseReferenceSequence      "3008|0070"
#define GKDCM_CalculatedDoseReferenceNumber        "3008|0072"
#define GKDCM_CalculatedDoseReferenceDescription   "3008|0074"
#define GKDCM_CalculatedDoseReferenceDoseValue     "3008|0076"
#define GKDCM_StartMeterset                        "3008|0078"
#define GKDCM_EndMeterset                          "3008|007a"
#define GKDCM_ReferencedMeasuredDoseReferenceSequence "3008|0080"
#define GKDCM_ReferencedMeasuredDoseReferenceNumber "3008|0082"
#define GKDCM_ReferencedCalculatedDoseReferenceSequence "3008|0090"
#define GKDCM_ReferencedCalculatedDoseReferenceNumber "3008|0092"
#define GKDCM_BeamLimitingDeviceLeafPairsSequence  "3008|00a0"
#define GKDCM_RecordedWedgeSequence                "3008|00b0"
#define GKDCM_RecordedCompensatorSequence          "3008|00c0"
#define GKDCM_RecordedBlockSequence                "3008|00d0"
#define GKDCM_TreatmentSummaryMeasuredDoseReferenceSequence "3008|00e0"
#define GKDCM_RecordedSnoutSequence                "3008|00f0"
#define GKDCM_RecordedRangeShifterSequence         "3008|00f2"
#define GKDCM_RecordedLateralSpreadingDeviceSequence "3008|00f4"
#define GKDCM_RecordedRangeModulatorSequence       "3008|00f6"
#define GKDCM_RecordedSourceSequence               "3008|0100"
#define GKDCM_SourceSerialNumber                   "3008|0105"
#define GKDCM_TreatmentSessionApplicationSetupSequence "3008|0110"
#define GKDCM_ApplicationSetupCheck                "3008|0116"
#define GKDCM_RecordedBrachyAccessoryDeviceSequence "3008|0120"
#define GKDCM_ReferencedBrachyAccessoryDeviceNumber "3008|0122"
#define GKDCM_RecordedChannelSequence              "3008|0130"
#define GKDCM_SpecifiedChannelTotalTime            "3008|0132"
#define GKDCM_DeliveredChannelTotalTime            "3008|0134"
#define GKDCM_SpecifiedNumberOfPulses              "3008|0136"
#define GKDCM_DeliveredNumberOfPulses              "3008|0138"
#define GKDCM_SpecifiedPulseRepetitionInterval     "3008|013a"
#define GKDCM_DeliveredPulseRepetitionInterval     "3008|013c"
#define GKDCM_RecordedSourceApplicatorSequence     "3008|0140"
#define GKDCM_ReferencedSourceApplicatorNumber     "3008|0142"
#define GKDCM_RecordedChannelShieldSequence        "3008|0150"
#define GKDCM_ReferencedChannelShieldNumber        "3008|0152"
#define GKDCM_BrachyControlPointDeliveredSequence  "3008|0160"
#define GKDCM_SafePositionExitDate                 "3008|0162"
#define GKDCM_SafePositionExitTime                 "3008|0164"
#define GKDCM_SafePositionReturnDate               "3008|0166"
#define GKDCM_SafePositionReturnTime               "3008|0168"
#define GKDCM_CurrentTreatmentStatus               "3008|0200"
#define GKDCM_TreatmentStatusComment               "3008|0202"
#define GKDCM_FractionGroupSummarySequence         "3008|0220"
#define GKDCM_ReferencedFractionNumber             "3008|0223"
#define GKDCM_FractionGroupType                    "3008|0224"
#define GKDCM_BeamStopperPosition                  "3008|0230"
#define GKDCM_FractionStatusSummarySequence        "3008|0240"
#define GKDCM_TreatmentDate                        "3008|0250"
#define GKDCM_TreatmentTime                        "3008|0251"
#define GKDCM_RTPlanLabel                          "300a|0002"
#define GKDCM_RTPlanName                           "300a|0003"
#define GKDCM_RTPlanDescription                    "300a|0004"
#define GKDCM_RTPlanDate                           "300a|0006"
#define GKDCM_RTPlanTime                           "300a|0007"
#define GKDCM_TreatmentProtocols                   "300a|0009"
#define GKDCM_PlanIntent                           "300a|000a"
#define GKDCM_TreatmentSites                       "300a|000b"
#define GKDCM_RTPlanGeometry                       "300a|000c"
#define GKDCM_PrescriptionDescription              "300a|000e"
#define GKDCM_DoseReferenceSequence                "300a|0010"
#define GKDCM_DoseReferenceNumber                  "300a|0012"
#define GKDCM_DoseReferenceUID                     "300a|0013"
#define GKDCM_DoseReferenceStructureType           "300a|0014"
#define GKDCM_NominalBeamEnergyUnit                "300a|0015"
#define GKDCM_DoseReferenceDescription             "300a|0016"
#define GKDCM_DoseReferencePointCoordinates        "300a|0018"
#define GKDCM_NominalPriorDose                     "300a|001a"
#define GKDCM_DoseReferenceType                    "300a|0020"
#define GKDCM_ConstraintWeight                     "300a|0021"
#define GKDCM_DeliveryWarningDose                  "300a|0022"
#define GKDCM_DeliveryMaximumDose                  "300a|0023"
#define GKDCM_TargetMinimumDose                    "300a|0025"
#define GKDCM_TargetPrescriptionDose               "300a|0026"
#define GKDCM_TargetMaximumDose                    "300a|0027"
#define GKDCM_TargetUnderdoseVolumeFraction        "300a|0028"
#define GKDCM_OrganAtRiskFullVolumeDose            "300a|002a"
#define GKDCM_OrganAtRiskLimitDose                 "300a|002b"
#define GKDCM_OrganAtRiskMaximumDose               "300a|002c"
#define GKDCM_OrganAtRiskOverdoseVolumeFraction    "300a|002d"
#define GKDCM_ToleranceTableSequence               "300a|0040"
#define GKDCM_ToleranceTableNumber                 "300a|0042"
#define GKDCM_ToleranceTableLabel                  "300a|0043"
#define GKDCM_GantryAngleTolerance                 "300a|0044"
#define GKDCM_BeamLimitingDeviceAngleTolerance     "300a|0046"
#define GKDCM_BeamLimitingDeviceToleranceSequence  "300a|0048"
#define GKDCM_BeamLimitingDevicePositionTolerance  "300a|004a"
#define GKDCM_SnoutPositionTolerance               "300a|004b"
#define GKDCM_PatientSupportAngleTolerance         "300a|004c"
#define GKDCM_TableTopEccentricAngleTolerance      "300a|004e"
#define GKDCM_TableTopPitchAngleTolerance          "300a|004f"
#define GKDCM_TableTopRollAngleTolerance           "300a|0050"
#define GKDCM_TableTopVerticalPositionTolerance    "300a|0051"
#define GKDCM_TableTopLongitudinalPositionTolerance "300a|0052"
#define GKDCM_TableTopLateralPositionTolerance     "300a|0053"
#define GKDCM_RTPlanRelationship                   "300a|0055"
#define GKDCM_FractionGroupSequence                "300a|0070"
#define GKDCM_FractionGroupNumber                  "300a|0071"
#define GKDCM_FractionGroupDescription             "300a|0072"
#define GKDCM_NumberOfFractionsPlanned             "300a|0078"
#define GKDCM_NumberOfFractionPatternDigitsPerDay  "300a|0079"
#define GKDCM_RepeatFractionCycleLength            "300a|007a"
#define GKDCM_FractionPattern                      "300a|007b"
#define GKDCM_NumberOfBeams                        "300a|0080"
#define GKDCM_BeamDoseSpecificationPoint           "300a|0082"
#define GKDCM_BeamDose                             "300a|0084"
#define GKDCM_BeamMeterset                         "300a|0086"
#define GKDCM_BeamDosePointDepth                   "300a|0088"
#define GKDCM_BeamDosePointEquivalentDepth         "300a|0089"
#define GKDCM_BeamDosePointSSD                     "300a|008a"
#define GKDCM_NumberOfBrachyApplicationSetups      "300a|00a0"
#define GKDCM_BrachyApplicationSetupDoseSpecificationPoint "300a|00a2"
#define GKDCM_BrachyApplicationSetupDose           "300a|00a4"
#define GKDCM_BeamSequence                         "300a|00b0"
#define GKDCM_TreatmentMachineName                 "300a|00b2"
#define GKDCM_PrimaryDosimeterUnit                 "300a|00b3"
#define GKDCM_SourceAxisDistance                   "300a|00b4"
#define GKDCM_BeamLimitingDeviceSequence           "300a|00b6"
#define GKDCM_RTBeamLimitingDeviceType             "300a|00b8"
#define GKDCM_SourceToBeamLimitingDeviceDistance   "300a|00ba"
#define GKDCM_IsocenterToBeamLimitingDeviceDistance "300a|00bb"
#define GKDCM_NumberOfLeafJawPairs                 "300a|00bc"
#define GKDCM_LeafPositionBoundaries               "300a|00be"
#define GKDCM_BeamNumber                           "300a|00c0"
#define GKDCM_BeamName                             "300a|00c2"
#define GKDCM_BeamDescription                      "300a|00c3"
#define GKDCM_BeamType                             "300a|00c4"
#define GKDCM_RadiationType                        "300a|00c6"
#define GKDCM_HighDoseTechniqueType                "300a|00c7"
#define GKDCM_ReferenceImageNumber                 "300a|00c8"
#define GKDCM_PlannedVerificationImageSequence     "300a|00ca"
#define GKDCM_ImagingDeviceSpecificAcquisitionParameters "300a|00cc"
#define GKDCM_TreatmentDeliveryType                "300a|00ce"
#define GKDCM_NumberOfWedges                       "300a|00d0"
#define GKDCM_WedgeSequence                        "300a|00d1"
#define GKDCM_WedgeNumber                          "300a|00d2"
#define GKDCM_WedgeType                            "300a|00d3"
#define GKDCM_WedgeID                              "300a|00d4"
#define GKDCM_WedgeAngle                           "300a|00d5"
#define GKDCM_WedgeFactor                          "300a|00d6"
#define GKDCM_TotalWedgeTrayWaterEquivalentThickness "300a|00d7"
#define GKDCM_WedgeOrientation                     "300a|00d8"
#define GKDCM_IsocenterToWedgeTrayDistance         "300a|00d9"
#define GKDCM_SourceToWedgeTrayDistance            "300a|00da"
#define GKDCM_WedgeThinEdgePosition                "300a|00db"
#define GKDCM_BolusID                              "300a|00dc"
#define GKDCM_BolusDescription                     "300a|00dd"
#define GKDCM_NumberOfCompensators                 "300a|00e0"
#define GKDCM_MaterialID                           "300a|00e1"
#define GKDCM_TotalCompensatorTrayFactor           "300a|00e2"
#define GKDCM_CompensatorSequence                  "300a|00e3"
#define GKDCM_CompensatorNumber                    "300a|00e4"
#define GKDCM_CompensatorID                        "300a|00e5"
#define GKDCM_SourceToCompensatorTrayDistance      "300a|00e6"
#define GKDCM_CompensatorRows                      "300a|00e7"
#define GKDCM_CompensatorColumns                   "300a|00e8"
#define GKDCM_CompensatorPixelSpacing              "300a|00e9"
#define GKDCM_CompensatorPosition                  "300a|00ea"
#define GKDCM_CompensatorTransmissionData          "300a|00eb"
#define GKDCM_CompensatorThicknessData             "300a|00ec"
#define GKDCM_NumberOfBoli                         "300a|00ed"
#define GKDCM_CompensatorType                      "300a|00ee"
#define GKDCM_NumberOfBlocks                       "300a|00f0"
#define GKDCM_TotalBlockTrayFactor                 "300a|00f2"
#define GKDCM_TotalBlockTrayWaterEquivalentThickness "300a|00f3"
#define GKDCM_BlockSequence                        "300a|00f4"
#define GKDCM_BlockTrayID                          "300a|00f5"
#define GKDCM_SourceToBlockTrayDistance            "300a|00f6"
#define GKDCM_IsocenterToBlockTrayDistance         "300a|00f7"
#define GKDCM_BlockType                            "300a|00f8"
#define GKDCM_AccessoryCode                        "300a|00f9"
#define GKDCM_BlockDivergence                      "300a|00fa"
#define GKDCM_BlockMountingPosition                "300a|00fb"
#define GKDCM_BlockNumber                          "300a|00fc"
#define GKDCM_BlockName                            "300a|00fe"
#define GKDCM_BlockThickness                       "300a|0100"
#define GKDCM_BlockTransmission                    "300a|0102"
#define GKDCM_BlockNumberOfPoints                  "300a|0104"
#define GKDCM_BlockData                            "300a|0106"
#define GKDCM_ApplicatorSequence                   "300a|0107"
#define GKDCM_ApplicatorID                         "300a|0108"
#define GKDCM_ApplicatorType                       "300a|0109"
#define GKDCM_ApplicatorDescription                "300a|010a"
#define GKDCM_CumulativeDoseReferenceCoefficient   "300a|010c"
#define GKDCM_FinalCumulativeMetersetWeight        "300a|010e"
#define GKDCM_NumberOfControlPoints                "300a|0110"
#define GKDCM_ControlPointSequence                 "300a|0111"
#define GKDCM_ControlPointIndex                    "300a|0112"
#define GKDCM_NominalBeamEnergy                    "300a|0114"
#define GKDCM_DoseRateSet                          "300a|0115"
#define GKDCM_WedgePositionSequence                "300a|0116"
#define GKDCM_WedgePosition                        "300a|0118"
#define GKDCM_BeamLimitingDevicePositionSequence   "300a|011a"
#define GKDCM_LeafJawPositions                     "300a|011c"
#define GKDCM_GantryAngle                          "300a|011e"
#define GKDCM_GantryRotationDirection              "300a|011f"
#define GKDCM_BeamLimitingDeviceAngle              "300a|0120"
#define GKDCM_BeamLimitingDeviceRotationDirection  "300a|0121"
#define GKDCM_PatientSupportAngle                  "300a|0122"
#define GKDCM_PatientSupportRotationDirection      "300a|0123"
#define GKDCM_TableTopEccentricAxisDistance        "300a|0124"
#define GKDCM_TableTopEccentricAngle               "300a|0125"
#define GKDCM_TableTopEccentricRotationDirection   "300a|0126"
#define GKDCM_TableTopVerticalPosition             "300a|0128"
#define GKDCM_TableTopLongitudinalPosition         "300a|0129"
#define GKDCM_TableTopLateralPosition              "300a|012a"
#define GKDCM_IsocenterPosition                    "300a|012c"
#define GKDCM_SurfaceEntryPoint                    "300a|012e"
#define GKDCM_SourceToSurfaceDistance              "300a|0130"
#define GKDCM_CumulativeMetersetWeight             "300a|0134"
#define GKDCM_TableTopPitchAngle                   "300a|0140"
#define GKDCM_TableTopPitchRotationDirection       "300a|0142"
#define GKDCM_TableTopRollAngle                    "300a|0144"
#define GKDCM_TableTopRollRotationDirection        "300a|0146"
#define GKDCM_HeadFixationAngle                    "300a|0148"
#define GKDCM_GantryPitchAngle                     "300a|014a"
#define GKDCM_GantryPitchRotationDirection         "300a|014c"
#define GKDCM_GantryPitchAngleTolerance            "300a|014e"
#define GKDCM_PatientSetupSequence                 "300a|0180"
#define GKDCM_PatientSetupNumber                   "300a|0182"
#define GKDCM_PatientSetupLabel                    "300a|0183"
#define GKDCM_PatientAdditionalPosition            "300a|0184"
#define GKDCM_FixationDeviceSequence               "300a|0190"
#define GKDCM_FixationDeviceType                   "300a|0192"
#define GKDCM_FixationDeviceLabel                  "300a|0194"
#define GKDCM_FixationDeviceDescription            "300a|0196"
#define GKDCM_FixationDevicePosition               "300a|0198"
#define GKDCM_FixationDevicePitchAngle             "300a|0199"
#define GKDCM_FixationDeviceRollAngle              "300a|019a"
#define GKDCM_ShieldingDeviceSequence              "300a|01a0"
#define GKDCM_ShieldingDeviceType                  "300a|01a2"
#define GKDCM_ShieldingDeviceLabel                 "300a|01a4"
#define GKDCM_ShieldingDeviceDescription           "300a|01a6"
#define GKDCM_ShieldingDevicePosition              "300a|01a8"
#define GKDCM_SetupTechnique                       "300a|01b0"
#define GKDCM_SetupTechniqueDescription            "300a|01b2"
#define GKDCM_SetupDeviceSequence                  "300a|01b4"
#define GKDCM_SetupDeviceType                      "300a|01b6"
#define GKDCM_SetupDeviceLabel                     "300a|01b8"
#define GKDCM_SetupDeviceDescription               "300a|01ba"
#define GKDCM_SetupDeviceParameter                 "300a|01bc"
#define GKDCM_SetupReferenceDescription            "300a|01d0"
#define GKDCM_TableTopVerticalSetupDisplacement    "300a|01d2"
#define GKDCM_TableTopLongitudinalSetupDisplacement "300a|01d4"
#define GKDCM_TableTopLateralSetupDisplacement     "300a|01d6"
#define GKDCM_BrachyTreatmentTechnique             "300a|0200"
#define GKDCM_BrachyTreatmentType                  "300a|0202"
#define GKDCM_TreatmentMachineSequence             "300a|0206"
#define GKDCM_SourceSequence                       "300a|0210"
#define GKDCM_SourceNumber                         "300a|0212"
#define GKDCM_SourceType                           "300a|0214"
#define GKDCM_SourceManufacturer                   "300a|0216"
#define GKDCM_ActiveSourceDiameter                 "300a|0218"
#define GKDCM_ActiveSourceLength                   "300a|021a"
#define GKDCM_SourceEncapsulationNominalThickness  "300a|0222"
#define GKDCM_SourceEncapsulationNominalTransmission "300a|0224"
#define GKDCM_SourceIsotopeName                    "300a|0226"
#define GKDCM_SourceIsotopeHalfLife                "300a|0228"
#define GKDCM_SourceStrengthUnits                  "300a|0229"
#define GKDCM_ReferenceAirKermaRate                "300a|022a"
#define GKDCM_SourceStrength                       "300a|022b"
#define GKDCM_SourceStrengthReferenceDate          "300a|022c"
#define GKDCM_SourceStrengthReferenceTime          "300a|022e"
#define GKDCM_ApplicationSetupSequence             "300a|0230"
#define GKDCM_ApplicationSetupType                 "300a|0232"
#define GKDCM_ApplicationSetupNumber               "300a|0234"
#define GKDCM_ApplicationSetupName                 "300a|0236"
#define GKDCM_ApplicationSetupManufacturer         "300a|0238"
#define GKDCM_TemplateNumber                       "300a|0240"
#define GKDCM_TemplateType                         "300a|0242"
#define GKDCM_TemplateName                         "300a|0244"
#define GKDCM_TotalReferenceAirKerma               "300a|0250"
#define GKDCM_BrachyAccessoryDeviceSequence        "300a|0260"
#define GKDCM_BrachyAccessoryDeviceNumber          "300a|0262"
#define GKDCM_BrachyAccessoryDeviceID              "300a|0263"
#define GKDCM_BrachyAccessoryDeviceType            "300a|0264"
#define GKDCM_BrachyAccessoryDeviceName            "300a|0266"
#define GKDCM_BrachyAccessoryDeviceNominalThickness "300a|026a"
#define GKDCM_BrachyAccessoryDeviceNominalTransmission "300a|026c"
#define GKDCM_ChannelSequence                      "300a|0280"
#define GKDCM_ChannelNumber                        "300a|0282"
#define GKDCM_ChannelLength                        "300a|0284"
#define GKDCM_ChannelTotalTime                     "300a|0286"
#define GKDCM_SourceMovementType                   "300a|0288"
#define GKDCM_NumberOfPulses                       "300a|028a"
#define GKDCM_PulseRepetitionInterval              "300a|028c"
#define GKDCM_SourceApplicatorNumber               "300a|0290"
#define GKDCM_SourceApplicatorID                   "300a|0291"
#define GKDCM_SourceApplicatorType                 "300a|0292"
#define GKDCM_SourceApplicatorName                 "300a|0294"
#define GKDCM_SourceApplicatorLength               "300a|0296"
#define GKDCM_SourceApplicatorManufacturer         "300a|0298"
#define GKDCM_SourceApplicatorWallNominalThickness "300a|029c"
#define GKDCM_SourceApplicatorWallNominalTransmission "300a|029e"
#define GKDCM_SourceApplicatorStepSize             "300a|02a0"
#define GKDCM_TransferTubeNumber                   "300a|02a2"
#define GKDCM_TransferTubeLength                   "300a|02a4"
#define GKDCM_ChannelShieldSequence                "300a|02b0"
#define GKDCM_ChannelShieldNumber                  "300a|02b2"
#define GKDCM_ChannelShieldID                      "300a|02b3"
#define GKDCM_ChannelShieldName                    "300a|02b4"
#define GKDCM_ChannelShieldNominalThickness        "300a|02b8"
#define GKDCM_ChannelShieldNominalTransmission     "300a|02ba"
#define GKDCM_FinalCumulativeTimeWeight            "300a|02c8"
#define GKDCM_BrachyControlPointSequence           "300a|02d0"
#define GKDCM_ControlPointRelativePosition         "300a|02d2"
#define GKDCM_ControlPoint3DPosition               "300a|02d4"
#define GKDCM_CumulativeTimeWeight                 "300a|02d6"
#define GKDCM_CompensatorDivergence                "300a|02e0"
#define GKDCM_CompensatorMountingPosition          "300a|02e1"
#define GKDCM_SourceToCompensatorDistance          "300a|02e2"
#define GKDCM_TotalCompensatorTrayWaterEquivalentThickness "300a|02e3"
#define GKDCM_IsocenterToCompensatorTrayDistance   "300a|02e4"
#define GKDCM_CompensatorColumnOffset              "300a|02e5"
#define GKDCM_IsocenterToCompensatorDistances      "300a|02e6"
#define GKDCM_CompensatorRelativeStoppingPowerRatio "300a|02e7"
#define GKDCM_CompensatorMillingToolDiameter       "300a|02e8"
#define GKDCM_IonRangeCompensatorSequence          "300a|02ea"
#define GKDCM_CompensatorDescription               "300a|02eb"
#define GKDCM_RadiationMassNumber                  "300a|0302"
#define GKDCM_RadiationAtomicNumber                "300a|0304"
#define GKDCM_RadiationChargeState                 "300a|0306"
#define GKDCM_ScanMode                             "300a|0308"
#define GKDCM_VirtualSourceAxisDistances           "300a|030a"
#define GKDCM_SnoutSequence                        "300a|030c"
#define GKDCM_SnoutPosition                        "300a|030d"
#define GKDCM_SnoutID                              "300a|030f"
#define GKDCM_NumberOfRangeShifters                "300a|0312"
#define GKDCM_RangeShifterSequence                 "300a|0314"
#define GKDCM_RangeShifterNumber                   "300a|0316"
#define GKDCM_RangeShifterID                       "300a|0318"
#define GKDCM_RangeShifterType                     "300a|0320"
#define GKDCM_RangeShifterDescription              "300a|0322"
#define GKDCM_NumberOfLateralSpreadingDevices      "300a|0330"
#define GKDCM_LateralSpreadingDeviceSequence       "300a|0332"
#define GKDCM_LateralSpreadingDeviceNumber         "300a|0334"
#define GKDCM_LateralSpreadingDeviceID             "300a|0336"
#define GKDCM_LateralSpreadingDeviceType           "300a|0338"
#define GKDCM_LateralSpreadingDeviceDescription    "300a|033a"
#define GKDCM_LateralSpreadingDeviceWaterEquivalentThickness "300a|033c"
#define GKDCM_NumberOfRangeModulators              "300a|0340"
#define GKDCM_RangeModulatorSequence               "300a|0342"
#define GKDCM_RangeModulatorNumber                 "300a|0344"
#define GKDCM_RangeModulatorID                     "300a|0346"
#define GKDCM_RangeModulatorType                   "300a|0348"
#define GKDCM_RangeModulatorDescription            "300a|034a"
#define GKDCM_BeamCurrentModulationID              "300a|034c"
#define GKDCM_PatientSupportType                   "300a|0350"
#define GKDCM_PatientSupportID                     "300a|0352"
#define GKDCM_PatientSupportAccessoryCode          "300a|0354"
#define GKDCM_FixationLightAzimuthalAngle          "300a|0356"
#define GKDCM_FixationLightPolarAngle              "300a|0358"
#define GKDCM_MetersetRate                         "300a|035a"
#define GKDCM_RangeShifterSettingsSequence         "300a|0360"
#define GKDCM_RangeShifterSetting                  "300a|0362"
#define GKDCM_IsocenterToRangeShifterDistance      "300a|0364"
#define GKDCM_RangeShifterWaterEquivalentThickness "300a|0366"
#define GKDCM_LateralSpreadingDeviceSettingsSequence "300a|0370"
#define GKDCM_LateralSpreadingDeviceSetting        "300a|0372"
#define GKDCM_IsocenterToLateralSpreadingDeviceDistance "300a|0374"
#define GKDCM_RangeModulatorSettingsSequence       "300a|0380"
#define GKDCM_RangeModulatorGatingStartValue       "300a|0382"
#define GKDCM_RangeModulatorGatingStopValue        "300a|0384"
#define GKDCM_RangeModulatorGatingStartWaterEquivalentThickness "300a|0386"
#define GKDCM_RangeModulatorGatingStopWaterEquivalentThickness "300a|0388"
#define GKDCM_IsocenterToRangeModulatorDistance    "300a|038a"
#define GKDCM_ScanSpotTuneID                       "300a|0390"
#define GKDCM_NumberOfScanSpotPositions            "300a|0392"
#define GKDCM_ScanSpotPositionMap                  "300a|0394"
#define GKDCM_ScanSpotMetersetWeights              "300a|0396"
#define GKDCM_ScanningSpotSize                     "300a|0398"
#define GKDCM_NumberOfPaintings                    "300a|039a"
#define GKDCM_IonToleranceTableSequence            "300a|03a0"
#define GKDCM_IonBeamSequence                      "300a|03a2"
#define GKDCM_IonBeamLimitingDeviceSequence        "300a|03a4"
#define GKDCM_IonBlockSequence                     "300a|03a6"
#define GKDCM_IonControlPointSequence              "300a|03a8"
#define GKDCM_IonWedgeSequence                     "300a|03aa"
#define GKDCM_IonWedgePositionSequence             "300a|03ac"
#define GKDCM_ReferencedSetupImageSequence         "300a|0401"
#define GKDCM_SetupImageComment                    "300a|0402"
#define GKDCM_MotionSynchronizationSequence        "300a|0410"
#define GKDCM_ControlPointOrientation              "300a|0412"
#define GKDCM_GeneralAccessorySequence             "300a|0420"
#define GKDCM_GeneralAccessoryID                   "300a|0421"
#define GKDCM_GeneralAccessoryDescription          "300a|0422"
#define GKDCM_GeneralAccessoryType                 "300a|0423"
#define GKDCM_GeneralAccessoryNumber               "300a|0424"
#define GKDCM_ApplicatorGeometrySequence           "300a|0431"
#define GKDCM_ApplicatorApertureShape              "300a|0432"
#define GKDCM_ApplicatorOpening                    "300a|0433"
#define GKDCM_ApplicatorOpeningX                   "300a|0434"
#define GKDCM_ApplicatorOpeningY                   "300a|0435"
#define GKDCM_SourceToApplicatorMountingPositionDistance "300a|0436"
#define GKDCM_ReferencedRTPlanSequence             "300c|0002"
#define GKDCM_ReferencedBeamSequence               "300c|0004"
#define GKDCM_ReferencedBeamNumber                 "300c|0006"
#define GKDCM_ReferencedReferenceImageNumber       "300c|0007"
#define GKDCM_StartCumulativeMetersetWeight        "300c|0008"
#define GKDCM_EndCumulativeMetersetWeight          "300c|0009"
#define GKDCM_ReferencedBrachyApplicationSetupSequence "300c|000a"
#define GKDCM_ReferencedBrachyApplicationSetupNumber "300c|000c"
#define GKDCM_ReferencedSourceNumber               "300c|000e"
#define GKDCM_ReferencedFractionGroupSequence      "300c|0020"
#define GKDCM_ReferencedFractionGroupNumber        "300c|0022"
#define GKDCM_ReferencedVerificationImageSequence  "300c|0040"
#define GKDCM_ReferencedReferenceImageSequence     "300c|0042"
#define GKDCM_ReferencedDoseReferenceSequence      "300c|0050"
#define GKDCM_ReferencedDoseReferenceNumber        "300c|0051"
#define GKDCM_BrachyReferencedDoseReferenceSequence "300c|0055"
#define GKDCM_ReferencedStructureSetSequence       "300c|0060"
#define GKDCM_ReferencedPatientSetupNumber         "300c|006a"
#define GKDCM_ReferencedDoseSequence               "300c|0080"
#define GKDCM_ReferencedToleranceTableNumber       "300c|00a0"
#define GKDCM_ReferencedBolusSequence              "300c|00b0"
#define GKDCM_ReferencedWedgeNumber                "300c|00c0"
#define GKDCM_ReferencedCompensatorNumber          "300c|00d0"
#define GKDCM_ReferencedBlockNumber                "300c|00e0"
#define GKDCM_ReferencedControlPointIndex          "300c|00f0"
#define GKDCM_ReferencedControlPointSequence       "300c|00f2"
#define GKDCM_ReferencedStartControlPointIndex     "300c|00f4"
#define GKDCM_ReferencedStopControlPointIndex      "300c|00f6"
#define GKDCM_ReferencedRangeShifterNumber         "300c|0100"
#define GKDCM_ReferencedLateralSpreadingDeviceNumber "300c|0102"
#define GKDCM_ReferencedRangeModulatorNumber       "300c|0104"
#define GKDCM_ApprovalStatus                       "300e|0002"
#define GKDCM_ReviewDate                           "300e|0004"
#define GKDCM_ReviewTime                           "300e|0005"
#define GKDCM_ReviewerName                         "300e|0008"
#define GKDCM_ACR_NEMA_TextGroupLength             "4000|0000"
#define GKDCM_ACR_NEMA_TextArbitrary               "4000|0010"
#define GKDCM_ACR_NEMA_TextComments                "4000|4000"
#define GKDCM_RETIRED_ResultsID                    "4008|0040"
#define GKDCM_RETIRED_ResultsIDIssuer              "4008|0042"
#define GKDCM_RETIRED_ReferencedInterpretationSequence "4008|0050"
#define GKDCM_RETIRED_InterpretationRecordedDate   "4008|0100"
#define GKDCM_RETIRED_InterpretationRecordedTime   "4008|0101"
#define GKDCM_RETIRED_InterpretationRecorder       "4008|0102"
#define GKDCM_RETIRED_ReferenceToRecordedSound     "4008|0103"
#define GKDCM_RETIRED_InterpretationTranscriptionDate "4008|0108"
#define GKDCM_RETIRED_InterpretationTranscriptionTime "4008|0109"
#define GKDCM_RETIRED_InterpretationTranscriber    "4008|010a"
#define GKDCM_RETIRED_InterpretationText           "4008|010b"
#define GKDCM_RETIRED_InterpretationAuthor         "4008|010c"
#define GKDCM_RETIRED_InterpretationApproverSequence "4008|0111"
#define GKDCM_RETIRED_InterpretationApprovalDate   "4008|0112"
#define GKDCM_RETIRED_InterpretationApprovalTime   "4008|0113"
#define GKDCM_RETIRED_PhysicianApprovingInterpretation "4008|0114"
#define GKDCM_RETIRED_InterpretationDiagnosisDescription "4008|0115"
#define GKDCM_RETIRED_InterpretationDiagnosisCodeSequence "4008|0117"
#define GKDCM_RETIRED_ResultsDistributionListSequence "4008|0118"
#define GKDCM_RETIRED_DistributionName             "4008|0119"
#define GKDCM_RETIRED_DistributionAddress          "4008|011a"
#define GKDCM_RETIRED_InterpretationID             "4008|0200"
#define GKDCM_RETIRED_InterpretationIDIssuer       "4008|0202"
#define GKDCM_RETIRED_InterpretationTypeID         "4008|0210"
#define GKDCM_RETIRED_InterpretationStatusID       "4008|0212"
#define GKDCM_RETIRED_Impressions                  "4008|0300"
#define GKDCM_RETIRED_ResultsComments              "4008|4000"
#define GKDCM_MACParametersSequence                "4ffe|0001"
#define GKDCM_SharedFunctionalGroupsSequence       "5200|9229"
#define GKDCM_PerFrameFunctionalGroupsSequence     "5200|9230"
#define GKDCM_WaveformSequence                     "5400|0100"
#define GKDCM_ChannelMinimumValue                  "5400|0110"
#define GKDCM_ChannelMaximumValue                  "5400|0112"
#define GKDCM_WaveformBitsAllocated                "5400|1004"
#define GKDCM_WaveformSampleInterpretation         "5400|1006"
#define GKDCM_WaveformPaddingValue                 "5400|100a"
#define GKDCM_WaveformData                         "5400|1010"
#define GKDCM_FirstOrderPhaseCorrectionAngle       "5600|0010"
#define GKDCM_SpectroscopyData                     "5600|0020"
#define GKDCM_PixelData                            "7fe0|0010"
#define GKDCM_ACR_NEMA_2C_CoefficientsSDVN         "7fe0|0020"
#define GKDCM_ACR_NEMA_2C_CoefficientsSDHN         "7fe0|0030"
#define GKDCM_ACR_NEMA_2C_CoefficientsSDDN         "7fe0|0040"
#define GKDCM_DigitalSignaturesSequence            "fffa|fffa"
#define GKDCM_DataSetTrailingPadding               "fffc|fffc"
#define GKDCM_Item                                 "fffe|e000"
#define GKDCM_ItemDelimitationItem                 "fffe|e00d"
#define GKDCM_SequenceDelimitationItem             "fffe|e0dd"

/*
** Tags where the group/element can vary (repeating tags".
** Number of entries: 78
*/
#define GKDCM_OverlayRows                          "6000|0010" /* (0x6000-0x60ff,0x0010" */
#define GKDCM_OverlayColumns                       "6000|0011" /* (0x6000-0x60ff,0x0011" */
#define GKDCM_NumberOfFramesInOverlay              "6000|0015" /* (0x6000-0x60ff,0x0015" */
#define GKDCM_OverlayDescription                   "6000|0022" /* (0x6000-0x60ff,0x0022" */
#define GKDCM_OverlayType                          "6000|0040" /* (0x6000-0x60ff,0x0040" */
#define GKDCM_OverlaySubtype                       "6000|0045" /* (0x6000-0x60ff,0x0045" */
#define GKDCM_OverlayOrigin                        "6000|0050" /* (0x6000-0x60ff,0x0050" */
#define GKDCM_ImageFrameOrigin                     "6000|0051" /* (0x6000-0x60ff,0x0051" */
#define GKDCM_OverlayBitsAllocated                 "6000|0100" /* (0x6000-0x60ff,0x0100" */
#define GKDCM_OverlayBitPosition                   "6000|0102" /* (0x6000-0x60ff,0x0102" */
#define GKDCM_OverlayActivationLayer               "6000|1001" /* (0x6000-0x60ff,0x1001" */
#define GKDCM_ROIArea                              "6000|1301" /* (0x6000-0x60ff,0x1301" */
#define GKDCM_ROIMean                              "6000|1302" /* (0x6000-0x60ff,0x1302" */
#define GKDCM_ROIStandardDeviation                 "6000|1303" /* (0x6000-0x60ff,0x1303" */
#define GKDCM_OverlayLabel                         "6000|1500" /* (0x6000-0x60ff,0x1500" */
#define GKDCM_OverlayData                          "6000|3000" /* (0x6000-0x60ff,0x3000" */
#define GKDCM_ACR_NEMA_2C_VariablePixelDataGroupLength "7f00|0000" /* (0x7f00-0x7fff,0x0000" */
#define GKDCM_PrivateGroupLength                   "0009|0000" /* (0x0009-o-0xffff,0x0000" */
#define GKDCM_RETIRED_NumberOfPoints               "5000|0010" /* (0x5000-0x50ff,0x0010" */
#define GKDCM_RETIRED_TypeOfData                   "5000|0020" /* (0x5000-0x50ff,0x0020" */
#define GKDCM_RETIRED_CurveDescription             "5000|0022" /* (0x5000-0x50ff,0x0022" */
#define GKDCM_RETIRED_AxisUnits                    "5000|0030" /* (0x5000-0x50ff,0x0030" */
#define GKDCM_RETIRED_AxisLabels                   "5000|0040" /* (0x5000-0x50ff,0x0040" */
#define GKDCM_RETIRED_OverlayPlanes                "6000|0012" /* (0x6000-0x60ff,0x0012" */
#define GKDCM_RETIRED_OverlayPlaneOrigin           "6000|0052" /* (0x6000-0x60ff,0x0052" */
#define GKDCM_ACR_NEMA_2C_OverlayCompressionCode   "6000|0060" /* (0x6000-0x60ff,0x0060" */
#define GKDCM_ACR_NEMA_2C_OverlayCompressionOriginator "6000|0061" /* (0x6000-0x60ff,0x0061" */
#define GKDCM_ACR_NEMA_2C_OverlayCompressionLabel  "6000|0062" /* (0x6000-0x60ff,0x0062" */
#define GKDCM_ACR_NEMA_2C_OverlayCompressionDescription "6000|0063" /* (0x6000-0x60ff,0x0063" */
#define GKDCM_ACR_NEMA_2C_OverlayCompressionStepPointers "6000|0066" /* (0x6000-0x60ff,0x0066" */
#define GKDCM_ACR_NEMA_2C_OverlayRepeatInterval    "6000|0068" /* (0x6000-0x60ff,0x0068" */
#define GKDCM_ACR_NEMA_2C_OverlayBitsGrouped       "6000|0069" /* (0x6000-0x60ff,0x0069" */
#define GKDCM_ACR_NEMA_2C_VariablePixelData        "7f00|0010" /* (0x7f00-0x7fff,0x0010" */
#define GKDCM_ACR_NEMA_2C_VariableNextDataGroup    "7f00|0011" /* (0x7f00-0x7fff,0x0011" */
#define GKDCM_ACR_NEMA_2C_VariableCoefficientsSDVN "7f00|0020" /* (0x7f00-0x7fff,0x0020" */
#define GKDCM_ACR_NEMA_2C_VariableCoefficientsSDHN "7f00|0030" /* (0x7f00-0x7fff,0x0030" */
#define GKDCM_ACR_NEMA_2C_VariableCoefficientsSDDN "7f00|0040" /* (0x7f00-0x7fff,0x0040" */
#define GKDCM_PrivateCreator                       "0009|0010" /* (0x0009-o-0xffff,0x0010-u-0x00ff" */
#define GKDCM_IllegalGroupLength                   "0001|0000" /* (0x0001-o-0x0007,0x0000" */
#define GKDCM_IllegalPrivateCreator                "0001|0010" /* (0x0001-o-0x0007,0x0010-u-0x00ff" */
#define GKDCM_GenericGroupLength                   "0000|0000" /* (0x0000-u-0xffff,0x0000" */
#define GKDCM_ACR_NEMA_SourceImageID               "0020|3100" /* (0x0020,0x3100-0x31ff" */
#define GKDCM_RETIRED_CurveDimensions              "5000|0005" /* (0x5000-0x50ff,0x0005" */
#define GKDCM_RETIRED_DataValueRepresentation      "5000|0103" /* (0x5000-0x50ff,0x0103" */
#define GKDCM_RETIRED_MinimumCoordinateValue       "5000|0104" /* (0x5000-0x50ff,0x0104" */
#define GKDCM_RETIRED_MaximumCoordinateValue       "5000|0105" /* (0x5000-0x50ff,0x0105" */
#define GKDCM_RETIRED_CurveRange                   "5000|0106" /* (0x5000-0x50ff,0x0106" */
#define GKDCM_RETIRED_CurveDataDescriptor          "5000|0110" /* (0x5000-0x50ff,0x0110" */
#define GKDCM_RETIRED_CoordinateStartValue         "5000|0112" /* (0x5000-0x50ff,0x0112" */
#define GKDCM_RETIRED_CoordinateStepValue          "5000|0114" /* (0x5000-0x50ff,0x0114" */
#define GKDCM_RETIRED_CurveActivationLayer         "5000|1001" /* (0x5000-0x50ff,0x1001" */
#define GKDCM_RETIRED_AudioType                    "5000|2000" /* (0x5000-0x50ff,0x2000" */
#define GKDCM_RETIRED_AudioSampleFormat            "5000|2002" /* (0x5000-0x50ff,0x2002" */
#define GKDCM_RETIRED_NumberOfChannels             "5000|2004" /* (0x5000-0x50ff,0x2004" */
#define GKDCM_RETIRED_NumberOfSamples              "5000|2006" /* (0x5000-0x50ff,0x2006" */
#define GKDCM_RETIRED_SampleRate                   "5000|2008" /* (0x5000-0x50ff,0x2008" */
#define GKDCM_RETIRED_TotalTime                    "5000|200a" /* (0x5000-0x50ff,0x200a" */
#define GKDCM_RETIRED_AudioSampleData              "5000|200c" /* (0x5000-0x50ff,0x200c" */
#define GKDCM_RETIRED_AudioComments                "5000|200e" /* (0x5000-0x50ff,0x200e" */
#define GKDCM_RETIRED_CurveLabel                   "5000|2500" /* (0x5000-0x50ff,0x2500" */
#define GKDCM_RETIRED_CurveReferencedOverlaySequence "5000|2600" /* (0x5000-0x50ff,0x2600" */
#define GKDCM_RETIRED_CurveReferencedOverlayGroup  "5000|2610" /* (0x5000-0x50ff,0x2610" */
#define GKDCM_RETIRED_CurveData                    "5000|3000" /* (0x5000-0x50ff,0x3000" */
#define GKDCM_ACR_NEMA_OverlayFormat               "6000|0110" /* (0x6000-0x60ff,0x0110" */
#define GKDCM_ACR_NEMA_OverlayLocation             "6000|0200" /* (0x6000-0x60ff,0x0200" */
#define GKDCM_ACR_NEMA_2C_OverlayCodeLabel         "6000|0800" /* (0x6000-0x60ff,0x0800" */
#define GKDCM_ACR_NEMA_2C_OverlayNumberOfTables    "6000|0802" /* (0x6000-0x60ff,0x0802" */
#define GKDCM_ACR_NEMA_2C_OverlayCodeTableLocation "6000|0803" /* (0x6000-0x60ff,0x0803" */
#define GKDCM_ACR_NEMA_2C_OverlayBitsForCodeWord   "6000|0804" /* (0x6000-0x60ff,0x0804" */
#define GKDCM_RETIRED_OverlayDescriptorGray        "6000|1100" /* (0x6000-0x60ff,0x1100" */
#define GKDCM_RETIRED_OverlayDescriptorRed         "6000|1101" /* (0x6000-0x60ff,0x1101" */
#define GKDCM_RETIRED_OverlayDescriptorGreen       "6000|1102" /* (0x6000-0x60ff,0x1102" */
#define GKDCM_RETIRED_OverlayDescriptorBlue        "6000|1103" /* (0x6000-0x60ff,0x1103" */
#define GKDCM_RETIRED_OverlaysGray                 "6000|1200" /* (0x6000-0x60ff,0x1200" */
#define GKDCM_RETIRED_OverlaysRed                  "6000|1201" /* (0x6000-0x60ff,0x1201" */
#define GKDCM_RETIRED_OverlaysGreen                "6000|1202" /* (0x6000-0x60ff,0x1202" */
#define GKDCM_RETIRED_OverlaysBlue                 "6000|1203" /* (0x6000-0x60ff,0x1203" */
#define GKDCM_ACR_NEMA_OverlayComments             "6000|4000" /* (0x6000-0x60ff,0x4000" */

