// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package f3

import "time"

type Comment struct {
	Common
	PosterID    *Reference    `json:"poster_id"`
	Created     time.Time     `json:"created"`
	Updated     time.Time     `json:"updated"`
	Content     string        `json:"content"`
	Attachments []*Attachment `json:"attachments"`
}

func (o *Comment) GetReferences() References {
	references := o.Common.GetReferences()
	if !o.PosterID.IsNil() {
		references = append(references, o.PosterID)
	}
	return references
}

func (o Comment) Equal(other Comment) bool {
	return o.Common.Equal(other.Common) &&
		nilOrEqual(o.PosterID, other.PosterID) &&
		o.Content == other.Content &&
		arrayEqual(o.Attachments, other.Attachments)
}

func (o *Comment) Clone() Interface {
	clone := &Comment{}
	*clone = *o
	return clone
}
