// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Specifies the prediction (aka, the automatically generated piece of metadata)
// and the target (for example, a column name) that can be accepted.
type AcceptChoice struct {

	// Specifies the target (for example, a column name) where a prediction can be
	// accepted.
	//
	// This member is required.
	PredictionTarget *string

	// The edit of the prediction.
	EditedValue *string

	// Specifies the prediction (aka, the automatically generated piece of metadata)
	// that can be accepted.
	PredictionChoice *int32

	noSmithyDocumentSerde
}

// Specifies the rule and the threshold under which a prediction can be accepted.
type AcceptRule struct {

	// Specifies whether you want to accept the top prediction for all targets or none.
	Rule AcceptRuleBehavior

	// The confidence score that specifies the condition at which a prediction can be
	// accepted.
	Threshold *float32

	noSmithyDocumentSerde
}

// The parameters of the environment action.
//
// The following types satisfy this interface:
//
//	ActionParametersMemberAwsConsoleLink
type ActionParameters interface {
	isActionParameters()
}

// The console link specified as part of the environment action.
type ActionParametersMemberAwsConsoleLink struct {
	Value AwsConsoleLinkParameters

	noSmithyDocumentSerde
}

func (*ActionParametersMemberAwsConsoleLink) isActionParameters() {}

// A Amazon DataZone inventory asset.
type AssetItem struct {

	// The identifier of the Amazon DataZone domain in which the inventory asset
	// exists.
	//
	// This member is required.
	DomainId *string

	// the identifier of the Amazon DataZone inventory asset.
	//
	// This member is required.
	Identifier *string

	// The name of the Amazon DataZone inventory asset.
	//
	// This member is required.
	Name *string

	// The identifier of the Amazon DataZone project that owns the inventory asset.
	//
	// This member is required.
	OwningProjectId *string

	// The identifier of the asset type of the specified Amazon DataZone inventory
	// asset.
	//
	// This member is required.
	TypeIdentifier *string

	// The revision of the inventory asset type.
	//
	// This member is required.
	TypeRevision *string

	// The additional attributes of a Amazon DataZone inventory asset.
	AdditionalAttributes *AssetItemAdditionalAttributes

	// The timestamp of when the Amazon DataZone inventory asset was created.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the inventory asset.
	CreatedBy *string

	// The description of an Amazon DataZone inventory asset.
	Description *string

	// The external identifier of the Amazon DataZone inventory asset.
	ExternalIdentifier *string

	// The timestamp of when the first revision of the inventory asset was created.
	FirstRevisionCreatedAt *time.Time

	// The Amazon DataZone user who created the first revision of the inventory asset.
	FirstRevisionCreatedBy *string

	// The glossary terms attached to the Amazon DataZone inventory asset.
	GlossaryTerms []string

	noSmithyDocumentSerde
}

// The additional attributes of an inventory asset.
type AssetItemAdditionalAttributes struct {

	// The forms included in the additional attributes of an inventory asset.
	FormsOutput []FormOutput

	// The latest time series data points forms included in the additional attributes
	// of an asset.
	LatestTimeSeriesDataPointFormsOutput []TimeSeriesDataPointSummaryFormOutput

	// The read-only forms included in the additional attributes of an inventory asset.
	ReadOnlyFormsOutput []FormOutput

	noSmithyDocumentSerde
}

// An asset published in an Amazon DataZone catalog.
type AssetListing struct {

	// The identifier of an asset published in an Amazon DataZone catalog.
	AssetId *string

	// The revision of an asset published in an Amazon DataZone catalog.
	AssetRevision *string

	// The type of an asset published in an Amazon DataZone catalog.
	AssetType *string

	// The timestamp of when an asset published in an Amazon DataZone catalog was
	// created.
	CreatedAt *time.Time

	// The metadata forms attached to an asset published in an Amazon DataZone
	// catalog.
	Forms *string

	// The glossary terms attached to an asset published in an Amazon DataZone
	// catalog.
	GlossaryTerms []DetailedGlossaryTerm

	// The latest time series data points forms included in the additional attributes
	// of an asset.
	LatestTimeSeriesDataPointForms []TimeSeriesDataPointSummaryFormOutput

	// The identifier of the project where an asset published in an Amazon DataZone
	// catalog exists.
	OwningProjectId *string

	noSmithyDocumentSerde
}

// The details of an asset published in an Amazon DataZone catalog.
type AssetListingDetails struct {

	// The identifier of an asset published in an Amazon DataZone catalog.
	//
	// This member is required.
	ListingId *string

	// The status of an asset published in an Amazon DataZone catalog.
	//
	// This member is required.
	ListingStatus ListingStatus

	noSmithyDocumentSerde
}

// The details of an asset published in an Amazon DataZone catalog.
type AssetListingItem struct {

	// The additional attributes of an asset published in an Amazon DataZone catalog.
	AdditionalAttributes *AssetListingItemAdditionalAttributes

	// The timestamp of when an asset published in an Amazon DataZone catalog was
	// created.
	CreatedAt *time.Time

	// The description of an asset published in an Amazon DataZone catalog.
	Description *string

	// The identifier of the inventory asset.
	EntityId *string

	// The revision of the inventory asset.
	EntityRevision *string

	// The type of the inventory asset.
	EntityType *string

	// Glossary terms attached to the inventory asset.
	GlossaryTerms []DetailedGlossaryTerm

	// The Amazon DataZone user who created the listing.
	ListingCreatedBy *string

	// The identifier of the listing (asset published in Amazon DataZone catalog).
	ListingId *string

	// The revision of the listing (asset published in Amazon DataZone catalog).
	ListingRevision *string

	// The Amazon DataZone user who updated the listing.
	ListingUpdatedBy *string

	// The name of the inventory asset.
	Name *string

	// The identifier of the project that owns the inventory asset.
	OwningProjectId *string

	noSmithyDocumentSerde
}

// Additional attributes of an inventory asset.
type AssetListingItemAdditionalAttributes struct {

	// The metadata forms that form additional attributes of the metadata asset.
	Forms *string

	// The latest time series data points forms included in the additional attributes
	// of an asset.
	LatestTimeSeriesDataPointForms []TimeSeriesDataPointSummaryFormOutput

	noSmithyDocumentSerde
}

// The revision of an inventory asset.
type AssetRevision struct {

	// The timestamp of when an inventory asset revison was created.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the asset revision.
	CreatedBy *string

	// The Amazon DataZone user who created the inventory asset.
	DomainId *string

	// The identifier of the inventory asset revision.
	Id *string

	// The revision details of the inventory asset.
	Revision *string

	noSmithyDocumentSerde
}

// The name map for assets.
type AssetTargetNameMap struct {

	// The identifier of the inventory asset.
	//
	// This member is required.
	AssetId *string

	// The target name in the asset target name map.
	//
	// This member is required.
	TargetName *string

	noSmithyDocumentSerde
}

// The details of the asset type.
type AssetTypeItem struct {

	// The identifier of the Amazon DataZone domain where the asset type exists.
	//
	// This member is required.
	DomainId *string

	// The forms included in the details of the asset type.
	//
	// This member is required.
	FormsOutput map[string]FormEntryOutput

	// The name of the asset type.
	//
	// This member is required.
	Name *string

	// The identifier of the Amazon DataZone project that owns the asset type.
	//
	// This member is required.
	OwningProjectId *string

	// The revision of the asset type.
	//
	// This member is required.
	Revision *string

	// The timestamp of when the asset type was created.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the asset type.
	CreatedBy *string

	// The description of the asset type.
	Description *string

	// The identifier of the Amazon DataZone domain where the asset type was
	// originally created.
	OriginDomainId *string

	// The identifier of the Amazon DataZone project where the asset type exists.
	OriginProjectId *string

	// The timestamp of when the asset type was updated.
	UpdatedAt *time.Time

	// The Amazon DataZone user who updated the asset type.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The parameters of the console link specified as part of the environment action.
type AwsConsoleLinkParameters struct {

	// The URI of the console link specified as part of the environment action.
	Uri *string

	noSmithyDocumentSerde
}

// The configuration of the business name generation.
type BusinessNameGenerationConfiguration struct {

	// Specifies whether the business name generation is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

// Part of the provisioning properties of the environment blueprint.
type CloudFormationProperties struct {

	// The template URL of the cloud formation provisioning properties of the
	// environment blueprint.
	//
	// This member is required.
	TemplateUrl *string

	noSmithyDocumentSerde
}

// The details of the parameters for the configurable environment action.
type ConfigurableActionParameter struct {

	// The key of the configurable action parameter.
	Key *string

	// The value of the configurable action parameter.
	Value *string

	noSmithyDocumentSerde
}

// The configurable action of a Amazon DataZone environment.
type ConfigurableEnvironmentAction struct {

	// The parameters of a configurable action in a Amazon DataZone environment.
	//
	// This member is required.
	Parameters []ConfigurableActionParameter

	// The type of a configurable action in a Amazon DataZone environment.
	//
	// This member is required.
	Type *string

	// The authentication type of a configurable action of a Amazon DataZone
	// environment.
	Auth ConfigurableActionTypeAuthorization

	noSmithyDocumentSerde
}

// The details of user parameters of an environment blueprint.
type CustomParameter struct {

	// The filed type of the parameter.
	//
	// This member is required.
	FieldType *string

	// The key name of the parameter.
	//
	// This member is required.
	KeyName *string

	// The default value of the parameter.
	DefaultValue *string

	// The description of the parameter.
	Description *string

	// Specifies whether the parameter is editable.
	IsEditable *bool

	// Specifies whether the custom parameter is optional.
	IsOptional *bool

	noSmithyDocumentSerde
}

type DataProductItem struct {

	//
	DomainId *string

	//
	ItemId *string

	noSmithyDocumentSerde
}

type DataProductSummary struct {

	//
	//
	// This member is required.
	DomainId *string

	//
	//
	// This member is required.
	Id *string

	//
	//
	// This member is required.
	Name *string

	//
	//
	// This member is required.
	OwningProjectId *string

	//
	CreatedAt *time.Time

	//
	CreatedBy *string

	//
	//
	// Deprecated: This structure is deprecated.
	DataProductItems []DataProductItem

	//
	Description *string

	//
	GlossaryTerms []string

	//
	UpdatedAt *time.Time

	//
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The configuration of the data source.
//
// The following types satisfy this interface:
//
//	DataSourceConfigurationInputMemberGlueRunConfiguration
//	DataSourceConfigurationInputMemberRedshiftRunConfiguration
type DataSourceConfigurationInput interface {
	isDataSourceConfigurationInput()
}

// The configuration of the Amazon Web Services Glue data source.
type DataSourceConfigurationInputMemberGlueRunConfiguration struct {
	Value GlueRunConfigurationInput

	noSmithyDocumentSerde
}

func (*DataSourceConfigurationInputMemberGlueRunConfiguration) isDataSourceConfigurationInput() {}

// The configuration of the Amazon Redshift data source.
type DataSourceConfigurationInputMemberRedshiftRunConfiguration struct {
	Value RedshiftRunConfigurationInput

	noSmithyDocumentSerde
}

func (*DataSourceConfigurationInputMemberRedshiftRunConfiguration) isDataSourceConfigurationInput() {}

// The configuration of the data source.
//
// The following types satisfy this interface:
//
//	DataSourceConfigurationOutputMemberGlueRunConfiguration
//	DataSourceConfigurationOutputMemberRedshiftRunConfiguration
type DataSourceConfigurationOutput interface {
	isDataSourceConfigurationOutput()
}

// The configuration of the Amazon Web Services Glue data source.
type DataSourceConfigurationOutputMemberGlueRunConfiguration struct {
	Value GlueRunConfigurationOutput

	noSmithyDocumentSerde
}

func (*DataSourceConfigurationOutputMemberGlueRunConfiguration) isDataSourceConfigurationOutput() {}

// The configuration of the Amazon Redshift data source.
type DataSourceConfigurationOutputMemberRedshiftRunConfiguration struct {
	Value RedshiftRunConfigurationOutput

	noSmithyDocumentSerde
}

func (*DataSourceConfigurationOutputMemberRedshiftRunConfiguration) isDataSourceConfigurationOutput() {
}

// The details of the error message that is returned if the operation cannot be
// successfully completed.
type DataSourceErrorMessage struct {

	// The type of the error message that is returned if the operation cannot be
	// successfully completed.
	//
	// This member is required.
	ErrorType DataSourceErrorType

	// The details of the error message that is returned if the operation cannot be
	// successfully completed.
	ErrorDetail *string

	noSmithyDocumentSerde
}

// The activity details of the data source run.
type DataSourceRunActivity struct {

	// The timestamp of when data source run activity was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The status of the asset included in the data source run activity.
	//
	// This member is required.
	DataAssetStatus DataAssetActivityStatus

	// The identifier of the data source for the data source run activity.
	//
	// This member is required.
	DataSourceRunId *string

	// The database included in the data source run activity.
	//
	// This member is required.
	Database *string

	// The project ID included in the data source run activity.
	//
	// This member is required.
	ProjectId *string

	// The technical name included in the data source run activity.
	//
	// This member is required.
	TechnicalName *string

	// The timestamp of when data source run activity was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The identifier of the asset included in the data source run activity.
	DataAssetId *string

	// The details of the error message that is returned if the operation cannot be
	// successfully completed.
	ErrorMessage *DataSourceErrorMessage

	// The technical description included in the data source run activity.
	TechnicalDescription *string

	noSmithyDocumentSerde
}

// The details of a data source run.
type DataSourceRunSummary struct {

	// The timestamp of when a data source run was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The identifier of the data source of the data source run.
	//
	// This member is required.
	DataSourceId *string

	// The identifier of the data source run.
	//
	// This member is required.
	Id *string

	// The project ID of the data source run.
	//
	// This member is required.
	ProjectId *string

	// The status of the data source run.
	//
	// This member is required.
	Status DataSourceRunStatus

	// The type of the data source run.
	//
	// This member is required.
	Type DataSourceRunType

	// The timestamp of when a data source run was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The details of the error message that is returned if the operation cannot be
	// successfully completed.
	ErrorMessage *DataSourceErrorMessage

	// The asset statistics from the data source run.
	RunStatisticsForAssets *RunStatisticsForAssets

	// The timestamp of when a data source run was started.
	StartedAt *time.Time

	// The timestamp of when a data source run was stopped.
	StoppedAt *time.Time

	noSmithyDocumentSerde
}

// The details of the data source.
type DataSourceSummary struct {

	// The ID of the data source.
	//
	// This member is required.
	DataSourceId *string

	// The ID of the Amazon DataZone domain in which the data source exists.
	//
	// This member is required.
	DomainId *string

	// The ID of the environment in which the data source exists.
	//
	// This member is required.
	EnvironmentId *string

	// The name of the data source.
	//
	// This member is required.
	Name *string

	// The status of the data source.
	//
	// This member is required.
	Status DataSourceStatus

	// The type of the data source.
	//
	// This member is required.
	Type *string

	// The timestamp of when the data source was created.
	CreatedAt *time.Time

	// Specifies whether the data source is enabled.
	EnableSetting EnableSetting

	// The count of the assets created during the last data source run.
	LastRunAssetCount *int32

	// The timestamp of when the data source run was last performed.
	LastRunAt *time.Time

	// The details of the error message that is returned if the operation cannot be
	// successfully completed.
	LastRunErrorMessage *DataSourceErrorMessage

	// The status of the last data source run.
	LastRunStatus DataSourceRunStatus

	// The details of the schedule of the data source runs.
	Schedule *ScheduleConfiguration

	// The timestamp of when the data source was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The details of the last deployment of the environment.
type Deployment struct {

	// The identifier of the last deployment of the environment.
	DeploymentId *string

	// The status of the last deployment of the environment.
	DeploymentStatus DeploymentStatus

	// The type of the last deployment of the environment.
	DeploymentType DeploymentType

	// The failure reason of the last deployment of the environment.
	FailureReason *EnvironmentError

	// Specifies whether the last deployment of the environment is complete.
	IsDeploymentComplete *bool

	// The messages of the last deployment of the environment.
	Messages []string

	noSmithyDocumentSerde
}

// The deployment properties of the Amazon DataZone blueprint.
type DeploymentProperties struct {

	// The end timeout of the environment blueprint deployment.
	EndTimeoutMinutes *int32

	// The start timeout of the environment blueprint deployment.
	StartTimeoutMinutes *int32

	noSmithyDocumentSerde
}

// Details of a glossary term attached to the inventory asset.
type DetailedGlossaryTerm struct {

	// The name of a glossary term attached to the inventory asset.
	Name *string

	// The shoft description of a glossary term attached to the inventory asset.
	ShortDescription *string

	noSmithyDocumentSerde
}

// A summary of a Amazon DataZone domain.
type DomainSummary struct {

	// The ARN of the Amazon DataZone domain.
	//
	// This member is required.
	Arn *string

	// A timestamp of when a Amazon DataZone domain was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the Amazon DataZone domain.
	//
	// This member is required.
	Id *string

	// The identifier of the Amazon Web Services account that manages the domain.
	//
	// This member is required.
	ManagedAccountId *string

	// A name of an Amazon DataZone domain.
	//
	// This member is required.
	Name *string

	// The status of the Amazon DataZone domain.
	//
	// This member is required.
	Status DomainStatus

	// A description of an Amazon DataZone domain.
	Description *string

	// A timestamp of when a Amazon DataZone domain was last updated.
	LastUpdatedAt *time.Time

	// The data portal URL for the Amazon DataZone domain.
	PortalUrl *string

	noSmithyDocumentSerde
}

// The details about the specified action configured for an environment. For
// example, the details of the specified console links for an analytics tool that
// is available in this environment.
type EnvironmentActionSummary struct {

	// The Amazon DataZone domain ID of the environment action.
	//
	// This member is required.
	DomainId *string

	// The environment ID of the environment action.
	//
	// This member is required.
	EnvironmentId *string

	// The ID of the environment action.
	//
	// This member is required.
	Id *string

	// The name of the environment action.
	//
	// This member is required.
	Name *string

	// The parameters of the environment action.
	//
	// This member is required.
	Parameters ActionParameters

	// The environment action description.
	Description *string

	noSmithyDocumentSerde
}

// The configuration details of an environment blueprint.
type EnvironmentBlueprintConfigurationItem struct {

	// The identifier of the Amazon DataZone domain in which an environment blueprint
	// exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of the environment blueprint.
	//
	// This member is required.
	EnvironmentBlueprintId *string

	// The timestamp of when an environment blueprint was created.
	CreatedAt *time.Time

	// The enabled Amazon Web Services Regions specified in a blueprint configuration.
	EnabledRegions []string

	// The ARN of the manage access role specified in the environment blueprint
	// configuration.
	ManageAccessRoleArn *string

	// The ARN of the provisioning role specified in the environment blueprint
	// configuration.
	ProvisioningRoleArn *string

	// The regional parameters of the environment blueprint.
	RegionalParameters map[string]map[string]string

	// The timestamp of when the environment blueprint was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The details of an environment blueprint summary.
type EnvironmentBlueprintSummary struct {

	// The identifier of the blueprint.
	//
	// This member is required.
	Id *string

	// The name of the blueprint.
	//
	// This member is required.
	Name *string

	// The provider of the blueprint.
	//
	// This member is required.
	Provider *string

	// The provisioning properties of the blueprint.
	//
	// This member is required.
	ProvisioningProperties ProvisioningProperties

	// The timestamp of when an environment blueprint was created.
	CreatedAt *time.Time

	// The description of a blueprint.
	Description *string

	// The timestamp of when the blueprint was enabled.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The failure reasons for the environment deployment.
type EnvironmentError struct {

	// The error message for the failure reason for the environment deployment.
	//
	// This member is required.
	Message *string

	// The error code for the failure reason for the environment deployment.
	Code *string

	noSmithyDocumentSerde
}

// The parameter details of an evironment profile.
type EnvironmentParameter struct {

	// The name of an environment profile parameter.
	Name *string

	// The value of an environment profile parameter.
	Value *string

	noSmithyDocumentSerde
}

// The details of an environment profile.
type EnvironmentProfileSummary struct {

	// The Amazon DataZone user who created the environment profile.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which the environment profile
	// exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of a blueprint with which an environment profile is created.
	//
	// This member is required.
	EnvironmentBlueprintId *string

	// The identifier of the environment profile.
	//
	// This member is required.
	Id *string

	// The name of the environment profile.
	//
	// This member is required.
	Name *string

	// The identifier of an Amazon Web Services account in which an environment
	// profile exists.
	AwsAccountId *string

	// The Amazon Web Services Region in which an environment profile exists.
	AwsAccountRegion *string

	// The timestamp of when an environment profile was created.
	CreatedAt *time.Time

	// The description of the environment profile.
	Description *string

	// The identifier of a project in which an environment profile exists.
	ProjectId *string

	// The timestamp of when the environment profile was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The details of an environment.
type EnvironmentSummary struct {

	// The Amazon DataZone user who created the environment.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which the environment exists.
	//
	// This member is required.
	DomainId *string

	// The name of the environment.
	//
	// This member is required.
	Name *string

	// The identifier of the project in which the environment exists.
	//
	// This member is required.
	ProjectId *string

	// The provider of the environment.
	//
	// This member is required.
	Provider *string

	// The identifier of the Amazon Web Services account in which an environment
	// exists.
	AwsAccountId *string

	// The Amazon Web Services Region in which an environment exists.
	AwsAccountRegion *string

	// The timestamp of when the environment was created.
	CreatedAt *time.Time

	// The description of the environment.
	Description *string

	// The identifier of the environment profile with which the environment was
	// created.
	EnvironmentProfileId *string

	// The identifier of the environment.
	Id *string

	// The status of the environment.
	Status EnvironmentStatus

	// The timestamp of when the environment was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Specifies the error message that is returned if the operation cannot be
// successfully completed.
type FailureCause struct {

	// The description of the error message.
	Message *string

	noSmithyDocumentSerde
}

// A search filter in Amazon DataZone.
type Filter struct {

	// A search filter attribute in Amazon DataZone.
	//
	// This member is required.
	Attribute *string

	// A search filter value in Amazon DataZone.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// A search filter clause in Amazon DataZone.
//
// The following types satisfy this interface:
//
//	FilterClauseMemberAnd
//	FilterClauseMemberFilter
//	FilterClauseMemberOr
type FilterClause interface {
	isFilterClause()
}

// The 'and' search filter clause in Amazon DataZone.
type FilterClauseMemberAnd struct {
	Value []FilterClause

	noSmithyDocumentSerde
}

func (*FilterClauseMemberAnd) isFilterClause() {}

// A search filter in Amazon DataZone.
type FilterClauseMemberFilter struct {
	Value Filter

	noSmithyDocumentSerde
}

func (*FilterClauseMemberFilter) isFilterClause() {}

// The 'or' search filter clause in Amazon DataZone.
type FilterClauseMemberOr struct {
	Value []FilterClause

	noSmithyDocumentSerde
}

func (*FilterClauseMemberOr) isFilterClause() {}

// A filter expression in Amazon DataZone.
type FilterExpression struct {

	// The search filter expression.
	//
	// This member is required.
	Expression *string

	// The search filter explresison type.
	//
	// This member is required.
	Type FilterExpressionType

	noSmithyDocumentSerde
}

// The details of the form entry.
type FormEntryInput struct {

	// The type ID of the form entry.
	//
	// This member is required.
	TypeIdentifier *string

	// The type revision of the form entry.
	//
	// This member is required.
	TypeRevision *string

	// Specifies whether a form entry is required.
	Required *bool

	noSmithyDocumentSerde
}

// The details of the form entry.
type FormEntryOutput struct {

	// The name of the type of the form entry.
	//
	// This member is required.
	TypeName *string

	// The type revision of the form entry.
	//
	// This member is required.
	TypeRevision *string

	// Specifies whether a form entry is required.
	Required *bool

	noSmithyDocumentSerde
}

// The details of a metadata form.
type FormInput struct {

	// The name of the metadata form.
	//
	// This member is required.
	FormName *string

	// The content of the metadata form.
	Content *string

	// The ID of the metadata form type.
	TypeIdentifier *string

	// The revision of the metadata form type.
	TypeRevision *string

	noSmithyDocumentSerde
}

// The details of a metadata form.
type FormOutput struct {

	// The name of the metadata form.
	//
	// This member is required.
	FormName *string

	// The content of the metadata form.
	Content *string

	// The name of the metadata form type.
	TypeName *string

	// The revision of the metadata form type.
	TypeRevision *string

	noSmithyDocumentSerde
}

// The details of the metadata form type.
type FormTypeData struct {

	// The identifier of the Amazon DataZone domain in which the form type exists.
	//
	// This member is required.
	DomainId *string

	// The name of the form type.
	//
	// This member is required.
	Name *string

	// The revision of the form type.
	//
	// This member is required.
	Revision *string

	// The timestamp of when the metadata form type was created.
	CreatedAt *time.Time

	// The Amazon DataZone user who created teh metadata form type.
	CreatedBy *string

	// The description of the metadata form type.
	Description *string

	// The imports specified in the form type.
	Imports []Import

	// The model of the form type.
	Model Model

	// The identifier of the Amazon DataZone domain in which the form type was
	// originally created.
	OriginDomainId *string

	// The identifier of the project in which the form type was originally created.
	OriginProjectId *string

	// The identifier of the project that owns the form type.
	OwningProjectId *string

	// The status of the form type.
	Status FormTypeStatus

	noSmithyDocumentSerde
}

// The details of a business glossary.
type GlossaryItem struct {

	// The identifier of the Amazon DataZone domain in which the business glossary
	// exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of the glossary.
	//
	// This member is required.
	Id *string

	// The name of the glossary.
	//
	// This member is required.
	Name *string

	// The identifier of the project that owns the business glosary.
	//
	// This member is required.
	OwningProjectId *string

	// The business glossary status.
	//
	// This member is required.
	Status GlossaryStatus

	// The timestamp of when the glossary was created.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the glossary.
	CreatedBy *string

	// The business glossary description.
	Description *string

	// The timestamp of when the business glossary was updated.
	UpdatedAt *time.Time

	// The Amazon DataZone user who updated the business glossary.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of a business glossary term.
type GlossaryTermItem struct {

	// The identifier of the Amazon DataZone domain in which the business glossary
	// exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of the business glossary to which the term belongs.
	//
	// This member is required.
	GlossaryId *string

	// The identifier of the business glossary term.
	//
	// This member is required.
	Id *string

	// The name of the business glossary term.
	//
	// This member is required.
	Name *string

	// The status of the business glossary term.
	//
	// This member is required.
	Status GlossaryTermStatus

	// The timestamp of when a business glossary term was created.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the business glossary.
	CreatedBy *string

	// The long description of the business glossary term.
	LongDescription *string

	// The short description of the business glossary term.
	ShortDescription *string

	// The relations of the business glossary term.
	TermRelations *TermRelations

	// The timestamp of when a business glossary term was updated.
	UpdatedAt *time.Time

	// The Amazon DataZone user who updated the business glossary term.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The configuration details of the Amazon Web Services Glue data source.
type GlueRunConfigurationInput struct {

	// The relational filter configurations included in the configuration details of
	// the Amazon Web Services Glue data source.
	//
	// This member is required.
	RelationalFilterConfigurations []RelationalFilterConfiguration

	// Specifies whether to automatically import data quality metrics as part of the
	// data source run.
	AutoImportDataQualityResult *bool

	// The data access role included in the configuration details of the Amazon Web
	// Services Glue data source.
	DataAccessRole *string

	noSmithyDocumentSerde
}

// The configuration details of the Amazon Web Services Glue data source.
type GlueRunConfigurationOutput struct {

	// The relational filter configurations included in the configuration details of
	// the Amazon Web Services Glue data source.
	//
	// This member is required.
	RelationalFilterConfigurations []RelationalFilterConfiguration

	// The Amazon Web Services account ID included in the configuration details of the
	// Amazon Web Services Glue data source.
	AccountId *string

	// Specifies whether to automatically import data quality metrics as part of the
	// data source run.
	AutoImportDataQualityResult *bool

	// The data access role included in the configuration details of the Amazon Web
	// Services Glue data source.
	DataAccessRole *string

	// The Amazon Web Services region included in the configuration details of the
	// Amazon Web Services Glue data source.
	Region *string

	noSmithyDocumentSerde
}

// The details of the self granting status.
type GlueSelfGrantStatusOutput struct {

	// The details for the self granting status for a Glue data source.
	//
	// This member is required.
	SelfGrantStatusDetails []SelfGrantStatusDetail

	noSmithyDocumentSerde
}

// The details of a listing for which a subscription is granted.
//
// The following types satisfy this interface:
//
//	GrantedEntityMemberListing
type GrantedEntity interface {
	isGrantedEntity()
}

// The listing for which a subscription is granted.
type GrantedEntityMemberListing struct {
	Value ListingRevision

	noSmithyDocumentSerde
}

func (*GrantedEntityMemberListing) isGrantedEntity() {}

// The details of a listing for which a subscription is to be granted.
//
// The following types satisfy this interface:
//
//	GrantedEntityInputMemberListing
type GrantedEntityInput interface {
	isGrantedEntityInput()
}

// The listing for which a subscription is to be granted.
type GrantedEntityInputMemberListing struct {
	Value ListingRevisionInput

	noSmithyDocumentSerde
}

func (*GrantedEntityInputMemberListing) isGrantedEntityInput() {}

// The details of a group in Amazon DataZone.
type GroupDetails struct {

	// The identifier of the group in Amazon DataZone.
	//
	// This member is required.
	GroupId *string

	noSmithyDocumentSerde
}

// The details of a group profile.
type GroupProfileSummary struct {

	// The ID of the Amazon DataZone domain of a group profile.
	DomainId *string

	// The group name of a group profile.
	GroupName *string

	// The ID of a group profile.
	Id *string

	// The status of a group profile.
	Status GroupProfileStatus

	noSmithyDocumentSerde
}

// The details of an IAM user profile in Amazon DataZone.
type IamUserProfileDetails struct {

	// The ARN of an IAM user profile in Amazon DataZone.
	Arn *string

	noSmithyDocumentSerde
}

// The details of the import of the metadata form type.
type Import struct {

	// The name of the import.
	//
	// This member is required.
	Name *string

	// The revision of the import.
	//
	// This member is required.
	Revision *string

	noSmithyDocumentSerde
}

// The reference details for the data lineage node.
type LineageNodeReference struct {

	// The event timestamp of the data lineage node.
	EventTimestamp *time.Time

	// The ID of the data lineage node.
	Id *string

	noSmithyDocumentSerde
}

// The summary of the data lineage node.
type LineageNodeSummary struct {

	// The ID of the domain of the data lineage node.
	//
	// This member is required.
	DomainId *string

	// The ID of the data lineage node.
	//
	// This member is required.
	Id *string

	// The name of the type of the data lineage node.
	//
	// This member is required.
	TypeName *string

	// The timestamp at which the data lineage node was created.
	CreatedAt *time.Time

	// The user who created the data lineage node.
	CreatedBy *string

	// The description of the data lineage node.
	Description *string

	// The event timestamp of the data lineage node.
	EventTimestamp *time.Time

	// The name of the data lineage node.
	Name *string

	// The alternate ID of the data lineage node.
	SourceIdentifier *string

	// The type of the revision of the data lineage node.
	TypeRevision *string

	// The timestamp at which the data lineage node was updated.
	UpdatedAt *time.Time

	// The user who updated the data lineage node.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of a data lineage node type.
type LineageNodeTypeItem struct {

	// The ID of the domain where the data lineage node type lives.
	//
	// This member is required.
	DomainId *string

	// The forms output of the data lineage node type.
	//
	// This member is required.
	FormsOutput map[string]FormEntryOutput

	// The revision of the data lineage node type.
	//
	// This member is required.
	Revision *string

	// The timestamp at which the data lineage node type was created.
	CreatedAt *time.Time

	// The user who created the data lineage node type.
	CreatedBy *string

	// The description of the data lineage node type.
	Description *string

	// The name of the data lineage node type.
	Name *string

	// The timestamp at which the data lineage node type was updated.
	UpdatedAt *time.Time

	// The user who updated the data lineage node type.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of a listing (aka asset published in a Amazon DataZone catalog).
//
// The following types satisfy this interface:
//
//	ListingItemMemberAssetListing
type ListingItem interface {
	isListingItem()
}

// An asset published in an Amazon DataZone catalog.
type ListingItemMemberAssetListing struct {
	Value AssetListing

	noSmithyDocumentSerde
}

func (*ListingItemMemberAssetListing) isListingItem() {}

// A revision of an asset published in a Amazon DataZone catalog.
type ListingRevision struct {

	// An identifier of a revision of an asset published in a Amazon DataZone catalog.
	//
	// This member is required.
	Id *string

	// The details of a revision of an asset published in a Amazon DataZone catalog.
	//
	// This member is required.
	Revision *string

	noSmithyDocumentSerde
}

// A revision to be made to an asset published in a Amazon DataZone catalog.
type ListingRevisionInput struct {

	// An identifier of revision to be made to an asset published in a Amazon DataZone
	// catalog.
	//
	// This member is required.
	Identifier *string

	// The details of a revision to be made to an asset published in a Amazon DataZone
	// catalog.
	//
	// This member is required.
	Revision *string

	noSmithyDocumentSerde
}

// The details about a project member.
//
// The following types satisfy this interface:
//
//	MemberMemberGroupIdentifier
//	MemberMemberUserIdentifier
type Member interface {
	isMember()
}

// The ID of the group of a project member.
type MemberMemberGroupIdentifier struct {
	Value string

	noSmithyDocumentSerde
}

func (*MemberMemberGroupIdentifier) isMember() {}

// The user ID of a project member.
type MemberMemberUserIdentifier struct {
	Value string

	noSmithyDocumentSerde
}

func (*MemberMemberUserIdentifier) isMember() {}

// The details about a project member.
//
// The following types satisfy this interface:
//
//	MemberDetailsMemberGroup
//	MemberDetailsMemberUser
type MemberDetails interface {
	isMemberDetails()
}

// The group details of a project member.
type MemberDetailsMemberGroup struct {
	Value GroupDetails

	noSmithyDocumentSerde
}

func (*MemberDetailsMemberGroup) isMemberDetails() {}

// The user details of a project member.
type MemberDetailsMemberUser struct {
	Value UserDetails

	noSmithyDocumentSerde
}

func (*MemberDetailsMemberUser) isMemberDetails() {}

// The metadata generation run.
type MetadataGenerationRunItem struct {

	// The ID of the Amazon DataZone domain in which the metadata generation run was
	// created.
	//
	// This member is required.
	DomainId *string

	// The ID of the metadata generation run.
	//
	// This member is required.
	Id *string

	// The ID of the project that owns the asset for which the metadata generation was
	// ran.
	//
	// This member is required.
	OwningProjectId *string

	// The timestamp at which the metadata generation run was created.
	CreatedAt *time.Time

	// The user who created the metadata generation run.
	CreatedBy *string

	// The status of the metadata generation run.
	Status MetadataGenerationRunStatus

	// The asset for which metadata was generated.
	Target *MetadataGenerationRunTarget

	// The type of the metadata generation run.
	Type MetadataGenerationRunType

	noSmithyDocumentSerde
}

// The asset for which metadata was generated.
type MetadataGenerationRunTarget struct {

	// The ID of the metadata generation run's target.
	//
	// This member is required.
	Identifier *string

	// The type of the asset for which metadata was generated.
	//
	// This member is required.
	Type MetadataGenerationTargetType

	// The revision of the asset for which metadata was generated.
	Revision *string

	noSmithyDocumentSerde
}

// The model of the API.
//
// The following types satisfy this interface:
//
//	ModelMemberSmithy
type Model interface {
	isModel()
}

// Indicates the smithy model of the API.
type ModelMemberSmithy struct {
	Value string

	noSmithyDocumentSerde
}

func (*ModelMemberSmithy) isModel() {}

// The details of a notification generated in Amazon DataZone.
type NotificationOutput struct {

	// The action link included in the notification.
	//
	// This member is required.
	ActionLink *string

	// The timestamp of when a notification was created.
	//
	// This member is required.
	CreationTimestamp *time.Time

	// The identifier of a Amazon DataZone domain in which the notification exists.
	//
	// This member is required.
	DomainIdentifier *string

	// The identifier of the notification.
	//
	// This member is required.
	Identifier *string

	// The timestamp of when the notification was last updated.
	//
	// This member is required.
	LastUpdatedTimestamp *time.Time

	// The message included in the notification.
	//
	// This member is required.
	Message *string

	// The title of the notification.
	//
	// This member is required.
	Title *string

	// The topic of the notification.
	//
	// This member is required.
	Topic *Topic

	// The type of the notification.
	//
	// This member is required.
	Type NotificationType

	// The metadata included in the notification.
	Metadata map[string]string

	// The status included in the notification.
	Status TaskStatus

	noSmithyDocumentSerde
}

// The details of the resource mentioned in a notification.
type NotificationResource struct {

	// The ID of the resource mentioned in a notification.
	//
	// This member is required.
	Id *string

	// The type of the resource mentioned in a notification.
	//
	// This member is required.
	Type NotificationResourceType

	// The name of the resource mentioned in a notification.
	Name *string

	noSmithyDocumentSerde
}

// The configuration of the prediction.
type PredictionConfiguration struct {

	// The business name generation mechanism.
	BusinessNameGeneration *BusinessNameGenerationConfiguration

	noSmithyDocumentSerde
}

// Specifies the error message that is returned if the operation cannot be
// successfully completed.
type ProjectDeletionError struct {

	// The code of the project deletion error.
	Code *string

	// The message of the project deletion error.
	Message *string

	noSmithyDocumentSerde
}

// The details of a project member.
type ProjectMember struct {

	// The designated role of a project member.
	//
	// This member is required.
	Designation UserDesignation

	// The membership details of a project member.
	//
	// This member is required.
	MemberDetails MemberDetails

	noSmithyDocumentSerde
}

// The details of a Amazon DataZone project.
type ProjectSummary struct {

	// The Amazon DataZone user who created the project.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of a Amazon DataZone domain where the project exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of a project.
	//
	// This member is required.
	Id *string

	// The name of a project.
	//
	// This member is required.
	Name *string

	// The timestamp of when a project was created.
	CreatedAt *time.Time

	// The description of a project.
	Description *string

	// Specifies the error message that is returned if the operation cannot be
	// successfully completed.
	FailureReasons []ProjectDeletionError

	// The status of the project.
	ProjectStatus ProjectStatus

	// The timestamp of when the project was updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// The provisioning properties of an environment blueprint.
//
// The following types satisfy this interface:
//
//	ProvisioningPropertiesMemberCloudFormation
type ProvisioningProperties interface {
	isProvisioningProperties()
}

// The cloud formation properties included as part of the provisioning properties
// of an environment blueprint.
type ProvisioningPropertiesMemberCloudFormation struct {
	Value CloudFormationProperties

	noSmithyDocumentSerde
}

func (*ProvisioningPropertiesMemberCloudFormation) isProvisioningProperties() {}

// The recommendation to be updated as part of the UpdateDataSource action.
type RecommendationConfiguration struct {

	// Specifies whether automatic business name generation is to be enabled or not as
	// part of the recommendation configuration.
	EnableBusinessNameGeneration *bool

	noSmithyDocumentSerde
}

// The details of the Amazon Redshift cluster storage.
type RedshiftClusterStorage struct {

	// The name of an Amazon Redshift cluster.
	//
	// This member is required.
	ClusterName *string

	noSmithyDocumentSerde
}

// The details of the credentials required to access an Amazon Redshift cluster.
type RedshiftCredentialConfiguration struct {

	// The ARN of a secret manager for an Amazon Redshift cluster.
	//
	// This member is required.
	SecretManagerArn *string

	noSmithyDocumentSerde
}

// The configuration details of the Amazon Redshift data source.
type RedshiftRunConfigurationInput struct {

	// The details of the credentials required to access an Amazon Redshift cluster.
	//
	// This member is required.
	RedshiftCredentialConfiguration *RedshiftCredentialConfiguration

	// The details of the Amazon Redshift storage as part of the configuration of an
	// Amazon Redshift data source run.
	//
	// This member is required.
	RedshiftStorage RedshiftStorage

	// The relational filger configurations included in the configuration details of
	// the Amazon Redshift data source.
	//
	// This member is required.
	RelationalFilterConfigurations []RelationalFilterConfiguration

	// The data access role included in the configuration details of the Amazon
	// Redshift data source.
	DataAccessRole *string

	noSmithyDocumentSerde
}

// The configuration details of the Amazon Redshift data source.
type RedshiftRunConfigurationOutput struct {

	// The details of the credentials required to access an Amazon Redshift cluster.
	//
	// This member is required.
	RedshiftCredentialConfiguration *RedshiftCredentialConfiguration

	// The details of the Amazon Redshift storage as part of the configuration of an
	// Amazon Redshift data source run.
	//
	// This member is required.
	RedshiftStorage RedshiftStorage

	// The relational filger configurations included in the configuration details of
	// the Amazon Redshift data source.
	//
	// This member is required.
	RelationalFilterConfigurations []RelationalFilterConfiguration

	// The ID of the Amazon Web Services account included in the configuration details
	// of the Amazon Redshift data source.
	AccountId *string

	// The data access role included in the configuration details of the Amazon
	// Redshift data source.
	DataAccessRole *string

	// The Amazon Web Services region included in the configuration details of the
	// Amazon Redshift data source.
	Region *string

	noSmithyDocumentSerde
}

// The details for the self granting status for an Amazon Redshift data source.
type RedshiftSelfGrantStatusOutput struct {

	// The details for the self granting status for an Amazon Redshift data source.
	//
	// This member is required.
	SelfGrantStatusDetails []SelfGrantStatusDetail

	noSmithyDocumentSerde
}

// The details of the Amazon Redshift Serverless workgroup storage.
type RedshiftServerlessStorage struct {

	// The name of the Amazon Redshift Serverless workgroup.
	//
	// This member is required.
	WorkgroupName *string

	noSmithyDocumentSerde
}

// The details of the Amazon Redshift storage as part of the configuration of an
// Amazon Redshift data source run.
//
// The following types satisfy this interface:
//
//	RedshiftStorageMemberRedshiftClusterSource
//	RedshiftStorageMemberRedshiftServerlessSource
type RedshiftStorage interface {
	isRedshiftStorage()
}

// The details of the Amazon Redshift cluster source.
type RedshiftStorageMemberRedshiftClusterSource struct {
	Value RedshiftClusterStorage

	noSmithyDocumentSerde
}

func (*RedshiftStorageMemberRedshiftClusterSource) isRedshiftStorage() {}

// The details of the Amazon Redshift Serverless workgroup source.
type RedshiftStorageMemberRedshiftServerlessSource struct {
	Value RedshiftServerlessStorage

	noSmithyDocumentSerde
}

func (*RedshiftStorageMemberRedshiftServerlessSource) isRedshiftStorage() {}

// The details of the automatically generated business metadata that is rejected.
type RejectChoice struct {

	// Specifies the target (for example, a column name) where a prediction can be
	// rejected.
	//
	// This member is required.
	PredictionTarget *string

	// Specifies the the automatically generated business metadata that can be
	// rejected.
	PredictionChoices []int32

	noSmithyDocumentSerde
}

// Specifies the rule and the threshold under which a prediction can be rejected.
type RejectRule struct {

	// Specifies whether you want to reject the top prediction for all targets or none.
	Rule RejectRuleBehavior

	// The confidence score that specifies the condition at which a prediction can be
	// rejected.
	Threshold *float32

	noSmithyDocumentSerde
}

// The relational filter configuration for the data source.
type RelationalFilterConfiguration struct {

	// The database name specified in the relational filter configuration for the data
	// source.
	//
	// This member is required.
	DatabaseName *string

	// The filter expressions specified in the relational filter configuration for the
	// data source.
	FilterExpressions []FilterExpression

	// The schema name specified in the relational filter configuration for the data
	// source.
	SchemaName *string

	noSmithyDocumentSerde
}

// The details of a provisioned resource of this Amazon DataZone environment.
type Resource struct {

	// The type of a provisioned resource of this Amazon DataZone environment.
	//
	// This member is required.
	Type *string

	// The value of a provisioned resource of this Amazon DataZone environment.
	//
	// This member is required.
	Value *string

	// The name of a provisioned resource of this Amazon DataZone environment.
	Name *string

	// The provider of a provisioned resource of this Amazon DataZone environment.
	Provider *string

	noSmithyDocumentSerde
}

// The asset statistics from the data source run.
type RunStatisticsForAssets struct {

	// The added statistic for the data source run.
	Added *int32

	// The failed statistic for the data source run.
	Failed *int32

	// The skipped statistic for the data source run.
	Skipped *int32

	// The unchanged statistic for the data source run.
	Unchanged *int32

	// The updated statistic for the data source run.
	Updated *int32

	noSmithyDocumentSerde
}

// The details of the schedule of the data source runs.
type ScheduleConfiguration struct {

	// The schedule of the data source runs.
	Schedule *string

	// The timezone of the data source run.
	Timezone Timezone

	noSmithyDocumentSerde
}

// The details of the search.
type SearchInItem struct {

	// The search attribute.
	//
	// This member is required.
	Attribute *string

	noSmithyDocumentSerde
}

// The details of the search results.
//
// The following types satisfy this interface:
//
//	SearchInventoryResultItemMemberAssetItem
//	SearchInventoryResultItemMemberDataProductItem
//	SearchInventoryResultItemMemberGlossaryItem
//	SearchInventoryResultItemMemberGlossaryTermItem
type SearchInventoryResultItem interface {
	isSearchInventoryResultItem()
}

// The asset item included in the search results.
type SearchInventoryResultItemMemberAssetItem struct {
	Value AssetItem

	noSmithyDocumentSerde
}

func (*SearchInventoryResultItemMemberAssetItem) isSearchInventoryResultItem() {}

// The data product item included in the search results.
//
// Deprecated: This field is deprecated.
type SearchInventoryResultItemMemberDataProductItem struct {
	Value DataProductSummary

	noSmithyDocumentSerde
}

func (*SearchInventoryResultItemMemberDataProductItem) isSearchInventoryResultItem() {}

// The glossary item included in the search results.
type SearchInventoryResultItemMemberGlossaryItem struct {
	Value GlossaryItem

	noSmithyDocumentSerde
}

func (*SearchInventoryResultItemMemberGlossaryItem) isSearchInventoryResultItem() {}

// The glossary term item included in the search results.
type SearchInventoryResultItemMemberGlossaryTermItem struct {
	Value GlossaryTermItem

	noSmithyDocumentSerde
}

func (*SearchInventoryResultItemMemberGlossaryTermItem) isSearchInventoryResultItem() {}

// The details of the results of the SearchListings action.
//
// The following types satisfy this interface:
//
//	SearchResultItemMemberAssetListing
type SearchResultItem interface {
	isSearchResultItem()
}

// The asset listing included in the results of the SearchListings action.
type SearchResultItemMemberAssetListing struct {
	Value AssetListingItem

	noSmithyDocumentSerde
}

func (*SearchResultItemMemberAssetListing) isSearchResultItem() {}

// The details of the way to sort search results.
type SearchSort struct {

	// The attribute detail of the way to sort search results.
	//
	// This member is required.
	Attribute *string

	// The order detail of the wya to sort search results.
	Order SortOrder

	noSmithyDocumentSerde
}

// The details of the results of the SearchTypes action.
//
// The following types satisfy this interface:
//
//	SearchTypesResultItemMemberAssetTypeItem
//	SearchTypesResultItemMemberFormTypeItem
//	SearchTypesResultItemMemberLineageNodeTypeItem
type SearchTypesResultItem interface {
	isSearchTypesResultItem()
}

// The asset type included in the results of the SearchTypes action.
type SearchTypesResultItemMemberAssetTypeItem struct {
	Value AssetTypeItem

	noSmithyDocumentSerde
}

func (*SearchTypesResultItemMemberAssetTypeItem) isSearchTypesResultItem() {}

// The form type included in the results of the SearchTypes action.
type SearchTypesResultItemMemberFormTypeItem struct {
	Value FormTypeData

	noSmithyDocumentSerde
}

func (*SearchTypesResultItemMemberFormTypeItem) isSearchTypesResultItem() {}

// The details of a data lineage node type.
type SearchTypesResultItemMemberLineageNodeTypeItem struct {
	Value LineageNodeTypeItem

	noSmithyDocumentSerde
}

func (*SearchTypesResultItemMemberLineageNodeTypeItem) isSearchTypesResultItem() {}

// The details for the self granting status.
type SelfGrantStatusDetail struct {

	// The name of the database used for the data source.
	//
	// This member is required.
	DatabaseName *string

	// The self granting status of the data source.
	//
	// This member is required.
	Status SelfGrantStatus

	// The reason for why the operation failed.
	FailureCause *string

	// The name of the schema used in the data source.
	SchemaName *string

	noSmithyDocumentSerde
}

// The details for the self granting status for a data source.
//
// The following types satisfy this interface:
//
//	SelfGrantStatusOutputMemberGlueSelfGrantStatus
//	SelfGrantStatusOutputMemberRedshiftSelfGrantStatus
type SelfGrantStatusOutput interface {
	isSelfGrantStatusOutput()
}

// The details for the self granting status for a Glue data source.
type SelfGrantStatusOutputMemberGlueSelfGrantStatus struct {
	Value GlueSelfGrantStatusOutput

	noSmithyDocumentSerde
}

func (*SelfGrantStatusOutputMemberGlueSelfGrantStatus) isSelfGrantStatusOutput() {}

// The details for the self granting status for an Amazon Redshift data source.
type SelfGrantStatusOutputMemberRedshiftSelfGrantStatus struct {
	Value RedshiftSelfGrantStatusOutput

	noSmithyDocumentSerde
}

func (*SelfGrantStatusOutputMemberRedshiftSelfGrantStatus) isSelfGrantStatusOutput() {}

// The single sign-on details in Amazon DataZone.
type SingleSignOn struct {

	// The type of single sign-on in Amazon DataZone.
	Type AuthType

	// The single sign-on user assignment in Amazon DataZone.
	UserAssignment UserAssignment

	noSmithyDocumentSerde
}

// The single sign-on details of the user profile.
type SsoUserProfileDetails struct {

	// The first name included in the single sign-on details of the user profile.
	FirstName *string

	// The last name included in the single sign-on details of the user profile.
	LastName *string

	// The username included in the single sign-on details of the user profile.
	Username *string

	noSmithyDocumentSerde
}

// The details of the asset for which the subscription grant is created.
type SubscribedAsset struct {

	// The identifier of the asset for which the subscription grant is created.
	//
	// This member is required.
	AssetId *string

	// The revision of the asset for which the subscription grant is created.
	//
	// This member is required.
	AssetRevision *string

	// The status of the asset for which the subscription grant is created.
	//
	// This member is required.
	Status SubscriptionGrantStatus

	// The failure cause included in the details of the asset for which the
	// subscription grant is created.
	FailureCause *FailureCause

	// The failure timestamp included in the details of the asset for which the
	// subscription grant is created.
	FailureTimestamp *time.Time

	// The timestamp of when the subscription grant to the asset is created.
	GrantedTimestamp *time.Time

	// The target name of the asset for which the subscription grant is created.
	TargetName *string

	noSmithyDocumentSerde
}

// The details of the published asset for which the subscription grant is created.
type SubscribedAssetListing struct {

	// The identifier of the published asset for which the subscription grant is
	// created.
	EntityId *string

	// The revision of the published asset for which the subscription grant is created.
	EntityRevision *string

	// The type of the published asset for which the subscription grant is created.
	EntityType *string

	// The forms attached to the published asset for which the subscription grant is
	// created.
	Forms *string

	// The glossary terms attached to the published asset for which the subscription
	// grant is created.
	GlossaryTerms []DetailedGlossaryTerm

	noSmithyDocumentSerde
}

// The details of the published asset for which the subscription grant is created.
type SubscribedListing struct {

	// The description of the published asset for which the subscription grant is
	// created.
	//
	// This member is required.
	Description *string

	// The identifier of the published asset for which the subscription grant is
	// created.
	//
	// This member is required.
	Id *string

	// The published asset for which the subscription grant is created.
	//
	// This member is required.
	Item SubscribedListingItem

	// The name of the published asset for which the subscription grant is created.
	//
	// This member is required.
	Name *string

	// The identifier of the project of the published asset for which the subscription
	// grant is created.
	//
	// This member is required.
	OwnerProjectId *string

	// The name of the project that owns the published asset for which the
	// subscription grant is created.
	OwnerProjectName *string

	// The revision of the published asset for which the subscription grant is created.
	Revision *string

	noSmithyDocumentSerde
}

// The published asset for which the subscription grant is to be created.
type SubscribedListingInput struct {

	// The identifier of the published asset for which the subscription grant is to be
	// created.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

// The published asset for which the subscription grant is created.
//
// The following types satisfy this interface:
//
//	SubscribedListingItemMemberAssetListing
type SubscribedListingItem interface {
	isSubscribedListingItem()
}

// The asset for which the subscription grant is created.
type SubscribedListingItemMemberAssetListing struct {
	Value SubscribedAssetListing

	noSmithyDocumentSerde
}

func (*SubscribedListingItemMemberAssetListing) isSubscribedListingItem() {}

// The principal that has the subscription grant for the asset.
//
// The following types satisfy this interface:
//
//	SubscribedPrincipalMemberProject
type SubscribedPrincipal interface {
	isSubscribedPrincipal()
}

// The project that has the subscription grant.
type SubscribedPrincipalMemberProject struct {
	Value SubscribedProject

	noSmithyDocumentSerde
}

func (*SubscribedPrincipalMemberProject) isSubscribedPrincipal() {}

// The principal that is to be given a subscriptiong grant.
//
// The following types satisfy this interface:
//
//	SubscribedPrincipalInputMemberProject
type SubscribedPrincipalInput interface {
	isSubscribedPrincipalInput()
}

// The project that is to be given a subscription grant.
type SubscribedPrincipalInputMemberProject struct {
	Value SubscribedProjectInput

	noSmithyDocumentSerde
}

func (*SubscribedPrincipalInputMemberProject) isSubscribedPrincipalInput() {}

// The project that has the subscription grant.
type SubscribedProject struct {

	// The identifier of the project that has the subscription grant.
	Id *string

	// The name of the project that has the subscription grant.
	Name *string

	noSmithyDocumentSerde
}

// The project that is to be given a subscription grant.
type SubscribedProjectInput struct {

	// The identifier of the project that is to be given a subscription grant.
	Identifier *string

	noSmithyDocumentSerde
}

// The details of the subscription grant.
type SubscriptionGrantSummary struct {

	// The timestamp of when a subscription grant was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The datazone user who created the subscription grant.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which a subscription grant
	// exists.
	//
	// This member is required.
	DomainId *string

	// The entity to which the subscription is granted.
	//
	// This member is required.
	GrantedEntity GrantedEntity

	// The identifier of the subscription grant.
	//
	// This member is required.
	Id *string

	// The status of the subscription grant.
	//
	// This member is required.
	Status SubscriptionGrantOverallStatus

	// The identifier of the target of the subscription grant.
	//
	// This member is required.
	SubscriptionTargetId *string

	// The timestampf of when the subscription grant was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The assets included in the subscription grant.
	Assets []SubscribedAsset

	// The ID of the subscription grant.
	SubscriptionId *string

	// The Amazon DataZone user who updated the subscription grant.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of the subscription request.
type SubscriptionRequestSummary struct {

	// The timestamp of when a subscription request was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the subscription request.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which a subscription request
	// exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of the subscription request.
	//
	// This member is required.
	Id *string

	// The reason for the subscription request.
	//
	// This member is required.
	RequestReason *string

	// The status of the subscription request.
	//
	// This member is required.
	Status SubscriptionRequestStatus

	// The listings included in the subscription request.
	//
	// This member is required.
	SubscribedListings []SubscribedListing

	// The principals included in the subscription request.
	//
	// This member is required.
	SubscribedPrincipals []SubscribedPrincipal

	// The timestamp of when the subscription request was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The decision comment of the subscription request.
	DecisionComment *string

	// The identifier of the subscription request reviewer.
	ReviewerId *string

	// The identifier of the Amazon DataZone user who updated the subscription request.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of the subscription.
type SubscriptionSummary struct {

	// The timestamp of when the subscription was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the subscription.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which a subscription exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of the subscription.
	//
	// This member is required.
	Id *string

	// The status of the subscription.
	//
	// This member is required.
	Status SubscriptionStatus

	// The listing included in the subscription.
	//
	// This member is required.
	SubscribedListing *SubscribedListing

	// The principal included in the subscription.
	//
	// This member is required.
	SubscribedPrincipal SubscribedPrincipal

	// The timestamp of when the subscription was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The retain permissions included in the subscription.
	RetainPermissions *bool

	// The identifier of the subscription request for the subscription.
	SubscriptionRequestId *string

	// The Amazon DataZone user who updated the subscription.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of the subscription target configuration.
type SubscriptionTargetForm struct {

	// The content of the subscription target configuration.
	//
	// This member is required.
	Content *string

	// The form name included in the subscription target configuration.
	//
	// This member is required.
	FormName *string

	noSmithyDocumentSerde
}

// The details of the subscription target.
type SubscriptionTargetSummary struct {

	// The asset types included in the subscription target.
	//
	// This member is required.
	ApplicableAssetTypes []string

	// The authorized principals included in the subscription target.
	//
	// This member is required.
	AuthorizedPrincipals []string

	// The timestamp of when the subscription target was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon DataZone user who created the subscription target.
	//
	// This member is required.
	CreatedBy *string

	// The identifier of the Amazon DataZone domain in which the subscription target
	// exists.
	//
	// This member is required.
	DomainId *string

	// The identifier of the environment of the subscription target.
	//
	// This member is required.
	EnvironmentId *string

	// The identifier of the subscription target.
	//
	// This member is required.
	Id *string

	// The manage access role specified in the subscription target.
	//
	// This member is required.
	ManageAccessRole *string

	// The name of the subscription target.
	//
	// This member is required.
	Name *string

	// The identifier of the project specified in the subscription target.
	//
	// This member is required.
	ProjectId *string

	// The provider of the subscription target.
	//
	// This member is required.
	Provider *string

	// The configuration of the subscription target.
	//
	// This member is required.
	SubscriptionTargetConfig []SubscriptionTargetForm

	// The type of the subscription target.
	//
	// This member is required.
	Type *string

	// The timestamp of when the subscription target was updated.
	UpdatedAt *time.Time

	// The Amazon DataZone user who updated the subscription target.
	UpdatedBy *string

	noSmithyDocumentSerde
}

// The details of the term relations.
type TermRelations struct {

	// The classifies of the term relations.
	Classifies []string

	// The isA property of the term relations.
	IsA []string

	noSmithyDocumentSerde
}

// The time series data points form.
type TimeSeriesDataPointFormInput struct {

	// The name of the time series data points form.
	//
	// This member is required.
	FormName *string

	// The timestamp of the time series data points form.
	//
	// This member is required.
	Timestamp *time.Time

	// The ID of the type of the time series data points form.
	//
	// This member is required.
	TypeIdentifier *string

	// The content of the time series data points form.
	Content *string

	// The revision type of the time series data points form.
	TypeRevision *string

	noSmithyDocumentSerde
}

// The time series data points form.
type TimeSeriesDataPointFormOutput struct {

	// The name of the time series data points form.
	//
	// This member is required.
	FormName *string

	// The timestamp of the time series data points form.
	//
	// This member is required.
	Timestamp *time.Time

	// The ID of the type of the time series data points form.
	//
	// This member is required.
	TypeIdentifier *string

	// The content of the time series data points form.
	Content *string

	// The ID of the time series data points form.
	Id *string

	// The revision type of the time series data points form.
	TypeRevision *string

	noSmithyDocumentSerde
}

// The summary of the time series data points form.
type TimeSeriesDataPointSummaryFormOutput struct {

	// The name of the time series data points summary form.
	//
	// This member is required.
	FormName *string

	// The timestamp of the time series data points summary form.
	//
	// This member is required.
	Timestamp *time.Time

	// The type ID of the time series data points summary form.
	//
	// This member is required.
	TypeIdentifier *string

	// The content of the summary of the time series data points form.
	ContentSummary *string

	// The ID of the time series data points summary form.
	Id *string

	// The type revision of the time series data points summary form.
	TypeRevision *string

	noSmithyDocumentSerde
}

// The topic of the notification.
type Topic struct {

	// The details of the resource mentioned in a notification.
	//
	// This member is required.
	Resource *NotificationResource

	// The role of the resource mentioned in a notification.
	//
	// This member is required.
	Role NotificationRole

	// The subject of the resource mentioned in a notification.
	//
	// This member is required.
	Subject *string

	noSmithyDocumentSerde
}

// The user details of a project member.
type UserDetails struct {

	// The identifier of the Amazon DataZone user.
	//
	// This member is required.
	UserId *string

	noSmithyDocumentSerde
}

// The details of the user profile in Amazon DataZone.
//
// The following types satisfy this interface:
//
//	UserProfileDetailsMemberIam
//	UserProfileDetailsMemberSso
type UserProfileDetails interface {
	isUserProfileDetails()
}

// The IAM details included in the user profile details.
type UserProfileDetailsMemberIam struct {
	Value IamUserProfileDetails

	noSmithyDocumentSerde
}

func (*UserProfileDetailsMemberIam) isUserProfileDetails() {}

// The single sign-on details included in the user profile details.
type UserProfileDetailsMemberSso struct {
	Value SsoUserProfileDetails

	noSmithyDocumentSerde
}

func (*UserProfileDetailsMemberSso) isUserProfileDetails() {}

// The details of the user profile.
type UserProfileSummary struct {

	// The details of the user profile.
	Details UserProfileDetails

	// The ID of the Amazon DataZone domain of the user profile.
	DomainId *string

	// The ID of the user profile.
	Id *string

	// The status of the user profile.
	Status UserProfileStatus

	// The type of the user profile.
	Type UserProfileType

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isActionParameters()              {}
func (*UnknownUnionMember) isDataSourceConfigurationInput()  {}
func (*UnknownUnionMember) isDataSourceConfigurationOutput() {}
func (*UnknownUnionMember) isFilterClause()                  {}
func (*UnknownUnionMember) isGrantedEntity()                 {}
func (*UnknownUnionMember) isGrantedEntityInput()            {}
func (*UnknownUnionMember) isListingItem()                   {}
func (*UnknownUnionMember) isMember()                        {}
func (*UnknownUnionMember) isMemberDetails()                 {}
func (*UnknownUnionMember) isModel()                         {}
func (*UnknownUnionMember) isProvisioningProperties()        {}
func (*UnknownUnionMember) isRedshiftStorage()               {}
func (*UnknownUnionMember) isSearchInventoryResultItem()     {}
func (*UnknownUnionMember) isSearchResultItem()              {}
func (*UnknownUnionMember) isSearchTypesResultItem()         {}
func (*UnknownUnionMember) isSelfGrantStatusOutput()         {}
func (*UnknownUnionMember) isSubscribedListingItem()         {}
func (*UnknownUnionMember) isSubscribedPrincipal()           {}
func (*UnknownUnionMember) isSubscribedPrincipalInput()      {}
func (*UnknownUnionMember) isUserProfileDetails()            {}
