// Code generated by smithy-go-codegen DO NOT EDIT.

package s3control

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	s3controlcust "github.com/aws/aws-sdk-go-v2/service/s3control/internal/customizations"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"strings"
	"time"
)

// Updates the IAM role of a registered location in your S3 Access Grants instance.
//
// Permissions You must have the s3:UpdateAccessGrantsLocation permission to use
// this operation.
//
// Additional Permissions You must also have the following permission: iam:PassRole
func (c *Client) UpdateAccessGrantsLocation(ctx context.Context, params *UpdateAccessGrantsLocationInput, optFns ...func(*Options)) (*UpdateAccessGrantsLocationOutput, error) {
	if params == nil {
		params = &UpdateAccessGrantsLocationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateAccessGrantsLocation", params, optFns, c.addOperationUpdateAccessGrantsLocationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateAccessGrantsLocationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateAccessGrantsLocationInput struct {

	// The ID of the registered location that you are updating. S3 Access Grants
	// assigns this ID when you register the location. S3 Access Grants assigns the ID
	// default to the default location s3:// and assigns an auto-generated ID to other
	// locations that you register.
	//
	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigned this ID when you registered the location. S3 Access Grants
	// assigns the ID default to the default location s3:// and assigns an
	// auto-generated ID to other locations that you register.
	//
	// If you are passing the default location, you cannot create an access grant for
	// the entire default location. You must also specify a bucket or a bucket and
	// prefix in the Subprefix field.
	//
	// This member is required.
	AccessGrantsLocationId *string

	// The ID of the Amazon Web Services account that is making this request.
	//
	// This member is required.
	AccountId *string

	// The Amazon Resource Name (ARN) of the IAM role for the registered location. S3
	// Access Grants assumes this role to manage access to the registered location.
	//
	// This member is required.
	IAMRoleArn *string

	noSmithyDocumentSerde
}

func (in *UpdateAccessGrantsLocationInput) bindEndpointParams(p *EndpointParameters) {

	p.AccountId = in.AccountId
	p.RequiresAccountId = ptr.Bool(true)
}

type UpdateAccessGrantsLocationOutput struct {

	// The Amazon Resource Name (ARN) of the registered location that you are
	// updating.
	AccessGrantsLocationArn *string

	// The ID of the registered location to which you are granting access. S3 Access
	// Grants assigned this ID when you registered the location. S3 Access Grants
	// assigns the ID default to the default location s3:// and assigns an
	// auto-generated ID to other locations that you register.
	AccessGrantsLocationId *string

	// The date and time when you registered the location.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the IAM role of the registered location. S3
	// Access Grants assumes this role to manage access to the registered location.
	IAMRoleArn *string

	// The S3 URI path of the location that you are updating. You cannot update the
	// scope of the registered location. The location scope can be the default S3
	// location s3:// , the S3 path to a bucket s3:// , or the S3 path to a bucket and
	// prefix s3:/// .
	LocationScope *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateAccessGrantsLocationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpUpdateAccessGrantsLocation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpUpdateAccessGrantsLocation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateAccessGrantsLocation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = s3controlcust.AddUpdateOutpostARN(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddContentChecksumMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opUpdateAccessGrantsLocationMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateAccessGrantsLocationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateAccessGrantsLocation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addMetadataRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addUpdateAccessGrantsLocationUpdateEndpoint(stack, options); err != nil {
		return err
	}
	if err = addStashOperationInput(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = v4.AddContentSHA256HeaderMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = s3controlcust.AddDisableHostPrefixMiddleware(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opUpdateAccessGrantsLocationMiddleware struct {
}

func (*endpointPrefix_opUpdateAccessGrantsLocationMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opUpdateAccessGrantsLocationMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	opaqueInput := getOperationInput(ctx)
	input, ok := opaqueInput.(*UpdateAccessGrantsLocationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input type %T", opaqueInput)
	}

	var prefix strings.Builder
	if input.AccountId == nil {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so may not be nil")}
	} else if !smithyhttp.ValidHostLabel(*input.AccountId) {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so must match \"[a-zA-Z0-9-]{1,63}\", but was \"%s\"", *input.AccountId)}
	} else {
		prefix.WriteString(*input.AccountId)
	}
	prefix.WriteString(".")
	req.URL.Host = prefix.String() + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opUpdateAccessGrantsLocationMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opUpdateAccessGrantsLocationMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opUpdateAccessGrantsLocation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateAccessGrantsLocation",
	}
}

func copyUpdateAccessGrantsLocationInputForUpdateEndpoint(params interface{}) (interface{}, error) {
	input, ok := params.(*UpdateAccessGrantsLocationInput)
	if !ok {
		return nil, fmt.Errorf("expect *UpdateAccessGrantsLocationInput type, got %T", params)
	}
	cpy := *input
	return &cpy, nil
}
func (in *UpdateAccessGrantsLocationInput) copy() interface{} {
	v := *in
	return &v
}
func backFillUpdateAccessGrantsLocationAccountID(input interface{}, v string) error {
	in := input.(*UpdateAccessGrantsLocationInput)
	if in.AccountId != nil {
		if !strings.EqualFold(*in.AccountId, v) {
			return fmt.Errorf("error backfilling account id")
		}
		return nil
	}
	in.AccountId = &v
	return nil
}
func addUpdateAccessGrantsLocationUpdateEndpoint(stack *middleware.Stack, options Options) error {
	return s3controlcust.UpdateEndpoint(stack, s3controlcust.UpdateEndpointOptions{
		Accessor: s3controlcust.UpdateEndpointParameterAccessor{GetARNInput: nopGetARNAccessor,
			BackfillAccountID: nopBackfillAccountIDAccessor,
			GetOutpostIDInput: nopGetOutpostIDFromInput,
			UpdateARNField:    nopSetARNAccessor,
			CopyInput:         copyUpdateAccessGrantsLocationInputForUpdateEndpoint,
		},
		EndpointResolver:        options.EndpointResolver,
		EndpointResolverOptions: options.EndpointOptions,
		UseARNRegion:            options.UseARNRegion,
	})
}
