// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package backup

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCancelLegalHold = "CancelLegalHold"

// CancelLegalHoldRequest generates a "aws/request.Request" representing the
// client's request for the CancelLegalHold operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelLegalHold for more information on using the CancelLegalHold
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CancelLegalHoldRequest method.
//	req, resp := client.CancelLegalHoldRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CancelLegalHold
func (c *Backup) CancelLegalHoldRequest(input *CancelLegalHoldInput) (req *request.Request, output *CancelLegalHoldOutput) {
	op := &request.Operation{
		Name:       opCancelLegalHold,
		HTTPMethod: "DELETE",
		HTTPPath:   "/legal-holds/{legalHoldId}",
	}

	if input == nil {
		input = &CancelLegalHoldInput{}
	}

	output = &CancelLegalHoldOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelLegalHold API operation for AWS Backup.
//
// This action removes the specified legal hold on a recovery point. This action
// can only be performed by a user with sufficient permissions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation CancelLegalHold for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - InvalidResourceStateException
//     Backup is already performing an action on this recovery point. It can't perform
//     the action you requested until the first action finishes. Try again later.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CancelLegalHold
func (c *Backup) CancelLegalHold(input *CancelLegalHoldInput) (*CancelLegalHoldOutput, error) {
	req, out := c.CancelLegalHoldRequest(input)
	return out, req.Send()
}

// CancelLegalHoldWithContext is the same as CancelLegalHold with the addition of
// the ability to pass a context and additional request options.
//
// See CancelLegalHold for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) CancelLegalHoldWithContext(ctx aws.Context, input *CancelLegalHoldInput, opts ...request.Option) (*CancelLegalHoldOutput, error) {
	req, out := c.CancelLegalHoldRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBackupPlan = "CreateBackupPlan"

// CreateBackupPlanRequest generates a "aws/request.Request" representing the
// client's request for the CreateBackupPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBackupPlan for more information on using the CreateBackupPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBackupPlanRequest method.
//	req, resp := client.CreateBackupPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupPlan
func (c *Backup) CreateBackupPlanRequest(input *CreateBackupPlanInput) (req *request.Request, output *CreateBackupPlanOutput) {
	op := &request.Operation{
		Name:       opCreateBackupPlan,
		HTTPMethod: "PUT",
		HTTPPath:   "/backup/plans/",
	}

	if input == nil {
		input = &CreateBackupPlanInput{}
	}

	output = &CreateBackupPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBackupPlan API operation for AWS Backup.
//
// Creates a backup plan using a backup plan name and backup rules. A backup
// plan is a document that contains information that Backup uses to schedule
// tasks that create recovery points for resources.
//
// If you call CreateBackupPlan with a plan that already exists, you receive
// an AlreadyExistsException exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation CreateBackupPlan for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
//   - AlreadyExistsException
//     The required resource already exists.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupPlan
func (c *Backup) CreateBackupPlan(input *CreateBackupPlanInput) (*CreateBackupPlanOutput, error) {
	req, out := c.CreateBackupPlanRequest(input)
	return out, req.Send()
}

// CreateBackupPlanWithContext is the same as CreateBackupPlan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBackupPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) CreateBackupPlanWithContext(ctx aws.Context, input *CreateBackupPlanInput, opts ...request.Option) (*CreateBackupPlanOutput, error) {
	req, out := c.CreateBackupPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBackupSelection = "CreateBackupSelection"

// CreateBackupSelectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateBackupSelection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBackupSelection for more information on using the CreateBackupSelection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBackupSelectionRequest method.
//	req, resp := client.CreateBackupSelectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupSelection
func (c *Backup) CreateBackupSelectionRequest(input *CreateBackupSelectionInput) (req *request.Request, output *CreateBackupSelectionOutput) {
	op := &request.Operation{
		Name:       opCreateBackupSelection,
		HTTPMethod: "PUT",
		HTTPPath:   "/backup/plans/{backupPlanId}/selections/",
	}

	if input == nil {
		input = &CreateBackupSelectionInput{}
	}

	output = &CreateBackupSelectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBackupSelection API operation for AWS Backup.
//
// Creates a JSON document that specifies a set of resources to assign to a
// backup plan. For examples, see Assigning resources programmatically (https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation CreateBackupSelection for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
//   - AlreadyExistsException
//     The required resource already exists.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupSelection
func (c *Backup) CreateBackupSelection(input *CreateBackupSelectionInput) (*CreateBackupSelectionOutput, error) {
	req, out := c.CreateBackupSelectionRequest(input)
	return out, req.Send()
}

// CreateBackupSelectionWithContext is the same as CreateBackupSelection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBackupSelection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) CreateBackupSelectionWithContext(ctx aws.Context, input *CreateBackupSelectionInput, opts ...request.Option) (*CreateBackupSelectionOutput, error) {
	req, out := c.CreateBackupSelectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBackupVault = "CreateBackupVault"

// CreateBackupVaultRequest generates a "aws/request.Request" representing the
// client's request for the CreateBackupVault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBackupVault for more information on using the CreateBackupVault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateBackupVaultRequest method.
//	req, resp := client.CreateBackupVaultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupVault
func (c *Backup) CreateBackupVaultRequest(input *CreateBackupVaultInput) (req *request.Request, output *CreateBackupVaultOutput) {
	op := &request.Operation{
		Name:       opCreateBackupVault,
		HTTPMethod: "PUT",
		HTTPPath:   "/backup-vaults/{backupVaultName}",
	}

	if input == nil {
		input = &CreateBackupVaultInput{}
	}

	output = &CreateBackupVaultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBackupVault API operation for AWS Backup.
//
// Creates a logical container where backups are stored. A CreateBackupVault
// request includes a name, optionally one or more resource tags, an encryption
// key, and a request ID.
//
// Do not include sensitive data, such as passport numbers, in the name of a
// backup vault.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation CreateBackupVault for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
//   - AlreadyExistsException
//     The required resource already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateBackupVault
func (c *Backup) CreateBackupVault(input *CreateBackupVaultInput) (*CreateBackupVaultOutput, error) {
	req, out := c.CreateBackupVaultRequest(input)
	return out, req.Send()
}

// CreateBackupVaultWithContext is the same as CreateBackupVault with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBackupVault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) CreateBackupVaultWithContext(ctx aws.Context, input *CreateBackupVaultInput, opts ...request.Option) (*CreateBackupVaultOutput, error) {
	req, out := c.CreateBackupVaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFramework = "CreateFramework"

// CreateFrameworkRequest generates a "aws/request.Request" representing the
// client's request for the CreateFramework operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFramework for more information on using the CreateFramework
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateFrameworkRequest method.
//	req, resp := client.CreateFrameworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateFramework
func (c *Backup) CreateFrameworkRequest(input *CreateFrameworkInput) (req *request.Request, output *CreateFrameworkOutput) {
	op := &request.Operation{
		Name:       opCreateFramework,
		HTTPMethod: "POST",
		HTTPPath:   "/audit/frameworks",
	}

	if input == nil {
		input = &CreateFrameworkInput{}
	}

	output = &CreateFrameworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFramework API operation for AWS Backup.
//
// Creates a framework with one or more controls. A framework is a collection
// of controls that you can use to evaluate your backup practices. By using
// pre-built customizable controls to define your policies, you can evaluate
// whether your backup practices comply with your policies and which resources
// are not yet in compliance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation CreateFramework for usage and error information.
//
// Returned Error Types:
//
//   - AlreadyExistsException
//     The required resource already exists.
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateFramework
func (c *Backup) CreateFramework(input *CreateFrameworkInput) (*CreateFrameworkOutput, error) {
	req, out := c.CreateFrameworkRequest(input)
	return out, req.Send()
}

// CreateFrameworkWithContext is the same as CreateFramework with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFramework for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) CreateFrameworkWithContext(ctx aws.Context, input *CreateFrameworkInput, opts ...request.Option) (*CreateFrameworkOutput, error) {
	req, out := c.CreateFrameworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLegalHold = "CreateLegalHold"

// CreateLegalHoldRequest generates a "aws/request.Request" representing the
// client's request for the CreateLegalHold operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLegalHold for more information on using the CreateLegalHold
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLegalHoldRequest method.
//	req, resp := client.CreateLegalHoldRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLegalHold
func (c *Backup) CreateLegalHoldRequest(input *CreateLegalHoldInput) (req *request.Request, output *CreateLegalHoldOutput) {
	op := &request.Operation{
		Name:       opCreateLegalHold,
		HTTPMethod: "POST",
		HTTPPath:   "/legal-holds/",
	}

	if input == nil {
		input = &CreateLegalHoldInput{}
	}

	output = &CreateLegalHoldOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLegalHold API operation for AWS Backup.
//
// This action creates a legal hold on a recovery point (backup). A legal hold
// is a restraint on altering or deleting a backup until an authorized user
// cancels the legal hold. Any actions to delete or disassociate a recovery
// point will fail with an error if one or more active legal holds are on the
// recovery point.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation CreateLegalHold for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLegalHold
func (c *Backup) CreateLegalHold(input *CreateLegalHoldInput) (*CreateLegalHoldOutput, error) {
	req, out := c.CreateLegalHoldRequest(input)
	return out, req.Send()
}

// CreateLegalHoldWithContext is the same as CreateLegalHold with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLegalHold for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) CreateLegalHoldWithContext(ctx aws.Context, input *CreateLegalHoldInput, opts ...request.Option) (*CreateLegalHoldOutput, error) {
	req, out := c.CreateLegalHoldRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateLogicallyAirGappedBackupVault = "CreateLogicallyAirGappedBackupVault"

// CreateLogicallyAirGappedBackupVaultRequest generates a "aws/request.Request" representing the
// client's request for the CreateLogicallyAirGappedBackupVault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateLogicallyAirGappedBackupVault for more information on using the CreateLogicallyAirGappedBackupVault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateLogicallyAirGappedBackupVaultRequest method.
//	req, resp := client.CreateLogicallyAirGappedBackupVaultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLogicallyAirGappedBackupVault
func (c *Backup) CreateLogicallyAirGappedBackupVaultRequest(input *CreateLogicallyAirGappedBackupVaultInput) (req *request.Request, output *CreateLogicallyAirGappedBackupVaultOutput) {
	op := &request.Operation{
		Name:       opCreateLogicallyAirGappedBackupVault,
		HTTPMethod: "PUT",
		HTTPPath:   "/logically-air-gapped-backup-vaults/{backupVaultName}",
	}

	if input == nil {
		input = &CreateLogicallyAirGappedBackupVaultInput{}
	}

	output = &CreateLogicallyAirGappedBackupVaultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateLogicallyAirGappedBackupVault API operation for AWS Backup.
//
// This request creates a logical container to where backups may be copied.
//
// This request includes a name, the Region, the maximum number of retention
// days, the minimum number of retention days, and optionally can include tags
// and a creator request ID.
//
// Do not include sensitive data, such as passport numbers, in the name of a
// backup vault.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation CreateLogicallyAirGappedBackupVault for usage and error information.
//
// Returned Error Types:
//
//   - AlreadyExistsException
//     The required resource already exists.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateLogicallyAirGappedBackupVault
func (c *Backup) CreateLogicallyAirGappedBackupVault(input *CreateLogicallyAirGappedBackupVaultInput) (*CreateLogicallyAirGappedBackupVaultOutput, error) {
	req, out := c.CreateLogicallyAirGappedBackupVaultRequest(input)
	return out, req.Send()
}

// CreateLogicallyAirGappedBackupVaultWithContext is the same as CreateLogicallyAirGappedBackupVault with the addition of
// the ability to pass a context and additional request options.
//
// See CreateLogicallyAirGappedBackupVault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) CreateLogicallyAirGappedBackupVaultWithContext(ctx aws.Context, input *CreateLogicallyAirGappedBackupVaultInput, opts ...request.Option) (*CreateLogicallyAirGappedBackupVaultOutput, error) {
	req, out := c.CreateLogicallyAirGappedBackupVaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReportPlan = "CreateReportPlan"

// CreateReportPlanRequest generates a "aws/request.Request" representing the
// client's request for the CreateReportPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReportPlan for more information on using the CreateReportPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateReportPlanRequest method.
//	req, resp := client.CreateReportPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateReportPlan
func (c *Backup) CreateReportPlanRequest(input *CreateReportPlanInput) (req *request.Request, output *CreateReportPlanOutput) {
	op := &request.Operation{
		Name:       opCreateReportPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/audit/report-plans",
	}

	if input == nil {
		input = &CreateReportPlanInput{}
	}

	output = &CreateReportPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReportPlan API operation for AWS Backup.
//
// Creates a report plan. A report plan is a document that contains information
// about the contents of the report and where Backup will deliver it.
//
// If you call CreateReportPlan with a plan that already exists, you receive
// an AlreadyExistsException exception.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation CreateReportPlan for usage and error information.
//
// Returned Error Types:
//
//   - AlreadyExistsException
//     The required resource already exists.
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateReportPlan
func (c *Backup) CreateReportPlan(input *CreateReportPlanInput) (*CreateReportPlanOutput, error) {
	req, out := c.CreateReportPlanRequest(input)
	return out, req.Send()
}

// CreateReportPlanWithContext is the same as CreateReportPlan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReportPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) CreateReportPlanWithContext(ctx aws.Context, input *CreateReportPlanInput, opts ...request.Option) (*CreateReportPlanOutput, error) {
	req, out := c.CreateReportPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRestoreTestingPlan = "CreateRestoreTestingPlan"

// CreateRestoreTestingPlanRequest generates a "aws/request.Request" representing the
// client's request for the CreateRestoreTestingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRestoreTestingPlan for more information on using the CreateRestoreTestingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRestoreTestingPlanRequest method.
//	req, resp := client.CreateRestoreTestingPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateRestoreTestingPlan
func (c *Backup) CreateRestoreTestingPlanRequest(input *CreateRestoreTestingPlanInput) (req *request.Request, output *CreateRestoreTestingPlanOutput) {
	op := &request.Operation{
		Name:       opCreateRestoreTestingPlan,
		HTTPMethod: "PUT",
		HTTPPath:   "/restore-testing/plans",
	}

	if input == nil {
		input = &CreateRestoreTestingPlanInput{}
	}

	output = &CreateRestoreTestingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRestoreTestingPlan API operation for AWS Backup.
//
// This is the first of two steps to create a restore testing plan; once this
// request is successful, finish the procedure with request CreateRestoreTestingSelection.
//
// You must include the parameter RestoreTestingPlan. You may optionally include
// CreatorRequestId and Tags.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation CreateRestoreTestingPlan for usage and error information.
//
// Returned Error Types:
//
//   - AlreadyExistsException
//     The required resource already exists.
//
//   - ConflictException
//     Backup can't perform the action that you requested until it finishes performing
//     a previous action. Try again later.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateRestoreTestingPlan
func (c *Backup) CreateRestoreTestingPlan(input *CreateRestoreTestingPlanInput) (*CreateRestoreTestingPlanOutput, error) {
	req, out := c.CreateRestoreTestingPlanRequest(input)
	return out, req.Send()
}

// CreateRestoreTestingPlanWithContext is the same as CreateRestoreTestingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRestoreTestingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) CreateRestoreTestingPlanWithContext(ctx aws.Context, input *CreateRestoreTestingPlanInput, opts ...request.Option) (*CreateRestoreTestingPlanOutput, error) {
	req, out := c.CreateRestoreTestingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRestoreTestingSelection = "CreateRestoreTestingSelection"

// CreateRestoreTestingSelectionRequest generates a "aws/request.Request" representing the
// client's request for the CreateRestoreTestingSelection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRestoreTestingSelection for more information on using the CreateRestoreTestingSelection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRestoreTestingSelectionRequest method.
//	req, resp := client.CreateRestoreTestingSelectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateRestoreTestingSelection
func (c *Backup) CreateRestoreTestingSelectionRequest(input *CreateRestoreTestingSelectionInput) (req *request.Request, output *CreateRestoreTestingSelectionOutput) {
	op := &request.Operation{
		Name:       opCreateRestoreTestingSelection,
		HTTPMethod: "PUT",
		HTTPPath:   "/restore-testing/plans/{RestoreTestingPlanName}/selections",
	}

	if input == nil {
		input = &CreateRestoreTestingSelectionInput{}
	}

	output = &CreateRestoreTestingSelectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRestoreTestingSelection API operation for AWS Backup.
//
// This request can be sent after CreateRestoreTestingPlan request returns successfully.
// This is the second part of creating a resource testing plan, and it must
// be completed sequentially.
//
// This consists of RestoreTestingSelectionName, ProtectedResourceType, and
// one of the following:
//
//   - ProtectedResourceArns
//
//   - ProtectedResourceConditions
//
// Each protected resource type can have one single value.
//
// A restore testing selection can include a wildcard value ("*") for ProtectedResourceArns
// along with ProtectedResourceConditions. Alternatively, you can include up
// to 30 specific protected resource ARNs in ProtectedResourceArns.
//
// Cannot select by both protected resource types AND specific ARNs. Request
// will fail if both are included.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation CreateRestoreTestingSelection for usage and error information.
//
// Returned Error Types:
//
//   - AlreadyExistsException
//     The required resource already exists.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/CreateRestoreTestingSelection
func (c *Backup) CreateRestoreTestingSelection(input *CreateRestoreTestingSelectionInput) (*CreateRestoreTestingSelectionOutput, error) {
	req, out := c.CreateRestoreTestingSelectionRequest(input)
	return out, req.Send()
}

// CreateRestoreTestingSelectionWithContext is the same as CreateRestoreTestingSelection with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRestoreTestingSelection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) CreateRestoreTestingSelectionWithContext(ctx aws.Context, input *CreateRestoreTestingSelectionInput, opts ...request.Option) (*CreateRestoreTestingSelectionOutput, error) {
	req, out := c.CreateRestoreTestingSelectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackupPlan = "DeleteBackupPlan"

// DeleteBackupPlanRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackupPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackupPlan for more information on using the DeleteBackupPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBackupPlanRequest method.
//	req, resp := client.DeleteBackupPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupPlan
func (c *Backup) DeleteBackupPlanRequest(input *DeleteBackupPlanInput) (req *request.Request, output *DeleteBackupPlanOutput) {
	op := &request.Operation{
		Name:       opDeleteBackupPlan,
		HTTPMethod: "DELETE",
		HTTPPath:   "/backup/plans/{backupPlanId}",
	}

	if input == nil {
		input = &DeleteBackupPlanInput{}
	}

	output = &DeleteBackupPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteBackupPlan API operation for AWS Backup.
//
// Deletes a backup plan. A backup plan can only be deleted after all associated
// selections of resources have been deleted. Deleting a backup plan deletes
// the current version of a backup plan. Previous versions, if any, will still
// exist.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DeleteBackupPlan for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupPlan
func (c *Backup) DeleteBackupPlan(input *DeleteBackupPlanInput) (*DeleteBackupPlanOutput, error) {
	req, out := c.DeleteBackupPlanRequest(input)
	return out, req.Send()
}

// DeleteBackupPlanWithContext is the same as DeleteBackupPlan with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackupPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DeleteBackupPlanWithContext(ctx aws.Context, input *DeleteBackupPlanInput, opts ...request.Option) (*DeleteBackupPlanOutput, error) {
	req, out := c.DeleteBackupPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackupSelection = "DeleteBackupSelection"

// DeleteBackupSelectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackupSelection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackupSelection for more information on using the DeleteBackupSelection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBackupSelectionRequest method.
//	req, resp := client.DeleteBackupSelectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupSelection
func (c *Backup) DeleteBackupSelectionRequest(input *DeleteBackupSelectionInput) (req *request.Request, output *DeleteBackupSelectionOutput) {
	op := &request.Operation{
		Name:       opDeleteBackupSelection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/backup/plans/{backupPlanId}/selections/{selectionId}",
	}

	if input == nil {
		input = &DeleteBackupSelectionInput{}
	}

	output = &DeleteBackupSelectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBackupSelection API operation for AWS Backup.
//
// Deletes the resource selection associated with a backup plan that is specified
// by the SelectionId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DeleteBackupSelection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupSelection
func (c *Backup) DeleteBackupSelection(input *DeleteBackupSelectionInput) (*DeleteBackupSelectionOutput, error) {
	req, out := c.DeleteBackupSelectionRequest(input)
	return out, req.Send()
}

// DeleteBackupSelectionWithContext is the same as DeleteBackupSelection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackupSelection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DeleteBackupSelectionWithContext(ctx aws.Context, input *DeleteBackupSelectionInput, opts ...request.Option) (*DeleteBackupSelectionOutput, error) {
	req, out := c.DeleteBackupSelectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackupVault = "DeleteBackupVault"

// DeleteBackupVaultRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackupVault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackupVault for more information on using the DeleteBackupVault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBackupVaultRequest method.
//	req, resp := client.DeleteBackupVaultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVault
func (c *Backup) DeleteBackupVaultRequest(input *DeleteBackupVaultInput) (req *request.Request, output *DeleteBackupVaultOutput) {
	op := &request.Operation{
		Name:       opDeleteBackupVault,
		HTTPMethod: "DELETE",
		HTTPPath:   "/backup-vaults/{backupVaultName}",
	}

	if input == nil {
		input = &DeleteBackupVaultInput{}
	}

	output = &DeleteBackupVaultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBackupVault API operation for AWS Backup.
//
// Deletes the backup vault identified by its name. A vault can be deleted only
// if it is empty.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DeleteBackupVault for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVault
func (c *Backup) DeleteBackupVault(input *DeleteBackupVaultInput) (*DeleteBackupVaultOutput, error) {
	req, out := c.DeleteBackupVaultRequest(input)
	return out, req.Send()
}

// DeleteBackupVaultWithContext is the same as DeleteBackupVault with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackupVault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DeleteBackupVaultWithContext(ctx aws.Context, input *DeleteBackupVaultInput, opts ...request.Option) (*DeleteBackupVaultOutput, error) {
	req, out := c.DeleteBackupVaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackupVaultAccessPolicy = "DeleteBackupVaultAccessPolicy"

// DeleteBackupVaultAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackupVaultAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackupVaultAccessPolicy for more information on using the DeleteBackupVaultAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBackupVaultAccessPolicyRequest method.
//	req, resp := client.DeleteBackupVaultAccessPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultAccessPolicy
func (c *Backup) DeleteBackupVaultAccessPolicyRequest(input *DeleteBackupVaultAccessPolicyInput) (req *request.Request, output *DeleteBackupVaultAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteBackupVaultAccessPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/backup-vaults/{backupVaultName}/access-policy",
	}

	if input == nil {
		input = &DeleteBackupVaultAccessPolicyInput{}
	}

	output = &DeleteBackupVaultAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBackupVaultAccessPolicy API operation for AWS Backup.
//
// Deletes the policy document that manages permissions on a backup vault.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DeleteBackupVaultAccessPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultAccessPolicy
func (c *Backup) DeleteBackupVaultAccessPolicy(input *DeleteBackupVaultAccessPolicyInput) (*DeleteBackupVaultAccessPolicyOutput, error) {
	req, out := c.DeleteBackupVaultAccessPolicyRequest(input)
	return out, req.Send()
}

// DeleteBackupVaultAccessPolicyWithContext is the same as DeleteBackupVaultAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackupVaultAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DeleteBackupVaultAccessPolicyWithContext(ctx aws.Context, input *DeleteBackupVaultAccessPolicyInput, opts ...request.Option) (*DeleteBackupVaultAccessPolicyOutput, error) {
	req, out := c.DeleteBackupVaultAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackupVaultLockConfiguration = "DeleteBackupVaultLockConfiguration"

// DeleteBackupVaultLockConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackupVaultLockConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackupVaultLockConfiguration for more information on using the DeleteBackupVaultLockConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBackupVaultLockConfigurationRequest method.
//	req, resp := client.DeleteBackupVaultLockConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultLockConfiguration
func (c *Backup) DeleteBackupVaultLockConfigurationRequest(input *DeleteBackupVaultLockConfigurationInput) (req *request.Request, output *DeleteBackupVaultLockConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteBackupVaultLockConfiguration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/backup-vaults/{backupVaultName}/vault-lock",
	}

	if input == nil {
		input = &DeleteBackupVaultLockConfigurationInput{}
	}

	output = &DeleteBackupVaultLockConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBackupVaultLockConfiguration API operation for AWS Backup.
//
// Deletes Backup Vault Lock from a backup vault specified by a backup vault
// name.
//
// If the Vault Lock configuration is immutable, then you cannot delete Vault
// Lock using API operations, and you will receive an InvalidRequestException
// if you attempt to do so. For more information, see Vault Lock (https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html)
// in the Backup Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DeleteBackupVaultLockConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultLockConfiguration
func (c *Backup) DeleteBackupVaultLockConfiguration(input *DeleteBackupVaultLockConfigurationInput) (*DeleteBackupVaultLockConfigurationOutput, error) {
	req, out := c.DeleteBackupVaultLockConfigurationRequest(input)
	return out, req.Send()
}

// DeleteBackupVaultLockConfigurationWithContext is the same as DeleteBackupVaultLockConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackupVaultLockConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DeleteBackupVaultLockConfigurationWithContext(ctx aws.Context, input *DeleteBackupVaultLockConfigurationInput, opts ...request.Option) (*DeleteBackupVaultLockConfigurationOutput, error) {
	req, out := c.DeleteBackupVaultLockConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackupVaultNotifications = "DeleteBackupVaultNotifications"

// DeleteBackupVaultNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackupVaultNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackupVaultNotifications for more information on using the DeleteBackupVaultNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteBackupVaultNotificationsRequest method.
//	req, resp := client.DeleteBackupVaultNotificationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultNotifications
func (c *Backup) DeleteBackupVaultNotificationsRequest(input *DeleteBackupVaultNotificationsInput) (req *request.Request, output *DeleteBackupVaultNotificationsOutput) {
	op := &request.Operation{
		Name:       opDeleteBackupVaultNotifications,
		HTTPMethod: "DELETE",
		HTTPPath:   "/backup-vaults/{backupVaultName}/notification-configuration",
	}

	if input == nil {
		input = &DeleteBackupVaultNotificationsInput{}
	}

	output = &DeleteBackupVaultNotificationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBackupVaultNotifications API operation for AWS Backup.
//
// Deletes event notifications for the specified backup vault.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DeleteBackupVaultNotifications for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteBackupVaultNotifications
func (c *Backup) DeleteBackupVaultNotifications(input *DeleteBackupVaultNotificationsInput) (*DeleteBackupVaultNotificationsOutput, error) {
	req, out := c.DeleteBackupVaultNotificationsRequest(input)
	return out, req.Send()
}

// DeleteBackupVaultNotificationsWithContext is the same as DeleteBackupVaultNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackupVaultNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DeleteBackupVaultNotificationsWithContext(ctx aws.Context, input *DeleteBackupVaultNotificationsInput, opts ...request.Option) (*DeleteBackupVaultNotificationsOutput, error) {
	req, out := c.DeleteBackupVaultNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFramework = "DeleteFramework"

// DeleteFrameworkRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFramework operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFramework for more information on using the DeleteFramework
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteFrameworkRequest method.
//	req, resp := client.DeleteFrameworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteFramework
func (c *Backup) DeleteFrameworkRequest(input *DeleteFrameworkInput) (req *request.Request, output *DeleteFrameworkOutput) {
	op := &request.Operation{
		Name:       opDeleteFramework,
		HTTPMethod: "DELETE",
		HTTPPath:   "/audit/frameworks/{frameworkName}",
	}

	if input == nil {
		input = &DeleteFrameworkInput{}
	}

	output = &DeleteFrameworkOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFramework API operation for AWS Backup.
//
// Deletes the framework specified by a framework name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DeleteFramework for usage and error information.
//
// Returned Error Types:
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - ConflictException
//     Backup can't perform the action that you requested until it finishes performing
//     a previous action. Try again later.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteFramework
func (c *Backup) DeleteFramework(input *DeleteFrameworkInput) (*DeleteFrameworkOutput, error) {
	req, out := c.DeleteFrameworkRequest(input)
	return out, req.Send()
}

// DeleteFrameworkWithContext is the same as DeleteFramework with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFramework for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DeleteFrameworkWithContext(ctx aws.Context, input *DeleteFrameworkInput, opts ...request.Option) (*DeleteFrameworkOutput, error) {
	req, out := c.DeleteFrameworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRecoveryPoint = "DeleteRecoveryPoint"

// DeleteRecoveryPointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRecoveryPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRecoveryPoint for more information on using the DeleteRecoveryPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRecoveryPointRequest method.
//	req, resp := client.DeleteRecoveryPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRecoveryPoint
func (c *Backup) DeleteRecoveryPointRequest(input *DeleteRecoveryPointInput) (req *request.Request, output *DeleteRecoveryPointOutput) {
	op := &request.Operation{
		Name:       opDeleteRecoveryPoint,
		HTTPMethod: "DELETE",
		HTTPPath:   "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}",
	}

	if input == nil {
		input = &DeleteRecoveryPointInput{}
	}

	output = &DeleteRecoveryPointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRecoveryPoint API operation for AWS Backup.
//
// Deletes the recovery point specified by a recovery point ID.
//
// If the recovery point ID belongs to a continuous backup, calling this endpoint
// deletes the existing continuous backup and stops future continuous backup.
//
// When an IAM role's permissions are insufficient to call this API, the service
// sends back an HTTP 200 response with an empty HTTP body, but the recovery
// point is not deleted. Instead, it enters an EXPIRED state.
//
// EXPIRED recovery points can be deleted with this API once the IAM role has
// the iam:CreateServiceLinkedRole action. To learn more about adding this role,
// see Troubleshooting manual deletions (https://docs.aws.amazon.com/aws-backup/latest/devguide/deleting-backups.html#deleting-backups-troubleshooting).
//
// If the user or role is deleted or the permission within the role is removed,
// the deletion will not be successful and will enter an EXPIRED state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DeleteRecoveryPoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - InvalidResourceStateException
//     Backup is already performing an action on this recovery point. It can't perform
//     the action you requested until the first action finishes. Try again later.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRecoveryPoint
func (c *Backup) DeleteRecoveryPoint(input *DeleteRecoveryPointInput) (*DeleteRecoveryPointOutput, error) {
	req, out := c.DeleteRecoveryPointRequest(input)
	return out, req.Send()
}

// DeleteRecoveryPointWithContext is the same as DeleteRecoveryPoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRecoveryPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DeleteRecoveryPointWithContext(ctx aws.Context, input *DeleteRecoveryPointInput, opts ...request.Option) (*DeleteRecoveryPointOutput, error) {
	req, out := c.DeleteRecoveryPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReportPlan = "DeleteReportPlan"

// DeleteReportPlanRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReportPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReportPlan for more information on using the DeleteReportPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteReportPlanRequest method.
//	req, resp := client.DeleteReportPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteReportPlan
func (c *Backup) DeleteReportPlanRequest(input *DeleteReportPlanInput) (req *request.Request, output *DeleteReportPlanOutput) {
	op := &request.Operation{
		Name:       opDeleteReportPlan,
		HTTPMethod: "DELETE",
		HTTPPath:   "/audit/report-plans/{reportPlanName}",
	}

	if input == nil {
		input = &DeleteReportPlanInput{}
	}

	output = &DeleteReportPlanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReportPlan API operation for AWS Backup.
//
// Deletes the report plan specified by a report plan name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DeleteReportPlan for usage and error information.
//
// Returned Error Types:
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ConflictException
//     Backup can't perform the action that you requested until it finishes performing
//     a previous action. Try again later.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteReportPlan
func (c *Backup) DeleteReportPlan(input *DeleteReportPlanInput) (*DeleteReportPlanOutput, error) {
	req, out := c.DeleteReportPlanRequest(input)
	return out, req.Send()
}

// DeleteReportPlanWithContext is the same as DeleteReportPlan with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReportPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DeleteReportPlanWithContext(ctx aws.Context, input *DeleteReportPlanInput, opts ...request.Option) (*DeleteReportPlanOutput, error) {
	req, out := c.DeleteReportPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRestoreTestingPlan = "DeleteRestoreTestingPlan"

// DeleteRestoreTestingPlanRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRestoreTestingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRestoreTestingPlan for more information on using the DeleteRestoreTestingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRestoreTestingPlanRequest method.
//	req, resp := client.DeleteRestoreTestingPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRestoreTestingPlan
func (c *Backup) DeleteRestoreTestingPlanRequest(input *DeleteRestoreTestingPlanInput) (req *request.Request, output *DeleteRestoreTestingPlanOutput) {
	op := &request.Operation{
		Name:       opDeleteRestoreTestingPlan,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restore-testing/plans/{RestoreTestingPlanName}",
	}

	if input == nil {
		input = &DeleteRestoreTestingPlanInput{}
	}

	output = &DeleteRestoreTestingPlanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRestoreTestingPlan API operation for AWS Backup.
//
// This request deletes the specified restore testing plan.
//
// Deletion can only successfully occur if all associated restore testing selections
// are deleted first.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DeleteRestoreTestingPlan for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRestoreTestingPlan
func (c *Backup) DeleteRestoreTestingPlan(input *DeleteRestoreTestingPlanInput) (*DeleteRestoreTestingPlanOutput, error) {
	req, out := c.DeleteRestoreTestingPlanRequest(input)
	return out, req.Send()
}

// DeleteRestoreTestingPlanWithContext is the same as DeleteRestoreTestingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRestoreTestingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DeleteRestoreTestingPlanWithContext(ctx aws.Context, input *DeleteRestoreTestingPlanInput, opts ...request.Option) (*DeleteRestoreTestingPlanOutput, error) {
	req, out := c.DeleteRestoreTestingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRestoreTestingSelection = "DeleteRestoreTestingSelection"

// DeleteRestoreTestingSelectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRestoreTestingSelection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRestoreTestingSelection for more information on using the DeleteRestoreTestingSelection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRestoreTestingSelectionRequest method.
//	req, resp := client.DeleteRestoreTestingSelectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRestoreTestingSelection
func (c *Backup) DeleteRestoreTestingSelectionRequest(input *DeleteRestoreTestingSelectionInput) (req *request.Request, output *DeleteRestoreTestingSelectionOutput) {
	op := &request.Operation{
		Name:       opDeleteRestoreTestingSelection,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restore-testing/plans/{RestoreTestingPlanName}/selections/{RestoreTestingSelectionName}",
	}

	if input == nil {
		input = &DeleteRestoreTestingSelectionInput{}
	}

	output = &DeleteRestoreTestingSelectionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRestoreTestingSelection API operation for AWS Backup.
//
// Input the Restore Testing Plan name and Restore Testing Selection name.
//
// All testing selections associated with a restore testing plan must be deleted
// before the restore testing plan can be deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DeleteRestoreTestingSelection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DeleteRestoreTestingSelection
func (c *Backup) DeleteRestoreTestingSelection(input *DeleteRestoreTestingSelectionInput) (*DeleteRestoreTestingSelectionOutput, error) {
	req, out := c.DeleteRestoreTestingSelectionRequest(input)
	return out, req.Send()
}

// DeleteRestoreTestingSelectionWithContext is the same as DeleteRestoreTestingSelection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRestoreTestingSelection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DeleteRestoreTestingSelectionWithContext(ctx aws.Context, input *DeleteRestoreTestingSelectionInput, opts ...request.Option) (*DeleteRestoreTestingSelectionOutput, error) {
	req, out := c.DeleteRestoreTestingSelectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBackupJob = "DescribeBackupJob"

// DescribeBackupJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBackupJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBackupJob for more information on using the DescribeBackupJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBackupJobRequest method.
//	req, resp := client.DescribeBackupJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupJob
func (c *Backup) DescribeBackupJobRequest(input *DescribeBackupJobInput) (req *request.Request, output *DescribeBackupJobOutput) {
	op := &request.Operation{
		Name:       opDescribeBackupJob,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-jobs/{backupJobId}",
	}

	if input == nil {
		input = &DescribeBackupJobInput{}
	}

	output = &DescribeBackupJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBackupJob API operation for AWS Backup.
//
// Returns backup job details for the specified BackupJobId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DescribeBackupJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - DependencyFailureException
//     A dependent Amazon Web Services service or resource returned an error to
//     the Backup service, and the action cannot be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupJob
func (c *Backup) DescribeBackupJob(input *DescribeBackupJobInput) (*DescribeBackupJobOutput, error) {
	req, out := c.DescribeBackupJobRequest(input)
	return out, req.Send()
}

// DescribeBackupJobWithContext is the same as DescribeBackupJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBackupJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DescribeBackupJobWithContext(ctx aws.Context, input *DescribeBackupJobInput, opts ...request.Option) (*DescribeBackupJobOutput, error) {
	req, out := c.DescribeBackupJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBackupVault = "DescribeBackupVault"

// DescribeBackupVaultRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBackupVault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBackupVault for more information on using the DescribeBackupVault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeBackupVaultRequest method.
//	req, resp := client.DescribeBackupVaultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupVault
func (c *Backup) DescribeBackupVaultRequest(input *DescribeBackupVaultInput) (req *request.Request, output *DescribeBackupVaultOutput) {
	op := &request.Operation{
		Name:       opDescribeBackupVault,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-vaults/{backupVaultName}",
	}

	if input == nil {
		input = &DescribeBackupVaultInput{}
	}

	output = &DescribeBackupVaultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBackupVault API operation for AWS Backup.
//
// Returns metadata about a backup vault specified by its name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DescribeBackupVault for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeBackupVault
func (c *Backup) DescribeBackupVault(input *DescribeBackupVaultInput) (*DescribeBackupVaultOutput, error) {
	req, out := c.DescribeBackupVaultRequest(input)
	return out, req.Send()
}

// DescribeBackupVaultWithContext is the same as DescribeBackupVault with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBackupVault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DescribeBackupVaultWithContext(ctx aws.Context, input *DescribeBackupVaultInput, opts ...request.Option) (*DescribeBackupVaultOutput, error) {
	req, out := c.DescribeBackupVaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCopyJob = "DescribeCopyJob"

// DescribeCopyJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCopyJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCopyJob for more information on using the DescribeCopyJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeCopyJobRequest method.
//	req, resp := client.DescribeCopyJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeCopyJob
func (c *Backup) DescribeCopyJobRequest(input *DescribeCopyJobInput) (req *request.Request, output *DescribeCopyJobOutput) {
	op := &request.Operation{
		Name:       opDescribeCopyJob,
		HTTPMethod: "GET",
		HTTPPath:   "/copy-jobs/{copyJobId}",
	}

	if input == nil {
		input = &DescribeCopyJobInput{}
	}

	output = &DescribeCopyJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCopyJob API operation for AWS Backup.
//
// Returns metadata associated with creating a copy of a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DescribeCopyJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeCopyJob
func (c *Backup) DescribeCopyJob(input *DescribeCopyJobInput) (*DescribeCopyJobOutput, error) {
	req, out := c.DescribeCopyJobRequest(input)
	return out, req.Send()
}

// DescribeCopyJobWithContext is the same as DescribeCopyJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCopyJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DescribeCopyJobWithContext(ctx aws.Context, input *DescribeCopyJobInput, opts ...request.Option) (*DescribeCopyJobOutput, error) {
	req, out := c.DescribeCopyJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFramework = "DescribeFramework"

// DescribeFrameworkRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFramework operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFramework for more information on using the DescribeFramework
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeFrameworkRequest method.
//	req, resp := client.DescribeFrameworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeFramework
func (c *Backup) DescribeFrameworkRequest(input *DescribeFrameworkInput) (req *request.Request, output *DescribeFrameworkOutput) {
	op := &request.Operation{
		Name:       opDescribeFramework,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/frameworks/{frameworkName}",
	}

	if input == nil {
		input = &DescribeFrameworkInput{}
	}

	output = &DescribeFrameworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFramework API operation for AWS Backup.
//
// Returns the framework details for the specified FrameworkName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DescribeFramework for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeFramework
func (c *Backup) DescribeFramework(input *DescribeFrameworkInput) (*DescribeFrameworkOutput, error) {
	req, out := c.DescribeFrameworkRequest(input)
	return out, req.Send()
}

// DescribeFrameworkWithContext is the same as DescribeFramework with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFramework for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DescribeFrameworkWithContext(ctx aws.Context, input *DescribeFrameworkInput, opts ...request.Option) (*DescribeFrameworkOutput, error) {
	req, out := c.DescribeFrameworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeGlobalSettings = "DescribeGlobalSettings"

// DescribeGlobalSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeGlobalSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeGlobalSettings for more information on using the DescribeGlobalSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeGlobalSettingsRequest method.
//	req, resp := client.DescribeGlobalSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeGlobalSettings
func (c *Backup) DescribeGlobalSettingsRequest(input *DescribeGlobalSettingsInput) (req *request.Request, output *DescribeGlobalSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeGlobalSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/global-settings",
	}

	if input == nil {
		input = &DescribeGlobalSettingsInput{}
	}

	output = &DescribeGlobalSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeGlobalSettings API operation for AWS Backup.
//
// Describes whether the Amazon Web Services account is opted in to cross-account
// backup. Returns an error if the account is not a member of an Organizations
// organization. Example: describe-global-settings --region us-west-2
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DescribeGlobalSettings for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeGlobalSettings
func (c *Backup) DescribeGlobalSettings(input *DescribeGlobalSettingsInput) (*DescribeGlobalSettingsOutput, error) {
	req, out := c.DescribeGlobalSettingsRequest(input)
	return out, req.Send()
}

// DescribeGlobalSettingsWithContext is the same as DescribeGlobalSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeGlobalSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DescribeGlobalSettingsWithContext(ctx aws.Context, input *DescribeGlobalSettingsInput, opts ...request.Option) (*DescribeGlobalSettingsOutput, error) {
	req, out := c.DescribeGlobalSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeProtectedResource = "DescribeProtectedResource"

// DescribeProtectedResourceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeProtectedResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeProtectedResource for more information on using the DescribeProtectedResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeProtectedResourceRequest method.
//	req, resp := client.DescribeProtectedResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeProtectedResource
func (c *Backup) DescribeProtectedResourceRequest(input *DescribeProtectedResourceInput) (req *request.Request, output *DescribeProtectedResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeProtectedResource,
		HTTPMethod: "GET",
		HTTPPath:   "/resources/{resourceArn}",
	}

	if input == nil {
		input = &DescribeProtectedResourceInput{}
	}

	output = &DescribeProtectedResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeProtectedResource API operation for AWS Backup.
//
// Returns information about a saved resource, including the last time it was
// backed up, its Amazon Resource Name (ARN), and the Amazon Web Services service
// type of the saved resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DescribeProtectedResource for usage and error information.
//
// Returned Error Types:
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeProtectedResource
func (c *Backup) DescribeProtectedResource(input *DescribeProtectedResourceInput) (*DescribeProtectedResourceOutput, error) {
	req, out := c.DescribeProtectedResourceRequest(input)
	return out, req.Send()
}

// DescribeProtectedResourceWithContext is the same as DescribeProtectedResource with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeProtectedResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DescribeProtectedResourceWithContext(ctx aws.Context, input *DescribeProtectedResourceInput, opts ...request.Option) (*DescribeProtectedResourceOutput, error) {
	req, out := c.DescribeProtectedResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRecoveryPoint = "DescribeRecoveryPoint"

// DescribeRecoveryPointRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRecoveryPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRecoveryPoint for more information on using the DescribeRecoveryPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRecoveryPointRequest method.
//	req, resp := client.DescribeRecoveryPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRecoveryPoint
func (c *Backup) DescribeRecoveryPointRequest(input *DescribeRecoveryPointInput) (req *request.Request, output *DescribeRecoveryPointOutput) {
	op := &request.Operation{
		Name:       opDescribeRecoveryPoint,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}",
	}

	if input == nil {
		input = &DescribeRecoveryPointInput{}
	}

	output = &DescribeRecoveryPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRecoveryPoint API operation for AWS Backup.
//
// Returns metadata associated with a recovery point, including ID, status,
// encryption, and lifecycle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DescribeRecoveryPoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRecoveryPoint
func (c *Backup) DescribeRecoveryPoint(input *DescribeRecoveryPointInput) (*DescribeRecoveryPointOutput, error) {
	req, out := c.DescribeRecoveryPointRequest(input)
	return out, req.Send()
}

// DescribeRecoveryPointWithContext is the same as DescribeRecoveryPoint with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRecoveryPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DescribeRecoveryPointWithContext(ctx aws.Context, input *DescribeRecoveryPointInput, opts ...request.Option) (*DescribeRecoveryPointOutput, error) {
	req, out := c.DescribeRecoveryPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRegionSettings = "DescribeRegionSettings"

// DescribeRegionSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRegionSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRegionSettings for more information on using the DescribeRegionSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRegionSettingsRequest method.
//	req, resp := client.DescribeRegionSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRegionSettings
func (c *Backup) DescribeRegionSettingsRequest(input *DescribeRegionSettingsInput) (req *request.Request, output *DescribeRegionSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeRegionSettings,
		HTTPMethod: "GET",
		HTTPPath:   "/account-settings",
	}

	if input == nil {
		input = &DescribeRegionSettingsInput{}
	}

	output = &DescribeRegionSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRegionSettings API operation for AWS Backup.
//
// Returns the current service opt-in settings for the Region. If service opt-in
// is enabled for a service, Backup tries to protect that service's resources
// in this Region, when the resource is included in an on-demand backup or scheduled
// backup plan. Otherwise, Backup does not try to protect that service's resources
// in this Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DescribeRegionSettings for usage and error information.
//
// Returned Error Types:
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRegionSettings
func (c *Backup) DescribeRegionSettings(input *DescribeRegionSettingsInput) (*DescribeRegionSettingsOutput, error) {
	req, out := c.DescribeRegionSettingsRequest(input)
	return out, req.Send()
}

// DescribeRegionSettingsWithContext is the same as DescribeRegionSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRegionSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DescribeRegionSettingsWithContext(ctx aws.Context, input *DescribeRegionSettingsInput, opts ...request.Option) (*DescribeRegionSettingsOutput, error) {
	req, out := c.DescribeRegionSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReportJob = "DescribeReportJob"

// DescribeReportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReportJob for more information on using the DescribeReportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReportJobRequest method.
//	req, resp := client.DescribeReportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportJob
func (c *Backup) DescribeReportJobRequest(input *DescribeReportJobInput) (req *request.Request, output *DescribeReportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeReportJob,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/report-jobs/{reportJobId}",
	}

	if input == nil {
		input = &DescribeReportJobInput{}
	}

	output = &DescribeReportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReportJob API operation for AWS Backup.
//
// Returns the details associated with creating a report as specified by its
// ReportJobId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DescribeReportJob for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportJob
func (c *Backup) DescribeReportJob(input *DescribeReportJobInput) (*DescribeReportJobOutput, error) {
	req, out := c.DescribeReportJobRequest(input)
	return out, req.Send()
}

// DescribeReportJobWithContext is the same as DescribeReportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DescribeReportJobWithContext(ctx aws.Context, input *DescribeReportJobInput, opts ...request.Option) (*DescribeReportJobOutput, error) {
	req, out := c.DescribeReportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReportPlan = "DescribeReportPlan"

// DescribeReportPlanRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReportPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReportPlan for more information on using the DescribeReportPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeReportPlanRequest method.
//	req, resp := client.DescribeReportPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportPlan
func (c *Backup) DescribeReportPlanRequest(input *DescribeReportPlanInput) (req *request.Request, output *DescribeReportPlanOutput) {
	op := &request.Operation{
		Name:       opDescribeReportPlan,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/report-plans/{reportPlanName}",
	}

	if input == nil {
		input = &DescribeReportPlanInput{}
	}

	output = &DescribeReportPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReportPlan API operation for AWS Backup.
//
// Returns a list of all report plans for an Amazon Web Services account and
// Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DescribeReportPlan for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeReportPlan
func (c *Backup) DescribeReportPlan(input *DescribeReportPlanInput) (*DescribeReportPlanOutput, error) {
	req, out := c.DescribeReportPlanRequest(input)
	return out, req.Send()
}

// DescribeReportPlanWithContext is the same as DescribeReportPlan with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReportPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DescribeReportPlanWithContext(ctx aws.Context, input *DescribeReportPlanInput, opts ...request.Option) (*DescribeReportPlanOutput, error) {
	req, out := c.DescribeReportPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRestoreJob = "DescribeRestoreJob"

// DescribeRestoreJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRestoreJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRestoreJob for more information on using the DescribeRestoreJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRestoreJobRequest method.
//	req, resp := client.DescribeRestoreJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRestoreJob
func (c *Backup) DescribeRestoreJobRequest(input *DescribeRestoreJobInput) (req *request.Request, output *DescribeRestoreJobOutput) {
	op := &request.Operation{
		Name:       opDescribeRestoreJob,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-jobs/{restoreJobId}",
	}

	if input == nil {
		input = &DescribeRestoreJobInput{}
	}

	output = &DescribeRestoreJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRestoreJob API operation for AWS Backup.
//
// Returns metadata associated with a restore job that is specified by a job
// ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DescribeRestoreJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - DependencyFailureException
//     A dependent Amazon Web Services service or resource returned an error to
//     the Backup service, and the action cannot be completed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRestoreJob
func (c *Backup) DescribeRestoreJob(input *DescribeRestoreJobInput) (*DescribeRestoreJobOutput, error) {
	req, out := c.DescribeRestoreJobRequest(input)
	return out, req.Send()
}

// DescribeRestoreJobWithContext is the same as DescribeRestoreJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRestoreJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DescribeRestoreJobWithContext(ctx aws.Context, input *DescribeRestoreJobInput, opts ...request.Option) (*DescribeRestoreJobOutput, error) {
	req, out := c.DescribeRestoreJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateRecoveryPoint = "DisassociateRecoveryPoint"

// DisassociateRecoveryPointRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateRecoveryPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateRecoveryPoint for more information on using the DisassociateRecoveryPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateRecoveryPointRequest method.
//	req, resp := client.DisassociateRecoveryPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPoint
func (c *Backup) DisassociateRecoveryPointRequest(input *DisassociateRecoveryPointInput) (req *request.Request, output *DisassociateRecoveryPointOutput) {
	op := &request.Operation{
		Name:       opDisassociateRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}/disassociate",
	}

	if input == nil {
		input = &DisassociateRecoveryPointInput{}
	}

	output = &DisassociateRecoveryPointOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateRecoveryPoint API operation for AWS Backup.
//
// Deletes the specified continuous backup recovery point from Backup and releases
// control of that continuous backup to the source service, such as Amazon RDS.
// The source service will continue to create and retain continuous backups
// using the lifecycle that you specified in your original backup plan.
//
// Does not support snapshot backup recovery points.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DisassociateRecoveryPoint for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - InvalidResourceStateException
//     Backup is already performing an action on this recovery point. It can't perform
//     the action you requested until the first action finishes. Try again later.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPoint
func (c *Backup) DisassociateRecoveryPoint(input *DisassociateRecoveryPointInput) (*DisassociateRecoveryPointOutput, error) {
	req, out := c.DisassociateRecoveryPointRequest(input)
	return out, req.Send()
}

// DisassociateRecoveryPointWithContext is the same as DisassociateRecoveryPoint with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateRecoveryPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DisassociateRecoveryPointWithContext(ctx aws.Context, input *DisassociateRecoveryPointInput, opts ...request.Option) (*DisassociateRecoveryPointOutput, error) {
	req, out := c.DisassociateRecoveryPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateRecoveryPointFromParent = "DisassociateRecoveryPointFromParent"

// DisassociateRecoveryPointFromParentRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateRecoveryPointFromParent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateRecoveryPointFromParent for more information on using the DisassociateRecoveryPointFromParent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateRecoveryPointFromParentRequest method.
//	req, resp := client.DisassociateRecoveryPointFromParentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPointFromParent
func (c *Backup) DisassociateRecoveryPointFromParentRequest(input *DisassociateRecoveryPointFromParentInput) (req *request.Request, output *DisassociateRecoveryPointFromParentOutput) {
	op := &request.Operation{
		Name:       opDisassociateRecoveryPointFromParent,
		HTTPMethod: "DELETE",
		HTTPPath:   "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}/parentAssociation",
	}

	if input == nil {
		input = &DisassociateRecoveryPointFromParentInput{}
	}

	output = &DisassociateRecoveryPointFromParentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateRecoveryPointFromParent API operation for AWS Backup.
//
// This action to a specific child (nested) recovery point removes the relationship
// between the specified recovery point and its parent (composite) recovery
// point.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation DisassociateRecoveryPointFromParent for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DisassociateRecoveryPointFromParent
func (c *Backup) DisassociateRecoveryPointFromParent(input *DisassociateRecoveryPointFromParentInput) (*DisassociateRecoveryPointFromParentOutput, error) {
	req, out := c.DisassociateRecoveryPointFromParentRequest(input)
	return out, req.Send()
}

// DisassociateRecoveryPointFromParentWithContext is the same as DisassociateRecoveryPointFromParent with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateRecoveryPointFromParent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) DisassociateRecoveryPointFromParentWithContext(ctx aws.Context, input *DisassociateRecoveryPointFromParentInput, opts ...request.Option) (*DisassociateRecoveryPointFromParentOutput, error) {
	req, out := c.DisassociateRecoveryPointFromParentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportBackupPlanTemplate = "ExportBackupPlanTemplate"

// ExportBackupPlanTemplateRequest generates a "aws/request.Request" representing the
// client's request for the ExportBackupPlanTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportBackupPlanTemplate for more information on using the ExportBackupPlanTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ExportBackupPlanTemplateRequest method.
//	req, resp := client.ExportBackupPlanTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ExportBackupPlanTemplate
func (c *Backup) ExportBackupPlanTemplateRequest(input *ExportBackupPlanTemplateInput) (req *request.Request, output *ExportBackupPlanTemplateOutput) {
	op := &request.Operation{
		Name:       opExportBackupPlanTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/backup/plans/{backupPlanId}/toTemplate/",
	}

	if input == nil {
		input = &ExportBackupPlanTemplateInput{}
	}

	output = &ExportBackupPlanTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportBackupPlanTemplate API operation for AWS Backup.
//
// Returns the backup plan that is specified by the plan ID as a backup template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ExportBackupPlanTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ExportBackupPlanTemplate
func (c *Backup) ExportBackupPlanTemplate(input *ExportBackupPlanTemplateInput) (*ExportBackupPlanTemplateOutput, error) {
	req, out := c.ExportBackupPlanTemplateRequest(input)
	return out, req.Send()
}

// ExportBackupPlanTemplateWithContext is the same as ExportBackupPlanTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See ExportBackupPlanTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ExportBackupPlanTemplateWithContext(ctx aws.Context, input *ExportBackupPlanTemplateInput, opts ...request.Option) (*ExportBackupPlanTemplateOutput, error) {
	req, out := c.ExportBackupPlanTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBackupPlan = "GetBackupPlan"

// GetBackupPlanRequest generates a "aws/request.Request" representing the
// client's request for the GetBackupPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBackupPlan for more information on using the GetBackupPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBackupPlanRequest method.
//	req, resp := client.GetBackupPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlan
func (c *Backup) GetBackupPlanRequest(input *GetBackupPlanInput) (req *request.Request, output *GetBackupPlanOutput) {
	op := &request.Operation{
		Name:       opGetBackupPlan,
		HTTPMethod: "GET",
		HTTPPath:   "/backup/plans/{backupPlanId}/",
	}

	if input == nil {
		input = &GetBackupPlanInput{}
	}

	output = &GetBackupPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBackupPlan API operation for AWS Backup.
//
// Returns BackupPlan details for the specified BackupPlanId. The details are
// the body of a backup plan in JSON format, in addition to plan metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetBackupPlan for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlan
func (c *Backup) GetBackupPlan(input *GetBackupPlanInput) (*GetBackupPlanOutput, error) {
	req, out := c.GetBackupPlanRequest(input)
	return out, req.Send()
}

// GetBackupPlanWithContext is the same as GetBackupPlan with the addition of
// the ability to pass a context and additional request options.
//
// See GetBackupPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetBackupPlanWithContext(ctx aws.Context, input *GetBackupPlanInput, opts ...request.Option) (*GetBackupPlanOutput, error) {
	req, out := c.GetBackupPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBackupPlanFromJSON = "GetBackupPlanFromJSON"

// GetBackupPlanFromJSONRequest generates a "aws/request.Request" representing the
// client's request for the GetBackupPlanFromJSON operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBackupPlanFromJSON for more information on using the GetBackupPlanFromJSON
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBackupPlanFromJSONRequest method.
//	req, resp := client.GetBackupPlanFromJSONRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromJSON
func (c *Backup) GetBackupPlanFromJSONRequest(input *GetBackupPlanFromJSONInput) (req *request.Request, output *GetBackupPlanFromJSONOutput) {
	op := &request.Operation{
		Name:       opGetBackupPlanFromJSON,
		HTTPMethod: "POST",
		HTTPPath:   "/backup/template/json/toPlan",
	}

	if input == nil {
		input = &GetBackupPlanFromJSONInput{}
	}

	output = &GetBackupPlanFromJSONOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBackupPlanFromJSON API operation for AWS Backup.
//
// Returns a valid JSON document specifying a backup plan or an error.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetBackupPlanFromJSON for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromJSON
func (c *Backup) GetBackupPlanFromJSON(input *GetBackupPlanFromJSONInput) (*GetBackupPlanFromJSONOutput, error) {
	req, out := c.GetBackupPlanFromJSONRequest(input)
	return out, req.Send()
}

// GetBackupPlanFromJSONWithContext is the same as GetBackupPlanFromJSON with the addition of
// the ability to pass a context and additional request options.
//
// See GetBackupPlanFromJSON for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetBackupPlanFromJSONWithContext(ctx aws.Context, input *GetBackupPlanFromJSONInput, opts ...request.Option) (*GetBackupPlanFromJSONOutput, error) {
	req, out := c.GetBackupPlanFromJSONRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBackupPlanFromTemplate = "GetBackupPlanFromTemplate"

// GetBackupPlanFromTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetBackupPlanFromTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBackupPlanFromTemplate for more information on using the GetBackupPlanFromTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBackupPlanFromTemplateRequest method.
//	req, resp := client.GetBackupPlanFromTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromTemplate
func (c *Backup) GetBackupPlanFromTemplateRequest(input *GetBackupPlanFromTemplateInput) (req *request.Request, output *GetBackupPlanFromTemplateOutput) {
	op := &request.Operation{
		Name:       opGetBackupPlanFromTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/backup/template/plans/{templateId}/toPlan",
	}

	if input == nil {
		input = &GetBackupPlanFromTemplateInput{}
	}

	output = &GetBackupPlanFromTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBackupPlanFromTemplate API operation for AWS Backup.
//
// Returns the template specified by its templateId as a backup plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetBackupPlanFromTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupPlanFromTemplate
func (c *Backup) GetBackupPlanFromTemplate(input *GetBackupPlanFromTemplateInput) (*GetBackupPlanFromTemplateOutput, error) {
	req, out := c.GetBackupPlanFromTemplateRequest(input)
	return out, req.Send()
}

// GetBackupPlanFromTemplateWithContext is the same as GetBackupPlanFromTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetBackupPlanFromTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetBackupPlanFromTemplateWithContext(ctx aws.Context, input *GetBackupPlanFromTemplateInput, opts ...request.Option) (*GetBackupPlanFromTemplateOutput, error) {
	req, out := c.GetBackupPlanFromTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBackupSelection = "GetBackupSelection"

// GetBackupSelectionRequest generates a "aws/request.Request" representing the
// client's request for the GetBackupSelection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBackupSelection for more information on using the GetBackupSelection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBackupSelectionRequest method.
//	req, resp := client.GetBackupSelectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupSelection
func (c *Backup) GetBackupSelectionRequest(input *GetBackupSelectionInput) (req *request.Request, output *GetBackupSelectionOutput) {
	op := &request.Operation{
		Name:       opGetBackupSelection,
		HTTPMethod: "GET",
		HTTPPath:   "/backup/plans/{backupPlanId}/selections/{selectionId}",
	}

	if input == nil {
		input = &GetBackupSelectionInput{}
	}

	output = &GetBackupSelectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBackupSelection API operation for AWS Backup.
//
// Returns selection metadata and a document in JSON format that specifies a
// list of resources that are associated with a backup plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetBackupSelection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupSelection
func (c *Backup) GetBackupSelection(input *GetBackupSelectionInput) (*GetBackupSelectionOutput, error) {
	req, out := c.GetBackupSelectionRequest(input)
	return out, req.Send()
}

// GetBackupSelectionWithContext is the same as GetBackupSelection with the addition of
// the ability to pass a context and additional request options.
//
// See GetBackupSelection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetBackupSelectionWithContext(ctx aws.Context, input *GetBackupSelectionInput, opts ...request.Option) (*GetBackupSelectionOutput, error) {
	req, out := c.GetBackupSelectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBackupVaultAccessPolicy = "GetBackupVaultAccessPolicy"

// GetBackupVaultAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetBackupVaultAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBackupVaultAccessPolicy for more information on using the GetBackupVaultAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBackupVaultAccessPolicyRequest method.
//	req, resp := client.GetBackupVaultAccessPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultAccessPolicy
func (c *Backup) GetBackupVaultAccessPolicyRequest(input *GetBackupVaultAccessPolicyInput) (req *request.Request, output *GetBackupVaultAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opGetBackupVaultAccessPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-vaults/{backupVaultName}/access-policy",
	}

	if input == nil {
		input = &GetBackupVaultAccessPolicyInput{}
	}

	output = &GetBackupVaultAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBackupVaultAccessPolicy API operation for AWS Backup.
//
// Returns the access policy document that is associated with the named backup
// vault.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetBackupVaultAccessPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultAccessPolicy
func (c *Backup) GetBackupVaultAccessPolicy(input *GetBackupVaultAccessPolicyInput) (*GetBackupVaultAccessPolicyOutput, error) {
	req, out := c.GetBackupVaultAccessPolicyRequest(input)
	return out, req.Send()
}

// GetBackupVaultAccessPolicyWithContext is the same as GetBackupVaultAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetBackupVaultAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetBackupVaultAccessPolicyWithContext(ctx aws.Context, input *GetBackupVaultAccessPolicyInput, opts ...request.Option) (*GetBackupVaultAccessPolicyOutput, error) {
	req, out := c.GetBackupVaultAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBackupVaultNotifications = "GetBackupVaultNotifications"

// GetBackupVaultNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the GetBackupVaultNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBackupVaultNotifications for more information on using the GetBackupVaultNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetBackupVaultNotificationsRequest method.
//	req, resp := client.GetBackupVaultNotificationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultNotifications
func (c *Backup) GetBackupVaultNotificationsRequest(input *GetBackupVaultNotificationsInput) (req *request.Request, output *GetBackupVaultNotificationsOutput) {
	op := &request.Operation{
		Name:       opGetBackupVaultNotifications,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-vaults/{backupVaultName}/notification-configuration",
	}

	if input == nil {
		input = &GetBackupVaultNotificationsInput{}
	}

	output = &GetBackupVaultNotificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBackupVaultNotifications API operation for AWS Backup.
//
// Returns event notifications for the specified backup vault.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetBackupVaultNotifications for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetBackupVaultNotifications
func (c *Backup) GetBackupVaultNotifications(input *GetBackupVaultNotificationsInput) (*GetBackupVaultNotificationsOutput, error) {
	req, out := c.GetBackupVaultNotificationsRequest(input)
	return out, req.Send()
}

// GetBackupVaultNotificationsWithContext is the same as GetBackupVaultNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See GetBackupVaultNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetBackupVaultNotificationsWithContext(ctx aws.Context, input *GetBackupVaultNotificationsInput, opts ...request.Option) (*GetBackupVaultNotificationsOutput, error) {
	req, out := c.GetBackupVaultNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLegalHold = "GetLegalHold"

// GetLegalHoldRequest generates a "aws/request.Request" representing the
// client's request for the GetLegalHold operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLegalHold for more information on using the GetLegalHold
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetLegalHoldRequest method.
//	req, resp := client.GetLegalHoldRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetLegalHold
func (c *Backup) GetLegalHoldRequest(input *GetLegalHoldInput) (req *request.Request, output *GetLegalHoldOutput) {
	op := &request.Operation{
		Name:       opGetLegalHold,
		HTTPMethod: "GET",
		HTTPPath:   "/legal-holds/{legalHoldId}/",
	}

	if input == nil {
		input = &GetLegalHoldInput{}
	}

	output = &GetLegalHoldOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLegalHold API operation for AWS Backup.
//
// This action returns details for a specified legal hold. The details are the
// body of a legal hold in JSON format, in addition to metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetLegalHold for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetLegalHold
func (c *Backup) GetLegalHold(input *GetLegalHoldInput) (*GetLegalHoldOutput, error) {
	req, out := c.GetLegalHoldRequest(input)
	return out, req.Send()
}

// GetLegalHoldWithContext is the same as GetLegalHold with the addition of
// the ability to pass a context and additional request options.
//
// See GetLegalHold for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetLegalHoldWithContext(ctx aws.Context, input *GetLegalHoldInput, opts ...request.Option) (*GetLegalHoldOutput, error) {
	req, out := c.GetLegalHoldRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecoveryPointRestoreMetadata = "GetRecoveryPointRestoreMetadata"

// GetRecoveryPointRestoreMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetRecoveryPointRestoreMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecoveryPointRestoreMetadata for more information on using the GetRecoveryPointRestoreMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRecoveryPointRestoreMetadataRequest method.
//	req, resp := client.GetRecoveryPointRestoreMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadata
func (c *Backup) GetRecoveryPointRestoreMetadataRequest(input *GetRecoveryPointRestoreMetadataInput) (req *request.Request, output *GetRecoveryPointRestoreMetadataOutput) {
	op := &request.Operation{
		Name:       opGetRecoveryPointRestoreMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}/restore-metadata",
	}

	if input == nil {
		input = &GetRecoveryPointRestoreMetadataInput{}
	}

	output = &GetRecoveryPointRestoreMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecoveryPointRestoreMetadata API operation for AWS Backup.
//
// Returns a set of metadata key-value pairs that were used to create the backup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetRecoveryPointRestoreMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRecoveryPointRestoreMetadata
func (c *Backup) GetRecoveryPointRestoreMetadata(input *GetRecoveryPointRestoreMetadataInput) (*GetRecoveryPointRestoreMetadataOutput, error) {
	req, out := c.GetRecoveryPointRestoreMetadataRequest(input)
	return out, req.Send()
}

// GetRecoveryPointRestoreMetadataWithContext is the same as GetRecoveryPointRestoreMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecoveryPointRestoreMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetRecoveryPointRestoreMetadataWithContext(ctx aws.Context, input *GetRecoveryPointRestoreMetadataInput, opts ...request.Option) (*GetRecoveryPointRestoreMetadataOutput, error) {
	req, out := c.GetRecoveryPointRestoreMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRestoreJobMetadata = "GetRestoreJobMetadata"

// GetRestoreJobMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetRestoreJobMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRestoreJobMetadata for more information on using the GetRestoreJobMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRestoreJobMetadataRequest method.
//	req, resp := client.GetRestoreJobMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreJobMetadata
func (c *Backup) GetRestoreJobMetadataRequest(input *GetRestoreJobMetadataInput) (req *request.Request, output *GetRestoreJobMetadataOutput) {
	op := &request.Operation{
		Name:       opGetRestoreJobMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-jobs/{restoreJobId}/metadata",
	}

	if input == nil {
		input = &GetRestoreJobMetadataInput{}
	}

	output = &GetRestoreJobMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRestoreJobMetadata API operation for AWS Backup.
//
// This request returns the metadata for the specified restore job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetRestoreJobMetadata for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreJobMetadata
func (c *Backup) GetRestoreJobMetadata(input *GetRestoreJobMetadataInput) (*GetRestoreJobMetadataOutput, error) {
	req, out := c.GetRestoreJobMetadataRequest(input)
	return out, req.Send()
}

// GetRestoreJobMetadataWithContext is the same as GetRestoreJobMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetRestoreJobMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetRestoreJobMetadataWithContext(ctx aws.Context, input *GetRestoreJobMetadataInput, opts ...request.Option) (*GetRestoreJobMetadataOutput, error) {
	req, out := c.GetRestoreJobMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRestoreTestingInferredMetadata = "GetRestoreTestingInferredMetadata"

// GetRestoreTestingInferredMetadataRequest generates a "aws/request.Request" representing the
// client's request for the GetRestoreTestingInferredMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRestoreTestingInferredMetadata for more information on using the GetRestoreTestingInferredMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRestoreTestingInferredMetadataRequest method.
//	req, resp := client.GetRestoreTestingInferredMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingInferredMetadata
func (c *Backup) GetRestoreTestingInferredMetadataRequest(input *GetRestoreTestingInferredMetadataInput) (req *request.Request, output *GetRestoreTestingInferredMetadataOutput) {
	op := &request.Operation{
		Name:       opGetRestoreTestingInferredMetadata,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-testing/inferred-metadata",
	}

	if input == nil {
		input = &GetRestoreTestingInferredMetadataInput{}
	}

	output = &GetRestoreTestingInferredMetadataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRestoreTestingInferredMetadata API operation for AWS Backup.
//
// This request returns the minimal required set of metadata needed to start
// a restore job with secure default settings. BackupVaultName and RecoveryPointArn
// are required parameters. BackupVaultAccountId is an optional parameter.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetRestoreTestingInferredMetadata for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingInferredMetadata
func (c *Backup) GetRestoreTestingInferredMetadata(input *GetRestoreTestingInferredMetadataInput) (*GetRestoreTestingInferredMetadataOutput, error) {
	req, out := c.GetRestoreTestingInferredMetadataRequest(input)
	return out, req.Send()
}

// GetRestoreTestingInferredMetadataWithContext is the same as GetRestoreTestingInferredMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See GetRestoreTestingInferredMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetRestoreTestingInferredMetadataWithContext(ctx aws.Context, input *GetRestoreTestingInferredMetadataInput, opts ...request.Option) (*GetRestoreTestingInferredMetadataOutput, error) {
	req, out := c.GetRestoreTestingInferredMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRestoreTestingPlan = "GetRestoreTestingPlan"

// GetRestoreTestingPlanRequest generates a "aws/request.Request" representing the
// client's request for the GetRestoreTestingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRestoreTestingPlan for more information on using the GetRestoreTestingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRestoreTestingPlanRequest method.
//	req, resp := client.GetRestoreTestingPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingPlan
func (c *Backup) GetRestoreTestingPlanRequest(input *GetRestoreTestingPlanInput) (req *request.Request, output *GetRestoreTestingPlanOutput) {
	op := &request.Operation{
		Name:       opGetRestoreTestingPlan,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-testing/plans/{RestoreTestingPlanName}",
	}

	if input == nil {
		input = &GetRestoreTestingPlanInput{}
	}

	output = &GetRestoreTestingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRestoreTestingPlan API operation for AWS Backup.
//
// Returns RestoreTestingPlan details for the specified RestoreTestingPlanName.
// The details are the body of a restore testing plan in JSON format, in addition
// to plan metadata.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetRestoreTestingPlan for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingPlan
func (c *Backup) GetRestoreTestingPlan(input *GetRestoreTestingPlanInput) (*GetRestoreTestingPlanOutput, error) {
	req, out := c.GetRestoreTestingPlanRequest(input)
	return out, req.Send()
}

// GetRestoreTestingPlanWithContext is the same as GetRestoreTestingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See GetRestoreTestingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetRestoreTestingPlanWithContext(ctx aws.Context, input *GetRestoreTestingPlanInput, opts ...request.Option) (*GetRestoreTestingPlanOutput, error) {
	req, out := c.GetRestoreTestingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRestoreTestingSelection = "GetRestoreTestingSelection"

// GetRestoreTestingSelectionRequest generates a "aws/request.Request" representing the
// client's request for the GetRestoreTestingSelection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRestoreTestingSelection for more information on using the GetRestoreTestingSelection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRestoreTestingSelectionRequest method.
//	req, resp := client.GetRestoreTestingSelectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingSelection
func (c *Backup) GetRestoreTestingSelectionRequest(input *GetRestoreTestingSelectionInput) (req *request.Request, output *GetRestoreTestingSelectionOutput) {
	op := &request.Operation{
		Name:       opGetRestoreTestingSelection,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-testing/plans/{RestoreTestingPlanName}/selections/{RestoreTestingSelectionName}",
	}

	if input == nil {
		input = &GetRestoreTestingSelectionInput{}
	}

	output = &GetRestoreTestingSelectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRestoreTestingSelection API operation for AWS Backup.
//
// Returns RestoreTestingSelection, which displays resources and elements of
// the restore testing plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetRestoreTestingSelection for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetRestoreTestingSelection
func (c *Backup) GetRestoreTestingSelection(input *GetRestoreTestingSelectionInput) (*GetRestoreTestingSelectionOutput, error) {
	req, out := c.GetRestoreTestingSelectionRequest(input)
	return out, req.Send()
}

// GetRestoreTestingSelectionWithContext is the same as GetRestoreTestingSelection with the addition of
// the ability to pass a context and additional request options.
//
// See GetRestoreTestingSelection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetRestoreTestingSelectionWithContext(ctx aws.Context, input *GetRestoreTestingSelectionInput, opts ...request.Option) (*GetRestoreTestingSelectionOutput, error) {
	req, out := c.GetRestoreTestingSelectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSupportedResourceTypes = "GetSupportedResourceTypes"

// GetSupportedResourceTypesRequest generates a "aws/request.Request" representing the
// client's request for the GetSupportedResourceTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSupportedResourceTypes for more information on using the GetSupportedResourceTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSupportedResourceTypesRequest method.
//	req, resp := client.GetSupportedResourceTypesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetSupportedResourceTypes
func (c *Backup) GetSupportedResourceTypesRequest(input *GetSupportedResourceTypesInput) (req *request.Request, output *GetSupportedResourceTypesOutput) {
	op := &request.Operation{
		Name:       opGetSupportedResourceTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/supported-resource-types",
	}

	if input == nil {
		input = &GetSupportedResourceTypesInput{}
	}

	output = &GetSupportedResourceTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSupportedResourceTypes API operation for AWS Backup.
//
// Returns the Amazon Web Services resource types supported by Backup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation GetSupportedResourceTypes for usage and error information.
//
// Returned Error Types:
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/GetSupportedResourceTypes
func (c *Backup) GetSupportedResourceTypes(input *GetSupportedResourceTypesInput) (*GetSupportedResourceTypesOutput, error) {
	req, out := c.GetSupportedResourceTypesRequest(input)
	return out, req.Send()
}

// GetSupportedResourceTypesWithContext is the same as GetSupportedResourceTypes with the addition of
// the ability to pass a context and additional request options.
//
// See GetSupportedResourceTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) GetSupportedResourceTypesWithContext(ctx aws.Context, input *GetSupportedResourceTypesInput, opts ...request.Option) (*GetSupportedResourceTypesOutput, error) {
	req, out := c.GetSupportedResourceTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListBackupJobSummaries = "ListBackupJobSummaries"

// ListBackupJobSummariesRequest generates a "aws/request.Request" representing the
// client's request for the ListBackupJobSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBackupJobSummaries for more information on using the ListBackupJobSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBackupJobSummariesRequest method.
//	req, resp := client.ListBackupJobSummariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobSummaries
func (c *Backup) ListBackupJobSummariesRequest(input *ListBackupJobSummariesInput) (req *request.Request, output *ListBackupJobSummariesOutput) {
	op := &request.Operation{
		Name:       opListBackupJobSummaries,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/backup-job-summaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBackupJobSummariesInput{}
	}

	output = &ListBackupJobSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBackupJobSummaries API operation for AWS Backup.
//
// This is a request for a summary of backup jobs created or running within
// the most recent 30 days. You can include parameters AccountID, State, ResourceType,
// MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter results.
//
// This request returns a summary that contains Region, Account, State, ResourceType,
// MessageCategory, StartTime, EndTime, and Count of included jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListBackupJobSummaries for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobSummaries
func (c *Backup) ListBackupJobSummaries(input *ListBackupJobSummariesInput) (*ListBackupJobSummariesOutput, error) {
	req, out := c.ListBackupJobSummariesRequest(input)
	return out, req.Send()
}

// ListBackupJobSummariesWithContext is the same as ListBackupJobSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See ListBackupJobSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupJobSummariesWithContext(ctx aws.Context, input *ListBackupJobSummariesInput, opts ...request.Option) (*ListBackupJobSummariesOutput, error) {
	req, out := c.ListBackupJobSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBackupJobSummariesPages iterates over the pages of a ListBackupJobSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBackupJobSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBackupJobSummaries operation.
//	pageNum := 0
//	err := client.ListBackupJobSummariesPages(params,
//	    func(page *backup.ListBackupJobSummariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListBackupJobSummariesPages(input *ListBackupJobSummariesInput, fn func(*ListBackupJobSummariesOutput, bool) bool) error {
	return c.ListBackupJobSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBackupJobSummariesPagesWithContext same as ListBackupJobSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupJobSummariesPagesWithContext(ctx aws.Context, input *ListBackupJobSummariesInput, fn func(*ListBackupJobSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBackupJobSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBackupJobSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBackupJobSummariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBackupJobs = "ListBackupJobs"

// ListBackupJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListBackupJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBackupJobs for more information on using the ListBackupJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBackupJobsRequest method.
//	req, resp := client.ListBackupJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs
func (c *Backup) ListBackupJobsRequest(input *ListBackupJobsInput) (req *request.Request, output *ListBackupJobsOutput) {
	op := &request.Operation{
		Name:       opListBackupJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-jobs/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBackupJobsInput{}
	}

	output = &ListBackupJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBackupJobs API operation for AWS Backup.
//
// Returns a list of existing backup jobs for an authenticated account for the
// last 30 days. For a longer period of time, consider using these monitoring
// tools (https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListBackupJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupJobs
func (c *Backup) ListBackupJobs(input *ListBackupJobsInput) (*ListBackupJobsOutput, error) {
	req, out := c.ListBackupJobsRequest(input)
	return out, req.Send()
}

// ListBackupJobsWithContext is the same as ListBackupJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListBackupJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupJobsWithContext(ctx aws.Context, input *ListBackupJobsInput, opts ...request.Option) (*ListBackupJobsOutput, error) {
	req, out := c.ListBackupJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBackupJobsPages iterates over the pages of a ListBackupJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBackupJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBackupJobs operation.
//	pageNum := 0
//	err := client.ListBackupJobsPages(params,
//	    func(page *backup.ListBackupJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListBackupJobsPages(input *ListBackupJobsInput, fn func(*ListBackupJobsOutput, bool) bool) error {
	return c.ListBackupJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBackupJobsPagesWithContext same as ListBackupJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupJobsPagesWithContext(ctx aws.Context, input *ListBackupJobsInput, fn func(*ListBackupJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBackupJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBackupJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBackupJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBackupPlanTemplates = "ListBackupPlanTemplates"

// ListBackupPlanTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListBackupPlanTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBackupPlanTemplates for more information on using the ListBackupPlanTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBackupPlanTemplatesRequest method.
//	req, resp := client.ListBackupPlanTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates
func (c *Backup) ListBackupPlanTemplatesRequest(input *ListBackupPlanTemplatesInput) (req *request.Request, output *ListBackupPlanTemplatesOutput) {
	op := &request.Operation{
		Name:       opListBackupPlanTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/backup/template/plans",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBackupPlanTemplatesInput{}
	}

	output = &ListBackupPlanTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBackupPlanTemplates API operation for AWS Backup.
//
// Returns metadata of your saved backup plan templates, including the template
// ID, name, and the creation and deletion dates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListBackupPlanTemplates for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanTemplates
func (c *Backup) ListBackupPlanTemplates(input *ListBackupPlanTemplatesInput) (*ListBackupPlanTemplatesOutput, error) {
	req, out := c.ListBackupPlanTemplatesRequest(input)
	return out, req.Send()
}

// ListBackupPlanTemplatesWithContext is the same as ListBackupPlanTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListBackupPlanTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupPlanTemplatesWithContext(ctx aws.Context, input *ListBackupPlanTemplatesInput, opts ...request.Option) (*ListBackupPlanTemplatesOutput, error) {
	req, out := c.ListBackupPlanTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBackupPlanTemplatesPages iterates over the pages of a ListBackupPlanTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBackupPlanTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBackupPlanTemplates operation.
//	pageNum := 0
//	err := client.ListBackupPlanTemplatesPages(params,
//	    func(page *backup.ListBackupPlanTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListBackupPlanTemplatesPages(input *ListBackupPlanTemplatesInput, fn func(*ListBackupPlanTemplatesOutput, bool) bool) error {
	return c.ListBackupPlanTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBackupPlanTemplatesPagesWithContext same as ListBackupPlanTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupPlanTemplatesPagesWithContext(ctx aws.Context, input *ListBackupPlanTemplatesInput, fn func(*ListBackupPlanTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBackupPlanTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBackupPlanTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBackupPlanTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBackupPlanVersions = "ListBackupPlanVersions"

// ListBackupPlanVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListBackupPlanVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBackupPlanVersions for more information on using the ListBackupPlanVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBackupPlanVersionsRequest method.
//	req, resp := client.ListBackupPlanVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions
func (c *Backup) ListBackupPlanVersionsRequest(input *ListBackupPlanVersionsInput) (req *request.Request, output *ListBackupPlanVersionsOutput) {
	op := &request.Operation{
		Name:       opListBackupPlanVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/backup/plans/{backupPlanId}/versions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBackupPlanVersionsInput{}
	}

	output = &ListBackupPlanVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBackupPlanVersions API operation for AWS Backup.
//
// Returns version metadata of your backup plans, including Amazon Resource
// Names (ARNs), backup plan IDs, creation and deletion dates, plan names, and
// version IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListBackupPlanVersions for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlanVersions
func (c *Backup) ListBackupPlanVersions(input *ListBackupPlanVersionsInput) (*ListBackupPlanVersionsOutput, error) {
	req, out := c.ListBackupPlanVersionsRequest(input)
	return out, req.Send()
}

// ListBackupPlanVersionsWithContext is the same as ListBackupPlanVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListBackupPlanVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupPlanVersionsWithContext(ctx aws.Context, input *ListBackupPlanVersionsInput, opts ...request.Option) (*ListBackupPlanVersionsOutput, error) {
	req, out := c.ListBackupPlanVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBackupPlanVersionsPages iterates over the pages of a ListBackupPlanVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBackupPlanVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBackupPlanVersions operation.
//	pageNum := 0
//	err := client.ListBackupPlanVersionsPages(params,
//	    func(page *backup.ListBackupPlanVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListBackupPlanVersionsPages(input *ListBackupPlanVersionsInput, fn func(*ListBackupPlanVersionsOutput, bool) bool) error {
	return c.ListBackupPlanVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBackupPlanVersionsPagesWithContext same as ListBackupPlanVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupPlanVersionsPagesWithContext(ctx aws.Context, input *ListBackupPlanVersionsInput, fn func(*ListBackupPlanVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBackupPlanVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBackupPlanVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBackupPlanVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBackupPlans = "ListBackupPlans"

// ListBackupPlansRequest generates a "aws/request.Request" representing the
// client's request for the ListBackupPlans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBackupPlans for more information on using the ListBackupPlans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBackupPlansRequest method.
//	req, resp := client.ListBackupPlansRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans
func (c *Backup) ListBackupPlansRequest(input *ListBackupPlansInput) (req *request.Request, output *ListBackupPlansOutput) {
	op := &request.Operation{
		Name:       opListBackupPlans,
		HTTPMethod: "GET",
		HTTPPath:   "/backup/plans/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBackupPlansInput{}
	}

	output = &ListBackupPlansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBackupPlans API operation for AWS Backup.
//
// Returns a list of all active backup plans for an authenticated account. The
// list contains information such as Amazon Resource Names (ARNs), plan IDs,
// creation and deletion dates, version IDs, plan names, and creator request
// IDs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListBackupPlans for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupPlans
func (c *Backup) ListBackupPlans(input *ListBackupPlansInput) (*ListBackupPlansOutput, error) {
	req, out := c.ListBackupPlansRequest(input)
	return out, req.Send()
}

// ListBackupPlansWithContext is the same as ListBackupPlans with the addition of
// the ability to pass a context and additional request options.
//
// See ListBackupPlans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupPlansWithContext(ctx aws.Context, input *ListBackupPlansInput, opts ...request.Option) (*ListBackupPlansOutput, error) {
	req, out := c.ListBackupPlansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBackupPlansPages iterates over the pages of a ListBackupPlans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBackupPlans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBackupPlans operation.
//	pageNum := 0
//	err := client.ListBackupPlansPages(params,
//	    func(page *backup.ListBackupPlansOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListBackupPlansPages(input *ListBackupPlansInput, fn func(*ListBackupPlansOutput, bool) bool) error {
	return c.ListBackupPlansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBackupPlansPagesWithContext same as ListBackupPlansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupPlansPagesWithContext(ctx aws.Context, input *ListBackupPlansInput, fn func(*ListBackupPlansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBackupPlansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBackupPlansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBackupPlansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBackupSelections = "ListBackupSelections"

// ListBackupSelectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListBackupSelections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBackupSelections for more information on using the ListBackupSelections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBackupSelectionsRequest method.
//	req, resp := client.ListBackupSelectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections
func (c *Backup) ListBackupSelectionsRequest(input *ListBackupSelectionsInput) (req *request.Request, output *ListBackupSelectionsOutput) {
	op := &request.Operation{
		Name:       opListBackupSelections,
		HTTPMethod: "GET",
		HTTPPath:   "/backup/plans/{backupPlanId}/selections/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBackupSelectionsInput{}
	}

	output = &ListBackupSelectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBackupSelections API operation for AWS Backup.
//
// Returns an array containing metadata of the resources associated with the
// target backup plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListBackupSelections for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupSelections
func (c *Backup) ListBackupSelections(input *ListBackupSelectionsInput) (*ListBackupSelectionsOutput, error) {
	req, out := c.ListBackupSelectionsRequest(input)
	return out, req.Send()
}

// ListBackupSelectionsWithContext is the same as ListBackupSelections with the addition of
// the ability to pass a context and additional request options.
//
// See ListBackupSelections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupSelectionsWithContext(ctx aws.Context, input *ListBackupSelectionsInput, opts ...request.Option) (*ListBackupSelectionsOutput, error) {
	req, out := c.ListBackupSelectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBackupSelectionsPages iterates over the pages of a ListBackupSelections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBackupSelections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBackupSelections operation.
//	pageNum := 0
//	err := client.ListBackupSelectionsPages(params,
//	    func(page *backup.ListBackupSelectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListBackupSelectionsPages(input *ListBackupSelectionsInput, fn func(*ListBackupSelectionsOutput, bool) bool) error {
	return c.ListBackupSelectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBackupSelectionsPagesWithContext same as ListBackupSelectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupSelectionsPagesWithContext(ctx aws.Context, input *ListBackupSelectionsInput, fn func(*ListBackupSelectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBackupSelectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBackupSelectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBackupSelectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBackupVaults = "ListBackupVaults"

// ListBackupVaultsRequest generates a "aws/request.Request" representing the
// client's request for the ListBackupVaults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBackupVaults for more information on using the ListBackupVaults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBackupVaultsRequest method.
//	req, resp := client.ListBackupVaultsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults
func (c *Backup) ListBackupVaultsRequest(input *ListBackupVaultsInput) (req *request.Request, output *ListBackupVaultsOutput) {
	op := &request.Operation{
		Name:       opListBackupVaults,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-vaults/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBackupVaultsInput{}
	}

	output = &ListBackupVaultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBackupVaults API operation for AWS Backup.
//
// Returns a list of recovery point storage containers along with information
// about them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListBackupVaults for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListBackupVaults
func (c *Backup) ListBackupVaults(input *ListBackupVaultsInput) (*ListBackupVaultsOutput, error) {
	req, out := c.ListBackupVaultsRequest(input)
	return out, req.Send()
}

// ListBackupVaultsWithContext is the same as ListBackupVaults with the addition of
// the ability to pass a context and additional request options.
//
// See ListBackupVaults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupVaultsWithContext(ctx aws.Context, input *ListBackupVaultsInput, opts ...request.Option) (*ListBackupVaultsOutput, error) {
	req, out := c.ListBackupVaultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBackupVaultsPages iterates over the pages of a ListBackupVaults operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBackupVaults method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBackupVaults operation.
//	pageNum := 0
//	err := client.ListBackupVaultsPages(params,
//	    func(page *backup.ListBackupVaultsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListBackupVaultsPages(input *ListBackupVaultsInput, fn func(*ListBackupVaultsOutput, bool) bool) error {
	return c.ListBackupVaultsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBackupVaultsPagesWithContext same as ListBackupVaultsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListBackupVaultsPagesWithContext(ctx aws.Context, input *ListBackupVaultsInput, fn func(*ListBackupVaultsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBackupVaultsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBackupVaultsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBackupVaultsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCopyJobSummaries = "ListCopyJobSummaries"

// ListCopyJobSummariesRequest generates a "aws/request.Request" representing the
// client's request for the ListCopyJobSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCopyJobSummaries for more information on using the ListCopyJobSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCopyJobSummariesRequest method.
//	req, resp := client.ListCopyJobSummariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobSummaries
func (c *Backup) ListCopyJobSummariesRequest(input *ListCopyJobSummariesInput) (req *request.Request, output *ListCopyJobSummariesOutput) {
	op := &request.Operation{
		Name:       opListCopyJobSummaries,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/copy-job-summaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCopyJobSummariesInput{}
	}

	output = &ListCopyJobSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCopyJobSummaries API operation for AWS Backup.
//
// This request obtains a list of copy jobs created or running within the the
// most recent 30 days. You can include parameters AccountID, State, ResourceType,
// MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter results.
//
// This request returns a summary that contains Region, Account, State, RestourceType,
// MessageCategory, StartTime, EndTime, and Count of included jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListCopyJobSummaries for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobSummaries
func (c *Backup) ListCopyJobSummaries(input *ListCopyJobSummariesInput) (*ListCopyJobSummariesOutput, error) {
	req, out := c.ListCopyJobSummariesRequest(input)
	return out, req.Send()
}

// ListCopyJobSummariesWithContext is the same as ListCopyJobSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See ListCopyJobSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListCopyJobSummariesWithContext(ctx aws.Context, input *ListCopyJobSummariesInput, opts ...request.Option) (*ListCopyJobSummariesOutput, error) {
	req, out := c.ListCopyJobSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCopyJobSummariesPages iterates over the pages of a ListCopyJobSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCopyJobSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCopyJobSummaries operation.
//	pageNum := 0
//	err := client.ListCopyJobSummariesPages(params,
//	    func(page *backup.ListCopyJobSummariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListCopyJobSummariesPages(input *ListCopyJobSummariesInput, fn func(*ListCopyJobSummariesOutput, bool) bool) error {
	return c.ListCopyJobSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCopyJobSummariesPagesWithContext same as ListCopyJobSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListCopyJobSummariesPagesWithContext(ctx aws.Context, input *ListCopyJobSummariesInput, fn func(*ListCopyJobSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCopyJobSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCopyJobSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCopyJobSummariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListCopyJobs = "ListCopyJobs"

// ListCopyJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListCopyJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCopyJobs for more information on using the ListCopyJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCopyJobsRequest method.
//	req, resp := client.ListCopyJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobs
func (c *Backup) ListCopyJobsRequest(input *ListCopyJobsInput) (req *request.Request, output *ListCopyJobsOutput) {
	op := &request.Operation{
		Name:       opListCopyJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/copy-jobs/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCopyJobsInput{}
	}

	output = &ListCopyJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCopyJobs API operation for AWS Backup.
//
// Returns metadata about your copy jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListCopyJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListCopyJobs
func (c *Backup) ListCopyJobs(input *ListCopyJobsInput) (*ListCopyJobsOutput, error) {
	req, out := c.ListCopyJobsRequest(input)
	return out, req.Send()
}

// ListCopyJobsWithContext is the same as ListCopyJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListCopyJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListCopyJobsWithContext(ctx aws.Context, input *ListCopyJobsInput, opts ...request.Option) (*ListCopyJobsOutput, error) {
	req, out := c.ListCopyJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCopyJobsPages iterates over the pages of a ListCopyJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCopyJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCopyJobs operation.
//	pageNum := 0
//	err := client.ListCopyJobsPages(params,
//	    func(page *backup.ListCopyJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListCopyJobsPages(input *ListCopyJobsInput, fn func(*ListCopyJobsOutput, bool) bool) error {
	return c.ListCopyJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCopyJobsPagesWithContext same as ListCopyJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListCopyJobsPagesWithContext(ctx aws.Context, input *ListCopyJobsInput, fn func(*ListCopyJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCopyJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCopyJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCopyJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFrameworks = "ListFrameworks"

// ListFrameworksRequest generates a "aws/request.Request" representing the
// client's request for the ListFrameworks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFrameworks for more information on using the ListFrameworks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListFrameworksRequest method.
//	req, resp := client.ListFrameworksRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListFrameworks
func (c *Backup) ListFrameworksRequest(input *ListFrameworksInput) (req *request.Request, output *ListFrameworksOutput) {
	op := &request.Operation{
		Name:       opListFrameworks,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/frameworks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFrameworksInput{}
	}

	output = &ListFrameworksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFrameworks API operation for AWS Backup.
//
// Returns a list of all frameworks for an Amazon Web Services account and Amazon
// Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListFrameworks for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListFrameworks
func (c *Backup) ListFrameworks(input *ListFrameworksInput) (*ListFrameworksOutput, error) {
	req, out := c.ListFrameworksRequest(input)
	return out, req.Send()
}

// ListFrameworksWithContext is the same as ListFrameworks with the addition of
// the ability to pass a context and additional request options.
//
// See ListFrameworks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListFrameworksWithContext(ctx aws.Context, input *ListFrameworksInput, opts ...request.Option) (*ListFrameworksOutput, error) {
	req, out := c.ListFrameworksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFrameworksPages iterates over the pages of a ListFrameworks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFrameworks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListFrameworks operation.
//	pageNum := 0
//	err := client.ListFrameworksPages(params,
//	    func(page *backup.ListFrameworksOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListFrameworksPages(input *ListFrameworksInput, fn func(*ListFrameworksOutput, bool) bool) error {
	return c.ListFrameworksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFrameworksPagesWithContext same as ListFrameworksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListFrameworksPagesWithContext(ctx aws.Context, input *ListFrameworksInput, fn func(*ListFrameworksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFrameworksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFrameworksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFrameworksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLegalHolds = "ListLegalHolds"

// ListLegalHoldsRequest generates a "aws/request.Request" representing the
// client's request for the ListLegalHolds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLegalHolds for more information on using the ListLegalHolds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLegalHoldsRequest method.
//	req, resp := client.ListLegalHoldsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListLegalHolds
func (c *Backup) ListLegalHoldsRequest(input *ListLegalHoldsInput) (req *request.Request, output *ListLegalHoldsOutput) {
	op := &request.Operation{
		Name:       opListLegalHolds,
		HTTPMethod: "GET",
		HTTPPath:   "/legal-holds/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLegalHoldsInput{}
	}

	output = &ListLegalHoldsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLegalHolds API operation for AWS Backup.
//
// This action returns metadata about active and previous legal holds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListLegalHolds for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListLegalHolds
func (c *Backup) ListLegalHolds(input *ListLegalHoldsInput) (*ListLegalHoldsOutput, error) {
	req, out := c.ListLegalHoldsRequest(input)
	return out, req.Send()
}

// ListLegalHoldsWithContext is the same as ListLegalHolds with the addition of
// the ability to pass a context and additional request options.
//
// See ListLegalHolds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListLegalHoldsWithContext(ctx aws.Context, input *ListLegalHoldsInput, opts ...request.Option) (*ListLegalHoldsOutput, error) {
	req, out := c.ListLegalHoldsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLegalHoldsPages iterates over the pages of a ListLegalHolds operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLegalHolds method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLegalHolds operation.
//	pageNum := 0
//	err := client.ListLegalHoldsPages(params,
//	    func(page *backup.ListLegalHoldsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListLegalHoldsPages(input *ListLegalHoldsInput, fn func(*ListLegalHoldsOutput, bool) bool) error {
	return c.ListLegalHoldsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLegalHoldsPagesWithContext same as ListLegalHoldsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListLegalHoldsPagesWithContext(ctx aws.Context, input *ListLegalHoldsInput, fn func(*ListLegalHoldsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLegalHoldsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLegalHoldsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLegalHoldsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProtectedResources = "ListProtectedResources"

// ListProtectedResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListProtectedResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProtectedResources for more information on using the ListProtectedResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProtectedResourcesRequest method.
//	req, resp := client.ListProtectedResourcesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources
func (c *Backup) ListProtectedResourcesRequest(input *ListProtectedResourcesInput) (req *request.Request, output *ListProtectedResourcesOutput) {
	op := &request.Operation{
		Name:       opListProtectedResources,
		HTTPMethod: "GET",
		HTTPPath:   "/resources/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProtectedResourcesInput{}
	}

	output = &ListProtectedResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProtectedResources API operation for AWS Backup.
//
// Returns an array of resources successfully backed up by Backup, including
// the time the resource was saved, an Amazon Resource Name (ARN) of the resource,
// and a resource type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListProtectedResources for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResources
func (c *Backup) ListProtectedResources(input *ListProtectedResourcesInput) (*ListProtectedResourcesOutput, error) {
	req, out := c.ListProtectedResourcesRequest(input)
	return out, req.Send()
}

// ListProtectedResourcesWithContext is the same as ListProtectedResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListProtectedResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListProtectedResourcesWithContext(ctx aws.Context, input *ListProtectedResourcesInput, opts ...request.Option) (*ListProtectedResourcesOutput, error) {
	req, out := c.ListProtectedResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProtectedResourcesPages iterates over the pages of a ListProtectedResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProtectedResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProtectedResources operation.
//	pageNum := 0
//	err := client.ListProtectedResourcesPages(params,
//	    func(page *backup.ListProtectedResourcesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListProtectedResourcesPages(input *ListProtectedResourcesInput, fn func(*ListProtectedResourcesOutput, bool) bool) error {
	return c.ListProtectedResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProtectedResourcesPagesWithContext same as ListProtectedResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListProtectedResourcesPagesWithContext(ctx aws.Context, input *ListProtectedResourcesInput, fn func(*ListProtectedResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProtectedResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProtectedResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProtectedResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProtectedResourcesByBackupVault = "ListProtectedResourcesByBackupVault"

// ListProtectedResourcesByBackupVaultRequest generates a "aws/request.Request" representing the
// client's request for the ListProtectedResourcesByBackupVault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProtectedResourcesByBackupVault for more information on using the ListProtectedResourcesByBackupVault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProtectedResourcesByBackupVaultRequest method.
//	req, resp := client.ListProtectedResourcesByBackupVaultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResourcesByBackupVault
func (c *Backup) ListProtectedResourcesByBackupVaultRequest(input *ListProtectedResourcesByBackupVaultInput) (req *request.Request, output *ListProtectedResourcesByBackupVaultOutput) {
	op := &request.Operation{
		Name:       opListProtectedResourcesByBackupVault,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-vaults/{backupVaultName}/resources/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProtectedResourcesByBackupVaultInput{}
	}

	output = &ListProtectedResourcesByBackupVaultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProtectedResourcesByBackupVault API operation for AWS Backup.
//
// This request lists the protected resources corresponding to each backup vault.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListProtectedResourcesByBackupVault for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListProtectedResourcesByBackupVault
func (c *Backup) ListProtectedResourcesByBackupVault(input *ListProtectedResourcesByBackupVaultInput) (*ListProtectedResourcesByBackupVaultOutput, error) {
	req, out := c.ListProtectedResourcesByBackupVaultRequest(input)
	return out, req.Send()
}

// ListProtectedResourcesByBackupVaultWithContext is the same as ListProtectedResourcesByBackupVault with the addition of
// the ability to pass a context and additional request options.
//
// See ListProtectedResourcesByBackupVault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListProtectedResourcesByBackupVaultWithContext(ctx aws.Context, input *ListProtectedResourcesByBackupVaultInput, opts ...request.Option) (*ListProtectedResourcesByBackupVaultOutput, error) {
	req, out := c.ListProtectedResourcesByBackupVaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProtectedResourcesByBackupVaultPages iterates over the pages of a ListProtectedResourcesByBackupVault operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProtectedResourcesByBackupVault method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProtectedResourcesByBackupVault operation.
//	pageNum := 0
//	err := client.ListProtectedResourcesByBackupVaultPages(params,
//	    func(page *backup.ListProtectedResourcesByBackupVaultOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListProtectedResourcesByBackupVaultPages(input *ListProtectedResourcesByBackupVaultInput, fn func(*ListProtectedResourcesByBackupVaultOutput, bool) bool) error {
	return c.ListProtectedResourcesByBackupVaultPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProtectedResourcesByBackupVaultPagesWithContext same as ListProtectedResourcesByBackupVaultPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListProtectedResourcesByBackupVaultPagesWithContext(ctx aws.Context, input *ListProtectedResourcesByBackupVaultInput, fn func(*ListProtectedResourcesByBackupVaultOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProtectedResourcesByBackupVaultInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProtectedResourcesByBackupVaultRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProtectedResourcesByBackupVaultOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecoveryPointsByBackupVault = "ListRecoveryPointsByBackupVault"

// ListRecoveryPointsByBackupVaultRequest generates a "aws/request.Request" representing the
// client's request for the ListRecoveryPointsByBackupVault operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecoveryPointsByBackupVault for more information on using the ListRecoveryPointsByBackupVault
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecoveryPointsByBackupVaultRequest method.
//	req, resp := client.ListRecoveryPointsByBackupVaultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault
func (c *Backup) ListRecoveryPointsByBackupVaultRequest(input *ListRecoveryPointsByBackupVaultInput) (req *request.Request, output *ListRecoveryPointsByBackupVaultOutput) {
	op := &request.Operation{
		Name:       opListRecoveryPointsByBackupVault,
		HTTPMethod: "GET",
		HTTPPath:   "/backup-vaults/{backupVaultName}/recovery-points/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecoveryPointsByBackupVaultInput{}
	}

	output = &ListRecoveryPointsByBackupVaultOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecoveryPointsByBackupVault API operation for AWS Backup.
//
// Returns detailed information about the recovery points stored in a backup
// vault.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListRecoveryPointsByBackupVault for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByBackupVault
func (c *Backup) ListRecoveryPointsByBackupVault(input *ListRecoveryPointsByBackupVaultInput) (*ListRecoveryPointsByBackupVaultOutput, error) {
	req, out := c.ListRecoveryPointsByBackupVaultRequest(input)
	return out, req.Send()
}

// ListRecoveryPointsByBackupVaultWithContext is the same as ListRecoveryPointsByBackupVault with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecoveryPointsByBackupVault for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRecoveryPointsByBackupVaultWithContext(ctx aws.Context, input *ListRecoveryPointsByBackupVaultInput, opts ...request.Option) (*ListRecoveryPointsByBackupVaultOutput, error) {
	req, out := c.ListRecoveryPointsByBackupVaultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecoveryPointsByBackupVaultPages iterates over the pages of a ListRecoveryPointsByBackupVault operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecoveryPointsByBackupVault method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecoveryPointsByBackupVault operation.
//	pageNum := 0
//	err := client.ListRecoveryPointsByBackupVaultPages(params,
//	    func(page *backup.ListRecoveryPointsByBackupVaultOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListRecoveryPointsByBackupVaultPages(input *ListRecoveryPointsByBackupVaultInput, fn func(*ListRecoveryPointsByBackupVaultOutput, bool) bool) error {
	return c.ListRecoveryPointsByBackupVaultPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecoveryPointsByBackupVaultPagesWithContext same as ListRecoveryPointsByBackupVaultPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRecoveryPointsByBackupVaultPagesWithContext(ctx aws.Context, input *ListRecoveryPointsByBackupVaultInput, fn func(*ListRecoveryPointsByBackupVaultOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecoveryPointsByBackupVaultInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecoveryPointsByBackupVaultRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecoveryPointsByBackupVaultOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecoveryPointsByLegalHold = "ListRecoveryPointsByLegalHold"

// ListRecoveryPointsByLegalHoldRequest generates a "aws/request.Request" representing the
// client's request for the ListRecoveryPointsByLegalHold operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecoveryPointsByLegalHold for more information on using the ListRecoveryPointsByLegalHold
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecoveryPointsByLegalHoldRequest method.
//	req, resp := client.ListRecoveryPointsByLegalHoldRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByLegalHold
func (c *Backup) ListRecoveryPointsByLegalHoldRequest(input *ListRecoveryPointsByLegalHoldInput) (req *request.Request, output *ListRecoveryPointsByLegalHoldOutput) {
	op := &request.Operation{
		Name:       opListRecoveryPointsByLegalHold,
		HTTPMethod: "GET",
		HTTPPath:   "/legal-holds/{legalHoldId}/recovery-points",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecoveryPointsByLegalHoldInput{}
	}

	output = &ListRecoveryPointsByLegalHoldOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecoveryPointsByLegalHold API operation for AWS Backup.
//
// This action returns recovery point ARNs (Amazon Resource Names) of the specified
// legal hold.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListRecoveryPointsByLegalHold for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByLegalHold
func (c *Backup) ListRecoveryPointsByLegalHold(input *ListRecoveryPointsByLegalHoldInput) (*ListRecoveryPointsByLegalHoldOutput, error) {
	req, out := c.ListRecoveryPointsByLegalHoldRequest(input)
	return out, req.Send()
}

// ListRecoveryPointsByLegalHoldWithContext is the same as ListRecoveryPointsByLegalHold with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecoveryPointsByLegalHold for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRecoveryPointsByLegalHoldWithContext(ctx aws.Context, input *ListRecoveryPointsByLegalHoldInput, opts ...request.Option) (*ListRecoveryPointsByLegalHoldOutput, error) {
	req, out := c.ListRecoveryPointsByLegalHoldRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecoveryPointsByLegalHoldPages iterates over the pages of a ListRecoveryPointsByLegalHold operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecoveryPointsByLegalHold method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecoveryPointsByLegalHold operation.
//	pageNum := 0
//	err := client.ListRecoveryPointsByLegalHoldPages(params,
//	    func(page *backup.ListRecoveryPointsByLegalHoldOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListRecoveryPointsByLegalHoldPages(input *ListRecoveryPointsByLegalHoldInput, fn func(*ListRecoveryPointsByLegalHoldOutput, bool) bool) error {
	return c.ListRecoveryPointsByLegalHoldPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecoveryPointsByLegalHoldPagesWithContext same as ListRecoveryPointsByLegalHoldPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRecoveryPointsByLegalHoldPagesWithContext(ctx aws.Context, input *ListRecoveryPointsByLegalHoldInput, fn func(*ListRecoveryPointsByLegalHoldOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecoveryPointsByLegalHoldInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecoveryPointsByLegalHoldRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecoveryPointsByLegalHoldOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecoveryPointsByResource = "ListRecoveryPointsByResource"

// ListRecoveryPointsByResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListRecoveryPointsByResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecoveryPointsByResource for more information on using the ListRecoveryPointsByResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecoveryPointsByResourceRequest method.
//	req, resp := client.ListRecoveryPointsByResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource
func (c *Backup) ListRecoveryPointsByResourceRequest(input *ListRecoveryPointsByResourceInput) (req *request.Request, output *ListRecoveryPointsByResourceOutput) {
	op := &request.Operation{
		Name:       opListRecoveryPointsByResource,
		HTTPMethod: "GET",
		HTTPPath:   "/resources/{resourceArn}/recovery-points/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecoveryPointsByResourceInput{}
	}

	output = &ListRecoveryPointsByResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecoveryPointsByResource API operation for AWS Backup.
//
// Returns detailed information about all the recovery points of the type specified
// by a resource Amazon Resource Name (ARN).
//
// For Amazon EFS and Amazon EC2, this action only lists recovery points created
// by Backup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListRecoveryPointsByResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRecoveryPointsByResource
func (c *Backup) ListRecoveryPointsByResource(input *ListRecoveryPointsByResourceInput) (*ListRecoveryPointsByResourceOutput, error) {
	req, out := c.ListRecoveryPointsByResourceRequest(input)
	return out, req.Send()
}

// ListRecoveryPointsByResourceWithContext is the same as ListRecoveryPointsByResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecoveryPointsByResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRecoveryPointsByResourceWithContext(ctx aws.Context, input *ListRecoveryPointsByResourceInput, opts ...request.Option) (*ListRecoveryPointsByResourceOutput, error) {
	req, out := c.ListRecoveryPointsByResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecoveryPointsByResourcePages iterates over the pages of a ListRecoveryPointsByResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecoveryPointsByResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecoveryPointsByResource operation.
//	pageNum := 0
//	err := client.ListRecoveryPointsByResourcePages(params,
//	    func(page *backup.ListRecoveryPointsByResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListRecoveryPointsByResourcePages(input *ListRecoveryPointsByResourceInput, fn func(*ListRecoveryPointsByResourceOutput, bool) bool) error {
	return c.ListRecoveryPointsByResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecoveryPointsByResourcePagesWithContext same as ListRecoveryPointsByResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRecoveryPointsByResourcePagesWithContext(ctx aws.Context, input *ListRecoveryPointsByResourceInput, fn func(*ListRecoveryPointsByResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecoveryPointsByResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecoveryPointsByResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecoveryPointsByResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReportJobs = "ListReportJobs"

// ListReportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListReportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReportJobs for more information on using the ListReportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReportJobsRequest method.
//	req, resp := client.ListReportJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportJobs
func (c *Backup) ListReportJobsRequest(input *ListReportJobsInput) (req *request.Request, output *ListReportJobsOutput) {
	op := &request.Operation{
		Name:       opListReportJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/report-jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReportJobsInput{}
	}

	output = &ListReportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReportJobs API operation for AWS Backup.
//
// Returns details about your report jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListReportJobs for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportJobs
func (c *Backup) ListReportJobs(input *ListReportJobsInput) (*ListReportJobsOutput, error) {
	req, out := c.ListReportJobsRequest(input)
	return out, req.Send()
}

// ListReportJobsWithContext is the same as ListReportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListReportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListReportJobsWithContext(ctx aws.Context, input *ListReportJobsInput, opts ...request.Option) (*ListReportJobsOutput, error) {
	req, out := c.ListReportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReportJobsPages iterates over the pages of a ListReportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReportJobs operation.
//	pageNum := 0
//	err := client.ListReportJobsPages(params,
//	    func(page *backup.ListReportJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListReportJobsPages(input *ListReportJobsInput, fn func(*ListReportJobsOutput, bool) bool) error {
	return c.ListReportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReportJobsPagesWithContext same as ListReportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListReportJobsPagesWithContext(ctx aws.Context, input *ListReportJobsInput, fn func(*ListReportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListReportPlans = "ListReportPlans"

// ListReportPlansRequest generates a "aws/request.Request" representing the
// client's request for the ListReportPlans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListReportPlans for more information on using the ListReportPlans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListReportPlansRequest method.
//	req, resp := client.ListReportPlansRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportPlans
func (c *Backup) ListReportPlansRequest(input *ListReportPlansInput) (req *request.Request, output *ListReportPlansOutput) {
	op := &request.Operation{
		Name:       opListReportPlans,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/report-plans",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListReportPlansInput{}
	}

	output = &ListReportPlansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListReportPlans API operation for AWS Backup.
//
// Returns a list of your report plans. For detailed information about a single
// report plan, use DescribeReportPlan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListReportPlans for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListReportPlans
func (c *Backup) ListReportPlans(input *ListReportPlansInput) (*ListReportPlansOutput, error) {
	req, out := c.ListReportPlansRequest(input)
	return out, req.Send()
}

// ListReportPlansWithContext is the same as ListReportPlans with the addition of
// the ability to pass a context and additional request options.
//
// See ListReportPlans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListReportPlansWithContext(ctx aws.Context, input *ListReportPlansInput, opts ...request.Option) (*ListReportPlansOutput, error) {
	req, out := c.ListReportPlansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListReportPlansPages iterates over the pages of a ListReportPlans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListReportPlans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListReportPlans operation.
//	pageNum := 0
//	err := client.ListReportPlansPages(params,
//	    func(page *backup.ListReportPlansOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListReportPlansPages(input *ListReportPlansInput, fn func(*ListReportPlansOutput, bool) bool) error {
	return c.ListReportPlansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListReportPlansPagesWithContext same as ListReportPlansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListReportPlansPagesWithContext(ctx aws.Context, input *ListReportPlansInput, fn func(*ListReportPlansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListReportPlansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListReportPlansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListReportPlansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRestoreJobSummaries = "ListRestoreJobSummaries"

// ListRestoreJobSummariesRequest generates a "aws/request.Request" representing the
// client's request for the ListRestoreJobSummaries operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRestoreJobSummaries for more information on using the ListRestoreJobSummaries
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRestoreJobSummariesRequest method.
//	req, resp := client.ListRestoreJobSummariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobSummaries
func (c *Backup) ListRestoreJobSummariesRequest(input *ListRestoreJobSummariesInput) (req *request.Request, output *ListRestoreJobSummariesOutput) {
	op := &request.Operation{
		Name:       opListRestoreJobSummaries,
		HTTPMethod: "GET",
		HTTPPath:   "/audit/restore-job-summaries",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRestoreJobSummariesInput{}
	}

	output = &ListRestoreJobSummariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRestoreJobSummaries API operation for AWS Backup.
//
// This request obtains a summary of restore jobs created or running within
// the the most recent 30 days. You can include parameters AccountID, State,
// ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
//
// This request returns a summary that contains Region, Account, State, RestourceType,
// MessageCategory, StartTime, EndTime, and Count of included jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListRestoreJobSummaries for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobSummaries
func (c *Backup) ListRestoreJobSummaries(input *ListRestoreJobSummariesInput) (*ListRestoreJobSummariesOutput, error) {
	req, out := c.ListRestoreJobSummariesRequest(input)
	return out, req.Send()
}

// ListRestoreJobSummariesWithContext is the same as ListRestoreJobSummaries with the addition of
// the ability to pass a context and additional request options.
//
// See ListRestoreJobSummaries for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRestoreJobSummariesWithContext(ctx aws.Context, input *ListRestoreJobSummariesInput, opts ...request.Option) (*ListRestoreJobSummariesOutput, error) {
	req, out := c.ListRestoreJobSummariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRestoreJobSummariesPages iterates over the pages of a ListRestoreJobSummaries operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRestoreJobSummaries method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRestoreJobSummaries operation.
//	pageNum := 0
//	err := client.ListRestoreJobSummariesPages(params,
//	    func(page *backup.ListRestoreJobSummariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListRestoreJobSummariesPages(input *ListRestoreJobSummariesInput, fn func(*ListRestoreJobSummariesOutput, bool) bool) error {
	return c.ListRestoreJobSummariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRestoreJobSummariesPagesWithContext same as ListRestoreJobSummariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRestoreJobSummariesPagesWithContext(ctx aws.Context, input *ListRestoreJobSummariesInput, fn func(*ListRestoreJobSummariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRestoreJobSummariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRestoreJobSummariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRestoreJobSummariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRestoreJobs = "ListRestoreJobs"

// ListRestoreJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListRestoreJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRestoreJobs for more information on using the ListRestoreJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRestoreJobsRequest method.
//	req, resp := client.ListRestoreJobsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs
func (c *Backup) ListRestoreJobsRequest(input *ListRestoreJobsInput) (req *request.Request, output *ListRestoreJobsOutput) {
	op := &request.Operation{
		Name:       opListRestoreJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-jobs/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRestoreJobsInput{}
	}

	output = &ListRestoreJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRestoreJobs API operation for AWS Backup.
//
// Returns a list of jobs that Backup initiated to restore a saved resource,
// including details about the recovery process.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListRestoreJobs for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobs
func (c *Backup) ListRestoreJobs(input *ListRestoreJobsInput) (*ListRestoreJobsOutput, error) {
	req, out := c.ListRestoreJobsRequest(input)
	return out, req.Send()
}

// ListRestoreJobsWithContext is the same as ListRestoreJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListRestoreJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRestoreJobsWithContext(ctx aws.Context, input *ListRestoreJobsInput, opts ...request.Option) (*ListRestoreJobsOutput, error) {
	req, out := c.ListRestoreJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRestoreJobsPages iterates over the pages of a ListRestoreJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRestoreJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRestoreJobs operation.
//	pageNum := 0
//	err := client.ListRestoreJobsPages(params,
//	    func(page *backup.ListRestoreJobsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListRestoreJobsPages(input *ListRestoreJobsInput, fn func(*ListRestoreJobsOutput, bool) bool) error {
	return c.ListRestoreJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRestoreJobsPagesWithContext same as ListRestoreJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRestoreJobsPagesWithContext(ctx aws.Context, input *ListRestoreJobsInput, fn func(*ListRestoreJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRestoreJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRestoreJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRestoreJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRestoreJobsByProtectedResource = "ListRestoreJobsByProtectedResource"

// ListRestoreJobsByProtectedResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListRestoreJobsByProtectedResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRestoreJobsByProtectedResource for more information on using the ListRestoreJobsByProtectedResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRestoreJobsByProtectedResourceRequest method.
//	req, resp := client.ListRestoreJobsByProtectedResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobsByProtectedResource
func (c *Backup) ListRestoreJobsByProtectedResourceRequest(input *ListRestoreJobsByProtectedResourceInput) (req *request.Request, output *ListRestoreJobsByProtectedResourceOutput) {
	op := &request.Operation{
		Name:       opListRestoreJobsByProtectedResource,
		HTTPMethod: "GET",
		HTTPPath:   "/resources/{resourceArn}/restore-jobs/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRestoreJobsByProtectedResourceInput{}
	}

	output = &ListRestoreJobsByProtectedResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRestoreJobsByProtectedResource API operation for AWS Backup.
//
// This returns restore jobs that contain the specified protected resource.
//
// You must include ResourceArn. You can optionally include NextToken, ByStatus,
// MaxResults, ByRecoveryPointCreationDateAfter , and ByRecoveryPointCreationDateBefore.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListRestoreJobsByProtectedResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreJobsByProtectedResource
func (c *Backup) ListRestoreJobsByProtectedResource(input *ListRestoreJobsByProtectedResourceInput) (*ListRestoreJobsByProtectedResourceOutput, error) {
	req, out := c.ListRestoreJobsByProtectedResourceRequest(input)
	return out, req.Send()
}

// ListRestoreJobsByProtectedResourceWithContext is the same as ListRestoreJobsByProtectedResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListRestoreJobsByProtectedResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRestoreJobsByProtectedResourceWithContext(ctx aws.Context, input *ListRestoreJobsByProtectedResourceInput, opts ...request.Option) (*ListRestoreJobsByProtectedResourceOutput, error) {
	req, out := c.ListRestoreJobsByProtectedResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRestoreJobsByProtectedResourcePages iterates over the pages of a ListRestoreJobsByProtectedResource operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRestoreJobsByProtectedResource method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRestoreJobsByProtectedResource operation.
//	pageNum := 0
//	err := client.ListRestoreJobsByProtectedResourcePages(params,
//	    func(page *backup.ListRestoreJobsByProtectedResourceOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListRestoreJobsByProtectedResourcePages(input *ListRestoreJobsByProtectedResourceInput, fn func(*ListRestoreJobsByProtectedResourceOutput, bool) bool) error {
	return c.ListRestoreJobsByProtectedResourcePagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRestoreJobsByProtectedResourcePagesWithContext same as ListRestoreJobsByProtectedResourcePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRestoreJobsByProtectedResourcePagesWithContext(ctx aws.Context, input *ListRestoreJobsByProtectedResourceInput, fn func(*ListRestoreJobsByProtectedResourceOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRestoreJobsByProtectedResourceInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRestoreJobsByProtectedResourceRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRestoreJobsByProtectedResourceOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRestoreTestingPlans = "ListRestoreTestingPlans"

// ListRestoreTestingPlansRequest generates a "aws/request.Request" representing the
// client's request for the ListRestoreTestingPlans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRestoreTestingPlans for more information on using the ListRestoreTestingPlans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRestoreTestingPlansRequest method.
//	req, resp := client.ListRestoreTestingPlansRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingPlans
func (c *Backup) ListRestoreTestingPlansRequest(input *ListRestoreTestingPlansInput) (req *request.Request, output *ListRestoreTestingPlansOutput) {
	op := &request.Operation{
		Name:       opListRestoreTestingPlans,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-testing/plans",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRestoreTestingPlansInput{}
	}

	output = &ListRestoreTestingPlansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRestoreTestingPlans API operation for AWS Backup.
//
// Returns a list of restore testing plans.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListRestoreTestingPlans for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingPlans
func (c *Backup) ListRestoreTestingPlans(input *ListRestoreTestingPlansInput) (*ListRestoreTestingPlansOutput, error) {
	req, out := c.ListRestoreTestingPlansRequest(input)
	return out, req.Send()
}

// ListRestoreTestingPlansWithContext is the same as ListRestoreTestingPlans with the addition of
// the ability to pass a context and additional request options.
//
// See ListRestoreTestingPlans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRestoreTestingPlansWithContext(ctx aws.Context, input *ListRestoreTestingPlansInput, opts ...request.Option) (*ListRestoreTestingPlansOutput, error) {
	req, out := c.ListRestoreTestingPlansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRestoreTestingPlansPages iterates over the pages of a ListRestoreTestingPlans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRestoreTestingPlans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRestoreTestingPlans operation.
//	pageNum := 0
//	err := client.ListRestoreTestingPlansPages(params,
//	    func(page *backup.ListRestoreTestingPlansOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListRestoreTestingPlansPages(input *ListRestoreTestingPlansInput, fn func(*ListRestoreTestingPlansOutput, bool) bool) error {
	return c.ListRestoreTestingPlansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRestoreTestingPlansPagesWithContext same as ListRestoreTestingPlansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRestoreTestingPlansPagesWithContext(ctx aws.Context, input *ListRestoreTestingPlansInput, fn func(*ListRestoreTestingPlansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRestoreTestingPlansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRestoreTestingPlansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRestoreTestingPlansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRestoreTestingSelections = "ListRestoreTestingSelections"

// ListRestoreTestingSelectionsRequest generates a "aws/request.Request" representing the
// client's request for the ListRestoreTestingSelections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRestoreTestingSelections for more information on using the ListRestoreTestingSelections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRestoreTestingSelectionsRequest method.
//	req, resp := client.ListRestoreTestingSelectionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingSelections
func (c *Backup) ListRestoreTestingSelectionsRequest(input *ListRestoreTestingSelectionsInput) (req *request.Request, output *ListRestoreTestingSelectionsOutput) {
	op := &request.Operation{
		Name:       opListRestoreTestingSelections,
		HTTPMethod: "GET",
		HTTPPath:   "/restore-testing/plans/{RestoreTestingPlanName}/selections",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRestoreTestingSelectionsInput{}
	}

	output = &ListRestoreTestingSelectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRestoreTestingSelections API operation for AWS Backup.
//
// Returns a list of restore testing selections. Can be filtered by MaxResults
// and RestoreTestingPlanName.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListRestoreTestingSelections for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListRestoreTestingSelections
func (c *Backup) ListRestoreTestingSelections(input *ListRestoreTestingSelectionsInput) (*ListRestoreTestingSelectionsOutput, error) {
	req, out := c.ListRestoreTestingSelectionsRequest(input)
	return out, req.Send()
}

// ListRestoreTestingSelectionsWithContext is the same as ListRestoreTestingSelections with the addition of
// the ability to pass a context and additional request options.
//
// See ListRestoreTestingSelections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRestoreTestingSelectionsWithContext(ctx aws.Context, input *ListRestoreTestingSelectionsInput, opts ...request.Option) (*ListRestoreTestingSelectionsOutput, error) {
	req, out := c.ListRestoreTestingSelectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRestoreTestingSelectionsPages iterates over the pages of a ListRestoreTestingSelections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRestoreTestingSelections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRestoreTestingSelections operation.
//	pageNum := 0
//	err := client.ListRestoreTestingSelectionsPages(params,
//	    func(page *backup.ListRestoreTestingSelectionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListRestoreTestingSelectionsPages(input *ListRestoreTestingSelectionsInput, fn func(*ListRestoreTestingSelectionsOutput, bool) bool) error {
	return c.ListRestoreTestingSelectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRestoreTestingSelectionsPagesWithContext same as ListRestoreTestingSelectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListRestoreTestingSelectionsPagesWithContext(ctx aws.Context, input *ListRestoreTestingSelectionsInput, fn func(*ListRestoreTestingSelectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRestoreTestingSelectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRestoreTestingSelectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRestoreTestingSelectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTags for more information on using the ListTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsRequest method.
//	req, resp := client.ListTagsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags
func (c *Backup) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for AWS Backup.
//
// Returns a list of key-value pairs assigned to a target recovery point, backup
// plan, or backup vault.
//
// ListTags only works for resource types that support full Backup management
// of their backups. Those resource types are listed in the "Full Backup management"
// section of the Feature availability by resource (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
// table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation ListTags for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/ListTags
func (c *Backup) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	return out, req.Send()
}

// ListTagsWithContext is the same as ListTags with the addition of
// the ability to pass a context and additional request options.
//
// See ListTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListTagsWithContext(ctx aws.Context, input *ListTagsInput, opts ...request.Option) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTagsPages iterates over the pages of a ListTags operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTags method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTags operation.
//	pageNum := 0
//	err := client.ListTagsPages(params,
//	    func(page *backup.ListTagsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Backup) ListTagsPages(input *ListTagsInput, fn func(*ListTagsOutput, bool) bool) error {
	return c.ListTagsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTagsPagesWithContext same as ListTagsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) ListTagsPagesWithContext(ctx aws.Context, input *ListTagsInput, fn func(*ListTagsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTagsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTagsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTagsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutBackupVaultAccessPolicy = "PutBackupVaultAccessPolicy"

// PutBackupVaultAccessPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutBackupVaultAccessPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBackupVaultAccessPolicy for more information on using the PutBackupVaultAccessPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBackupVaultAccessPolicyRequest method.
//	req, resp := client.PutBackupVaultAccessPolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultAccessPolicy
func (c *Backup) PutBackupVaultAccessPolicyRequest(input *PutBackupVaultAccessPolicyInput) (req *request.Request, output *PutBackupVaultAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opPutBackupVaultAccessPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/backup-vaults/{backupVaultName}/access-policy",
	}

	if input == nil {
		input = &PutBackupVaultAccessPolicyInput{}
	}

	output = &PutBackupVaultAccessPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBackupVaultAccessPolicy API operation for AWS Backup.
//
// Sets a resource-based policy that is used to manage access permissions on
// the target backup vault. Requires a backup vault name and an access policy
// document in JSON format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation PutBackupVaultAccessPolicy for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultAccessPolicy
func (c *Backup) PutBackupVaultAccessPolicy(input *PutBackupVaultAccessPolicyInput) (*PutBackupVaultAccessPolicyOutput, error) {
	req, out := c.PutBackupVaultAccessPolicyRequest(input)
	return out, req.Send()
}

// PutBackupVaultAccessPolicyWithContext is the same as PutBackupVaultAccessPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutBackupVaultAccessPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) PutBackupVaultAccessPolicyWithContext(ctx aws.Context, input *PutBackupVaultAccessPolicyInput, opts ...request.Option) (*PutBackupVaultAccessPolicyOutput, error) {
	req, out := c.PutBackupVaultAccessPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBackupVaultLockConfiguration = "PutBackupVaultLockConfiguration"

// PutBackupVaultLockConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutBackupVaultLockConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBackupVaultLockConfiguration for more information on using the PutBackupVaultLockConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBackupVaultLockConfigurationRequest method.
//	req, resp := client.PutBackupVaultLockConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultLockConfiguration
func (c *Backup) PutBackupVaultLockConfigurationRequest(input *PutBackupVaultLockConfigurationInput) (req *request.Request, output *PutBackupVaultLockConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutBackupVaultLockConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/backup-vaults/{backupVaultName}/vault-lock",
	}

	if input == nil {
		input = &PutBackupVaultLockConfigurationInput{}
	}

	output = &PutBackupVaultLockConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBackupVaultLockConfiguration API operation for AWS Backup.
//
// Applies Backup Vault Lock to a backup vault, preventing attempts to delete
// any recovery point stored in or created in a backup vault. Vault Lock also
// prevents attempts to update the lifecycle policy that controls the retention
// period of any recovery point currently stored in a backup vault. If specified,
// Vault Lock enforces a minimum and maximum retention period for future backup
// and copy jobs that target a backup vault.
//
// Backup Vault Lock has been assessed by Cohasset Associates for use in environments
// that are subject to SEC 17a-4, CFTC, and FINRA regulations. For more information
// about how Backup Vault Lock relates to these regulations, see the Cohasset
// Associates Compliance Assessment. (samples/cohassetreport.zip)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation PutBackupVaultLockConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultLockConfiguration
func (c *Backup) PutBackupVaultLockConfiguration(input *PutBackupVaultLockConfigurationInput) (*PutBackupVaultLockConfigurationOutput, error) {
	req, out := c.PutBackupVaultLockConfigurationRequest(input)
	return out, req.Send()
}

// PutBackupVaultLockConfigurationWithContext is the same as PutBackupVaultLockConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutBackupVaultLockConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) PutBackupVaultLockConfigurationWithContext(ctx aws.Context, input *PutBackupVaultLockConfigurationInput, opts ...request.Option) (*PutBackupVaultLockConfigurationOutput, error) {
	req, out := c.PutBackupVaultLockConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutBackupVaultNotifications = "PutBackupVaultNotifications"

// PutBackupVaultNotificationsRequest generates a "aws/request.Request" representing the
// client's request for the PutBackupVaultNotifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutBackupVaultNotifications for more information on using the PutBackupVaultNotifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutBackupVaultNotificationsRequest method.
//	req, resp := client.PutBackupVaultNotificationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultNotifications
func (c *Backup) PutBackupVaultNotificationsRequest(input *PutBackupVaultNotificationsInput) (req *request.Request, output *PutBackupVaultNotificationsOutput) {
	op := &request.Operation{
		Name:       opPutBackupVaultNotifications,
		HTTPMethod: "PUT",
		HTTPPath:   "/backup-vaults/{backupVaultName}/notification-configuration",
	}

	if input == nil {
		input = &PutBackupVaultNotificationsInput{}
	}

	output = &PutBackupVaultNotificationsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutBackupVaultNotifications API operation for AWS Backup.
//
// Turns on notifications on a backup vault for the specified topic and events.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation PutBackupVaultNotifications for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutBackupVaultNotifications
func (c *Backup) PutBackupVaultNotifications(input *PutBackupVaultNotificationsInput) (*PutBackupVaultNotificationsOutput, error) {
	req, out := c.PutBackupVaultNotificationsRequest(input)
	return out, req.Send()
}

// PutBackupVaultNotificationsWithContext is the same as PutBackupVaultNotifications with the addition of
// the ability to pass a context and additional request options.
//
// See PutBackupVaultNotifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) PutBackupVaultNotificationsWithContext(ctx aws.Context, input *PutBackupVaultNotificationsInput, opts ...request.Option) (*PutBackupVaultNotificationsOutput, error) {
	req, out := c.PutBackupVaultNotificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRestoreValidationResult = "PutRestoreValidationResult"

// PutRestoreValidationResultRequest generates a "aws/request.Request" representing the
// client's request for the PutRestoreValidationResult operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRestoreValidationResult for more information on using the PutRestoreValidationResult
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutRestoreValidationResultRequest method.
//	req, resp := client.PutRestoreValidationResultRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutRestoreValidationResult
func (c *Backup) PutRestoreValidationResultRequest(input *PutRestoreValidationResultInput) (req *request.Request, output *PutRestoreValidationResultOutput) {
	op := &request.Operation{
		Name:       opPutRestoreValidationResult,
		HTTPMethod: "PUT",
		HTTPPath:   "/restore-jobs/{restoreJobId}/validations",
	}

	if input == nil {
		input = &PutRestoreValidationResultInput{}
	}

	output = &PutRestoreValidationResultOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutRestoreValidationResult API operation for AWS Backup.
//
// This request allows you to send your independent self-run restore test validation
// results. RestoreJobId and ValidationStatus are required. Optionally, you
// can input a ValidationStatusMessage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation PutRestoreValidationResult for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/PutRestoreValidationResult
func (c *Backup) PutRestoreValidationResult(input *PutRestoreValidationResultInput) (*PutRestoreValidationResultOutput, error) {
	req, out := c.PutRestoreValidationResultRequest(input)
	return out, req.Send()
}

// PutRestoreValidationResultWithContext is the same as PutRestoreValidationResult with the addition of
// the ability to pass a context and additional request options.
//
// See PutRestoreValidationResult for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) PutRestoreValidationResultWithContext(ctx aws.Context, input *PutRestoreValidationResultInput, opts ...request.Option) (*PutRestoreValidationResultOutput, error) {
	req, out := c.PutRestoreValidationResultRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartBackupJob = "StartBackupJob"

// StartBackupJobRequest generates a "aws/request.Request" representing the
// client's request for the StartBackupJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartBackupJob for more information on using the StartBackupJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartBackupJobRequest method.
//	req, resp := client.StartBackupJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartBackupJob
func (c *Backup) StartBackupJobRequest(input *StartBackupJobInput) (req *request.Request, output *StartBackupJobOutput) {
	op := &request.Operation{
		Name:       opStartBackupJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/backup-jobs",
	}

	if input == nil {
		input = &StartBackupJobInput{}
	}

	output = &StartBackupJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartBackupJob API operation for AWS Backup.
//
// Starts an on-demand backup job for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation StartBackupJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartBackupJob
func (c *Backup) StartBackupJob(input *StartBackupJobInput) (*StartBackupJobOutput, error) {
	req, out := c.StartBackupJobRequest(input)
	return out, req.Send()
}

// StartBackupJobWithContext is the same as StartBackupJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartBackupJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) StartBackupJobWithContext(ctx aws.Context, input *StartBackupJobInput, opts ...request.Option) (*StartBackupJobOutput, error) {
	req, out := c.StartBackupJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartCopyJob = "StartCopyJob"

// StartCopyJobRequest generates a "aws/request.Request" representing the
// client's request for the StartCopyJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartCopyJob for more information on using the StartCopyJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartCopyJobRequest method.
//	req, resp := client.StartCopyJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartCopyJob
func (c *Backup) StartCopyJobRequest(input *StartCopyJobInput) (req *request.Request, output *StartCopyJobOutput) {
	op := &request.Operation{
		Name:       opStartCopyJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/copy-jobs",
	}

	if input == nil {
		input = &StartCopyJobInput{}
	}

	output = &StartCopyJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartCopyJob API operation for AWS Backup.
//
// Starts a job to create a one-time copy of the specified resource.
//
// Does not support continuous backups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation StartCopyJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartCopyJob
func (c *Backup) StartCopyJob(input *StartCopyJobInput) (*StartCopyJobOutput, error) {
	req, out := c.StartCopyJobRequest(input)
	return out, req.Send()
}

// StartCopyJobWithContext is the same as StartCopyJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartCopyJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) StartCopyJobWithContext(ctx aws.Context, input *StartCopyJobInput, opts ...request.Option) (*StartCopyJobOutput, error) {
	req, out := c.StartCopyJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReportJob = "StartReportJob"

// StartReportJobRequest generates a "aws/request.Request" representing the
// client's request for the StartReportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReportJob for more information on using the StartReportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartReportJobRequest method.
//	req, resp := client.StartReportJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartReportJob
func (c *Backup) StartReportJobRequest(input *StartReportJobInput) (req *request.Request, output *StartReportJobOutput) {
	op := &request.Operation{
		Name:       opStartReportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/audit/report-jobs/{reportPlanName}",
	}

	if input == nil {
		input = &StartReportJobInput{}
	}

	output = &StartReportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReportJob API operation for AWS Backup.
//
// Starts an on-demand report job for the specified report plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation StartReportJob for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartReportJob
func (c *Backup) StartReportJob(input *StartReportJobInput) (*StartReportJobOutput, error) {
	req, out := c.StartReportJobRequest(input)
	return out, req.Send()
}

// StartReportJobWithContext is the same as StartReportJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartReportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) StartReportJobWithContext(ctx aws.Context, input *StartReportJobInput, opts ...request.Option) (*StartReportJobOutput, error) {
	req, out := c.StartReportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartRestoreJob = "StartRestoreJob"

// StartRestoreJobRequest generates a "aws/request.Request" representing the
// client's request for the StartRestoreJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartRestoreJob for more information on using the StartRestoreJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartRestoreJobRequest method.
//	req, resp := client.StartRestoreJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartRestoreJob
func (c *Backup) StartRestoreJobRequest(input *StartRestoreJobInput) (req *request.Request, output *StartRestoreJobOutput) {
	op := &request.Operation{
		Name:       opStartRestoreJob,
		HTTPMethod: "PUT",
		HTTPPath:   "/restore-jobs",
	}

	if input == nil {
		input = &StartRestoreJobInput{}
	}

	output = &StartRestoreJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartRestoreJob API operation for AWS Backup.
//
// Recovers the saved resource identified by an Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation StartRestoreJob for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StartRestoreJob
func (c *Backup) StartRestoreJob(input *StartRestoreJobInput) (*StartRestoreJobOutput, error) {
	req, out := c.StartRestoreJobRequest(input)
	return out, req.Send()
}

// StartRestoreJobWithContext is the same as StartRestoreJob with the addition of
// the ability to pass a context and additional request options.
//
// See StartRestoreJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) StartRestoreJobWithContext(ctx aws.Context, input *StartRestoreJobInput, opts ...request.Option) (*StartRestoreJobOutput, error) {
	req, out := c.StartRestoreJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopBackupJob = "StopBackupJob"

// StopBackupJobRequest generates a "aws/request.Request" representing the
// client's request for the StopBackupJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopBackupJob for more information on using the StopBackupJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopBackupJobRequest method.
//	req, resp := client.StopBackupJobRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJob
func (c *Backup) StopBackupJobRequest(input *StopBackupJobInput) (req *request.Request, output *StopBackupJobOutput) {
	op := &request.Operation{
		Name:       opStopBackupJob,
		HTTPMethod: "POST",
		HTTPPath:   "/backup-jobs/{backupJobId}",
	}

	if input == nil {
		input = &StopBackupJobInput{}
	}

	output = &StopBackupJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopBackupJob API operation for AWS Backup.
//
// Attempts to cancel a job to create a one-time backup of a resource.
//
// This action is not supported for the following services: Amazon FSx for Windows
// File Server, Amazon FSx for Lustre, FSx for ONTAP , Amazon FSx for OpenZFS,
// Amazon DocumentDB (with MongoDB compatibility), Amazon RDS, Amazon Aurora,
// and Amazon Neptune.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation StopBackupJob for usage and error information.
//
// Returned Error Types:
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/StopBackupJob
func (c *Backup) StopBackupJob(input *StopBackupJobInput) (*StopBackupJobOutput, error) {
	req, out := c.StopBackupJobRequest(input)
	return out, req.Send()
}

// StopBackupJobWithContext is the same as StopBackupJob with the addition of
// the ability to pass a context and additional request options.
//
// See StopBackupJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) StopBackupJobWithContext(ctx aws.Context, input *StopBackupJobInput, opts ...request.Option) (*StopBackupJobOutput, error) {
	req, out := c.StopBackupJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/TagResource
func (c *Backup) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Backup.
//
// Assigns a set of key-value pairs to a recovery point, backup plan, or backup
// vault identified by an Amazon Resource Name (ARN).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/TagResource
func (c *Backup) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UntagResource
func (c *Backup) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/untag/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Backup.
//
// Removes a set of key-value pairs from a recovery point, backup plan, or backup
// vault identified by an Amazon Resource Name (ARN)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UntagResource
func (c *Backup) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBackupPlan = "UpdateBackupPlan"

// UpdateBackupPlanRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBackupPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBackupPlan for more information on using the UpdateBackupPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateBackupPlanRequest method.
//	req, resp := client.UpdateBackupPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateBackupPlan
func (c *Backup) UpdateBackupPlanRequest(input *UpdateBackupPlanInput) (req *request.Request, output *UpdateBackupPlanOutput) {
	op := &request.Operation{
		Name:       opUpdateBackupPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/backup/plans/{backupPlanId}",
	}

	if input == nil {
		input = &UpdateBackupPlanInput{}
	}

	output = &UpdateBackupPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBackupPlan API operation for AWS Backup.
//
// Updates an existing backup plan identified by its backupPlanId with the input
// document in JSON format. The new version is uniquely identified by a VersionId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation UpdateBackupPlan for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateBackupPlan
func (c *Backup) UpdateBackupPlan(input *UpdateBackupPlanInput) (*UpdateBackupPlanOutput, error) {
	req, out := c.UpdateBackupPlanRequest(input)
	return out, req.Send()
}

// UpdateBackupPlanWithContext is the same as UpdateBackupPlan with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBackupPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) UpdateBackupPlanWithContext(ctx aws.Context, input *UpdateBackupPlanInput, opts ...request.Option) (*UpdateBackupPlanOutput, error) {
	req, out := c.UpdateBackupPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateFramework = "UpdateFramework"

// UpdateFrameworkRequest generates a "aws/request.Request" representing the
// client's request for the UpdateFramework operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateFramework for more information on using the UpdateFramework
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateFrameworkRequest method.
//	req, resp := client.UpdateFrameworkRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateFramework
func (c *Backup) UpdateFrameworkRequest(input *UpdateFrameworkInput) (req *request.Request, output *UpdateFrameworkOutput) {
	op := &request.Operation{
		Name:       opUpdateFramework,
		HTTPMethod: "PUT",
		HTTPPath:   "/audit/frameworks/{frameworkName}",
	}

	if input == nil {
		input = &UpdateFrameworkInput{}
	}

	output = &UpdateFrameworkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateFramework API operation for AWS Backup.
//
// Updates an existing framework identified by its FrameworkName with the input
// document in JSON format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation UpdateFramework for usage and error information.
//
// Returned Error Types:
//
//   - AlreadyExistsException
//     The required resource already exists.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - LimitExceededException
//     A limit in the request has been exceeded; for example, a maximum number of
//     items allowed in a request.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ConflictException
//     Backup can't perform the action that you requested until it finishes performing
//     a previous action. Try again later.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateFramework
func (c *Backup) UpdateFramework(input *UpdateFrameworkInput) (*UpdateFrameworkOutput, error) {
	req, out := c.UpdateFrameworkRequest(input)
	return out, req.Send()
}

// UpdateFrameworkWithContext is the same as UpdateFramework with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateFramework for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) UpdateFrameworkWithContext(ctx aws.Context, input *UpdateFrameworkInput, opts ...request.Option) (*UpdateFrameworkOutput, error) {
	req, out := c.UpdateFrameworkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGlobalSettings = "UpdateGlobalSettings"

// UpdateGlobalSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGlobalSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGlobalSettings for more information on using the UpdateGlobalSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateGlobalSettingsRequest method.
//	req, resp := client.UpdateGlobalSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateGlobalSettings
func (c *Backup) UpdateGlobalSettingsRequest(input *UpdateGlobalSettingsInput) (req *request.Request, output *UpdateGlobalSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateGlobalSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/global-settings",
	}

	if input == nil {
		input = &UpdateGlobalSettingsInput{}
	}

	output = &UpdateGlobalSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateGlobalSettings API operation for AWS Backup.
//
// Updates whether the Amazon Web Services account is opted in to cross-account
// backup. Returns an error if the account is not an Organizations management
// account. Use the DescribeGlobalSettings API to determine the current settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation UpdateGlobalSettings for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateGlobalSettings
func (c *Backup) UpdateGlobalSettings(input *UpdateGlobalSettingsInput) (*UpdateGlobalSettingsOutput, error) {
	req, out := c.UpdateGlobalSettingsRequest(input)
	return out, req.Send()
}

// UpdateGlobalSettingsWithContext is the same as UpdateGlobalSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGlobalSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) UpdateGlobalSettingsWithContext(ctx aws.Context, input *UpdateGlobalSettingsInput, opts ...request.Option) (*UpdateGlobalSettingsOutput, error) {
	req, out := c.UpdateGlobalSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRecoveryPointLifecycle = "UpdateRecoveryPointLifecycle"

// UpdateRecoveryPointLifecycleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRecoveryPointLifecycle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRecoveryPointLifecycle for more information on using the UpdateRecoveryPointLifecycle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRecoveryPointLifecycleRequest method.
//	req, resp := client.UpdateRecoveryPointLifecycleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRecoveryPointLifecycle
func (c *Backup) UpdateRecoveryPointLifecycleRequest(input *UpdateRecoveryPointLifecycleInput) (req *request.Request, output *UpdateRecoveryPointLifecycleOutput) {
	op := &request.Operation{
		Name:       opUpdateRecoveryPointLifecycle,
		HTTPMethod: "POST",
		HTTPPath:   "/backup-vaults/{backupVaultName}/recovery-points/{recoveryPointArn}",
	}

	if input == nil {
		input = &UpdateRecoveryPointLifecycleInput{}
	}

	output = &UpdateRecoveryPointLifecycleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRecoveryPointLifecycle API operation for AWS Backup.
//
// Sets the transition lifecycle of a recovery point.
//
// The lifecycle defines when a protected resource is transitioned to cold storage
// and when it expires. Backup transitions and expires backups automatically
// according to the lifecycle that you define.
//
// Backups transitioned to cold storage must be stored in cold storage for a
// minimum of 90 days. Therefore, the “retention” setting must be 90 days
// greater than the “transition to cold after days” setting. The “transition
// to cold after days” setting cannot be changed after a backup has been transitioned
// to cold.
//
// Resource types that are able to be transitioned to cold storage are listed
// in the "Lifecycle to cold storage" section of the Feature availability by
// resource (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
// table. Backup ignores this expression for other resource types.
//
// This operation does not support continuous backups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation UpdateRecoveryPointLifecycle for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - InvalidRequestException
//     Indicates that something is wrong with the input to the request. For example,
//     a parameter is of the wrong type.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRecoveryPointLifecycle
func (c *Backup) UpdateRecoveryPointLifecycle(input *UpdateRecoveryPointLifecycleInput) (*UpdateRecoveryPointLifecycleOutput, error) {
	req, out := c.UpdateRecoveryPointLifecycleRequest(input)
	return out, req.Send()
}

// UpdateRecoveryPointLifecycleWithContext is the same as UpdateRecoveryPointLifecycle with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRecoveryPointLifecycle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) UpdateRecoveryPointLifecycleWithContext(ctx aws.Context, input *UpdateRecoveryPointLifecycleInput, opts ...request.Option) (*UpdateRecoveryPointLifecycleOutput, error) {
	req, out := c.UpdateRecoveryPointLifecycleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRegionSettings = "UpdateRegionSettings"

// UpdateRegionSettingsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRegionSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRegionSettings for more information on using the UpdateRegionSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRegionSettingsRequest method.
//	req, resp := client.UpdateRegionSettingsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRegionSettings
func (c *Backup) UpdateRegionSettingsRequest(input *UpdateRegionSettingsInput) (req *request.Request, output *UpdateRegionSettingsOutput) {
	op := &request.Operation{
		Name:       opUpdateRegionSettings,
		HTTPMethod: "PUT",
		HTTPPath:   "/account-settings",
	}

	if input == nil {
		input = &UpdateRegionSettingsInput{}
	}

	output = &UpdateRegionSettingsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRegionSettings API operation for AWS Backup.
//
// Updates the current service opt-in settings for the Region.
//
// Use the DescribeRegionSettings API to determine the resource types that are
// supported.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation UpdateRegionSettings for usage and error information.
//
// Returned Error Types:
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRegionSettings
func (c *Backup) UpdateRegionSettings(input *UpdateRegionSettingsInput) (*UpdateRegionSettingsOutput, error) {
	req, out := c.UpdateRegionSettingsRequest(input)
	return out, req.Send()
}

// UpdateRegionSettingsWithContext is the same as UpdateRegionSettings with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRegionSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) UpdateRegionSettingsWithContext(ctx aws.Context, input *UpdateRegionSettingsInput, opts ...request.Option) (*UpdateRegionSettingsOutput, error) {
	req, out := c.UpdateRegionSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateReportPlan = "UpdateReportPlan"

// UpdateReportPlanRequest generates a "aws/request.Request" representing the
// client's request for the UpdateReportPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateReportPlan for more information on using the UpdateReportPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateReportPlanRequest method.
//	req, resp := client.UpdateReportPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateReportPlan
func (c *Backup) UpdateReportPlanRequest(input *UpdateReportPlanInput) (req *request.Request, output *UpdateReportPlanOutput) {
	op := &request.Operation{
		Name:       opUpdateReportPlan,
		HTTPMethod: "PUT",
		HTTPPath:   "/audit/report-plans/{reportPlanName}",
	}

	if input == nil {
		input = &UpdateReportPlanInput{}
	}

	output = &UpdateReportPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateReportPlan API operation for AWS Backup.
//
// Updates an existing report plan identified by its ReportPlanName with the
// input document in JSON format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation UpdateReportPlan for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ConflictException
//     Backup can't perform the action that you requested until it finishes performing
//     a previous action. Try again later.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateReportPlan
func (c *Backup) UpdateReportPlan(input *UpdateReportPlanInput) (*UpdateReportPlanOutput, error) {
	req, out := c.UpdateReportPlanRequest(input)
	return out, req.Send()
}

// UpdateReportPlanWithContext is the same as UpdateReportPlan with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateReportPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) UpdateReportPlanWithContext(ctx aws.Context, input *UpdateReportPlanInput, opts ...request.Option) (*UpdateReportPlanOutput, error) {
	req, out := c.UpdateReportPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRestoreTestingPlan = "UpdateRestoreTestingPlan"

// UpdateRestoreTestingPlanRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRestoreTestingPlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRestoreTestingPlan for more information on using the UpdateRestoreTestingPlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRestoreTestingPlanRequest method.
//	req, resp := client.UpdateRestoreTestingPlanRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRestoreTestingPlan
func (c *Backup) UpdateRestoreTestingPlanRequest(input *UpdateRestoreTestingPlanInput) (req *request.Request, output *UpdateRestoreTestingPlanOutput) {
	op := &request.Operation{
		Name:       opUpdateRestoreTestingPlan,
		HTTPMethod: "PUT",
		HTTPPath:   "/restore-testing/plans/{RestoreTestingPlanName}",
	}

	if input == nil {
		input = &UpdateRestoreTestingPlanInput{}
	}

	output = &UpdateRestoreTestingPlanOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRestoreTestingPlan API operation for AWS Backup.
//
// This request will send changes to your specified restore testing plan. RestoreTestingPlanName
// cannot be updated after it is created.
//
// RecoveryPointSelection can contain:
//
//   - Algorithm
//
//   - ExcludeVaults
//
//   - IncludeVaults
//
//   - RecoveryPointTypes
//
//   - SelectionWindowDays
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation UpdateRestoreTestingPlan for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Backup can't perform the action that you requested until it finishes performing
//     a previous action. Try again later.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRestoreTestingPlan
func (c *Backup) UpdateRestoreTestingPlan(input *UpdateRestoreTestingPlanInput) (*UpdateRestoreTestingPlanOutput, error) {
	req, out := c.UpdateRestoreTestingPlanRequest(input)
	return out, req.Send()
}

// UpdateRestoreTestingPlanWithContext is the same as UpdateRestoreTestingPlan with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRestoreTestingPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) UpdateRestoreTestingPlanWithContext(ctx aws.Context, input *UpdateRestoreTestingPlanInput, opts ...request.Option) (*UpdateRestoreTestingPlanOutput, error) {
	req, out := c.UpdateRestoreTestingPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRestoreTestingSelection = "UpdateRestoreTestingSelection"

// UpdateRestoreTestingSelectionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRestoreTestingSelection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRestoreTestingSelection for more information on using the UpdateRestoreTestingSelection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRestoreTestingSelectionRequest method.
//	req, resp := client.UpdateRestoreTestingSelectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRestoreTestingSelection
func (c *Backup) UpdateRestoreTestingSelectionRequest(input *UpdateRestoreTestingSelectionInput) (req *request.Request, output *UpdateRestoreTestingSelectionOutput) {
	op := &request.Operation{
		Name:       opUpdateRestoreTestingSelection,
		HTTPMethod: "PUT",
		HTTPPath:   "/restore-testing/plans/{RestoreTestingPlanName}/selections/{RestoreTestingSelectionName}",
	}

	if input == nil {
		input = &UpdateRestoreTestingSelectionInput{}
	}

	output = &UpdateRestoreTestingSelectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRestoreTestingSelection API operation for AWS Backup.
//
// Most elements except the RestoreTestingSelectionName can be updated with
// this request.
//
// RestoreTestingSelection can use either protected resource ARNs or conditions,
// but not both. That is, if your selection has ProtectedResourceArns, requesting
// an update with the parameter ProtectedResourceConditions will be unsuccessful.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Backup's
// API operation UpdateRestoreTestingSelection for usage and error information.
//
// Returned Error Types:
//
//   - ConflictException
//     Backup can't perform the action that you requested until it finishes performing
//     a previous action. Try again later.
//
//   - InvalidParameterValueException
//     Indicates that something is wrong with a parameter's value. For example,
//     the value is out of range.
//
//   - MissingParameterValueException
//     Indicates that a required parameter is missing.
//
//   - ResourceNotFoundException
//     A resource that is required for the action doesn't exist.
//
//   - ServiceUnavailableException
//     The request failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/UpdateRestoreTestingSelection
func (c *Backup) UpdateRestoreTestingSelection(input *UpdateRestoreTestingSelectionInput) (*UpdateRestoreTestingSelectionOutput, error) {
	req, out := c.UpdateRestoreTestingSelectionRequest(input)
	return out, req.Send()
}

// UpdateRestoreTestingSelectionWithContext is the same as UpdateRestoreTestingSelection with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRestoreTestingSelection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Backup) UpdateRestoreTestingSelectionWithContext(ctx aws.Context, input *UpdateRestoreTestingSelectionInput, opts ...request.Option) (*UpdateRestoreTestingSelectionOutput, error) {
	req, out := c.UpdateRestoreTestingSelectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// A list of backup options for each resource type.
type AdvancedBackupSetting struct {
	_ struct{} `type:"structure"`

	// Specifies the backup option for a selected resource. This option is only
	// available for Windows VSS backup jobs.
	//
	// Valid values:
	//
	// Set to "WindowsVSS":"enabled" to enable the WindowsVSS backup option and
	// create a Windows VSS backup.
	//
	// Set to "WindowsVSS":"disabled" to create a regular backup. The WindowsVSS
	// option is not enabled by default.
	//
	// If you specify an invalid option, you get an InvalidParameterValueException
	// exception.
	//
	// For more information about Windows VSS backups, see Creating a VSS-Enabled
	// Windows Backup (https://docs.aws.amazon.com/aws-backup/latest/devguide/windows-backups.html).
	BackupOptions map[string]*string `type:"map"`

	// Specifies an object containing resource type and backup options. The only
	// supported resource type is Amazon EC2 instances with Windows Volume Shadow
	// Copy Service (VSS). For a CloudFormation example, see the sample CloudFormation
	// template to enable Windows VSS (https://docs.aws.amazon.com/aws-backup/latest/devguide/integrate-cloudformation-with-aws-backup.html)
	// in the Backup User Guide.
	//
	// Valid values: EC2.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedBackupSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AdvancedBackupSetting) GoString() string {
	return s.String()
}

// SetBackupOptions sets the BackupOptions field's value.
func (s *AdvancedBackupSetting) SetBackupOptions(v map[string]*string) *AdvancedBackupSetting {
	s.BackupOptions = v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AdvancedBackupSetting) SetResourceType(v string) *AdvancedBackupSetting {
	s.ResourceType = &v
	return s
}

// The required resource already exists.
type AlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Arn *string `type:"string"`

	Code_ *string `locationName:"Code" type:"string"`

	Context *string `type:"string"`

	CreatorRequestId *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &AlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AlreadyExistsException) Code() string {
	return "AlreadyExistsException"
}

// Message returns the exception's message.
func (s *AlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AlreadyExistsException) OrigErr() error {
	return nil
}

func (s *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This is a summary of jobs created or running within the most recent 30 days.
//
// The returned summary may contain the following: Region, Account, State, RestourceType,
// MessageCategory, StartTime, EndTime, and Count of included jobs.
type BackupJobSummary struct {
	_ struct{} `type:"structure"`

	// The account ID that owns the jobs within the summary.
	AccountId *string `type:"string"`

	// The value as a number of jobs in a job summary.
	Count *int64 `type:"integer"`

	// The value of time in number format of a job end time.
	//
	// This value is the time in Unix format, Coordinated Universal Time (UTC),
	// and accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	EndTime *time.Time `type:"timestamp"`

	// This parameter is the job count for the specified message category.
	//
	// Example strings include AccessDenied, Success, and InvalidParameters. See
	// Monitoring (https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
	// for a list of MessageCategory strings.
	//
	// The the value ANY returns count of all message categories.
	//
	// AGGREGATE_ALL aggregates job counts for all message categories and returns
	// the sum.
	MessageCategory *string `type:"string"`

	// The Amazon Web Services Regions within the job summary.
	Region *string `type:"string"`

	// This value is the job count for the specified resource type. The request
	// GetSupportedResourceTypes returns strings for supported resource types.
	ResourceType *string `type:"string"`

	// The value of time in number format of a job start time.
	//
	// This value is the time in Unix format, Coordinated Universal Time (UTC),
	// and accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	StartTime *time.Time `type:"timestamp"`

	// This value is job count for jobs with the specified state.
	State *string `type:"string" enum:"BackupJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackupJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BackupJobSummary) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *BackupJobSummary) SetAccountId(v string) *BackupJobSummary {
	s.AccountId = &v
	return s
}

// SetCount sets the Count field's value.
func (s *BackupJobSummary) SetCount(v int64) *BackupJobSummary {
	s.Count = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *BackupJobSummary) SetEndTime(v time.Time) *BackupJobSummary {
	s.EndTime = &v
	return s
}

// SetMessageCategory sets the MessageCategory field's value.
func (s *BackupJobSummary) SetMessageCategory(v string) *BackupJobSummary {
	s.MessageCategory = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *BackupJobSummary) SetRegion(v string) *BackupJobSummary {
	s.Region = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *BackupJobSummary) SetResourceType(v string) *BackupJobSummary {
	s.ResourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *BackupJobSummary) SetStartTime(v time.Time) *BackupJobSummary {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *BackupJobSummary) SetState(v string) *BackupJobSummary {
	s.State = &v
	return s
}

// Contains DeleteAt and MoveToColdStorageAt timestamps, which are used to specify
// a lifecycle for a recovery point.
//
// The lifecycle defines when a protected resource is transitioned to cold storage
// and when it expires. Backup transitions and expires backups automatically
// according to the lifecycle that you define.
//
// Backups transitioned to cold storage must be stored in cold storage for a
// minimum of 90 days. Therefore, the “retention” setting must be 90 days
// greater than the “transition to cold after days” setting. The “transition
// to cold after days” setting cannot be changed after a backup has been transitioned
// to cold.
//
// Resource types that are able to be transitioned to cold storage are listed
// in the "Lifecycle to cold storage" section of the Feature availability by
// resource (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
// table. Backup ignores this expression for other resource types.
type CalculatedLifecycle struct {
	_ struct{} `type:"structure"`

	// A timestamp that specifies when to delete a recovery point.
	DeleteAt *time.Time `type:"timestamp"`

	// A timestamp that specifies when to transition a recovery point to cold storage.
	MoveToColdStorageAt *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculatedLifecycle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CalculatedLifecycle) GoString() string {
	return s.String()
}

// SetDeleteAt sets the DeleteAt field's value.
func (s *CalculatedLifecycle) SetDeleteAt(v time.Time) *CalculatedLifecycle {
	s.DeleteAt = &v
	return s
}

// SetMoveToColdStorageAt sets the MoveToColdStorageAt field's value.
func (s *CalculatedLifecycle) SetMoveToColdStorageAt(v time.Time) *CalculatedLifecycle {
	s.MoveToColdStorageAt = &v
	return s
}

type CancelLegalHoldInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// String describing the reason for removing the legal hold.
	//
	// CancelDescription is a required field
	CancelDescription *string `location:"querystring" locationName:"cancelDescription" type:"string" required:"true"`

	// Legal hold ID required to remove the specified legal hold on a recovery point.
	//
	// LegalHoldId is a required field
	LegalHoldId *string `location:"uri" locationName:"legalHoldId" type:"string" required:"true"`

	// The integer amount in days specifying amount of days after this API operation
	// to remove legal hold.
	RetainRecordInDays *int64 `location:"querystring" locationName:"retainRecordInDays" type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelLegalHoldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelLegalHoldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelLegalHoldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelLegalHoldInput"}
	if s.CancelDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("CancelDescription"))
	}
	if s.LegalHoldId == nil {
		invalidParams.Add(request.NewErrParamRequired("LegalHoldId"))
	}
	if s.LegalHoldId != nil && len(*s.LegalHoldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LegalHoldId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCancelDescription sets the CancelDescription field's value.
func (s *CancelLegalHoldInput) SetCancelDescription(v string) *CancelLegalHoldInput {
	s.CancelDescription = &v
	return s
}

// SetLegalHoldId sets the LegalHoldId field's value.
func (s *CancelLegalHoldInput) SetLegalHoldId(v string) *CancelLegalHoldInput {
	s.LegalHoldId = &v
	return s
}

// SetRetainRecordInDays sets the RetainRecordInDays field's value.
func (s *CancelLegalHoldInput) SetRetainRecordInDays(v int64) *CancelLegalHoldInput {
	s.RetainRecordInDays = &v
	return s
}

type CancelLegalHoldOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelLegalHoldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CancelLegalHoldOutput) GoString() string {
	return s.String()
}

// Contains an array of triplets made up of a condition type (such as StringEquals),
// a key, and a value. Used to filter resources using their tags and assign
// them to a backup plan. Case sensitive.
type Condition struct {
	_ struct{} `type:"structure"`

	// The key in a key-value pair. For example, in the tag Department: Accounting,
	// Department is the key.
	//
	// ConditionKey is a required field
	ConditionKey *string `type:"string" required:"true"`

	// An operation applied to a key-value pair used to assign resources to your
	// backup plan. Condition only supports StringEquals. For more flexible assignment
	// options, including StringLike and the ability to exclude resources from your
	// backup plan, use Conditions (with an "s" on the end) for your BackupSelection
	// (https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BackupSelection.html).
	//
	// ConditionType is a required field
	ConditionType *string `type:"string" required:"true" enum:"ConditionType"`

	// The value in a key-value pair. For example, in the tag Department: Accounting,
	// Accounting is the value.
	//
	// ConditionValue is a required field
	ConditionValue *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Condition) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Condition) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Condition"}
	if s.ConditionKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ConditionKey"))
	}
	if s.ConditionType == nil {
		invalidParams.Add(request.NewErrParamRequired("ConditionType"))
	}
	if s.ConditionValue == nil {
		invalidParams.Add(request.NewErrParamRequired("ConditionValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditionKey sets the ConditionKey field's value.
func (s *Condition) SetConditionKey(v string) *Condition {
	s.ConditionKey = &v
	return s
}

// SetConditionType sets the ConditionType field's value.
func (s *Condition) SetConditionType(v string) *Condition {
	s.ConditionType = &v
	return s
}

// SetConditionValue sets the ConditionValue field's value.
func (s *Condition) SetConditionValue(v string) *Condition {
	s.ConditionValue = &v
	return s
}

// Includes information about tags you define to assign tagged resources to
// a backup plan.
type ConditionParameter struct {
	_ struct{} `type:"structure"`

	// The key in a key-value pair. For example, in the tag Department: Accounting,
	// Department is the key.
	ConditionKey *string `type:"string"`

	// The value in a key-value pair. For example, in the tag Department: Accounting,
	// Accounting is the value.
	ConditionValue *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConditionParameter) GoString() string {
	return s.String()
}

// SetConditionKey sets the ConditionKey field's value.
func (s *ConditionParameter) SetConditionKey(v string) *ConditionParameter {
	s.ConditionKey = &v
	return s
}

// SetConditionValue sets the ConditionValue field's value.
func (s *ConditionParameter) SetConditionValue(v string) *ConditionParameter {
	s.ConditionValue = &v
	return s
}

// Contains information about which resources to include or exclude from a backup
// plan using their tags. Conditions are case sensitive.
type Conditions struct {
	_ struct{} `type:"structure"`

	// Filters the values of your tagged resources for only those resources that
	// you tagged with the same value. Also called "exact matching."
	StringEquals []*ConditionParameter `type:"list"`

	// Filters the values of your tagged resources for matching tag values with
	// the use of a wildcard character (*) anywhere in the string. For example,
	// "prod*" or "*rod*" matches the tag value "production".
	StringLike []*ConditionParameter `type:"list"`

	// Filters the values of your tagged resources for only those resources that
	// you tagged that do not have the same value. Also called "negated matching."
	StringNotEquals []*ConditionParameter `type:"list"`

	// Filters the values of your tagged resources for non-matching tag values with
	// the use of a wildcard character (*) anywhere in the string.
	StringNotLike []*ConditionParameter `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Conditions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Conditions) GoString() string {
	return s.String()
}

// SetStringEquals sets the StringEquals field's value.
func (s *Conditions) SetStringEquals(v []*ConditionParameter) *Conditions {
	s.StringEquals = v
	return s
}

// SetStringLike sets the StringLike field's value.
func (s *Conditions) SetStringLike(v []*ConditionParameter) *Conditions {
	s.StringLike = v
	return s
}

// SetStringNotEquals sets the StringNotEquals field's value.
func (s *Conditions) SetStringNotEquals(v []*ConditionParameter) *Conditions {
	s.StringNotEquals = v
	return s
}

// SetStringNotLike sets the StringNotLike field's value.
func (s *Conditions) SetStringNotLike(v []*ConditionParameter) *Conditions {
	s.StringNotLike = v
	return s
}

// Backup can't perform the action that you requested until it finishes performing
// a previous action. Try again later.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Context *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A list of parameters for a control. A control can have zero, one, or more
// than one parameter. An example of a control with two parameters is: "backup
// plan frequency is at least daily and the retention period is at least 1 year".
// The first parameter is daily. The second parameter is 1 year.
type ControlInputParameter struct {
	_ struct{} `type:"structure"`

	// The name of a parameter, for example, BackupPlanFrequency.
	ParameterName *string `type:"string"`

	// The value of parameter, for example, hourly.
	ParameterValue *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlInputParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlInputParameter) GoString() string {
	return s.String()
}

// SetParameterName sets the ParameterName field's value.
func (s *ControlInputParameter) SetParameterName(v string) *ControlInputParameter {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *ControlInputParameter) SetParameterValue(v string) *ControlInputParameter {
	s.ParameterValue = &v
	return s
}

// A framework consists of one or more controls. Each control has its own control
// scope. The control scope can include one or more resource types, a combination
// of a tag key and value, or a combination of one resource type and one resource
// ID. If no scope is specified, evaluations for the rule are triggered when
// any resource in your recording group changes in configuration.
//
// To set a control scope that includes all of a particular resource, leave
// the ControlScope empty or do not pass it when calling CreateFramework.
type ControlScope struct {
	_ struct{} `type:"structure"`

	// The ID of the only Amazon Web Services resource that you want your control
	// scope to contain.
	ComplianceResourceIds []*string `min:"1" type:"list"`

	// Describes whether the control scope includes one or more types of resources,
	// such as EFS or RDS.
	ComplianceResourceTypes []*string `type:"list"`

	// The tag key-value pair applied to those Amazon Web Services resources that
	// you want to trigger an evaluation for a rule. A maximum of one key-value
	// pair can be provided. The tag value is optional, but it cannot be an empty
	// string. The structure to assign a tag is: [{"Key":"string","Value":"string"}].
	Tags map[string]*string `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlScope) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlScope) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ControlScope) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ControlScope"}
	if s.ComplianceResourceIds != nil && len(s.ComplianceResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ComplianceResourceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComplianceResourceIds sets the ComplianceResourceIds field's value.
func (s *ControlScope) SetComplianceResourceIds(v []*string) *ControlScope {
	s.ComplianceResourceIds = v
	return s
}

// SetComplianceResourceTypes sets the ComplianceResourceTypes field's value.
func (s *ControlScope) SetComplianceResourceTypes(v []*string) *ControlScope {
	s.ComplianceResourceTypes = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ControlScope) SetTags(v map[string]*string) *ControlScope {
	s.Tags = v
	return s
}

// The details of the copy operation.
type CopyAction struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies the destination backup
	// vault for the copied backup. For example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	//
	// DestinationBackupVaultArn is a required field
	DestinationBackupVaultArn *string `type:"string" required:"true"`

	// Contains an array of Transition objects specifying how long in days before
	// a recovery point transitions to cold storage or is deleted.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, on the console, the “retention” setting
	// must be 90 days greater than the “transition to cold after days” setting.
	// The “transition to cold after days” setting cannot be changed after a
	// backup has been transitioned to cold.
	//
	// Resource types that are able to be transitioned to cold storage are listed
	// in the "Lifecycle to cold storage" section of the Feature availability by
	// resource (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
	// table. Backup ignores this expression for other resource types.
	Lifecycle *Lifecycle `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyAction"}
	if s.DestinationBackupVaultArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationBackupVaultArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationBackupVaultArn sets the DestinationBackupVaultArn field's value.
func (s *CopyAction) SetDestinationBackupVaultArn(v string) *CopyAction {
	s.DestinationBackupVaultArn = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *CopyAction) SetLifecycle(v *Lifecycle) *CopyAction {
	s.Lifecycle = v
	return s
}

// Contains detailed information about a copy job.
type CopyJob struct {
	_ struct{} `type:"structure"`

	// The account ID that owns the copy job.
	AccountId *string `type:"string"`

	// The size, in bytes, of a copy job.
	BackupSizeInBytes *int64 `type:"long"`

	// This returns the statistics of the included child (nested) copy jobs.
	ChildJobsInState map[string]*int64 `type:"map"`

	// The date and time a copy job is completed, in Unix format and Coordinated
	// Universal Time (UTC). The value of CompletionDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CompletionDate *time.Time `type:"timestamp"`

	// This is the identifier of a resource within a composite group, such as nested
	// (child) recovery point belonging to a composite (parent) stack. The ID is
	// transferred from the logical ID (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax)
	// within a stack.
	CompositeMemberIdentifier *string `type:"string"`

	// Uniquely identifies a copy job.
	CopyJobId *string `type:"string"`

	// Contains information about the backup plan and rule that Backup used to initiate
	// the recovery point backup.
	CreatedBy *RecoveryPointCreator `type:"structure"`

	// The date and time a copy job is created, in Unix format and Coordinated Universal
	// Time (UTC). The value of CreationDate is accurate to milliseconds. For example,
	// the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
	// AM.
	CreationDate *time.Time `type:"timestamp"`

	// An Amazon Resource Name (ARN) that uniquely identifies a destination copy
	// vault; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	DestinationBackupVaultArn *string `type:"string"`

	// An ARN that uniquely identifies a destination recovery point; for example,
	// arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	DestinationRecoveryPointArn *string `type:"string"`

	// Specifies the IAM role ARN used to copy the target recovery point; for example,
	// arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// This is a boolean value indicating this is a parent (composite) copy job.
	IsParent *bool `type:"boolean"`

	// This parameter is the job count for the specified message category.
	//
	// Example strings may include AccessDenied, SUCCESS, AGGREGATE_ALL, and InvalidParameters.
	// See Monitoring (https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
	// for a list of MessageCategory strings.
	//
	// The the value ANY returns count of all message categories.
	//
	// AGGREGATE_ALL aggregates job counts for all message categories and returns
	// the sum
	MessageCategory *string `type:"string"`

	// This is the number of child (nested) copy jobs.
	NumberOfChildJobs *int64 `type:"long"`

	// This uniquely identifies a request to Backup to copy a resource. The return
	// will be the parent (composite) job ID.
	ParentJobId *string `type:"string"`

	// The Amazon Web Services resource to be copied; for example, an Amazon Elastic
	// Block Store (Amazon EBS) volume or an Amazon Relational Database Service
	// (Amazon RDS) database.
	ResourceArn *string `type:"string"`

	// This is the non-unique name of the resource that belongs to the specified
	// backup.
	ResourceName *string `type:"string"`

	// The type of Amazon Web Services resource to be copied; for example, an Amazon
	// Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database
	// Service (Amazon RDS) database.
	ResourceType *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies a source copy vault;
	// for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	SourceBackupVaultArn *string `type:"string"`

	// An ARN that uniquely identifies a source recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	SourceRecoveryPointArn *string `type:"string"`

	// The current state of a copy job.
	State *string `type:"string" enum:"CopyJobState"`

	// A detailed message explaining the status of the job to copy a resource.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyJob) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *CopyJob) SetAccountId(v string) *CopyJob {
	s.AccountId = &v
	return s
}

// SetBackupSizeInBytes sets the BackupSizeInBytes field's value.
func (s *CopyJob) SetBackupSizeInBytes(v int64) *CopyJob {
	s.BackupSizeInBytes = &v
	return s
}

// SetChildJobsInState sets the ChildJobsInState field's value.
func (s *CopyJob) SetChildJobsInState(v map[string]*int64) *CopyJob {
	s.ChildJobsInState = v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *CopyJob) SetCompletionDate(v time.Time) *CopyJob {
	s.CompletionDate = &v
	return s
}

// SetCompositeMemberIdentifier sets the CompositeMemberIdentifier field's value.
func (s *CopyJob) SetCompositeMemberIdentifier(v string) *CopyJob {
	s.CompositeMemberIdentifier = &v
	return s
}

// SetCopyJobId sets the CopyJobId field's value.
func (s *CopyJob) SetCopyJobId(v string) *CopyJob {
	s.CopyJobId = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *CopyJob) SetCreatedBy(v *RecoveryPointCreator) *CopyJob {
	s.CreatedBy = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CopyJob) SetCreationDate(v time.Time) *CopyJob {
	s.CreationDate = &v
	return s
}

// SetDestinationBackupVaultArn sets the DestinationBackupVaultArn field's value.
func (s *CopyJob) SetDestinationBackupVaultArn(v string) *CopyJob {
	s.DestinationBackupVaultArn = &v
	return s
}

// SetDestinationRecoveryPointArn sets the DestinationRecoveryPointArn field's value.
func (s *CopyJob) SetDestinationRecoveryPointArn(v string) *CopyJob {
	s.DestinationRecoveryPointArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *CopyJob) SetIamRoleArn(v string) *CopyJob {
	s.IamRoleArn = &v
	return s
}

// SetIsParent sets the IsParent field's value.
func (s *CopyJob) SetIsParent(v bool) *CopyJob {
	s.IsParent = &v
	return s
}

// SetMessageCategory sets the MessageCategory field's value.
func (s *CopyJob) SetMessageCategory(v string) *CopyJob {
	s.MessageCategory = &v
	return s
}

// SetNumberOfChildJobs sets the NumberOfChildJobs field's value.
func (s *CopyJob) SetNumberOfChildJobs(v int64) *CopyJob {
	s.NumberOfChildJobs = &v
	return s
}

// SetParentJobId sets the ParentJobId field's value.
func (s *CopyJob) SetParentJobId(v string) *CopyJob {
	s.ParentJobId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CopyJob) SetResourceArn(v string) *CopyJob {
	s.ResourceArn = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *CopyJob) SetResourceName(v string) *CopyJob {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CopyJob) SetResourceType(v string) *CopyJob {
	s.ResourceType = &v
	return s
}

// SetSourceBackupVaultArn sets the SourceBackupVaultArn field's value.
func (s *CopyJob) SetSourceBackupVaultArn(v string) *CopyJob {
	s.SourceBackupVaultArn = &v
	return s
}

// SetSourceRecoveryPointArn sets the SourceRecoveryPointArn field's value.
func (s *CopyJob) SetSourceRecoveryPointArn(v string) *CopyJob {
	s.SourceRecoveryPointArn = &v
	return s
}

// SetState sets the State field's value.
func (s *CopyJob) SetState(v string) *CopyJob {
	s.State = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *CopyJob) SetStatusMessage(v string) *CopyJob {
	s.StatusMessage = &v
	return s
}

// This is a summary of copy jobs created or running within the most recent
// 30 days.
//
// The returned summary may contain the following: Region, Account, State, RestourceType,
// MessageCategory, StartTime, EndTime, and Count of included jobs.
type CopyJobSummary struct {
	_ struct{} `type:"structure"`

	// The account ID that owns the jobs within the summary.
	AccountId *string `type:"string"`

	// The value as a number of jobs in a job summary.
	Count *int64 `type:"integer"`

	// The value of time in number format of a job end time.
	//
	// This value is the time in Unix format, Coordinated Universal Time (UTC),
	// and accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	EndTime *time.Time `type:"timestamp"`

	// This parameter is the job count for the specified message category.
	//
	// Example strings include AccessDenied, Success, and InvalidParameters. See
	// Monitoring (https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
	// for a list of MessageCategory strings.
	//
	// The the value ANY returns count of all message categories.
	//
	// AGGREGATE_ALL aggregates job counts for all message categories and returns
	// the sum.
	MessageCategory *string `type:"string"`

	// This is the Amazon Web Services Regions within the job summary.
	Region *string `type:"string"`

	// This value is the job count for the specified resource type. The request
	// GetSupportedResourceTypes returns strings for supported resource types
	ResourceType *string `type:"string"`

	// The value of time in number format of a job start time.
	//
	// This value is the time in Unix format, Coordinated Universal Time (UTC),
	// and accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	StartTime *time.Time `type:"timestamp"`

	// This value is job count for jobs with the specified state.
	State *string `type:"string" enum:"CopyJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyJobSummary) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *CopyJobSummary) SetAccountId(v string) *CopyJobSummary {
	s.AccountId = &v
	return s
}

// SetCount sets the Count field's value.
func (s *CopyJobSummary) SetCount(v int64) *CopyJobSummary {
	s.Count = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CopyJobSummary) SetEndTime(v time.Time) *CopyJobSummary {
	s.EndTime = &v
	return s
}

// SetMessageCategory sets the MessageCategory field's value.
func (s *CopyJobSummary) SetMessageCategory(v string) *CopyJobSummary {
	s.MessageCategory = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *CopyJobSummary) SetRegion(v string) *CopyJobSummary {
	s.Region = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *CopyJobSummary) SetResourceType(v string) *CopyJobSummary {
	s.ResourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CopyJobSummary) SetStartTime(v time.Time) *CopyJobSummary {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *CopyJobSummary) SetState(v string) *CopyJobSummary {
	s.State = &v
	return s
}

type CreateBackupPlanInput struct {
	_ struct{} `type:"structure"`

	// Specifies the body of a backup plan. Includes a BackupPlanName and one or
	// more sets of Rules.
	//
	// BackupPlan is a required field
	BackupPlan *PlanInput `type:"structure" required:"true"`

	// To help organize your resources, you can assign your own metadata to the
	// resources that you create. Each tag is a key-value pair. The specified tags
	// are assigned to all backups created with this plan.
	//
	// BackupPlanTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateBackupPlanInput's
	// String and GoString methods.
	BackupPlanTags map[string]*string `type:"map" sensitive:"true"`

	// Identifies the request and allows failed requests to be retried without the
	// risk of running the operation twice. If the request includes a CreatorRequestId
	// that matches an existing backup plan, that plan is returned. This parameter
	// is optional.
	//
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackupPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackupPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackupPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackupPlanInput"}
	if s.BackupPlan == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlan"))
	}
	if s.BackupPlan != nil {
		if err := s.BackupPlan.Validate(); err != nil {
			invalidParams.AddNested("BackupPlan", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPlan sets the BackupPlan field's value.
func (s *CreateBackupPlanInput) SetBackupPlan(v *PlanInput) *CreateBackupPlanInput {
	s.BackupPlan = v
	return s
}

// SetBackupPlanTags sets the BackupPlanTags field's value.
func (s *CreateBackupPlanInput) SetBackupPlanTags(v map[string]*string) *CreateBackupPlanInput {
	s.BackupPlanTags = v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateBackupPlanInput) SetCreatorRequestId(v string) *CreateBackupPlanInput {
	s.CreatorRequestId = &v
	return s
}

type CreateBackupPlanOutput struct {
	_ struct{} `type:"structure"`

	// A list of BackupOptions settings for a resource type. This option is only
	// available for Windows Volume Shadow Copy Service (VSS) backup jobs.
	AdvancedBackupSettings []*AdvancedBackupSetting `type:"list"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for
	// example, arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50.
	BackupPlanArn *string `type:"string"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// The date and time that a backup plan is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most
	// 1,024 bytes long. They cannot be edited.
	VersionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackupPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackupPlanOutput) GoString() string {
	return s.String()
}

// SetAdvancedBackupSettings sets the AdvancedBackupSettings field's value.
func (s *CreateBackupPlanOutput) SetAdvancedBackupSettings(v []*AdvancedBackupSetting) *CreateBackupPlanOutput {
	s.AdvancedBackupSettings = v
	return s
}

// SetBackupPlanArn sets the BackupPlanArn field's value.
func (s *CreateBackupPlanOutput) SetBackupPlanArn(v string) *CreateBackupPlanOutput {
	s.BackupPlanArn = &v
	return s
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *CreateBackupPlanOutput) SetBackupPlanId(v string) *CreateBackupPlanOutput {
	s.BackupPlanId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CreateBackupPlanOutput) SetCreationDate(v time.Time) *CreateBackupPlanOutput {
	s.CreationDate = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CreateBackupPlanOutput) SetVersionId(v string) *CreateBackupPlanOutput {
	s.VersionId = &v
	return s
}

type CreateBackupSelectionInput struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies the backup plan to be associated with the selection of
	// resources.
	//
	// BackupPlanId is a required field
	BackupPlanId *string `location:"uri" locationName:"backupPlanId" type:"string" required:"true"`

	// Specifies the body of a request to assign a set of resources to a backup
	// plan.
	//
	// BackupSelection is a required field
	BackupSelection *Selection `type:"structure" required:"true"`

	// A unique string that identifies the request and allows failed requests to
	// be retried without the risk of running the operation twice. This parameter
	// is optional.
	//
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackupSelectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackupSelectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackupSelectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackupSelectionInput"}
	if s.BackupPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlanId"))
	}
	if s.BackupPlanId != nil && len(*s.BackupPlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupPlanId", 1))
	}
	if s.BackupSelection == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupSelection"))
	}
	if s.BackupSelection != nil {
		if err := s.BackupSelection.Validate(); err != nil {
			invalidParams.AddNested("BackupSelection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *CreateBackupSelectionInput) SetBackupPlanId(v string) *CreateBackupSelectionInput {
	s.BackupPlanId = &v
	return s
}

// SetBackupSelection sets the BackupSelection field's value.
func (s *CreateBackupSelectionInput) SetBackupSelection(v *Selection) *CreateBackupSelectionInput {
	s.BackupSelection = v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateBackupSelectionInput) SetCreatorRequestId(v string) *CreateBackupSelectionInput {
	s.CreatorRequestId = &v
	return s
}

type CreateBackupSelectionOutput struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// The date and time a backup selection is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// Uniquely identifies the body of a request to assign a set of resources to
	// a backup plan.
	SelectionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackupSelectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackupSelectionOutput) GoString() string {
	return s.String()
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *CreateBackupSelectionOutput) SetBackupPlanId(v string) *CreateBackupSelectionOutput {
	s.BackupPlanId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CreateBackupSelectionOutput) SetCreationDate(v time.Time) *CreateBackupSelectionOutput {
	s.CreationDate = &v
	return s
}

// SetSelectionId sets the SelectionId field's value.
func (s *CreateBackupSelectionOutput) SetSelectionId(v string) *CreateBackupSelectionOutput {
	s.SelectionId = &v
	return s
}

type CreateBackupVaultInput struct {
	_ struct{} `type:"structure"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of letters,
	// numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// Metadata that you can assign to help organize the resources that you create.
	// Each tag is a key-value pair.
	//
	// BackupVaultTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateBackupVaultInput's
	// String and GoString methods.
	BackupVaultTags map[string]*string `type:"map" sensitive:"true"`

	// A unique string that identifies the request and allows failed requests to
	// be retried without the risk of running the operation twice. This parameter
	// is optional.
	//
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string `type:"string"`

	// The server-side encryption key that is used to protect your backups; for
	// example, arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	EncryptionKeyArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackupVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackupVaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackupVaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackupVaultInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *CreateBackupVaultInput) SetBackupVaultName(v string) *CreateBackupVaultInput {
	s.BackupVaultName = &v
	return s
}

// SetBackupVaultTags sets the BackupVaultTags field's value.
func (s *CreateBackupVaultInput) SetBackupVaultTags(v map[string]*string) *CreateBackupVaultInput {
	s.BackupVaultTags = v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateBackupVaultInput) SetCreatorRequestId(v string) *CreateBackupVaultInput {
	s.CreatorRequestId = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *CreateBackupVaultInput) SetEncryptionKeyArn(v string) *CreateBackupVaultInput {
	s.EncryptionKeyArn = &v
	return s
}

type CreateBackupVaultOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Region where they are created. They consist of lowercase letters, numbers,
	// and hyphens.
	BackupVaultName *string `type:"string"`

	// The date and time a backup vault is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackupVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBackupVaultOutput) GoString() string {
	return s.String()
}

// SetBackupVaultArn sets the BackupVaultArn field's value.
func (s *CreateBackupVaultOutput) SetBackupVaultArn(v string) *CreateBackupVaultOutput {
	s.BackupVaultArn = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *CreateBackupVaultOutput) SetBackupVaultName(v string) *CreateBackupVaultOutput {
	s.BackupVaultName = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CreateBackupVaultOutput) SetCreationDate(v time.Time) *CreateBackupVaultOutput {
	s.CreationDate = &v
	return s
}

type CreateFrameworkInput struct {
	_ struct{} `type:"structure"`

	// A list of the controls that make up the framework. Each control in the list
	// has a name, input parameters, and scope.
	//
	// FrameworkControls is a required field
	FrameworkControls []*FrameworkControl `type:"list" required:"true"`

	// An optional description of the framework with a maximum of 1,024 characters.
	FrameworkDescription *string `type:"string"`

	// The unique name of the framework. The name must be between 1 and 256 characters,
	// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9),
	// and underscores (_).
	//
	// FrameworkName is a required field
	FrameworkName *string `min:"1" type:"string" required:"true"`

	// Metadata that you can assign to help organize the frameworks that you create.
	// Each tag is a key-value pair.
	FrameworkTags map[string]*string `type:"map"`

	// A customer-chosen string that you can use to distinguish between otherwise
	// identical calls to CreateFrameworkInput. Retrying a successful request with
	// the same idempotency token results in a success message with no action taken.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFrameworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFrameworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFrameworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFrameworkInput"}
	if s.FrameworkControls == nil {
		invalidParams.Add(request.NewErrParamRequired("FrameworkControls"))
	}
	if s.FrameworkName == nil {
		invalidParams.Add(request.NewErrParamRequired("FrameworkName"))
	}
	if s.FrameworkName != nil && len(*s.FrameworkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FrameworkName", 1))
	}
	if s.FrameworkControls != nil {
		for i, v := range s.FrameworkControls {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "FrameworkControls", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFrameworkControls sets the FrameworkControls field's value.
func (s *CreateFrameworkInput) SetFrameworkControls(v []*FrameworkControl) *CreateFrameworkInput {
	s.FrameworkControls = v
	return s
}

// SetFrameworkDescription sets the FrameworkDescription field's value.
func (s *CreateFrameworkInput) SetFrameworkDescription(v string) *CreateFrameworkInput {
	s.FrameworkDescription = &v
	return s
}

// SetFrameworkName sets the FrameworkName field's value.
func (s *CreateFrameworkInput) SetFrameworkName(v string) *CreateFrameworkInput {
	s.FrameworkName = &v
	return s
}

// SetFrameworkTags sets the FrameworkTags field's value.
func (s *CreateFrameworkInput) SetFrameworkTags(v map[string]*string) *CreateFrameworkInput {
	s.FrameworkTags = v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateFrameworkInput) SetIdempotencyToken(v string) *CreateFrameworkInput {
	s.IdempotencyToken = &v
	return s
}

type CreateFrameworkOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	FrameworkArn *string `type:"string"`

	// The unique name of the framework. The name must be between 1 and 256 characters,
	// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9),
	// and underscores (_).
	FrameworkName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFrameworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateFrameworkOutput) GoString() string {
	return s.String()
}

// SetFrameworkArn sets the FrameworkArn field's value.
func (s *CreateFrameworkOutput) SetFrameworkArn(v string) *CreateFrameworkOutput {
	s.FrameworkArn = &v
	return s
}

// SetFrameworkName sets the FrameworkName field's value.
func (s *CreateFrameworkOutput) SetFrameworkName(v string) *CreateFrameworkOutput {
	s.FrameworkName = &v
	return s
}

type CreateLegalHoldInput struct {
	_ struct{} `type:"structure"`

	// This is the string description of the legal hold.
	//
	// Description is a required field
	Description *string `type:"string" required:"true"`

	// This is a user-chosen string used to distinguish between otherwise identical
	// calls. Retrying a successful request with the same idempotency token results
	// in a success message with no action taken.
	IdempotencyToken *string `type:"string"`

	// This specifies criteria to assign a set of resources, such as resource types
	// or backup vaults.
	RecoveryPointSelection *RecoveryPointSelection `type:"structure"`

	// Optional tags to include. A tag is a key-value pair you can use to manage,
	// filter, and search for your resources. Allowed characters include UTF-8 letters,
	// numbers, spaces, and the following characters: + - = . _ : /.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateLegalHoldInput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`

	// This is the string title of the legal hold.
	//
	// Title is a required field
	Title *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLegalHoldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLegalHoldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLegalHoldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLegalHoldInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.RecoveryPointSelection != nil {
		if err := s.RecoveryPointSelection.Validate(); err != nil {
			invalidParams.AddNested("RecoveryPointSelection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateLegalHoldInput) SetDescription(v string) *CreateLegalHoldInput {
	s.Description = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateLegalHoldInput) SetIdempotencyToken(v string) *CreateLegalHoldInput {
	s.IdempotencyToken = &v
	return s
}

// SetRecoveryPointSelection sets the RecoveryPointSelection field's value.
func (s *CreateLegalHoldInput) SetRecoveryPointSelection(v *RecoveryPointSelection) *CreateLegalHoldInput {
	s.RecoveryPointSelection = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateLegalHoldInput) SetTags(v map[string]*string) *CreateLegalHoldInput {
	s.Tags = v
	return s
}

// SetTitle sets the Title field's value.
func (s *CreateLegalHoldInput) SetTitle(v string) *CreateLegalHoldInput {
	s.Title = &v
	return s
}

type CreateLegalHoldOutput struct {
	_ struct{} `type:"structure"`

	// Time in number format when legal hold was created.
	CreationDate *time.Time `type:"timestamp"`

	// This is the returned string description of the legal hold.
	Description *string `type:"string"`

	// This is the ARN (Amazon Resource Number) of the created legal hold.
	LegalHoldArn *string `type:"string"`

	// Legal hold ID returned for the specified legal hold on a recovery point.
	LegalHoldId *string `type:"string"`

	// This specifies criteria to assign a set of resources, such as resource types
	// or backup vaults.
	RecoveryPointSelection *RecoveryPointSelection `type:"structure"`

	// This displays the status of the legal hold returned after creating the legal
	// hold. Statuses can be ACTIVE, PENDING, CANCELED, CANCELING, or FAILED.
	Status *string `type:"string" enum:"LegalHoldStatus"`

	// This is the string title of the legal hold returned after creating the legal
	// hold.
	Title *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLegalHoldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLegalHoldOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *CreateLegalHoldOutput) SetCreationDate(v time.Time) *CreateLegalHoldOutput {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateLegalHoldOutput) SetDescription(v string) *CreateLegalHoldOutput {
	s.Description = &v
	return s
}

// SetLegalHoldArn sets the LegalHoldArn field's value.
func (s *CreateLegalHoldOutput) SetLegalHoldArn(v string) *CreateLegalHoldOutput {
	s.LegalHoldArn = &v
	return s
}

// SetLegalHoldId sets the LegalHoldId field's value.
func (s *CreateLegalHoldOutput) SetLegalHoldId(v string) *CreateLegalHoldOutput {
	s.LegalHoldId = &v
	return s
}

// SetRecoveryPointSelection sets the RecoveryPointSelection field's value.
func (s *CreateLegalHoldOutput) SetRecoveryPointSelection(v *RecoveryPointSelection) *CreateLegalHoldOutput {
	s.RecoveryPointSelection = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateLegalHoldOutput) SetStatus(v string) *CreateLegalHoldOutput {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *CreateLegalHoldOutput) SetTitle(v string) *CreateLegalHoldOutput {
	s.Title = &v
	return s
}

type CreateLogicallyAirGappedBackupVaultInput struct {
	_ struct{} `type:"structure"`

	// This is the name of the vault that is being created.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// These are the tags that will be included in the newly-created vault.
	//
	// BackupVaultTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateLogicallyAirGappedBackupVaultInput's
	// String and GoString methods.
	BackupVaultTags map[string]*string `type:"map" sensitive:"true"`

	// This is the ID of the creation request.
	//
	// This parameter is optional. If used, this parameter must contain 1 to 50
	// alphanumeric or '-_.' characters.
	CreatorRequestId *string `type:"string"`

	// This is the setting that specifies the maximum retention period that the
	// vault retains its recovery points. If this parameter is not specified, Backup
	// does not enforce a maximum retention period on the recovery points in the
	// vault (allowing indefinite storage).
	//
	// If specified, any backup or copy job to the vault must have a lifecycle policy
	// with a retention period equal to or shorter than the maximum retention period.
	// If the job retention period is longer than that maximum retention period,
	// then the vault fails the backup or copy job, and you should either modify
	// your lifecycle settings or use a different vault.
	//
	// MaxRetentionDays is a required field
	MaxRetentionDays *int64 `type:"long" required:"true"`

	// This setting specifies the minimum retention period that the vault retains
	// its recovery points. If this parameter is not specified, no minimum retention
	// period is enforced.
	//
	// If specified, any backup or copy job to the vault must have a lifecycle policy
	// with a retention period equal to or longer than the minimum retention period.
	// If a job retention period is shorter than that minimum retention period,
	// then the vault fails the backup or copy job, and you should either modify
	// your lifecycle settings or use a different vault.
	//
	// MinRetentionDays is a required field
	MinRetentionDays *int64 `type:"long" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLogicallyAirGappedBackupVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLogicallyAirGappedBackupVaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateLogicallyAirGappedBackupVaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateLogicallyAirGappedBackupVaultInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}
	if s.MaxRetentionDays == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxRetentionDays"))
	}
	if s.MinRetentionDays == nil {
		invalidParams.Add(request.NewErrParamRequired("MinRetentionDays"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *CreateLogicallyAirGappedBackupVaultInput) SetBackupVaultName(v string) *CreateLogicallyAirGappedBackupVaultInput {
	s.BackupVaultName = &v
	return s
}

// SetBackupVaultTags sets the BackupVaultTags field's value.
func (s *CreateLogicallyAirGappedBackupVaultInput) SetBackupVaultTags(v map[string]*string) *CreateLogicallyAirGappedBackupVaultInput {
	s.BackupVaultTags = v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateLogicallyAirGappedBackupVaultInput) SetCreatorRequestId(v string) *CreateLogicallyAirGappedBackupVaultInput {
	s.CreatorRequestId = &v
	return s
}

// SetMaxRetentionDays sets the MaxRetentionDays field's value.
func (s *CreateLogicallyAirGappedBackupVaultInput) SetMaxRetentionDays(v int64) *CreateLogicallyAirGappedBackupVaultInput {
	s.MaxRetentionDays = &v
	return s
}

// SetMinRetentionDays sets the MinRetentionDays field's value.
func (s *CreateLogicallyAirGappedBackupVaultInput) SetMinRetentionDays(v int64) *CreateLogicallyAirGappedBackupVaultInput {
	s.MinRetentionDays = &v
	return s
}

type CreateLogicallyAirGappedBackupVaultOutput struct {
	_ struct{} `type:"structure"`

	// This is the ARN (Amazon Resource Name) of the vault being created.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Logically air-gapped
	// backup vaults are identified by names that are unique to the account used
	// to create them and the Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	BackupVaultName *string `type:"string"`

	// The date and time when the vault was created.
	//
	// This value is in Unix format, Coordinated Universal Time (UTC), and accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// This is the current state of the vault.
	VaultState *string `type:"string" enum:"VaultState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLogicallyAirGappedBackupVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateLogicallyAirGappedBackupVaultOutput) GoString() string {
	return s.String()
}

// SetBackupVaultArn sets the BackupVaultArn field's value.
func (s *CreateLogicallyAirGappedBackupVaultOutput) SetBackupVaultArn(v string) *CreateLogicallyAirGappedBackupVaultOutput {
	s.BackupVaultArn = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *CreateLogicallyAirGappedBackupVaultOutput) SetBackupVaultName(v string) *CreateLogicallyAirGappedBackupVaultOutput {
	s.BackupVaultName = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CreateLogicallyAirGappedBackupVaultOutput) SetCreationDate(v time.Time) *CreateLogicallyAirGappedBackupVaultOutput {
	s.CreationDate = &v
	return s
}

// SetVaultState sets the VaultState field's value.
func (s *CreateLogicallyAirGappedBackupVaultOutput) SetVaultState(v string) *CreateLogicallyAirGappedBackupVaultOutput {
	s.VaultState = &v
	return s
}

type CreateReportPlanInput struct {
	_ struct{} `type:"structure"`

	// A customer-chosen string that you can use to distinguish between otherwise
	// identical calls to CreateReportPlanInput. Retrying a successful request with
	// the same idempotency token results in a success message with no action taken.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// A structure that contains information about where and how to deliver your
	// reports, specifically your Amazon S3 bucket name, S3 key prefix, and the
	// formats of your reports.
	//
	// ReportDeliveryChannel is a required field
	ReportDeliveryChannel *ReportDeliveryChannel `type:"structure" required:"true"`

	// An optional description of the report plan with a maximum of 1,024 characters.
	ReportPlanDescription *string `type:"string"`

	// The unique name of the report plan. The name must be between 1 and 256 characters,
	// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9),
	// and underscores (_).
	//
	// ReportPlanName is a required field
	ReportPlanName *string `min:"1" type:"string" required:"true"`

	// Metadata that you can assign to help organize the report plans that you create.
	// Each tag is a key-value pair.
	ReportPlanTags map[string]*string `type:"map"`

	// Identifies the report template for the report. Reports are built using a
	// report template. The report templates are:
	//
	// RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT
	// | COPY_JOB_REPORT | RESTORE_JOB_REPORT
	//
	// If the report template is RESOURCE_COMPLIANCE_REPORT or CONTROL_COMPLIANCE_REPORT,
	// this API resource also describes the report coverage by Amazon Web Services
	// Regions and frameworks.
	//
	// ReportSetting is a required field
	ReportSetting *ReportSetting `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReportPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReportPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReportPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReportPlanInput"}
	if s.ReportDeliveryChannel == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportDeliveryChannel"))
	}
	if s.ReportPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportPlanName"))
	}
	if s.ReportPlanName != nil && len(*s.ReportPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportPlanName", 1))
	}
	if s.ReportSetting == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportSetting"))
	}
	if s.ReportDeliveryChannel != nil {
		if err := s.ReportDeliveryChannel.Validate(); err != nil {
			invalidParams.AddNested("ReportDeliveryChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.ReportSetting != nil {
		if err := s.ReportSetting.Validate(); err != nil {
			invalidParams.AddNested("ReportSetting", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *CreateReportPlanInput) SetIdempotencyToken(v string) *CreateReportPlanInput {
	s.IdempotencyToken = &v
	return s
}

// SetReportDeliveryChannel sets the ReportDeliveryChannel field's value.
func (s *CreateReportPlanInput) SetReportDeliveryChannel(v *ReportDeliveryChannel) *CreateReportPlanInput {
	s.ReportDeliveryChannel = v
	return s
}

// SetReportPlanDescription sets the ReportPlanDescription field's value.
func (s *CreateReportPlanInput) SetReportPlanDescription(v string) *CreateReportPlanInput {
	s.ReportPlanDescription = &v
	return s
}

// SetReportPlanName sets the ReportPlanName field's value.
func (s *CreateReportPlanInput) SetReportPlanName(v string) *CreateReportPlanInput {
	s.ReportPlanName = &v
	return s
}

// SetReportPlanTags sets the ReportPlanTags field's value.
func (s *CreateReportPlanInput) SetReportPlanTags(v map[string]*string) *CreateReportPlanInput {
	s.ReportPlanTags = v
	return s
}

// SetReportSetting sets the ReportSetting field's value.
func (s *CreateReportPlanInput) SetReportSetting(v *ReportSetting) *CreateReportPlanInput {
	s.ReportSetting = v
	return s
}

type CreateReportPlanOutput struct {
	_ struct{} `type:"structure"`

	// The date and time a backup vault is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationTime *time.Time `type:"timestamp"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	ReportPlanArn *string `type:"string"`

	// The unique name of the report plan.
	ReportPlanName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReportPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateReportPlanOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateReportPlanOutput) SetCreationTime(v time.Time) *CreateReportPlanOutput {
	s.CreationTime = &v
	return s
}

// SetReportPlanArn sets the ReportPlanArn field's value.
func (s *CreateReportPlanOutput) SetReportPlanArn(v string) *CreateReportPlanOutput {
	s.ReportPlanArn = &v
	return s
}

// SetReportPlanName sets the ReportPlanName field's value.
func (s *CreateReportPlanOutput) SetReportPlanName(v string) *CreateReportPlanOutput {
	s.ReportPlanName = &v
	return s
}

type CreateRestoreTestingPlanInput struct {
	_ struct{} `type:"structure"`

	// This is a unique string that identifies the request and allows failed requests
	// to be retriedwithout the risk of running the operation twice. This parameter
	// is optional. If used, this parameter must contain 1 to 50 alphanumeric or
	// '-_.' characters.
	CreatorRequestId *string `type:"string"`

	// A restore testing plan must contain a unique RestoreTestingPlanName string
	// you create and must contain a ScheduleExpression cron. You may optionally
	// include a StartWindowHours integer and a CreatorRequestId string.
	//
	// The RestoreTestingPlanName is a unique string that is the name of the restore
	// testing plan. This cannot be changed after creation, and it must consist
	// of only alphanumeric characters and underscores.
	//
	// RestoreTestingPlan is a required field
	RestoreTestingPlan *RestoreTestingPlanForCreate `type:"structure" required:"true"`

	// Optional tags to include. A tag is a key-value pair you can use to manage,
	// filter, and search for your resources. Allowed characters include UTF-8 letters,numbers,
	// spaces, and the following characters: + - = . _ : /.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateRestoreTestingPlanInput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRestoreTestingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRestoreTestingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRestoreTestingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRestoreTestingPlanInput"}
	if s.RestoreTestingPlan == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreTestingPlan"))
	}
	if s.RestoreTestingPlan != nil {
		if err := s.RestoreTestingPlan.Validate(); err != nil {
			invalidParams.AddNested("RestoreTestingPlan", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateRestoreTestingPlanInput) SetCreatorRequestId(v string) *CreateRestoreTestingPlanInput {
	s.CreatorRequestId = &v
	return s
}

// SetRestoreTestingPlan sets the RestoreTestingPlan field's value.
func (s *CreateRestoreTestingPlanInput) SetRestoreTestingPlan(v *RestoreTestingPlanForCreate) *CreateRestoreTestingPlanInput {
	s.RestoreTestingPlan = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRestoreTestingPlanInput) SetTags(v map[string]*string) *CreateRestoreTestingPlanInput {
	s.Tags = v
	return s
}

type CreateRestoreTestingPlanOutput struct {
	_ struct{} `type:"structure"`

	// The date and time a restore testing plan was created, in Unix format and
	// Coordinated Universal Time (UTC). The value of CreationTime is accurate to
	// milliseconds. For example, the value 1516925490.087 represents Friday, January
	// 26, 2018 12:11:30.087AM.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// An Amazon Resource Name (ARN) that uniquely identifies the created restore
	// testing plan.
	//
	// RestoreTestingPlanArn is a required field
	RestoreTestingPlanArn *string `type:"string" required:"true"`

	// This unique string is the name of the restore testing plan.
	//
	// The name cannot be changed after creation. The name consists of only alphanumeric
	// characters and underscores. Maximum length is 50.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRestoreTestingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRestoreTestingPlanOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateRestoreTestingPlanOutput) SetCreationTime(v time.Time) *CreateRestoreTestingPlanOutput {
	s.CreationTime = &v
	return s
}

// SetRestoreTestingPlanArn sets the RestoreTestingPlanArn field's value.
func (s *CreateRestoreTestingPlanOutput) SetRestoreTestingPlanArn(v string) *CreateRestoreTestingPlanOutput {
	s.RestoreTestingPlanArn = &v
	return s
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *CreateRestoreTestingPlanOutput) SetRestoreTestingPlanName(v string) *CreateRestoreTestingPlanOutput {
	s.RestoreTestingPlanName = &v
	return s
}

type CreateRestoreTestingSelectionInput struct {
	_ struct{} `type:"structure"`

	// This is an optional unique string that identifies the request and allows
	// failed requests to be retried without the risk of running the operation twice.
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string `type:"string"`

	// Input the restore testing plan name that was returned from the related CreateRestoreTestingPlan
	// request.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `location:"uri" locationName:"RestoreTestingPlanName" type:"string" required:"true"`

	// This consists of RestoreTestingSelectionName, ProtectedResourceType, and
	// one of the following:
	//
	//    * ProtectedResourceArns
	//
	//    * ProtectedResourceConditions
	//
	// Each protected resource type can have one single value.
	//
	// A restore testing selection can include a wildcard value ("*") for ProtectedResourceArns
	// along with ProtectedResourceConditions. Alternatively, you can include up
	// to 30 specific protected resource ARNs in ProtectedResourceArns.
	//
	// RestoreTestingSelection is a required field
	RestoreTestingSelection *RestoreTestingSelectionForCreate `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRestoreTestingSelectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRestoreTestingSelectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRestoreTestingSelectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRestoreTestingSelectionInput"}
	if s.RestoreTestingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreTestingPlanName"))
	}
	if s.RestoreTestingPlanName != nil && len(*s.RestoreTestingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestoreTestingPlanName", 1))
	}
	if s.RestoreTestingSelection == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreTestingSelection"))
	}
	if s.RestoreTestingSelection != nil {
		if err := s.RestoreTestingSelection.Validate(); err != nil {
			invalidParams.AddNested("RestoreTestingSelection", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateRestoreTestingSelectionInput) SetCreatorRequestId(v string) *CreateRestoreTestingSelectionInput {
	s.CreatorRequestId = &v
	return s
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *CreateRestoreTestingSelectionInput) SetRestoreTestingPlanName(v string) *CreateRestoreTestingSelectionInput {
	s.RestoreTestingPlanName = &v
	return s
}

// SetRestoreTestingSelection sets the RestoreTestingSelection field's value.
func (s *CreateRestoreTestingSelectionInput) SetRestoreTestingSelection(v *RestoreTestingSelectionForCreate) *CreateRestoreTestingSelectionInput {
	s.RestoreTestingSelection = v
	return s
}

type CreateRestoreTestingSelectionOutput struct {
	_ struct{} `type:"structure"`

	// This is the time the resource testing selection was created successfully.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// This is the ARN of the restore testing plan with which the restore testing
	// selection is associated.
	//
	// RestoreTestingPlanArn is a required field
	RestoreTestingPlanArn *string `type:"string" required:"true"`

	// Unique string that is the name of the restore testing plan.
	//
	// The name cannot be changed after creation. The name consists of only alphanumeric
	// characters and underscores. Maximum length is 50.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `type:"string" required:"true"`

	// This is the unique name of the restore testing selection that belongs to
	// the related restore testing plan.
	//
	// RestoreTestingSelectionName is a required field
	RestoreTestingSelectionName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRestoreTestingSelectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRestoreTestingSelectionOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *CreateRestoreTestingSelectionOutput) SetCreationTime(v time.Time) *CreateRestoreTestingSelectionOutput {
	s.CreationTime = &v
	return s
}

// SetRestoreTestingPlanArn sets the RestoreTestingPlanArn field's value.
func (s *CreateRestoreTestingSelectionOutput) SetRestoreTestingPlanArn(v string) *CreateRestoreTestingSelectionOutput {
	s.RestoreTestingPlanArn = &v
	return s
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *CreateRestoreTestingSelectionOutput) SetRestoreTestingPlanName(v string) *CreateRestoreTestingSelectionOutput {
	s.RestoreTestingPlanName = &v
	return s
}

// SetRestoreTestingSelectionName sets the RestoreTestingSelectionName field's value.
func (s *CreateRestoreTestingSelectionOutput) SetRestoreTestingSelectionName(v string) *CreateRestoreTestingSelectionOutput {
	s.RestoreTestingSelectionName = &v
	return s
}

// This is a resource filter containing FromDate: DateTime and ToDate: DateTime.
// Both values are required. Future DateTime values are not permitted.
//
// The date and time are in Unix format and Coordinated Universal Time (UTC),
// and it is accurate to milliseconds ((milliseconds are optional). For example,
// the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
// AM.
type DateRange struct {
	_ struct{} `type:"structure"`

	// This value is the beginning date, inclusive.
	//
	// The date and time are in Unix format and Coordinated Universal Time (UTC),
	// and it is accurate to milliseconds (milliseconds are optional).
	//
	// FromDate is a required field
	FromDate *time.Time `type:"timestamp" required:"true"`

	// This value is the end date, inclusive.
	//
	// The date and time are in Unix format and Coordinated Universal Time (UTC),
	// and it is accurate to milliseconds (milliseconds are optional).
	//
	// ToDate is a required field
	ToDate *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateRange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DateRange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DateRange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DateRange"}
	if s.FromDate == nil {
		invalidParams.Add(request.NewErrParamRequired("FromDate"))
	}
	if s.ToDate == nil {
		invalidParams.Add(request.NewErrParamRequired("ToDate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFromDate sets the FromDate field's value.
func (s *DateRange) SetFromDate(v time.Time) *DateRange {
	s.FromDate = &v
	return s
}

// SetToDate sets the ToDate field's value.
func (s *DateRange) SetToDate(v time.Time) *DateRange {
	s.ToDate = &v
	return s
}

type DeleteBackupPlanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Uniquely identifies a backup plan.
	//
	// BackupPlanId is a required field
	BackupPlanId *string `location:"uri" locationName:"backupPlanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackupPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackupPlanInput"}
	if s.BackupPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlanId"))
	}
	if s.BackupPlanId != nil && len(*s.BackupPlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupPlanId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *DeleteBackupPlanInput) SetBackupPlanId(v string) *DeleteBackupPlanInput {
	s.BackupPlanId = &v
	return s
}

type DeleteBackupPlanOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for
	// example, arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50.
	BackupPlanArn *string `type:"string"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// The date and time a backup plan is deleted, in Unix format and Coordinated
	// Universal Time (UTC). The value of DeletionDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	DeletionDate *time.Time `type:"timestamp"`

	// Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most
	// 1,024 bytes long. Version IDs cannot be edited.
	VersionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupPlanOutput) GoString() string {
	return s.String()
}

// SetBackupPlanArn sets the BackupPlanArn field's value.
func (s *DeleteBackupPlanOutput) SetBackupPlanArn(v string) *DeleteBackupPlanOutput {
	s.BackupPlanArn = &v
	return s
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *DeleteBackupPlanOutput) SetBackupPlanId(v string) *DeleteBackupPlanOutput {
	s.BackupPlanId = &v
	return s
}

// SetDeletionDate sets the DeletionDate field's value.
func (s *DeleteBackupPlanOutput) SetDeletionDate(v time.Time) *DeleteBackupPlanOutput {
	s.DeletionDate = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeleteBackupPlanOutput) SetVersionId(v string) *DeleteBackupPlanOutput {
	s.VersionId = &v
	return s
}

type DeleteBackupSelectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Uniquely identifies a backup plan.
	//
	// BackupPlanId is a required field
	BackupPlanId *string `location:"uri" locationName:"backupPlanId" type:"string" required:"true"`

	// Uniquely identifies the body of a request to assign a set of resources to
	// a backup plan.
	//
	// SelectionId is a required field
	SelectionId *string `location:"uri" locationName:"selectionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupSelectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupSelectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackupSelectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackupSelectionInput"}
	if s.BackupPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlanId"))
	}
	if s.BackupPlanId != nil && len(*s.BackupPlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupPlanId", 1))
	}
	if s.SelectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectionId"))
	}
	if s.SelectionId != nil && len(*s.SelectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SelectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *DeleteBackupSelectionInput) SetBackupPlanId(v string) *DeleteBackupSelectionInput {
	s.BackupPlanId = &v
	return s
}

// SetSelectionId sets the SelectionId field's value.
func (s *DeleteBackupSelectionInput) SetSelectionId(v string) *DeleteBackupSelectionInput {
	s.SelectionId = &v
	return s
}

type DeleteBackupSelectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupSelectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupSelectionOutput) GoString() string {
	return s.String()
}

type DeleteBackupVaultAccessPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackupVaultAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackupVaultAccessPolicyInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *DeleteBackupVaultAccessPolicyInput) SetBackupVaultName(v string) *DeleteBackupVaultAccessPolicyInput {
	s.BackupVaultName = &v
	return s
}

type DeleteBackupVaultAccessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultAccessPolicyOutput) GoString() string {
	return s.String()
}

type DeleteBackupVaultInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackupVaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackupVaultInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *DeleteBackupVaultInput) SetBackupVaultName(v string) *DeleteBackupVaultInput {
	s.BackupVaultName = &v
	return s
}

type DeleteBackupVaultLockConfigurationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the backup vault from which to delete Backup Vault Lock.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultLockConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultLockConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackupVaultLockConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackupVaultLockConfigurationInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *DeleteBackupVaultLockConfigurationInput) SetBackupVaultName(v string) *DeleteBackupVaultLockConfigurationInput {
	s.BackupVaultName = &v
	return s
}

type DeleteBackupVaultLockConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultLockConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultLockConfigurationOutput) GoString() string {
	return s.String()
}

type DeleteBackupVaultNotificationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Region where they are created. They consist of lowercase letters, numbers,
	// and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultNotificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackupVaultNotificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackupVaultNotificationsInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *DeleteBackupVaultNotificationsInput) SetBackupVaultName(v string) *DeleteBackupVaultNotificationsInput {
	s.BackupVaultName = &v
	return s
}

type DeleteBackupVaultNotificationsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultNotificationsOutput) GoString() string {
	return s.String()
}

type DeleteBackupVaultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBackupVaultOutput) GoString() string {
	return s.String()
}

type DeleteFrameworkInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of a framework.
	//
	// FrameworkName is a required field
	FrameworkName *string `location:"uri" locationName:"frameworkName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFrameworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFrameworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFrameworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFrameworkInput"}
	if s.FrameworkName == nil {
		invalidParams.Add(request.NewErrParamRequired("FrameworkName"))
	}
	if s.FrameworkName != nil && len(*s.FrameworkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FrameworkName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFrameworkName sets the FrameworkName field's value.
func (s *DeleteFrameworkInput) SetFrameworkName(v string) *DeleteFrameworkInput {
	s.FrameworkName = &v
	return s
}

type DeleteFrameworkOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFrameworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteFrameworkOutput) GoString() string {
	return s.String()
}

type DeleteRecoveryPointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `location:"uri" locationName:"recoveryPointArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecoveryPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRecoveryPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRecoveryPointInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}
	if s.RecoveryPointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointArn"))
	}
	if s.RecoveryPointArn != nil && len(*s.RecoveryPointArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryPointArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *DeleteRecoveryPointInput) SetBackupVaultName(v string) *DeleteRecoveryPointInput {
	s.BackupVaultName = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *DeleteRecoveryPointInput) SetRecoveryPointArn(v string) *DeleteRecoveryPointInput {
	s.RecoveryPointArn = &v
	return s
}

type DeleteRecoveryPointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRecoveryPointOutput) GoString() string {
	return s.String()
}

type DeleteReportPlanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of a report plan.
	//
	// ReportPlanName is a required field
	ReportPlanName *string `location:"uri" locationName:"reportPlanName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReportPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReportPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReportPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReportPlanInput"}
	if s.ReportPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportPlanName"))
	}
	if s.ReportPlanName != nil && len(*s.ReportPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportPlanName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportPlanName sets the ReportPlanName field's value.
func (s *DeleteReportPlanInput) SetReportPlanName(v string) *DeleteReportPlanInput {
	s.ReportPlanName = &v
	return s
}

type DeleteReportPlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReportPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteReportPlanOutput) GoString() string {
	return s.String()
}

type DeleteRestoreTestingPlanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Required unique name of the restore testing plan you wish to delete.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `location:"uri" locationName:"RestoreTestingPlanName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRestoreTestingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRestoreTestingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRestoreTestingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRestoreTestingPlanInput"}
	if s.RestoreTestingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreTestingPlanName"))
	}
	if s.RestoreTestingPlanName != nil && len(*s.RestoreTestingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestoreTestingPlanName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *DeleteRestoreTestingPlanInput) SetRestoreTestingPlanName(v string) *DeleteRestoreTestingPlanInput {
	s.RestoreTestingPlanName = &v
	return s
}

type DeleteRestoreTestingPlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRestoreTestingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRestoreTestingPlanOutput) GoString() string {
	return s.String()
}

type DeleteRestoreTestingSelectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Required unique name of the restore testing plan that contains the restore
	// testing selection you wish to delete.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `location:"uri" locationName:"RestoreTestingPlanName" type:"string" required:"true"`

	// Required unique name of the restore testing selection you wish to delete.
	//
	// RestoreTestingSelectionName is a required field
	RestoreTestingSelectionName *string `location:"uri" locationName:"RestoreTestingSelectionName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRestoreTestingSelectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRestoreTestingSelectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRestoreTestingSelectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRestoreTestingSelectionInput"}
	if s.RestoreTestingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreTestingPlanName"))
	}
	if s.RestoreTestingPlanName != nil && len(*s.RestoreTestingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestoreTestingPlanName", 1))
	}
	if s.RestoreTestingSelectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreTestingSelectionName"))
	}
	if s.RestoreTestingSelectionName != nil && len(*s.RestoreTestingSelectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestoreTestingSelectionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *DeleteRestoreTestingSelectionInput) SetRestoreTestingPlanName(v string) *DeleteRestoreTestingSelectionInput {
	s.RestoreTestingPlanName = &v
	return s
}

// SetRestoreTestingSelectionName sets the RestoreTestingSelectionName field's value.
func (s *DeleteRestoreTestingSelectionInput) SetRestoreTestingSelectionName(v string) *DeleteRestoreTestingSelectionInput {
	s.RestoreTestingSelectionName = &v
	return s
}

type DeleteRestoreTestingSelectionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRestoreTestingSelectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRestoreTestingSelectionOutput) GoString() string {
	return s.String()
}

// A dependent Amazon Web Services service or resource returned an error to
// the Backup service, and the action cannot be completed.
type DependencyFailureException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Context *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyFailureException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DependencyFailureException) GoString() string {
	return s.String()
}

func newErrorDependencyFailureException(v protocol.ResponseMetadata) error {
	return &DependencyFailureException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DependencyFailureException) Code() string {
	return "DependencyFailureException"
}

// Message returns the exception's message.
func (s *DependencyFailureException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DependencyFailureException) OrigErr() error {
	return nil
}

func (s *DependencyFailureException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DependencyFailureException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DependencyFailureException) RequestID() string {
	return s.RespMetadata.RequestID
}

type DescribeBackupJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Uniquely identifies a request to Backup to back up a resource.
	//
	// BackupJobId is a required field
	BackupJobId *string `location:"uri" locationName:"backupJobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBackupJobInput"}
	if s.BackupJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupJobId"))
	}
	if s.BackupJobId != nil && len(*s.BackupJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupJobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupJobId sets the BackupJobId field's value.
func (s *DescribeBackupJobInput) SetBackupJobId(v string) *DescribeBackupJobInput {
	s.BackupJobId = &v
	return s
}

type DescribeBackupJobOutput struct {
	_ struct{} `type:"structure"`

	// Returns the account ID that owns the backup job.
	AccountId *string `type:"string"`

	// Uniquely identifies a request to Backup to back up a resource.
	BackupJobId *string `type:"string"`

	// Represents the options specified as part of backup plan or on-demand backup
	// job.
	BackupOptions map[string]*string `type:"map"`

	// The size, in bytes, of a backup.
	BackupSizeInBytes *int64 `type:"long"`

	// Represents the actual backup type selected for a backup job. For example,
	// if a successful Windows Volume Shadow Copy Service (VSS) backup was taken,
	// BackupType returns "WindowsVSS". If BackupType is empty, then the backup
	// type was a regular backup.
	BackupType *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	BackupVaultName *string `type:"string"`

	// The size in bytes transferred to a backup vault at the time that the job
	// status was queried.
	BytesTransferred *int64 `type:"long"`

	// This returns the statistics of the included child (nested) backup jobs.
	ChildJobsInState map[string]*int64 `type:"map"`

	// The date and time that a job to create a backup job is completed, in Unix
	// format and Coordinated Universal Time (UTC). The value of CompletionDate
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time `type:"timestamp"`

	// Contains identifying information about the creation of a backup job, including
	// the BackupPlanArn, BackupPlanId, BackupPlanVersion, and BackupRuleId of the
	// backup plan that is used to create it.
	CreatedBy *RecoveryPointCreator `type:"structure"`

	// The date and time that a backup job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// The date and time that a job to back up resources is expected to be completed,
	// in Unix format and Coordinated Universal Time (UTC). The value of ExpectedCompletionDate
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	ExpectedCompletionDate *time.Time `type:"timestamp"`

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// This is the date a backup job was initiated.
	InitiationDate *time.Time `type:"timestamp"`

	// This returns the boolean value that a backup job is a parent (composite)
	// job.
	IsParent *bool `type:"boolean"`

	// This is the job count for the specified message category.
	//
	// Example strings may include AccessDenied, SUCCESS, AGGREGATE_ALL, and INVALIDPARAMETERS.
	// View Monitoring (https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
	// for a list of accepted MessageCategory strings.
	MessageCategory *string `type:"string"`

	// This returns the number of child (nested) backup jobs.
	NumberOfChildJobs *int64 `type:"long"`

	// This returns the parent (composite) resource backup job ID.
	ParentJobId *string `type:"string"`

	// Contains an estimated percentage that is complete of a job at the time the
	// job status was queried.
	PercentDone *string `type:"string"`

	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// An ARN that uniquely identifies a saved resource. The format of the ARN depends
	// on the resource type.
	ResourceArn *string `type:"string"`

	// This is the non-unique name of the resource that belongs to the specified
	// backup.
	ResourceName *string `type:"string"`

	// The type of Amazon Web Services resource to be backed up; for example, an
	// Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database
	// Service (Amazon RDS) database.
	ResourceType *string `type:"string"`

	// Specifies the time in Unix format and Coordinated Universal Time (UTC) when
	// a backup job must be started before it is canceled. The value is calculated
	// by adding the start window to the scheduled time. So if the scheduled time
	// were 6:00 PM and the start window is 2 hours, the StartBy time would be 8:00
	// PM on the date specified. The value of StartBy is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	StartBy *time.Time `type:"timestamp"`

	// The current state of a backup job.
	State *string `type:"string" enum:"JobState"`

	// A detailed message explaining the status of the job to back up a resource.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupJobOutput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeBackupJobOutput) SetAccountId(v string) *DescribeBackupJobOutput {
	s.AccountId = &v
	return s
}

// SetBackupJobId sets the BackupJobId field's value.
func (s *DescribeBackupJobOutput) SetBackupJobId(v string) *DescribeBackupJobOutput {
	s.BackupJobId = &v
	return s
}

// SetBackupOptions sets the BackupOptions field's value.
func (s *DescribeBackupJobOutput) SetBackupOptions(v map[string]*string) *DescribeBackupJobOutput {
	s.BackupOptions = v
	return s
}

// SetBackupSizeInBytes sets the BackupSizeInBytes field's value.
func (s *DescribeBackupJobOutput) SetBackupSizeInBytes(v int64) *DescribeBackupJobOutput {
	s.BackupSizeInBytes = &v
	return s
}

// SetBackupType sets the BackupType field's value.
func (s *DescribeBackupJobOutput) SetBackupType(v string) *DescribeBackupJobOutput {
	s.BackupType = &v
	return s
}

// SetBackupVaultArn sets the BackupVaultArn field's value.
func (s *DescribeBackupJobOutput) SetBackupVaultArn(v string) *DescribeBackupJobOutput {
	s.BackupVaultArn = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *DescribeBackupJobOutput) SetBackupVaultName(v string) *DescribeBackupJobOutput {
	s.BackupVaultName = &v
	return s
}

// SetBytesTransferred sets the BytesTransferred field's value.
func (s *DescribeBackupJobOutput) SetBytesTransferred(v int64) *DescribeBackupJobOutput {
	s.BytesTransferred = &v
	return s
}

// SetChildJobsInState sets the ChildJobsInState field's value.
func (s *DescribeBackupJobOutput) SetChildJobsInState(v map[string]*int64) *DescribeBackupJobOutput {
	s.ChildJobsInState = v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *DescribeBackupJobOutput) SetCompletionDate(v time.Time) *DescribeBackupJobOutput {
	s.CompletionDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeBackupJobOutput) SetCreatedBy(v *RecoveryPointCreator) *DescribeBackupJobOutput {
	s.CreatedBy = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeBackupJobOutput) SetCreationDate(v time.Time) *DescribeBackupJobOutput {
	s.CreationDate = &v
	return s
}

// SetExpectedCompletionDate sets the ExpectedCompletionDate field's value.
func (s *DescribeBackupJobOutput) SetExpectedCompletionDate(v time.Time) *DescribeBackupJobOutput {
	s.ExpectedCompletionDate = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *DescribeBackupJobOutput) SetIamRoleArn(v string) *DescribeBackupJobOutput {
	s.IamRoleArn = &v
	return s
}

// SetInitiationDate sets the InitiationDate field's value.
func (s *DescribeBackupJobOutput) SetInitiationDate(v time.Time) *DescribeBackupJobOutput {
	s.InitiationDate = &v
	return s
}

// SetIsParent sets the IsParent field's value.
func (s *DescribeBackupJobOutput) SetIsParent(v bool) *DescribeBackupJobOutput {
	s.IsParent = &v
	return s
}

// SetMessageCategory sets the MessageCategory field's value.
func (s *DescribeBackupJobOutput) SetMessageCategory(v string) *DescribeBackupJobOutput {
	s.MessageCategory = &v
	return s
}

// SetNumberOfChildJobs sets the NumberOfChildJobs field's value.
func (s *DescribeBackupJobOutput) SetNumberOfChildJobs(v int64) *DescribeBackupJobOutput {
	s.NumberOfChildJobs = &v
	return s
}

// SetParentJobId sets the ParentJobId field's value.
func (s *DescribeBackupJobOutput) SetParentJobId(v string) *DescribeBackupJobOutput {
	s.ParentJobId = &v
	return s
}

// SetPercentDone sets the PercentDone field's value.
func (s *DescribeBackupJobOutput) SetPercentDone(v string) *DescribeBackupJobOutput {
	s.PercentDone = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *DescribeBackupJobOutput) SetRecoveryPointArn(v string) *DescribeBackupJobOutput {
	s.RecoveryPointArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeBackupJobOutput) SetResourceArn(v string) *DescribeBackupJobOutput {
	s.ResourceArn = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *DescribeBackupJobOutput) SetResourceName(v string) *DescribeBackupJobOutput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeBackupJobOutput) SetResourceType(v string) *DescribeBackupJobOutput {
	s.ResourceType = &v
	return s
}

// SetStartBy sets the StartBy field's value.
func (s *DescribeBackupJobOutput) SetStartBy(v time.Time) *DescribeBackupJobOutput {
	s.StartBy = &v
	return s
}

// SetState sets the State field's value.
func (s *DescribeBackupJobOutput) SetState(v string) *DescribeBackupJobOutput {
	s.State = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DescribeBackupJobOutput) SetStatusMessage(v string) *DescribeBackupJobOutput {
	s.StatusMessage = &v
	return s
}

type DescribeBackupVaultInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// This is the account ID of the specified backup vault.
	BackupVaultAccountId *string `location:"querystring" locationName:"backupVaultAccountId" type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupVaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupVaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBackupVaultInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultAccountId sets the BackupVaultAccountId field's value.
func (s *DescribeBackupVaultInput) SetBackupVaultAccountId(v string) *DescribeBackupVaultInput {
	s.BackupVaultAccountId = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *DescribeBackupVaultInput) SetBackupVaultName(v string) *DescribeBackupVaultInput {
	s.BackupVaultName = &v
	return s
}

type DescribeBackupVaultOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Region where they are created. They consist of lowercase letters, numbers,
	// and hyphens.
	BackupVaultName *string `type:"string"`

	// The date and time that a backup vault is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// A unique string that identifies the request and allows failed requests to
	// be retried without the risk of running the operation twice. This parameter
	// is optional. If used, this parameter must contain 1 to 50 alphanumeric or
	// '-_.' characters.
	CreatorRequestId *string `type:"string"`

	// The server-side encryption key that is used to protect your backups; for
	// example, arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	EncryptionKeyArn *string `type:"string"`

	// The date and time when Backup Vault Lock configuration cannot be changed
	// or deleted.
	//
	// If you applied Vault Lock to your vault without specifying a lock date, you
	// can change any of your Vault Lock settings, or delete Vault Lock from the
	// vault entirely, at any time.
	//
	// This value is in Unix format, Coordinated Universal Time (UTC), and accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	LockDate *time.Time `type:"timestamp"`

	// A Boolean that indicates whether Backup Vault Lock is currently protecting
	// the backup vault. True means that Vault Lock causes delete or update operations
	// on the recovery points stored in the vault to fail.
	Locked *bool `type:"boolean"`

	// The Backup Vault Lock setting that specifies the maximum retention period
	// that the vault retains its recovery points. If this parameter is not specified,
	// Vault Lock does not enforce a maximum retention period on the recovery points
	// in the vault (allowing indefinite storage).
	//
	// If specified, any backup or copy job to the vault must have a lifecycle policy
	// with a retention period equal to or shorter than the maximum retention period.
	// If the job's retention period is longer than that maximum retention period,
	// then the vault fails the backup or copy job, and you should either modify
	// your lifecycle settings or use a different vault. Recovery points already
	// stored in the vault prior to Vault Lock are not affected.
	MaxRetentionDays *int64 `type:"long"`

	// The Backup Vault Lock setting that specifies the minimum retention period
	// that the vault retains its recovery points. If this parameter is not specified,
	// Vault Lock does not enforce a minimum retention period.
	//
	// If specified, any backup or copy job to the vault must have a lifecycle policy
	// with a retention period equal to or longer than the minimum retention period.
	// If the job's retention period is shorter than that minimum retention period,
	// then the vault fails the backup or copy job, and you should either modify
	// your lifecycle settings or use a different vault. Recovery points already
	// stored in the vault prior to Vault Lock are not affected.
	MinRetentionDays *int64 `type:"long"`

	// The number of recovery points that are stored in a backup vault.
	NumberOfRecoveryPoints *int64 `type:"long"`

	// This is the type of vault described.
	VaultType *string `type:"string" enum:"VaultType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeBackupVaultOutput) GoString() string {
	return s.String()
}

// SetBackupVaultArn sets the BackupVaultArn field's value.
func (s *DescribeBackupVaultOutput) SetBackupVaultArn(v string) *DescribeBackupVaultOutput {
	s.BackupVaultArn = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *DescribeBackupVaultOutput) SetBackupVaultName(v string) *DescribeBackupVaultOutput {
	s.BackupVaultName = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeBackupVaultOutput) SetCreationDate(v time.Time) *DescribeBackupVaultOutput {
	s.CreationDate = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *DescribeBackupVaultOutput) SetCreatorRequestId(v string) *DescribeBackupVaultOutput {
	s.CreatorRequestId = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *DescribeBackupVaultOutput) SetEncryptionKeyArn(v string) *DescribeBackupVaultOutput {
	s.EncryptionKeyArn = &v
	return s
}

// SetLockDate sets the LockDate field's value.
func (s *DescribeBackupVaultOutput) SetLockDate(v time.Time) *DescribeBackupVaultOutput {
	s.LockDate = &v
	return s
}

// SetLocked sets the Locked field's value.
func (s *DescribeBackupVaultOutput) SetLocked(v bool) *DescribeBackupVaultOutput {
	s.Locked = &v
	return s
}

// SetMaxRetentionDays sets the MaxRetentionDays field's value.
func (s *DescribeBackupVaultOutput) SetMaxRetentionDays(v int64) *DescribeBackupVaultOutput {
	s.MaxRetentionDays = &v
	return s
}

// SetMinRetentionDays sets the MinRetentionDays field's value.
func (s *DescribeBackupVaultOutput) SetMinRetentionDays(v int64) *DescribeBackupVaultOutput {
	s.MinRetentionDays = &v
	return s
}

// SetNumberOfRecoveryPoints sets the NumberOfRecoveryPoints field's value.
func (s *DescribeBackupVaultOutput) SetNumberOfRecoveryPoints(v int64) *DescribeBackupVaultOutput {
	s.NumberOfRecoveryPoints = &v
	return s
}

// SetVaultType sets the VaultType field's value.
func (s *DescribeBackupVaultOutput) SetVaultType(v string) *DescribeBackupVaultOutput {
	s.VaultType = &v
	return s
}

type DescribeCopyJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Uniquely identifies a copy job.
	//
	// CopyJobId is a required field
	CopyJobId *string `location:"uri" locationName:"copyJobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCopyJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCopyJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCopyJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCopyJobInput"}
	if s.CopyJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("CopyJobId"))
	}
	if s.CopyJobId != nil && len(*s.CopyJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CopyJobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyJobId sets the CopyJobId field's value.
func (s *DescribeCopyJobInput) SetCopyJobId(v string) *DescribeCopyJobInput {
	s.CopyJobId = &v
	return s
}

type DescribeCopyJobOutput struct {
	_ struct{} `type:"structure"`

	// Contains detailed information about a copy job.
	CopyJob *CopyJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCopyJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeCopyJobOutput) GoString() string {
	return s.String()
}

// SetCopyJob sets the CopyJob field's value.
func (s *DescribeCopyJobOutput) SetCopyJob(v *CopyJob) *DescribeCopyJobOutput {
	s.CopyJob = v
	return s
}

type DescribeFrameworkInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of a framework.
	//
	// FrameworkName is a required field
	FrameworkName *string `location:"uri" locationName:"frameworkName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFrameworkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFrameworkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFrameworkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFrameworkInput"}
	if s.FrameworkName == nil {
		invalidParams.Add(request.NewErrParamRequired("FrameworkName"))
	}
	if s.FrameworkName != nil && len(*s.FrameworkName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FrameworkName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFrameworkName sets the FrameworkName field's value.
func (s *DescribeFrameworkInput) SetFrameworkName(v string) *DescribeFrameworkInput {
	s.FrameworkName = &v
	return s
}

type DescribeFrameworkOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that a framework is created, in ISO 8601 representation.
	// The value of CreationTime is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00
	// represents the 10th of July 2020 at 3:00 PM 8 hours behind UTC.
	CreationTime *time.Time `type:"timestamp"`

	// The deployment status of a framework. The statuses are:
	//
	// CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED
	// | FAILED
	DeploymentStatus *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	FrameworkArn *string `type:"string"`

	// A list of the controls that make up the framework. Each control in the list
	// has a name, input parameters, and scope.
	FrameworkControls []*FrameworkControl `type:"list"`

	// An optional description of the framework.
	FrameworkDescription *string `type:"string"`

	// The unique name of a framework.
	FrameworkName *string `min:"1" type:"string"`

	// A framework consists of one or more controls. Each control governs a resource,
	// such as backup plans, backup selections, backup vaults, or recovery points.
	// You can also turn Config recording on or off for each resource. The statuses
	// are:
	//
	//    * ACTIVE when recording is turned on for all resources governed by the
	//    framework.
	//
	//    * PARTIALLY_ACTIVE when recording is turned off for at least one resource
	//    governed by the framework.
	//
	//    * INACTIVE when recording is turned off for all resources governed by
	//    the framework.
	//
	//    * UNAVAILABLE when Backup is unable to validate recording status at this
	//    time.
	FrameworkStatus *string `type:"string"`

	// A customer-chosen string that you can use to distinguish between otherwise
	// identical calls to DescribeFrameworkOutput. Retrying a successful request
	// with the same idempotency token results in a success message with no action
	// taken.
	IdempotencyToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFrameworkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeFrameworkOutput) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *DescribeFrameworkOutput) SetCreationTime(v time.Time) *DescribeFrameworkOutput {
	s.CreationTime = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *DescribeFrameworkOutput) SetDeploymentStatus(v string) *DescribeFrameworkOutput {
	s.DeploymentStatus = &v
	return s
}

// SetFrameworkArn sets the FrameworkArn field's value.
func (s *DescribeFrameworkOutput) SetFrameworkArn(v string) *DescribeFrameworkOutput {
	s.FrameworkArn = &v
	return s
}

// SetFrameworkControls sets the FrameworkControls field's value.
func (s *DescribeFrameworkOutput) SetFrameworkControls(v []*FrameworkControl) *DescribeFrameworkOutput {
	s.FrameworkControls = v
	return s
}

// SetFrameworkDescription sets the FrameworkDescription field's value.
func (s *DescribeFrameworkOutput) SetFrameworkDescription(v string) *DescribeFrameworkOutput {
	s.FrameworkDescription = &v
	return s
}

// SetFrameworkName sets the FrameworkName field's value.
func (s *DescribeFrameworkOutput) SetFrameworkName(v string) *DescribeFrameworkOutput {
	s.FrameworkName = &v
	return s
}

// SetFrameworkStatus sets the FrameworkStatus field's value.
func (s *DescribeFrameworkOutput) SetFrameworkStatus(v string) *DescribeFrameworkOutput {
	s.FrameworkStatus = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *DescribeFrameworkOutput) SetIdempotencyToken(v string) *DescribeFrameworkOutput {
	s.IdempotencyToken = &v
	return s
}

type DescribeGlobalSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGlobalSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGlobalSettingsInput) GoString() string {
	return s.String()
}

type DescribeGlobalSettingsOutput struct {
	_ struct{} `type:"structure"`

	// The status of the flag isCrossAccountBackupEnabled.
	GlobalSettings map[string]*string `type:"map"`

	// The date and time that the flag isCrossAccountBackupEnabled was last updated.
	// This update is in Unix format and Coordinated Universal Time (UTC). The value
	// of LastUpdateTime is accurate to milliseconds. For example, the value 1516925490.087
	// represents Friday, January 26, 2018 12:11:30.087 AM.
	LastUpdateTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGlobalSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeGlobalSettingsOutput) GoString() string {
	return s.String()
}

// SetGlobalSettings sets the GlobalSettings field's value.
func (s *DescribeGlobalSettingsOutput) SetGlobalSettings(v map[string]*string) *DescribeGlobalSettingsOutput {
	s.GlobalSettings = v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *DescribeGlobalSettingsOutput) SetLastUpdateTime(v time.Time) *DescribeGlobalSettingsOutput {
	s.LastUpdateTime = &v
	return s
}

type DescribeProtectedResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProtectedResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProtectedResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeProtectedResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeProtectedResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeProtectedResourceInput) SetResourceArn(v string) *DescribeProtectedResourceInput {
	s.ResourceArn = &v
	return s
}

type DescribeProtectedResourceOutput struct {
	_ struct{} `type:"structure"`

	// The date and time that a resource was last backed up, in Unix format and
	// Coordinated Universal Time (UTC). The value of LastBackupTime is accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	LastBackupTime *time.Time `type:"timestamp"`

	// This is the ARN (Amazon Resource Name) of the backup vault that contains
	// the most recent backup recovery point.
	LastBackupVaultArn *string `type:"string"`

	// This is the ARN (Amazon Resource Name) of the most recent recovery point.
	LastRecoveryPointArn *string `type:"string"`

	// This is the time in minutes the most recent restore job took to complete.
	LatestRestoreExecutionTimeMinutes *int64 `type:"long"`

	// This is the creation date of the most recent restore job.
	LatestRestoreJobCreationDate *time.Time `type:"timestamp"`

	// This is the date the most recent recovery point was created.
	LatestRestoreRecoveryPointCreationDate *time.Time `type:"timestamp"`

	// An ARN that uniquely identifies a resource. The format of the ARN depends
	// on the resource type.
	ResourceArn *string `type:"string"`

	// This is the non-unique name of the resource that belongs to the specified
	// backup.
	ResourceName *string `type:"string"`

	// The type of Amazon Web Services resource saved as a recovery point; for example,
	// an Amazon EBS volume or an Amazon RDS database.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProtectedResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeProtectedResourceOutput) GoString() string {
	return s.String()
}

// SetLastBackupTime sets the LastBackupTime field's value.
func (s *DescribeProtectedResourceOutput) SetLastBackupTime(v time.Time) *DescribeProtectedResourceOutput {
	s.LastBackupTime = &v
	return s
}

// SetLastBackupVaultArn sets the LastBackupVaultArn field's value.
func (s *DescribeProtectedResourceOutput) SetLastBackupVaultArn(v string) *DescribeProtectedResourceOutput {
	s.LastBackupVaultArn = &v
	return s
}

// SetLastRecoveryPointArn sets the LastRecoveryPointArn field's value.
func (s *DescribeProtectedResourceOutput) SetLastRecoveryPointArn(v string) *DescribeProtectedResourceOutput {
	s.LastRecoveryPointArn = &v
	return s
}

// SetLatestRestoreExecutionTimeMinutes sets the LatestRestoreExecutionTimeMinutes field's value.
func (s *DescribeProtectedResourceOutput) SetLatestRestoreExecutionTimeMinutes(v int64) *DescribeProtectedResourceOutput {
	s.LatestRestoreExecutionTimeMinutes = &v
	return s
}

// SetLatestRestoreJobCreationDate sets the LatestRestoreJobCreationDate field's value.
func (s *DescribeProtectedResourceOutput) SetLatestRestoreJobCreationDate(v time.Time) *DescribeProtectedResourceOutput {
	s.LatestRestoreJobCreationDate = &v
	return s
}

// SetLatestRestoreRecoveryPointCreationDate sets the LatestRestoreRecoveryPointCreationDate field's value.
func (s *DescribeProtectedResourceOutput) SetLatestRestoreRecoveryPointCreationDate(v time.Time) *DescribeProtectedResourceOutput {
	s.LatestRestoreRecoveryPointCreationDate = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeProtectedResourceOutput) SetResourceArn(v string) *DescribeProtectedResourceOutput {
	s.ResourceArn = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *DescribeProtectedResourceOutput) SetResourceName(v string) *DescribeProtectedResourceOutput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeProtectedResourceOutput) SetResourceType(v string) *DescribeProtectedResourceOutput {
	s.ResourceType = &v
	return s
}

type DescribeRecoveryPointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// This is the account ID of the specified backup vault.
	BackupVaultAccountId *string `location:"querystring" locationName:"backupVaultAccountId" type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `location:"uri" locationName:"recoveryPointArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoveryPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRecoveryPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRecoveryPointInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}
	if s.RecoveryPointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointArn"))
	}
	if s.RecoveryPointArn != nil && len(*s.RecoveryPointArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryPointArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultAccountId sets the BackupVaultAccountId field's value.
func (s *DescribeRecoveryPointInput) SetBackupVaultAccountId(v string) *DescribeRecoveryPointInput {
	s.BackupVaultAccountId = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *DescribeRecoveryPointInput) SetBackupVaultName(v string) *DescribeRecoveryPointInput {
	s.BackupVaultName = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *DescribeRecoveryPointInput) SetRecoveryPointArn(v string) *DescribeRecoveryPointInput {
	s.RecoveryPointArn = &v
	return s
}

type DescribeRecoveryPointOutput struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, of a backup.
	BackupSizeInBytes *int64 `type:"long"`

	// An ARN that uniquely identifies a backup vault; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Region where they are created. They consist of lowercase letters, numbers,
	// and hyphens.
	BackupVaultName *string `type:"string"`

	// A CalculatedLifecycle object containing DeleteAt and MoveToColdStorageAt
	// timestamps.
	CalculatedLifecycle *CalculatedLifecycle `type:"structure"`

	// The date and time that a job to create a recovery point is completed, in
	// Unix format and Coordinated Universal Time (UTC). The value of CompletionDate
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time `type:"timestamp"`

	// This is the identifier of a resource within a composite group, such as nested
	// (child) recovery point belonging to a composite (parent) stack. The ID is
	// transferred from the logical ID (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax)
	// within a stack.
	CompositeMemberIdentifier *string `type:"string"`

	// Contains identifying information about the creation of a recovery point,
	// including the BackupPlanArn, BackupPlanId, BackupPlanVersion, and BackupRuleId
	// of the backup plan used to create it.
	CreatedBy *RecoveryPointCreator `type:"structure"`

	// The date and time that a recovery point is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// The server-side encryption key used to protect your backups; for example,
	// arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	EncryptionKeyArn *string `type:"string"`

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// A Boolean value that is returned as TRUE if the specified recovery point
	// is encrypted, or FALSE if the recovery point is not encrypted.
	IsEncrypted *bool `type:"boolean"`

	// This returns the boolean value that a recovery point is a parent (composite)
	// job.
	IsParent *bool `type:"boolean"`

	// The date and time that a recovery point was last restored, in Unix format
	// and Coordinated Universal Time (UTC). The value of LastRestoreTime is accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	LastRestoreTime *time.Time `type:"timestamp"`

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup transitions and expires backups automatically
	// according to the lifecycle that you define.
	//
	// Backups that are transitioned to cold storage must be stored in cold storage
	// for a minimum of 90 days. Therefore, the “retention” setting must be
	// 90 days greater than the “transition to cold after days” setting. The
	// “transition to cold after days” setting cannot be changed after a backup
	// has been transitioned to cold.
	//
	// Resource types that are able to be transitioned to cold storage are listed
	// in the "Lifecycle to cold storage" section of the Feature availability by
	// resource (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
	// table. Backup ignores this expression for other resource types.
	Lifecycle *Lifecycle `type:"structure"`

	// This is an ARN that uniquely identifies a parent (composite) recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	ParentRecoveryPointArn *string `type:"string"`

	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// An ARN that uniquely identifies a saved resource. The format of the ARN depends
	// on the resource type.
	ResourceArn *string `type:"string"`

	// This is the non-unique name of the resource that belongs to the specified
	// backup.
	ResourceName *string `type:"string"`

	// The type of Amazon Web Services resource to save as a recovery point; for
	// example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational
	// Database Service (Amazon RDS) database.
	ResourceType *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies the source vault where
	// the resource was originally backed up in; for example, arn:aws:backup:us-east-1:123456789012:vault:BackupVault.
	// If the recovery is restored to the same Amazon Web Services account or Region,
	// this value will be null.
	SourceBackupVaultArn *string `type:"string"`

	// A status code specifying the state of the recovery point.
	//
	// PARTIAL status indicates Backup could not create the recovery point before
	// the backup window closed. To increase your backup plan window using the API,
	// see UpdateBackupPlan (https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html).
	// You can also increase your backup plan window using the Console by choosing
	// and editing your backup plan.
	//
	// EXPIRED status indicates that the recovery point has exceeded its retention
	// period, but Backup lacks permission or is otherwise unable to delete it.
	// To manually delete these recovery points, see Step 3: Delete the recovery
	// points (https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups)
	// in the Clean up resources section of Getting started.
	//
	// STOPPED status occurs on a continuous backup where a user has taken some
	// action that causes the continuous backup to be disabled. This can be caused
	// by the removal of permissions, turning off versioning, turning off events
	// being sent to EventBridge, or disabling the EventBridge rules that are put
	// in place by Backup.
	//
	// To resolve STOPPED status, ensure that all requested permissions are in place
	// and that versioning is enabled on the S3 bucket. Once these conditions are
	// met, the next instance of a backup rule running will result in a new continuous
	// recovery point being created. The recovery points with STOPPED status do
	// not need to be deleted.
	//
	// For SAP HANA on Amazon EC2 STOPPED status occurs due to user action, application
	// misconfiguration, or backup failure. To ensure that future continuous backups
	// succeed, refer to the recovery point status and check SAP HANA for details.
	Status *string `type:"string" enum:"RecoveryPointStatus"`

	// A status message explaining the status of the recovery point.
	StatusMessage *string `type:"string"`

	// Specifies the storage class of the recovery point. Valid values are WARM
	// or COLD.
	StorageClass *string `type:"string" enum:"StorageClass"`

	// This is the type of vault in which the described recovery point is stored.
	VaultType *string `type:"string" enum:"VaultType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRecoveryPointOutput) GoString() string {
	return s.String()
}

// SetBackupSizeInBytes sets the BackupSizeInBytes field's value.
func (s *DescribeRecoveryPointOutput) SetBackupSizeInBytes(v int64) *DescribeRecoveryPointOutput {
	s.BackupSizeInBytes = &v
	return s
}

// SetBackupVaultArn sets the BackupVaultArn field's value.
func (s *DescribeRecoveryPointOutput) SetBackupVaultArn(v string) *DescribeRecoveryPointOutput {
	s.BackupVaultArn = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *DescribeRecoveryPointOutput) SetBackupVaultName(v string) *DescribeRecoveryPointOutput {
	s.BackupVaultName = &v
	return s
}

// SetCalculatedLifecycle sets the CalculatedLifecycle field's value.
func (s *DescribeRecoveryPointOutput) SetCalculatedLifecycle(v *CalculatedLifecycle) *DescribeRecoveryPointOutput {
	s.CalculatedLifecycle = v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *DescribeRecoveryPointOutput) SetCompletionDate(v time.Time) *DescribeRecoveryPointOutput {
	s.CompletionDate = &v
	return s
}

// SetCompositeMemberIdentifier sets the CompositeMemberIdentifier field's value.
func (s *DescribeRecoveryPointOutput) SetCompositeMemberIdentifier(v string) *DescribeRecoveryPointOutput {
	s.CompositeMemberIdentifier = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeRecoveryPointOutput) SetCreatedBy(v *RecoveryPointCreator) *DescribeRecoveryPointOutput {
	s.CreatedBy = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeRecoveryPointOutput) SetCreationDate(v time.Time) *DescribeRecoveryPointOutput {
	s.CreationDate = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *DescribeRecoveryPointOutput) SetEncryptionKeyArn(v string) *DescribeRecoveryPointOutput {
	s.EncryptionKeyArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *DescribeRecoveryPointOutput) SetIamRoleArn(v string) *DescribeRecoveryPointOutput {
	s.IamRoleArn = &v
	return s
}

// SetIsEncrypted sets the IsEncrypted field's value.
func (s *DescribeRecoveryPointOutput) SetIsEncrypted(v bool) *DescribeRecoveryPointOutput {
	s.IsEncrypted = &v
	return s
}

// SetIsParent sets the IsParent field's value.
func (s *DescribeRecoveryPointOutput) SetIsParent(v bool) *DescribeRecoveryPointOutput {
	s.IsParent = &v
	return s
}

// SetLastRestoreTime sets the LastRestoreTime field's value.
func (s *DescribeRecoveryPointOutput) SetLastRestoreTime(v time.Time) *DescribeRecoveryPointOutput {
	s.LastRestoreTime = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *DescribeRecoveryPointOutput) SetLifecycle(v *Lifecycle) *DescribeRecoveryPointOutput {
	s.Lifecycle = v
	return s
}

// SetParentRecoveryPointArn sets the ParentRecoveryPointArn field's value.
func (s *DescribeRecoveryPointOutput) SetParentRecoveryPointArn(v string) *DescribeRecoveryPointOutput {
	s.ParentRecoveryPointArn = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *DescribeRecoveryPointOutput) SetRecoveryPointArn(v string) *DescribeRecoveryPointOutput {
	s.RecoveryPointArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DescribeRecoveryPointOutput) SetResourceArn(v string) *DescribeRecoveryPointOutput {
	s.ResourceArn = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *DescribeRecoveryPointOutput) SetResourceName(v string) *DescribeRecoveryPointOutput {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeRecoveryPointOutput) SetResourceType(v string) *DescribeRecoveryPointOutput {
	s.ResourceType = &v
	return s
}

// SetSourceBackupVaultArn sets the SourceBackupVaultArn field's value.
func (s *DescribeRecoveryPointOutput) SetSourceBackupVaultArn(v string) *DescribeRecoveryPointOutput {
	s.SourceBackupVaultArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeRecoveryPointOutput) SetStatus(v string) *DescribeRecoveryPointOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DescribeRecoveryPointOutput) SetStatusMessage(v string) *DescribeRecoveryPointOutput {
	s.StatusMessage = &v
	return s
}

// SetStorageClass sets the StorageClass field's value.
func (s *DescribeRecoveryPointOutput) SetStorageClass(v string) *DescribeRecoveryPointOutput {
	s.StorageClass = &v
	return s
}

// SetVaultType sets the VaultType field's value.
func (s *DescribeRecoveryPointOutput) SetVaultType(v string) *DescribeRecoveryPointOutput {
	s.VaultType = &v
	return s
}

type DescribeRegionSettingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRegionSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRegionSettingsInput) GoString() string {
	return s.String()
}

type DescribeRegionSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Returns whether Backup fully manages the backups for a resource type.
	//
	// For the benefits of full Backup management, see Full Backup management (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#full-management).
	//
	// For a list of resource types and whether each supports full Backup management,
	// see the Feature availability by resource (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
	// table.
	//
	// If "DynamoDB":false, you can enable full Backup management for DynamoDB backup
	// by enabling Backup's advanced DynamoDB backup features (https://docs.aws.amazon.com/aws-backup/latest/devguide/advanced-ddb-backup.html#advanced-ddb-backup-enable-cli).
	ResourceTypeManagementPreference map[string]*bool `type:"map"`

	// Returns a list of all services along with the opt-in preferences in the Region.
	ResourceTypeOptInPreference map[string]*bool `type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRegionSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRegionSettingsOutput) GoString() string {
	return s.String()
}

// SetResourceTypeManagementPreference sets the ResourceTypeManagementPreference field's value.
func (s *DescribeRegionSettingsOutput) SetResourceTypeManagementPreference(v map[string]*bool) *DescribeRegionSettingsOutput {
	s.ResourceTypeManagementPreference = v
	return s
}

// SetResourceTypeOptInPreference sets the ResourceTypeOptInPreference field's value.
func (s *DescribeRegionSettingsOutput) SetResourceTypeOptInPreference(v map[string]*bool) *DescribeRegionSettingsOutput {
	s.ResourceTypeOptInPreference = v
	return s
}

type DescribeReportJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the report job. A unique, randomly generated, Unicode,
	// UTF-8 encoded string that is at most 1,024 bytes long. The report job ID
	// cannot be edited.
	//
	// ReportJobId is a required field
	ReportJobId *string `location:"uri" locationName:"reportJobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReportJobInput"}
	if s.ReportJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportJobId"))
	}
	if s.ReportJobId != nil && len(*s.ReportJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportJobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportJobId sets the ReportJobId field's value.
func (s *DescribeReportJobInput) SetReportJobId(v string) *DescribeReportJobInput {
	s.ReportJobId = &v
	return s
}

type DescribeReportJobOutput struct {
	_ struct{} `type:"structure"`

	// A list of information about a report job, including its completion and creation
	// times, report destination, unique report job ID, Amazon Resource Name (ARN),
	// report template, status, and status message.
	ReportJob *ReportJob `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReportJobOutput) GoString() string {
	return s.String()
}

// SetReportJob sets the ReportJob field's value.
func (s *DescribeReportJobOutput) SetReportJob(v *ReportJob) *DescribeReportJobOutput {
	s.ReportJob = v
	return s
}

type DescribeReportPlanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of a report plan.
	//
	// ReportPlanName is a required field
	ReportPlanName *string `location:"uri" locationName:"reportPlanName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReportPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReportPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReportPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReportPlanInput"}
	if s.ReportPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportPlanName"))
	}
	if s.ReportPlanName != nil && len(*s.ReportPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportPlanName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReportPlanName sets the ReportPlanName field's value.
func (s *DescribeReportPlanInput) SetReportPlanName(v string) *DescribeReportPlanInput {
	s.ReportPlanName = &v
	return s
}

type DescribeReportPlanOutput struct {
	_ struct{} `type:"structure"`

	// Returns details about the report plan that is specified by its name. These
	// details include the report plan's Amazon Resource Name (ARN), description,
	// settings, delivery channel, deployment status, creation time, and last attempted
	// and successful run times.
	ReportPlan *ReportPlan `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReportPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeReportPlanOutput) GoString() string {
	return s.String()
}

// SetReportPlan sets the ReportPlan field's value.
func (s *DescribeReportPlanOutput) SetReportPlan(v *ReportPlan) *DescribeReportPlanOutput {
	s.ReportPlan = v
	return s
}

type DescribeRestoreJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Uniquely identifies the job that restores a recovery point.
	//
	// RestoreJobId is a required field
	RestoreJobId *string `location:"uri" locationName:"restoreJobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRestoreJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRestoreJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRestoreJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRestoreJobInput"}
	if s.RestoreJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreJobId"))
	}
	if s.RestoreJobId != nil && len(*s.RestoreJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestoreJobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestoreJobId sets the RestoreJobId field's value.
func (s *DescribeRestoreJobInput) SetRestoreJobId(v string) *DescribeRestoreJobInput {
	s.RestoreJobId = &v
	return s
}

type DescribeRestoreJobOutput struct {
	_ struct{} `type:"structure"`

	// Returns the account ID that owns the restore job.
	AccountId *string `type:"string"`

	// The size, in bytes, of the restored resource.
	BackupSizeInBytes *int64 `type:"long"`

	// The date and time that a job to restore a recovery point is completed, in
	// Unix format and Coordinated Universal Time (UTC). The value of CompletionDate
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time `type:"timestamp"`

	// Contains identifying information about the creation of a restore job.
	CreatedBy *RestoreJobCreator `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource whose recovery
	// point is being restored. The format of the ARN depends on the resource type
	// of the backed-up resource.
	CreatedResourceArn *string `type:"string"`

	// The date and time that a restore job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// This notes the status of the data generated by the restore test. The status
	// may be Deleting, Failed, or Successful.
	DeletionStatus *string `type:"string" enum:"RestoreDeletionStatus"`

	// This describes the restore job deletion status.
	DeletionStatusMessage *string `type:"string"`

	// The amount of time in minutes that a job restoring a recovery point is expected
	// to take.
	ExpectedCompletionTimeMinutes *int64 `type:"long"`

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// Contains an estimated percentage that is complete of a job at the time the
	// job status was queried.
	PercentDone *string `type:"string"`

	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// This is the creation date of the recovery point made by the specifed restore
	// job.
	RecoveryPointCreationDate *time.Time `type:"timestamp"`

	// Returns metadata associated with a restore job listed by resource type.
	ResourceType *string `type:"string"`

	// Uniquely identifies the job that restores a recovery point.
	RestoreJobId *string `type:"string"`

	// Status code specifying the state of the job that is initiated by Backup to
	// restore a recovery point.
	Status *string `type:"string" enum:"RestoreJobStatus"`

	// A message showing the status of a job to restore a recovery point.
	StatusMessage *string `type:"string"`

	// This is the status of validation run on the indicated restore job.
	ValidationStatus *string `type:"string" enum:"RestoreValidationStatus"`

	// This describes the status of validation run on the indicated restore job.
	ValidationStatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRestoreJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeRestoreJobOutput) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *DescribeRestoreJobOutput) SetAccountId(v string) *DescribeRestoreJobOutput {
	s.AccountId = &v
	return s
}

// SetBackupSizeInBytes sets the BackupSizeInBytes field's value.
func (s *DescribeRestoreJobOutput) SetBackupSizeInBytes(v int64) *DescribeRestoreJobOutput {
	s.BackupSizeInBytes = &v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *DescribeRestoreJobOutput) SetCompletionDate(v time.Time) *DescribeRestoreJobOutput {
	s.CompletionDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DescribeRestoreJobOutput) SetCreatedBy(v *RestoreJobCreator) *DescribeRestoreJobOutput {
	s.CreatedBy = v
	return s
}

// SetCreatedResourceArn sets the CreatedResourceArn field's value.
func (s *DescribeRestoreJobOutput) SetCreatedResourceArn(v string) *DescribeRestoreJobOutput {
	s.CreatedResourceArn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *DescribeRestoreJobOutput) SetCreationDate(v time.Time) *DescribeRestoreJobOutput {
	s.CreationDate = &v
	return s
}

// SetDeletionStatus sets the DeletionStatus field's value.
func (s *DescribeRestoreJobOutput) SetDeletionStatus(v string) *DescribeRestoreJobOutput {
	s.DeletionStatus = &v
	return s
}

// SetDeletionStatusMessage sets the DeletionStatusMessage field's value.
func (s *DescribeRestoreJobOutput) SetDeletionStatusMessage(v string) *DescribeRestoreJobOutput {
	s.DeletionStatusMessage = &v
	return s
}

// SetExpectedCompletionTimeMinutes sets the ExpectedCompletionTimeMinutes field's value.
func (s *DescribeRestoreJobOutput) SetExpectedCompletionTimeMinutes(v int64) *DescribeRestoreJobOutput {
	s.ExpectedCompletionTimeMinutes = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *DescribeRestoreJobOutput) SetIamRoleArn(v string) *DescribeRestoreJobOutput {
	s.IamRoleArn = &v
	return s
}

// SetPercentDone sets the PercentDone field's value.
func (s *DescribeRestoreJobOutput) SetPercentDone(v string) *DescribeRestoreJobOutput {
	s.PercentDone = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *DescribeRestoreJobOutput) SetRecoveryPointArn(v string) *DescribeRestoreJobOutput {
	s.RecoveryPointArn = &v
	return s
}

// SetRecoveryPointCreationDate sets the RecoveryPointCreationDate field's value.
func (s *DescribeRestoreJobOutput) SetRecoveryPointCreationDate(v time.Time) *DescribeRestoreJobOutput {
	s.RecoveryPointCreationDate = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DescribeRestoreJobOutput) SetResourceType(v string) *DescribeRestoreJobOutput {
	s.ResourceType = &v
	return s
}

// SetRestoreJobId sets the RestoreJobId field's value.
func (s *DescribeRestoreJobOutput) SetRestoreJobId(v string) *DescribeRestoreJobOutput {
	s.RestoreJobId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeRestoreJobOutput) SetStatus(v string) *DescribeRestoreJobOutput {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *DescribeRestoreJobOutput) SetStatusMessage(v string) *DescribeRestoreJobOutput {
	s.StatusMessage = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *DescribeRestoreJobOutput) SetValidationStatus(v string) *DescribeRestoreJobOutput {
	s.ValidationStatus = &v
	return s
}

// SetValidationStatusMessage sets the ValidationStatusMessage field's value.
func (s *DescribeRestoreJobOutput) SetValidationStatusMessage(v string) *DescribeRestoreJobOutput {
	s.ValidationStatusMessage = &v
	return s
}

type DisassociateRecoveryPointFromParentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// This is the name of a logical container where the child (nested) recovery
	// point is stored. Backup vaults are identified by names that are unique to
	// the account used to create them and the Amazon Web Services Region where
	// they are created. They consist of lowercase letters, numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// This is the Amazon Resource Name (ARN) that uniquely identifies the child
	// (nested) recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `location:"uri" locationName:"recoveryPointArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateRecoveryPointFromParentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateRecoveryPointFromParentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateRecoveryPointFromParentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateRecoveryPointFromParentInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}
	if s.RecoveryPointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointArn"))
	}
	if s.RecoveryPointArn != nil && len(*s.RecoveryPointArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryPointArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *DisassociateRecoveryPointFromParentInput) SetBackupVaultName(v string) *DisassociateRecoveryPointFromParentInput {
	s.BackupVaultName = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *DisassociateRecoveryPointFromParentInput) SetRecoveryPointArn(v string) *DisassociateRecoveryPointFromParentInput {
	s.RecoveryPointArn = &v
	return s
}

type DisassociateRecoveryPointFromParentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateRecoveryPointFromParentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateRecoveryPointFromParentOutput) GoString() string {
	return s.String()
}

type DisassociateRecoveryPointInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The unique name of an Backup vault.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// An Amazon Resource Name (ARN) that uniquely identifies an Backup recovery
	// point.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `location:"uri" locationName:"recoveryPointArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateRecoveryPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateRecoveryPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateRecoveryPointInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}
	if s.RecoveryPointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointArn"))
	}
	if s.RecoveryPointArn != nil && len(*s.RecoveryPointArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryPointArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *DisassociateRecoveryPointInput) SetBackupVaultName(v string) *DisassociateRecoveryPointInput {
	s.BackupVaultName = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *DisassociateRecoveryPointInput) SetRecoveryPointArn(v string) *DisassociateRecoveryPointInput {
	s.RecoveryPointArn = &v
	return s
}

type DisassociateRecoveryPointOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateRecoveryPointOutput) GoString() string {
	return s.String()
}

type ExportBackupPlanTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Uniquely identifies a backup plan.
	//
	// BackupPlanId is a required field
	BackupPlanId *string `location:"uri" locationName:"backupPlanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportBackupPlanTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportBackupPlanTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportBackupPlanTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportBackupPlanTemplateInput"}
	if s.BackupPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlanId"))
	}
	if s.BackupPlanId != nil && len(*s.BackupPlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupPlanId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *ExportBackupPlanTemplateInput) SetBackupPlanId(v string) *ExportBackupPlanTemplateInput {
	s.BackupPlanId = &v
	return s
}

type ExportBackupPlanTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The body of a backup plan template in JSON format.
	//
	// This is a signed JSON document that cannot be modified before being passed
	// to GetBackupPlanFromJSON.
	BackupPlanTemplateJson *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportBackupPlanTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExportBackupPlanTemplateOutput) GoString() string {
	return s.String()
}

// SetBackupPlanTemplateJson sets the BackupPlanTemplateJson field's value.
func (s *ExportBackupPlanTemplateOutput) SetBackupPlanTemplateJson(v string) *ExportBackupPlanTemplateOutput {
	s.BackupPlanTemplateJson = &v
	return s
}

// Contains detailed information about a framework. Frameworks contain controls,
// which evaluate and report on your backup events and resources. Frameworks
// generate daily compliance results.
type Framework struct {
	_ struct{} `type:"structure"`

	// The date and time that a framework is created, in ISO 8601 representation.
	// The value of CreationTime is accurate to milliseconds. For example, 2020-07-10T15:00:00.000-08:00
	// represents the 10th of July 2020 at 3:00 PM 8 hours behind UTC.
	CreationTime *time.Time `type:"timestamp"`

	// The deployment status of a framework. The statuses are:
	//
	// CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED
	// | FAILED
	DeploymentStatus *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	FrameworkArn *string `type:"string"`

	// An optional description of the framework with a maximum 1,024 characters.
	FrameworkDescription *string `type:"string"`

	// The unique name of a framework. This name is between 1 and 256 characters,
	// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9),
	// and underscores (_).
	FrameworkName *string `min:"1" type:"string"`

	// The number of controls contained by the framework.
	NumberOfControls *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Framework) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Framework) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *Framework) SetCreationTime(v time.Time) *Framework {
	s.CreationTime = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *Framework) SetDeploymentStatus(v string) *Framework {
	s.DeploymentStatus = &v
	return s
}

// SetFrameworkArn sets the FrameworkArn field's value.
func (s *Framework) SetFrameworkArn(v string) *Framework {
	s.FrameworkArn = &v
	return s
}

// SetFrameworkDescription sets the FrameworkDescription field's value.
func (s *Framework) SetFrameworkDescription(v string) *Framework {
	s.FrameworkDescription = &v
	return s
}

// SetFrameworkName sets the FrameworkName field's value.
func (s *Framework) SetFrameworkName(v string) *Framework {
	s.FrameworkName = &v
	return s
}

// SetNumberOfControls sets the NumberOfControls field's value.
func (s *Framework) SetNumberOfControls(v int64) *Framework {
	s.NumberOfControls = &v
	return s
}

// Contains detailed information about all of the controls of a framework. Each
// framework must contain at least one control.
type FrameworkControl struct {
	_ struct{} `type:"structure"`

	// A list of ParameterName and ParameterValue pairs.
	ControlInputParameters []*ControlInputParameter `type:"list"`

	// The name of a control. This name is between 1 and 256 characters.
	//
	// ControlName is a required field
	ControlName *string `type:"string" required:"true"`

	// The scope of a control. The control scope defines what the control will evaluate.
	// Three examples of control scopes are: a specific backup plan, all backup
	// plans with a specific tag, or all backup plans.
	ControlScope *ControlScope `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameworkControl) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FrameworkControl) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FrameworkControl) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FrameworkControl"}
	if s.ControlName == nil {
		invalidParams.Add(request.NewErrParamRequired("ControlName"))
	}
	if s.ControlScope != nil {
		if err := s.ControlScope.Validate(); err != nil {
			invalidParams.AddNested("ControlScope", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetControlInputParameters sets the ControlInputParameters field's value.
func (s *FrameworkControl) SetControlInputParameters(v []*ControlInputParameter) *FrameworkControl {
	s.ControlInputParameters = v
	return s
}

// SetControlName sets the ControlName field's value.
func (s *FrameworkControl) SetControlName(v string) *FrameworkControl {
	s.ControlName = &v
	return s
}

// SetControlScope sets the ControlScope field's value.
func (s *FrameworkControl) SetControlScope(v *ControlScope) *FrameworkControl {
	s.ControlScope = v
	return s
}

type GetBackupPlanFromJSONInput struct {
	_ struct{} `type:"structure"`

	// A customer-supplied backup plan document in JSON format.
	//
	// BackupPlanTemplateJson is a required field
	BackupPlanTemplateJson *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupPlanFromJSONInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupPlanFromJSONInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackupPlanFromJSONInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBackupPlanFromJSONInput"}
	if s.BackupPlanTemplateJson == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlanTemplateJson"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPlanTemplateJson sets the BackupPlanTemplateJson field's value.
func (s *GetBackupPlanFromJSONInput) SetBackupPlanTemplateJson(v string) *GetBackupPlanFromJSONInput {
	s.BackupPlanTemplateJson = &v
	return s
}

type GetBackupPlanFromJSONOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the body of a backup plan. Includes a BackupPlanName and one or
	// more sets of Rules.
	BackupPlan *Plan `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupPlanFromJSONOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupPlanFromJSONOutput) GoString() string {
	return s.String()
}

// SetBackupPlan sets the BackupPlan field's value.
func (s *GetBackupPlanFromJSONOutput) SetBackupPlan(v *Plan) *GetBackupPlanFromJSONOutput {
	s.BackupPlan = v
	return s
}

type GetBackupPlanFromTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Uniquely identifies a stored backup plan template.
	//
	// BackupPlanTemplateId is a required field
	BackupPlanTemplateId *string `location:"uri" locationName:"templateId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupPlanFromTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupPlanFromTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackupPlanFromTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBackupPlanFromTemplateInput"}
	if s.BackupPlanTemplateId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlanTemplateId"))
	}
	if s.BackupPlanTemplateId != nil && len(*s.BackupPlanTemplateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupPlanTemplateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPlanTemplateId sets the BackupPlanTemplateId field's value.
func (s *GetBackupPlanFromTemplateInput) SetBackupPlanTemplateId(v string) *GetBackupPlanFromTemplateInput {
	s.BackupPlanTemplateId = &v
	return s
}

type GetBackupPlanFromTemplateOutput struct {
	_ struct{} `type:"structure"`

	// Returns the body of a backup plan based on the target template, including
	// the name, rules, and backup vault of the plan.
	BackupPlanDocument *Plan `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupPlanFromTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupPlanFromTemplateOutput) GoString() string {
	return s.String()
}

// SetBackupPlanDocument sets the BackupPlanDocument field's value.
func (s *GetBackupPlanFromTemplateOutput) SetBackupPlanDocument(v *Plan) *GetBackupPlanFromTemplateOutput {
	s.BackupPlanDocument = v
	return s
}

type GetBackupPlanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Uniquely identifies a backup plan.
	//
	// BackupPlanId is a required field
	BackupPlanId *string `location:"uri" locationName:"backupPlanId" type:"string" required:"true"`

	// Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most
	// 1,024 bytes long. Version IDs cannot be edited.
	VersionId *string `location:"querystring" locationName:"versionId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackupPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBackupPlanInput"}
	if s.BackupPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlanId"))
	}
	if s.BackupPlanId != nil && len(*s.BackupPlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupPlanId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *GetBackupPlanInput) SetBackupPlanId(v string) *GetBackupPlanInput {
	s.BackupPlanId = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetBackupPlanInput) SetVersionId(v string) *GetBackupPlanInput {
	s.VersionId = &v
	return s
}

type GetBackupPlanOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of BackupOptions for each resource type. The list is populated
	// only if the advanced option is set for the backup plan.
	AdvancedBackupSettings []*AdvancedBackupSetting `type:"list"`

	// Specifies the body of a backup plan. Includes a BackupPlanName and one or
	// more sets of Rules.
	BackupPlan *Plan `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for
	// example, arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50.
	BackupPlanArn *string `type:"string"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// The date and time that a backup plan is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// A unique string that identifies the request and allows failed requests to
	// be retried without the risk of running the operation twice.
	CreatorRequestId *string `type:"string"`

	// The date and time that a backup plan is deleted, in Unix format and Coordinated
	// Universal Time (UTC). The value of DeletionDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	DeletionDate *time.Time `type:"timestamp"`

	// The last time a job to back up resources was run with this backup plan. A
	// date and time, in Unix format and Coordinated Universal Time (UTC). The value
	// of LastExecutionDate is accurate to milliseconds. For example, the value
	// 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	LastExecutionDate *time.Time `type:"timestamp"`

	// Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most
	// 1,024 bytes long. Version IDs cannot be edited.
	VersionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupPlanOutput) GoString() string {
	return s.String()
}

// SetAdvancedBackupSettings sets the AdvancedBackupSettings field's value.
func (s *GetBackupPlanOutput) SetAdvancedBackupSettings(v []*AdvancedBackupSetting) *GetBackupPlanOutput {
	s.AdvancedBackupSettings = v
	return s
}

// SetBackupPlan sets the BackupPlan field's value.
func (s *GetBackupPlanOutput) SetBackupPlan(v *Plan) *GetBackupPlanOutput {
	s.BackupPlan = v
	return s
}

// SetBackupPlanArn sets the BackupPlanArn field's value.
func (s *GetBackupPlanOutput) SetBackupPlanArn(v string) *GetBackupPlanOutput {
	s.BackupPlanArn = &v
	return s
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *GetBackupPlanOutput) SetBackupPlanId(v string) *GetBackupPlanOutput {
	s.BackupPlanId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetBackupPlanOutput) SetCreationDate(v time.Time) *GetBackupPlanOutput {
	s.CreationDate = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *GetBackupPlanOutput) SetCreatorRequestId(v string) *GetBackupPlanOutput {
	s.CreatorRequestId = &v
	return s
}

// SetDeletionDate sets the DeletionDate field's value.
func (s *GetBackupPlanOutput) SetDeletionDate(v time.Time) *GetBackupPlanOutput {
	s.DeletionDate = &v
	return s
}

// SetLastExecutionDate sets the LastExecutionDate field's value.
func (s *GetBackupPlanOutput) SetLastExecutionDate(v time.Time) *GetBackupPlanOutput {
	s.LastExecutionDate = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *GetBackupPlanOutput) SetVersionId(v string) *GetBackupPlanOutput {
	s.VersionId = &v
	return s
}

type GetBackupSelectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Uniquely identifies a backup plan.
	//
	// BackupPlanId is a required field
	BackupPlanId *string `location:"uri" locationName:"backupPlanId" type:"string" required:"true"`

	// Uniquely identifies the body of a request to assign a set of resources to
	// a backup plan.
	//
	// SelectionId is a required field
	SelectionId *string `location:"uri" locationName:"selectionId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupSelectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupSelectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackupSelectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBackupSelectionInput"}
	if s.BackupPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlanId"))
	}
	if s.BackupPlanId != nil && len(*s.BackupPlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupPlanId", 1))
	}
	if s.SelectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectionId"))
	}
	if s.SelectionId != nil && len(*s.SelectionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SelectionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *GetBackupSelectionInput) SetBackupPlanId(v string) *GetBackupSelectionInput {
	s.BackupPlanId = &v
	return s
}

// SetSelectionId sets the SelectionId field's value.
func (s *GetBackupSelectionInput) SetSelectionId(v string) *GetBackupSelectionInput {
	s.SelectionId = &v
	return s
}

type GetBackupSelectionOutput struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// Specifies the body of a request to assign a set of resources to a backup
	// plan.
	BackupSelection *Selection `type:"structure"`

	// The date and time a backup selection is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// A unique string that identifies the request and allows failed requests to
	// be retried without the risk of running the operation twice.
	CreatorRequestId *string `type:"string"`

	// Uniquely identifies the body of a request to assign a set of resources to
	// a backup plan.
	SelectionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupSelectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupSelectionOutput) GoString() string {
	return s.String()
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *GetBackupSelectionOutput) SetBackupPlanId(v string) *GetBackupSelectionOutput {
	s.BackupPlanId = &v
	return s
}

// SetBackupSelection sets the BackupSelection field's value.
func (s *GetBackupSelectionOutput) SetBackupSelection(v *Selection) *GetBackupSelectionOutput {
	s.BackupSelection = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetBackupSelectionOutput) SetCreationDate(v time.Time) *GetBackupSelectionOutput {
	s.CreationDate = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *GetBackupSelectionOutput) SetCreatorRequestId(v string) *GetBackupSelectionOutput {
	s.CreatorRequestId = &v
	return s
}

// SetSelectionId sets the SelectionId field's value.
func (s *GetBackupSelectionOutput) SetSelectionId(v string) *GetBackupSelectionOutput {
	s.SelectionId = &v
	return s
}

type GetBackupVaultAccessPolicyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupVaultAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupVaultAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackupVaultAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBackupVaultAccessPolicyInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *GetBackupVaultAccessPolicyInput) SetBackupVaultName(v string) *GetBackupVaultAccessPolicyInput {
	s.BackupVaultName = &v
	return s
}

type GetBackupVaultAccessPolicyOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Region where they are created. They consist of lowercase letters, numbers,
	// and hyphens.
	BackupVaultName *string `type:"string"`

	// The backup vault access policy document in JSON format.
	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupVaultAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupVaultAccessPolicyOutput) GoString() string {
	return s.String()
}

// SetBackupVaultArn sets the BackupVaultArn field's value.
func (s *GetBackupVaultAccessPolicyOutput) SetBackupVaultArn(v string) *GetBackupVaultAccessPolicyOutput {
	s.BackupVaultArn = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *GetBackupVaultAccessPolicyOutput) SetBackupVaultName(v string) *GetBackupVaultAccessPolicyOutput {
	s.BackupVaultName = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *GetBackupVaultAccessPolicyOutput) SetPolicy(v string) *GetBackupVaultAccessPolicyOutput {
	s.Policy = &v
	return s
}

type GetBackupVaultNotificationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupVaultNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupVaultNotificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBackupVaultNotificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBackupVaultNotificationsInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *GetBackupVaultNotificationsInput) SetBackupVaultName(v string) *GetBackupVaultNotificationsInput {
	s.BackupVaultName = &v
	return s
}

type GetBackupVaultNotificationsOutput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// An array of events that indicate the status of jobs to back up resources
	// to the backup vault.
	BackupVaultEvents []*string `type:"list" enum:"VaultEvent"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Region where they are created. They consist of lowercase letters, numbers,
	// and hyphens.
	BackupVaultName *string `type:"string"`

	// An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon
	// SNS) topic; for example, arn:aws:sns:us-west-2:111122223333:MyTopic.
	SNSTopicArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupVaultNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBackupVaultNotificationsOutput) GoString() string {
	return s.String()
}

// SetBackupVaultArn sets the BackupVaultArn field's value.
func (s *GetBackupVaultNotificationsOutput) SetBackupVaultArn(v string) *GetBackupVaultNotificationsOutput {
	s.BackupVaultArn = &v
	return s
}

// SetBackupVaultEvents sets the BackupVaultEvents field's value.
func (s *GetBackupVaultNotificationsOutput) SetBackupVaultEvents(v []*string) *GetBackupVaultNotificationsOutput {
	s.BackupVaultEvents = v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *GetBackupVaultNotificationsOutput) SetBackupVaultName(v string) *GetBackupVaultNotificationsOutput {
	s.BackupVaultName = &v
	return s
}

// SetSNSTopicArn sets the SNSTopicArn field's value.
func (s *GetBackupVaultNotificationsOutput) SetSNSTopicArn(v string) *GetBackupVaultNotificationsOutput {
	s.SNSTopicArn = &v
	return s
}

type GetLegalHoldInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// This is the ID required to use GetLegalHold. This unique ID is associated
	// with a specific legal hold.
	//
	// LegalHoldId is a required field
	LegalHoldId *string `location:"uri" locationName:"legalHoldId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLegalHoldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLegalHoldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLegalHoldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLegalHoldInput"}
	if s.LegalHoldId == nil {
		invalidParams.Add(request.NewErrParamRequired("LegalHoldId"))
	}
	if s.LegalHoldId != nil && len(*s.LegalHoldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LegalHoldId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLegalHoldId sets the LegalHoldId field's value.
func (s *GetLegalHoldInput) SetLegalHoldId(v string) *GetLegalHoldInput {
	s.LegalHoldId = &v
	return s
}

type GetLegalHoldOutput struct {
	_ struct{} `type:"structure"`

	// String describing the reason for removing the legal hold.
	CancelDescription *string `type:"string"`

	// Time in number when legal hold was cancelled.
	CancellationDate *time.Time `type:"timestamp"`

	// Time in number format when legal hold was created.
	CreationDate *time.Time `type:"timestamp"`

	// This is the returned string description of the legal hold.
	Description *string `type:"string"`

	// This is the returned framework ARN for the specified legal hold. An Amazon
	// Resource Name (ARN) uniquely identifies a resource. The format of the ARN
	// depends on the resource type.
	LegalHoldArn *string `type:"string"`

	// This is the returned ID associated with a specified legal hold.
	LegalHoldId *string `type:"string"`

	// This specifies criteria to assign a set of resources, such as resource types
	// or backup vaults.
	RecoveryPointSelection *RecoveryPointSelection `type:"structure"`

	// This is the date and time until which the legal hold record will be retained.
	RetainRecordUntil *time.Time `type:"timestamp"`

	// This is the status of the legal hold. Statuses can be ACTIVE, CREATING, CANCELED,
	// and CANCELING.
	Status *string `type:"string" enum:"LegalHoldStatus"`

	// This is the string title of the legal hold.
	Title *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLegalHoldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetLegalHoldOutput) GoString() string {
	return s.String()
}

// SetCancelDescription sets the CancelDescription field's value.
func (s *GetLegalHoldOutput) SetCancelDescription(v string) *GetLegalHoldOutput {
	s.CancelDescription = &v
	return s
}

// SetCancellationDate sets the CancellationDate field's value.
func (s *GetLegalHoldOutput) SetCancellationDate(v time.Time) *GetLegalHoldOutput {
	s.CancellationDate = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetLegalHoldOutput) SetCreationDate(v time.Time) *GetLegalHoldOutput {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetLegalHoldOutput) SetDescription(v string) *GetLegalHoldOutput {
	s.Description = &v
	return s
}

// SetLegalHoldArn sets the LegalHoldArn field's value.
func (s *GetLegalHoldOutput) SetLegalHoldArn(v string) *GetLegalHoldOutput {
	s.LegalHoldArn = &v
	return s
}

// SetLegalHoldId sets the LegalHoldId field's value.
func (s *GetLegalHoldOutput) SetLegalHoldId(v string) *GetLegalHoldOutput {
	s.LegalHoldId = &v
	return s
}

// SetRecoveryPointSelection sets the RecoveryPointSelection field's value.
func (s *GetLegalHoldOutput) SetRecoveryPointSelection(v *RecoveryPointSelection) *GetLegalHoldOutput {
	s.RecoveryPointSelection = v
	return s
}

// SetRetainRecordUntil sets the RetainRecordUntil field's value.
func (s *GetLegalHoldOutput) SetRetainRecordUntil(v time.Time) *GetLegalHoldOutput {
	s.RetainRecordUntil = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetLegalHoldOutput) SetStatus(v string) *GetLegalHoldOutput {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *GetLegalHoldOutput) SetTitle(v string) *GetLegalHoldOutput {
	s.Title = &v
	return s
}

type GetRecoveryPointRestoreMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// This is the account ID of the specified backup vault.
	BackupVaultAccountId *string `location:"querystring" locationName:"backupVaultAccountId" type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `location:"uri" locationName:"recoveryPointArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryPointRestoreMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryPointRestoreMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecoveryPointRestoreMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecoveryPointRestoreMetadataInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}
	if s.RecoveryPointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointArn"))
	}
	if s.RecoveryPointArn != nil && len(*s.RecoveryPointArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RecoveryPointArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultAccountId sets the BackupVaultAccountId field's value.
func (s *GetRecoveryPointRestoreMetadataInput) SetBackupVaultAccountId(v string) *GetRecoveryPointRestoreMetadataInput {
	s.BackupVaultAccountId = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *GetRecoveryPointRestoreMetadataInput) SetBackupVaultName(v string) *GetRecoveryPointRestoreMetadataInput {
	s.BackupVaultName = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *GetRecoveryPointRestoreMetadataInput) SetRecoveryPointArn(v string) *GetRecoveryPointRestoreMetadataInput {
	s.RecoveryPointArn = &v
	return s
}

type GetRecoveryPointRestoreMetadataOutput struct {
	_ struct{} `type:"structure"`

	// An ARN that uniquely identifies a backup vault; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// This is the resource type associated with the recovery point.
	ResourceType *string `type:"string"`

	// The set of metadata key-value pairs that describe the original configuration
	// of the backed-up resource. These values vary depending on the service that
	// is being restored.
	//
	// RestoreMetadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetRecoveryPointRestoreMetadataOutput's
	// String and GoString methods.
	RestoreMetadata map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryPointRestoreMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryPointRestoreMetadataOutput) GoString() string {
	return s.String()
}

// SetBackupVaultArn sets the BackupVaultArn field's value.
func (s *GetRecoveryPointRestoreMetadataOutput) SetBackupVaultArn(v string) *GetRecoveryPointRestoreMetadataOutput {
	s.BackupVaultArn = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *GetRecoveryPointRestoreMetadataOutput) SetRecoveryPointArn(v string) *GetRecoveryPointRestoreMetadataOutput {
	s.RecoveryPointArn = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetRecoveryPointRestoreMetadataOutput) SetResourceType(v string) *GetRecoveryPointRestoreMetadataOutput {
	s.ResourceType = &v
	return s
}

// SetRestoreMetadata sets the RestoreMetadata field's value.
func (s *GetRecoveryPointRestoreMetadataOutput) SetRestoreMetadata(v map[string]*string) *GetRecoveryPointRestoreMetadataOutput {
	s.RestoreMetadata = v
	return s
}

type GetRestoreJobMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// This is a unique identifier of a restore job within Backup.
	//
	// RestoreJobId is a required field
	RestoreJobId *string `location:"uri" locationName:"restoreJobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreJobMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreJobMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRestoreJobMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRestoreJobMetadataInput"}
	if s.RestoreJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreJobId"))
	}
	if s.RestoreJobId != nil && len(*s.RestoreJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestoreJobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestoreJobId sets the RestoreJobId field's value.
func (s *GetRestoreJobMetadataInput) SetRestoreJobId(v string) *GetRestoreJobMetadataInput {
	s.RestoreJobId = &v
	return s
}

type GetRestoreJobMetadataOutput struct {
	_ struct{} `type:"structure"`

	// This contains the metadata of the specified backup job.
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetRestoreJobMetadataOutput's
	// String and GoString methods.
	Metadata map[string]*string `type:"map" sensitive:"true"`

	// This is a unique identifier of a restore job within Backup.
	RestoreJobId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreJobMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreJobMetadataOutput) GoString() string {
	return s.String()
}

// SetMetadata sets the Metadata field's value.
func (s *GetRestoreJobMetadataOutput) SetMetadata(v map[string]*string) *GetRestoreJobMetadataOutput {
	s.Metadata = v
	return s
}

// SetRestoreJobId sets the RestoreJobId field's value.
func (s *GetRestoreJobMetadataOutput) SetRestoreJobId(v string) *GetRestoreJobMetadataOutput {
	s.RestoreJobId = &v
	return s
}

type GetRestoreTestingInferredMetadataInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// This is the account ID of the specified backup vault.
	BackupVaultAccountId *string `location:"querystring" locationName:"BackupVaultAccountId" type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web ServicesRegion where they are created. They consist of letters,
	// numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"querystring" locationName:"BackupVaultName" type:"string" required:"true"`

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `location:"querystring" locationName:"RecoveryPointArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreTestingInferredMetadataInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreTestingInferredMetadataInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRestoreTestingInferredMetadataInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRestoreTestingInferredMetadataInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.RecoveryPointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultAccountId sets the BackupVaultAccountId field's value.
func (s *GetRestoreTestingInferredMetadataInput) SetBackupVaultAccountId(v string) *GetRestoreTestingInferredMetadataInput {
	s.BackupVaultAccountId = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *GetRestoreTestingInferredMetadataInput) SetBackupVaultName(v string) *GetRestoreTestingInferredMetadataInput {
	s.BackupVaultName = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *GetRestoreTestingInferredMetadataInput) SetRecoveryPointArn(v string) *GetRestoreTestingInferredMetadataInput {
	s.RecoveryPointArn = &v
	return s
}

type GetRestoreTestingInferredMetadataOutput struct {
	_ struct{} `type:"structure"`

	// This is a string map of the metadata inferred from the request.
	//
	// InferredMetadata is a required field
	InferredMetadata map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreTestingInferredMetadataOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreTestingInferredMetadataOutput) GoString() string {
	return s.String()
}

// SetInferredMetadata sets the InferredMetadata field's value.
func (s *GetRestoreTestingInferredMetadataOutput) SetInferredMetadata(v map[string]*string) *GetRestoreTestingInferredMetadataOutput {
	s.InferredMetadata = v
	return s
}

type GetRestoreTestingPlanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Required unique name of the restore testing plan.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `location:"uri" locationName:"RestoreTestingPlanName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreTestingPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreTestingPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRestoreTestingPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRestoreTestingPlanInput"}
	if s.RestoreTestingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreTestingPlanName"))
	}
	if s.RestoreTestingPlanName != nil && len(*s.RestoreTestingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestoreTestingPlanName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *GetRestoreTestingPlanInput) SetRestoreTestingPlanName(v string) *GetRestoreTestingPlanInput {
	s.RestoreTestingPlanName = &v
	return s
}

type GetRestoreTestingPlanOutput struct {
	_ struct{} `type:"structure"`

	// Specifies the body of a restore testing plan. Includes RestoreTestingPlanName.
	//
	// RestoreTestingPlan is a required field
	RestoreTestingPlan *RestoreTestingPlanForGet `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreTestingPlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreTestingPlanOutput) GoString() string {
	return s.String()
}

// SetRestoreTestingPlan sets the RestoreTestingPlan field's value.
func (s *GetRestoreTestingPlanOutput) SetRestoreTestingPlan(v *RestoreTestingPlanForGet) *GetRestoreTestingPlanOutput {
	s.RestoreTestingPlan = v
	return s
}

type GetRestoreTestingSelectionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Required unique name of the restore testing plan.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `location:"uri" locationName:"RestoreTestingPlanName" type:"string" required:"true"`

	// Required unique name of the restore testing selection.
	//
	// RestoreTestingSelectionName is a required field
	RestoreTestingSelectionName *string `location:"uri" locationName:"RestoreTestingSelectionName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreTestingSelectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreTestingSelectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRestoreTestingSelectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRestoreTestingSelectionInput"}
	if s.RestoreTestingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreTestingPlanName"))
	}
	if s.RestoreTestingPlanName != nil && len(*s.RestoreTestingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestoreTestingPlanName", 1))
	}
	if s.RestoreTestingSelectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreTestingSelectionName"))
	}
	if s.RestoreTestingSelectionName != nil && len(*s.RestoreTestingSelectionName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestoreTestingSelectionName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *GetRestoreTestingSelectionInput) SetRestoreTestingPlanName(v string) *GetRestoreTestingSelectionInput {
	s.RestoreTestingPlanName = &v
	return s
}

// SetRestoreTestingSelectionName sets the RestoreTestingSelectionName field's value.
func (s *GetRestoreTestingSelectionInput) SetRestoreTestingSelectionName(v string) *GetRestoreTestingSelectionInput {
	s.RestoreTestingSelectionName = &v
	return s
}

type GetRestoreTestingSelectionOutput struct {
	_ struct{} `type:"structure"`

	// Unique name of the restore testing selection.
	//
	// RestoreTestingSelection is a required field
	RestoreTestingSelection *RestoreTestingSelectionForGet `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreTestingSelectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestoreTestingSelectionOutput) GoString() string {
	return s.String()
}

// SetRestoreTestingSelection sets the RestoreTestingSelection field's value.
func (s *GetRestoreTestingSelectionOutput) SetRestoreTestingSelection(v *RestoreTestingSelectionForGet) *GetRestoreTestingSelectionOutput {
	s.RestoreTestingSelection = v
	return s
}

type GetSupportedResourceTypesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSupportedResourceTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSupportedResourceTypesInput) GoString() string {
	return s.String()
}

type GetSupportedResourceTypesOutput struct {
	_ struct{} `type:"structure"`

	// Contains a string with the supported Amazon Web Services resource types:
	//
	//    * Aurora for Amazon Aurora
	//
	//    * DynamoDB for Amazon DynamoDB
	//
	//    * EBS for Amazon Elastic Block Store
	//
	//    * EC2 for Amazon Elastic Compute Cloud
	//
	//    * EFS for Amazon Elastic File System
	//
	//    * FSX for Amazon FSx
	//
	//    * RDS for Amazon Relational Database Service
	//
	//    * Storage Gateway for Storage Gateway
	//
	//    * DocDB for Amazon DocumentDB (with MongoDB compatibility)
	//
	//    * Neptune for Amazon Neptune
	ResourceTypes []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSupportedResourceTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSupportedResourceTypesOutput) GoString() string {
	return s.String()
}

// SetResourceTypes sets the ResourceTypes field's value.
func (s *GetSupportedResourceTypesOutput) SetResourceTypes(v []*string) *GetSupportedResourceTypesOutput {
	s.ResourceTypes = v
	return s
}

// Indicates that something is wrong with a parameter's value. For example,
// the value is out of range.
type InvalidParameterValueException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Context *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValueException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValueException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterValueException(v protocol.ResponseMetadata) error {
	return &InvalidParameterValueException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterValueException) Code() string {
	return "InvalidParameterValueException"
}

// Message returns the exception's message.
func (s *InvalidParameterValueException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterValueException) OrigErr() error {
	return nil
}

func (s *InvalidParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterValueException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterValueException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates that something is wrong with the input to the request. For example,
// a parameter is of the wrong type.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Context *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Backup is already performing an action on this recovery point. It can't perform
// the action you requested until the first action finishes. Try again later.
type InvalidResourceStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Context *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourceStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourceStateException) GoString() string {
	return s.String()
}

func newErrorInvalidResourceStateException(v protocol.ResponseMetadata) error {
	return &InvalidResourceStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourceStateException) Code() string {
	return "InvalidResourceStateException"
}

// Message returns the exception's message.
func (s *InvalidResourceStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourceStateException) OrigErr() error {
	return nil
}

func (s *InvalidResourceStateException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourceStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourceStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains detailed information about a backup job.
type Job struct {
	_ struct{} `type:"structure"`

	// The account ID that owns the backup job.
	AccountId *string `type:"string"`

	// Uniquely identifies a request to Backup to back up a resource.
	BackupJobId *string `type:"string"`

	// Specifies the backup option for a selected resource. This option is only
	// available for Windows Volume Shadow Copy Service (VSS) backup jobs.
	//
	// Valid values: Set to "WindowsVSS":"enabled" to enable the WindowsVSS backup
	// option and create a Windows VSS backup. Set to "WindowsVSS":"disabled" to
	// create a regular backup. If you specify an invalid option, you get an InvalidParameterValueException
	// exception.
	BackupOptions map[string]*string `type:"map"`

	// The size, in bytes, of a backup.
	BackupSizeInBytes *int64 `type:"long"`

	// Represents the type of backup for a backup job.
	BackupType *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup vault; for
	// example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	BackupVaultName *string `type:"string"`

	// The size in bytes transferred to a backup vault at the time that the job
	// status was queried.
	BytesTransferred *int64 `type:"long"`

	// The date and time a job to create a backup job is completed, in Unix format
	// and Coordinated Universal Time (UTC). The value of CompletionDate is accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time `type:"timestamp"`

	// Contains identifying information about the creation of a backup job, including
	// the BackupPlanArn, BackupPlanId, BackupPlanVersion, and BackupRuleId of the
	// backup plan used to create it.
	CreatedBy *RecoveryPointCreator `type:"structure"`

	// The date and time a backup job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// The date and time a job to back up resources is expected to be completed,
	// in Unix format and Coordinated Universal Time (UTC). The value of ExpectedCompletionDate
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	ExpectedCompletionDate *time.Time `type:"timestamp"`

	// Specifies the IAM role ARN used to create the target recovery point. IAM
	// roles other than the default role must include either AWSBackup or AwsBackup
	// in the role name. For example, arn:aws:iam::123456789012:role/AWSBackupRDSAccess.
	// Role names without those strings lack permissions to perform backup jobs.
	IamRoleArn *string `type:"string"`

	// This is the date on which the backup job was initiated.
	InitiationDate *time.Time `type:"timestamp"`

	// This is a boolean value indicating this is a parent (composite) backup job.
	IsParent *bool `type:"boolean"`

	// This parameter is the job count for the specified message category.
	//
	// Example strings may include AccessDenied, SUCCESS, AGGREGATE_ALL, and INVALIDPARAMETERS.
	// See Monitoring (https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
	// for a list of MessageCategory strings.
	//
	// The the value ANY returns count of all message categories.
	//
	// AGGREGATE_ALL aggregates job counts for all message categories and returns
	// the sum.
	MessageCategory *string `type:"string"`

	// This uniquely identifies a request to Backup to back up a resource. The return
	// will be the parent (composite) job ID.
	ParentJobId *string `type:"string"`

	// Contains an estimated percentage complete of a job at the time the job status
	// was queried.
	PercentDone *string `type:"string"`

	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// An ARN that uniquely identifies a resource. The format of the ARN depends
	// on the resource type.
	ResourceArn *string `type:"string"`

	// This is the non-unique name of the resource that belongs to the specified
	// backup.
	ResourceName *string `type:"string"`

	// The type of Amazon Web Services resource to be backed up; for example, an
	// Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database
	// Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS)
	// backups, the only supported resource type is Amazon EC2.
	ResourceType *string `type:"string"`

	// Specifies the time in Unix format and Coordinated Universal Time (UTC) when
	// a backup job must be started before it is canceled. The value is calculated
	// by adding the start window to the scheduled time. So if the scheduled time
	// were 6:00 PM and the start window is 2 hours, the StartBy time would be 8:00
	// PM on the date specified. The value of StartBy is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	StartBy *time.Time `type:"timestamp"`

	// The current state of a backup job.
	State *string `type:"string" enum:"JobState"`

	// A detailed message explaining the status of the job to back up a resource.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Job) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Job) SetAccountId(v string) *Job {
	s.AccountId = &v
	return s
}

// SetBackupJobId sets the BackupJobId field's value.
func (s *Job) SetBackupJobId(v string) *Job {
	s.BackupJobId = &v
	return s
}

// SetBackupOptions sets the BackupOptions field's value.
func (s *Job) SetBackupOptions(v map[string]*string) *Job {
	s.BackupOptions = v
	return s
}

// SetBackupSizeInBytes sets the BackupSizeInBytes field's value.
func (s *Job) SetBackupSizeInBytes(v int64) *Job {
	s.BackupSizeInBytes = &v
	return s
}

// SetBackupType sets the BackupType field's value.
func (s *Job) SetBackupType(v string) *Job {
	s.BackupType = &v
	return s
}

// SetBackupVaultArn sets the BackupVaultArn field's value.
func (s *Job) SetBackupVaultArn(v string) *Job {
	s.BackupVaultArn = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *Job) SetBackupVaultName(v string) *Job {
	s.BackupVaultName = &v
	return s
}

// SetBytesTransferred sets the BytesTransferred field's value.
func (s *Job) SetBytesTransferred(v int64) *Job {
	s.BytesTransferred = &v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *Job) SetCompletionDate(v time.Time) *Job {
	s.CompletionDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *Job) SetCreatedBy(v *RecoveryPointCreator) *Job {
	s.CreatedBy = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Job) SetCreationDate(v time.Time) *Job {
	s.CreationDate = &v
	return s
}

// SetExpectedCompletionDate sets the ExpectedCompletionDate field's value.
func (s *Job) SetExpectedCompletionDate(v time.Time) *Job {
	s.ExpectedCompletionDate = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *Job) SetIamRoleArn(v string) *Job {
	s.IamRoleArn = &v
	return s
}

// SetInitiationDate sets the InitiationDate field's value.
func (s *Job) SetInitiationDate(v time.Time) *Job {
	s.InitiationDate = &v
	return s
}

// SetIsParent sets the IsParent field's value.
func (s *Job) SetIsParent(v bool) *Job {
	s.IsParent = &v
	return s
}

// SetMessageCategory sets the MessageCategory field's value.
func (s *Job) SetMessageCategory(v string) *Job {
	s.MessageCategory = &v
	return s
}

// SetParentJobId sets the ParentJobId field's value.
func (s *Job) SetParentJobId(v string) *Job {
	s.ParentJobId = &v
	return s
}

// SetPercentDone sets the PercentDone field's value.
func (s *Job) SetPercentDone(v string) *Job {
	s.PercentDone = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *Job) SetRecoveryPointArn(v string) *Job {
	s.RecoveryPointArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *Job) SetResourceArn(v string) *Job {
	s.ResourceArn = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *Job) SetResourceName(v string) *Job {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *Job) SetResourceType(v string) *Job {
	s.ResourceType = &v
	return s
}

// SetStartBy sets the StartBy field's value.
func (s *Job) SetStartBy(v time.Time) *Job {
	s.StartBy = &v
	return s
}

// SetState sets the State field's value.
func (s *Job) SetState(v string) *Job {
	s.State = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *Job) SetStatusMessage(v string) *Job {
	s.StatusMessage = &v
	return s
}

// Pair of two related strings. Allowed characters are letters, white space,
// and numbers that can be represented in UTF-8 and the following characters:
// + - = . _ : /
type KeyValue struct {
	_ struct{} `type:"structure"`

	// The tag key (String). The key can't start with aws:.
	//
	// Length Constraints: Minimum length of 1. Maximum length of 128.
	//
	// Pattern: ^(?![aA]{1}[wW]{1}[sS]{1}:)([\p{L}\p{Z}\p{N}_.:/=+\-@]+)$
	//
	// Key is a required field
	Key *string `type:"string" required:"true"`

	// The value of the key.
	//
	// Length Constraints: Maximum length of 256.
	//
	// Pattern: ^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KeyValue) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KeyValue) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KeyValue"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *KeyValue) SetKey(v string) *KeyValue {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *KeyValue) SetValue(v string) *KeyValue {
	s.Value = &v
	return s
}

// A legal hold is an administrative tool that helps prevent backups from being
// deleted while under a hold. While the hold is in place, backups under a hold
// cannot be deleted and lifecycle policies that would alter the backup status
// (such as transition to cold storage) are delayed until the legal hold is
// removed. A backup can have more than one legal hold. Legal holds are applied
// to one or more backups (also known as recovery points). These backups can
// be filtered by resource types and by resource IDs.
type LegalHold struct {
	_ struct{} `type:"structure"`

	// This is the time in number format when legal hold was cancelled.
	CancellationDate *time.Time `type:"timestamp"`

	// This is the time in number format when legal hold was created.
	CreationDate *time.Time `type:"timestamp"`

	// This is the description of a legal hold.
	Description *string `type:"string"`

	// This is an Amazon Resource Number (ARN) that uniquely identifies the legal
	// hold; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	LegalHoldArn *string `type:"string"`

	// ID of specific legal hold on one or more recovery points.
	LegalHoldId *string `type:"string"`

	// This is the status of the legal hold. Statuses can be ACTIVE, CREATING, CANCELED,
	// and CANCELING.
	Status *string `type:"string" enum:"LegalHoldStatus"`

	// This is the title of a legal hold.
	Title *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LegalHold) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LegalHold) GoString() string {
	return s.String()
}

// SetCancellationDate sets the CancellationDate field's value.
func (s *LegalHold) SetCancellationDate(v time.Time) *LegalHold {
	s.CancellationDate = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *LegalHold) SetCreationDate(v time.Time) *LegalHold {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *LegalHold) SetDescription(v string) *LegalHold {
	s.Description = &v
	return s
}

// SetLegalHoldArn sets the LegalHoldArn field's value.
func (s *LegalHold) SetLegalHoldArn(v string) *LegalHold {
	s.LegalHoldArn = &v
	return s
}

// SetLegalHoldId sets the LegalHoldId field's value.
func (s *LegalHold) SetLegalHoldId(v string) *LegalHold {
	s.LegalHoldId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *LegalHold) SetStatus(v string) *LegalHold {
	s.Status = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *LegalHold) SetTitle(v string) *LegalHold {
	s.Title = &v
	return s
}

// Contains an array of Transition objects specifying how long in days before
// a recovery point transitions to cold storage or is deleted.
//
// Backups transitioned to cold storage must be stored in cold storage for a
// minimum of 90 days. Therefore, on the console, the “retention” setting
// must be 90 days greater than the “transition to cold after days” setting.
// The “transition to cold after days” setting cannot be changed after a
// backup has been transitioned to cold.
//
// Resource types that are able to be transitioned to cold storage are listed
// in the "Lifecycle to cold storage" section of the Feature availability by
// resource (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
// table. Backup ignores this expression for other resource types.
type Lifecycle struct {
	_ struct{} `type:"structure"`

	// Specifies the number of days after creation that a recovery point is deleted.
	// Must be greater than 90 days plus MoveToColdStorageAfterDays.
	DeleteAfterDays *int64 `type:"long"`

	// Specifies the number of days after creation that a recovery point is moved
	// to cold storage.
	MoveToColdStorageAfterDays *int64 `type:"long"`

	// Optional Boolean. If this is true, this setting will instruct your backup
	// plan to transition supported resources to archive (cold) storage tier in
	// accordance with your lifecycle settings.
	OptInToArchiveForSupportedResources *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Lifecycle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Lifecycle) GoString() string {
	return s.String()
}

// SetDeleteAfterDays sets the DeleteAfterDays field's value.
func (s *Lifecycle) SetDeleteAfterDays(v int64) *Lifecycle {
	s.DeleteAfterDays = &v
	return s
}

// SetMoveToColdStorageAfterDays sets the MoveToColdStorageAfterDays field's value.
func (s *Lifecycle) SetMoveToColdStorageAfterDays(v int64) *Lifecycle {
	s.MoveToColdStorageAfterDays = &v
	return s
}

// SetOptInToArchiveForSupportedResources sets the OptInToArchiveForSupportedResources field's value.
func (s *Lifecycle) SetOptInToArchiveForSupportedResources(v bool) *Lifecycle {
	s.OptInToArchiveForSupportedResources = &v
	return s
}

// A limit in the request has been exceeded; for example, a maximum number of
// items allowed in a request.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Context *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListBackupJobSummariesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Returns the job count for the specified account.
	//
	// If the request is sent from a member account or an account not part of Amazon
	// Web Services Organizations, jobs within requestor's account will be returned.
	//
	// Root, admin, and delegated administrator accounts can use the value ANY to
	// return job counts from every account in the organization.
	//
	// AGGREGATE_ALL aggregates job counts from all accounts within the authenticated
	// organization, then returns the sum.
	AccountId *string `location:"querystring" locationName:"AccountId" type:"string"`

	// This is the period that sets the boundaries for returned results.
	//
	// Acceptable values include
	//
	//    * ONE_DAY for daily job count for the prior 14 days.
	//
	//    * SEVEN_DAYS for the aggregated job count for the prior 7 days.
	//
	//    * FOURTEEN_DAYS for aggregated job count for prior 14 days.
	AggregationPeriod *string `location:"querystring" locationName:"AggregationPeriod" type:"string" enum:"AggregationPeriod"`

	// This parameter sets the maximum number of items to be returned.
	//
	// The value is an integer. Range of accepted values is from 1 to 500.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// This parameter returns the job count for the specified message category.
	//
	// Example accepted strings include AccessDenied, Success, and InvalidParameters.
	// See Monitoring (https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
	// for a list of accepted MessageCategory strings.
	//
	// The the value ANY returns count of all message categories.
	//
	// AGGREGATE_ALL aggregates job counts for all message categories and returns
	// the sum.
	MessageCategory *string `location:"querystring" locationName:"MessageCategory" type:"string"`

	// The next item following a partial list of returned resources. For example,
	// if a request is made to return MaxResults number of resources, NextToken
	// allows you to return more items in your list starting at the location pointed
	// to by the next token.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// Returns the job count for the specified resource type. Use request GetSupportedResourceTypes
	// to obtain strings for supported resource types.
	//
	// The the value ANY returns count of all resource types.
	//
	// AGGREGATE_ALL aggregates job counts for all resource types and returns the
	// sum.
	//
	// The type of Amazon Web Services resource to be backed up; for example, an
	// Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database
	// Service (Amazon RDS) database.
	ResourceType *string `location:"querystring" locationName:"ResourceType" type:"string"`

	// This parameter returns the job count for jobs with the specified state.
	//
	// The the value ANY returns count of all states.
	//
	// AGGREGATE_ALL aggregates job counts for all states and returns the sum.
	State *string `location:"querystring" locationName:"State" type:"string" enum:"BackupJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupJobSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupJobSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackupJobSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBackupJobSummariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListBackupJobSummariesInput) SetAccountId(v string) *ListBackupJobSummariesInput {
	s.AccountId = &v
	return s
}

// SetAggregationPeriod sets the AggregationPeriod field's value.
func (s *ListBackupJobSummariesInput) SetAggregationPeriod(v string) *ListBackupJobSummariesInput {
	s.AggregationPeriod = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBackupJobSummariesInput) SetMaxResults(v int64) *ListBackupJobSummariesInput {
	s.MaxResults = &v
	return s
}

// SetMessageCategory sets the MessageCategory field's value.
func (s *ListBackupJobSummariesInput) SetMessageCategory(v string) *ListBackupJobSummariesInput {
	s.MessageCategory = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupJobSummariesInput) SetNextToken(v string) *ListBackupJobSummariesInput {
	s.NextToken = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListBackupJobSummariesInput) SetResourceType(v string) *ListBackupJobSummariesInput {
	s.ResourceType = &v
	return s
}

// SetState sets the State field's value.
func (s *ListBackupJobSummariesInput) SetState(v string) *ListBackupJobSummariesInput {
	s.State = &v
	return s
}

type ListBackupJobSummariesOutput struct {
	_ struct{} `type:"structure"`

	// This is the period that sets the boundaries for returned results.
	//
	//    * ONE_DAY for daily job count for the prior 14 days.
	//
	//    * SEVEN_DAYS for the aggregated job count for the prior 7 days.
	//
	//    * FOURTEEN_DAYS for aggregated job count for prior 14 days.
	AggregationPeriod *string `type:"string"`

	// This request returns a summary that contains Region, Account, State, ResourceType,
	// MessageCategory, StartTime, EndTime, and Count of included jobs.
	BackupJobSummaries []*BackupJobSummary `type:"list"`

	// The next item following a partial list of returned resources. For example,
	// if a request is made to return MaxResults number of resources, NextToken
	// allows you to return more items in your list starting at the location pointed
	// to by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupJobSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupJobSummariesOutput) GoString() string {
	return s.String()
}

// SetAggregationPeriod sets the AggregationPeriod field's value.
func (s *ListBackupJobSummariesOutput) SetAggregationPeriod(v string) *ListBackupJobSummariesOutput {
	s.AggregationPeriod = &v
	return s
}

// SetBackupJobSummaries sets the BackupJobSummaries field's value.
func (s *ListBackupJobSummariesOutput) SetBackupJobSummaries(v []*BackupJobSummary) *ListBackupJobSummariesOutput {
	s.BackupJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupJobSummariesOutput) SetNextToken(v string) *ListBackupJobSummariesOutput {
	s.NextToken = &v
	return s
}

type ListBackupJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The account ID to list the jobs from. Returns only backup jobs associated
	// with the specified account ID.
	//
	// If used from an Organizations management account, passing * returns all jobs
	// across the organization.
	ByAccountId *string `location:"querystring" locationName:"accountId" type:"string"`

	// Returns only backup jobs that will be stored in the specified backup vault.
	// Backup vaults are identified by names that are unique to the account used
	// to create them and the Amazon Web Services Region where they are created.
	// They consist of lowercase letters, numbers, and hyphens.
	ByBackupVaultName *string `location:"querystring" locationName:"backupVaultName" type:"string"`

	// Returns only backup jobs completed after a date expressed in Unix format
	// and Coordinated Universal Time (UTC).
	ByCompleteAfter *time.Time `location:"querystring" locationName:"completeAfter" type:"timestamp"`

	// Returns only backup jobs completed before a date expressed in Unix format
	// and Coordinated Universal Time (UTC).
	ByCompleteBefore *time.Time `location:"querystring" locationName:"completeBefore" type:"timestamp"`

	// Returns only backup jobs that were created after the specified date.
	ByCreatedAfter *time.Time `location:"querystring" locationName:"createdAfter" type:"timestamp"`

	// Returns only backup jobs that were created before the specified date.
	ByCreatedBefore *time.Time `location:"querystring" locationName:"createdBefore" type:"timestamp"`

	// This is an optional parameter that can be used to filter out jobs with a
	// MessageCategory which matches the value you input.
	//
	// Example strings may include AccessDenied, SUCCESS, AGGREGATE_ALL, and InvalidParameters.
	//
	// View Monitoring (https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
	//
	// The wildcard () returns count of all message categories.
	//
	// AGGREGATE_ALL aggregates job counts for all message categories and returns
	// the sum.
	ByMessageCategory *string `location:"querystring" locationName:"messageCategory" type:"string"`

	// This is a filter to list child (nested) jobs based on parent job ID.
	ByParentJobId *string `location:"querystring" locationName:"parentJobId" type:"string"`

	// Returns only backup jobs that match the specified resource Amazon Resource
	// Name (ARN).
	ByResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string"`

	// Returns only backup jobs for the specified resources:
	//
	//    * Aurora for Amazon Aurora
	//
	//    * CloudFormation for CloudFormation
	//
	//    * DocumentDB for Amazon DocumentDB (with MongoDB compatibility)
	//
	//    * DynamoDB for Amazon DynamoDB
	//
	//    * EBS for Amazon Elastic Block Store
	//
	//    * EC2 for Amazon Elastic Compute Cloud
	//
	//    * EFS for Amazon Elastic File System
	//
	//    * FSx for Amazon FSx
	//
	//    * Neptune for Amazon Neptune
	//
	//    * Redshift for Amazon Redshift
	//
	//    * RDS for Amazon Relational Database Service
	//
	//    * SAP HANA on Amazon EC2 for SAP HANA databases
	//
	//    * Storage Gateway for Storage Gateway
	//
	//    * S3 for Amazon S3
	//
	//    * Timestream for Amazon Timestream
	//
	//    * VirtualMachine for virtual machines
	ByResourceType *string `location:"querystring" locationName:"resourceType" type:"string"`

	// Returns only backup jobs that are in the specified state.
	ByState *string `location:"querystring" locationName:"state" type:"string" enum:"JobState"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackupJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBackupJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByAccountId sets the ByAccountId field's value.
func (s *ListBackupJobsInput) SetByAccountId(v string) *ListBackupJobsInput {
	s.ByAccountId = &v
	return s
}

// SetByBackupVaultName sets the ByBackupVaultName field's value.
func (s *ListBackupJobsInput) SetByBackupVaultName(v string) *ListBackupJobsInput {
	s.ByBackupVaultName = &v
	return s
}

// SetByCompleteAfter sets the ByCompleteAfter field's value.
func (s *ListBackupJobsInput) SetByCompleteAfter(v time.Time) *ListBackupJobsInput {
	s.ByCompleteAfter = &v
	return s
}

// SetByCompleteBefore sets the ByCompleteBefore field's value.
func (s *ListBackupJobsInput) SetByCompleteBefore(v time.Time) *ListBackupJobsInput {
	s.ByCompleteBefore = &v
	return s
}

// SetByCreatedAfter sets the ByCreatedAfter field's value.
func (s *ListBackupJobsInput) SetByCreatedAfter(v time.Time) *ListBackupJobsInput {
	s.ByCreatedAfter = &v
	return s
}

// SetByCreatedBefore sets the ByCreatedBefore field's value.
func (s *ListBackupJobsInput) SetByCreatedBefore(v time.Time) *ListBackupJobsInput {
	s.ByCreatedBefore = &v
	return s
}

// SetByMessageCategory sets the ByMessageCategory field's value.
func (s *ListBackupJobsInput) SetByMessageCategory(v string) *ListBackupJobsInput {
	s.ByMessageCategory = &v
	return s
}

// SetByParentJobId sets the ByParentJobId field's value.
func (s *ListBackupJobsInput) SetByParentJobId(v string) *ListBackupJobsInput {
	s.ByParentJobId = &v
	return s
}

// SetByResourceArn sets the ByResourceArn field's value.
func (s *ListBackupJobsInput) SetByResourceArn(v string) *ListBackupJobsInput {
	s.ByResourceArn = &v
	return s
}

// SetByResourceType sets the ByResourceType field's value.
func (s *ListBackupJobsInput) SetByResourceType(v string) *ListBackupJobsInput {
	s.ByResourceType = &v
	return s
}

// SetByState sets the ByState field's value.
func (s *ListBackupJobsInput) SetByState(v string) *ListBackupJobsInput {
	s.ByState = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBackupJobsInput) SetMaxResults(v int64) *ListBackupJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupJobsInput) SetNextToken(v string) *ListBackupJobsInput {
	s.NextToken = &v
	return s
}

type ListBackupJobsOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures containing metadata about your backup jobs returned
	// in JSON format.
	BackupJobs []*Job `type:"list"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupJobsOutput) GoString() string {
	return s.String()
}

// SetBackupJobs sets the BackupJobs field's value.
func (s *ListBackupJobsOutput) SetBackupJobs(v []*Job) *ListBackupJobsOutput {
	s.BackupJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupJobsOutput) SetNextToken(v string) *ListBackupJobsOutput {
	s.NextToken = &v
	return s
}

type ListBackupPlanTemplatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupPlanTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupPlanTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackupPlanTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBackupPlanTemplatesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBackupPlanTemplatesInput) SetMaxResults(v int64) *ListBackupPlanTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupPlanTemplatesInput) SetNextToken(v string) *ListBackupPlanTemplatesInput {
	s.NextToken = &v
	return s
}

type ListBackupPlanTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// An array of template list items containing metadata about your saved templates.
	BackupPlanTemplatesList []*PlanTemplatesListMember `type:"list"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupPlanTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupPlanTemplatesOutput) GoString() string {
	return s.String()
}

// SetBackupPlanTemplatesList sets the BackupPlanTemplatesList field's value.
func (s *ListBackupPlanTemplatesOutput) SetBackupPlanTemplatesList(v []*PlanTemplatesListMember) *ListBackupPlanTemplatesOutput {
	s.BackupPlanTemplatesList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupPlanTemplatesOutput) SetNextToken(v string) *ListBackupPlanTemplatesOutput {
	s.NextToken = &v
	return s
}

type ListBackupPlanVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Uniquely identifies a backup plan.
	//
	// BackupPlanId is a required field
	BackupPlanId *string `location:"uri" locationName:"backupPlanId" type:"string" required:"true"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupPlanVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupPlanVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackupPlanVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBackupPlanVersionsInput"}
	if s.BackupPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlanId"))
	}
	if s.BackupPlanId != nil && len(*s.BackupPlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupPlanId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *ListBackupPlanVersionsInput) SetBackupPlanId(v string) *ListBackupPlanVersionsInput {
	s.BackupPlanId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBackupPlanVersionsInput) SetMaxResults(v int64) *ListBackupPlanVersionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupPlanVersionsInput) SetNextToken(v string) *ListBackupPlanVersionsInput {
	s.NextToken = &v
	return s
}

type ListBackupPlanVersionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of version list items containing metadata about your backup plans.
	BackupPlanVersionsList []*PlansListMember `type:"list"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupPlanVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupPlanVersionsOutput) GoString() string {
	return s.String()
}

// SetBackupPlanVersionsList sets the BackupPlanVersionsList field's value.
func (s *ListBackupPlanVersionsOutput) SetBackupPlanVersionsList(v []*PlansListMember) *ListBackupPlanVersionsOutput {
	s.BackupPlanVersionsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupPlanVersionsOutput) SetNextToken(v string) *ListBackupPlanVersionsOutput {
	s.NextToken = &v
	return s
}

type ListBackupPlansInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A Boolean value with a default value of FALSE that returns deleted backup
	// plans when set to TRUE.
	IncludeDeleted *bool `location:"querystring" locationName:"includeDeleted" type:"boolean"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupPlansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupPlansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackupPlansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBackupPlansInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIncludeDeleted sets the IncludeDeleted field's value.
func (s *ListBackupPlansInput) SetIncludeDeleted(v bool) *ListBackupPlansInput {
	s.IncludeDeleted = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBackupPlansInput) SetMaxResults(v int64) *ListBackupPlansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupPlansInput) SetNextToken(v string) *ListBackupPlansInput {
	s.NextToken = &v
	return s
}

type ListBackupPlansOutput struct {
	_ struct{} `type:"structure"`

	// An array of backup plan list items containing metadata about your saved backup
	// plans.
	BackupPlansList []*PlansListMember `type:"list"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupPlansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupPlansOutput) GoString() string {
	return s.String()
}

// SetBackupPlansList sets the BackupPlansList field's value.
func (s *ListBackupPlansOutput) SetBackupPlansList(v []*PlansListMember) *ListBackupPlansOutput {
	s.BackupPlansList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupPlansOutput) SetNextToken(v string) *ListBackupPlansOutput {
	s.NextToken = &v
	return s
}

type ListBackupSelectionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Uniquely identifies a backup plan.
	//
	// BackupPlanId is a required field
	BackupPlanId *string `location:"uri" locationName:"backupPlanId" type:"string" required:"true"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupSelectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupSelectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackupSelectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBackupSelectionsInput"}
	if s.BackupPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlanId"))
	}
	if s.BackupPlanId != nil && len(*s.BackupPlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupPlanId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *ListBackupSelectionsInput) SetBackupPlanId(v string) *ListBackupSelectionsInput {
	s.BackupPlanId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBackupSelectionsInput) SetMaxResults(v int64) *ListBackupSelectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupSelectionsInput) SetNextToken(v string) *ListBackupSelectionsInput {
	s.NextToken = &v
	return s
}

type ListBackupSelectionsOutput struct {
	_ struct{} `type:"structure"`

	// An array of backup selection list items containing metadata about each resource
	// in the list.
	BackupSelectionsList []*SelectionsListMember `type:"list"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupSelectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupSelectionsOutput) GoString() string {
	return s.String()
}

// SetBackupSelectionsList sets the BackupSelectionsList field's value.
func (s *ListBackupSelectionsOutput) SetBackupSelectionsList(v []*SelectionsListMember) *ListBackupSelectionsOutput {
	s.BackupSelectionsList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupSelectionsOutput) SetNextToken(v string) *ListBackupSelectionsOutput {
	s.NextToken = &v
	return s
}

type ListBackupVaultsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// This parameter will sort the list of vaults by shared vaults.
	ByShared *bool `location:"querystring" locationName:"shared" type:"boolean"`

	// This parameter will sort the list of vaults by vault type.
	ByVaultType *string `location:"querystring" locationName:"vaultType" type:"string" enum:"VaultType"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupVaultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupVaultsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListBackupVaultsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListBackupVaultsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByShared sets the ByShared field's value.
func (s *ListBackupVaultsInput) SetByShared(v bool) *ListBackupVaultsInput {
	s.ByShared = &v
	return s
}

// SetByVaultType sets the ByVaultType field's value.
func (s *ListBackupVaultsInput) SetByVaultType(v string) *ListBackupVaultsInput {
	s.ByVaultType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListBackupVaultsInput) SetMaxResults(v int64) *ListBackupVaultsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupVaultsInput) SetNextToken(v string) *ListBackupVaultsInput {
	s.NextToken = &v
	return s
}

type ListBackupVaultsOutput struct {
	_ struct{} `type:"structure"`

	// An array of backup vault list members containing vault metadata, including
	// Amazon Resource Name (ARN), display name, creation date, number of saved
	// recovery points, and encryption information if the resources saved in the
	// backup vault are encrypted.
	BackupVaultList []*VaultListMember `type:"list"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupVaultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListBackupVaultsOutput) GoString() string {
	return s.String()
}

// SetBackupVaultList sets the BackupVaultList field's value.
func (s *ListBackupVaultsOutput) SetBackupVaultList(v []*VaultListMember) *ListBackupVaultsOutput {
	s.BackupVaultList = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListBackupVaultsOutput) SetNextToken(v string) *ListBackupVaultsOutput {
	s.NextToken = &v
	return s
}

type ListCopyJobSummariesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Returns the job count for the specified account.
	//
	// If the request is sent from a member account or an account not part of Amazon
	// Web Services Organizations, jobs within requestor's account will be returned.
	//
	// Root, admin, and delegated administrator accounts can use the value ANY to
	// return job counts from every account in the organization.
	//
	// AGGREGATE_ALL aggregates job counts from all accounts within the authenticated
	// organization, then returns the sum.
	AccountId *string `location:"querystring" locationName:"AccountId" type:"string"`

	// This is the period that sets the boundaries for returned results.
	//
	//    * ONE_DAY for daily job count for the prior 14 days.
	//
	//    * SEVEN_DAYS for the aggregated job count for the prior 7 days.
	//
	//    * FOURTEEN_DAYS for aggregated job count for prior 14 days.
	AggregationPeriod *string `location:"querystring" locationName:"AggregationPeriod" type:"string" enum:"AggregationPeriod"`

	// This parameter sets the maximum number of items to be returned.
	//
	// The value is an integer. Range of accepted values is from 1 to 500.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// This parameter returns the job count for the specified message category.
	//
	// Example accepted strings include AccessDenied, Success, and InvalidParameters.
	// See Monitoring (https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
	// for a list of accepted MessageCategory strings.
	//
	// The the value ANY returns count of all message categories.
	//
	// AGGREGATE_ALL aggregates job counts for all message categories and returns
	// the sum.
	MessageCategory *string `location:"querystring" locationName:"MessageCategory" type:"string"`

	// The next item following a partial list of returned resources. For example,
	// if a request is made to return MaxResults number of resources, NextToken
	// allows you to return more items in your list starting at the location pointed
	// to by the next token.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// Returns the job count for the specified resource type. Use request GetSupportedResourceTypes
	// to obtain strings for supported resource types.
	//
	// The the value ANY returns count of all resource types.
	//
	// AGGREGATE_ALL aggregates job counts for all resource types and returns the
	// sum.
	//
	// The type of Amazon Web Services resource to be backed up; for example, an
	// Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database
	// Service (Amazon RDS) database.
	ResourceType *string `location:"querystring" locationName:"ResourceType" type:"string"`

	// This parameter returns the job count for jobs with the specified state.
	//
	// The the value ANY returns count of all states.
	//
	// AGGREGATE_ALL aggregates job counts for all states and returns the sum.
	State *string `location:"querystring" locationName:"State" type:"string" enum:"CopyJobStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCopyJobSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCopyJobSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCopyJobSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCopyJobSummariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListCopyJobSummariesInput) SetAccountId(v string) *ListCopyJobSummariesInput {
	s.AccountId = &v
	return s
}

// SetAggregationPeriod sets the AggregationPeriod field's value.
func (s *ListCopyJobSummariesInput) SetAggregationPeriod(v string) *ListCopyJobSummariesInput {
	s.AggregationPeriod = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCopyJobSummariesInput) SetMaxResults(v int64) *ListCopyJobSummariesInput {
	s.MaxResults = &v
	return s
}

// SetMessageCategory sets the MessageCategory field's value.
func (s *ListCopyJobSummariesInput) SetMessageCategory(v string) *ListCopyJobSummariesInput {
	s.MessageCategory = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCopyJobSummariesInput) SetNextToken(v string) *ListCopyJobSummariesInput {
	s.NextToken = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListCopyJobSummariesInput) SetResourceType(v string) *ListCopyJobSummariesInput {
	s.ResourceType = &v
	return s
}

// SetState sets the State field's value.
func (s *ListCopyJobSummariesInput) SetState(v string) *ListCopyJobSummariesInput {
	s.State = &v
	return s
}

type ListCopyJobSummariesOutput struct {
	_ struct{} `type:"structure"`

	// This is the period that sets the boundaries for returned results.
	//
	//    * ONE_DAY for daily job count for the prior 14 days.
	//
	//    * SEVEN_DAYS for the aggregated job count for the prior 7 days.
	//
	//    * FOURTEEN_DAYS for aggregated job count for prior 14 days.
	AggregationPeriod *string `type:"string"`

	// This return shows a summary that contains Region, Account, State, ResourceType,
	// MessageCategory, StartTime, EndTime, and Count of included jobs.
	CopyJobSummaries []*CopyJobSummary `type:"list"`

	// The next item following a partial list of returned resources. For example,
	// if a request is made to return MaxResults number of resources, NextToken
	// allows you to return more items in your list starting at the location pointed
	// to by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCopyJobSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCopyJobSummariesOutput) GoString() string {
	return s.String()
}

// SetAggregationPeriod sets the AggregationPeriod field's value.
func (s *ListCopyJobSummariesOutput) SetAggregationPeriod(v string) *ListCopyJobSummariesOutput {
	s.AggregationPeriod = &v
	return s
}

// SetCopyJobSummaries sets the CopyJobSummaries field's value.
func (s *ListCopyJobSummariesOutput) SetCopyJobSummaries(v []*CopyJobSummary) *ListCopyJobSummariesOutput {
	s.CopyJobSummaries = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCopyJobSummariesOutput) SetNextToken(v string) *ListCopyJobSummariesOutput {
	s.NextToken = &v
	return s
}

type ListCopyJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The account ID to list the jobs from. Returns only copy jobs associated with
	// the specified account ID.
	ByAccountId *string `location:"querystring" locationName:"accountId" type:"string"`

	// Returns only copy jobs completed after a date expressed in Unix format and
	// Coordinated Universal Time (UTC).
	ByCompleteAfter *time.Time `location:"querystring" locationName:"completeAfter" type:"timestamp"`

	// Returns only copy jobs completed before a date expressed in Unix format and
	// Coordinated Universal Time (UTC).
	ByCompleteBefore *time.Time `location:"querystring" locationName:"completeBefore" type:"timestamp"`

	// Returns only copy jobs that were created after the specified date.
	ByCreatedAfter *time.Time `location:"querystring" locationName:"createdAfter" type:"timestamp"`

	// Returns only copy jobs that were created before the specified date.
	ByCreatedBefore *time.Time `location:"querystring" locationName:"createdBefore" type:"timestamp"`

	// An Amazon Resource Name (ARN) that uniquely identifies a source backup vault
	// to copy from; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	ByDestinationVaultArn *string `location:"querystring" locationName:"destinationVaultArn" type:"string"`

	// This is an optional parameter that can be used to filter out jobs with a
	// MessageCategory which matches the value you input.
	//
	// Example strings may include AccessDenied, SUCCESS, AGGREGATE_ALL, and INVALIDPARAMETERS.
	//
	// View Monitoring (https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html)
	// for a list of accepted strings.
	//
	// The the value ANY returns count of all message categories.
	//
	// AGGREGATE_ALL aggregates job counts for all message categories and returns
	// the sum.
	ByMessageCategory *string `location:"querystring" locationName:"messageCategory" type:"string"`

	// This is a filter to list child (nested) jobs based on parent job ID.
	ByParentJobId *string `location:"querystring" locationName:"parentJobId" type:"string"`

	// Returns only copy jobs that match the specified resource Amazon Resource
	// Name (ARN).
	ByResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string"`

	// Returns only backup jobs for the specified resources:
	//
	//    * Aurora for Amazon Aurora
	//
	//    * CloudFormation for CloudFormation
	//
	//    * DocumentDB for Amazon DocumentDB (with MongoDB compatibility)
	//
	//    * DynamoDB for Amazon DynamoDB
	//
	//    * EBS for Amazon Elastic Block Store
	//
	//    * EC2 for Amazon Elastic Compute Cloud
	//
	//    * EFS for Amazon Elastic File System
	//
	//    * FSx for Amazon FSx
	//
	//    * Neptune for Amazon Neptune
	//
	//    * Redshift for Amazon Redshift
	//
	//    * RDS for Amazon Relational Database Service
	//
	//    * SAP HANA on Amazon EC2 for SAP HANA databases
	//
	//    * Storage Gateway for Storage Gateway
	//
	//    * S3 for Amazon S3
	//
	//    * Timestream for Amazon Timestream
	//
	//    * VirtualMachine for virtual machines
	ByResourceType *string `location:"querystring" locationName:"resourceType" type:"string"`

	// Returns only copy jobs that are in the specified state.
	ByState *string `location:"querystring" locationName:"state" type:"string" enum:"CopyJobState"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCopyJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCopyJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCopyJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCopyJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByAccountId sets the ByAccountId field's value.
func (s *ListCopyJobsInput) SetByAccountId(v string) *ListCopyJobsInput {
	s.ByAccountId = &v
	return s
}

// SetByCompleteAfter sets the ByCompleteAfter field's value.
func (s *ListCopyJobsInput) SetByCompleteAfter(v time.Time) *ListCopyJobsInput {
	s.ByCompleteAfter = &v
	return s
}

// SetByCompleteBefore sets the ByCompleteBefore field's value.
func (s *ListCopyJobsInput) SetByCompleteBefore(v time.Time) *ListCopyJobsInput {
	s.ByCompleteBefore = &v
	return s
}

// SetByCreatedAfter sets the ByCreatedAfter field's value.
func (s *ListCopyJobsInput) SetByCreatedAfter(v time.Time) *ListCopyJobsInput {
	s.ByCreatedAfter = &v
	return s
}

// SetByCreatedBefore sets the ByCreatedBefore field's value.
func (s *ListCopyJobsInput) SetByCreatedBefore(v time.Time) *ListCopyJobsInput {
	s.ByCreatedBefore = &v
	return s
}

// SetByDestinationVaultArn sets the ByDestinationVaultArn field's value.
func (s *ListCopyJobsInput) SetByDestinationVaultArn(v string) *ListCopyJobsInput {
	s.ByDestinationVaultArn = &v
	return s
}

// SetByMessageCategory sets the ByMessageCategory field's value.
func (s *ListCopyJobsInput) SetByMessageCategory(v string) *ListCopyJobsInput {
	s.ByMessageCategory = &v
	return s
}

// SetByParentJobId sets the ByParentJobId field's value.
func (s *ListCopyJobsInput) SetByParentJobId(v string) *ListCopyJobsInput {
	s.ByParentJobId = &v
	return s
}

// SetByResourceArn sets the ByResourceArn field's value.
func (s *ListCopyJobsInput) SetByResourceArn(v string) *ListCopyJobsInput {
	s.ByResourceArn = &v
	return s
}

// SetByResourceType sets the ByResourceType field's value.
func (s *ListCopyJobsInput) SetByResourceType(v string) *ListCopyJobsInput {
	s.ByResourceType = &v
	return s
}

// SetByState sets the ByState field's value.
func (s *ListCopyJobsInput) SetByState(v string) *ListCopyJobsInput {
	s.ByState = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCopyJobsInput) SetMaxResults(v int64) *ListCopyJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCopyJobsInput) SetNextToken(v string) *ListCopyJobsInput {
	s.NextToken = &v
	return s
}

type ListCopyJobsOutput struct {
	_ struct{} `type:"structure"`

	// An array of structures containing metadata about your copy jobs returned
	// in JSON format.
	CopyJobs []*CopyJob `type:"list"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCopyJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCopyJobsOutput) GoString() string {
	return s.String()
}

// SetCopyJobs sets the CopyJobs field's value.
func (s *ListCopyJobsOutput) SetCopyJobs(v []*CopyJob) *ListCopyJobsOutput {
	s.CopyJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCopyJobsOutput) SetNextToken(v string) *ListCopyJobsOutput {
	s.NextToken = &v
	return s
}

type ListFrameworksInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The number of desired results from 1 to 1000. Optional. If unspecified, the
	// query will return 1 MB of data.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFrameworksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFrameworksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFrameworksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFrameworksInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFrameworksInput) SetMaxResults(v int64) *ListFrameworksInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFrameworksInput) SetNextToken(v string) *ListFrameworksInput {
	s.NextToken = &v
	return s
}

type ListFrameworksOutput struct {
	_ struct{} `type:"structure"`

	// A list of frameworks with details for each framework, including the framework
	// name, Amazon Resource Name (ARN), description, number of controls, creation
	// time, and deployment status.
	Frameworks []*Framework `type:"list"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFrameworksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListFrameworksOutput) GoString() string {
	return s.String()
}

// SetFrameworks sets the Frameworks field's value.
func (s *ListFrameworksOutput) SetFrameworks(v []*Framework) *ListFrameworksOutput {
	s.Frameworks = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFrameworksOutput) SetNextToken(v string) *ListFrameworksOutput {
	s.NextToken = &v
	return s
}

type ListLegalHoldsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of resource list items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned resources. For example,
	// if a request is made to return MaxResults number of resources, NextToken
	// allows you to return more items in your list starting at the location pointed
	// to by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLegalHoldsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLegalHoldsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLegalHoldsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLegalHoldsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListLegalHoldsInput) SetMaxResults(v int64) *ListLegalHoldsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLegalHoldsInput) SetNextToken(v string) *ListLegalHoldsInput {
	s.NextToken = &v
	return s
}

type ListLegalHoldsOutput struct {
	_ struct{} `type:"structure"`

	// This is an array of returned legal holds, both active and previous.
	LegalHolds []*LegalHold `type:"list"`

	// The next item following a partial list of returned resources. For example,
	// if a request is made to return MaxResults number of resources, NextToken
	// allows you to return more items in your list starting at the location pointed
	// to by the next token.
	NextToken *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLegalHoldsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListLegalHoldsOutput) GoString() string {
	return s.String()
}

// SetLegalHolds sets the LegalHolds field's value.
func (s *ListLegalHoldsOutput) SetLegalHolds(v []*LegalHold) *ListLegalHoldsOutput {
	s.LegalHolds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListLegalHoldsOutput) SetNextToken(v string) *ListLegalHoldsOutput {
	s.NextToken = &v
	return s
}

type ListProtectedResourcesByBackupVaultInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// This is the list of protected resources by backup vault within the vault(s)
	// you specify by account ID.
	BackupVaultAccountId *string `location:"querystring" locationName:"backupVaultAccountId" type:"string"`

	// This is the list of protected resources by backup vault within the vault(s)
	// you specify by name.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtectedResourcesByBackupVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtectedResourcesByBackupVaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProtectedResourcesByBackupVaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProtectedResourcesByBackupVaultInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultAccountId sets the BackupVaultAccountId field's value.
func (s *ListProtectedResourcesByBackupVaultInput) SetBackupVaultAccountId(v string) *ListProtectedResourcesByBackupVaultInput {
	s.BackupVaultAccountId = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *ListProtectedResourcesByBackupVaultInput) SetBackupVaultName(v string) *ListProtectedResourcesByBackupVaultInput {
	s.BackupVaultName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProtectedResourcesByBackupVaultInput) SetMaxResults(v int64) *ListProtectedResourcesByBackupVaultInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProtectedResourcesByBackupVaultInput) SetNextToken(v string) *ListProtectedResourcesByBackupVaultInput {
	s.NextToken = &v
	return s
}

type ListProtectedResourcesByBackupVaultOutput struct {
	_ struct{} `type:"structure"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`

	// These are the results returned for the request ListProtectedResourcesByBackupVault.
	Results []*ProtectedResource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtectedResourcesByBackupVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtectedResourcesByBackupVaultOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProtectedResourcesByBackupVaultOutput) SetNextToken(v string) *ListProtectedResourcesByBackupVaultOutput {
	s.NextToken = &v
	return s
}

// SetResults sets the Results field's value.
func (s *ListProtectedResourcesByBackupVaultOutput) SetResults(v []*ProtectedResource) *ListProtectedResourcesByBackupVaultOutput {
	s.Results = v
	return s
}

type ListProtectedResourcesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtectedResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtectedResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProtectedResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProtectedResourcesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProtectedResourcesInput) SetMaxResults(v int64) *ListProtectedResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProtectedResourcesInput) SetNextToken(v string) *ListProtectedResourcesInput {
	s.NextToken = &v
	return s
}

type ListProtectedResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`

	// An array of resources successfully backed up by Backup including the time
	// the resource was saved, an Amazon Resource Name (ARN) of the resource, and
	// a resource type.
	Results []*ProtectedResource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtectedResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProtectedResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProtectedResourcesOutput) SetNextToken(v string) *ListProtectedResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResults sets the Results field's value.
func (s *ListProtectedResourcesOutput) SetResults(v []*ProtectedResource) *ListProtectedResourcesOutput {
	s.Results = v
	return s
}

type ListRecoveryPointsByBackupVaultInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// This parameter will sort the list of recovery points by account ID.
	BackupVaultAccountId *string `location:"querystring" locationName:"backupVaultAccountId" type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// Backup vault name might not be available when a supported service creates
	// the backup.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// Returns only recovery points that match the specified backup plan ID.
	ByBackupPlanId *string `location:"querystring" locationName:"backupPlanId" type:"string"`

	// Returns only recovery points that were created after the specified timestamp.
	ByCreatedAfter *time.Time `location:"querystring" locationName:"createdAfter" type:"timestamp"`

	// Returns only recovery points that were created before the specified timestamp.
	ByCreatedBefore *time.Time `location:"querystring" locationName:"createdBefore" type:"timestamp"`

	// This returns only recovery points that match the specified parent (composite)
	// recovery point Amazon Resource Name (ARN).
	ByParentRecoveryPointArn *string `location:"querystring" locationName:"parentRecoveryPointArn" type:"string"`

	// Returns only recovery points that match the specified resource Amazon Resource
	// Name (ARN).
	ByResourceArn *string `location:"querystring" locationName:"resourceArn" type:"string"`

	// Returns only recovery points that match the specified resource type(s):
	//
	//    * Aurora for Amazon Aurora
	//
	//    * CloudFormation for CloudFormation
	//
	//    * DocumentDB for Amazon DocumentDB (with MongoDB compatibility)
	//
	//    * DynamoDB for Amazon DynamoDB
	//
	//    * EBS for Amazon Elastic Block Store
	//
	//    * EC2 for Amazon Elastic Compute Cloud
	//
	//    * EFS for Amazon Elastic File System
	//
	//    * FSx for Amazon FSx
	//
	//    * Neptune for Amazon Neptune
	//
	//    * Redshift for Amazon Redshift
	//
	//    * RDS for Amazon Relational Database Service
	//
	//    * SAP HANA on Amazon EC2 for SAP HANA databases
	//
	//    * Storage Gateway for Storage Gateway
	//
	//    * S3 for Amazon S3
	//
	//    * Timestream for Amazon Timestream
	//
	//    * VirtualMachine for virtual machines
	ByResourceType *string `location:"querystring" locationName:"resourceType" type:"string"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsByBackupVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsByBackupVaultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecoveryPointsByBackupVaultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecoveryPointsByBackupVaultInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultAccountId sets the BackupVaultAccountId field's value.
func (s *ListRecoveryPointsByBackupVaultInput) SetBackupVaultAccountId(v string) *ListRecoveryPointsByBackupVaultInput {
	s.BackupVaultAccountId = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *ListRecoveryPointsByBackupVaultInput) SetBackupVaultName(v string) *ListRecoveryPointsByBackupVaultInput {
	s.BackupVaultName = &v
	return s
}

// SetByBackupPlanId sets the ByBackupPlanId field's value.
func (s *ListRecoveryPointsByBackupVaultInput) SetByBackupPlanId(v string) *ListRecoveryPointsByBackupVaultInput {
	s.ByBackupPlanId = &v
	return s
}

// SetByCreatedAfter sets the ByCreatedAfter field's value.
func (s *ListRecoveryPointsByBackupVaultInput) SetByCreatedAfter(v time.Time) *ListRecoveryPointsByBackupVaultInput {
	s.ByCreatedAfter = &v
	return s
}

// SetByCreatedBefore sets the ByCreatedBefore field's value.
func (s *ListRecoveryPointsByBackupVaultInput) SetByCreatedBefore(v time.Time) *ListRecoveryPointsByBackupVaultInput {
	s.ByCreatedBefore = &v
	return s
}

// SetByParentRecoveryPointArn sets the ByParentRecoveryPointArn field's value.
func (s *ListRecoveryPointsByBackupVaultInput) SetByParentRecoveryPointArn(v string) *ListRecoveryPointsByBackupVaultInput {
	s.ByParentRecoveryPointArn = &v
	return s
}

// SetByResourceArn sets the ByResourceArn field's value.
func (s *ListRecoveryPointsByBackupVaultInput) SetByResourceArn(v string) *ListRecoveryPointsByBackupVaultInput {
	s.ByResourceArn = &v
	return s
}

// SetByResourceType sets the ByResourceType field's value.
func (s *ListRecoveryPointsByBackupVaultInput) SetByResourceType(v string) *ListRecoveryPointsByBackupVaultInput {
	s.ByResourceType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecoveryPointsByBackupVaultInput) SetMaxResults(v int64) *ListRecoveryPointsByBackupVaultInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecoveryPointsByBackupVaultInput) SetNextToken(v string) *ListRecoveryPointsByBackupVaultInput {
	s.NextToken = &v
	return s
}

type ListRecoveryPointsByBackupVaultOutput struct {
	_ struct{} `type:"structure"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`

	// An array of objects that contain detailed information about recovery points
	// saved in a backup vault.
	RecoveryPoints []*RecoveryPointByBackupVault `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsByBackupVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsByBackupVaultOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecoveryPointsByBackupVaultOutput) SetNextToken(v string) *ListRecoveryPointsByBackupVaultOutput {
	s.NextToken = &v
	return s
}

// SetRecoveryPoints sets the RecoveryPoints field's value.
func (s *ListRecoveryPointsByBackupVaultOutput) SetRecoveryPoints(v []*RecoveryPointByBackupVault) *ListRecoveryPointsByBackupVaultOutput {
	s.RecoveryPoints = v
	return s
}

type ListRecoveryPointsByLegalHoldInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// This is the ID of the legal hold.
	//
	// LegalHoldId is a required field
	LegalHoldId *string `location:"uri" locationName:"legalHoldId" type:"string" required:"true"`

	// This is the maximum number of resource list items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// This is the next item following a partial list of returned resources. For
	// example, if a request is made to return MaxResults number of resources, NextToken
	// allows you to return more items in your list starting at the location pointed
	// to by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsByLegalHoldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsByLegalHoldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecoveryPointsByLegalHoldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecoveryPointsByLegalHoldInput"}
	if s.LegalHoldId == nil {
		invalidParams.Add(request.NewErrParamRequired("LegalHoldId"))
	}
	if s.LegalHoldId != nil && len(*s.LegalHoldId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LegalHoldId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLegalHoldId sets the LegalHoldId field's value.
func (s *ListRecoveryPointsByLegalHoldInput) SetLegalHoldId(v string) *ListRecoveryPointsByLegalHoldInput {
	s.LegalHoldId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecoveryPointsByLegalHoldInput) SetMaxResults(v int64) *ListRecoveryPointsByLegalHoldInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecoveryPointsByLegalHoldInput) SetNextToken(v string) *ListRecoveryPointsByLegalHoldInput {
	s.NextToken = &v
	return s
}

type ListRecoveryPointsByLegalHoldOutput struct {
	_ struct{} `type:"structure"`

	// This return is the next item following a partial list of returned resources.
	NextToken *string `type:"string"`

	// This is a list of the recovery points returned by ListRecoveryPointsByLegalHold.
	RecoveryPoints []*RecoveryPointMember `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsByLegalHoldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsByLegalHoldOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecoveryPointsByLegalHoldOutput) SetNextToken(v string) *ListRecoveryPointsByLegalHoldOutput {
	s.NextToken = &v
	return s
}

// SetRecoveryPoints sets the RecoveryPoints field's value.
func (s *ListRecoveryPointsByLegalHoldOutput) SetRecoveryPoints(v []*RecoveryPointMember) *ListRecoveryPointsByLegalHoldOutput {
	s.RecoveryPoints = v
	return s
}

type ListRecoveryPointsByResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to be returned.
	//
	// Amazon RDS requires a value of at least 20.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// An ARN that uniquely identifies a resource. The format of the ARN depends
	// on the resource type.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsByResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsByResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecoveryPointsByResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecoveryPointsByResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecoveryPointsByResourceInput) SetMaxResults(v int64) *ListRecoveryPointsByResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecoveryPointsByResourceInput) SetNextToken(v string) *ListRecoveryPointsByResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListRecoveryPointsByResourceInput) SetResourceArn(v string) *ListRecoveryPointsByResourceInput {
	s.ResourceArn = &v
	return s
}

type ListRecoveryPointsByResourceOutput struct {
	_ struct{} `type:"structure"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`

	// An array of objects that contain detailed information about recovery points
	// of the specified resource type.
	//
	// Only Amazon EFS and Amazon EC2 recovery points return BackupVaultName.
	RecoveryPoints []*RecoveryPointByResource `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsByResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsByResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecoveryPointsByResourceOutput) SetNextToken(v string) *ListRecoveryPointsByResourceOutput {
	s.NextToken = &v
	return s
}

// SetRecoveryPoints sets the RecoveryPoints field's value.
func (s *ListRecoveryPointsByResourceOutput) SetRecoveryPoints(v []*RecoveryPointByResource) *ListRecoveryPointsByResourceOutput {
	s.RecoveryPoints = v
	return s
}

type ListReportJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Returns only report jobs that were created after the date and time specified
	// in Unix format and Coordinated Universal Time (UTC). For example, the value
	// 1516925490 represents Friday, January 26, 2018 12:11:30 AM.
	ByCreationAfter *time.Time `location:"querystring" locationName:"CreationAfter" type:"timestamp"`

	// Returns only report jobs that were created before the date and time specified
	// in Unix format and Coordinated Universal Time (UTC). For example, the value
	// 1516925490 represents Friday, January 26, 2018 12:11:30 AM.
	ByCreationBefore *time.Time `location:"querystring" locationName:"CreationBefore" type:"timestamp"`

	// Returns only report jobs with the specified report plan name.
	ByReportPlanName *string `location:"querystring" locationName:"ReportPlanName" min:"1" type:"string"`

	// Returns only report jobs that are in the specified status. The statuses are:
	//
	// CREATED | RUNNING | COMPLETED | FAILED
	ByStatus *string `location:"querystring" locationName:"Status" type:"string"`

	// The number of desired results from 1 to 1000. Optional. If unspecified, the
	// query will return 1 MB of data.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReportJobsInput"}
	if s.ByReportPlanName != nil && len(*s.ByReportPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ByReportPlanName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByCreationAfter sets the ByCreationAfter field's value.
func (s *ListReportJobsInput) SetByCreationAfter(v time.Time) *ListReportJobsInput {
	s.ByCreationAfter = &v
	return s
}

// SetByCreationBefore sets the ByCreationBefore field's value.
func (s *ListReportJobsInput) SetByCreationBefore(v time.Time) *ListReportJobsInput {
	s.ByCreationBefore = &v
	return s
}

// SetByReportPlanName sets the ByReportPlanName field's value.
func (s *ListReportJobsInput) SetByReportPlanName(v string) *ListReportJobsInput {
	s.ByReportPlanName = &v
	return s
}

// SetByStatus sets the ByStatus field's value.
func (s *ListReportJobsInput) SetByStatus(v string) *ListReportJobsInput {
	s.ByStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReportJobsInput) SetMaxResults(v int64) *ListReportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReportJobsInput) SetNextToken(v string) *ListReportJobsInput {
	s.NextToken = &v
	return s
}

type ListReportJobsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `type:"string"`

	// Details about your report jobs in JSON format.
	ReportJobs []*ReportJob `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReportJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReportJobsOutput) SetNextToken(v string) *ListReportJobsOutput {
	s.NextToken = &v
	return s
}

// SetReportJobs sets the ReportJobs field's value.
func (s *ListReportJobsOutput) SetReportJobs(v []*ReportJob) *ListReportJobsOutput {
	s.ReportJobs = v
	return s
}

type ListReportPlansInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The number of desired results from 1 to 1000. Optional. If unspecified, the
	// query will return 1 MB of data.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReportPlansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReportPlansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListReportPlansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListReportPlansInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListReportPlansInput) SetMaxResults(v int64) *ListReportPlansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListReportPlansInput) SetNextToken(v string) *ListReportPlansInput {
	s.NextToken = &v
	return s
}

type ListReportPlansOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `type:"string"`

	// A list of your report plans with detailed information for each plan. This
	// information includes the Amazon Resource Name (ARN), report plan name, description,
	// settings, delivery channel, deployment status, creation time, and last times
	// the report plan attempted to and successfully ran.
	ReportPlans []*ReportPlan `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReportPlansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListReportPlansOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListReportPlansOutput) SetNextToken(v string) *ListReportPlansOutput {
	s.NextToken = &v
	return s
}

// SetReportPlans sets the ReportPlans field's value.
func (s *ListReportPlansOutput) SetReportPlans(v []*ReportPlan) *ListReportPlansOutput {
	s.ReportPlans = v
	return s
}

type ListRestoreJobSummariesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Returns the job count for the specified account.
	//
	// If the request is sent from a member account or an account not part of Amazon
	// Web Services Organizations, jobs within requestor's account will be returned.
	//
	// Root, admin, and delegated administrator accounts can use the value ANY to
	// return job counts from every account in the organization.
	//
	// AGGREGATE_ALL aggregates job counts from all accounts within the authenticated
	// organization, then returns the sum.
	AccountId *string `location:"querystring" locationName:"AccountId" type:"string"`

	// This is the period that sets the boundaries for returned results.
	//
	// Acceptable values include
	//
	//    * ONE_DAY for daily job count for the prior 14 days.
	//
	//    * SEVEN_DAYS for the aggregated job count for the prior 7 days.
	//
	//    * FOURTEEN_DAYS for aggregated job count for prior 14 days.
	AggregationPeriod *string `location:"querystring" locationName:"AggregationPeriod" type:"string" enum:"AggregationPeriod"`

	// This parameter sets the maximum number of items to be returned.
	//
	// The value is an integer. Range of accepted values is from 1 to 500.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned resources. For example,
	// if a request is made to return MaxResults number of resources, NextToken
	// allows you to return more items in your list starting at the location pointed
	// to by the next token.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// Returns the job count for the specified resource type. Use request GetSupportedResourceTypes
	// to obtain strings for supported resource types.
	//
	// The the value ANY returns count of all resource types.
	//
	// AGGREGATE_ALL aggregates job counts for all resource types and returns the
	// sum.
	//
	// The type of Amazon Web Services resource to be backed up; for example, an
	// Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database
	// Service (Amazon RDS) database.
	ResourceType *string `location:"querystring" locationName:"ResourceType" type:"string"`

	// This parameter returns the job count for jobs with the specified state.
	//
	// The the value ANY returns count of all states.
	//
	// AGGREGATE_ALL aggregates job counts for all states and returns the sum.
	State *string `location:"querystring" locationName:"State" type:"string" enum:"RestoreJobState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreJobSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreJobSummariesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRestoreJobSummariesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRestoreJobSummariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccountId sets the AccountId field's value.
func (s *ListRestoreJobSummariesInput) SetAccountId(v string) *ListRestoreJobSummariesInput {
	s.AccountId = &v
	return s
}

// SetAggregationPeriod sets the AggregationPeriod field's value.
func (s *ListRestoreJobSummariesInput) SetAggregationPeriod(v string) *ListRestoreJobSummariesInput {
	s.AggregationPeriod = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRestoreJobSummariesInput) SetMaxResults(v int64) *ListRestoreJobSummariesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRestoreJobSummariesInput) SetNextToken(v string) *ListRestoreJobSummariesInput {
	s.NextToken = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListRestoreJobSummariesInput) SetResourceType(v string) *ListRestoreJobSummariesInput {
	s.ResourceType = &v
	return s
}

// SetState sets the State field's value.
func (s *ListRestoreJobSummariesInput) SetState(v string) *ListRestoreJobSummariesInput {
	s.State = &v
	return s
}

type ListRestoreJobSummariesOutput struct {
	_ struct{} `type:"structure"`

	// This is the period that sets the boundaries for returned results.
	//
	//    * ONE_DAY for daily job count for the prior 14 days.
	//
	//    * SEVEN_DAYS for the aggregated job count for the prior 7 days.
	//
	//    * FOURTEEN_DAYS for aggregated job count for prior 14 days.
	AggregationPeriod *string `type:"string"`

	// The next item following a partial list of returned resources. For example,
	// if a request is made to return MaxResults number of resources, NextToken
	// allows you to return more items in your list starting at the location pointed
	// to by the next token.
	NextToken *string `type:"string"`

	// This return contains a summary that contains Region, Account, State, ResourceType,
	// MessageCategory, StartTime, EndTime, and Count of included jobs.
	RestoreJobSummaries []*RestoreJobSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreJobSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreJobSummariesOutput) GoString() string {
	return s.String()
}

// SetAggregationPeriod sets the AggregationPeriod field's value.
func (s *ListRestoreJobSummariesOutput) SetAggregationPeriod(v string) *ListRestoreJobSummariesOutput {
	s.AggregationPeriod = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRestoreJobSummariesOutput) SetNextToken(v string) *ListRestoreJobSummariesOutput {
	s.NextToken = &v
	return s
}

// SetRestoreJobSummaries sets the RestoreJobSummaries field's value.
func (s *ListRestoreJobSummariesOutput) SetRestoreJobSummaries(v []*RestoreJobSummary) *ListRestoreJobSummariesOutput {
	s.RestoreJobSummaries = v
	return s
}

type ListRestoreJobsByProtectedResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Returns only restore jobs of recovery points that were created after the
	// specified date.
	ByRecoveryPointCreationDateAfter *time.Time `location:"querystring" locationName:"recoveryPointCreationDateAfter" type:"timestamp"`

	// Returns only restore jobs of recovery points that were created before the
	// specified date.
	ByRecoveryPointCreationDateBefore *time.Time `location:"querystring" locationName:"recoveryPointCreationDateBefore" type:"timestamp"`

	// Returns only restore jobs associated with the specified job status.
	ByStatus *string `location:"querystring" locationName:"status" type:"string" enum:"RestoreJobStatus"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request ismade to return MaxResults number of items, NextToken allows you
	// to return more items in your list starting at the location pointed to by
	// the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// Returns only restore jobs that match the specified resource Amazon Resource
	// Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreJobsByProtectedResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreJobsByProtectedResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRestoreJobsByProtectedResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRestoreJobsByProtectedResourceInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByRecoveryPointCreationDateAfter sets the ByRecoveryPointCreationDateAfter field's value.
func (s *ListRestoreJobsByProtectedResourceInput) SetByRecoveryPointCreationDateAfter(v time.Time) *ListRestoreJobsByProtectedResourceInput {
	s.ByRecoveryPointCreationDateAfter = &v
	return s
}

// SetByRecoveryPointCreationDateBefore sets the ByRecoveryPointCreationDateBefore field's value.
func (s *ListRestoreJobsByProtectedResourceInput) SetByRecoveryPointCreationDateBefore(v time.Time) *ListRestoreJobsByProtectedResourceInput {
	s.ByRecoveryPointCreationDateBefore = &v
	return s
}

// SetByStatus sets the ByStatus field's value.
func (s *ListRestoreJobsByProtectedResourceInput) SetByStatus(v string) *ListRestoreJobsByProtectedResourceInput {
	s.ByStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRestoreJobsByProtectedResourceInput) SetMaxResults(v int64) *ListRestoreJobsByProtectedResourceInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRestoreJobsByProtectedResourceInput) SetNextToken(v string) *ListRestoreJobsByProtectedResourceInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListRestoreJobsByProtectedResourceInput) SetResourceArn(v string) *ListRestoreJobsByProtectedResourceInput {
	s.ResourceArn = &v
	return s
}

type ListRestoreJobsByProtectedResourceOutput struct {
	_ struct{} `type:"structure"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// youto return more items in your list starting at the location pointed to
	// by the next token
	NextToken *string `type:"string"`

	// An array of objects that contain detailed information about jobs to restore
	// saved resources.>
	RestoreJobs []*RestoreJobsListMember `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreJobsByProtectedResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreJobsByProtectedResourceOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRestoreJobsByProtectedResourceOutput) SetNextToken(v string) *ListRestoreJobsByProtectedResourceOutput {
	s.NextToken = &v
	return s
}

// SetRestoreJobs sets the RestoreJobs field's value.
func (s *ListRestoreJobsByProtectedResourceOutput) SetRestoreJobs(v []*RestoreJobsListMember) *ListRestoreJobsByProtectedResourceOutput {
	s.RestoreJobs = v
	return s
}

type ListRestoreJobsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The account ID to list the jobs from. Returns only restore jobs associated
	// with the specified account ID.
	ByAccountId *string `location:"querystring" locationName:"accountId" type:"string"`

	// Returns only copy jobs completed after a date expressed in Unix format and
	// Coordinated Universal Time (UTC).
	ByCompleteAfter *time.Time `location:"querystring" locationName:"completeAfter" type:"timestamp"`

	// Returns only copy jobs completed before a date expressed in Unix format and
	// Coordinated Universal Time (UTC).
	ByCompleteBefore *time.Time `location:"querystring" locationName:"completeBefore" type:"timestamp"`

	// Returns only restore jobs that were created after the specified date.
	ByCreatedAfter *time.Time `location:"querystring" locationName:"createdAfter" type:"timestamp"`

	// Returns only restore jobs that were created before the specified date.
	ByCreatedBefore *time.Time `location:"querystring" locationName:"createdBefore" type:"timestamp"`

	// Include this parameter to return only restore jobs for the specified resources:
	//
	//    * Aurora for Amazon Aurora
	//
	//    * CloudFormation for CloudFormation
	//
	//    * DocumentDB for Amazon DocumentDB (with MongoDB compatibility)
	//
	//    * DynamoDB for Amazon DynamoDB
	//
	//    * EBS for Amazon Elastic Block Store
	//
	//    * EC2 for Amazon Elastic Compute Cloud
	//
	//    * EFS for Amazon Elastic File System
	//
	//    * FSx for Amazon FSx
	//
	//    * Neptune for Amazon Neptune
	//
	//    * Redshift for Amazon Redshift
	//
	//    * RDS for Amazon Relational Database Service
	//
	//    * SAP HANA on Amazon EC2 for SAP HANA databases
	//
	//    * Storage Gateway for Storage Gateway
	//
	//    * S3 for Amazon S3
	//
	//    * Timestream for Amazon Timestream
	//
	//    * VirtualMachine for virtual machines
	ByResourceType *string `location:"querystring" locationName:"resourceType" type:"string"`

	// This returns only restore testing jobs that match the specified resource
	// Amazon Resource Name (ARN).
	ByRestoreTestingPlanArn *string `location:"querystring" locationName:"restoreTestingPlanArn" type:"string"`

	// Returns only restore jobs associated with the specified job status.
	ByStatus *string `location:"querystring" locationName:"status" type:"string" enum:"RestoreJobStatus"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRestoreJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRestoreJobsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByAccountId sets the ByAccountId field's value.
func (s *ListRestoreJobsInput) SetByAccountId(v string) *ListRestoreJobsInput {
	s.ByAccountId = &v
	return s
}

// SetByCompleteAfter sets the ByCompleteAfter field's value.
func (s *ListRestoreJobsInput) SetByCompleteAfter(v time.Time) *ListRestoreJobsInput {
	s.ByCompleteAfter = &v
	return s
}

// SetByCompleteBefore sets the ByCompleteBefore field's value.
func (s *ListRestoreJobsInput) SetByCompleteBefore(v time.Time) *ListRestoreJobsInput {
	s.ByCompleteBefore = &v
	return s
}

// SetByCreatedAfter sets the ByCreatedAfter field's value.
func (s *ListRestoreJobsInput) SetByCreatedAfter(v time.Time) *ListRestoreJobsInput {
	s.ByCreatedAfter = &v
	return s
}

// SetByCreatedBefore sets the ByCreatedBefore field's value.
func (s *ListRestoreJobsInput) SetByCreatedBefore(v time.Time) *ListRestoreJobsInput {
	s.ByCreatedBefore = &v
	return s
}

// SetByResourceType sets the ByResourceType field's value.
func (s *ListRestoreJobsInput) SetByResourceType(v string) *ListRestoreJobsInput {
	s.ByResourceType = &v
	return s
}

// SetByRestoreTestingPlanArn sets the ByRestoreTestingPlanArn field's value.
func (s *ListRestoreJobsInput) SetByRestoreTestingPlanArn(v string) *ListRestoreJobsInput {
	s.ByRestoreTestingPlanArn = &v
	return s
}

// SetByStatus sets the ByStatus field's value.
func (s *ListRestoreJobsInput) SetByStatus(v string) *ListRestoreJobsInput {
	s.ByStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRestoreJobsInput) SetMaxResults(v int64) *ListRestoreJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRestoreJobsInput) SetNextToken(v string) *ListRestoreJobsInput {
	s.NextToken = &v
	return s
}

type ListRestoreJobsOutput struct {
	_ struct{} `type:"structure"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`

	// An array of objects that contain detailed information about jobs to restore
	// saved resources.
	RestoreJobs []*RestoreJobsListMember `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRestoreJobsOutput) SetNextToken(v string) *ListRestoreJobsOutput {
	s.NextToken = &v
	return s
}

// SetRestoreJobs sets the RestoreJobs field's value.
func (s *ListRestoreJobsOutput) SetRestoreJobs(v []*RestoreJobsListMember) *ListRestoreJobsOutput {
	s.RestoreJobs = v
	return s
}

type ListRestoreTestingPlansInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the nexttoken.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreTestingPlansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreTestingPlansInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRestoreTestingPlansInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRestoreTestingPlansInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRestoreTestingPlansInput) SetMaxResults(v int64) *ListRestoreTestingPlansInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRestoreTestingPlansInput) SetNextToken(v string) *ListRestoreTestingPlansInput {
	s.NextToken = &v
	return s
}

type ListRestoreTestingPlansOutput struct {
	_ struct{} `type:"structure"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the nexttoken.
	NextToken *string `type:"string"`

	// This is a returned list of restore testing plans.
	//
	// RestoreTestingPlans is a required field
	RestoreTestingPlans []*RestoreTestingPlanForList `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreTestingPlansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreTestingPlansOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRestoreTestingPlansOutput) SetNextToken(v string) *ListRestoreTestingPlansOutput {
	s.NextToken = &v
	return s
}

// SetRestoreTestingPlans sets the RestoreTestingPlans field's value.
func (s *ListRestoreTestingPlansOutput) SetRestoreTestingPlans(v []*RestoreTestingPlanForList) *ListRestoreTestingPlansOutput {
	s.RestoreTestingPlans = v
	return s
}

type ListRestoreTestingSelectionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the nexttoken.
	NextToken *string `location:"querystring" locationName:"NextToken" type:"string"`

	// Returns restore testing selections by the specified restore testing plan
	// name.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `location:"uri" locationName:"RestoreTestingPlanName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreTestingSelectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreTestingSelectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRestoreTestingSelectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRestoreTestingSelectionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.RestoreTestingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreTestingPlanName"))
	}
	if s.RestoreTestingPlanName != nil && len(*s.RestoreTestingPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestoreTestingPlanName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRestoreTestingSelectionsInput) SetMaxResults(v int64) *ListRestoreTestingSelectionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRestoreTestingSelectionsInput) SetNextToken(v string) *ListRestoreTestingSelectionsInput {
	s.NextToken = &v
	return s
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *ListRestoreTestingSelectionsInput) SetRestoreTestingPlanName(v string) *ListRestoreTestingSelectionsInput {
	s.RestoreTestingPlanName = &v
	return s
}

type ListRestoreTestingSelectionsOutput struct {
	_ struct{} `type:"structure"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the nexttoken.
	NextToken *string `type:"string"`

	// The returned restore testing selections associated with the restore testing
	// plan.
	//
	// RestoreTestingSelections is a required field
	RestoreTestingSelections []*RestoreTestingSelectionForList `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreTestingSelectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRestoreTestingSelectionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRestoreTestingSelectionsOutput) SetNextToken(v string) *ListRestoreTestingSelectionsOutput {
	s.NextToken = &v
	return s
}

// SetRestoreTestingSelections sets the RestoreTestingSelections field's value.
func (s *ListRestoreTestingSelectionsOutput) SetRestoreTestingSelections(v []*RestoreTestingSelectionForList) *ListRestoreTestingSelectionsOutput {
	s.RestoreTestingSelections = v
	return s
}

type ListTagsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of items to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the type of resource. Valid targets for ListTags are
	// recovery points, backup plans, and backup vaults.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTagsInput) SetMaxResults(v int64) *ListTagsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsInput) SetNextToken(v string) *ListTagsInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsInput) SetResourceArn(v string) *ListTagsInput {
	s.ResourceArn = &v
	return s
}

type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// The next item following a partial list of returned items. For example, if
	// a request is made to return MaxResults number of items, NextToken allows
	// you to return more items in your list starting at the location pointed to
	// by the next token.
	NextToken *string `type:"string"`

	// To help organize your resources, you can assign your own metadata to the
	// resources you create. Each tag is a key-value pair.
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by ListTagsOutput's
	// String and GoString methods.
	Tags map[string]*string `type:"map" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTagsOutput) SetNextToken(v string) *ListTagsOutput {
	s.NextToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsOutput) SetTags(v map[string]*string) *ListTagsOutput {
	s.Tags = v
	return s
}

// Indicates that a required parameter is missing.
type MissingParameterValueException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Context *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingParameterValueException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MissingParameterValueException) GoString() string {
	return s.String()
}

func newErrorMissingParameterValueException(v protocol.ResponseMetadata) error {
	return &MissingParameterValueException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *MissingParameterValueException) Code() string {
	return "MissingParameterValueException"
}

// Message returns the exception's message.
func (s *MissingParameterValueException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *MissingParameterValueException) OrigErr() error {
	return nil
}

func (s *MissingParameterValueException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *MissingParameterValueException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *MissingParameterValueException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains an optional backup plan display name and an array of BackupRule
// objects, each of which specifies a backup rule. Each rule in a backup plan
// is a separate scheduled task and can back up a different selection of Amazon
// Web Services resources.
type Plan struct {
	_ struct{} `type:"structure"`

	// Contains a list of BackupOptions for each resource type.
	AdvancedBackupSettings []*AdvancedBackupSetting `type:"list"`

	// The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.'
	// characters.
	//
	// BackupPlanName is a required field
	BackupPlanName *string `type:"string" required:"true"`

	// An array of BackupRule objects, each of which specifies a scheduled task
	// that is used to back up a selection of resources.
	//
	// Rules is a required field
	Rules []*Rule `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Plan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Plan) GoString() string {
	return s.String()
}

// SetAdvancedBackupSettings sets the AdvancedBackupSettings field's value.
func (s *Plan) SetAdvancedBackupSettings(v []*AdvancedBackupSetting) *Plan {
	s.AdvancedBackupSettings = v
	return s
}

// SetBackupPlanName sets the BackupPlanName field's value.
func (s *Plan) SetBackupPlanName(v string) *Plan {
	s.BackupPlanName = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *Plan) SetRules(v []*Rule) *Plan {
	s.Rules = v
	return s
}

// Contains an optional backup plan display name and an array of BackupRule
// objects, each of which specifies a backup rule. Each rule in a backup plan
// is a separate scheduled task.
type PlanInput struct {
	_ struct{} `type:"structure"`

	// Specifies a list of BackupOptions for each resource type. These settings
	// are only available for Windows Volume Shadow Copy Service (VSS) backup jobs.
	AdvancedBackupSettings []*AdvancedBackupSetting `type:"list"`

	// The display name of a backup plan. Must contain 1 to 50 alphanumeric or '-_.'
	// characters.
	//
	// BackupPlanName is a required field
	BackupPlanName *string `type:"string" required:"true"`

	// An array of BackupRule objects, each of which specifies a scheduled task
	// that is used to back up a selection of resources.
	//
	// Rules is a required field
	Rules []*RuleInput `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PlanInput"}
	if s.BackupPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlanName"))
	}
	if s.Rules == nil {
		invalidParams.Add(request.NewErrParamRequired("Rules"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdvancedBackupSettings sets the AdvancedBackupSettings field's value.
func (s *PlanInput) SetAdvancedBackupSettings(v []*AdvancedBackupSetting) *PlanInput {
	s.AdvancedBackupSettings = v
	return s
}

// SetBackupPlanName sets the BackupPlanName field's value.
func (s *PlanInput) SetBackupPlanName(v string) *PlanInput {
	s.BackupPlanName = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *PlanInput) SetRules(v []*RuleInput) *PlanInput {
	s.Rules = v
	return s
}

// An object specifying metadata associated with a backup plan template.
type PlanTemplatesListMember struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a stored backup plan template.
	BackupPlanTemplateId *string `type:"string"`

	// The optional display name of a backup plan template.
	BackupPlanTemplateName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlanTemplatesListMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlanTemplatesListMember) GoString() string {
	return s.String()
}

// SetBackupPlanTemplateId sets the BackupPlanTemplateId field's value.
func (s *PlanTemplatesListMember) SetBackupPlanTemplateId(v string) *PlanTemplatesListMember {
	s.BackupPlanTemplateId = &v
	return s
}

// SetBackupPlanTemplateName sets the BackupPlanTemplateName field's value.
func (s *PlanTemplatesListMember) SetBackupPlanTemplateName(v string) *PlanTemplatesListMember {
	s.BackupPlanTemplateName = &v
	return s
}

// Contains metadata about a backup plan.
type PlansListMember struct {
	_ struct{} `type:"structure"`

	// Contains a list of BackupOptions for a resource type.
	AdvancedBackupSettings []*AdvancedBackupSetting `type:"list"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for
	// example, arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50.
	BackupPlanArn *string `type:"string"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// The display name of a saved backup plan.
	BackupPlanName *string `type:"string"`

	// The date and time a resource backup plan is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// A unique string that identifies the request and allows failed requests to
	// be retried without the risk of running the operation twice. This parameter
	// is optional.
	//
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string `type:"string"`

	// The date and time a backup plan is deleted, in Unix format and Coordinated
	// Universal Time (UTC). The value of DeletionDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	DeletionDate *time.Time `type:"timestamp"`

	// The last time a job to back up resources was run with this rule. A date and
	// time, in Unix format and Coordinated Universal Time (UTC). The value of LastExecutionDate
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	LastExecutionDate *time.Time `type:"timestamp"`

	// Unique, randomly generated, Unicode, UTF-8 encoded strings that are at most
	// 1,024 bytes long. Version IDs cannot be edited.
	VersionId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlansListMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PlansListMember) GoString() string {
	return s.String()
}

// SetAdvancedBackupSettings sets the AdvancedBackupSettings field's value.
func (s *PlansListMember) SetAdvancedBackupSettings(v []*AdvancedBackupSetting) *PlansListMember {
	s.AdvancedBackupSettings = v
	return s
}

// SetBackupPlanArn sets the BackupPlanArn field's value.
func (s *PlansListMember) SetBackupPlanArn(v string) *PlansListMember {
	s.BackupPlanArn = &v
	return s
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *PlansListMember) SetBackupPlanId(v string) *PlansListMember {
	s.BackupPlanId = &v
	return s
}

// SetBackupPlanName sets the BackupPlanName field's value.
func (s *PlansListMember) SetBackupPlanName(v string) *PlansListMember {
	s.BackupPlanName = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *PlansListMember) SetCreationDate(v time.Time) *PlansListMember {
	s.CreationDate = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *PlansListMember) SetCreatorRequestId(v string) *PlansListMember {
	s.CreatorRequestId = &v
	return s
}

// SetDeletionDate sets the DeletionDate field's value.
func (s *PlansListMember) SetDeletionDate(v time.Time) *PlansListMember {
	s.DeletionDate = &v
	return s
}

// SetLastExecutionDate sets the LastExecutionDate field's value.
func (s *PlansListMember) SetLastExecutionDate(v time.Time) *PlansListMember {
	s.LastExecutionDate = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *PlansListMember) SetVersionId(v string) *PlansListMember {
	s.VersionId = &v
	return s
}

// A structure that contains information about a backed-up resource.
type ProtectedResource struct {
	_ struct{} `type:"structure"`

	// The date and time a resource was last backed up, in Unix format and Coordinated
	// Universal Time (UTC). The value of LastBackupTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	LastBackupTime *time.Time `type:"timestamp"`

	// This is the ARN (Amazon Resource Name) of the backup vault that contains
	// the most recent backup recovery point.
	LastBackupVaultArn *string `type:"string"`

	// This is the ARN (Amazon Resource Name) of the most recent recovery point.
	LastRecoveryPointArn *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	ResourceArn *string `type:"string"`

	// This is the non-unique name of the resource that belongs to the specified
	// backup.
	ResourceName *string `type:"string"`

	// The type of Amazon Web Services resource; for example, an Amazon Elastic
	// Block Store (Amazon EBS) volume or an Amazon Relational Database Service
	// (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups,
	// the only supported resource type is Amazon EC2.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedResource) GoString() string {
	return s.String()
}

// SetLastBackupTime sets the LastBackupTime field's value.
func (s *ProtectedResource) SetLastBackupTime(v time.Time) *ProtectedResource {
	s.LastBackupTime = &v
	return s
}

// SetLastBackupVaultArn sets the LastBackupVaultArn field's value.
func (s *ProtectedResource) SetLastBackupVaultArn(v string) *ProtectedResource {
	s.LastBackupVaultArn = &v
	return s
}

// SetLastRecoveryPointArn sets the LastRecoveryPointArn field's value.
func (s *ProtectedResource) SetLastRecoveryPointArn(v string) *ProtectedResource {
	s.LastRecoveryPointArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ProtectedResource) SetResourceArn(v string) *ProtectedResource {
	s.ResourceArn = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *ProtectedResource) SetResourceName(v string) *ProtectedResource {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ProtectedResource) SetResourceType(v string) *ProtectedResource {
	s.ResourceType = &v
	return s
}

// A list of conditions that you define for resources in your restore testing
// plan using tags.
//
// For example, "StringEquals": { "Key": "aws:ResourceTag/CreatedByCryo", "Value":
// "true" },. Condition operators are case sensitive.
type ProtectedResourceConditions struct {
	_ struct{} `type:"structure"`

	// Filters the values of your tagged resources for only those resources that
	// you tagged with the same value. Also called "exact matching."
	StringEquals []*KeyValue `type:"list"`

	// Filters the values of your tagged resources for only those resources that
	// you tagged that do not have the same value. Also called "negated matching."
	StringNotEquals []*KeyValue `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedResourceConditions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProtectedResourceConditions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProtectedResourceConditions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProtectedResourceConditions"}
	if s.StringEquals != nil {
		for i, v := range s.StringEquals {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StringEquals", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.StringNotEquals != nil {
		for i, v := range s.StringNotEquals {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "StringNotEquals", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStringEquals sets the StringEquals field's value.
func (s *ProtectedResourceConditions) SetStringEquals(v []*KeyValue) *ProtectedResourceConditions {
	s.StringEquals = v
	return s
}

// SetStringNotEquals sets the StringNotEquals field's value.
func (s *ProtectedResourceConditions) SetStringNotEquals(v []*KeyValue) *ProtectedResourceConditions {
	s.StringNotEquals = v
	return s
}

type PutBackupVaultAccessPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// The backup vault access policy document in JSON format.
	Policy *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupVaultAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupVaultAccessPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBackupVaultAccessPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBackupVaultAccessPolicyInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *PutBackupVaultAccessPolicyInput) SetBackupVaultName(v string) *PutBackupVaultAccessPolicyInput {
	s.BackupVaultName = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *PutBackupVaultAccessPolicyInput) SetPolicy(v string) *PutBackupVaultAccessPolicyInput {
	s.Policy = &v
	return s
}

type PutBackupVaultAccessPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupVaultAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupVaultAccessPolicyOutput) GoString() string {
	return s.String()
}

type PutBackupVaultLockConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Backup Vault Lock configuration that specifies the name of the backup
	// vault it protects.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// The Backup Vault Lock configuration that specifies the number of days before
	// the lock date. For example, setting ChangeableForDays to 30 on Jan. 1, 2022
	// at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.
	//
	// Backup enforces a 72-hour cooling-off period before Vault Lock takes effect
	// and becomes immutable. Therefore, you must set ChangeableForDays to 3 or
	// greater.
	//
	// Before the lock date, you can delete Vault Lock from the vault using DeleteBackupVaultLockConfiguration
	// or change the Vault Lock configuration using PutBackupVaultLockConfiguration.
	// On and after the lock date, the Vault Lock becomes immutable and cannot be
	// changed or deleted.
	//
	// If this parameter is not specified, you can delete Vault Lock from the vault
	// using DeleteBackupVaultLockConfiguration or change the Vault Lock configuration
	// using PutBackupVaultLockConfiguration at any time.
	ChangeableForDays *int64 `type:"long"`

	// The Backup Vault Lock configuration that specifies the maximum retention
	// period that the vault retains its recovery points. This setting can be useful
	// if, for example, your organization's policies require you to destroy certain
	// data after retaining it for four years (1460 days).
	//
	// If this parameter is not included, Vault Lock does not enforce a maximum
	// retention period on the recovery points in the vault. If this parameter is
	// included without a value, Vault Lock will not enforce a maximum retention
	// period.
	//
	// If this parameter is specified, any backup or copy job to the vault must
	// have a lifecycle policy with a retention period equal to or shorter than
	// the maximum retention period. If the job's retention period is longer than
	// that maximum retention period, then the vault fails the backup or copy job,
	// and you should either modify your lifecycle settings or use a different vault.
	// The longest maximum retention period you can specify is 36500 days (approximately
	// 100 years). Recovery points already saved in the vault prior to Vault Lock
	// are not affected.
	MaxRetentionDays *int64 `type:"long"`

	// The Backup Vault Lock configuration that specifies the minimum retention
	// period that the vault retains its recovery points. This setting can be useful
	// if, for example, your organization's policies require you to retain certain
	// data for at least seven years (2555 days).
	//
	// If this parameter is not specified, Vault Lock will not enforce a minimum
	// retention period.
	//
	// If this parameter is specified, any backup or copy job to the vault must
	// have a lifecycle policy with a retention period equal to or longer than the
	// minimum retention period. If the job's retention period is shorter than that
	// minimum retention period, then the vault fails that backup or copy job, and
	// you should either modify your lifecycle settings or use a different vault.
	// The shortest minimum retention period you can specify is 1 day. Recovery
	// points already saved in the vault prior to Vault Lock are not affected.
	MinRetentionDays *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupVaultLockConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupVaultLockConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBackupVaultLockConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBackupVaultLockConfigurationInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *PutBackupVaultLockConfigurationInput) SetBackupVaultName(v string) *PutBackupVaultLockConfigurationInput {
	s.BackupVaultName = &v
	return s
}

// SetChangeableForDays sets the ChangeableForDays field's value.
func (s *PutBackupVaultLockConfigurationInput) SetChangeableForDays(v int64) *PutBackupVaultLockConfigurationInput {
	s.ChangeableForDays = &v
	return s
}

// SetMaxRetentionDays sets the MaxRetentionDays field's value.
func (s *PutBackupVaultLockConfigurationInput) SetMaxRetentionDays(v int64) *PutBackupVaultLockConfigurationInput {
	s.MaxRetentionDays = &v
	return s
}

// SetMinRetentionDays sets the MinRetentionDays field's value.
func (s *PutBackupVaultLockConfigurationInput) SetMinRetentionDays(v int64) *PutBackupVaultLockConfigurationInput {
	s.MinRetentionDays = &v
	return s
}

type PutBackupVaultLockConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupVaultLockConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupVaultLockConfigurationOutput) GoString() string {
	return s.String()
}

type PutBackupVaultNotificationsInput struct {
	_ struct{} `type:"structure"`

	// An array of events that indicate the status of jobs to back up resources
	// to the backup vault.
	//
	// For common use cases and code samples, see Using Amazon SNS to track Backup
	// events (https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html).
	//
	// The following events are supported:
	//
	//    * BACKUP_JOB_STARTED | BACKUP_JOB_COMPLETED
	//
	//    * COPY_JOB_STARTED | COPY_JOB_SUCCESSFUL | COPY_JOB_FAILED
	//
	//    * RESTORE_JOB_STARTED | RESTORE_JOB_COMPLETED | RECOVERY_POINT_MODIFIED
	//
	//    * S3_BACKUP_OBJECT_FAILED | S3_RESTORE_OBJECT_FAILED
	//
	// The list below shows items that are deprecated events (for reference) and
	// are no longer in use. They are no longer supported and will not return statuses
	// or notifications. Refer to the list above for current supported events.
	//
	// BackupVaultEvents is a required field
	BackupVaultEvents []*string `type:"list" required:"true" enum:"VaultEvent"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `location:"uri" locationName:"backupVaultName" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s
	// events; for example, arn:aws:sns:us-west-2:111122223333:MyVaultTopic.
	//
	// SNSTopicArn is a required field
	SNSTopicArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupVaultNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupVaultNotificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutBackupVaultNotificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutBackupVaultNotificationsInput"}
	if s.BackupVaultEvents == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultEvents"))
	}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.BackupVaultName != nil && len(*s.BackupVaultName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupVaultName", 1))
	}
	if s.SNSTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SNSTopicArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupVaultEvents sets the BackupVaultEvents field's value.
func (s *PutBackupVaultNotificationsInput) SetBackupVaultEvents(v []*string) *PutBackupVaultNotificationsInput {
	s.BackupVaultEvents = v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *PutBackupVaultNotificationsInput) SetBackupVaultName(v string) *PutBackupVaultNotificationsInput {
	s.BackupVaultName = &v
	return s
}

// SetSNSTopicArn sets the SNSTopicArn field's value.
func (s *PutBackupVaultNotificationsInput) SetSNSTopicArn(v string) *PutBackupVaultNotificationsInput {
	s.SNSTopicArn = &v
	return s
}

type PutBackupVaultNotificationsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupVaultNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutBackupVaultNotificationsOutput) GoString() string {
	return s.String()
}

type PutRestoreValidationResultInput struct {
	_ struct{} `type:"structure"`

	// This is a unique identifier of a restore job within Backup.
	//
	// RestoreJobId is a required field
	RestoreJobId *string `location:"uri" locationName:"restoreJobId" type:"string" required:"true"`

	// This is the status of your restore validation.
	//
	// ValidationStatus is a required field
	ValidationStatus *string `type:"string" required:"true" enum:"RestoreValidationStatus"`

	// This is an optional message string you can input to describe the validation
	// status for the restore test validation.
	ValidationStatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRestoreValidationResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRestoreValidationResultInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRestoreValidationResultInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRestoreValidationResultInput"}
	if s.RestoreJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreJobId"))
	}
	if s.RestoreJobId != nil && len(*s.RestoreJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestoreJobId", 1))
	}
	if s.ValidationStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("ValidationStatus"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestoreJobId sets the RestoreJobId field's value.
func (s *PutRestoreValidationResultInput) SetRestoreJobId(v string) *PutRestoreValidationResultInput {
	s.RestoreJobId = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *PutRestoreValidationResultInput) SetValidationStatus(v string) *PutRestoreValidationResultInput {
	s.ValidationStatus = &v
	return s
}

// SetValidationStatusMessage sets the ValidationStatusMessage field's value.
func (s *PutRestoreValidationResultInput) SetValidationStatusMessage(v string) *PutRestoreValidationResultInput {
	s.ValidationStatusMessage = &v
	return s
}

type PutRestoreValidationResultOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRestoreValidationResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRestoreValidationResultOutput) GoString() string {
	return s.String()
}

// Contains detailed information about the recovery points stored in a backup
// vault.
type RecoveryPointByBackupVault struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, of a backup.
	BackupSizeInBytes *int64 `type:"long"`

	// An ARN that uniquely identifies a backup vault; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	BackupVaultArn *string `type:"string"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	BackupVaultName *string `type:"string"`

	// A CalculatedLifecycle object containing DeleteAt and MoveToColdStorageAt
	// timestamps.
	CalculatedLifecycle *CalculatedLifecycle `type:"structure"`

	// The date and time a job to restore a recovery point is completed, in Unix
	// format and Coordinated Universal Time (UTC). The value of CompletionDate
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time `type:"timestamp"`

	// This is the identifier of a resource within a composite group, such as nested
	// (child) recovery point belonging to a composite (parent) stack. The ID is
	// transferred from the logical ID (https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax)
	// within a stack.
	CompositeMemberIdentifier *string `type:"string"`

	// Contains identifying information about the creation of a recovery point,
	// including the BackupPlanArn, BackupPlanId, BackupPlanVersion, and BackupRuleId
	// of the backup plan that is used to create it.
	CreatedBy *RecoveryPointCreator `type:"structure"`

	// The date and time a recovery point is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// The server-side encryption key that is used to protect your backups; for
	// example, arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	EncryptionKeyArn *string `type:"string"`

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// A Boolean value that is returned as TRUE if the specified recovery point
	// is encrypted, or FALSE if the recovery point is not encrypted.
	IsEncrypted *bool `type:"boolean"`

	// This is a boolean value indicating this is a parent (composite) recovery
	// point.
	IsParent *bool `type:"boolean"`

	// The date and time a recovery point was last restored, in Unix format and
	// Coordinated Universal Time (UTC). The value of LastRestoreTime is accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	LastRestoreTime *time.Time `type:"timestamp"`

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup transitions and expires backups automatically
	// according to the lifecycle that you define.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, the “retention” setting must be 90 days
	// greater than the “transition to cold after days” setting. The “transition
	// to cold after days” setting cannot be changed after a backup has been transitioned
	// to cold.
	//
	// Resource types that are able to be transitioned to cold storage are listed
	// in the "Lifecycle to cold storage" section of the Feature availability by
	// resource (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
	// table. Backup ignores this expression for other resource types.
	Lifecycle *Lifecycle `type:"structure"`

	// This is the Amazon Resource Name (ARN) of the parent (composite) recovery
	// point.
	ParentRecoveryPointArn *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// An ARN that uniquely identifies a resource. The format of the ARN depends
	// on the resource type.
	ResourceArn *string `type:"string"`

	// This is the non-unique name of the resource that belongs to the specified
	// backup.
	ResourceName *string `type:"string"`

	// The type of Amazon Web Services resource saved as a recovery point; for example,
	// an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational
	// Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service
	// (VSS) backups, the only supported resource type is Amazon EC2.
	ResourceType *string `type:"string"`

	// The backup vault where the recovery point was originally copied from. If
	// the recovery point is restored to the same account this value will be null.
	SourceBackupVaultArn *string `type:"string"`

	// A status code specifying the state of the recovery point.
	Status *string `type:"string" enum:"RecoveryPointStatus"`

	// A message explaining the reason of the recovery point deletion failure.
	StatusMessage *string `type:"string"`

	// This is the type of vault in which the described recovery point is stored.
	VaultType *string `type:"string" enum:"VaultType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryPointByBackupVault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryPointByBackupVault) GoString() string {
	return s.String()
}

// SetBackupSizeInBytes sets the BackupSizeInBytes field's value.
func (s *RecoveryPointByBackupVault) SetBackupSizeInBytes(v int64) *RecoveryPointByBackupVault {
	s.BackupSizeInBytes = &v
	return s
}

// SetBackupVaultArn sets the BackupVaultArn field's value.
func (s *RecoveryPointByBackupVault) SetBackupVaultArn(v string) *RecoveryPointByBackupVault {
	s.BackupVaultArn = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *RecoveryPointByBackupVault) SetBackupVaultName(v string) *RecoveryPointByBackupVault {
	s.BackupVaultName = &v
	return s
}

// SetCalculatedLifecycle sets the CalculatedLifecycle field's value.
func (s *RecoveryPointByBackupVault) SetCalculatedLifecycle(v *CalculatedLifecycle) *RecoveryPointByBackupVault {
	s.CalculatedLifecycle = v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *RecoveryPointByBackupVault) SetCompletionDate(v time.Time) *RecoveryPointByBackupVault {
	s.CompletionDate = &v
	return s
}

// SetCompositeMemberIdentifier sets the CompositeMemberIdentifier field's value.
func (s *RecoveryPointByBackupVault) SetCompositeMemberIdentifier(v string) *RecoveryPointByBackupVault {
	s.CompositeMemberIdentifier = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *RecoveryPointByBackupVault) SetCreatedBy(v *RecoveryPointCreator) *RecoveryPointByBackupVault {
	s.CreatedBy = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *RecoveryPointByBackupVault) SetCreationDate(v time.Time) *RecoveryPointByBackupVault {
	s.CreationDate = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *RecoveryPointByBackupVault) SetEncryptionKeyArn(v string) *RecoveryPointByBackupVault {
	s.EncryptionKeyArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *RecoveryPointByBackupVault) SetIamRoleArn(v string) *RecoveryPointByBackupVault {
	s.IamRoleArn = &v
	return s
}

// SetIsEncrypted sets the IsEncrypted field's value.
func (s *RecoveryPointByBackupVault) SetIsEncrypted(v bool) *RecoveryPointByBackupVault {
	s.IsEncrypted = &v
	return s
}

// SetIsParent sets the IsParent field's value.
func (s *RecoveryPointByBackupVault) SetIsParent(v bool) *RecoveryPointByBackupVault {
	s.IsParent = &v
	return s
}

// SetLastRestoreTime sets the LastRestoreTime field's value.
func (s *RecoveryPointByBackupVault) SetLastRestoreTime(v time.Time) *RecoveryPointByBackupVault {
	s.LastRestoreTime = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *RecoveryPointByBackupVault) SetLifecycle(v *Lifecycle) *RecoveryPointByBackupVault {
	s.Lifecycle = v
	return s
}

// SetParentRecoveryPointArn sets the ParentRecoveryPointArn field's value.
func (s *RecoveryPointByBackupVault) SetParentRecoveryPointArn(v string) *RecoveryPointByBackupVault {
	s.ParentRecoveryPointArn = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *RecoveryPointByBackupVault) SetRecoveryPointArn(v string) *RecoveryPointByBackupVault {
	s.RecoveryPointArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *RecoveryPointByBackupVault) SetResourceArn(v string) *RecoveryPointByBackupVault {
	s.ResourceArn = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *RecoveryPointByBackupVault) SetResourceName(v string) *RecoveryPointByBackupVault {
	s.ResourceName = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *RecoveryPointByBackupVault) SetResourceType(v string) *RecoveryPointByBackupVault {
	s.ResourceType = &v
	return s
}

// SetSourceBackupVaultArn sets the SourceBackupVaultArn field's value.
func (s *RecoveryPointByBackupVault) SetSourceBackupVaultArn(v string) *RecoveryPointByBackupVault {
	s.SourceBackupVaultArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecoveryPointByBackupVault) SetStatus(v string) *RecoveryPointByBackupVault {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *RecoveryPointByBackupVault) SetStatusMessage(v string) *RecoveryPointByBackupVault {
	s.StatusMessage = &v
	return s
}

// SetVaultType sets the VaultType field's value.
func (s *RecoveryPointByBackupVault) SetVaultType(v string) *RecoveryPointByBackupVault {
	s.VaultType = &v
	return s
}

// Contains detailed information about a saved recovery point.
type RecoveryPointByResource struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, of a backup.
	BackupSizeBytes *int64 `type:"long"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	BackupVaultName *string `type:"string"`

	// The date and time a recovery point is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// The server-side encryption key that is used to protect your backups; for
	// example, arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab.
	EncryptionKeyArn *string `type:"string"`

	// This is a boolean value indicating this is a parent (composite) recovery
	// point.
	IsParent *bool `type:"boolean"`

	// This is the Amazon Resource Name (ARN) of the parent (composite) recovery
	// point.
	ParentRecoveryPointArn *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies a recovery point;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// This is the non-unique name of the resource that belongs to the specified
	// backup.
	ResourceName *string `type:"string"`

	// A status code specifying the state of the recovery point.
	Status *string `type:"string" enum:"RecoveryPointStatus"`

	// A message explaining the reason of the recovery point deletion failure.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryPointByResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryPointByResource) GoString() string {
	return s.String()
}

// SetBackupSizeBytes sets the BackupSizeBytes field's value.
func (s *RecoveryPointByResource) SetBackupSizeBytes(v int64) *RecoveryPointByResource {
	s.BackupSizeBytes = &v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *RecoveryPointByResource) SetBackupVaultName(v string) *RecoveryPointByResource {
	s.BackupVaultName = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *RecoveryPointByResource) SetCreationDate(v time.Time) *RecoveryPointByResource {
	s.CreationDate = &v
	return s
}

// SetEncryptionKeyArn sets the EncryptionKeyArn field's value.
func (s *RecoveryPointByResource) SetEncryptionKeyArn(v string) *RecoveryPointByResource {
	s.EncryptionKeyArn = &v
	return s
}

// SetIsParent sets the IsParent field's value.
func (s *RecoveryPointByResource) SetIsParent(v bool) *RecoveryPointByResource {
	s.IsParent = &v
	return s
}

// SetParentRecoveryPointArn sets the ParentRecoveryPointArn field's value.
func (s *RecoveryPointByResource) SetParentRecoveryPointArn(v string) *RecoveryPointByResource {
	s.ParentRecoveryPointArn = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *RecoveryPointByResource) SetRecoveryPointArn(v string) *RecoveryPointByResource {
	s.RecoveryPointArn = &v
	return s
}

// SetResourceName sets the ResourceName field's value.
func (s *RecoveryPointByResource) SetResourceName(v string) *RecoveryPointByResource {
	s.ResourceName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RecoveryPointByResource) SetStatus(v string) *RecoveryPointByResource {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *RecoveryPointByResource) SetStatusMessage(v string) *RecoveryPointByResource {
	s.StatusMessage = &v
	return s
}

// Contains information about the backup plan and rule that Backup used to initiate
// the recovery point backup.
type RecoveryPointCreator struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for
	// example, arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50.
	BackupPlanArn *string `type:"string"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings
	// that are at most 1,024 bytes long. They cannot be edited.
	BackupPlanVersion *string `type:"string"`

	// Uniquely identifies a rule used to schedule the backup of a selection of
	// resources.
	BackupRuleId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryPointCreator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryPointCreator) GoString() string {
	return s.String()
}

// SetBackupPlanArn sets the BackupPlanArn field's value.
func (s *RecoveryPointCreator) SetBackupPlanArn(v string) *RecoveryPointCreator {
	s.BackupPlanArn = &v
	return s
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *RecoveryPointCreator) SetBackupPlanId(v string) *RecoveryPointCreator {
	s.BackupPlanId = &v
	return s
}

// SetBackupPlanVersion sets the BackupPlanVersion field's value.
func (s *RecoveryPointCreator) SetBackupPlanVersion(v string) *RecoveryPointCreator {
	s.BackupPlanVersion = &v
	return s
}

// SetBackupRuleId sets the BackupRuleId field's value.
func (s *RecoveryPointCreator) SetBackupRuleId(v string) *RecoveryPointCreator {
	s.BackupRuleId = &v
	return s
}

// This is a recovery point which is a child (nested) recovery point of a parent
// (composite) recovery point. These recovery points can be disassociated from
// their parent (composite) recovery point, in which case they will no longer
// be a member.
type RecoveryPointMember struct {
	_ struct{} `type:"structure"`

	// This is the name of the backup vault (the logical container in which backups
	// are stored).
	BackupVaultName *string `type:"string"`

	// This is the Amazon Resource Name (ARN) of the parent (composite) recovery
	// point.
	RecoveryPointArn *string `type:"string"`

	// This is the Amazon Resource Name (ARN) that uniquely identifies a saved resource.
	ResourceArn *string `type:"string"`

	// This is the Amazon Web Services resource type that is saved as a recovery
	// point.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryPointMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryPointMember) GoString() string {
	return s.String()
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *RecoveryPointMember) SetBackupVaultName(v string) *RecoveryPointMember {
	s.BackupVaultName = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *RecoveryPointMember) SetRecoveryPointArn(v string) *RecoveryPointMember {
	s.RecoveryPointArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *RecoveryPointMember) SetResourceArn(v string) *RecoveryPointMember {
	s.ResourceArn = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *RecoveryPointMember) SetResourceType(v string) *RecoveryPointMember {
	s.ResourceType = &v
	return s
}

// This specifies criteria to assign a set of resources, such as resource types
// or backup vaults.
type RecoveryPointSelection struct {
	_ struct{} `type:"structure"`

	// This is a resource filter containing FromDate: DateTime and ToDate: DateTime.
	// Both values are required. Future DateTime values are not permitted.
	//
	// The date and time are in Unix format and Coordinated Universal Time (UTC),
	// and it is accurate to milliseconds ((milliseconds are optional). For example,
	// the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
	// AM.
	DateRange *DateRange `type:"structure"`

	// These are the resources included in the resource selection (including type
	// of resources and vaults).
	ResourceIdentifiers []*string `type:"list"`

	// These are the names of the vaults in which the selected recovery points are
	// contained.
	VaultNames []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryPointSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryPointSelection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RecoveryPointSelection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RecoveryPointSelection"}
	if s.DateRange != nil {
		if err := s.DateRange.Validate(); err != nil {
			invalidParams.AddNested("DateRange", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDateRange sets the DateRange field's value.
func (s *RecoveryPointSelection) SetDateRange(v *DateRange) *RecoveryPointSelection {
	s.DateRange = v
	return s
}

// SetResourceIdentifiers sets the ResourceIdentifiers field's value.
func (s *RecoveryPointSelection) SetResourceIdentifiers(v []*string) *RecoveryPointSelection {
	s.ResourceIdentifiers = v
	return s
}

// SetVaultNames sets the VaultNames field's value.
func (s *RecoveryPointSelection) SetVaultNames(v []*string) *RecoveryPointSelection {
	s.VaultNames = v
	return s
}

// Contains information from your report plan about where to deliver your reports,
// specifically your Amazon S3 bucket name, S3 key prefix, and the formats of
// your reports.
type ReportDeliveryChannel struct {
	_ struct{} `type:"structure"`

	// A list of the format of your reports: CSV, JSON, or both. If not specified,
	// the default format is CSV.
	Formats []*string `type:"list"`

	// The unique name of the S3 bucket that receives your reports.
	//
	// S3BucketName is a required field
	S3BucketName *string `type:"string" required:"true"`

	// The prefix for where Backup Audit Manager delivers your reports to Amazon
	// S3. The prefix is this part of the following path: s3://your-bucket-name/prefix/Backup/us-west-2/year/month/day/report-name.
	// If not specified, there is no prefix.
	S3KeyPrefix *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportDeliveryChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportDeliveryChannel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReportDeliveryChannel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReportDeliveryChannel"}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFormats sets the Formats field's value.
func (s *ReportDeliveryChannel) SetFormats(v []*string) *ReportDeliveryChannel {
	s.Formats = v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *ReportDeliveryChannel) SetS3BucketName(v string) *ReportDeliveryChannel {
	s.S3BucketName = &v
	return s
}

// SetS3KeyPrefix sets the S3KeyPrefix field's value.
func (s *ReportDeliveryChannel) SetS3KeyPrefix(v string) *ReportDeliveryChannel {
	s.S3KeyPrefix = &v
	return s
}

// Contains information from your report job about your report destination.
type ReportDestination struct {
	_ struct{} `type:"structure"`

	// The unique name of the Amazon S3 bucket that receives your reports.
	S3BucketName *string `type:"string"`

	// The object key that uniquely identifies your reports in your S3 bucket.
	S3Keys []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportDestination) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportDestination) GoString() string {
	return s.String()
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *ReportDestination) SetS3BucketName(v string) *ReportDestination {
	s.S3BucketName = &v
	return s
}

// SetS3Keys sets the S3Keys field's value.
func (s *ReportDestination) SetS3Keys(v []*string) *ReportDestination {
	s.S3Keys = v
	return s
}

// Contains detailed information about a report job. A report job compiles a
// report based on a report plan and publishes it to Amazon S3.
type ReportJob struct {
	_ struct{} `type:"structure"`

	// The date and time that a report job is completed, in Unix format and Coordinated
	// Universal Time (UTC). The value of CompletionTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CompletionTime *time.Time `type:"timestamp"`

	// The date and time that a report job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationTime *time.Time `type:"timestamp"`

	// The S3 bucket name and S3 keys for the destination where the report job publishes
	// the report.
	ReportDestination *ReportDestination `type:"structure"`

	// The identifier for a report job. A unique, randomly generated, Unicode, UTF-8
	// encoded string that is at most 1,024 bytes long. Report job IDs cannot be
	// edited.
	ReportJobId *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	ReportPlanArn *string `type:"string"`

	// Identifies the report template for the report. Reports are built using a
	// report template. The report templates are:
	//
	// RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT
	// | COPY_JOB_REPORT | RESTORE_JOB_REPORT
	ReportTemplate *string `type:"string"`

	// The status of a report job. The statuses are:
	//
	// CREATED | RUNNING | COMPLETED | FAILED
	//
	// COMPLETED means that the report is available for your review at your designated
	// destination. If the status is FAILED, review the StatusMessage for the reason.
	Status *string `type:"string"`

	// A message explaining the status of the report job.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportJob) GoString() string {
	return s.String()
}

// SetCompletionTime sets the CompletionTime field's value.
func (s *ReportJob) SetCompletionTime(v time.Time) *ReportJob {
	s.CompletionTime = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ReportJob) SetCreationTime(v time.Time) *ReportJob {
	s.CreationTime = &v
	return s
}

// SetReportDestination sets the ReportDestination field's value.
func (s *ReportJob) SetReportDestination(v *ReportDestination) *ReportJob {
	s.ReportDestination = v
	return s
}

// SetReportJobId sets the ReportJobId field's value.
func (s *ReportJob) SetReportJobId(v string) *ReportJob {
	s.ReportJobId = &v
	return s
}

// SetReportPlanArn sets the ReportPlanArn field's value.
func (s *ReportJob) SetReportPlanArn(v string) *ReportJob {
	s.ReportPlanArn = &v
	return s
}

// SetReportTemplate sets the ReportTemplate field's value.
func (s *ReportJob) SetReportTemplate(v string) *ReportJob {
	s.ReportTemplate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReportJob) SetStatus(v string) *ReportJob {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ReportJob) SetStatusMessage(v string) *ReportJob {
	s.StatusMessage = &v
	return s
}

// Contains detailed information about a report plan.
type ReportPlan struct {
	_ struct{} `type:"structure"`

	// The date and time that a report plan is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationTime is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationTime *time.Time `type:"timestamp"`

	// The deployment status of a report plan. The statuses are:
	//
	// CREATE_IN_PROGRESS | UPDATE_IN_PROGRESS | DELETE_IN_PROGRESS | COMPLETED
	DeploymentStatus *string `type:"string"`

	// The date and time that a report job associated with this report plan last
	// attempted to run, in Unix format and Coordinated Universal Time (UTC). The
	// value of LastAttemptedExecutionTime is accurate to milliseconds. For example,
	// the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
	// AM.
	LastAttemptedExecutionTime *time.Time `type:"timestamp"`

	// The date and time that a report job associated with this report plan last
	// successfully ran, in Unix format and Coordinated Universal Time (UTC). The
	// value of LastSuccessfulExecutionTime is accurate to milliseconds. For example,
	// the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087
	// AM.
	LastSuccessfulExecutionTime *time.Time `type:"timestamp"`

	// Contains information about where and how to deliver your reports, specifically
	// your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
	ReportDeliveryChannel *ReportDeliveryChannel `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	ReportPlanArn *string `type:"string"`

	// An optional description of the report plan with a maximum 1,024 characters.
	ReportPlanDescription *string `type:"string"`

	// The unique name of the report plan. This name is between 1 and 256 characters
	// starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9),
	// and underscores (_).
	ReportPlanName *string `min:"1" type:"string"`

	// Identifies the report template for the report. Reports are built using a
	// report template. The report templates are:
	//
	// RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT
	// | COPY_JOB_REPORT | RESTORE_JOB_REPORT
	//
	// If the report template is RESOURCE_COMPLIANCE_REPORT or CONTROL_COMPLIANCE_REPORT,
	// this API resource also describes the report coverage by Amazon Web Services
	// Regions and frameworks.
	ReportSetting *ReportSetting `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportPlan) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportPlan) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ReportPlan) SetCreationTime(v time.Time) *ReportPlan {
	s.CreationTime = &v
	return s
}

// SetDeploymentStatus sets the DeploymentStatus field's value.
func (s *ReportPlan) SetDeploymentStatus(v string) *ReportPlan {
	s.DeploymentStatus = &v
	return s
}

// SetLastAttemptedExecutionTime sets the LastAttemptedExecutionTime field's value.
func (s *ReportPlan) SetLastAttemptedExecutionTime(v time.Time) *ReportPlan {
	s.LastAttemptedExecutionTime = &v
	return s
}

// SetLastSuccessfulExecutionTime sets the LastSuccessfulExecutionTime field's value.
func (s *ReportPlan) SetLastSuccessfulExecutionTime(v time.Time) *ReportPlan {
	s.LastSuccessfulExecutionTime = &v
	return s
}

// SetReportDeliveryChannel sets the ReportDeliveryChannel field's value.
func (s *ReportPlan) SetReportDeliveryChannel(v *ReportDeliveryChannel) *ReportPlan {
	s.ReportDeliveryChannel = v
	return s
}

// SetReportPlanArn sets the ReportPlanArn field's value.
func (s *ReportPlan) SetReportPlanArn(v string) *ReportPlan {
	s.ReportPlanArn = &v
	return s
}

// SetReportPlanDescription sets the ReportPlanDescription field's value.
func (s *ReportPlan) SetReportPlanDescription(v string) *ReportPlan {
	s.ReportPlanDescription = &v
	return s
}

// SetReportPlanName sets the ReportPlanName field's value.
func (s *ReportPlan) SetReportPlanName(v string) *ReportPlan {
	s.ReportPlanName = &v
	return s
}

// SetReportSetting sets the ReportSetting field's value.
func (s *ReportPlan) SetReportSetting(v *ReportSetting) *ReportPlan {
	s.ReportSetting = v
	return s
}

// Contains detailed information about a report setting.
type ReportSetting struct {
	_ struct{} `type:"structure"`

	// These are the accounts to be included in the report.
	Accounts []*string `type:"list"`

	// The Amazon Resource Names (ARNs) of the frameworks a report covers.
	FrameworkArns []*string `type:"list"`

	// The number of frameworks a report covers.
	NumberOfFrameworks *int64 `type:"integer"`

	// These are the Organizational Units to be included in the report.
	OrganizationUnits []*string `type:"list"`

	// These are the Regions to be included in the report.
	Regions []*string `type:"list"`

	// Identifies the report template for the report. Reports are built using a
	// report template. The report templates are:
	//
	// RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT
	// | COPY_JOB_REPORT | RESTORE_JOB_REPORT
	//
	// ReportTemplate is a required field
	ReportTemplate *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ReportSetting) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReportSetting) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReportSetting"}
	if s.ReportTemplate == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportTemplate"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccounts sets the Accounts field's value.
func (s *ReportSetting) SetAccounts(v []*string) *ReportSetting {
	s.Accounts = v
	return s
}

// SetFrameworkArns sets the FrameworkArns field's value.
func (s *ReportSetting) SetFrameworkArns(v []*string) *ReportSetting {
	s.FrameworkArns = v
	return s
}

// SetNumberOfFrameworks sets the NumberOfFrameworks field's value.
func (s *ReportSetting) SetNumberOfFrameworks(v int64) *ReportSetting {
	s.NumberOfFrameworks = &v
	return s
}

// SetOrganizationUnits sets the OrganizationUnits field's value.
func (s *ReportSetting) SetOrganizationUnits(v []*string) *ReportSetting {
	s.OrganizationUnits = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *ReportSetting) SetRegions(v []*string) *ReportSetting {
	s.Regions = v
	return s
}

// SetReportTemplate sets the ReportTemplate field's value.
func (s *ReportSetting) SetReportTemplate(v string) *ReportSetting {
	s.ReportTemplate = &v
	return s
}

// A resource that is required for the action doesn't exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Context *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains information about the restore testing plan that Backup used to initiate
// the restore job.
type RestoreJobCreator struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a restore testing
	// plan.
	RestoreTestingPlanArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreJobCreator) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreJobCreator) GoString() string {
	return s.String()
}

// SetRestoreTestingPlanArn sets the RestoreTestingPlanArn field's value.
func (s *RestoreJobCreator) SetRestoreTestingPlanArn(v string) *RestoreJobCreator {
	s.RestoreTestingPlanArn = &v
	return s
}

// This is a summary of restore jobs created or running within the most recent
// 30 days.
//
// The returned summary may contain the following: Region, Account, State, ResourceType,
// MessageCategory, StartTime, EndTime, and Count of included jobs.
type RestoreJobSummary struct {
	_ struct{} `type:"structure"`

	// The account ID that owns the jobs within the summary.
	AccountId *string `type:"string"`

	// The value as a number of jobs in a job summary.
	Count *int64 `type:"integer"`

	// The value of time in number format of a job end time.
	//
	// This value is the time in Unix format, Coordinated Universal Time (UTC),
	// and accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	EndTime *time.Time `type:"timestamp"`

	// The Amazon Web Services Regions within the job summary.
	Region *string `type:"string"`

	// This value is the job count for the specified resource type. The request
	// GetSupportedResourceTypes returns strings for supported resource types.
	ResourceType *string `type:"string"`

	// The value of time in number format of a job start time.
	//
	// This value is the time in Unix format, Coordinated Universal Time (UTC),
	// and accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	StartTime *time.Time `type:"timestamp"`

	// This value is job count for jobs with the specified state.
	State *string `type:"string" enum:"RestoreJobState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreJobSummary) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *RestoreJobSummary) SetAccountId(v string) *RestoreJobSummary {
	s.AccountId = &v
	return s
}

// SetCount sets the Count field's value.
func (s *RestoreJobSummary) SetCount(v int64) *RestoreJobSummary {
	s.Count = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *RestoreJobSummary) SetEndTime(v time.Time) *RestoreJobSummary {
	s.EndTime = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *RestoreJobSummary) SetRegion(v string) *RestoreJobSummary {
	s.Region = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *RestoreJobSummary) SetResourceType(v string) *RestoreJobSummary {
	s.ResourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *RestoreJobSummary) SetStartTime(v time.Time) *RestoreJobSummary {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *RestoreJobSummary) SetState(v string) *RestoreJobSummary {
	s.State = &v
	return s
}

// Contains metadata about a restore job.
type RestoreJobsListMember struct {
	_ struct{} `type:"structure"`

	// The account ID that owns the restore job.
	AccountId *string `type:"string"`

	// The size, in bytes, of the restored resource.
	BackupSizeInBytes *int64 `type:"long"`

	// The date and time a job to restore a recovery point is completed, in Unix
	// format and Coordinated Universal Time (UTC). The value of CompletionDate
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	CompletionDate *time.Time `type:"timestamp"`

	// Contains identifying information about the creation of a restore job.
	CreatedBy *RestoreJobCreator `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	CreatedResourceArn *string `type:"string"`

	// The date and time a restore job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// This notes the status of the data generated by the restore test. The status
	// may be Deleting, Failed, or Successful.
	DeletionStatus *string `type:"string" enum:"RestoreDeletionStatus"`

	// This describes the restore job deletion status.
	DeletionStatusMessage *string `type:"string"`

	// The amount of time in minutes that a job restoring a recovery point is expected
	// to take.
	ExpectedCompletionTimeMinutes *int64 `type:"long"`

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// Contains an estimated percentage complete of a job at the time the job status
	// was queried.
	PercentDone *string `type:"string"`

	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`

	// The date on which a recovery point was created.
	RecoveryPointCreationDate *time.Time `type:"timestamp"`

	// The resource type of the listed restore jobs; for example, an Amazon Elastic
	// Block Store (Amazon EBS) volume or an Amazon Relational Database Service
	// (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups,
	// the only supported resource type is Amazon EC2.
	ResourceType *string `type:"string"`

	// Uniquely identifies the job that restores a recovery point.
	RestoreJobId *string `type:"string"`

	// A status code specifying the state of the job initiated by Backup to restore
	// a recovery point.
	Status *string `type:"string" enum:"RestoreJobStatus"`

	// A detailed message explaining the status of the job to restore a recovery
	// point.
	StatusMessage *string `type:"string"`

	// This is the status of validation run on the indicated restore job.
	ValidationStatus *string `type:"string" enum:"RestoreValidationStatus"`

	// This describes the status of validation run on the indicated restore job.
	ValidationStatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreJobsListMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreJobsListMember) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *RestoreJobsListMember) SetAccountId(v string) *RestoreJobsListMember {
	s.AccountId = &v
	return s
}

// SetBackupSizeInBytes sets the BackupSizeInBytes field's value.
func (s *RestoreJobsListMember) SetBackupSizeInBytes(v int64) *RestoreJobsListMember {
	s.BackupSizeInBytes = &v
	return s
}

// SetCompletionDate sets the CompletionDate field's value.
func (s *RestoreJobsListMember) SetCompletionDate(v time.Time) *RestoreJobsListMember {
	s.CompletionDate = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *RestoreJobsListMember) SetCreatedBy(v *RestoreJobCreator) *RestoreJobsListMember {
	s.CreatedBy = v
	return s
}

// SetCreatedResourceArn sets the CreatedResourceArn field's value.
func (s *RestoreJobsListMember) SetCreatedResourceArn(v string) *RestoreJobsListMember {
	s.CreatedResourceArn = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *RestoreJobsListMember) SetCreationDate(v time.Time) *RestoreJobsListMember {
	s.CreationDate = &v
	return s
}

// SetDeletionStatus sets the DeletionStatus field's value.
func (s *RestoreJobsListMember) SetDeletionStatus(v string) *RestoreJobsListMember {
	s.DeletionStatus = &v
	return s
}

// SetDeletionStatusMessage sets the DeletionStatusMessage field's value.
func (s *RestoreJobsListMember) SetDeletionStatusMessage(v string) *RestoreJobsListMember {
	s.DeletionStatusMessage = &v
	return s
}

// SetExpectedCompletionTimeMinutes sets the ExpectedCompletionTimeMinutes field's value.
func (s *RestoreJobsListMember) SetExpectedCompletionTimeMinutes(v int64) *RestoreJobsListMember {
	s.ExpectedCompletionTimeMinutes = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *RestoreJobsListMember) SetIamRoleArn(v string) *RestoreJobsListMember {
	s.IamRoleArn = &v
	return s
}

// SetPercentDone sets the PercentDone field's value.
func (s *RestoreJobsListMember) SetPercentDone(v string) *RestoreJobsListMember {
	s.PercentDone = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *RestoreJobsListMember) SetRecoveryPointArn(v string) *RestoreJobsListMember {
	s.RecoveryPointArn = &v
	return s
}

// SetRecoveryPointCreationDate sets the RecoveryPointCreationDate field's value.
func (s *RestoreJobsListMember) SetRecoveryPointCreationDate(v time.Time) *RestoreJobsListMember {
	s.RecoveryPointCreationDate = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *RestoreJobsListMember) SetResourceType(v string) *RestoreJobsListMember {
	s.ResourceType = &v
	return s
}

// SetRestoreJobId sets the RestoreJobId field's value.
func (s *RestoreJobsListMember) SetRestoreJobId(v string) *RestoreJobsListMember {
	s.RestoreJobId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RestoreJobsListMember) SetStatus(v string) *RestoreJobsListMember {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *RestoreJobsListMember) SetStatusMessage(v string) *RestoreJobsListMember {
	s.StatusMessage = &v
	return s
}

// SetValidationStatus sets the ValidationStatus field's value.
func (s *RestoreJobsListMember) SetValidationStatus(v string) *RestoreJobsListMember {
	s.ValidationStatus = &v
	return s
}

// SetValidationStatusMessage sets the ValidationStatusMessage field's value.
func (s *RestoreJobsListMember) SetValidationStatusMessage(v string) *RestoreJobsListMember {
	s.ValidationStatusMessage = &v
	return s
}

// This contains metadata about a restore testing plan.
type RestoreTestingPlanForCreate struct {
	_ struct{} `type:"structure"`

	// Required: Algorithm; Required: Recovery point types; IncludeVaults (one or
	// more). Optional: SelectionWindowDays ('30' if not specified); ExcludeVaults
	// (list of selectors), defaults to empty list if not listed.
	//
	// RecoveryPointSelection is a required field
	RecoveryPointSelection *RestoreTestingRecoveryPointSelection `type:"structure" required:"true"`

	// The RestoreTestingPlanName is a unique string that is the name of the restore
	// testing plan. This cannot be changed after creation, and it must consist
	// of only alphanumeric characters and underscores.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `type:"string" required:"true"`

	// A CRON expression in specified timezone when a restore testing plan is executed.
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `type:"string" required:"true"`

	// Optional. This is the timezone in which the schedule expression is set. By
	// default, ScheduleExpressions are in UTC. You can modify this to a specified
	// timezone.
	ScheduleExpressionTimezone *string `type:"string"`

	// Defaults to 24 hours.
	//
	// A value in hours after a restore test is scheduled before a job will be canceled
	// if it doesn't start successfully. This value is optional. If this value is
	// included, this parameter has a maximum value of 168 hours (one week).
	StartWindowHours *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingPlanForCreate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingPlanForCreate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTestingPlanForCreate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreTestingPlanForCreate"}
	if s.RecoveryPointSelection == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointSelection"))
	}
	if s.RestoreTestingPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreTestingPlanName"))
	}
	if s.ScheduleExpression == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduleExpression"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryPointSelection sets the RecoveryPointSelection field's value.
func (s *RestoreTestingPlanForCreate) SetRecoveryPointSelection(v *RestoreTestingRecoveryPointSelection) *RestoreTestingPlanForCreate {
	s.RecoveryPointSelection = v
	return s
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *RestoreTestingPlanForCreate) SetRestoreTestingPlanName(v string) *RestoreTestingPlanForCreate {
	s.RestoreTestingPlanName = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *RestoreTestingPlanForCreate) SetScheduleExpression(v string) *RestoreTestingPlanForCreate {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleExpressionTimezone sets the ScheduleExpressionTimezone field's value.
func (s *RestoreTestingPlanForCreate) SetScheduleExpressionTimezone(v string) *RestoreTestingPlanForCreate {
	s.ScheduleExpressionTimezone = &v
	return s
}

// SetStartWindowHours sets the StartWindowHours field's value.
func (s *RestoreTestingPlanForCreate) SetStartWindowHours(v int64) *RestoreTestingPlanForCreate {
	s.StartWindowHours = &v
	return s
}

// This contains metadata about a restore testing plan.
type RestoreTestingPlanForGet struct {
	_ struct{} `type:"structure"`

	// The date and time that a restore testing plan was created, in Unix format
	// and Coordinated Universal Time (UTC). The value of CreationTime is accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// This identifies the request and allows failed requests to be retried without
	// the risk of running the operation twice. If the request includes a CreatorRequestId
	// that matches an existing backup plan, that plan is returned. This parameter
	// is optional.
	//
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string `type:"string"`

	// The last time a restore test was run with the specified restore testing plan.
	// A date and time, in Unix format and Coordinated Universal Time (UTC). The
	// value of LastExecutionDate is accurate to milliseconds. For example, the
	// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	LastExecutionTime *time.Time `type:"timestamp"`

	// The date and time that the restore testing plan was updated. This update
	// is in Unix format and Coordinated Universal Time (UTC). The value of LastUpdateTime
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The specified criteria to assign a set of resources, such as recovery point
	// types or backup vaults.
	//
	// RecoveryPointSelection is a required field
	RecoveryPointSelection *RestoreTestingRecoveryPointSelection `type:"structure" required:"true"`

	// An Amazon Resource Name (ARN) that uniquely identifies a restore testing
	// plan.
	//
	// RestoreTestingPlanArn is a required field
	RestoreTestingPlanArn *string `type:"string" required:"true"`

	// This is the restore testing plan name.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `type:"string" required:"true"`

	// A CRON expression in specified timezone when a restore testing plan is executed.
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `type:"string" required:"true"`

	// Optional. This is the timezone in which the schedule expression is set. By
	// default, ScheduleExpressions are in UTC. You can modify this to a specified
	// timezone.
	ScheduleExpressionTimezone *string `type:"string"`

	// Defaults to 24 hours.
	//
	// A value in hours after a restore test is scheduled before a job will be canceled
	// if it doesn't start successfully. This value is optional. If this value is
	// included, this parameter has a maximum value of 168 hours (one week).
	StartWindowHours *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingPlanForGet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingPlanForGet) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *RestoreTestingPlanForGet) SetCreationTime(v time.Time) *RestoreTestingPlanForGet {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *RestoreTestingPlanForGet) SetCreatorRequestId(v string) *RestoreTestingPlanForGet {
	s.CreatorRequestId = &v
	return s
}

// SetLastExecutionTime sets the LastExecutionTime field's value.
func (s *RestoreTestingPlanForGet) SetLastExecutionTime(v time.Time) *RestoreTestingPlanForGet {
	s.LastExecutionTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *RestoreTestingPlanForGet) SetLastUpdateTime(v time.Time) *RestoreTestingPlanForGet {
	s.LastUpdateTime = &v
	return s
}

// SetRecoveryPointSelection sets the RecoveryPointSelection field's value.
func (s *RestoreTestingPlanForGet) SetRecoveryPointSelection(v *RestoreTestingRecoveryPointSelection) *RestoreTestingPlanForGet {
	s.RecoveryPointSelection = v
	return s
}

// SetRestoreTestingPlanArn sets the RestoreTestingPlanArn field's value.
func (s *RestoreTestingPlanForGet) SetRestoreTestingPlanArn(v string) *RestoreTestingPlanForGet {
	s.RestoreTestingPlanArn = &v
	return s
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *RestoreTestingPlanForGet) SetRestoreTestingPlanName(v string) *RestoreTestingPlanForGet {
	s.RestoreTestingPlanName = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *RestoreTestingPlanForGet) SetScheduleExpression(v string) *RestoreTestingPlanForGet {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleExpressionTimezone sets the ScheduleExpressionTimezone field's value.
func (s *RestoreTestingPlanForGet) SetScheduleExpressionTimezone(v string) *RestoreTestingPlanForGet {
	s.ScheduleExpressionTimezone = &v
	return s
}

// SetStartWindowHours sets the StartWindowHours field's value.
func (s *RestoreTestingPlanForGet) SetStartWindowHours(v int64) *RestoreTestingPlanForGet {
	s.StartWindowHours = &v
	return s
}

// This contains metadata about a restore testing plan.
type RestoreTestingPlanForList struct {
	_ struct{} `type:"structure"`

	// The date and time that a restore testing plan was created, in Unix format
	// and Coordinated Universal Time (UTC). The value of CreationTime is accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The last time a restore test was run with the specified restore testing plan.
	// A date and time, in Unix format and Coordinated Universal Time (UTC). The
	// value of LastExecutionDate is accurate to milliseconds. For example, the
	// value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
	LastExecutionTime *time.Time `type:"timestamp"`

	// The date and time that the restore testing plan was updated. This update
	// is in Unix format and Coordinated Universal Time (UTC). The value of LastUpdateTime
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26, 2018 12:11:30.087 AM.
	LastUpdateTime *time.Time `type:"timestamp"`

	// An Amazon Resource Name (ARN) that uniquely identifiesa restore testing plan.
	//
	// RestoreTestingPlanArn is a required field
	RestoreTestingPlanArn *string `type:"string" required:"true"`

	// This is the restore testing plan name.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `type:"string" required:"true"`

	// A CRON expression in specified timezone when a restore testing plan is executed.
	//
	// ScheduleExpression is a required field
	ScheduleExpression *string `type:"string" required:"true"`

	// Optional. This is the timezone in which the schedule expression is set. By
	// default, ScheduleExpressions are in UTC. You can modify this to a specified
	// timezone.
	ScheduleExpressionTimezone *string `type:"string"`

	// Defaults to 24 hours.
	//
	// A value in hours after a restore test is scheduled before a job will be canceled
	// if it doesn't start successfully. This value is optional. If this value is
	// included, this parameter has a maximum value of 168 hours (one week).
	StartWindowHours *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingPlanForList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingPlanForList) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *RestoreTestingPlanForList) SetCreationTime(v time.Time) *RestoreTestingPlanForList {
	s.CreationTime = &v
	return s
}

// SetLastExecutionTime sets the LastExecutionTime field's value.
func (s *RestoreTestingPlanForList) SetLastExecutionTime(v time.Time) *RestoreTestingPlanForList {
	s.LastExecutionTime = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *RestoreTestingPlanForList) SetLastUpdateTime(v time.Time) *RestoreTestingPlanForList {
	s.LastUpdateTime = &v
	return s
}

// SetRestoreTestingPlanArn sets the RestoreTestingPlanArn field's value.
func (s *RestoreTestingPlanForList) SetRestoreTestingPlanArn(v string) *RestoreTestingPlanForList {
	s.RestoreTestingPlanArn = &v
	return s
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *RestoreTestingPlanForList) SetRestoreTestingPlanName(v string) *RestoreTestingPlanForList {
	s.RestoreTestingPlanName = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *RestoreTestingPlanForList) SetScheduleExpression(v string) *RestoreTestingPlanForList {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleExpressionTimezone sets the ScheduleExpressionTimezone field's value.
func (s *RestoreTestingPlanForList) SetScheduleExpressionTimezone(v string) *RestoreTestingPlanForList {
	s.ScheduleExpressionTimezone = &v
	return s
}

// SetStartWindowHours sets the StartWindowHours field's value.
func (s *RestoreTestingPlanForList) SetStartWindowHours(v int64) *RestoreTestingPlanForList {
	s.StartWindowHours = &v
	return s
}

// This contains metadata about a restore testing plan.
type RestoreTestingPlanForUpdate struct {
	_ struct{} `type:"structure"`

	// Required: Algorithm; RecoveryPointTypes; IncludeVaults (one or more).
	//
	// Optional: SelectionWindowDays ('30' if not specified); ExcludeVaults (defaults
	// to empty list if not listed).
	RecoveryPointSelection *RestoreTestingRecoveryPointSelection `type:"structure"`

	// A CRON expression in specified timezone when a restore testing plan is executed.
	ScheduleExpression *string `type:"string"`

	// Optional. This is the timezone in which the schedule expression is set. By
	// default, ScheduleExpressions are in UTC. You can modify this to a specified
	// timezone.
	ScheduleExpressionTimezone *string `type:"string"`

	// Defaults to 24 hours.
	//
	// A value in hours after a restore test is scheduled before a job will be canceled
	// if it doesn't start successfully. This value is optional. If this value is
	// included, this parameter has a maximum value of 168 hours (one week).
	StartWindowHours *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingPlanForUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingPlanForUpdate) GoString() string {
	return s.String()
}

// SetRecoveryPointSelection sets the RecoveryPointSelection field's value.
func (s *RestoreTestingPlanForUpdate) SetRecoveryPointSelection(v *RestoreTestingRecoveryPointSelection) *RestoreTestingPlanForUpdate {
	s.RecoveryPointSelection = v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *RestoreTestingPlanForUpdate) SetScheduleExpression(v string) *RestoreTestingPlanForUpdate {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleExpressionTimezone sets the ScheduleExpressionTimezone field's value.
func (s *RestoreTestingPlanForUpdate) SetScheduleExpressionTimezone(v string) *RestoreTestingPlanForUpdate {
	s.ScheduleExpressionTimezone = &v
	return s
}

// SetStartWindowHours sets the StartWindowHours field's value.
func (s *RestoreTestingPlanForUpdate) SetStartWindowHours(v int64) *RestoreTestingPlanForUpdate {
	s.StartWindowHours = &v
	return s
}

// Required: Algorithm; Required: Recovery point types; IncludeVaults(one or
// more). Optional: SelectionWindowDays ('30' if not specified);ExcludeVaults
// (list of selectors), defaults to empty list if not listed.
type RestoreTestingRecoveryPointSelection struct {
	_ struct{} `type:"structure"`

	// Acceptable values include "LATEST_WITHIN_WINDOW" or "RANDOM_WITHIN_WINDOW"
	Algorithm *string `type:"string" enum:"RestoreTestingRecoveryPointSelectionAlgorithm"`

	// Accepted values include specific ARNs or list of selectors. Defaults to empty
	// list if not listed.
	ExcludeVaults []*string `type:"list"`

	// Accepted values include wildcard ["*"] or by specific ARNs or ARN wilcard
	// replacement ["arn:aws:backup:us-west-2:123456789012:backup-vault:asdf", ...]
	// ["arn:aws:backup:*:*:backup-vault:asdf-*", ...]
	IncludeVaults []*string `type:"list"`

	// These are the types of recovery points.
	RecoveryPointTypes []*string `type:"list" enum:"RestoreTestingRecoveryPointType"`

	// Accepted values are integers from 1 to 365.
	SelectionWindowDays *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingRecoveryPointSelection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingRecoveryPointSelection) GoString() string {
	return s.String()
}

// SetAlgorithm sets the Algorithm field's value.
func (s *RestoreTestingRecoveryPointSelection) SetAlgorithm(v string) *RestoreTestingRecoveryPointSelection {
	s.Algorithm = &v
	return s
}

// SetExcludeVaults sets the ExcludeVaults field's value.
func (s *RestoreTestingRecoveryPointSelection) SetExcludeVaults(v []*string) *RestoreTestingRecoveryPointSelection {
	s.ExcludeVaults = v
	return s
}

// SetIncludeVaults sets the IncludeVaults field's value.
func (s *RestoreTestingRecoveryPointSelection) SetIncludeVaults(v []*string) *RestoreTestingRecoveryPointSelection {
	s.IncludeVaults = v
	return s
}

// SetRecoveryPointTypes sets the RecoveryPointTypes field's value.
func (s *RestoreTestingRecoveryPointSelection) SetRecoveryPointTypes(v []*string) *RestoreTestingRecoveryPointSelection {
	s.RecoveryPointTypes = v
	return s
}

// SetSelectionWindowDays sets the SelectionWindowDays field's value.
func (s *RestoreTestingRecoveryPointSelection) SetSelectionWindowDays(v int64) *RestoreTestingRecoveryPointSelection {
	s.SelectionWindowDays = &v
	return s
}

// This contains metadata about a specific restore testing selection.
//
// ProtectedResourceType is required, such as Amazon EBS or Amazon EC2.
//
// This consists of RestoreTestingSelectionName, ProtectedResourceType, and
// one of the following:
//
//   - ProtectedResourceArns
//
//   - ProtectedResourceConditions
//
// Each protected resource type can have one single value.
//
// A restore testing selection can include a wildcard value ("*") for ProtectedResourceArns
// along with ProtectedResourceConditions. Alternatively, you can include up
// to 30 specific protected resource ARNs in ProtectedResourceArns.
//
// ProtectedResourceConditions examples include as StringEquals and StringNotEquals.
type RestoreTestingSelectionForCreate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that Backup uses to create
	// the target resource; for example: arn:aws:iam::123456789012:role/S3Access.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`

	// Each protected resource can be filtered by its specific ARNs, such as ProtectedResourceArns:
	// ["arn:aws:...", "arn:aws:..."] or by a wildcard: ProtectedResourceArns: ["*"],
	// but not both.
	ProtectedResourceArns []*string `type:"list"`

	// If you have included the wildcard in ProtectedResourceArns, you can include
	// resource conditions, such as ProtectedResourceConditions: { StringEquals:
	// [{ key: "XXXX", value: "YYYY" }].
	ProtectedResourceConditions *ProtectedResourceConditions `type:"structure"`

	// The type of Amazon Web Services resource included in a restore testing selection;
	// for example, an Amazon EBS volume or an Amazon RDS database.
	//
	// Supported resource types accepted include:
	//
	//    * Aurora for Amazon Aurora
	//
	//    * DocumentDB for Amazon DocumentDB (with MongoDB compatibility)
	//
	//    * DynamoDB for Amazon DynamoDB
	//
	//    * EBS for Amazon Elastic Block Store
	//
	//    * EC2 for Amazon Elastic Compute Cloud
	//
	//    * EFS for Amazon Elastic File System
	//
	//    * FSx for Amazon FSx
	//
	//    * Neptune for Amazon Neptune
	//
	//    * RDS for Amazon Relational Database Service
	//
	//    * S3 for Amazon S3
	//
	// ProtectedResourceType is a required field
	ProtectedResourceType *string `type:"string" required:"true"`

	// You can override certain restore metadata keys by including the parameter
	// RestoreMetadataOverrides in the body of RestoreTestingSelection. Key values
	// are not case sensitive.
	//
	// See the complete list of restore testing inferred metadata (https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html).
	//
	// RestoreMetadataOverrides is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RestoreTestingSelectionForCreate's
	// String and GoString methods.
	RestoreMetadataOverrides map[string]*string `type:"map" sensitive:"true"`

	// This is the unique name of the restore testing selection that belongs to
	// the related restore testing plan.
	//
	// RestoreTestingSelectionName is a required field
	RestoreTestingSelectionName *string `type:"string" required:"true"`

	// This is amount of hours (1 to 168) available to run a validation script on
	// the data. The data will be deleted upon the completion of the validation
	// script or the end of the specified retention period, whichever comes first.
	ValidationWindowHours *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingSelectionForCreate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingSelectionForCreate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTestingSelectionForCreate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreTestingSelectionForCreate"}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.ProtectedResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ProtectedResourceType"))
	}
	if s.RestoreTestingSelectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("RestoreTestingSelectionName"))
	}
	if s.ProtectedResourceConditions != nil {
		if err := s.ProtectedResourceConditions.Validate(); err != nil {
			invalidParams.AddNested("ProtectedResourceConditions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *RestoreTestingSelectionForCreate) SetIamRoleArn(v string) *RestoreTestingSelectionForCreate {
	s.IamRoleArn = &v
	return s
}

// SetProtectedResourceArns sets the ProtectedResourceArns field's value.
func (s *RestoreTestingSelectionForCreate) SetProtectedResourceArns(v []*string) *RestoreTestingSelectionForCreate {
	s.ProtectedResourceArns = v
	return s
}

// SetProtectedResourceConditions sets the ProtectedResourceConditions field's value.
func (s *RestoreTestingSelectionForCreate) SetProtectedResourceConditions(v *ProtectedResourceConditions) *RestoreTestingSelectionForCreate {
	s.ProtectedResourceConditions = v
	return s
}

// SetProtectedResourceType sets the ProtectedResourceType field's value.
func (s *RestoreTestingSelectionForCreate) SetProtectedResourceType(v string) *RestoreTestingSelectionForCreate {
	s.ProtectedResourceType = &v
	return s
}

// SetRestoreMetadataOverrides sets the RestoreMetadataOverrides field's value.
func (s *RestoreTestingSelectionForCreate) SetRestoreMetadataOverrides(v map[string]*string) *RestoreTestingSelectionForCreate {
	s.RestoreMetadataOverrides = v
	return s
}

// SetRestoreTestingSelectionName sets the RestoreTestingSelectionName field's value.
func (s *RestoreTestingSelectionForCreate) SetRestoreTestingSelectionName(v string) *RestoreTestingSelectionForCreate {
	s.RestoreTestingSelectionName = &v
	return s
}

// SetValidationWindowHours sets the ValidationWindowHours field's value.
func (s *RestoreTestingSelectionForCreate) SetValidationWindowHours(v int64) *RestoreTestingSelectionForCreate {
	s.ValidationWindowHours = &v
	return s
}

// This contains metadata about a restore testing selection.
type RestoreTestingSelectionForGet struct {
	_ struct{} `type:"structure"`

	// The date and time that a restore testing selection was created, in Unix format
	// and Coordinated Universal Time (UTC). The value of CreationTime is accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 201812:11:30.087 AM.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// This identifies the request and allows failed requests to be retried without
	// the risk of running the operation twice. If the request includes a CreatorRequestId
	// that matches an existing backup plan, that plan is returned. This parameter
	// is optional.
	//
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that Backup uses to create
	// the target resource; for example:arn:aws:iam::123456789012:role/S3Access.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`

	// You can include specific ARNs, such as ProtectedResourceArns: ["arn:aws:...",
	// "arn:aws:..."] or you can include a wildcard: ProtectedResourceArns: ["*"],
	// but not both.
	ProtectedResourceArns []*string `type:"list"`

	// In a resource testing selection, this parameter filters by specific conditions
	// such as StringEquals or StringNotEquals.
	ProtectedResourceConditions *ProtectedResourceConditions `type:"structure"`

	// The type of Amazon Web Services resource included in a resource testing selection;
	// for example, an Amazon EBS volume or an Amazon RDS database.
	//
	// ProtectedResourceType is a required field
	ProtectedResourceType *string `type:"string" required:"true"`

	// You can override certain restore metadata keys by including the parameter
	// RestoreMetadataOverrides in the body of RestoreTestingSelection. Key values
	// are not case sensitive.
	//
	// See the complete list of restore testing inferred metadata (https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html).
	//
	// RestoreMetadataOverrides is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RestoreTestingSelectionForGet's
	// String and GoString methods.
	RestoreMetadataOverrides map[string]*string `type:"map" sensitive:"true"`

	// The RestoreTestingPlanName is a unique string that is the name of the restore
	// testing plan.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `type:"string" required:"true"`

	// This is the unique name of the restore testing selection that belongs to
	// the related restore testing plan.
	//
	// RestoreTestingSelectionName is a required field
	RestoreTestingSelectionName *string `type:"string" required:"true"`

	// This is amount of hours (1 to 168) available to run a validation script on
	// the data. The data will be deleted upon the completion of the validation
	// script or the end of the specified retention period, whichever comes first.
	ValidationWindowHours *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingSelectionForGet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingSelectionForGet) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *RestoreTestingSelectionForGet) SetCreationTime(v time.Time) *RestoreTestingSelectionForGet {
	s.CreationTime = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *RestoreTestingSelectionForGet) SetCreatorRequestId(v string) *RestoreTestingSelectionForGet {
	s.CreatorRequestId = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *RestoreTestingSelectionForGet) SetIamRoleArn(v string) *RestoreTestingSelectionForGet {
	s.IamRoleArn = &v
	return s
}

// SetProtectedResourceArns sets the ProtectedResourceArns field's value.
func (s *RestoreTestingSelectionForGet) SetProtectedResourceArns(v []*string) *RestoreTestingSelectionForGet {
	s.ProtectedResourceArns = v
	return s
}

// SetProtectedResourceConditions sets the ProtectedResourceConditions field's value.
func (s *RestoreTestingSelectionForGet) SetProtectedResourceConditions(v *ProtectedResourceConditions) *RestoreTestingSelectionForGet {
	s.ProtectedResourceConditions = v
	return s
}

// SetProtectedResourceType sets the ProtectedResourceType field's value.
func (s *RestoreTestingSelectionForGet) SetProtectedResourceType(v string) *RestoreTestingSelectionForGet {
	s.ProtectedResourceType = &v
	return s
}

// SetRestoreMetadataOverrides sets the RestoreMetadataOverrides field's value.
func (s *RestoreTestingSelectionForGet) SetRestoreMetadataOverrides(v map[string]*string) *RestoreTestingSelectionForGet {
	s.RestoreMetadataOverrides = v
	return s
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *RestoreTestingSelectionForGet) SetRestoreTestingPlanName(v string) *RestoreTestingSelectionForGet {
	s.RestoreTestingPlanName = &v
	return s
}

// SetRestoreTestingSelectionName sets the RestoreTestingSelectionName field's value.
func (s *RestoreTestingSelectionForGet) SetRestoreTestingSelectionName(v string) *RestoreTestingSelectionForGet {
	s.RestoreTestingSelectionName = &v
	return s
}

// SetValidationWindowHours sets the ValidationWindowHours field's value.
func (s *RestoreTestingSelectionForGet) SetValidationWindowHours(v int64) *RestoreTestingSelectionForGet {
	s.ValidationWindowHours = &v
	return s
}

// This contains metadata about a restore testing selection.
type RestoreTestingSelectionForList struct {
	_ struct{} `type:"structure"`

	// This is the date and time that a restore testing selection was created, in
	// Unix format and Coordinated Universal Time (UTC). The value of CreationTime
	// is accurate to milliseconds. For example, the value 1516925490.087 represents
	// Friday, January 26,2018 12:11:30.087 AM.
	//
	// CreationTime is a required field
	CreationTime *time.Time `type:"timestamp" required:"true"`

	// The Amazon Resource Name (ARN) of the IAM role that Backup uses to create
	// the target resource; for example: arn:aws:iam::123456789012:role/S3Access.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`

	// The type of Amazon Web Services resource included in a restore testing selection;
	// for example, an Amazon EBS volume or an Amazon RDS database.
	//
	// ProtectedResourceType is a required field
	ProtectedResourceType *string `type:"string" required:"true"`

	// Unique string that is the name of the restore testing plan.
	//
	// The name cannot be changed after creation. The name must consist of only
	// alphanumeric characters and underscores. Maximum length is 50.
	//
	// RestoreTestingPlanName is a required field
	RestoreTestingPlanName *string `type:"string" required:"true"`

	// Unique name of a restore testing selection.
	//
	// RestoreTestingSelectionName is a required field
	RestoreTestingSelectionName *string `type:"string" required:"true"`

	// This value represents the time, in hours, data is retained after a restore
	// test so that optional validation can be completed.
	//
	// Accepted value is an integer between 0 and 168 (the hourly equivalent of
	// seven days).
	ValidationWindowHours *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingSelectionForList) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingSelectionForList) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *RestoreTestingSelectionForList) SetCreationTime(v time.Time) *RestoreTestingSelectionForList {
	s.CreationTime = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *RestoreTestingSelectionForList) SetIamRoleArn(v string) *RestoreTestingSelectionForList {
	s.IamRoleArn = &v
	return s
}

// SetProtectedResourceType sets the ProtectedResourceType field's value.
func (s *RestoreTestingSelectionForList) SetProtectedResourceType(v string) *RestoreTestingSelectionForList {
	s.ProtectedResourceType = &v
	return s
}

// SetRestoreTestingPlanName sets the RestoreTestingPlanName field's value.
func (s *RestoreTestingSelectionForList) SetRestoreTestingPlanName(v string) *RestoreTestingSelectionForList {
	s.RestoreTestingPlanName = &v
	return s
}

// SetRestoreTestingSelectionName sets the RestoreTestingSelectionName field's value.
func (s *RestoreTestingSelectionForList) SetRestoreTestingSelectionName(v string) *RestoreTestingSelectionForList {
	s.RestoreTestingSelectionName = &v
	return s
}

// SetValidationWindowHours sets the ValidationWindowHours field's value.
func (s *RestoreTestingSelectionForList) SetValidationWindowHours(v int64) *RestoreTestingSelectionForList {
	s.ValidationWindowHours = &v
	return s
}

// This contains metadata about a restore testing selection.
type RestoreTestingSelectionForUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role that Backup uses to create
	// the target resource; for example: arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// You can include a list of specific ARNs, such as ProtectedResourceArns: ["arn:aws:...",
	// "arn:aws:..."] or you can include a wildcard: ProtectedResourceArns: ["*"],
	// but not both.
	ProtectedResourceArns []*string `type:"list"`

	// A list of conditions that you define for resources in your restore testing
	// plan using tags.
	//
	// For example, "StringEquals": { "Key": "aws:ResourceTag/CreatedByCryo", "Value":
	// "true" },. Condition operators are case sensitive.
	ProtectedResourceConditions *ProtectedResourceConditions `type:"structure"`

	// You can override certain restore metadata keys by including the parameter
	// RestoreMetadataOverrides in the body of RestoreTestingSelection. Key values
	// are not case sensitive.
	//
	// See the complete list of restore testing inferred metadata (https://docs.aws.amazon.com/aws-backup/latest/devguide/restore-testing-inferred-metadata.html).
	//
	// RestoreMetadataOverrides is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RestoreTestingSelectionForUpdate's
	// String and GoString methods.
	RestoreMetadataOverrides map[string]*string `type:"map" sensitive:"true"`

	// This value represents the time, in hours, data is retained after a restore
	// test so that optional validation can be completed.
	//
	// Accepted value is an integer between 0 and 168 (the hourly equivalent of
	// seven days).
	ValidationWindowHours *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingSelectionForUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTestingSelectionForUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTestingSelectionForUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreTestingSelectionForUpdate"}
	if s.ProtectedResourceConditions != nil {
		if err := s.ProtectedResourceConditions.Validate(); err != nil {
			invalidParams.AddNested("ProtectedResourceConditions", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *RestoreTestingSelectionForUpdate) SetIamRoleArn(v string) *RestoreTestingSelectionForUpdate {
	s.IamRoleArn = &v
	return s
}

// SetProtectedResourceArns sets the ProtectedResourceArns field's value.
func (s *RestoreTestingSelectionForUpdate) SetProtectedResourceArns(v []*string) *RestoreTestingSelectionForUpdate {
	s.ProtectedResourceArns = v
	return s
}

// SetProtectedResourceConditions sets the ProtectedResourceConditions field's value.
func (s *RestoreTestingSelectionForUpdate) SetProtectedResourceConditions(v *ProtectedResourceConditions) *RestoreTestingSelectionForUpdate {
	s.ProtectedResourceConditions = v
	return s
}

// SetRestoreMetadataOverrides sets the RestoreMetadataOverrides field's value.
func (s *RestoreTestingSelectionForUpdate) SetRestoreMetadataOverrides(v map[string]*string) *RestoreTestingSelectionForUpdate {
	s.RestoreMetadataOverrides = v
	return s
}

// SetValidationWindowHours sets the ValidationWindowHours field's value.
func (s *RestoreTestingSelectionForUpdate) SetValidationWindowHours(v int64) *RestoreTestingSelectionForUpdate {
	s.ValidationWindowHours = &v
	return s
}

// Specifies a scheduled task used to back up a selection of resources.
type Rule struct {
	_ struct{} `type:"structure"`

	// A value in minutes after a backup job is successfully started before it must
	// be completed or it will be canceled by Backup. This value is optional.
	CompletionWindowMinutes *int64 `type:"long"`

	// An array of CopyAction objects, which contains the details of the copy operation.
	CopyActions []*CopyAction `type:"list"`

	// Specifies whether Backup creates continuous backups. True causes Backup to
	// create continuous backups capable of point-in-time restore (PITR). False
	// (or not specified) causes Backup to create snapshot backups.
	EnableContinuousBackup *bool `type:"boolean"`

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup transitions and expires backups automatically
	// according to the lifecycle that you define.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, the “retention” setting must be 90 days
	// greater than the “transition to cold after days” setting. The “transition
	// to cold after days” setting cannot be changed after a backup has been transitioned
	// to cold.
	//
	// Resource types that are able to be transitioned to cold storage are listed
	// in the "Lifecycle to cold storage" section of the Feature availability by
	// resource (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
	// table. Backup ignores this expression for other resource types.
	Lifecycle *Lifecycle `type:"structure"`

	// An array of key-value pair strings that are assigned to resources that are
	// associated with this rule when restored from backup.
	//
	// RecoveryPointTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Rule's
	// String and GoString methods.
	RecoveryPointTags map[string]*string `type:"map" sensitive:"true"`

	// Uniquely identifies a rule that is used to schedule the backup of a selection
	// of resources.
	RuleId *string `type:"string"`

	// A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.'
	// characters.
	//
	// RuleName is a required field
	RuleName *string `type:"string" required:"true"`

	// A cron expression in UTC specifying when Backup initiates a backup job. For
	// more information about Amazon Web Services cron expressions, see Schedule
	// Expressions for Rules (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html)
	// in the Amazon CloudWatch Events User Guide.. Two examples of Amazon Web Services
	// cron expressions are 15 * ? * * * (take a backup every hour at 15 minutes
	// past the hour) and 0 12 * * ? * (take a backup every day at 12 noon UTC).
	// For a table of examples, click the preceding link and scroll down the page.
	ScheduleExpression *string `type:"string"`

	// This is the timezone in which the schedule expression is set. By default,
	// ScheduleExpressions are in UTC. You can modify this to a specified timezone.
	ScheduleExpressionTimezone *string `type:"string"`

	// A value in minutes after a backup is scheduled before a job will be canceled
	// if it doesn't start successfully. This value is optional. If this value is
	// included, it must be at least 60 minutes to avoid errors.
	//
	// During the start window, the backup job status remains in CREATED status
	// until it has successfully begun or until the start window time has run out.
	// If within the start window time Backup receives an error that allows the
	// job to be retried, Backup will automatically retry to begin the job at least
	// every 10 minutes until the backup successfully begins (the job status changes
	// to RUNNING) or until the job status changes to EXPIRED (which is expected
	// to occur when the start window time is over).
	StartWindowMinutes *int64 `type:"long"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// TargetBackupVaultName is a required field
	TargetBackupVaultName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Rule) GoString() string {
	return s.String()
}

// SetCompletionWindowMinutes sets the CompletionWindowMinutes field's value.
func (s *Rule) SetCompletionWindowMinutes(v int64) *Rule {
	s.CompletionWindowMinutes = &v
	return s
}

// SetCopyActions sets the CopyActions field's value.
func (s *Rule) SetCopyActions(v []*CopyAction) *Rule {
	s.CopyActions = v
	return s
}

// SetEnableContinuousBackup sets the EnableContinuousBackup field's value.
func (s *Rule) SetEnableContinuousBackup(v bool) *Rule {
	s.EnableContinuousBackup = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *Rule) SetLifecycle(v *Lifecycle) *Rule {
	s.Lifecycle = v
	return s
}

// SetRecoveryPointTags sets the RecoveryPointTags field's value.
func (s *Rule) SetRecoveryPointTags(v map[string]*string) *Rule {
	s.RecoveryPointTags = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *Rule) SetRuleId(v string) *Rule {
	s.RuleId = &v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *Rule) SetRuleName(v string) *Rule {
	s.RuleName = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *Rule) SetScheduleExpression(v string) *Rule {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleExpressionTimezone sets the ScheduleExpressionTimezone field's value.
func (s *Rule) SetScheduleExpressionTimezone(v string) *Rule {
	s.ScheduleExpressionTimezone = &v
	return s
}

// SetStartWindowMinutes sets the StartWindowMinutes field's value.
func (s *Rule) SetStartWindowMinutes(v int64) *Rule {
	s.StartWindowMinutes = &v
	return s
}

// SetTargetBackupVaultName sets the TargetBackupVaultName field's value.
func (s *Rule) SetTargetBackupVaultName(v string) *Rule {
	s.TargetBackupVaultName = &v
	return s
}

// Specifies a scheduled task used to back up a selection of resources.
type RuleInput struct {
	_ struct{} `type:"structure"`

	// A value in minutes after a backup job is successfully started before it must
	// be completed or it will be canceled by Backup. This value is optional.
	CompletionWindowMinutes *int64 `type:"long"`

	// An array of CopyAction objects, which contains the details of the copy operation.
	CopyActions []*CopyAction `type:"list"`

	// Specifies whether Backup creates continuous backups. True causes Backup to
	// create continuous backups capable of point-in-time restore (PITR). False
	// (or not specified) causes Backup to create snapshot backups.
	EnableContinuousBackup *bool `type:"boolean"`

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup will transition and expire backups automatically
	// according to the lifecycle that you define.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, the “retention” setting must be 90 days
	// greater than the “transition to cold after days” setting. The “transition
	// to cold after days” setting cannot be changed after a backup has been transitioned
	// to cold.
	//
	// Resource types that are able to be transitioned to cold storage are listed
	// in the "Lifecycle to cold storage" section of the Feature availability by
	// resource (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
	// table. Backup ignores this expression for other resource types.
	//
	// This parameter has a maximum value of 100 years (36,500 days).
	Lifecycle *Lifecycle `type:"structure"`

	// To help organize your resources, you can assign your own metadata to the
	// resources that you create. Each tag is a key-value pair.
	//
	// RecoveryPointTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RuleInput's
	// String and GoString methods.
	RecoveryPointTags map[string]*string `type:"map" sensitive:"true"`

	// A display name for a backup rule. Must contain 1 to 50 alphanumeric or '-_.'
	// characters.
	//
	// RuleName is a required field
	RuleName *string `type:"string" required:"true"`

	// A CRON expression in UTC specifying when Backup initiates a backup job.
	ScheduleExpression *string `type:"string"`

	// This is the timezone in which the schedule expression is set. By default,
	// ScheduleExpressions are in UTC. You can modify this to a specified timezone.
	ScheduleExpressionTimezone *string `type:"string"`

	// A value in minutes after a backup is scheduled before a job will be canceled
	// if it doesn't start successfully. This value is optional. If this value is
	// included, it must be at least 60 minutes to avoid errors.
	//
	// This parameter has a maximum value of 100 years (52,560,000 minutes).
	//
	// During the start window, the backup job status remains in CREATED status
	// until it has successfully begun or until the start window time has run out.
	// If within the start window time Backup receives an error that allows the
	// job to be retried, Backup will automatically retry to begin the job at least
	// every 10 minutes until the backup successfully begins (the job status changes
	// to RUNNING) or until the job status changes to EXPIRED (which is expected
	// to occur when the start window time is over).
	StartWindowMinutes *int64 `type:"long"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// TargetBackupVaultName is a required field
	TargetBackupVaultName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleInput"}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.TargetBackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetBackupVaultName"))
	}
	if s.CopyActions != nil {
		for i, v := range s.CopyActions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CopyActions", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompletionWindowMinutes sets the CompletionWindowMinutes field's value.
func (s *RuleInput) SetCompletionWindowMinutes(v int64) *RuleInput {
	s.CompletionWindowMinutes = &v
	return s
}

// SetCopyActions sets the CopyActions field's value.
func (s *RuleInput) SetCopyActions(v []*CopyAction) *RuleInput {
	s.CopyActions = v
	return s
}

// SetEnableContinuousBackup sets the EnableContinuousBackup field's value.
func (s *RuleInput) SetEnableContinuousBackup(v bool) *RuleInput {
	s.EnableContinuousBackup = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *RuleInput) SetLifecycle(v *Lifecycle) *RuleInput {
	s.Lifecycle = v
	return s
}

// SetRecoveryPointTags sets the RecoveryPointTags field's value.
func (s *RuleInput) SetRecoveryPointTags(v map[string]*string) *RuleInput {
	s.RecoveryPointTags = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *RuleInput) SetRuleName(v string) *RuleInput {
	s.RuleName = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *RuleInput) SetScheduleExpression(v string) *RuleInput {
	s.ScheduleExpression = &v
	return s
}

// SetScheduleExpressionTimezone sets the ScheduleExpressionTimezone field's value.
func (s *RuleInput) SetScheduleExpressionTimezone(v string) *RuleInput {
	s.ScheduleExpressionTimezone = &v
	return s
}

// SetStartWindowMinutes sets the StartWindowMinutes field's value.
func (s *RuleInput) SetStartWindowMinutes(v int64) *RuleInput {
	s.StartWindowMinutes = &v
	return s
}

// SetTargetBackupVaultName sets the TargetBackupVaultName field's value.
func (s *RuleInput) SetTargetBackupVaultName(v string) *RuleInput {
	s.TargetBackupVaultName = &v
	return s
}

// Used to specify a set of resources to a backup plan.
//
// Specifying your desired Conditions, ListOfTags, NotResources, and/or Resources
// is recommended. If none of these are specified, Backup will attempt to select
// all supported and opted-in storage resources, which could have unintended
// cost implications.
type Selection struct {
	_ struct{} `type:"structure"`

	// A list of conditions that you define to assign resources to your backup plans
	// using tags. For example, "StringEquals": { "Key": "aws:ResourceTag/CreatedByCryo",
	// "Value": "true" },. Condition operators are case sensitive.
	//
	// Conditions differs from ListOfTags as follows:
	//
	//    * When you specify more than one condition, you only assign the resources
	//    that match ALL conditions (using AND logic).
	//
	//    * Conditions supports StringEquals, StringLike, StringNotEquals, and StringNotLike.
	//    ListOfTags only supports StringEquals.
	Conditions *Conditions `type:"structure"`

	// The ARN of the IAM role that Backup uses to authenticate when backing up
	// the target resource; for example, arn:aws:iam::123456789012:role/S3Access.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`

	// A list of conditions that you define to assign resources to your backup plans
	// using tags. For example, "StringEquals": { "Key": "aws:ResourceTag/CreatedByCryo",
	// "Value": "true" },. Condition operators are case sensitive.
	//
	// ListOfTags differs from Conditions as follows:
	//
	//    * When you specify more than one condition, you assign all resources that
	//    match AT LEAST ONE condition (using OR logic).
	//
	//    * ListOfTags only supports StringEquals. Conditions supports StringEquals,
	//    StringLike, StringNotEquals, and StringNotLike.
	ListOfTags []*Condition `type:"list"`

	// A list of Amazon Resource Names (ARNs) to exclude from a backup plan. The
	// maximum number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.
	//
	// If you need to exclude many resources from a backup plan, consider a different
	// resource selection strategy, such as assigning only one or a few resource
	// types or refining your resource selection using tags.
	NotResources []*string `type:"list"`

	// A list of Amazon Resource Names (ARNs) to assign to a backup plan. The maximum
	// number of ARNs is 500 without wildcards, or 30 ARNs with wildcards.
	//
	// If you need to assign many resources to a backup plan, consider a different
	// resource selection strategy, such as assigning all resources of a resource
	// type or refining your resource selection using tags.
	Resources []*string `type:"list"`

	// The display name of a resource selection document. Must contain 1 to 50 alphanumeric
	// or '-_.' characters.
	//
	// SelectionName is a required field
	SelectionName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Selection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Selection) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Selection) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Selection"}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.SelectionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SelectionName"))
	}
	if s.ListOfTags != nil {
		for i, v := range s.ListOfTags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ListOfTags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConditions sets the Conditions field's value.
func (s *Selection) SetConditions(v *Conditions) *Selection {
	s.Conditions = v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *Selection) SetIamRoleArn(v string) *Selection {
	s.IamRoleArn = &v
	return s
}

// SetListOfTags sets the ListOfTags field's value.
func (s *Selection) SetListOfTags(v []*Condition) *Selection {
	s.ListOfTags = v
	return s
}

// SetNotResources sets the NotResources field's value.
func (s *Selection) SetNotResources(v []*string) *Selection {
	s.NotResources = v
	return s
}

// SetResources sets the Resources field's value.
func (s *Selection) SetResources(v []*string) *Selection {
	s.Resources = v
	return s
}

// SetSelectionName sets the SelectionName field's value.
func (s *Selection) SetSelectionName(v string) *Selection {
	s.SelectionName = &v
	return s
}

// Contains metadata about a BackupSelection object.
type SelectionsListMember struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// The date and time a backup plan is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// A unique string that identifies the request and allows failed requests to
	// be retried without the risk of running the operation twice. This parameter
	// is optional.
	//
	// If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
	CreatorRequestId *string `type:"string"`

	// Specifies the IAM role Amazon Resource Name (ARN) to create the target recovery
	// point; for example, arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// Uniquely identifies a request to assign a set of resources to a backup plan.
	SelectionId *string `type:"string"`

	// The display name of a resource selection document.
	SelectionName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelectionsListMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelectionsListMember) GoString() string {
	return s.String()
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *SelectionsListMember) SetBackupPlanId(v string) *SelectionsListMember {
	s.BackupPlanId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *SelectionsListMember) SetCreationDate(v time.Time) *SelectionsListMember {
	s.CreationDate = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *SelectionsListMember) SetCreatorRequestId(v string) *SelectionsListMember {
	s.CreatorRequestId = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *SelectionsListMember) SetIamRoleArn(v string) *SelectionsListMember {
	s.IamRoleArn = &v
	return s
}

// SetSelectionId sets the SelectionId field's value.
func (s *SelectionsListMember) SetSelectionId(v string) *SelectionsListMember {
	s.SelectionId = &v
	return s
}

// SetSelectionName sets the SelectionName field's value.
func (s *SelectionsListMember) SetSelectionName(v string) *SelectionsListMember {
	s.SelectionName = &v
	return s
}

// The request failed due to a temporary failure of the server.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"Code" type:"string"`

	Context *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	Type *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartBackupJobInput struct {
	_ struct{} `type:"structure"`

	// Specifies the backup option for a selected resource. This option is only
	// available for Windows Volume Shadow Copy Service (VSS) backup jobs.
	//
	// Valid values: Set to "WindowsVSS":"enabled" to enable the WindowsVSS backup
	// option and create a Windows VSS backup. Set to "WindowsVSS""disabled" to
	// create a regular backup. The WindowsVSS option is not enabled by default.
	BackupOptions map[string]*string `type:"map"`

	// The name of a logical container where backups are stored. Backup vaults are
	// identified by names that are unique to the account used to create them and
	// the Amazon Web Services Region where they are created. They consist of lowercase
	// letters, numbers, and hyphens.
	//
	// BackupVaultName is a required field
	BackupVaultName *string `type:"string" required:"true"`

	// A value in minutes during which a successfully started backup must complete,
	// or else Backup will cancel the job. This value is optional. This value begins
	// counting down from when the backup was scheduled. It does not add additional
	// time for StartWindowMinutes, or if the backup started later than scheduled.
	//
	// Like StartWindowMinutes, this parameter has a maximum value of 100 years
	// (52,560,000 minutes).
	CompleteWindowMinutes *int64 `type:"long"`

	// Specifies the IAM role ARN used to create the target recovery point; for
	// example, arn:aws:iam::123456789012:role/S3Access.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`

	// A customer-chosen string that you can use to distinguish between otherwise
	// identical calls to StartBackupJob. Retrying a successful request with the
	// same idempotency token results in a success message with no action taken.
	IdempotencyToken *string `type:"string"`

	// The lifecycle defines when a protected resource is transitioned to cold storage
	// and when it expires. Backup will transition and expire backups automatically
	// according to the lifecycle that you define.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, the “retention” setting must be 90 days
	// greater than the “transition to cold after days” setting. The “transition
	// to cold after days” setting cannot be changed after a backup has been transitioned
	// to cold.
	//
	// Resource types that are able to be transitioned to cold storage are listed
	// in the "Lifecycle to cold storage" section of the Feature availability by
	// resource (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
	// table. Backup ignores this expression for other resource types.
	//
	// This parameter has a maximum value of 100 years (36,500 days).
	Lifecycle *Lifecycle `type:"structure"`

	// To help organize your resources, you can assign your own metadata to the
	// resources that you create. Each tag is a key-value pair.
	//
	// RecoveryPointTags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartBackupJobInput's
	// String and GoString methods.
	RecoveryPointTags map[string]*string `type:"map" sensitive:"true"`

	// An Amazon Resource Name (ARN) that uniquely identifies a resource. The format
	// of the ARN depends on the resource type.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// A value in minutes after a backup is scheduled before a job will be canceled
	// if it doesn't start successfully. This value is optional, and the default
	// is 8 hours. If this value is included, it must be at least 60 minutes to
	// avoid errors.
	//
	// This parameter has a maximum value of 100 years (52,560,000 minutes).
	//
	// During the start window, the backup job status remains in CREATED status
	// until it has successfully begun or until the start window time has run out.
	// If within the start window time Backup receives an error that allows the
	// job to be retried, Backup will automatically retry to begin the job at least
	// every 10 minutes until the backup successfully begins (the job status changes
	// to RUNNING) or until the job status changes to EXPIRED (which is expected
	// to occur when the start window time is over).
	StartWindowMinutes *int64 `type:"long"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartBackupJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartBackupJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartBackupJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartBackupJobInput"}
	if s.BackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupVaultName"))
	}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupOptions sets the BackupOptions field's value.
func (s *StartBackupJobInput) SetBackupOptions(v map[string]*string) *StartBackupJobInput {
	s.BackupOptions = v
	return s
}

// SetBackupVaultName sets the BackupVaultName field's value.
func (s *StartBackupJobInput) SetBackupVaultName(v string) *StartBackupJobInput {
	s.BackupVaultName = &v
	return s
}

// SetCompleteWindowMinutes sets the CompleteWindowMinutes field's value.
func (s *StartBackupJobInput) SetCompleteWindowMinutes(v int64) *StartBackupJobInput {
	s.CompleteWindowMinutes = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *StartBackupJobInput) SetIamRoleArn(v string) *StartBackupJobInput {
	s.IamRoleArn = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *StartBackupJobInput) SetIdempotencyToken(v string) *StartBackupJobInput {
	s.IdempotencyToken = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *StartBackupJobInput) SetLifecycle(v *Lifecycle) *StartBackupJobInput {
	s.Lifecycle = v
	return s
}

// SetRecoveryPointTags sets the RecoveryPointTags field's value.
func (s *StartBackupJobInput) SetRecoveryPointTags(v map[string]*string) *StartBackupJobInput {
	s.RecoveryPointTags = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *StartBackupJobInput) SetResourceArn(v string) *StartBackupJobInput {
	s.ResourceArn = &v
	return s
}

// SetStartWindowMinutes sets the StartWindowMinutes field's value.
func (s *StartBackupJobInput) SetStartWindowMinutes(v int64) *StartBackupJobInput {
	s.StartWindowMinutes = &v
	return s
}

type StartBackupJobOutput struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a request to Backup to back up a resource.
	BackupJobId *string `type:"string"`

	// The date and time that a backup job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// This is a returned boolean value indicating this is a parent (composite)
	// backup job.
	IsParent *bool `type:"boolean"`

	// Note: This field is only returned for Amazon EFS and Advanced DynamoDB resources.
	//
	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	RecoveryPointArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartBackupJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartBackupJobOutput) GoString() string {
	return s.String()
}

// SetBackupJobId sets the BackupJobId field's value.
func (s *StartBackupJobOutput) SetBackupJobId(v string) *StartBackupJobOutput {
	s.BackupJobId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *StartBackupJobOutput) SetCreationDate(v time.Time) *StartBackupJobOutput {
	s.CreationDate = &v
	return s
}

// SetIsParent sets the IsParent field's value.
func (s *StartBackupJobOutput) SetIsParent(v bool) *StartBackupJobOutput {
	s.IsParent = &v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *StartBackupJobOutput) SetRecoveryPointArn(v string) *StartBackupJobOutput {
	s.RecoveryPointArn = &v
	return s
}

type StartCopyJobInput struct {
	_ struct{} `type:"structure"`

	// An Amazon Resource Name (ARN) that uniquely identifies a destination backup
	// vault to copy to; for example, arn:aws:backup:us-east-1:123456789012:vault:aBackupVault.
	//
	// DestinationBackupVaultArn is a required field
	DestinationBackupVaultArn *string `type:"string" required:"true"`

	// Specifies the IAM role ARN used to copy the target recovery point; for example,
	// arn:aws:iam::123456789012:role/S3Access.
	//
	// IamRoleArn is a required field
	IamRoleArn *string `type:"string" required:"true"`

	// A customer-chosen string that you can use to distinguish between otherwise
	// identical calls to StartCopyJob. Retrying a successful request with the same
	// idempotency token results in a success message with no action taken.
	IdempotencyToken *string `type:"string"`

	// Contains an array of Transition objects specifying how long in days before
	// a recovery point transitions to cold storage or is deleted.
	//
	// Backups transitioned to cold storage must be stored in cold storage for a
	// minimum of 90 days. Therefore, on the console, the “retention” setting
	// must be 90 days greater than the “transition to cold after days” setting.
	// The “transition to cold after days” setting cannot be changed after a
	// backup has been transitioned to cold.
	//
	// Resource types that are able to be transitioned to cold storage are listed
	// in the "Lifecycle to cold storage" section of the Feature availability by
	// resource (https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource)
	// table. Backup ignores this expression for other resource types.
	Lifecycle *Lifecycle `type:"structure"`

	// An ARN that uniquely identifies a recovery point to use for the copy job;
	// for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `type:"string" required:"true"`

	// The name of a logical source container where backups are stored. Backup vaults
	// are identified by names that are unique to the account used to create them
	// and the Amazon Web Services Region where they are created. They consist of
	// lowercase letters, numbers, and hyphens.
	//
	// SourceBackupVaultName is a required field
	SourceBackupVaultName *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCopyJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCopyJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCopyJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartCopyJobInput"}
	if s.DestinationBackupVaultArn == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationBackupVaultArn"))
	}
	if s.IamRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRoleArn"))
	}
	if s.RecoveryPointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointArn"))
	}
	if s.SourceBackupVaultName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceBackupVaultName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationBackupVaultArn sets the DestinationBackupVaultArn field's value.
func (s *StartCopyJobInput) SetDestinationBackupVaultArn(v string) *StartCopyJobInput {
	s.DestinationBackupVaultArn = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *StartCopyJobInput) SetIamRoleArn(v string) *StartCopyJobInput {
	s.IamRoleArn = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *StartCopyJobInput) SetIdempotencyToken(v string) *StartCopyJobInput {
	s.IdempotencyToken = &v
	return s
}

// SetLifecycle sets the Lifecycle field's value.
func (s *StartCopyJobInput) SetLifecycle(v *Lifecycle) *StartCopyJobInput {
	s.Lifecycle = v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *StartCopyJobInput) SetRecoveryPointArn(v string) *StartCopyJobInput {
	s.RecoveryPointArn = &v
	return s
}

// SetSourceBackupVaultName sets the SourceBackupVaultName field's value.
func (s *StartCopyJobInput) SetSourceBackupVaultName(v string) *StartCopyJobInput {
	s.SourceBackupVaultName = &v
	return s
}

type StartCopyJobOutput struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies a copy job.
	CopyJobId *string `type:"string"`

	// The date and time that a copy job is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreationDate *time.Time `type:"timestamp"`

	// This is a returned boolean value indicating this is a parent (composite)
	// copy job.
	IsParent *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCopyJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartCopyJobOutput) GoString() string {
	return s.String()
}

// SetCopyJobId sets the CopyJobId field's value.
func (s *StartCopyJobOutput) SetCopyJobId(v string) *StartCopyJobOutput {
	s.CopyJobId = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *StartCopyJobOutput) SetCreationDate(v time.Time) *StartCopyJobOutput {
	s.CreationDate = &v
	return s
}

// SetIsParent sets the IsParent field's value.
func (s *StartCopyJobOutput) SetIsParent(v bool) *StartCopyJobOutput {
	s.IsParent = &v
	return s
}

type StartReportJobInput struct {
	_ struct{} `type:"structure"`

	// A customer-chosen string that you can use to distinguish between otherwise
	// identical calls to StartReportJobInput. Retrying a successful request with
	// the same idempotency token results in a success message with no action taken.
	IdempotencyToken *string `type:"string" idempotencyToken:"true"`

	// The unique name of a report plan.
	//
	// ReportPlanName is a required field
	ReportPlanName *string `location:"uri" locationName:"reportPlanName" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReportJobInput"}
	if s.ReportPlanName == nil {
		invalidParams.Add(request.NewErrParamRequired("ReportPlanName"))
	}
	if s.ReportPlanName != nil && len(*s.ReportPlanName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ReportPlanName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *StartReportJobInput) SetIdempotencyToken(v string) *StartReportJobInput {
	s.IdempotencyToken = &v
	return s
}

// SetReportPlanName sets the ReportPlanName field's value.
func (s *StartReportJobInput) SetReportPlanName(v string) *StartReportJobInput {
	s.ReportPlanName = &v
	return s
}

type StartReportJobOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the report job. A unique, randomly generated, Unicode,
	// UTF-8 encoded string that is at most 1,024 bytes long. The report job ID
	// cannot be edited.
	ReportJobId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartReportJobOutput) GoString() string {
	return s.String()
}

// SetReportJobId sets the ReportJobId field's value.
func (s *StartReportJobOutput) SetReportJobId(v string) *StartReportJobOutput {
	s.ReportJobId = &v
	return s
}

type StartRestoreJobInput struct {
	_ struct{} `type:"structure"`

	// This is an optional parameter. If this equals True, tags included in the
	// backup will be copied to the restored resource.
	//
	// This can only be applied to backups created through Backup.
	CopySourceTagsToRestoredResource *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the IAM role that Backup uses to create
	// the target resource; for example: arn:aws:iam::123456789012:role/S3Access.
	IamRoleArn *string `type:"string"`

	// A customer-chosen string that you can use to distinguish between otherwise
	// identical calls to StartRestoreJob. Retrying a successful request with the
	// same idempotency token results in a success message with no action taken.
	IdempotencyToken *string `type:"string"`

	// A set of metadata key-value pairs. Contains information, such as a resource
	// name, required to restore a recovery point.
	//
	// You can get configuration metadata about a resource at the time it was backed
	// up by calling GetRecoveryPointRestoreMetadata. However, values in addition
	// to those provided by GetRecoveryPointRestoreMetadata might be required to
	// restore a resource. For example, you might need to provide a new resource
	// name if the original already exists.
	//
	// You need to specify specific metadata to restore an Amazon Elastic File System
	// (Amazon EFS) instance:
	//
	//    * file-system-id: The ID of the Amazon EFS file system that is backed
	//    up by Backup. Returned in GetRecoveryPointRestoreMetadata.
	//
	//    * Encrypted: A Boolean value that, if true, specifies that the file system
	//    is encrypted. If KmsKeyId is specified, Encrypted must be set to true.
	//
	//    * KmsKeyId: Specifies the Amazon Web Services KMS key that is used to
	//    encrypt the restored file system. You can specify a key from another Amazon
	//    Web Services account provided that key it is properly shared with your
	//    account via Amazon Web Services KMS.
	//
	//    * PerformanceMode: Specifies the throughput mode of the file system.
	//
	//    * CreationToken: A user-supplied value that ensures the uniqueness (idempotency)
	//    of the request.
	//
	//    * newFileSystem: A Boolean value that, if true, specifies that the recovery
	//    point is restored to a new Amazon EFS file system.
	//
	//    * ItemsToRestore: An array of one to five strings where each string is
	//    a file path. Use ItemsToRestore to restore specific files or directories
	//    rather than the entire file system. This parameter is optional. For example,
	//    "itemsToRestore":"[\"/my.test\"]".
	//
	// Metadata is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by StartRestoreJobInput's
	// String and GoString methods.
	//
	// Metadata is a required field
	Metadata map[string]*string `type:"map" required:"true" sensitive:"true"`

	// An ARN that uniquely identifies a recovery point; for example, arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45.
	//
	// RecoveryPointArn is a required field
	RecoveryPointArn *string `type:"string" required:"true"`

	// Starts a job to restore a recovery point for one of the following resources:
	//
	//    * Aurora for Amazon Aurora
	//
	//    * DocumentDB for Amazon DocumentDB (with MongoDB compatibility)
	//
	//    * CloudFormation for CloudFormation
	//
	//    * DynamoDB for Amazon DynamoDB
	//
	//    * EBS for Amazon Elastic Block Store
	//
	//    * EC2 for Amazon Elastic Compute Cloud
	//
	//    * EFS for Amazon Elastic File System
	//
	//    * FSx for Amazon FSx
	//
	//    * Neptune for Amazon Neptune
	//
	//    * RDS for Amazon Relational Database Service
	//
	//    * Redshift for Amazon Redshift
	//
	//    * Storage Gateway for Storage Gateway
	//
	//    * S3 for Amazon S3
	//
	//    * Timestream for Amazon Timestream
	//
	//    * VirtualMachine for virtual machines
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRestoreJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRestoreJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartRestoreJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartRestoreJobInput"}
	if s.Metadata == nil {
		invalidParams.Add(request.NewErrParamRequired("Metadata"))
	}
	if s.RecoveryPointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopySourceTagsToRestoredResource sets the CopySourceTagsToRestoredResource field's value.
func (s *StartRestoreJobInput) SetCopySourceTagsToRestoredResource(v bool) *StartRestoreJobInput {
	s.CopySourceTagsToRestoredResource = &v
	return s
}

// SetIamRoleArn sets the IamRoleArn field's value.
func (s *StartRestoreJobInput) SetIamRoleArn(v string) *StartRestoreJobInput {
	s.IamRoleArn = &v
	return s
}

// SetIdempotencyToken sets the IdempotencyToken field's value.
func (s *StartRestoreJobInput) SetIdempotencyToken(v string) *StartRestoreJobInput {
	s.IdempotencyToken = &v
	return s
}

// SetMetadata sets the Metadata field's value.
func (s *StartRestoreJobInput) SetMetadata(v map[string]*string) *StartRestoreJobInput {
	s.Metadata = v
	return s
}

// SetRecoveryPointArn sets the RecoveryPointArn field's value.
func (s *StartRestoreJobInput) SetRecoveryPointArn(v string) *StartRestoreJobInput {
	s.RecoveryPointArn = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *StartRestoreJobInput) SetResourceType(v string) *StartRestoreJobInput {
	s.ResourceType = &v
	return s
}

type StartRestoreJobOutput struct {
	_ struct{} `type:"structure"`

	// Uniquely identifies the job that restores a recovery point.
	RestoreJobId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRestoreJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRestoreJobOutput) GoString() string {
	return s.String()
}

// SetRestoreJobId sets the RestoreJobId field's value.
func (s *StartRestoreJobOutput) SetRestoreJobId(v string) *StartRestoreJobOutput {
	s.RestoreJobId = &v
	return s
}

type StopBackupJobInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// Uniquely identifies a request to Backup to back up a resource.
	//
	// BackupJobId is a required field
	BackupJobId *string `location:"uri" locationName:"backupJobId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopBackupJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopBackupJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopBackupJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopBackupJobInput"}
	if s.BackupJobId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupJobId"))
	}
	if s.BackupJobId != nil && len(*s.BackupJobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupJobId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupJobId sets the BackupJobId field's value.
func (s *StopBackupJobInput) SetBackupJobId(v string) *StopBackupJobInput {
	s.BackupJobId = &v
	return s
}

type StopBackupJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopBackupJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopBackupJobOutput) GoString() string {
	return s.String()
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// An ARN that uniquely identifies a resource. The format of the ARN depends
	// on the type of the tagged resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// Key-value pairs that are used to help organize your resources. You can assign
	// your own metadata to the resources you create. For clarity, this is the structure
	// to assign tags: [{"Key":"string","Value":"string"}].
	//
	// Tags is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by TagResourceInput's
	// String and GoString methods.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// An ARN that uniquely identifies a resource. The format of the ARN depends
	// on the type of the tagged resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// A list of keys to identify which key-value tags to remove from a resource.
	//
	// TagKeyList is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UntagResourceInput's
	// String and GoString methods.
	//
	// TagKeyList is a required field
	TagKeyList []*string `type:"list" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeyList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeyList"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeyList sets the TagKeyList field's value.
func (s *UntagResourceInput) SetTagKeyList(v []*string) *UntagResourceInput {
	s.TagKeyList = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateBackupPlanInput struct {
	_ struct{} `type:"structure"`

	// Specifies the body of a backup plan. Includes a BackupPlanName and one or
	// more sets of Rules.
	//
	// BackupPlan is a required field
	BackupPlan *PlanInput `type:"structure" required:"true"`

	// Uniquely identifies a backup plan.
	//
	// BackupPlanId is a required field
	BackupPlanId *string `location:"uri" locationName:"backupPlanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackupPlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBackupPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBackupPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBackupPlanInput"}
	if s.BackupPlan == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlan"))
	}
	if s.BackupPlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupPlanId"))
	}
	if s.BackupPlanId != nil && len(*s.BackupPlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BackupPlanId", 1))
	}
	if s.BackupPlan != nil {
		if err := s.BackupPlan.Validate(); err != nil {
			invalidParams.AddNested("BackupPlan", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupPlan sets the BackupPlan field's value.
func (s *UpdateBackupPlanInput) SetBackupPlan(v *PlanInput) *UpdateBackupPlanInput {
	s.BackupPlan = v
	return s
}

// SetBackupPlanId sets the BackupPlanId field's value.
func (s *UpdateBackupPlanInput) SetBackupPlanId(v string) *UpdateBackupPlanInput {
	s.BackupPlanId = &v
	return s
}

type UpdateBackupPlanOutput struct {
	_ struct{} `type:"structure"`

	// Contains a list of BackupOptions for each resource type.
	AdvancedBackupSettings []*AdvancedBackupSetting `type:"list"`

	// An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for
	// example, arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50.
	BackupPlanArn *string `type:"string"`

	// Uniquely identifies a backup plan.
	BackupPlanId *string `type:"string"`

	// The date and time a backup plan is created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreationDate is accurate to millisecond