
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQVariantAnimation.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QVariantAnimation>
#include <QAnimationGroup>
#include <QChildEvent>
#include <QEasingCurve>
#include <QEvent>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtCoreCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QVariantAnimation

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QVariantAnimation::staticMetaObject);
}


// QVariant QVariantAnimation::currentValue()


static void _init_f_currentValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_f_currentValue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVariant > ((QVariant)((QVariantAnimation *)cls)->currentValue ());
}


// int QVariantAnimation::duration()


static void _init_f_duration_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_duration_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVariantAnimation *)cls)->duration ());
}


// QEasingCurve QVariantAnimation::easingCurve()


static void _init_f_easingCurve_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QEasingCurve > ();
}

static void _call_f_easingCurve_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QEasingCurve > ((QEasingCurve)((QVariantAnimation *)cls)->easingCurve ());
}


// QVariant QVariantAnimation::endValue()


static void _init_f_endValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_f_endValue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVariant > ((QVariant)((QVariantAnimation *)cls)->endValue ());
}


// QVariant QVariantAnimation::keyValueAt(double step)


static void _init_f_keyValueAt_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_keyValueAt_c1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  ret.write<QVariant > ((QVariant)((QVariantAnimation *)cls)->keyValueAt (arg1));
}


// QList<QVariantAnimation::KeyValue> QVariantAnimation::keyValues()


static void _init_f_keyValues_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QList<QVariantAnimation::KeyValue> > ();
}

static void _call_f_keyValues_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QList<QVariantAnimation::KeyValue> > ((QList<QVariantAnimation::KeyValue>)((QVariantAnimation *)cls)->keyValues ());
}


// void QVariantAnimation::setDuration(int msecs)


static void _init_f_setDuration_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("msecs");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDuration_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation *)cls)->setDuration (arg1);
}


// void QVariantAnimation::setEasingCurve(const QEasingCurve &easing)


static void _init_f_setEasingCurve_2510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("easing");
  decl->add_arg<const QEasingCurve & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEasingCurve_2510 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QEasingCurve &arg1 = gsi::arg_reader<const QEasingCurve & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation *)cls)->setEasingCurve (arg1);
}


// void QVariantAnimation::setEndValue(const QVariant &value)


static void _init_f_setEndValue_2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setEndValue_2119 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation *)cls)->setEndValue (arg1);
}


// void QVariantAnimation::setKeyValueAt(double step, const QVariant &value)


static void _init_f_setKeyValueAt_3082 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setKeyValueAt_3082 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  const QVariant &arg2 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation *)cls)->setKeyValueAt (arg1, arg2);
}


// void QVariantAnimation::setKeyValues(const QList<QVariantAnimation::KeyValue> &values)


static void _init_f_setKeyValues_4584 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("values");
  decl->add_arg<const QList<QVariantAnimation::KeyValue> & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setKeyValues_4584 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QList<QVariantAnimation::KeyValue> &arg1 = gsi::arg_reader<const QList<QVariantAnimation::KeyValue> & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation *)cls)->setKeyValues (arg1);
}


// void QVariantAnimation::setStartValue(const QVariant &value)


static void _init_f_setStartValue_2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartValue_2119 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = gsi::arg_reader<const QVariant & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation *)cls)->setStartValue (arg1);
}


// QVariant QVariantAnimation::startValue()


static void _init_f_startValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QVariant > ();
}

static void _call_f_startValue_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QVariant > ((QVariant)((QVariantAnimation *)cls)->startValue ());
}


// static QString QVariantAnimation::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QVariantAnimation::tr (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QVariantAnimation () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":currentValue", "@brief Method QVariant QVariantAnimation::currentValue()\n", true, &_init_f_currentValue_c0, &_call_f_currentValue_c0);
  methods += new qt_gsi::GenericMethod (":duration", "@brief Method int QVariantAnimation::duration()\nThis is a reimplementation of QAbstractAnimation::duration", true, &_init_f_duration_c0, &_call_f_duration_c0);
  methods += new qt_gsi::GenericMethod (":easingCurve", "@brief Method QEasingCurve QVariantAnimation::easingCurve()\n", true, &_init_f_easingCurve_c0, &_call_f_easingCurve_c0);
  methods += new qt_gsi::GenericMethod (":endValue", "@brief Method QVariant QVariantAnimation::endValue()\n", true, &_init_f_endValue_c0, &_call_f_endValue_c0);
  methods += new qt_gsi::GenericMethod ("keyValueAt", "@brief Method QVariant QVariantAnimation::keyValueAt(double step)\n", true, &_init_f_keyValueAt_c1071, &_call_f_keyValueAt_c1071);
  methods += new qt_gsi::GenericMethod (":keyValues", "@brief Method QList<QVariantAnimation::KeyValue> QVariantAnimation::keyValues()\n", true, &_init_f_keyValues_c0, &_call_f_keyValues_c0);
  methods += new qt_gsi::GenericMethod ("setDuration|duration=", "@brief Method void QVariantAnimation::setDuration(int msecs)\n", false, &_init_f_setDuration_767, &_call_f_setDuration_767);
  methods += new qt_gsi::GenericMethod ("setEasingCurve|easingCurve=", "@brief Method void QVariantAnimation::setEasingCurve(const QEasingCurve &easing)\n", false, &_init_f_setEasingCurve_2510, &_call_f_setEasingCurve_2510);
  methods += new qt_gsi::GenericMethod ("setEndValue|endValue=", "@brief Method void QVariantAnimation::setEndValue(const QVariant &value)\n", false, &_init_f_setEndValue_2119, &_call_f_setEndValue_2119);
  methods += new qt_gsi::GenericMethod ("setKeyValueAt", "@brief Method void QVariantAnimation::setKeyValueAt(double step, const QVariant &value)\n", false, &_init_f_setKeyValueAt_3082, &_call_f_setKeyValueAt_3082);
  methods += new qt_gsi::GenericMethod ("setKeyValues|keyValues=", "@brief Method void QVariantAnimation::setKeyValues(const QList<QVariantAnimation::KeyValue> &values)\n", false, &_init_f_setKeyValues_4584, &_call_f_setKeyValues_4584);
  methods += new qt_gsi::GenericMethod ("setStartValue|startValue=", "@brief Method void QVariantAnimation::setStartValue(const QVariant &value)\n", false, &_init_f_setStartValue_2119, &_call_f_setStartValue_2119);
  methods += new qt_gsi::GenericMethod (":startValue", "@brief Method QVariant QVariantAnimation::startValue()\n", true, &_init_f_startValue_c0, &_call_f_startValue_c0);
  methods += gsi::qt_signal<int > ("currentLoopChanged(int)", "currentLoopChanged", gsi::arg("currentLoop"), "@brief Signal declaration for QVariantAnimation::currentLoopChanged(int currentLoop)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QVariantAnimation::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > ("directionChanged(QAbstractAnimation::Direction)", "directionChanged", gsi::arg("arg1"), "@brief Signal declaration for QVariantAnimation::directionChanged(QAbstractAnimation::Direction)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal ("finished()", "finished", "@brief Signal declaration for QVariantAnimation::finished()\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QVariantAnimation::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const qt_gsi::Converter<QAbstractAnimation::State>::target_type &, const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > ("stateChanged(QAbstractAnimation::State, QAbstractAnimation::State)", "stateChanged", gsi::arg("newState"), gsi::arg("oldState"), "@brief Signal declaration for QVariantAnimation::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QVariant & > ("valueChanged(const QVariant &)", "valueChanged", gsi::arg("value"), "@brief Signal declaration for QVariantAnimation::valueChanged(const QVariant &value)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QVariantAnimation::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  return methods;
}

gsi::Class<QAbstractAnimation> &qtdecl_QAbstractAnimation ();

qt_gsi::QtNativeClass<QVariantAnimation> decl_QVariantAnimation (qtdecl_QAbstractAnimation (), "QtCore", "QVariantAnimation_Native",
  methods_QVariantAnimation (),
  "@hide\n@alias QVariantAnimation");

GSI_QTCORE_PUBLIC gsi::Class<QVariantAnimation> &qtdecl_QVariantAnimation () { return decl_QVariantAnimation; }

}


class QVariantAnimation_Adaptor : public QVariantAnimation, public qt_gsi::QtObjectBase
{
public:

  virtual ~QVariantAnimation_Adaptor();

  //  [adaptor ctor] QVariantAnimation::QVariantAnimation(QObject *parent)
  QVariantAnimation_Adaptor() : QVariantAnimation()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QVariantAnimation::QVariantAnimation(QObject *parent)
  QVariantAnimation_Adaptor(QObject *parent) : QVariantAnimation(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QVariantAnimation::isSignalConnected(const QMetaMethod &signal)
  bool fp_QVariantAnimation_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QVariantAnimation::isSignalConnected(signal);
  }

  //  [expose] int QVariantAnimation::receivers(const char *signal)
  int fp_QVariantAnimation_receivers_c1731 (const char *signal) const {
    return QVariantAnimation::receivers(signal);
  }

  //  [expose] QObject *QVariantAnimation::sender()
  QObject * fp_QVariantAnimation_sender_c0 () const {
    return QVariantAnimation::sender();
  }

  //  [expose] int QVariantAnimation::senderSignalIndex()
  int fp_QVariantAnimation_senderSignalIndex_c0 () const {
    return QVariantAnimation::senderSignalIndex();
  }

  //  [emitter impl] void QVariantAnimation::currentLoopChanged(int currentLoop)
  void emitter_QVariantAnimation_currentLoopChanged_767(int currentLoop)
  {
    emit QVariantAnimation::currentLoopChanged(currentLoop);
  }

  //  [emitter impl] void QVariantAnimation::destroyed(QObject *)
  void emitter_QVariantAnimation_destroyed_1302(QObject *arg1)
  {
    emit QVariantAnimation::destroyed(arg1);
  }

  //  [emitter impl] void QVariantAnimation::directionChanged(QAbstractAnimation::Direction)
  void emitter_QVariantAnimation_directionChanged_3310(QAbstractAnimation::Direction arg1)
  {
    emit QVariantAnimation::directionChanged(arg1);
  }

  //  [adaptor impl] int QVariantAnimation::duration()
  int cbs_duration_c0_0() const
  {
    return QVariantAnimation::duration();
  }

  virtual int duration() const
  {
    if (cb_duration_c0_0.can_issue()) {
      return cb_duration_c0_0.issue<QVariantAnimation_Adaptor, int>(&QVariantAnimation_Adaptor::cbs_duration_c0_0);
    } else {
      return QVariantAnimation::duration();
    }
  }

  //  [adaptor impl] bool QVariantAnimation::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QVariantAnimation::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QVariantAnimation_Adaptor, bool, QObject *, QEvent *>(&QVariantAnimation_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QVariantAnimation::eventFilter(watched, event);
    }
  }

  //  [emitter impl] void QVariantAnimation::finished()
  void emitter_QVariantAnimation_finished_0()
  {
    emit QVariantAnimation::finished();
  }

  //  [emitter impl] void QVariantAnimation::objectNameChanged(const QString &objectName)
  void emitter_QVariantAnimation_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QVariantAnimation::objectNameChanged(const QString &objectName)'");
  }

  //  [emitter impl] void QVariantAnimation::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  void emitter_QVariantAnimation_stateChanged_5680(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  {
    emit QVariantAnimation::stateChanged(newState, oldState);
  }

  //  [emitter impl] void QVariantAnimation::valueChanged(const QVariant &value)
  void emitter_QVariantAnimation_valueChanged_2119(const QVariant &value)
  {
    emit QVariantAnimation::valueChanged(value);
  }

  //  [adaptor impl] void QVariantAnimation::childEvent(QChildEvent *event)
  void cbs_childEvent_1701_0(QChildEvent *event)
  {
    QVariantAnimation::childEvent(event);
  }

  virtual void childEvent(QChildEvent *event)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QVariantAnimation_Adaptor, QChildEvent *>(&QVariantAnimation_Adaptor::cbs_childEvent_1701_0, event);
    } else {
      QVariantAnimation::childEvent(event);
    }
  }

  //  [adaptor impl] void QVariantAnimation::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QVariantAnimation::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QVariantAnimation_Adaptor, QEvent *>(&QVariantAnimation_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QVariantAnimation::customEvent(event);
    }
  }

  //  [adaptor impl] void QVariantAnimation::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QVariantAnimation::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QVariantAnimation_Adaptor, const QMetaMethod &>(&QVariantAnimation_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QVariantAnimation::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QVariantAnimation::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QVariantAnimation::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QVariantAnimation_Adaptor, bool, QEvent *>(&QVariantAnimation_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QVariantAnimation::event(_event);
    }
  }

  //  [adaptor impl] QVariant QVariantAnimation::interpolated(const QVariant &from, const QVariant &to, double progress)
  QVariant cbs_interpolated_c5093_0(const QVariant &from, const QVariant &to, double progress) const
  {
    return QVariantAnimation::interpolated(from, to, progress);
  }

  virtual QVariant interpolated(const QVariant &from, const QVariant &to, double progress) const
  {
    if (cb_interpolated_c5093_0.can_issue()) {
      return cb_interpolated_c5093_0.issue<QVariantAnimation_Adaptor, QVariant, const QVariant &, const QVariant &, double>(&QVariantAnimation_Adaptor::cbs_interpolated_c5093_0, from, to, progress);
    } else {
      return QVariantAnimation::interpolated(from, to, progress);
    }
  }

  //  [adaptor impl] void QVariantAnimation::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QVariantAnimation::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QVariantAnimation_Adaptor, QTimerEvent *>(&QVariantAnimation_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QVariantAnimation::timerEvent(event);
    }
  }

  //  [adaptor impl] void QVariantAnimation::updateCurrentTime(int)
  void cbs_updateCurrentTime_767_0(int arg1)
  {
    QVariantAnimation::updateCurrentTime(arg1);
  }

  virtual void updateCurrentTime(int arg1)
  {
    if (cb_updateCurrentTime_767_0.can_issue()) {
      cb_updateCurrentTime_767_0.issue<QVariantAnimation_Adaptor, int>(&QVariantAnimation_Adaptor::cbs_updateCurrentTime_767_0, arg1);
    } else {
      QVariantAnimation::updateCurrentTime(arg1);
    }
  }

  //  [adaptor impl] void QVariantAnimation::updateCurrentValue(const QVariant &value)
  void cbs_updateCurrentValue_2119_0(const QVariant &value)
  {
    QVariantAnimation::updateCurrentValue(value);
  }

  virtual void updateCurrentValue(const QVariant &value)
  {
    if (cb_updateCurrentValue_2119_0.can_issue()) {
      cb_updateCurrentValue_2119_0.issue<QVariantAnimation_Adaptor, const QVariant &>(&QVariantAnimation_Adaptor::cbs_updateCurrentValue_2119_0, value);
    } else {
      QVariantAnimation::updateCurrentValue(value);
    }
  }

  //  [adaptor impl] void QVariantAnimation::updateDirection(QAbstractAnimation::Direction direction)
  void cbs_updateDirection_3310_0(const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & direction)
  {
    QVariantAnimation::updateDirection(qt_gsi::QtToCppAdaptor<QAbstractAnimation::Direction>(direction).cref());
  }

  virtual void updateDirection(QAbstractAnimation::Direction direction)
  {
    if (cb_updateDirection_3310_0.can_issue()) {
      cb_updateDirection_3310_0.issue<QVariantAnimation_Adaptor, const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type &>(&QVariantAnimation_Adaptor::cbs_updateDirection_3310_0, qt_gsi::CppToQtAdaptor<QAbstractAnimation::Direction>(direction));
    } else {
      QVariantAnimation::updateDirection(direction);
    }
  }

  //  [adaptor impl] void QVariantAnimation::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  void cbs_updateState_5680_0(const qt_gsi::Converter<QAbstractAnimation::State>::target_type & newState, const qt_gsi::Converter<QAbstractAnimation::State>::target_type & oldState)
  {
    QVariantAnimation::updateState(qt_gsi::QtToCppAdaptor<QAbstractAnimation::State>(newState).cref(), qt_gsi::QtToCppAdaptor<QAbstractAnimation::State>(oldState).cref());
  }

  virtual void updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)
  {
    if (cb_updateState_5680_0.can_issue()) {
      cb_updateState_5680_0.issue<QVariantAnimation_Adaptor, const qt_gsi::Converter<QAbstractAnimation::State>::target_type &, const qt_gsi::Converter<QAbstractAnimation::State>::target_type &>(&QVariantAnimation_Adaptor::cbs_updateState_5680_0, qt_gsi::CppToQtAdaptor<QAbstractAnimation::State>(newState), qt_gsi::CppToQtAdaptor<QAbstractAnimation::State>(oldState));
    } else {
      QVariantAnimation::updateState(newState, oldState);
    }
  }

  gsi::Callback cb_duration_c0_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_interpolated_c5093_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_updateCurrentTime_767_0;
  gsi::Callback cb_updateCurrentValue_2119_0;
  gsi::Callback cb_updateDirection_3310_0;
  gsi::Callback cb_updateState_5680_0;
};

QVariantAnimation_Adaptor::~QVariantAnimation_Adaptor() { }

//  Constructor QVariantAnimation::QVariantAnimation(QObject *parent) (adaptor class)

static void _init_ctor_QVariantAnimation_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QVariantAnimation_Adaptor> ();
}

static void _call_ctor_QVariantAnimation_Adaptor_1302 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ret.write<QVariantAnimation_Adaptor *> (new QVariantAnimation_Adaptor (arg1));
}


// void QVariantAnimation::childEvent(QChildEvent *event)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QVariantAnimation_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// emitter void QVariantAnimation::currentLoopChanged(int currentLoop)

static void _init_emitter_currentLoopChanged_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("currentLoop");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_currentLoopChanged_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ((QVariantAnimation_Adaptor *)cls)->emitter_QVariantAnimation_currentLoopChanged_767 (arg1);
}


// void QVariantAnimation::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QVariantAnimation_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QVariantAnimation::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QVariantAnimation_Adaptor *)cls)->emitter_QVariantAnimation_destroyed_1302 (arg1);
}


// emitter void QVariantAnimation::directionChanged(QAbstractAnimation::Direction)

static void _init_emitter_directionChanged_3310 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_directionChanged_3310 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & >() (args, heap);
  ((QVariantAnimation_Adaptor *)cls)->emitter_QVariantAnimation_directionChanged_3310 (arg1);
}


// void QVariantAnimation::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QVariantAnimation_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// int QVariantAnimation::duration()

static void _init_cbs_duration_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_duration_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVariantAnimation_Adaptor *)cls)->cbs_duration_c0_0 ());
}

static void _set_callback_cbs_duration_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QVariantAnimation_Adaptor *)cls)->cb_duration_c0_0 = cb;
}


// bool QVariantAnimation::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QVariantAnimation_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QVariantAnimation_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QVariantAnimation::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QVariantAnimation_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QVariantAnimation_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// emitter void QVariantAnimation::finished()

static void _init_emitter_finished_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_emitter_finished_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ((QVariantAnimation_Adaptor *)cls)->emitter_QVariantAnimation_finished_0 ();
}


// QVariant QVariantAnimation::interpolated(const QVariant &from, const QVariant &to, double progress)

static void _init_cbs_interpolated_c5093_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QVariant & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("progress");
  decl->add_arg<double > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_interpolated_c5093_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = args.read<const QVariant & > (heap);
  const QVariant &arg2 = args.read<const QVariant & > (heap);
  double arg3 = args.read<double > (heap);
  ret.write<QVariant > ((QVariant)((QVariantAnimation_Adaptor *)cls)->cbs_interpolated_c5093_0 (arg1, arg2, arg3));
}

static void _set_callback_cbs_interpolated_c5093_0 (void *cls, const gsi::Callback &cb)
{
  ((QVariantAnimation_Adaptor *)cls)->cb_interpolated_c5093_0 = cb;
}


// exposed bool QVariantAnimation::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QVariantAnimation_Adaptor *)cls)->fp_QVariantAnimation_isSignalConnected_c2394 (arg1));
}


// emitter void QVariantAnimation::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QVariantAnimation_Adaptor *)cls)->emitter_QVariantAnimation_objectNameChanged_4567 (arg1);
}


// exposed int QVariantAnimation::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QVariantAnimation_Adaptor *)cls)->fp_QVariantAnimation_receivers_c1731 (arg1));
}


// exposed QObject *QVariantAnimation::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QVariantAnimation_Adaptor *)cls)->fp_QVariantAnimation_sender_c0 ());
}


// exposed int QVariantAnimation::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QVariantAnimation_Adaptor *)cls)->fp_QVariantAnimation_senderSignalIndex_c0 ());
}


// emitter void QVariantAnimation::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)

static void _init_emitter_stateChanged_5680 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_emitter_stateChanged_5680 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & >() (args, heap);
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & >() (args, heap);
  ((QVariantAnimation_Adaptor *)cls)->emitter_QVariantAnimation_stateChanged_5680 (arg1, arg2);
}


// void QVariantAnimation::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QVariantAnimation_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// void QVariantAnimation::updateCurrentTime(int)

static void _init_cbs_updateCurrentTime_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateCurrentTime_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation_Adaptor *)cls)->cbs_updateCurrentTime_767_0 (arg1);
}

static void _set_callback_cbs_updateCurrentTime_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QVariantAnimation_Adaptor *)cls)->cb_updateCurrentTime_767_0 = cb;
}


// void QVariantAnimation::updateCurrentValue(const QVariant &value)

static void _init_cbs_updateCurrentValue_2119_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateCurrentValue_2119_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = args.read<const QVariant & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation_Adaptor *)cls)->cbs_updateCurrentValue_2119_0 (arg1);
}

static void _set_callback_cbs_updateCurrentValue_2119_0 (void *cls, const gsi::Callback &cb)
{
  ((QVariantAnimation_Adaptor *)cls)->cb_updateCurrentValue_2119_0 = cb;
}


// void QVariantAnimation::updateDirection(QAbstractAnimation::Direction direction)

static void _init_cbs_updateDirection_3310_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_updateDirection_3310_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractAnimation::Direction>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation_Adaptor *)cls)->cbs_updateDirection_3310_0 (arg1);
}

static void _set_callback_cbs_updateDirection_3310_0 (void *cls, const gsi::Callback &cb)
{
  ((QVariantAnimation_Adaptor *)cls)->cb_updateDirection_3310_0 = cb;
}


// void QVariantAnimation::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)

static void _init_cbs_updateState_5680_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldState");
  decl->add_arg<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_updateState_5680_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg1 = args.read<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (heap);
  const qt_gsi::Converter<QAbstractAnimation::State>::target_type & arg2 = args.read<const qt_gsi::Converter<QAbstractAnimation::State>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QVariantAnimation_Adaptor *)cls)->cbs_updateState_5680_0 (arg1, arg2);
}

static void _set_callback_cbs_updateState_5680_0 (void *cls, const gsi::Callback &cb)
{
  ((QVariantAnimation_Adaptor *)cls)->cb_updateState_5680_0 = cb;
}


// emitter void QVariantAnimation::valueChanged(const QVariant &value)

static void _init_emitter_valueChanged_2119 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<const QVariant & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_valueChanged_2119 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QVariant &arg1 = gsi::arg_reader<const QVariant & >() (args, heap);
  ((QVariantAnimation_Adaptor *)cls)->emitter_QVariantAnimation_valueChanged_2119 (arg1);
}


namespace gsi
{

gsi::Class<QVariantAnimation> &qtdecl_QVariantAnimation ();

static gsi::Methods methods_QVariantAnimation_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QVariantAnimation::QVariantAnimation(QObject *parent)\nThis method creates an object of class QVariantAnimation.", &_init_ctor_QVariantAnimation_Adaptor_1302, &_call_ctor_QVariantAnimation_Adaptor_1302);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QVariantAnimation::childEvent(QChildEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("emit_currentLoopChanged", "@brief Emitter for signal void QVariantAnimation::currentLoopChanged(int currentLoop)\nCall this method to emit this signal.", false, &_init_emitter_currentLoopChanged_767, &_call_emitter_currentLoopChanged_767);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QVariantAnimation::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QVariantAnimation::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("emit_directionChanged", "@brief Emitter for signal void QVariantAnimation::directionChanged(QAbstractAnimation::Direction)\nCall this method to emit this signal.", false, &_init_emitter_directionChanged_3310, &_call_emitter_directionChanged_3310);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QVariantAnimation::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("duration", "@brief Virtual method int QVariantAnimation::duration()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("duration", "@hide", true, &_init_cbs_duration_c0_0, &_call_cbs_duration_c0_0, &_set_callback_cbs_duration_c0_0);
  methods += new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QVariantAnimation::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QVariantAnimation::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("emit_finished", "@brief Emitter for signal void QVariantAnimation::finished()\nCall this method to emit this signal.", false, &_init_emitter_finished_0, &_call_emitter_finished_0);
  methods += new qt_gsi::GenericMethod ("*interpolated", "@brief Virtual method QVariant QVariantAnimation::interpolated(const QVariant &from, const QVariant &to, double progress)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_interpolated_c5093_0, &_call_cbs_interpolated_c5093_0);
  methods += new qt_gsi::GenericMethod ("*interpolated", "@hide", true, &_init_cbs_interpolated_c5093_0, &_call_cbs_interpolated_c5093_0, &_set_callback_cbs_interpolated_c5093_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QVariantAnimation::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QVariantAnimation::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QVariantAnimation::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QVariantAnimation::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QVariantAnimation::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("emit_stateChanged", "@brief Emitter for signal void QVariantAnimation::stateChanged(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nCall this method to emit this signal.", false, &_init_emitter_stateChanged_5680, &_call_emitter_stateChanged_5680);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QVariantAnimation::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentTime", "@brief Virtual method void QVariantAnimation::updateCurrentTime(int)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateCurrentTime_767_0, &_call_cbs_updateCurrentTime_767_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentTime", "@hide", false, &_init_cbs_updateCurrentTime_767_0, &_call_cbs_updateCurrentTime_767_0, &_set_callback_cbs_updateCurrentTime_767_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentValue", "@brief Virtual method void QVariantAnimation::updateCurrentValue(const QVariant &value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateCurrentValue_2119_0, &_call_cbs_updateCurrentValue_2119_0);
  methods += new qt_gsi::GenericMethod ("*updateCurrentValue", "@hide", false, &_init_cbs_updateCurrentValue_2119_0, &_call_cbs_updateCurrentValue_2119_0, &_set_callback_cbs_updateCurrentValue_2119_0);
  methods += new qt_gsi::GenericMethod ("*updateDirection", "@brief Virtual method void QVariantAnimation::updateDirection(QAbstractAnimation::Direction direction)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateDirection_3310_0, &_call_cbs_updateDirection_3310_0);
  methods += new qt_gsi::GenericMethod ("*updateDirection", "@hide", false, &_init_cbs_updateDirection_3310_0, &_call_cbs_updateDirection_3310_0, &_set_callback_cbs_updateDirection_3310_0);
  methods += new qt_gsi::GenericMethod ("*updateState", "@brief Virtual method void QVariantAnimation::updateState(QAbstractAnimation::State newState, QAbstractAnimation::State oldState)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_updateState_5680_0, &_call_cbs_updateState_5680_0);
  methods += new qt_gsi::GenericMethod ("*updateState", "@hide", false, &_init_cbs_updateState_5680_0, &_call_cbs_updateState_5680_0, &_set_callback_cbs_updateState_5680_0);
  methods += new qt_gsi::GenericMethod ("emit_valueChanged", "@brief Emitter for signal void QVariantAnimation::valueChanged(const QVariant &value)\nCall this method to emit this signal.", false, &_init_emitter_valueChanged_2119, &_call_emitter_valueChanged_2119);
  return methods;
}

gsi::Class<QVariantAnimation_Adaptor> decl_QVariantAnimation_Adaptor (qtdecl_QVariantAnimation (), "QtCore", "QVariantAnimation",
  methods_QVariantAnimation_Adaptor (),
  "@qt\n@brief Binding of QVariantAnimation");

}

