/* ----- core/invsntrup761, derived from supercop/crypto_core/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *core_invsntrup761_checksums[] = {
  "681d6c76cd117dbe30df650d7701ae3a75b82d0a916ed319e942e34d87726ab6",
  "e0a98560abe832360f4b8a8101491ccc7e1adaeafcf056b382ff9a16c24004b6",
} ;

static void (*crypto_core)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_core_OUTPUTBYTES ntruprime_core_invsntrup761_OUTPUTBYTES
#define crypto_core_INPUTBYTES ntruprime_core_invsntrup761_INPUTBYTES
#define crypto_core_KEYBYTES ntruprime_core_invsntrup761_KEYBYTES
#define crypto_core_CONSTBYTES ntruprime_core_invsntrup761_CONSTBYTES

static void *storage_core_invsntrup761_h;
static unsigned char *test_core_invsntrup761_h;
static void *storage_core_invsntrup761_n;
static unsigned char *test_core_invsntrup761_n;
static void *storage_core_invsntrup761_k;
static unsigned char *test_core_invsntrup761_k;
static void *storage_core_invsntrup761_c;
static unsigned char *test_core_invsntrup761_c;
static void *storage_core_invsntrup761_h2;
static unsigned char *test_core_invsntrup761_h2;
static void *storage_core_invsntrup761_n2;
static unsigned char *test_core_invsntrup761_n2;
static void *storage_core_invsntrup761_k2;
static unsigned char *test_core_invsntrup761_k2;
static void *storage_core_invsntrup761_c2;
static unsigned char *test_core_invsntrup761_c2;

#define precomputed_core_invsntrup761_NUM 4

static const unsigned char precomputed_core_invsntrup761_h[precomputed_core_invsntrup761_NUM][crypto_core_OUTPUTBYTES] = {
  {140,8,204,253,247,247,3,0,59,255,251,2,102,3,216,4,157,247,253,5,208,251,23,255,71,248,172,5,140,6,2,4,171,3,21,4,128,0,13,247,162,250,23,252,12,4,0,4,247,7,95,7,123,255,39,254,107,248,89,248,227,1,116,7,164,1,145,250,20,3,164,8,189,247,198,250,37,249,156,250,63,254,13,255,223,7,181,3,158,2,218,248,0,253,56,250,54,2,183,249,5,252,30,253,232,1,213,250,213,253,254,248,172,0,133,247,8,253,97,8,47,251,95,249,56,254,121,3,60,8,61,249,34,252,222,8,203,0,127,252,135,249,63,251,20,252,6,5,187,250,101,255,139,253,198,7,171,254,15,249,25,5,45,248,165,8,174,2,47,8,144,249,169,254,251,4,114,5,239,250,82,255,133,254,211,4,46,7,251,252,68,8,128,254,247,251,116,6,235,4,178,3,150,4,34,7,92,253,5,254,127,3,195,255,127,7,104,255,233,1,144,255,96,247,135,2,91,7,10,248,179,6,203,0,11,255,95,2,228,3,206,4,194,1,52,2,216,250,91,254,171,248,181,1,123,3,230,7,85,4,127,254,80,0,157,250,172,1,73,6,36,0,50,1,142,6,104,247,157,1,245,248,235,6,127,4,11,251,205,8,102,252,50,255,218,2,85,253,239,8,238,1,80,255,18,247,189,253,193,254,252,250,234,252,110,249,205,7,116,251,110,2,182,5,198,248,57,1,124,250,219,4,253,2,123,2,172,250,36,7,79,3,48,2,85,251,43,3,29,254,98,1,109,249,253,255,232,6,96,7,165,254,63,250,66,251,121,251,127,2,122,7,104,250,68,1,228,248,17,2,114,2,56,3,44,4,192,251,207,249,62,249,94,3,57,5,54,247,63,251,29,248,124,253,173,2,170,2,173,8,187,8,127,8,71,8,144,248,253,248,178,4,54,254,27,252,128,5,218,2,65,252,186,0,225,254,138,250,64,249,146,255,20,5,248,254,149,0,146,8,31,252,106,3,92,2,132,249,82,252,137,248,63,251,127,249,10,248,210,250,128,253,229,2,141,7,117,3,62,252,194,2,228,0,66,1,225,1,200,0,95,8,137,248,186,5,193,7,104,1,201,254,196,2,63,249,243,251,31,8,213,253,108,255,10,5,64,249,75,253,26,247,234,8,72,254,253,2,16,251,146,4,242,254,188,3,192,2,130,251,186,3,71,255,130,1,51,251,49,248,95,254,240,8,52,252,13,5,112,248,128,251,86,252,70,253,56,253,158,247,163,253,254,254,128,3,208,255,218,254,33,254,31,248,15,249,88,254,199,251,133,5,150,247,188,4,117,250,57,251,90,248,164,6,240,250,246,3,45,250,200,2,81,8,140,1,6,254,67,3,249,254,27,253,95,248,22,8,103,4,49,4,180,252,213,248,174,3,60,6,128,6,247,8,171,255,189,248,230,254,107,1,191,3,112,252,202,251,174,3,192,0,102,2,67,251,29,4,42,247,18,0,248,249,33,251,197,7,91,1,106,248,241,253,2,1,216,255,220,0,59,3,81,0,37,8,47,250,16,0,0,3,216,251,236,0,5,5,22,5,165,2,130,248,162,8,152,4,130,4,203,255,22,248,14,7,153,250,166,255,178,5,107,1,159,248,59,0,131,0,55,248,177,0,242,2,31,8,128,6,206,8,41,252,148,248,54,1,196,0,223,253,19,4,244,250,243,1,12,7,52,7,180,6,145,7,174,251,113,6,62,4,57,1,243,254,25,255,84,7,162,8,217,247,250,1,99,251,178,254,226,249,13,255,167,252,40,1,76,255,221,250,28,253,254,249,74,1,117,252,140,252,43,254,143,252,185,3,6,248,146,2,125,2,188,248,81,5,98,8,16,249,201,5,240,251,206,0,108,1,97,3,42,6,47,255,228,251,187,253,4,251,170,1,111,252,149,6,24,2,174,254,121,7,44,255,200,249,251,7,60,247,67,249,37,4,166,5,0,251,133,249,106,254,61,251,105,250,92,253,186,255,39,254,23,4,141,248,150,254,222,5,234,3,232,252,101,248,174,250,89,8,55,4,110,249,159,0,87,0,118,253,69,252,35,2,55,253,158,251,149,254,133,6,26,250,100,249,194,0,125,8,215,253,82,249,106,249,95,3,181,249,18,3,104,249,120,255,114,3,232,6,78,249,149,251,200,7,142,255,155,255,133,2,137,7,160,2,205,5,164,8,53,250,190,3,158,253,22,251,55,247,10,7,100,250,143,253,47,0,200,6,134,253,41,247,213,7,13,5,106,249,233,247,89,252,10,251,176,255,148,8,87,6,244,252,107,3,195,252,133,252,11,7,197,7,82,3,25,254,79,250,11,250,135,6,35,250,11,254,141,5,97,255,80,7,255,6,8,7,67,3,193,7,245,253,77,248,224,251,66,7,87,4,2,1,209,6,187,2,40,6,142,3,66,251,239,253,183,4,165,253,223,254,155,4,31,0,214,0,8,2,241,255,205,248,132,0,15,247,253,249,181,251,102,0,94,8,67,6,204,255,79,7,180,4,14,2,3,250,224,247,169,251,112,5,208,253,16,249,122,0,18,247,52,252,88,248,97,252,45,4,198,7,83,6,201,250,38,7,81,252,185,3,197,6,132,251,201,5,188,250,170,5,145,251,178,3,156,5,78,0,217,7,246,4,101,255,229,249,119,250,237,4,43,3,122,249,44,6,123,0,52,0,56,251,84,249,148,8,206,7,161,248,83,249,140,248,175,8,46,7,61,2,139,253,222,251,221,255,90,253,35,5,140,0,51,2,60,5,83,255,137,7,185,8,171,255,127,252,216,4,69,5,80,6,40,6,203,253,48,250,135,251,131,7,203,7,212,3,10,7,119,252,81,3,74,254,95,8,199,250,41,0,250,249,105,6,103,249,116,2,138,6,87,248,206,1,147,252,92,250,34,247,92,248,0,251,248,254,201,253,68,255,134,255,88,3,172,7,255,248,106,1,73,252,174,4,160,0,195,249,217,2,94,8,55,252,75,252,11,252,62,254,72,252,123,2,75,1,59,2,210,249,25,254,191,6,155,251,9,248,203,250,97,253,93,0,128,4,199,1,40,7,125,7,38,1,7,7,115,6,117,2,0,1,12,8,145,7,193,248,120,247,120,6,59,252,163,255,2,7,69,6,183,254,178,2,93,247,120,0,177,247,203,253,31,3,166,2,154,248,217,2,0,0,136,8,77,2,230,254,107,252,42,5,247,253,44,7,209,255,92,255,35,5,146,2,52,3,214,3,72,6,57,253,85,253,84,0,155,2,229,7,222,250,152,255,27,8,255,249,103,251,219,247,34,8,176,253,245,252,219,253,105,8,199,250,8,249,40,250,22,249,38,249,207,250,166,3,41,0,88,8,48,250,135,1,107,250,156,252,0},
  {198,6,206,251,242,248,133,2,57,249,250,255,89,254,193,7,202,7,140,250,177,3,74,255,85,249,255,2,43,3,244,1,65,255,220,6,134,252,83,8,53,255,21,8,98,0,200,251,230,249,230,249,110,249,213,0,229,8,163,250,93,250,10,7,252,252,192,2,91,250,211,2,141,3,239,251,230,254,99,255,240,0,38,254,218,247,147,250,60,0,113,7,165,0,79,254,181,5,88,251,220,251,191,247,51,5,136,7,32,5,100,8,144,8,245,2,188,5,226,254,244,250,95,7,8,250,90,253,250,4,101,8,179,247,138,0,82,248,214,2,64,254,0,0,242,8,250,6,107,0,96,253,164,247,220,255,192,5,108,3,35,247,48,1,46,248,194,253,82,250,205,255,214,250,213,252,106,247,167,8,141,5,188,7,189,6,187,253,97,252,47,2,238,253,204,8,178,4,49,7,98,247,102,3,100,6,102,0,145,248,218,5,95,2,88,8,130,4,206,5,49,252,158,253,57,253,99,0,164,3,77,8,207,252,21,250,249,6,230,0,237,7,12,0,112,8,139,249,131,6,148,251,148,252,52,8,130,250,144,1,70,249,86,6,164,254,29,254,64,253,130,251,224,8,131,252,48,6,164,255,29,1,240,8,154,1,127,252,9,253,149,5,193,8,169,250,118,3,197,3,231,1,219,249,2,7,18,3,37,5,107,8,179,255,37,249,213,254,13,255,178,3,233,0,133,251,156,7,22,250,219,254,226,5,205,247,36,2,243,1,171,250,226,247,220,7,97,4,201,248,38,254,133,6,49,252,16,1,49,0,146,250,143,1,175,6,127,247,145,7,135,3,94,253,4,6,76,249,142,252,104,253,91,4,115,1,23,249,31,1,131,2,29,255,119,247,161,5,65,250,140,6,9,249,160,4,104,6,52,250,38,8,246,6,219,254,7,255,243,6,136,255,157,5,16,0,68,251,42,248,94,250,58,253,166,254,141,1,214,251,169,252,58,252,122,4,20,251,96,247,222,249,137,1,133,251,95,250,13,254,136,250,180,5,47,254,34,253,36,6,231,6,33,251,193,5,123,252,249,2,54,8,130,254,128,7,8,254,169,252,239,251,35,247,234,248,242,254,115,250,11,254,162,5,73,255,58,7,243,247,117,250,162,7,106,1,77,5,90,253,230,7,190,254,110,1,25,7,195,7,168,254,249,248,71,253,83,254,206,252,196,251,176,8,205,5,44,8,235,254,143,6,41,255,47,251,15,250,206,250,20,2,16,2,64,1,135,248,119,3,36,255,102,8,223,248,236,7,85,4,68,249,31,0,108,255,139,0,154,0,131,6,250,5,53,249,84,255,113,253,150,250,71,2,135,6,194,7,94,6,33,254,194,254,12,252,11,1,48,4,37,3,211,248,91,247,173,6,209,252,29,3,167,8,206,249,27,6,55,254,27,5,123,6,197,8,25,3,85,252,42,0,143,5,218,2,209,2,138,1,107,8,98,253,70,2,15,0,10,5,143,251,105,0,208,254,7,5,161,255,162,4,193,4,168,254,234,7,126,2,158,254,3,249,222,249,15,1,224,250,126,0,48,0,26,5,153,1,154,247,113,8,169,255,186,7,131,3,249,7,44,248,255,253,246,248,219,249,76,249,154,2,97,0,229,1,123,7,148,5,122,0,5,5,127,0,26,3,130,7,205,2,169,0,237,8,53,252,184,252,71,8,85,255,209,247,45,8,45,253,241,8,99,7,97,8,150,251,114,250,96,7,178,8,37,255,225,7,112,253,145,6,80,6,140,253,33,252,128,254,99,2,181,0,162,247,64,249,113,250,221,5,45,253,82,3,104,6,66,255,177,252,197,248,144,5,192,248,140,8,82,6,64,250,124,5,27,4,41,7,62,4,140,252,242,1,7,5,29,247,14,2,58,248,46,7,214,255,2,6,188,8,188,250,135,253,233,250,229,5,167,5,251,254,74,5,60,249,231,5,154,6,76,255,213,251,36,4,1,6,18,247,147,251,93,250,206,254,111,0,233,6,188,252,223,7,7,1,53,248,195,248,95,253,15,253,39,248,145,7,162,7,30,255,38,6,133,248,68,251,91,253,29,6,4,0,51,3,31,2,236,255,242,249,70,7,186,253,95,252,41,248,3,0,17,3,188,1,162,4,232,254,6,5,208,3,60,3,160,252,70,0,239,2,117,0,220,255,98,4,132,247,36,5,111,2,42,7,175,252,142,7,145,3,5,252,140,252,71,253,111,3,6,250,166,255,149,249,230,248,48,1,161,253,201,251,7,249,178,3,39,251,72,4,238,248,101,1,172,2,114,4,82,248,23,253,224,252,141,6,33,8,236,253,186,7,168,3,105,250,199,5,185,5,95,8,239,247,73,249,7,254,102,3,44,247,154,247,89,0,196,6,150,250,132,3,24,249,172,254,162,252,132,6,130,247,191,255,251,250,232,1,163,247,147,2,225,247,27,255,59,1,4,2,204,253,11,4,86,248,114,3,161,3,123,253,61,0,179,8,171,248,29,2,117,255,251,7,54,251,112,254,129,3,248,3,26,5,135,4,77,248,246,1,219,0,244,252,107,5,238,249,127,4,210,0,38,249,6,248,74,3,226,253,158,251,81,255,123,2,42,251,69,255,52,255,192,251,245,250,9,247,167,6,101,5,171,5,134,248,210,3,190,253,43,5,24,5,159,248,1,248,13,255,225,8,118,6,211,253,35,4,95,254,142,251,165,3,172,247,254,255,185,5,188,249,80,254,46,2,250,253,137,253,79,4,152,8,218,0,116,254,233,252,70,249,130,7,50,4,49,1,104,8,210,4,32,254,233,4,33,2,226,4,86,252,200,253,118,255,35,254,34,4,154,255,71,249,171,253,31,255,184,6,11,7,222,3,81,251,89,6,54,6,252,247,34,6,198,253,3,6,90,6,48,255,248,0,105,247,115,252,63,6,192,254,26,7,208,4,181,2,99,250,85,248,126,254,29,3,83,0,101,4,22,8,104,6,205,253,228,254,177,2,127,254,158,0,103,6,190,6,164,251,67,250,3,254,21,252,18,251,57,0,66,2,18,248,163,3,213,6,83,4,41,255,223,248,3,5,242,3,33,248,62,248,224,250,8,3,97,247,103,8,31,6,18,5,152,7,37,5,117,251,123,252,55,1,19,7,170,250,228,247,138,0,127,247,123,1,243,5,42,1,207,255,204,4,142,4,143,2,188,3,19,1,97,249,155,7,166,248,229,253,60,8,135,251,123,254,71,250,139,251,120,255,207,8,172,3,179,253,33,253,123,0,93,7,38,0,205,8,253,252,66,249,125,3,20,251,35,254,243,250,44,251,13,3,29,2,109,252,146,1,239,0,28,252,93,8,101,252,90,3,250,254,75,253,28,8,133,248,140,2,122,2,66,5,102,248,99,248,0},
  {67,249,56,253,107,0,24,3,196,247,234,0,229,0,92,4,4,254,97,254,192,0,73,6,1,8,116,0,186,0,157,252,110,5,163,8,129,7,152,247,167,251,143,247,181,250,110,8,208,4,38,249,202,249,247,255,87,2,29,251,215,251,67,249,54,255,118,249,38,7,36,5,103,250,194,8,1,0,157,0,138,3,123,8,219,6,96,8,86,252,226,253,153,250,126,0,120,248,227,253,6,252,171,252,89,4,177,248,12,254,200,255,171,0,154,3,26,251,81,253,57,5,24,255,11,254,15,5,40,250,184,253,112,247,115,247,187,0,3,0,107,250,117,252,218,3,117,247,176,247,145,248,212,2,36,2,113,252,217,2,82,4,122,248,222,0,150,255,153,3,91,3,211,252,239,247,244,249,83,247,235,8,99,4,103,253,203,255,43,7,91,252,201,3,83,5,208,5,170,4,47,0,52,8,184,7,170,255,71,247,156,249,124,255,253,251,110,6,117,254,104,251,196,0,90,247,29,248,75,250,171,247,218,5,112,247,29,6,113,0,223,247,195,7,80,3,113,2,33,249,115,7,85,250,51,5,74,250,191,248,127,7,148,250,225,0,209,2,243,250,33,248,183,247,104,253,238,255,193,6,57,2,121,7,42,8,101,2,117,255,123,252,56,7,76,2,64,253,228,251,38,251,180,249,133,252,41,252,185,250,94,253,108,254,28,7,119,2,178,1,115,250,109,8,165,4,43,250,68,7,210,7,145,4,118,250,99,3,236,250,23,252,13,7,175,250,28,252,33,247,250,247,221,6,19,247,64,252,7,254,70,8,57,3,61,253,95,254,35,4,239,2,190,249,122,6,129,0,236,3,131,251,35,7,174,249,112,248,80,0,222,247,143,8,37,7,139,3,84,7,55,249,35,247,184,6,154,3,208,249,234,253,224,248,151,0,168,255,160,2,70,248,130,253,162,6,22,251,95,8,193,5,211,252,251,2,169,254,78,5,83,254,25,250,153,248,175,247,185,2,181,253,171,255,19,251,182,6,235,249,166,254,105,7,82,8,133,2,106,250,187,250,159,4,199,250,237,3,81,249,107,1,201,7,3,248,2,5,247,1,96,255,226,1,183,251,171,248,67,5,51,251,183,254,184,3,21,8,155,4,118,252,84,0,200,7,42,3,63,253,141,251,251,3,39,247,220,249,193,4,206,249,144,4,46,0,49,7,176,249,148,1,12,253,37,4,38,7,16,249,20,7,189,247,105,1,198,253,239,247,212,253,135,251,165,247,48,2,39,1,130,0,98,254,88,7,224,8,100,250,165,4,114,5,215,4,16,252,253,248,122,7,191,5,94,249,6,249,110,3,14,8,77,250,193,2,42,2,133,254,200,255,238,250,97,253,253,250,86,247,69,249,152,5,12,255,208,247,5,4,45,8,98,250,228,252,218,3,9,8,124,3,196,248,8,254,252,249,34,8,216,249,96,8,215,4,10,8,254,252,112,248,78,252,197,249,172,6,252,6,145,249,3,4,249,251,6,251,36,247,208,251,49,8,174,247,45,8,171,252,155,254,173,6,52,253,20,3,159,252,224,247,71,6,247,251,168,3,133,6,213,250,78,4,116,253,245,3,34,251,48,250,92,6,205,247,15,248,73,5,201,5,129,2,111,1,201,4,106,247,163,252,209,251,170,250,224,255,243,249,62,7,138,253,154,247,86,2,220,255,64,3,29,247,62,249,123,253,200,255,51,0,37,255,141,3,14,251,39,3,255,4,91,7,18,251,57,254,134,251,248,5,188,2,38,253,253,255,130,249,253,0,181,2,138,255,50,254,199,3,195,251,14,1,43,2,238,0,13,250,127,254,157,3,213,247,23,247,85,4,153,0,30,252,7,254,124,250,208,252,107,254,79,249,136,7,49,2,225,252,55,247,107,5,0,1,209,250,25,4,143,253,186,5,29,249,106,255,77,6,162,251,99,252,122,3,136,2,34,0,75,254,17,250,60,7,148,2,21,249,78,250,223,252,159,249,42,247,193,252,15,250,21,255,120,250,31,247,166,7,196,249,135,1,91,8,107,2,224,251,222,7,11,8,96,8,234,253,60,251,112,8,152,248,239,1,131,4,16,252,27,8,234,8,171,8,15,247,64,7,192,251,47,4,57,3,16,247,227,247,175,8,193,1,227,251,249,255,142,253,8,4,4,253,69,253,150,250,50,8,64,255,71,247,217,247,64,1,187,253,234,253,37,6,84,253,203,248,230,250,161,250,106,4,218,252,184,248,55,5,42,5,55,252,174,0,237,249,78,251,169,247,115,3,139,247,12,255,105,255,164,249,118,253,55,4,228,251,213,1,72,7,175,7,160,6,40,3,6,5,167,1,134,1,160,254,38,0,139,251,195,249,190,248,38,248,164,249,117,248,12,6,78,8,12,6,186,4,194,252,18,6,242,253,79,251,26,250,130,4,16,4,87,5,152,3,72,247,79,252,225,247,78,0,0,8,227,3,81,248,73,247,214,6,208,251,120,3,125,251,9,6,137,247,19,6,209,255,6,254,239,247,8,251,220,253,151,5,229,1,199,1,43,5,238,254,55,1,226,3,186,250,64,251,187,248,192,0,114,247,18,254,80,252,150,5,61,250,170,5,246,252,99,5,207,253,192,255,251,5,106,251,130,248,132,248,68,0,51,0,16,255,69,0,128,252,101,8,171,248,118,252,246,0,216,4,99,248,78,248,146,252,234,251,250,253,149,247,159,253,51,253,189,5,98,247,93,2,230,2,24,4,208,6,16,7,169,255,97,1,9,247,245,250,194,250,153,0,6,250,231,251,218,253,221,247,169,250,247,255,154,253,170,5,145,255,38,254,90,4,49,2,72,247,144,2,14,251,238,6,165,253,193,0,113,252,197,255,12,3,143,247,112,252,22,248,19,250,93,1,193,3,145,5,158,255,235,247,70,3,203,0,133,254,86,253,190,8,82,252,91,249,191,248,156,7,130,4,125,252,97,250,110,6,175,5,58,4,95,252,38,0,151,255,164,6,166,1,194,255,131,251,49,3,243,4,134,253,193,8,209,248,204,253,150,248,140,249,50,255,168,4,166,252,91,7,121,250,240,252,97,252,120,2,102,247,6,252,44,249,29,1,4,2,55,6,152,251,20,4,40,0,16,249,54,253,94,248,20,249,246,3,126,1,155,3,187,249,51,252,8,252,199,7,131,4,32,252,154,1,70,2,232,5,31,252,250,6,197,4,209,253,91,8,227,3,122,252,84,250,43,6,103,247,194,3,97,253,157,3,114,247,9,255,62,255,219,252,182,3,240,3,101,251,98,5,245,251,138,7,227,7,184,6,28,247,84,247,68,255,173,0,24,249,203,1,17,252,222,7,250,249,18,5,92,4,62,2,245,3,109,2,31,255,21,1,55,253,64,249,120,253,0},
  {219,7,190,255,204,6,82,3,187,253,78,252,132,7,214,253,174,254,232,254,203,255,194,254,20,255,70,3,110,0,193,251,15,249,167,249,191,6,72,4,182,255,188,255,197,5,20,247,227,4,100,4,28,2,118,5,195,4,243,8,125,249,231,255,88,2,83,251,163,6,201,1,23,249,0,254,98,248,108,0,78,254,111,249,1,252,109,253,167,5,246,1,246,254,138,1,26,4,221,248,215,251,137,4,95,250,53,8,1,7,126,252,15,252,143,254,139,5,71,250,220,248,205,2,113,5,32,0,247,7,160,7,252,255,79,0,231,250,247,247,244,7,173,251,199,251,158,5,244,251,157,254,35,4,207,253,157,255,61,249,65,250,44,5,47,249,197,250,151,252,105,8,248,249,178,4,93,5,7,251,176,5,210,248,124,5,161,8,165,0,71,3,177,5,72,254,38,254,161,6,109,249,217,252,38,0,254,4,204,250,134,255,221,3,61,250,121,254,231,6,214,247,213,252,228,5,45,6,129,6,171,3,163,250,101,3,212,247,36,248,162,8,66,249,148,6,211,3,126,1,101,252,131,0,69,2,208,6,44,255,115,5,251,253,149,252,210,253,109,7,214,255,238,6,183,254,33,4,249,1,36,8,192,252,200,250,172,3,124,1,61,254,172,255,47,250,40,5,41,0,63,0,105,255,46,5,247,4,30,252,127,253,8,251,149,250,113,254,171,250,238,0,216,249,161,1,12,8,29,249,235,7,86,0,188,250,190,247,166,248,25,0,136,7,140,8,31,5,142,253,57,2,157,250,39,2,59,5,164,253,155,248,130,1,24,0,4,3,46,1,170,4,175,252,220,6,67,248,64,252,217,1,150,249,15,4,219,0,167,3,88,7,167,255,170,250,244,252,205,6,241,250,14,247,65,247,56,248,153,253,34,247,192,247,11,247,148,4,143,250,170,255,71,254,106,253,105,5,179,255,0,5,237,251,236,6,108,247,146,247,14,2,151,7,179,8,122,6,67,248,232,5,32,8,213,1,135,248,115,251,216,2,2,2,208,7,240,251,91,252,87,7,235,254,79,254,28,3,99,247,41,2,71,255,58,247,43,7,37,251,83,1,9,3,103,254,253,253,120,250,251,251,188,1,85,1,110,247,5,249,143,6,238,2,250,253,236,1,37,247,165,7,132,255,248,7,95,0,122,5,52,8,133,252,132,249,29,255,37,255,9,251,35,8,107,248,222,8,221,0,190,2,116,3,68,247,23,6,13,8,187,251,29,249,87,6,127,248,140,251,46,249,125,4,251,4,62,6,82,5,165,5,181,247,142,4,4,250,59,5,119,255,26,0,214,249,118,251,105,7,140,250,37,255,68,248,225,247,118,255,188,248,119,3,156,5,191,255,180,8,37,254,193,3,174,255,190,253,33,255,161,247,103,251,130,250,48,2,138,248,223,0,202,247,230,255,100,249,1,251,71,4,179,252,10,247,154,253,115,5,169,250,186,5,75,3,134,5,38,3,203,255,242,3,174,255,155,252,86,249,65,249,138,4,56,8,71,4,212,248,113,1,182,7,120,254,41,5,154,2,30,252,95,8,131,251,76,7,77,254,86,249,130,248,33,251,9,1,163,248,168,8,64,248,214,253,135,255,72,249,169,2,132,0,55,252,195,253,59,4,163,249,151,247,59,251,42,253,34,247,169,248,139,253,166,253,228,8,75,248,63,247,142,254,235,2,255,7,194,8,84,250,106,4,74,3,64,7,98,248,145,253,192,0,135,6,76,0,240,0,12,251,127,254,91,8,133,255,247,6,253,247,141,252,40,8,179,7,8,250,125,8,251,251,219,248,22,2,148,4,248,3,2,4,152,5,132,5,123,7,15,2,76,250,184,248,133,252,194,6,14,248,76,255,141,255,23,6,188,251,34,3,229,255,70,6,77,5,234,1,189,1,220,254,24,7,103,249,203,6,70,255,188,4,57,2,49,3,211,5,238,5,130,253,149,0,254,4,6,253,81,251,123,255,98,3,24,1,176,255,143,2,7,8,135,3,133,8,2,251,103,255,97,251,105,250,118,247,2,6,101,252,204,247,232,251,102,1,113,253,73,247,61,255,94,250,82,249,211,250,42,8,47,252,140,253,187,251,202,3,119,7,63,248,6,250,47,4,120,251,22,251,53,254,146,251,217,5,169,248,139,252,51,1,164,1,24,247,176,0,82,1,135,249,16,6,65,250,49,8,160,2,213,252,192,252,231,0,92,251,200,248,84,254,18,3,77,254,25,5,201,6,110,247,155,0,166,6,12,0,213,249,184,1,239,8,166,250,171,2,24,2,198,8,103,3,67,1,60,7,51,8,218,252,86,251,212,252,71,251,153,6,70,4,238,250,181,253,36,252,39,248,86,8,62,8,144,250,17,4,123,248,12,249,161,252,248,1,36,253,157,255,37,0,144,251,154,6,215,247,21,251,207,249,135,0,181,251,172,252,157,251,178,8,170,247,136,5,103,255,57,4,154,3,210,4,162,2,244,1,230,4,244,251,245,247,216,0,215,4,209,6,36,0,177,6,192,6,145,254,213,250,226,252,160,8,202,1,235,250,140,254,182,7,246,251,167,247,88,3,41,252,144,248,187,248,125,253,161,0,91,255,183,255,209,254,41,4,222,4,249,1,248,250,189,2,199,248,230,252,46,251,41,253,84,2,218,6,79,249,142,255,182,4,252,6,238,252,73,3,138,253,56,250,106,6,80,250,154,4,151,249,229,247,44,6,214,5,68,250,113,5,29,254,80,3,1,0,83,253,174,247,130,251,153,255,108,251,95,0,78,6,149,250,220,253,46,250,187,2,194,249,128,2,33,254,86,251,193,255,129,249,8,5,94,248,112,6,61,248,178,252,122,8,23,3,25,253,123,254,233,7,61,8,69,6,246,253,41,2,60,247,241,0,243,254,139,251,11,253,35,2,89,2,209,250,81,8,127,6,74,247,137,3,64,252,80,4,55,0,83,8,179,250,234,0,227,6,120,250,4,6,213,254,37,252,60,254,164,7,155,248,175,255,180,7,147,1,114,5,203,1,63,248,10,251,64,247,57,253,63,255,132,4,49,1,206,0,7,6,226,8,175,254,206,3,206,4,86,4,6,251,88,8,247,253,158,3,249,252,152,252,152,247,41,248,81,0,203,254,174,253,239,4,199,5,173,254,40,1,107,5,245,250,123,0,153,250,62,250,204,6,122,250,47,8,166,254,162,253,164,3,23,252,85,4,192,248,73,252,115,253,201,253,207,255,37,253,183,254,124,248,89,249,203,251,255,252,97,4,138,247,231,6,124,248,143,252,26,252,229,252,244,250,210,5,111,249,0,8,237,0,237,254,130,255,191,6,144,5,169,7,42,249,248,255,31,248,136,249,221,248,4,2,27,255,16,1,125,5,93,5,0},
} ;

static const unsigned char precomputed_core_invsntrup761_n[precomputed_core_invsntrup761_NUM][crypto_core_INPUTBYTES] = {
  {23,134,222,114,112,111,226,94,165,159,216,93,208,82,195,24,156,127,190,89,151,44,43,218,70,87,49,129,176,248,74,7,131,94,122,221,108,145,39,163,46,251,50,252,235,35,72,142,203,217,235,19,184,217,194,201,159,224,179,202,135,90,239,173,72,27,20,171,86,51,184,222,119,80,133,40,221,1,139,243,142,153,19,112,56,164,183,29,115,13,249,202,54,133,215,86,8,200,128,55,60,24,247,94,86,169,125,169,121,5,222,203,81,221,254,251,174,153,168,193,157,88,95,232,176,27,127,187,1,230,0,143,95,234,242,68,20,159,79,254,7,229,241,164,28,79,215,73,86,77,190,69,76,37,151,59,197,9,225,198,159,50,7,71,103,207,50,199,170,217,144,137,176,245,203,111,80,51,60,232,98,43,165,0,77,215,98,116,172,134,123,152,135,34,26,159,190,209,223,110,109,137,189,10,97,76,196,47,161,66,2,37,184,171,25,57,118,233,20,84,38,11,179,170,114,131,19,239,128,227,68,163,141,40,153,132,163,28,194,49,152,20,143,64,162,225,159,116,11,33,126,40,219,169,137,80,134,8,217,209,114,77,17,243,179,35,155,236,215,114,50,170,164,194,14,84,62,232,15,107,55,73,62,3,95,206,83,68,172,124,93,214,251,62,242,136,60,191,178,140,146,208,141,81,104,156,166,102,49,136,79,98,147,69,186,119,158,88,34,69,82,173,239,0,158,13,48,240,26,181,52,208,139,204,155,35,175,190,210,14,87,158,96,127,243,177,128,71,54,143,103,45,16,157,159,245,139,32,117,215,137,51,69,201,150,128,161,140,162,210,64,64,210,70,91,225,105,193,29,8,37,168,171,253,83,72,4,1,210,149,226,10,163,147,32,10,13,86,28,151,201,31,198,114,116,183,50,220,243,148,29,153,139,49,171,119,178,72,102,217,187,39,41,36,145,234,56,61,11,228,30,12,222,74,238,11,27,222,142,161,186,163,121,106,177,225,124,28,74,165,117,59,64,31,155,151,193,221,204,168,106,43,7,252,58,53,52,68,120,213,123,24,67,91,199,205,90,159,208,52,61,87,199,35,87,160,176,193,108,204,154,147,152,121,5,52,2,127,35,59,17,170,84,157,14,245,222,197,66,18,132,244,67,239,137,48,160,25,63,25,52,180,154,176,249,71,73,238,149,150,5,167,184,171,210,181,190,24,58,174,200,150,27,57,206,246,132,109,123,139,99,110,61,82,80,249,156,231,95,98,242,105,46,57,196,76,78,103,81,76,240,182,134,140,192,194,185,54,55,197,237,250,30,211,202,148,220,234,225,244,127,205,157,73,158,214,242,183,82,223,119,131,125,45,45,221,192,101,119,154,70,169,25,198,162,53,29,87,101,138,220,45,53,198,41,34,32,6,96,206,47,173,240,195,204,114,36,97,217,154,227,205,64,54,25,57,216,185,223,10,9,255,58,229,6,191,70,81,9,29,37,169,225,174,99,129,160,90,159,179,44,174,77,212,21,157,202,185,186,13,127,155,84,39,23,97,47,228,165,86,42,198,114,134,142,7,157,110,211,31,124,150,136,84,144,105,53,19,113,167,215,189,24,10,120,174,151,29,17,14,51,213,162,147,8,61,105,111,13,45,206,190,32,69,194,130,244,4,251,51,156,122,149,128,67,144,83,56,253,98,36,222,217,46,188,240,48,216,84,228,43},
  {165,128,124,77,134,24,59,83,60,1,46,214,62,235,88,1,253,130,109,255,105,146,3,80,47,124,88,189,146,156,38,245,12,151,62,100,131,218,21,7,109,71,222,142,235,34,59,137,154,241,113,157,232,168,2,91,198,180,155,36,138,41,186,152,197,81,88,35,240,128,196,25,186,173,180,82,45,73,95,35,16,149,129,59,65,47,150,217,118,0,162,14,109,70,154,242,219,67,6,216,127,76,209,237,225,109,249,185,61,29,116,241,228,24,149,186,146,94,95,69,159,30,199,82,159,122,231,94,106,109,236,63,31,98,49,133,137,94,108,94,65,109,59,177,41,52,252,233,8,100,150,124,134,50,205,195,222,40,192,28,3,113,93,14,57,79,237,134,58,196,137,64,205,91,32,248,73,126,70,31,93,211,96,15,68,170,78,58,89,13,122,97,254,127,79,25,112,27,242,207,165,133,153,197,76,22,66,239,12,239,212,113,206,7,153,65,72,185,105,51,155,151,255,192,112,136,0,39,12,112,234,163,160,145,141,152,33,124,17,186,245,28,159,237,12,120,184,117,124,99,44,86,124,90,8,148,153,113,77,211,106,45,78,20,78,85,157,201,194,166,171,83,0,122,51,38,68,0,57,255,47,17,220,167,236,55,171,245,76,96,159,12,101,116,172,126,6,119,239,192,197,24,12,189,20,165,208,163,174,67,50,76,39,41,215,116,117,20,49,81,103,125,49,56,15,195,174,228,49,15,201,87,195,111,209,237,147,224,65,5,12,120,128,23,92,22,4,23,84,28,191,12,111,40,170,168,241,212,55,103,134,235,36,211,202,53,250,164,84,191,85,53,232,20,92,183,159,133,237,15,87,186,116,103,122,87,99,92,70,171,14,216,65,47,172,165,62,34,162,246,86,211,233,235,89,6,97,198,176,229,218,171,44,139,191,179,237,85,103,234,62,145,25,198,246,51,217,144,250,115,200,124,22,10,228,119,224,204,41,19,182,236,76,250,12,132,190,93,245,102,160,239,59,120,13,254,203,17,252,208,189,174,25,90,72,142,250,31,173,18,76,35,78,9,111,77,92,81,140,234,199,162,72,233,60,179,99,19,210,78,141,241,221,90,209,88,78,217,96,64,144,66,54,236,40,79,72,144,197,65,35,22,203,19,22,99,154,29,182,125,58,42,82,138,149,109,42,35,178,186,38,143,145,32,199,51,82,168,82,229,69,48,76,14,148,181,167,142,169,209,101,247,236,134,142,187,83,89,121,8,142,178,14,21,63,130,227,159,55,172,135,142,90,48,7,85,219,142,18,10,243,70,166,101,221,112,181,204,161,36,76,97,205,12,10,191,110,3,240,29,230,75,127,184,159,159,185,232,142,244,145,76,65,203,221,75,129,169,252,106,139,102,27,248,36,177,3,145,166,95,29,95,200,237,133,137,173,151,50,132,220,195,127,76,201,70,174,182,252,180,105,243,54,187,78,12,117,212,88,192,73,123,189,184,90,56,182,72,173,27,131,164,209,245,60,161,138,27,199,116,90,229,124,244,223,26,194,50,117,125,250,18,199,206,225,31,47,214,113,12,207,162,164,73,226,125,48,36,84,252,117,200,101,93,22,234,181,22,79,248,202,246,168,138,3,4,202,101,204,205,232,242,79,213,199,176,187,128,49,36,216,25,128,183,30,63,214,58,232,21,60,44,251,68,2,211,52,236,7,148,56},
  {15,40,143,222,21,143,192,255,57,184,178,151,85,131,186,231,63,123,34,92,146,34,202,178,180,12,121,59,124,182,208,7,109,225,68,65,68,237,205,225,96,62,101,77,37,255,208,56,109,122,174,181,192,72,108,170,46,59,159,112,74,51,35,161,1,158,254,175,90,64,226,5,210,124,150,82,251,89,82,14,137,179,108,38,217,158,9,217,170,14,22,163,104,225,221,229,107,2,53,30,176,169,51,157,165,72,15,170,9,214,124,161,161,85,43,56,52,6,74,14,233,82,1,100,73,113,91,205,187,222,238,90,58,36,122,36,84,243,152,33,115,152,101,249,188,55,66,151,59,137,28,210,165,233,117,60,226,55,144,244,108,112,201,185,221,22,194,51,106,196,49,44,252,237,98,62,220,21,14,66,247,67,229,224,11,11,56,215,202,131,235,135,192,130,147,79,203,96,109,136,14,163,242,150,97,225,219,240,176,149,248,2,237,74,38,50,96,120,34,87,247,238,2,148,157,185,15,25,139,47,188,28,100,204,221,69,119,63,148,245,159,37,226,147,58,75,228,128,8,17,170,250,236,113,212,48,43,38,190,51,17,91,90,217,182,98,12,244,89,66,160,171,101,18,120,173,28,244,54,48,153,179,100,111,207,28,147,72,49,10,79,78,251,144,201,197,182,238,44,109,247,54,137,221,168,235,83,187,74,127,81,89,160,198,83,235,82,93,122,204,81,168,157,196,75,235,238,169,127,59,205,217,237,9,117,130,129,125,19,25,89,164,88,107,176,1,153,112,84,194,115,221,236,105,64,34,100,193,78,157,29,247,138,117,232,18,92,137,187,49,219,142,119,127,105,31,192,200,23,217,109,44,83,37,98,182,52,178,8,141,147,241,158,17,28,144,251,171,193,246,238,181,74,141,163,188,47,164,129,109,111,12,7,135,65,144,137,33,149,206,215,57,73,139,26,199,176,40,217,161,96,135,35,157,33,80,199,28,0,241,229,192,118,118,63,102,225,237,43,5,254,81,100,64,200,173,242,17,222,100,154,149,210,96,70,203,152,114,99,154,211,5,39,237,210,233,88,190,121,156,233,236,62,130,104,9,108,191,155,42,250,83,177,107,59,243,169,170,66,121,50,238,233,22,68,140,241,35,200,132,128,17,52,21,116,246,123,140,238,163,96,196,82,245,249,223,66,75,14,207,55,201,88,172,6,64,7,215,131,7,161,30,165,120,120,109,21,191,255,145,152,61,231,142,49,84,216,111,54,241,182,22,103,182,156,62,54,249,158,141,194,8,101,106,236,77,40,74,14,45,23,52,34,245,75,174,7,55,235,186,69,73,231,160,37,181,62,172,168,21,103,161,142,42,63,67,153,17,231,115,220,39,102,88,83,188,220,223,178,222,182,213,148,225,66,202,230,237,250,192,50,103,31,210,197,13,175,3,172,248,74,247,245,249,59,223,29,58,184,95,66,107,106,84,224,57,132,152,216,155,61,8,229,64,105,197,152,168,131,171,119,57,235,123,223,183,117,90,226,60,185,22,142,255,225,160,177,168,182,21,216,220,46,149,58,157,108,5,174,34,111,241,50,126,71,100,65,195,17,74,58,252,176,133,244,144,74,249,32,161,22,169,209,72,1,244,153,191,121,173,21,27,153,162,52,65,82,124,236,232,62,151,107,62,157,68,167,160,87,107,188,207,191,100,108,96,246,200,102,122,163},
  {6,101,200,25,20,139,83,75,153,124,216,34,162,154,93,33,12,83,77,233,225,16,96,122,82,59,42,100,46,252,64,56,209,178,26,78,210,205,16,17,194,251,77,46,105,147,25,204,81,62,165,96,235,142,21,149,232,71,85,154,125,68,50,145,124,59,84,6,6,198,41,103,133,15,192,104,142,56,122,39,16,60,104,209,176,113,106,94,183,230,216,198,158,14,52,248,107,46,187,77,82,82,26,171,32,101,129,157,234,233,33,18,217,55,215,82,56,184,197,98,218,143,253,19,127,203,243,140,169,26,89,246,41,151,118,208,91,202,222,129,21,35,228,24,61,147,38,44,59,193,18,166,30,143,122,59,107,99,88,218,18,104,127,89,41,248,22,103,232,31,82,160,165,223,171,175,234,24,52,50,79,96,101,251,245,59,11,65,161,4,106,231,117,75,167,30,44,2,101,66,134,54,242,48,137,238,240,230,117,226,10,164,151,49,173,150,18,244,163,200,211,116,111,161,16,101,219,151,93,33,122,110,72,174,191,106,176,212,148,71,97,99,53,145,55,131,9,184,53,76,107,248,255,37,42,117,86,70,131,196,92,46,154,212,229,33,219,35,93,139,47,54,12,83,252,86,28,42,79,173,65,64,121,109,128,17,121,139,234,132,95,77,19,107,238,178,203,67,135,229,62,70,35,254,4,232,151,22,170,234,16,249,110,51,241,179,109,254,123,1,30,214,15,144,99,212,174,142,187,36,90,147,4,36,87,117,16,251,173,34,179,246,159,185,127,90,145,159,85,126,223,184,101,185,40,201,105,24,66,134,208,3,126,70,229,97,254,199,241,62,57,217,204,99,56,65,92,199,210,15,72,188,139,2,27,93,228,50,84,204,68,124,128,253,143,133,122,115,140,131,19,44,132,18,172,145,44,174,129,61,177,13,156,16,44,7,5,219,49,14,24,247,151,241,187,129,53,200,155,32,255,249,133,164,12,34,56,40,54,67,191,212,144,197,86,60,17,19,94,75,220,228,11,251,21,40,175,37,130,73,246,68,54,235,207,4,118,25,154,52,168,71,171,24,130,243,182,55,38,216,194,36,214,139,28,149,29,52,62,19,133,81,18,127,134,9,122,245,80,173,164,38,37,90,96,34,37,205,27,54,9,192,216,85,250,98,15,30,118,211,145,13,120,191,91,252,166,126,59,77,156,185,55,183,235,206,208,36,65,201,45,106,208,241,125,69,250,21,171,164,44,249,80,178,122,200,247,236,159,223,124,64,133,236,51,198,113,17,153,166,45,108,27,159,168,117,201,31,123,51,72,133,171,186,215,225,164,11,87,111,76,10,178,219,114,159,50,26,210,121,95,177,152,68,57,236,133,200,39,66,209,74,74,141,39,186,41,160,53,143,86,195,129,127,12,171,231,250,27,120,52,4,139,231,32,41,72,255,33,204,115,108,162,144,85,231,219,62,3,195,146,44,208,214,34,127,53,233,98,217,210,71,234,64,65,97,63,43,30,180,156,36,223,33,189,50,60,241,2,209,8,47,252,199,16,204,105,60,40,62,18,203,120,21,143,205,107,37,99,217,255,92,43,97,192,7,83,53,182,201,119,107,14,178,210,209,102,93,207,107,233,13,234,230,19,214,138,222,14,106,147,31,117,190,199,242,42,250,11,158,208,224,187,210,239,241,128,187,124,215,142,199,234,97,94,110,245,125,222,129,84},
} ;

static const unsigned char precomputed_core_invsntrup761_k[precomputed_core_invsntrup761_NUM][crypto_core_KEYBYTES] = {
  {},
  {},
  {},
  {},
} ;

static const unsigned char precomputed_core_invsntrup761_c[precomputed_core_invsntrup761_NUM][crypto_core_CONSTBYTES] = {
  {},
  {},
  {},
  {},
} ;

static void test_core_invsntrup761_impl(long long impl)
{
  unsigned char *h = test_core_invsntrup761_h;
  unsigned char *n = test_core_invsntrup761_n;
  unsigned char *k = test_core_invsntrup761_k;
  unsigned char *c = test_core_invsntrup761_c;
  unsigned char *h2 = test_core_invsntrup761_h2;
  unsigned char *n2 = test_core_invsntrup761_n2;
  unsigned char *k2 = test_core_invsntrup761_k2;
  unsigned char *c2 = test_core_invsntrup761_c2;
  long long hlen = crypto_core_OUTPUTBYTES;
  long long nlen = crypto_core_INPUTBYTES;
  long long klen = crypto_core_KEYBYTES;
  long long clen = crypto_core_CONSTBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_core_invsntrup761_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_core = ntruprime_dispatch_core_invsntrup761(impl);
    printf("core_invsntrup761 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_core_invsntrup761_implementation(impl),ntruprime_dispatch_core_invsntrup761_compiler(impl));
  } else {
    crypto_core = ntruprime_core_invsntrup761;
    printf("core_invsntrup761 selected implementation %s compiler %s\n",ntruprime_core_invsntrup761_implementation(),ntruprime_core_invsntrup761_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 512;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(h2,h,hlen);
      input_prepare(n2,n,nlen);
      input_prepare(k2,k,klen);
      input_prepare(c2,c,clen);
      secret(n,nlen);
      secret(k,klen);
      secret(c,clen);
      crypto_core(h,n,k,c);
      public(n,nlen);
      public(k,klen);
      public(c,clen);
      public(h,hlen);
      checksum(h,hlen);
      output_compare(h2,h,hlen,"crypto_core");
      input_compare(n2,n,nlen,"crypto_core");
      input_compare(k2,k,klen,"crypto_core");
      input_compare(c2,c,clen,"crypto_core");

      double_canary(h2,h,hlen);
      double_canary(n2,n,nlen);
      double_canary(k2,k,klen);
      double_canary(c2,c,clen);
      secret(n2,nlen);
      secret(k2,klen);
      secret(c2,clen);
      crypto_core(h2,n2,k2,c2);
      public(n2,nlen);
      public(k2,klen);
      public(c2,clen);
      public(h2,hlen);
      if (memcmp(h2,h,hlen) != 0) fail("failure: crypto_core is nondeterministic\n");
    }
    checksum_expected(core_invsntrup761_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_core_invsntrup761_NUM;++precomp) {
    output_prepare(h2,h,crypto_core_OUTPUTBYTES);
    input_prepare(n2,n,crypto_core_INPUTBYTES);
    memcpy(n,precomputed_core_invsntrup761_n[precomp],crypto_core_INPUTBYTES);
    memcpy(n2,precomputed_core_invsntrup761_n[precomp],crypto_core_INPUTBYTES);
    input_prepare(k2,k,crypto_core_KEYBYTES);
    memcpy(k,precomputed_core_invsntrup761_k[precomp],crypto_core_KEYBYTES);
    memcpy(k2,precomputed_core_invsntrup761_k[precomp],crypto_core_KEYBYTES);
    input_prepare(c2,c,crypto_core_CONSTBYTES);
    memcpy(c,precomputed_core_invsntrup761_c[precomp],crypto_core_CONSTBYTES);
    memcpy(c2,precomputed_core_invsntrup761_c[precomp],crypto_core_CONSTBYTES);
    crypto_core(h,n,k,c);
    if (memcmp(h,precomputed_core_invsntrup761_h[precomp],crypto_core_OUTPUTBYTES)) {
      fail("failure: crypto_core fails precomputed test vectors\n");
      printf("expected h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",((unsigned char *) precomputed_core_invsntrup761_h[precomp])[pos]);
      printf("\n");
      printf("received h: ");
      for (long long pos = 0;pos < crypto_core_OUTPUTBYTES;++pos) printf("%02x",h[pos]);
      printf("\n");
    }
    output_compare(h2,h,crypto_core_OUTPUTBYTES,"crypto_core");
    input_compare(n2,n,crypto_core_INPUTBYTES,"crypto_core");
    input_compare(k2,k,crypto_core_KEYBYTES,"crypto_core");
    input_compare(c2,c,crypto_core_CONSTBYTES,"crypto_core");
  }
}

void test_core_invsntrup761(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"core")) return;
  if (targetp && strcmp(targetp,"invsntrup761")) return;
  storage_core_invsntrup761_h = callocplus(crypto_core_OUTPUTBYTES);
  test_core_invsntrup761_h = aligned(storage_core_invsntrup761_h,crypto_core_OUTPUTBYTES);
  if (crypto_core_OUTPUTBYTES > maxalloc) maxalloc = crypto_core_OUTPUTBYTES;
  storage_core_invsntrup761_n = callocplus(crypto_core_INPUTBYTES);
  test_core_invsntrup761_n = aligned(storage_core_invsntrup761_n,crypto_core_INPUTBYTES);
  if (crypto_core_INPUTBYTES > maxalloc) maxalloc = crypto_core_INPUTBYTES;
  storage_core_invsntrup761_k = callocplus(crypto_core_KEYBYTES);
  test_core_invsntrup761_k = aligned(storage_core_invsntrup761_k,crypto_core_KEYBYTES);
  if (crypto_core_KEYBYTES > maxalloc) maxalloc = crypto_core_KEYBYTES;
  storage_core_invsntrup761_c = callocplus(crypto_core_CONSTBYTES);
  test_core_invsntrup761_c = aligned(storage_core_invsntrup761_c,crypto_core_CONSTBYTES);
  if (crypto_core_CONSTBYTES > maxalloc) maxalloc = crypto_core_CONSTBYTES;
  storage_core_invsntrup761_h2 = callocplus(maxalloc);
  test_core_invsntrup761_h2 = aligned(storage_core_invsntrup761_h2,crypto_core_OUTPUTBYTES);
  storage_core_invsntrup761_n2 = callocplus(maxalloc);
  test_core_invsntrup761_n2 = aligned(storage_core_invsntrup761_n2,crypto_core_INPUTBYTES);
  storage_core_invsntrup761_k2 = callocplus(maxalloc);
  test_core_invsntrup761_k2 = aligned(storage_core_invsntrup761_k2,crypto_core_KEYBYTES);
  storage_core_invsntrup761_c2 = callocplus(maxalloc);
  test_core_invsntrup761_c2 = aligned(storage_core_invsntrup761_c2,crypto_core_CONSTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("core_invsntrup761 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_core_invsntrup761();++impl)
      forked(test_core_invsntrup761_impl,impl);
    ++test_core_invsntrup761_h;
    ++test_core_invsntrup761_n;
    ++test_core_invsntrup761_k;
    ++test_core_invsntrup761_c;
    ++test_core_invsntrup761_h2;
    ++test_core_invsntrup761_n2;
    ++test_core_invsntrup761_k2;
    ++test_core_invsntrup761_c2;
  }
  free(storage_core_invsntrup761_c2);
  free(storage_core_invsntrup761_k2);
  free(storage_core_invsntrup761_n2);
  free(storage_core_invsntrup761_h2);
  free(storage_core_invsntrup761_c);
  free(storage_core_invsntrup761_k);
  free(storage_core_invsntrup761_n);
  free(storage_core_invsntrup761_h);
}
#undef crypto_core_OUTPUTBYTES
#undef crypto_core_INPUTBYTES
#undef crypto_core_KEYBYTES
#undef crypto_core_CONSTBYTES

