/*  $Id: lat_lon_country.inc 612552 2020-07-23 15:34:00Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  Jonathan Kans et al.
 *
 * File Description:
 *   Built-in copy of lat_lon_country.txt.
 *
 */

static const char* const s_DefaultLatLonCountryText[] = {
    "- Made with Natural Earth.",
    "1",
    "Afghanistan",
    "	39	69	72",
    "	38	63	75",
    "	37	62	75",
    "	36	60	75",
    "	35	59	75",
    "	34	59	72",
    "	33	59	72",
    "	32	59	71",
    "	31	59	70",
    "	30	59	70",
    "	29	59	67",
    "	28	59	67",
    "Albania",
    "	43	18	21",
    "	42	18	21",
    "	41	18	22",
    "	40	18	22",
    "	39	18	22",
    "	38	18	21",
    "Algeria",
    "	38	5	8",
    "	37	-1	9",
    "	36	-3	9",
    "	35	-3	9",
    "	34	-3	9",
    "	33	-3	10",
    "	32	-4	10",
    "	31	-6	10",
    "	30	-9	10",
    "	29	-9	10",
    "	28	-9	10",
    "	27	-9	10",
    "	26	-9	11",
    "	25	-9	12",
    "	24	-7	12",
    "	23	-5	12",
    "	22	-4	12",
    "	21	-2	12",
    "	20	-1	10",
    "	19	0	8",
    "	18	1	7",
    "	17	2	4",
    "American Samoa",
    "	-10	-172	-170",
    "	-11	-172	-170",
    "	-12	-172	-170",
    "	-13	-171	-167",
    "	-14	-171	-167",
    "	-15	-171	-167",
    "Andorra",
    "	43	0	2",
    "	42	0	2",
    "	41	0	2",
    "Angola",
    "	-3	11	14",
    "	-4	11	17",
    "	-5	11	17	19	21",
    "	-6	11	22",
    "	-7	11	22",
    "	-8	11	23",
    "	-9	11	25",
    "	-10	11	25",
    "	-11	11	25",
    "	-12	11	25",
    "	-13	11	25",
    "	-14	10	25",
    "	-15	10	23",
    "	-16	10	24",
    "	-17	10	24",
    "	-18	10	24",
    "	-19	19	22",
    "Anguilla",
    "	19	-64	-61",
    "	18	-64	-61",
    "	17	-64	-61",
    "Antarctica",
    "	-59	-47	-43",
    "	-60	-59	-53	-47	-43",
    "	-61	-62	-53	-47	-43",
    "	-62	-62	-53",
    "	-63	-65	-54",
    "	-64	-66	-54	51	56	99	104	110	114",
    "	-65	-69	-56	47	58	86	117	119	144",
    "	-66	-70	-59	42	70	79	147",
    "	-67	-91	-89	-73	-59	31	35	38	71	76	156",
    "	-68	-91	-89	-76	-60	31	161",
    "	-69	-91	-89	-77	-60	-11	168",
    "	-70	-103	-95	-77	-59	-13	171",
    "	-71	-106	-87	-81	-79	-77	-58	-15	171",
    "	-72	-128	-117	-115	-112	-106	-58	-22	-19	-17	171",
    "	-73	-137	-109	-106	-58	-23	171",
    "	-74	-147	-58	-27	170",
    "	-75	-150	-59	-32	166",
    "	-76	-159	-62	-48	-44	-36	170",
    "	-77	-165	-65	-51	-42	-37	170",
    "	-78	-165	-64	-62	-58	-52	-41	-37	170",
    "	-79	-165	-58	-55	168",
    "	-80	-165	-58	-55	164",
    "	-81	-175	-170	-164	169",
    "	-82	-175	177",
    "	-83	-180	180",
    "	-84	-180	180",
    "	-85	-180	180",
    "	-86	-180	180",
    "	-87	-180	180",
    "	-88	-180	180",
    "	-89	-180	180",
    "	-90	-180	180",
    "	-90	-180	180",
    "Antigua and Barbuda",
    "	18	-62	-60",
    "	17	-62	-60",
    "	16	-62	-60",
    "	15	-62	-60",
    "Argentina",
    "	-20	-67	-61",
    "	-21	-68	-60",
    "	-22	-68	-59",
    "	-23	-69	-57",
    "	-24	-69	-52",
    "	-25	-69	-52",
    "	-26	-70	-52",
    "	-27	-70	-52",
    "	-28	-71	-52",
    "	-29	-71	-54",
    "	-30	-71	-55",
    "	-31	-71	-56",
    "	-32	-71	-56",
    "	-33	-71	-56",
    "	-34	-71	-56",
    "	-35	-72	-55",
    "	-36	-72	-55",
    "	-37	-72	-55",
    "	-38	-72	-55",
    "	-39	-72	-56",
    "	-40	-72	-60",
    "	-41	-73	-61",
    "	-42	-73	-61",
    "	-43	-73	-62",
    "	-44	-73	-63",
    "	-45	-73	-64",
    "	-46	-73	-64",
    "	-47	-74	-64",
    "	-48	-74	-64",
    "	-49	-74	-64",
    "	-50	-74	-66",
    "	-51	-74	-66",
    "	-52	-73	-66",
    "	-53	-71	-62",
    "	-54	-69	-62",
    "	-55	-69	-62",
    "	-56	-67	-65",
    "Armenia",
    "	42	42	46",
    "	41	42	46",
    "	40	42	47",
    "	39	42	47",
    "	38	43	47",
    "	37	45	47",
    "Aruba",
    "	13	-71	-68",
    "	12	-71	-68",
    "	11	-71	-68",
    "Ashmore and Cartier Islands",
    "	-11	122	124",
    "	-12	122	124",
    "	-13	122	124",
    "Australia",
    "	-8	141	143",
    "	-9	131	133	141	143",
    "	-10	129	137	140	144",
    "	-11	129	137	140	144",
    "	-12	124	137	140	144",
    "	-13	123	137	140	146",
    "	-14	123	138	140	146",
    "	-15	121	146",
    "	-16	121	147",
    "	-17	120	147",
    "	-18	118	149",
    "	-19	114	150",
    "	-20	112	151",
    "	-21	112	151",
    "	-22	112	152",
    "	-23	112	154",
    "	-24	111	154",
    "	-25	111	154",
    "	-26	111	154",
    "	-27	112	154",
    "	-28	112	154",
    "	-29	113	154",
    "	-30	113	154	158	160",
    "	-31	113	154	158	160",
    "	-32	113	154	158	160",
    "	-33	113	129	131	153",
    "	-34	113	125	133	152",
    "	-35	113	124	134	152",
    "	-36	115	119	134	151",
    "	-37	135	151",
    "	-38	138	151",
    "	-39	139	149",
    "	-40	142	149",
    "	-41	142	149",
    "	-42	143	149",
    "	-43	144	149",
    "	-44	144	149",
    "	-53	157	159",
    "	-54	157	159",
    "	-55	157	159",
    "Australia: Australian Capital Territory",
    "	-34	147	150",
    "	-35	147	150",
    "	-36	147	150",
    "Australia: Jervis Bay Territory",
    "	-34	149	151",
    "	-35	149	151",
    "	-36	149	151",
    "Australia: New South Wales",
    "	-27	147	154",
    "	-28	140	154",
    "	-29	140	154",
    "	-30	140	154",
    "	-31	140	154",
    "	-32	140	154",
    "	-33	140	153",
    "	-34	140	152",
    "	-35	140	152",
    "	-36	142	151",
    "	-37	143	151",
    "	-38	147	151",
    "Australia: Northern Territory",
    "	-9	131	133",
    "	-10	129	137",
    "	-11	129	137",
    "	-12	128	137",
    "	-13	128	137",
    "	-14	128	138",
    "	-15	128	139",
    "	-16	128	139",
    "	-17	128	139",
    "	-18	128	139",
    "	-19	128	139",
    "	-20	128	139",
    "	-21	128	139",
    "	-22	128	139",
    "	-23	128	139",
    "	-24	128	139",
    "	-25	128	139",
    "	-26	128	139",
    "	-27	128	139",
    "Australia: Queensland",
    "	-9	141	143",
    "	-10	140	144",
    "	-11	140	144",
    "	-12	140	144",
    "	-13	140	146",
    "	-14	140	146",
    "	-15	137	146",
    "	-16	137	147",
    "	-17	137	147",
    "	-18	137	149",
    "	-19	137	150",
    "	-20	137	151",
    "	-21	137	151",
    "	-22	137	152",
    "	-23	137	154",
    "	-24	137	154",
    "	-25	137	154",
    "	-26	137	154",
    "	-27	137	154",
    "	-28	140	154",
    "	-29	140	154",
    "	-30	140	152",
    "Australia: South Australia",
    "	-25	128	142",
    "	-26	128	142",
    "	-27	128	142",
    "	-28	128	142",
    "	-29	128	142",
    "	-30	128	142",
    "	-31	128	142",
    "	-32	128	142",
    "	-33	131	142",
    "	-34	133	142",
    "	-35	134	142",
    "	-36	134	141",
    "	-37	135	141",
    "	-38	138	141",
    "	-39	139	141",
    "Australia: Tasmania",
    "	-38	142	149",
    "	-39	142	149",
    "	-40	142	149",
    "	-41	142	149",
    "	-42	143	149",
    "	-43	144	149",
    "	-44	144	149",
    "Australia: Victoria",
    "	-32	139	141",
    "	-33	139	144",
    "	-34	139	148",
    "	-35	139	149",
    "	-36	139	150",
    "	-37	139	150",
    "	-38	139	150",
    "	-39	139	148",
    "	-40	145	147",
    "Australia: Western Australia",
    "	-12	124	128",
    "	-13	123	130",
    "	-14	123	130",
    "	-15	121	130",
    "	-16	121	130",
    "	-17	120	130",
    "	-18	118	130",
    "	-19	114	130",
    "	-20	112	130",
    "	-21	112	130",
    "	-22	112	130",
    "	-23	112	130",
    "	-24	111	130",
    "	-25	111	130",
    "	-26	111	130",
    "	-27	112	130",
    "	-28	112	130",
    "	-29	113	130",
    "	-30	113	130",
    "	-31	113	130",
    "	-32	113	130",
    "	-33	113	129",
    "	-34	113	125",
    "	-35	113	124",
    "	-36	115	119",
    "Austria",
    "	50	13	16",
    "	49	11	18",
    "	48	8	18",
    "	47	8	18",
    "	46	8	18",
    "	45	8	17",
    "Azerbaijan",
    "	42	43	50",
    "	41	43	51",
    "	40	43	51",
    "	39	43	51",
    "	38	43	50",
    "	37	44	50",
    "Bahamas",
    "	27	-79	-76",
    "	26	-80	-75",
    "	25	-80	-73",
    "	24	-80	-72",
    "	23	-80	-71",
    "	22	-80	-71",
    "	21	-76	-71",
    "	20	-74	-71",
    "	19	-74	-72",
    "Bahrain",
    "	27	49	51",
    "	26	49	51",
    "	25	49	51",
    "	24	49	51",
    "Baker Island",
    "	1	-177	-175",
    "	0	-177	-175",
    "	-1	-177	-175",
    "Bangladesh",
    "	27	87	90",
    "	26	87	93",
    "	25	87	93",
    "	24	87	93",
    "	23	87	93",
    "	22	87	93",
    "	21	87	93",
    "	20	88	93",
    "	19	91	93",
    "Barbados",
    "	14	-60	-58",
    "	13	-60	-58",
    "	12	-60	-58",
    "Bassas da India",
    "	-20	38	40",
    "	-21	38	40",
    "	-22	38	40",
    "Belarus",
    "	57	26	30",
    "	56	25	32",
    "	55	23	32",
    "	54	22	33",
    "	53	22	33",
    "	52	22	33",
    "	51	22	32",
    "	50	22	31",
    "Belgium",
    "	52	1	6",
    "	51	1	7",
    "	50	1	7",
    "	49	1	7",
    "	48	3	6",
    "Belize",
    "	19	-90	-86",
    "	18	-90	-86",
    "	17	-90	-86",
    "	16	-90	-86",
    "	15	-90	-87",
    "	14	-90	-87",
    "Benin",
    "	13	1	4",
    "	12	-1	4",
    "	11	-1	4",
    "	10	-1	4",
    "	9	-1	4",
    "	8	0	4",
    "	7	0	3",
    "	6	0	3",
    "	5	0	3",
    "Bermuda",
    "	33	-65	-63",
    "	32	-65	-63",
    "	31	-65	-63",
    "Bhutan",
    "	29	88	92",
    "	28	87	93",
    "	27	87	93",
    "	26	87	93",
    "	25	87	93",
    "Bolivia",
    "	-8	-67	-64",
    "	-9	-70	-64",
    "	-10	-70	-63",
    "	-11	-70	-61",
    "	-12	-70	-59",
    "	-13	-70	-59",
    "	-14	-70	-59",
    "	-15	-70	-57",
    "	-16	-70	-56",
    "	-17	-70	-56",
    "	-18	-70	-56",
    "	-19	-70	-56",
    "	-20	-69	-56",
    "	-21	-69	-56",
    "	-22	-69	-61",
    "	-23	-69	-61",
    "Borneo",
    "	6	113	116",
    "	5	113	116",
    "	4	113	116",
    "	3	113	116",
    "Borneo",
    "	5	114	118",
    "	4	107	109	114	118",
    "	3	107	110	113	119",
    "	2	107	120",
    "	1	107	120",
    "	0	107	120",
    "	-1	107	120",
    "	-2	107	118",
    "	-3	109	117",
    "	-4	109	117",
    "	-5	113	117",
    "Borneo",
    "	8	115	118",
    "	7	115	119",
    "	6	114	120",
    "	5	112	120",
    "	4	111	120",
    "	3	108	119",
    "	2	108	116",
    "	1	108	116",
    "	0	108	115",
    "	-1	109	112",
    "Bosnia and Herzegovina",
    "	46	14	19",
    "	45	14	20",
    "	44	14	20",
    "	43	14	20",
    "	42	15	20",
    "	41	16	19",
    "Botswana",
    "	-16	22	26",
    "	-17	19	26",
    "	-18	19	27",
    "	-19	19	28",
    "	-20	19	30",
    "	-21	18	30",
    "	-22	18	30",
    "	-23	18	30",
    "	-24	18	28",
    "	-25	18	27",
    "	-26	19	26",
    "	-27	19	23",
    "Bouvet Island",
    "	-53	2	4",
    "	-54	2	4",
    "	-55	2	4",
    "Brazil",
    "	6	-61	-58",
    "	5	-65	-58	-52	-50",
    "	4	-65	-58	-53	-49",
    "	3	-69	-49",
    "	2	-70	-48",
    "	1	-71	-45	-30	-28",
    "	0	-71	-43	-30	-28",
    "	-1	-71	-38	-30	-28",
    "	-2	-70	-37	-33	-31",
    "	-3	-73	-35	-33	-31",
    "	-4	-74	-31",
    "	-5	-74	-33",
    "	-6	-75	-33",
    "	-7	-75	-33",
    "	-8	-75	-33",
    "	-9	-74	-33",
    "	-10	-74	-34",
    "	-11	-73	-35",
    "	-12	-71	-36",
    "	-13	-65	-36",
    "	-14	-63	-37",
    "	-15	-61	-37",
    "	-16	-61	-37",
    "	-17	-61	-37",
    "	-18	-59	-38",
    "	-19	-59	-38	-30	-27",
    "	-20	-59	-38	-30	-27",
    "	-21	-59	-39	-30	-27",
    "	-22	-58	-39",
    "	-23	-58	-39",
    "	-24	-56	-42",
    "	-25	-56	-45",
    "	-26	-56	-46",
    "	-27	-57	-47",
    "	-28	-58	-47",
    "	-29	-58	-47",
    "	-30	-58	-48",
    "	-31	-58	-49",
    "	-32	-57	-49",
    "	-33	-54	-51",
    "	-34	-54	-51",
    "British Indian Ocean Territory",
    "	-4	70	73",
    "	-5	70	73",
    "	-6	70	73",
    "	-7	70	73",
    "	-8	71	73",
    "British Virgin Islands",
    "	19	-65	-63",
    "	18	-65	-63",
    "	17	-65	-63",
    "Brunei",
    "	6	113	116",
    "	5	113	116",
    "	4	113	116",
    "	3	113	116",
    "Bulgaria",
    "	45	21	28",
    "	44	21	29",
    "	43	21	29",
    "	42	21	29",
    "	41	21	29",
    "	40	21	29",
    "Burkina Faso",
    "	16	-1	1",
    "	15	-3	1",
    "	14	-5	2",
    "	13	-5	3",
    "	12	-6	3",
    "	11	-6	3",
    "	10	-6	3",
    "	9	-6	1",
    "	8	-5	-1",
    "Burundi",
    "	-1	27	31",
    "	-2	27	31",
    "	-3	27	31",
    "	-4	28	31",
    "	-5	28	31",
    "Cambodia",
    "	15	101	108",
    "	14	101	108",
    "	13	101	108",
    "	12	101	108",
    "	11	101	108",
    "	10	101	107",
    "	9	102	107",
    "Cameroon",
    "	14	13	15",
    "	13	13	16",
    "	12	12	16",
    "	11	12	16",
    "	10	11	16",
    "	9	11	16",
    "	8	9	16",
    "	7	8	16",
    "	6	7	16",
    "	5	7	16",
    "	4	7	16",
    "	3	7	17",
    "	2	8	17",
    "	1	8	17",
    "	0	14	17",
    "Canada",
    "	84	-78	-67",
    "	83	-90	-60",
    "	82	-96	-60",
    "	81	-101	-60",
    "	80	-106	-61",
    "	79	-115	-108	-106	-66",
    "	78	-121	-69",
    "	77	-124	-73",
    "	76	-124	-74",
    "	75	-125	-76",
    "	74	-125	-75",
    "	73	-126	-73",
    "	72	-126	-69",
    "	71	-132	-66",
    "	70	-142	-65",
    "	69	-142	-63",
    "	68	-142	-61",
    "	67	-142	-60",
    "	66	-142	-60",
    "	65	-142	-60",
    "	64	-142	-61",
    "	63	-142	-62",
    "	62	-142	-63",
    "	61	-142	-89	-84	-63",
    "	60	-142	-91	-81	-62",
    "	59	-142	-91	-81	-61",
    "	58	-140	-88	-81	-60",
    "	57	-138	-86	-81	-59",
    "	56	-133	-57",
    "	55	-134	-56",
    "	54	-134	-54",
    "	53	-134	-54",
    "	52	-134	-54",
    "	51	-133	-54",
    "	50	-132	-52",
    "	49	-129	-51",
    "	48	-128	-51",
    "	47	-126	-51",
    "	46	-90	-51",
    "	45	-86	-58	-56	-51",
    "	44	-84	-58",
    "	43	-84	-73	-67	-58",
    "	42	-84	-75	-67	-63	-61	-58",
    "	41	-84	-77",
    "	40	-84	-80",
    "Canada: Alberta",
    "	61	-121	-109",
    "	60	-121	-109",
    "	59	-121	-109",
    "	58	-121	-109",
    "	57	-121	-109",
    "	56	-121	-109",
    "	55	-121	-109",
    "	54	-121	-109",
    "	53	-121	-109",
    "	52	-121	-109",
    "	51	-119	-109",
    "	50	-118	-109",
    "	49	-116	-109",
    "	48	-115	-109",
    "	47	-115	-109",
    "Canada: British Columbia",
    "	61	-140	-119",
    "	60	-140	-119",
    "	59	-140	-119",
    "	58	-140	-119",
    "	57	-138	-119",
    "	56	-134	-119",
    "	55	-134	-119",
    "	54	-134	-117",
    "	53	-134	-116",
    "	52	-134	-114",
    "	51	-133	-113",
    "	50	-132	-113",
    "	49	-129	-113",
    "	48	-128	-113",
    "	47	-126	-113",
    "Canada: Manitoba",
    "	61	-103	-93",
    "	60	-103	-93",
    "	59	-103	-91",
    "	58	-103	-88",
    "	57	-103	-87",
    "	56	-103	-87",
    "	55	-103	-87",
    "	54	-103	-89",
    "	53	-102	-90",
    "	52	-102	-92",
    "	51	-102	-93",
    "	50	-102	-94",
    "	49	-102	-94",
    "	48	-102	-94",
    "	47	-102	-94",
    "Canada: New Brunswick",
    "	49	-67	-63",
    "	48	-70	-63",
    "	47	-70	-62",
    "	46	-70	-62",
    "	45	-68	-62",
    "	44	-68	-63",
    "	43	-67	-65",
    "Canada: Newfoundland and Labrador",
    "	61	-65	-63",
    "	60	-65	-62",
    "	59	-65	-61",
    "	58	-65	-60",
    "	57	-65	-59",
    "	56	-68	-57",
    "	55	-68	-56",
    "	54	-68	-54",
    "	53	-68	-54",
    "	52	-68	-54",
    "	51	-68	-54",
    "	50	-65	-63	-59	-52",
    "	49	-60	-51",
    "	48	-60	-51",
    "	47	-60	-51",
    "	46	-60	-51",
    "	45	-56	-51",
    "Canada: Northwest Territories",
    "	79	-115	-109",
    "	78	-121	-109",
    "	77	-124	-109",
    "	76	-124	-109",
    "	75	-125	-109",
    "	74	-125	-109",
    "	73	-126	-109",
    "	72	-126	-109",
    "	71	-132	-109",
    "	70	-136	-109",
    "	69	-137	-109",
    "	68	-137	-115	-113	-111",
    "	67	-137	-113",
    "	66	-137	-108",
    "	65	-135	-100",
    "	64	-134	-100",
    "	63	-133	-100",
    "	62	-131	-100",
    "	61	-130	-101",
    "	60	-129	-101",
    "	59	-127	-101",
    "Canada: Nova Scotia",
    "	48	-61	-59",
    "	47	-65	-58",
    "	46	-66	-58",
    "	45	-67	-58",
    "	44	-67	-58",
    "	43	-67	-58",
    "	42	-67	-63	-61	-58",
    "Canada: Nunavut",
    "	84	-78	-67",
    "	83	-90	-60",
    "	82	-96	-60",
    "	81	-101	-60",
    "	80	-106	-61",
    "	79	-111	-108	-106	-66",
    "	78	-111	-69",
    "	77	-111	-73",
    "	76	-111	-74",
    "	75	-111	-76",
    "	74	-111	-75",
    "	73	-111	-73",
    "	72	-111	-69",
    "	71	-118	-66",
    "	70	-121	-65",
    "	69	-121	-63",
    "	68	-121	-61",
    "	67	-121	-60",
    "	66	-121	-60",
    "	65	-118	-60",
    "	64	-114	-61",
    "	63	-110	-62",
    "	62	-103	-63",
    "	61	-103	-89	-84	-63",
    "	60	-103	-91	-81	-77	-69	-63",
    "	59	-103	-93	-81	-76	-69	-63",
    "	58	-81	-75",
    "	57	-81	-75",
    "	56	-81	-75",
    "	55	-82	-75",
    "	54	-83	-76",
    "	53	-83	-77",
    "	52	-83	-77",
    "	51	-82	-77",
    "	50	-80	-78",
    "Canada: Ontario",
    "	57	-90	-86",
    "	56	-92	-81",
    "	55	-94	-81",
    "	54	-95	-81",
    "	53	-96	-79",
    "	52	-96	-78",
    "	51	-96	-78",
    "	50	-96	-78",
    "	49	-96	-78",
    "	48	-96	-78",
    "	47	-95	-76",
    "	46	-90	-73",
    "	45	-86	-73",
    "	44	-84	-73",
    "	43	-84	-73",
    "	42	-84	-75",
    "	41	-84	-77",
    "	40	-84	-80",
    "Canada: Prince Edward Island",
    "	48	-65	-62",
    "	47	-65	-60",
    "	46	-65	-60",
    "	45	-65	-60",
    "	44	-63	-61",
    "Canada: Quebec",
    "	63	-79	-71",
    "	62	-79	-68",
    "	61	-79	-68	-66	-63",
    "	60	-79	-68	-66	-63",
    "	59	-79	-62",
    "	58	-79	-62",
    "	57	-79	-62",
    "	56	-79	-62",
    "	55	-80	-62",
    "	54	-80	-62",
    "	53	-80	-56",
    "	52	-80	-56",
    "	51	-80	-56",
    "	50	-80	-56",
    "	49	-80	-57",
    "	48	-80	-60",
    "	47	-80	-60",
    "	46	-80	-65	-63	-60",
    "	45	-80	-68",
    "	44	-78	-69",
    "	43	-75	-73",
    "Canada: Saskatchewan",
    "	61	-111	-101",
    "	60	-111	-101",
    "	59	-111	-101",
    "	58	-111	-101",
    "	57	-111	-101",
    "	56	-111	-100",
    "	55	-111	-100",
    "	54	-111	-100",
    "	53	-111	-100",
    "	52	-111	-100",
    "	51	-111	-100",
    "	50	-111	-100",
    "	49	-111	-100",
    "	48	-111	-100",
    "	47	-111	-100",
    "Canada: Yukon",
    "	70	-142	-136",
    "	69	-142	-135",
    "	68	-142	-132",
    "	67	-142	-131",
    "	66	-142	-131",
    "	65	-142	-129",
    "	64	-142	-128",
    "	63	-142	-127",
    "	62	-142	-125",
    "	61	-142	-122",
    "	60	-142	-122",
    "	59	-142	-122",
    "Cape Verde",
    "	18	-26	-23",
    "	17	-26	-21",
    "	16	-26	-21",
    "	15	-26	-21",
    "	14	-25	-21",
    "	13	-25	-22",
    "Cayman Islands",
    "	20	-82	-78",
    "	19	-82	-78",
    "	18	-82	-78",
    "Central African Republic",
    "	12	21	23",
    "	11	20	24",
    "	10	18	24",
    "	9	17	25",
    "	8	14	26",
    "	7	13	27",
    "	6	13	28",
    "	5	13	28",
    "	4	13	28",
    "	3	13	26",
    "	2	14	19",
    "	1	14	17",
    "Chad",
    "	24	13	17",
    "	23	13	19",
    "	22	13	21",
    "	21	13	23",
    "	20	14	24",
    "	19	14	24",
    "	18	14	24",
    "	17	13	24",
    "	16	12	24",
    "	15	12	24",
    "	14	12	24",
    "	13	12	23",
    "	12	12	23",
    "	11	13	23",
    "	10	12	23",
    "	9	12	23",
    "	8	12	22",
    "	7	13	20",
    "	6	14	18",
    "Chile",
    "	-16	-70	-68",
    "	-17	-71	-67",
    "	-18	-71	-67",
    "	-19	-71	-67",
    "	-20	-71	-67",
    "	-21	-71	-66",
    "	-22	-71	-66",
    "	-23	-71	-66",
    "	-24	-71	-66",
    "	-25	-106	-104	-81	-78	-71	-66",
    "	-26	-110	-108	-106	-104	-81	-78	-72	-67",
    "	-27	-110	-108	-106	-104	-81	-78	-72	-67",
    "	-28	-110	-108	-72	-67",
    "	-29	-72	-68",
    "	-30	-72	-68",
    "	-31	-72	-68",
    "	-32	-81	-77	-72	-68",
    "	-33	-81	-77	-73	-68",
    "	-34	-81	-77	-73	-68",
    "	-35	-74	-68",
    "	-36	-74	-69",
    "	-37	-74	-69",
    "	-38	-74	-69",
    "	-39	-74	-69",
    "	-40	-75	-70",
    "	-41	-75	-70",
    "	-42	-75	-70",
    "	-43	-76	-70",
    "	-44	-76	-70",
    "	-45	-76	-70",
    "	-46	-76	-70",
    "	-47	-76	-70",
    "	-48	-76	-70",
    "	-49	-76	-71",
    "	-50	-76	-69",
    "	-51	-76	-67",
    "	-52	-76	-67",
    "	-53	-76	-66",
    "	-54	-75	-65",
    "	-55	-74	-65",
    "	-56	-72	-65",
    "China",
    "	54	119	126",
    "	53	119	127",
    "	52	118	127",
    "	51	118	128",
    "	50	85	88	115	130",
    "	49	84	90	114	135",
    "	48	81	91	114	135",
    "	47	81	92	114	135",
    "	46	79	94	110	135",
    "	45	78	96	110	135",
    "	44	78	96	109	134",
    "	43	78	132",
    "	42	75	132",
    "	41	72	132",
    "	40	72	129",
    "	39	72	127",
    "	38	72	125",
    "	37	72	123",
    "	36	73	123",
    "	35	73	123",
    "	34	74	121",
    "	33	77	122",
    "	32	77	122",
    "	31	77	123",
    "	30	77	123",
    "	29	78	123",
    "	28	81	123",
    "	27	83	122",
    "	26	84	93	96	122",
    "	25	96	121",
    "	24	96	120",
    "	23	96	120",
    "	22	96	118",
    "	21	98	117",
    "	20	98	102	105	114",
    "	19	107	112",
    "	18	107	112",
    "	17	107	111",
    "China: Hainan",
    "	21	108	111",
    "	20	107	112",
    "	19	107	112",
    "	18	107	112",
    "	17	107	111",
    "Christmas Island",
    "	-9	104	106",
    "	-10	104	106",
    "	-11	104	106",
    "Clipperton Island",
    "	11	-110	-108",
    "	10	-110	-108",
    "	9	-110	-108",
    "Cocos Islands",
    "	-11	95	97",
    "	-12	95	97",
    "	-13	95	97",
    "Colombia",
    "	14	-82	-80",
    "	13	-82	-80	-73	-70",
    "	12	-82	-80	-75	-70",
    "	11	-82	-80	-76	-70",
    "	10	-77	-70",
    "	9	-78	-71",
    "	8	-78	-69",
    "	7	-78	-66",
    "	6	-78	-66",
    "	5	-78	-66",
    "	4	-78	-66",
    "	3	-79	-66",
    "	2	-80	-65",
    "	1	-80	-65",
    "	0	-80	-65",
    "	-1	-79	-68",
    "	-2	-75	-68",
    "	-3	-74	-68",
    "	-4	-71	-68",
    "	-5	-71	-68",
    "Comoros",
    "	-10	42	44",
    "	-11	42	45",
    "	-12	42	45",
    "	-13	42	45",
    "Cook Islands",
    "	-7	-159	-156",
    "	-8	-159	-156",
    "	-9	-166	-164	-162	-156",
    "	-10	-166	-164	-162	-159",
    "	-11	-166	-164	-162	-159",
    "	-17	-160	-158",
    "	-18	-160	-156",
    "	-19	-160	-156",
    "	-20	-160	-156",
    "	-21	-160	-156",
    "	-22	-160	-156",
    "Coral Sea Islands",
    "	-15	146	151",
    "	-16	146	151",
    "	-17	146	151",
    "	-18	147	149",
    "	-20	152	156",
    "	-21	152	156",
    "	-22	152	156",
    "	-23	154	156",
    "Costa Rica",
    "	12	-86	-83",
    "	11	-86	-82",
    "	10	-86	-81",
    "	9	-86	-81",
    "	8	-86	-81",
    "	7	-84	-81",
    "	6	-88	-86",
    "	5	-88	-86",
    "	4	-88	-86",
    "Cote d'Ivoire",
    "	11	-9	-3",
    "	10	-9	-1",
    "	9	-9	-1",
    "	8	-9	-1",
    "	7	-9	-1",
    "	6	-9	-1",
    "	5	-9	-1",
    "	4	-8	-1",
    "	3	-8	-4",
    "Croatia",
    "	47	14	18",
    "	46	12	20",
    "	45	12	20",
    "	44	12	20",
    "	43	12	20",
    "	42	14	19",
    "	41	15	19",
    "Cuba",
    "	24	-84	-79",
    "	23	-85	-76",
    "	22	-85	-74",
    "	21	-85	-73",
    "	20	-85	-73",
    "	19	-80	-73",
    "	18	-78	-73",
    "Curacao",
    "	13	-70	-67",
    "	12	-70	-67",
    "	11	-70	-67",
    "Cyprus",
    "	36	31	35",
    "	35	31	35",
    "	34	31	35",
    "	33	31	35",
    "Cyprus",
    "	36	31	35",
    "	35	31	35",
    "	34	31	35",
    "Cyprus",
    "	35	31	34",
    "	34	31	34",
    "	33	31	34",
    "Cyprus",
    "	36	32	34",
    "	35	32	34",
    "	34	32	34",
    "	33	32	34",
    "Czech Republic",
    "	52	13	16",
    "	51	11	19",
    "	50	11	19",
    "	49	11	19",
    "	48	11	19",
    "	47	12	18",
    "Democratic Republic of the Congo",
    "	6	18	20	23	28",
    "	5	17	31",
    "	4	17	31",
    "	3	17	32",
    "	2	16	32",
    "	1	16	32",
    "	0	15	32",
    "	-1	15	31",
    "	-2	14	30",
    "	-3	11	30",
    "	-4	11	30",
    "	-5	11	31",
    "	-6	11	31",
    "	-7	11	13	15	31",
    "	-8	15	31",
    "	-9	16	31",
    "	-10	20	29",
    "	-11	21	30",
    "	-12	21	30",
    "	-13	25	30",
    "	-14	27	30",
    "Denmark",
    "	58	7	12",
    "	57	7	13",
    "	56	7	16",
    "	55	7	16",
    "	54	7	16",
    "	53	7	13",
    "Djibouti",
    "	13	41	44",
    "	12	40	44",
    "	11	40	44",
    "	10	40	44",
    "	9	40	43",
    "Dominica",
    "	16	-62	-60",
    "	15	-62	-60",
    "	14	-62	-60",
    "Dominican Republic",
    "	20	-72	-67",
    "	19	-73	-67",
    "	18	-73	-67",
    "	17	-73	-67",
    "	16	-72	-70",
    "Ecuador",
    "	2	-80	-77",
    "	1	-81	-74",
    "	0	-81	-74",
    "	-1	-82	-74",
    "	-2	-82	-74",
    "	-3	-82	-74",
    "	-4	-81	-76",
    "	-5	-81	-77",
    "	-6	-80	-78",
    "Ecuador: Galapagos",
    "	2	-93	-90",
    "	1	-93	-88",
    "	0	-93	-88",
    "	-1	-92	-88",
    "	-2	-92	-88",
    "Egypt",
    "	32	23	35",
    "	31	23	35",
    "	30	23	35",
    "	29	23	35",
    "	28	23	35",
    "	27	23	35",
    "	26	23	35",
    "	25	23	36",
    "	24	23	36",
    "	23	23	37",
    "	22	23	37",
    "	21	23	37",
    "	20	23	37",
    "El Salvador",
    "	15	-90	-87",
    "	14	-91	-86",
    "	13	-91	-86",
    "	12	-91	-86",
    "Equatorial Guinea",
    "	4	7	9",
    "	3	7	12",
    "	2	7	12",
    "	1	8	12",
    "	0	4	6	8	12",
    "	-1	4	6	8	10",
    "	-2	4	6",
    "Eritrea",
    "	19	37	39",
    "	18	35	40",
    "	17	35	41",
    "	16	35	41",
    "	15	35	42",
    "	14	35	43",
    "	13	35	44",
    "	12	39	44",
    "	11	40	44",
    "Estonia",
    "	60	21	29",
    "	59	20	29",
    "	58	20	29",
    "	57	20	28",
    "	56	20	28",
    "Eswatini",
    "	-24	30	33",
    "	-25	29	33",
    "	-26	29	33",
    "	-27	29	33",
    "	-28	29	32",
    "Ethiopia",
    "	15	35	41",
    "	14	35	42",
    "	13	34	43",
    "	12	33	43",
    "	11	33	44",
    "	10	33	44",
    "	9	32	47",
    "	8	31	48",
    "	7	31	48",
    "	6	31	48",
    "	5	33	47",
    "	4	33	46",
    "	3	34	46",
    "	2	36	42",
    "Europa Island",
    "	-21	39	41",
    "	-22	39	41",
    "	-23	39	41",
    "Falkland Islands (Islas Malvinas)",
    "	-50	-62	-56",
    "	-51	-62	-56",
    "	-52	-62	-56",
    "	-53	-62	-57",
    "Faroe Islands",
    "	63	-8	-5",
    "	62	-8	-5",
    "	61	-8	-5",
    "	60	-7	-5",
    "Fiji",
    "	-11	176	178",
    "	-12	176	178",
    "	-13	176	178",
    "	-15	-180	-178	176	180",
    "	-16	-180	-177	176	180",
    "	-17	-180	-177	176	180",
    "	-18	-180	-177	176	180",
    "	-19	-180	-177	176	180",
    "	-20	-180	-177	173	180",
    "	-21	173	175",
    "	-22	173	175",
    "Finland",
    "	71	26	28",
    "	70	19	30",
    "	69	19	30",
    "	68	19	31",
    "	67	19	31",
    "	66	22	31",
    "	65	22	31",
    "	64	20	32",
    "	63	20	32",
    "	62	20	32",
    "	61	20	32",
    "	60	20	31",
    "	59	20	29",
    "	58	21	25",
    "Finland",
    "	61	18	22",
    "	60	18	22",
    "	59	18	22",
    "	58	19	21",
    "France",
    "	52	0	3",
    "	51	0	5",
    "	50	-2	8",
    "	49	-6	9",
    "	48	-6	9",
    "	47	-6	9",
    "	46	-5	8",
    "	45	-3	8",
    "	44	-2	8",
    "	43	-2	8",
    "	42	-2	8",
    "	41	-2	7",
    "France: Corsica",
    "	44	8	10",
    "	43	7	10",
    "	42	7	10",
    "	41	7	10",
    "	40	7	10",
    "France: Saint Barthelemy",
    "	18	-63	-61",
    "	17	-63	-61",
    "	16	-63	-61",
    "France: Saint Martin",
    "	19	-64	-62",
    "	18	-64	-62",
    "	17	-64	-62",
    "French Guiana",
    "	6	-55	-51",
    "	5	-55	-50",
    "	4	-55	-50",
    "	3	-55	-50",
    "	2	-55	-50",
    "	1	-55	-51",
    "French Polynesia",
    "	-6	-141	-139",
    "	-7	-141	-138",
    "	-8	-141	-137",
    "	-9	-141	-137",
    "	-10	-141	-137",
    "	-11	-140	-137",
    "	-13	-149	-140",
    "	-14	-149	-139",
    "	-15	-152	-139",
    "	-16	-152	-137",
    "	-17	-152	-135",
    "	-18	-150	-148	-146	-135",
    "	-19	-142	-135",
    "	-20	-142	-134",
    "	-21	-152	-150	-141	-134",
    "	-22	-152	-146	-141	-133",
    "	-23	-152	-146	-136	-133",
    "	-24	-150	-146	-136	-133",
    "	-26	-145	-143",
    "	-27	-145	-143",
    "	-28	-145	-143",
    "French Southern and Antarctic Lands",
    "	-10	46	48",
    "	-11	46	48",
    "	-12	46	48",
    "	-14	53	55",
    "	-15	53	55",
    "	-16	41	43	53	55",
    "	-17	41	43",
    "	-18	41	43",
    "	-20	38	40",
    "	-21	38	41",
    "	-22	38	41",
    "	-23	39	41",
    "	-36	76	78",
    "	-37	76	78",
    "	-38	76	78",
    "	-39	76	78",
    "	-45	49	52",
    "	-46	49	52",
    "	-47	49	52	67	70",
    "	-48	67	71",
    "	-49	67	71",
    "	-50	67	71",
    "Gabon",
    "	3	10	14",
    "	2	8	15",
    "	1	7	15",
    "	0	7	15",
    "	-1	7	15",
    "	-2	7	15",
    "	-3	8	15",
    "	-4	9	12",
    "Gambia",
    "	14	-17	-12",
    "	13	-17	-12",
    "	12	-17	-12",
    "Gaza Strip",
    "	32	33	35",
    "	31	33	35",
    "	30	33	35",
    "Georgia",
    "	44	38	44",
    "	43	38	47",
    "	42	38	47",
    "	41	39	47",
    "	40	40	47",
    "Germany",
    "	56	7	9",
    "	55	7	15",
    "	54	5	15",
    "	53	5	15",
    "	52	4	16",
    "	51	4	16",
    "	50	4	16",
    "	49	4	15",
    "	48	5	14",
    "	47	6	14",
    "	46	6	14",
    "Ghana",
    "	12	-2	1",
    "	11	-3	1",
    "	10	-3	1",
    "	9	-3	1",
    "	8	-4	1",
    "	7	-4	2",
    "	6	-4	2",
    "	5	-4	2",
    "	4	-4	2",
    "	3	-3	0",
    "Gibraltar",
    "	37	-6	-4",
    "	36	-6	-4",
    "	35	-6	-4",
    "Glorioso Islands",
    "	-10	46	48",
    "	-11	46	48",
    "	-12	46	48",
    "Greece",
    "	42	20	27",
    "	41	19	27",
    "	40	18	27",
    "	39	18	27",
    "	38	18	28",
    "	37	19	29",
    "	36	19	29",
    "	35	20	29",
    "	34	22	28",
    "	33	23	26",
    "Greenland",
    "	84	-47	-23",
    "	83	-60	-18",
    "	82	-65	-10",
    "	81	-68	-10",
    "	80	-69	-10",
    "	79	-74	-13",
    "	78	-74	-16",
    "	77	-74	-16",
    "	76	-73	-16",
    "	75	-72	-16",
    "	74	-68	-65	-61	-16",
    "	73	-58	-16",
    "	72	-57	-19",
    "	71	-57	-20",
    "	70	-56	-20",
    "	69	-56	-20",
    "	68	-55	-21",
    "	67	-54	-24",
    "	66	-54	-31",
    "	65	-54	-32",
    "	64	-54	-34",
    "	63	-53	-39",
    "	62	-52	-39",
    "	61	-51	-40",
    "	60	-50	-41",
    "	59	-49	-41",
    "	58	-45	-42",
    "Grenada",
    "	13	-62	-60",
    "	12	-62	-60",
    "	11	-62	-60",
    "Guadeloupe",
    "	17	-62	-59",
    "	16	-62	-59",
    "	15	-62	-59",
    "	14	-62	-60",
    "Guam",
    "	14	143	145",
    "	13	143	145",
    "	12	143	145",
    "Guatemala",
    "	18	-92	-88",
    "	17	-92	-88",
    "	16	-93	-87",
    "	15	-93	-87",
    "	14	-93	-87",
    "	13	-93	-88",
    "	12	-92	-89",
    "Guernsey",
    "	50	-3	-1",
    "	49	-3	-1",
    "	48	-3	-1",
    "Guinea",
    "	13	-14	-7",
    "	12	-15	-7",
    "	11	-16	-6",
    "	10	-16	-6",
    "	9	-16	-6",
    "	8	-14	-6",
    "	7	-11	-6",
    "	6	-10	-7",
    "Guinea-Bissau",
    "	13	-17	-12",
    "	12	-17	-12",
    "	11	-17	-12",
    "	10	-17	-12",
    "	9	-16	-13",
    "Guyana",
    "	9	-61	-58",
    "	8	-61	-57",
    "	7	-62	-56",
    "	6	-62	-56",
    "	5	-62	-56",
    "	4	-62	-56",
    "	3	-61	-55",
    "	2	-61	-55",
    "	1	-61	-55",
    "	0	-60	-55",
    "Haiti",
    "	21	-73	-71",
    "	20	-74	-70",
    "	19	-75	-70",
    "	18	-75	-70",
    "	17	-75	-70",
    "Heard Island and McDonald Islands",
    "	-51	72	74",
    "	-52	72	74",
    "	-53	72	74",
    "	-54	72	74",
    "Honduras",
    "	18	-84	-82",
    "	17	-87	-82",
    "	16	-90	-82",
    "	15	-90	-82",
    "	14	-90	-82",
    "	13	-90	-82",
    "	12	-89	-84",
    "	11	-88	-86",
    "Hong Kong",
    "	23	112	115",
    "	22	112	115",
    "	21	112	115",
    "Howland Island",
    "	1	-177	-175",
    "	0	-177	-175",
    "	-1	-177	-175",
    "Hungary",
    "	49	16	23",
    "	48	15	23",
    "	47	15	23",
    "	46	15	23",
    "	45	15	22",
    "	44	16	20",
    "Iceland",
    "	67	-24	-13",
    "	66	-25	-12",
    "	65	-25	-12",
    "	64	-25	-12",
    "	63	-25	-12",
    "	62	-23	-15",
    "India",
    "	36	76	79",
    "	35	72	79",
    "	34	72	80",
    "	33	72	80",
    "	32	72	80",
    "	31	72	82",
    "	30	71	82	93	97",
    "	29	69	82	87	89	91	98",
    "	28	68	98",
    "	27	68	98",
    "	26	68	98",
    "	25	67	96",
    "	24	67	96",
    "	23	67	95",
    "	22	67	95",
    "	21	67	94",
    "	20	68	93",
    "	19	69	88",
    "	18	71	87",
    "	17	71	85",
    "	16	72	84",
    "	15	72	83",
    "	14	72	82	91	95",
    "	13	73	81	91	95",
    "	12	71	81	91	95",
    "	11	71	81	91	94",
    "	10	71	80	91	94",
    "	9	71	80	91	94",
    "	8	72	80	91	94",
    "	7	72	79	92	94",
    "	6	92	94",
    "	5	92	94",
    "Indonesia",
    "	6	94	98	125	127",
    "	5	94	99	106	109	114	118	125	128",
    "	4	94	100	104	109	114	118	124	128",
    "	3	94	102	104	110	113	119	124	129",
    "	2	94	132",
    "	1	94	137",
    "	0	96	139",
    "	-1	96	141",
    "	-2	97	141",
    "	-3	98	141",
    "	-4	99	141",
    "	-5	101	141",
    "	-6	101	116	118	141",
    "	-7	104	141",
    "	-8	105	132	136	141",
    "	-9	109	132	136	141",
    "	-10	115	126	139	141",
    "	-11	119	125",
    "Iran",
    "	40	43	49",
    "	39	43	49	54	58",
    "	38	43	61",
    "	37	43	62",
    "	36	43	62",
    "	35	43	62",
    "	34	44	62",
    "	33	44	62",
    "	32	44	62",
    "	31	45	62",
    "	30	46	62",
    "	29	46	63",
    "	28	47	64",
    "	27	49	64",
    "	26	50	64",
    "	25	52	64",
    "	24	53	62",
    "Iraq",
    "	38	41	45",
    "	37	40	46",
    "	36	40	47",
    "	35	39	47",
    "	34	37	47",
    "	33	37	48",
    "	32	37	48",
    "	31	37	49",
    "	30	39	49",
    "	29	41	49",
    "	28	42	49",
    "Ireland",
    "	56	-9	-5",
    "	55	-11	-5",
    "	54	-11	-5",
    "	53	-11	-4",
    "	52	-11	-4",
    "	51	-11	-4",
    "	50	-11	-6",
    "Isle of Man",
    "	55	-5	-3",
    "	54	-5	-3",
    "	53	-5	-3",
    "Israel",
    "	34	34	36",
    "	33	33	36",
    "	32	33	36",
    "	31	33	36",
    "	30	33	36",
    "	29	33	36",
    "	28	33	36",
    "Italy",
    "	48	10	13",
    "	47	6	14",
    "	46	5	14",
    "	45	5	14",
    "	44	5	14",
    "	43	5	16",
    "	42	6	18",
    "	41	7	19",
    "	40	7	19",
    "	39	7	19",
    "	38	7	19",
    "	37	7	18",
    "	36	10	17",
    "	35	10	16",
    "	34	11	13",
    "Jamaica",
    "	19	-79	-75",
    "	18	-79	-75",
    "	17	-79	-75",
    "	16	-78	-75",
    "Jan Mayen",
    "	72	-9	-6",
    "	71	-10	-6",
    "	70	-10	-6",
    "	69	-10	-7",
    "Japan",
    "	46	139	143",
    "	45	139	146",
    "	44	139	146",
    "	43	138	146",
    "	42	138	146",
    "	41	138	146",
    "	40	138	144",
    "	39	137	143",
    "	38	135	143",
    "	37	131	142",
    "	36	131	142",
    "	35	128	141",
    "	34	128	141",
    "	33	127	140",
    "	32	127	141",
    "	31	127	134	138	141",
    "	30	128	132	139	141",
    "	29	128	132	139	141",
    "	28	126	131	139	143",
    "	27	125	131	139	143",
    "	26	122	132	139	143",
    "	25	121	132	140	143	152	154",
    "	24	121	126	130	132	140	142	152	154",
    "	23	121	126	140	142	152	154",
    "Jarvis Island",
    "	1	-161	-159",
    "	0	-161	-159",
    "	-1	-161	-159",
    "Jersey",
    "	50	-3	-1",
    "	49	-3	-1",
    "	48	-3	-1",
    "Johnston Atoll",
    "	17	-170	-168",
    "	16	-170	-168",
    "	15	-170	-168",
    "Jordan",
    "	34	37	39",
    "	33	34	40",
    "	32	34	40",
    "	31	34	40",
    "	30	33	39",
    "	29	33	38",
    "	28	33	38",
    "Juan de Nova Island",
    "	-16	41	43",
    "	-17	41	43",
    "	-18	41	43",
    "Kazakhstan",
    "	56	67	71",
    "	55	60	77",
    "	54	59	79",
    "	53	59	79",
    "	52	48	84",
    "	51	46	86",
    "	50	45	88",
    "	49	45	88",
    "	48	45	88",
    "	47	45	87",
    "	46	46	86",
    "	45	47	86",
    "	44	48	83",
    "	43	48	56	58	81",
    "	42	49	56	60	81",
    "	41	50	56	64	81",
    "	40	51	56	65	71",
    "	39	66	69",
    "Kenya",
    "	6	33	36",
    "	5	32	42",
    "	4	32	42",
    "	3	32	42",
    "	2	33	42",
    "	1	32	42",
    "	0	32	42",
    "	-1	32	42",
    "	-2	32	42",
    "	-3	34	42",
    "	-4	36	41",
    "	-5	37	40",
    "Kerguelen Archipelago",
    "	-47	67	70",
    "	-48	67	71",
    "	-49	67	71",
    "	-50	67	71",
    "Kingman Reef",
    "	7	-163	-161",
    "	6	-163	-161",
    "	5	-163	-161",
    "Kiribati",
    "	5	-161	-159",
    "	4	-161	-158	171	173",
    "	3	-161	-156	171	173",
    "	2	-160	-156	171	174",
    "	1	-158	-156	171	175",
    "	0	-158	-156	171	177",
    "	-1	-172	-170	171	177",
    "	-2	-172	-170	173	177",
    "	-3	-173	-170	-156	-153	174	177",
    "	-4	-173	-171	-156	-153",
    "	-5	-173	-171	-156	-153",
    "	-10	-152	-150",
    "	-11	-152	-150",
    "	-12	-152	-150",
    "Kosovo",
    "	44	19	22",
    "	43	19	22",
    "	42	19	22",
    "	41	19	22",
    "	40	19	21",
    "Kuwait",
    "	31	46	49",
    "	30	45	49",
    "	29	45	49",
    "	28	45	49",
    "	27	46	49",
    "Kyrgyzstan",
    "	44	72	75",
    "	43	69	81",
    "	42	69	81",
    "	41	68	81",
    "	40	68	80",
    "	39	68	78",
    "	38	68	74",
    "Laos",
    "	23	100	103",
    "	22	99	104",
    "	21	99	105",
    "	20	99	105",
    "	19	99	106",
    "	18	99	107",
    "	17	99	108",
    "	16	99	108",
    "	15	103	108",
    "	14	104	108",
    "	13	104	108",
    "	12	104	107",
    "Latvia",
    "	59	23	26",
    "	58	20	28",
    "	57	19	29",
    "	56	19	29",
    "	55	19	29",
    "	54	24	28",
    "Lebanon",
    "	35	34	37",
    "	34	34	37",
    "	33	34	37",
    "	32	34	37",
    "Lesotho",
    "	-27	26	30",
    "	-28	26	30",
    "	-29	26	30",
    "	-30	26	30",
    "	-31	26	29",
    "Liberia",
    "	9	-11	-8",
    "	8	-12	-7",
    "	7	-12	-6",
    "	6	-12	-6",
    "	5	-12	-6",
    "	4	-11	-6",
    "	3	-10	-6",
    "Libya",
    "	34	10	12",
    "	33	9	16	19	25",
    "	32	9	26",
    "	31	8	26",
    "	30	8	26",
    "	29	8	25",
    "	28	8	25",
    "	27	8	25",
    "	26	8	25",
    "	25	8	25",
    "	24	8	25",
    "	23	9	25",
    "	22	10	25",
    "	21	12	25",
    "	20	17	25",
    "	19	20	25",
    "	18	21	25",
    "Liechtenstein",
    "	48	8	10",
    "	47	8	10",
    "	46	8	10",
    "Lithuania",
    "	57	20	26",
    "	56	19	27",
    "	55	19	27",
    "	54	19	27",
    "	53	21	27",
    "	52	22	25",
    "Luxembourg",
    "	51	4	7",
    "	50	4	7",
    "	49	4	7",
    "	48	4	7",
    "Macau",
    "	23	112	114",
    "	22	112	114",
    "	21	112	114",
    "Madagascar",
    "	-10	48	50",
    "	-11	47	50",
    "	-12	46	51",
    "	-13	46	51",
    "	-14	44	51",
    "	-15	43	51",
    "	-16	42	51",
    "	-17	42	51",
    "	-18	42	50",
    "	-19	42	50",
    "	-20	42	50",
    "	-21	42	49",
    "	-22	42	49",
    "	-23	42	48",
    "	-24	42	48",
    "	-25	42	48",
    "	-26	43	48",
    "Malawi",
    "	-8	31	35",
    "	-9	31	35",
    "	-10	31	35",
    "	-11	31	35",
    "	-12	31	36",
    "	-13	31	36",
    "	-14	31	36",
    "	-15	31	36",
    "	-16	33	36",
    "	-17	33	36",
    "	-18	34	36",
    "Malaysia",
    "	8	115	118",
    "	7	98	103	115	119",
    "	6	98	104	114	120",
    "	5	98	104	112	120",
    "	4	99	104	111	120",
    "	3	99	105	108	119",
    "	2	99	105	108	116",
    "	1	100	105	108	116",
    "	0	101	105	108	115",
    "	-1	109	112",
    "Maldives",
    "	8	71	73",
    "	7	71	74",
    "	6	71	74",
    "	5	71	74",
    "	4	71	74",
    "	3	71	74",
    "	2	71	74",
    "	1	71	74",
    "	0	71	74",
    "	-1	71	74",
    "Mali",
    "	25	-7	-2",
    "	24	-7	0",
    "	23	-7	1",
    "	22	-7	2",
    "	21	-7	3",
    "	20	-7	5",
    "	19	-7	5",
    "	18	-7	5",
    "	17	-6	5",
    "	16	-12	5",
    "	15	-13	5",
    "	14	-13	4",
    "	13	-13	1",
    "	12	-13	-1",
    "	11	-12	-3",
    "	10	-12	-3",
    "	9	-9	-4",
    "Malta",
    "	37	13	15",
    "	36	13	15",
    "	35	13	15",
    "	34	13	15",
    "Marshall Islands",
    "	15	167	170",
    "	14	167	170",
    "	13	167	170",
    "	12	164	167",
    "	11	164	167	169	171",
    "	10	164	167	169	171",
    "	9	166	171",
    "	8	166	172",
    "	7	166	173",
    "	6	167	173",
    "	5	167	173",
    "	4	167	170",
    "	3	167	169",
    "Martinique",
    "	15	-62	-59",
    "	14	-62	-59",
    "	13	-62	-59",
    "Mauritania",
    "	28	-9	-7",
    "	27	-9	-5",
    "	26	-13	-3",
    "	25	-13	-3",
    "	24	-14	-3",
    "	23	-14	-3",
    "	22	-18	-5",
    "	21	-18	-5",
    "	20	-18	-4",
    "	19	-18	-4",
    "	18	-17	-4",
    "	17	-17	-4",
    "	16	-17	-4",
    "	15	-17	-4",
    "	14	-17	-4",
    "	13	-13	-10",
    "Mauritius",
    "	-9	55	57",
    "	-10	55	57",
    "	-11	55	57",
    "	-18	56	58	62	64",
    "	-19	56	58	62	64",
    "	-20	56	58	62	64",
    "	-21	56	58",
    "Mayotte",
    "	-11	44	46",
    "	-12	44	46",
    "	-13	44	46",
    "Mexico",
    "	33	-118	-112",
    "	32	-118	-104",
    "	31	-118	-103",
    "	30	-119	-99",
    "	29	-119	-98",
    "	28	-119	-98",
    "	27	-119	-96",
    "	26	-116	-96",
    "	25	-115	-96",
    "	24	-113	-96",
    "	23	-113	-96",
    "	22	-111	-96	-91	-85",
    "	21	-111	-95	-91	-85",
    "	20	-111	-109	-107	-94	-92	-85",
    "	19	-115	-109	-106	-85",
    "	18	-115	-109	-106	-86",
    "	17	-115	-109	-105	-86",
    "	16	-103	-87",
    "	15	-101	-89",
    "	14	-98	-90",
    "	13	-93	-91",
    "Micronesia",
    "	10	137	139",
    "	9	137	139	148	151	153	155",
    "	8	137	139	148	155",
    "	7	148	159",
    "	6	148	154	156	159	161	164",
    "	5	148	150	152	154	156	159	161	164",
    "	4	152	154	156	158	161	164",
    "Midway Islands",
    "	29	-178	-176",
    "	28	-178	-176",
    "	27	-178	-176",
    "Moldova",
    "	49	25	29",
    "	48	25	30",
    "	47	25	31",
    "	46	26	31",
    "	45	27	31",
    "	44	27	29",
    "Monaco",
    "	44	6	8",
    "	43	6	8",
    "	42	6	8",
    "Mongolia",
    "	53	97	100",
    "	52	96	103",
    "	51	88	108	112	117",
    "	50	86	117",
    "	49	86	119",
    "	48	86	120",
    "	47	86	120",
    "	46	88	120",
    "	45	89	120",
    "	44	89	117",
    "	43	91	115",
    "	42	94	112",
    "	41	95	111",
    "	40	102	106",
    "Montenegro",
    "	44	17	21",
    "	43	17	21",
    "	42	17	21",
    "	41	17	21",
    "	40	18	20",
    "Montserrat",
    "	17	-63	-61",
    "	16	-63	-61",
    "	15	-63	-61",
    "Morocco",
    "	36	-7	-1",
    "	35	-7	0",
    "	34	-9	0",
    "	33	-10	0",
    "	32	-10	0",
    "	31	-10	0",
    "	30	-11	-1",
    "	29	-13	-2",
    "	28	-14	-4",
    "	27	-15	-7",
    "	26	-15	-7",
    "	25	-16	-8",
    "	24	-17	-11",
    "	23	-17	-11",
    "	22	-18	-12",
    "	21	-18	-13",
    "	20	-18	-13",
    "Mozambique",
    "	-9	38	41",
    "	-10	33	41",
    "	-11	33	41",
    "	-12	33	41",
    "	-13	29	41",
    "	-14	29	41",
    "	-15	29	41",
    "	-16	29	41",
    "	-17	29	41",
    "	-18	31	39",
    "	-19	31	37",
    "	-20	30	36",
    "	-21	30	36",
    "	-22	30	36",
    "	-23	30	36",
    "	-24	30	36",
    "	-25	30	36",
    "	-26	30	34",
    "	-27	31	33",
    "Myanmar",
    "	29	96	99",
    "	28	94	99",
    "	27	94	99",
    "	26	93	99",
    "	25	92	99",
    "	24	92	100",
    "	23	91	100",
    "	22	91	102",
    "	21	91	102",
    "	20	91	102",
    "	19	91	101",
    "	18	91	100",
    "	17	92	99",
    "	16	93	99",
    "	15	92	99",
    "	14	92	100",
    "	13	92	94	96	100",
    "	12	96	100",
    "	11	96	100",
    "	10	96	100",
    "	9	96	100",
    "	8	97	99",
    "Namibia",
    "	-15	12	14",
    "	-16	10	26",
    "	-17	10	26",
    "	-18	10	26",
    "	-19	10	25",
    "	-20	11	21",
    "	-21	12	21",
    "	-22	12	21",
    "	-23	13	21",
    "	-24	13	20",
    "	-25	13	20",
    "	-26	13	20",
    "	-27	13	20",
    "	-28	14	20",
    "	-29	14	20",
    "Nauru",
    "	1	165	167",
    "	0	165	167",
    "	-1	165	167",
    "Navassa Island",
    "	19	-76	-74",
    "	18	-76	-74",
    "	17	-76	-74",
    "Nepal",
    "	31	79	83",
    "	30	79	85",
    "	29	79	87",
    "	28	79	89",
    "	27	79	89",
    "	26	80	89",
    "	25	83	89",
    "Netherlands",
    "	54	3	8",
    "	53	3	8",
    "	52	2	8",
    "	51	2	8",
    "	50	2	7",
    "	49	4	7",
    "Netherlands Antilles",
    "	18	-64	-61",
    "	17	-64	-61",
    "	16	-64	-61",
    "	13	-69	-67",
    "	12	-69	-67",
    "	11	-69	-67",
    "New Caledonia",
    "	-18	158	160	162	164",
    "	-19	158	160	162	168",
    "	-20	158	160	162	169",
    "	-21	162	169",
    "	-22	163	169",
    "	-23	165	168",
    "New Zealand",
    "	-7	-173	-171",
    "	-8	-173	-170",
    "	-9	-173	-170",
    "	-10	-172	-170",
    "	-28	-178	-176",
    "	-29	-178	-176",
    "	-30	-178	-176",
    "	-33	171	174",
    "	-34	171	175",
    "	-35	171	176",
    "	-36	172	179",
    "	-37	172	179",
    "	-38	172	179",
    "	-39	171	179",
    "	-40	170	179",
    "	-41	169	177",
    "	-42	-177	-175	167	177",
    "	-43	-177	-175	166	175",
    "	-44	-177	-175	165	174",
    "	-45	-177	-175	165	172",
    "	-46	165	172",
    "	-47	165	171",
    "	-48	165	169	177	179",
    "	-49	164	167	177	179",
    "	-50	164	167	177	179",
    "	-51	164	170",
    "	-52	168	170",
    "	-53	168	170",
    "Nicaragua",
    "	16	-84	-82",
    "	15	-87	-81",
    "	14	-88	-81",
    "	13	-88	-81",
    "	12	-88	-82",
    "	11	-88	-82",
    "	10	-87	-82",
    "	9	-85	-82",
    "Niger",
    "	24	10	14",
    "	23	8	16",
    "	22	6	16",
    "	21	5	16",
    "	20	3	16",
    "	19	3	16",
    "	18	3	16",
    "	17	2	16",
    "	16	0	16",
    "	15	-1	16",
    "	14	-1	15",
    "	13	-1	14",
    "	12	-1	14",
    "	11	0	10",
    "	10	1	4",
    "Nigeria",
    "	14	3	15",
    "	13	2	15",
    "	12	2	15",
    "	11	2	15",
    "	10	1	15",
    "	9	1	14",
    "	8	1	14",
    "	7	1	13",
    "	6	1	13",
    "	5	1	12",
    "	4	4	10",
    "	3	4	9",
    "Niue",
    "	-17	-170	-168",
    "	-18	-170	-168",
    "	-19	-170	-168",
    "	-20	-170	-168",
    "Norfolk Island",
    "	-27	166	168",
    "	-28	166	168",
    "	-29	166	168",
    "	-30	166	168",
    "North Korea",
    "	44	128	130",
    "	43	127	131",
    "	42	125	131",
    "	41	123	131",
    "	40	123	131",
    "	39	123	130",
    "	38	123	129",
    "	37	123	129",
    "	36	123	127",
    "North Macedonia",
    "	43	19	23",
    "	42	19	24",
    "	41	19	24",
    "	40	19	24",
    "	39	19	22",
    "Northern Mariana Islands",
    "	21	143	146",
    "	20	143	146",
    "	19	143	146",
    "	18	144	146",
    "	17	144	146",
    "	16	144	146",
    "	15	144	146",
    "	14	144	146",
    "	13	144	146",
    "Norway",
    "	72	22	29",
    "	71	17	32",
    "	70	14	32",
    "	69	11	32",
    "	68	11	31",
    "	67	11	26",
    "	66	10	18",
    "	65	8	17",
    "	64	6	15",
    "	63	3	15",
    "	62	3	13",
    "	61	3	13",
    "	60	3	13",
    "	59	3	13",
    "	58	4	13",
    "	57	4	12",
    "	56	5	8",
    "Oman",
    "	27	55	57",
    "	26	55	57",
    "	25	54	58",
    "	24	54	60",
    "	23	54	60",
    "	22	54	60",
    "	21	54	60",
    "	20	51	60",
    "	19	50	59",
    "	18	50	58",
    "	17	50	58",
    "	16	51	57",
    "	15	51	55",
    "Pakistan",
    "	38	73	75",
    "	37	70	77",
    "	36	70	78",
    "	35	68	78",
    "	34	68	78",
    "	33	68	78",
    "	32	65	76",
    "	31	65	76",
    "	30	59	75",
    "	29	59	75",
    "	28	59	74",
    "	27	60	73",
    "	26	60	72",
    "	25	60	72",
    "	24	60	72",
    "	23	65	72",
    "	22	66	69",
    "Palau",
    "	8	133	135",
    "	7	133	135",
    "	6	131	135",
    "	5	131	135",
    "	4	130	133",
    "	3	130	132",
    "	2	130	132",
    "	1	130	132",
    "Palmyra Atoll",
    "	6	-163	-161",
    "	5	-163	-161",
    "	4	-163	-161",
    "Panama",
    "	10	-83	-76",
    "	9	-84	-76",
    "	8	-84	-76",
    "	7	-84	-76",
    "	6	-82	-76",
    "Papua New Guinea",
    "	0	141	143	145	151",
    "	-1	139	143	145	153",
    "	-2	139	155",
    "	-3	139	155",
    "	-4	139	156",
    "	-5	139	156",
    "	-6	139	156",
    "	-7	139	156",
    "	-8	139	154",
    "	-9	139	154",
    "	-10	139	155",
    "	-11	146	155",
    "	-12	152	155",
    "Paracel Islands",
    "	18	110	112",
    "	17	110	113",
    "	16	110	113",
    "	15	110	113",
    "Paraguay",
    "	-18	-62	-57",
    "	-19	-63	-56",
    "	-20	-63	-56",
    "	-21	-63	-54",
    "	-22	-63	-53",
    "	-23	-63	-53",
    "	-24	-62	-53",
    "	-25	-61	-53",
    "	-26	-59	-53",
    "	-27	-59	-53",
    "	-28	-59	-54",
    "Peru",
    "	1	-76	-73",
    "	0	-76	-72",
    "	-1	-78	-69",
    "	-2	-81	-69",
    "	-3	-82	-68",
    "	-4	-82	-68",
    "	-5	-82	-68",
    "	-6	-82	-71",
    "	-7	-82	-71",
    "	-8	-80	-69",
    "	-9	-80	-68",
    "	-10	-79	-68",
    "	-11	-79	-67",
    "	-12	-78	-67",
    "	-13	-78	-67",
    "	-14	-77	-67",
    "	-15	-77	-67",
    "	-16	-76	-67",
    "	-17	-75	-67",
    "	-18	-73	-68",
    "	-19	-71	-68",
    "Philippines",
    "	22	120	122",
    "	21	120	123",
    "	20	120	123",
    "	19	119	123",
    "	18	119	123",
    "	17	118	123",
    "	16	118	123",
    "	15	118	125",
    "	14	118	125",
    "	13	118	126",
    "	12	118	126",
    "	11	117	127",
    "	10	116	127",
    "	9	115	127",
    "	8	115	127",
    "	7	115	127",
    "	6	115	127",
    "	5	117	127",
    "	4	118	126",
    "	3	118	120",
    "Pitcairn Islands",
    "	-22	-131	-129",
    "	-23	-131	-127	-125	-123",
    "	-24	-131	-127	-125	-123",
    "	-25	-131	-127	-125	-123",
    "	-26	-131	-129",
    "Poland",
    "	55	13	24",
    "	54	13	24",
    "	53	13	24",
    "	52	13	24",
    "	51	13	25",
    "	50	13	25",
    "	49	13	25",
    "	48	16	24",
    "	47	21	23",
    "Portugal",
    "	43	-9	-7",
    "	42	-9	-5",
    "	41	-9	-5",
    "	40	-10	-5",
    "	39	-10	-5",
    "	38	-10	-5",
    "	37	-10	-5",
    "	36	-9	-6",
    "	35	-8	-6",
    "Portugal: Azores",
    "	40	-32	-26",
    "	39	-32	-26",
    "	38	-32	-24",
    "	37	-29	-24",
    "	36	-26	-24",
    "	35	-26	-24",
    "Portugal: Madeira",
    "	34	-17	-15",
    "	33	-18	-15",
    "	32	-18	-15",
    "	31	-18	-14",
    "	30	-17	-14",
    "	29	-17	-14",
    "Puerto Rico",
    "	19	-68	-64",
    "	18	-68	-64",
    "	17	-68	-64",
    "	16	-68	-64",
    "Qatar",
    "	27	50	52",
    "	26	49	52",
    "	25	49	52",
    "	24	49	52",
    "	23	49	52",
    "Republic of the Congo",
    "	4	15	19",
    "	3	12	19",
    "	2	12	19",
    "	1	12	19",
    "	0	11	19",
    "	-1	10	18",
    "	-2	10	18",
    "	-3	10	17",
    "	-4	10	17",
    "	-5	10	16",
    "	-6	10	13",
    "Reunion",
    "	-19	54	56",
    "	-20	54	56",
    "	-21	54	56",
    "	-22	54	56",
    "Romania",
    "	49	21	28",
    "	48	20	29",
    "	47	19	29",
    "	46	19	30",
    "	45	19	30",
    "	44	19	30",
    "	43	20	30",
    "	42	21	29",
    "Russia",
    "	82	49	51	53	66	88	97",
    "	81	35	37	43	66	77	81	88	100",
    "	80	35	37	43	66	75	81	88	105",
    "	79	35	37	43	66	75	81	89	108",
    "	78	49	52	57	60	66	68	75	78	88	108	155	157",
    "	77	59	70	88	114	136	143	147	153	155	157",
    "	76	54	70	80	114	134	153	155	157",
    "	75	53	70	78	117	134	153",
    "	74	52	130	134	151",
    "	73	50	61	67	130	134	151",
    "	72	-180	-174	50	59	65	159	177	180",
    "	71	-180	-174	50	61	65	163	167	172	177	180",
    "	70	-180	-174	27	37	47	180",
    "	69	-180	-175	27	180",
    "	68	-180	-171	27	180",
    "	67	-180	-168	27	180",
    "	66	-180	-167	28	180",
    "	65	-180	-167	28	180",
    "	64	-180	-167	28	180",
    "	63	-176	-171	28	180",
    "	62	27	180",
    "	61	25	180",
    "	60	25	175",
    "	59	25	173",
    "	58	26	167	169	171",
    "	57	26	143	150	165",
    "	56	19	23	26	141	154	167",
    "	55	18	23	26	144	154	169",
    "	54	18	23	27	144	154	169",
    "	53	18	23	29	144	154	163	165	169",
    "	52	30	63	71	144	154	161",
    "	51	30	63	77	121	124	145	154	159",
    "	50	33	62	78	121	125	145	153	159",
    "	49	34	50	53	62	78	99	101	120	126	145	152	157",
    "	48	36	49	83	90	94	98	106	120	126	145	151	156",
    "	47	36	50	129	145	149	155",
    "	46	35	50	129	144	146	154",
    "	45	35	50	129	153",
    "	44	35	49	129	138	141	151",
    "	43	36	49	129	137	144	148",
    "	42	38	49	129	136	144	147",
    "	41	42	49	129	135",
    "	40	45	49",
    "Rwanda",
    "	0	28	31",
    "	-1	27	31",
    "	-2	27	31",
    "	-3	27	31",
    "Saint Helena",
    "	-6	-15	-13",
    "	-7	-15	-13",
    "	-8	-15	-13",
    "	-14	-6	-4",
    "	-15	-6	-4",
    "	-16	-6	-4",
    "	-17	-6	-4",
    "	-36	-13	-11",
    "	-37	-13	-11",
    "	-38	-13	-11",
    "	-39	-11	-8",
    "	-40	-11	-8",
    "	-41	-11	-8",
    "Saint Kitts and Nevis",
    "	18	-63	-61",
    "	17	-63	-61",
    "	16	-63	-61",
    "Saint Lucia",
    "	15	-62	-59",
    "	14	-62	-59",
    "	13	-62	-59",
    "	12	-62	-59",
    "Saint Pierre and Miquelon",
    "	48	-57	-55",
    "	47	-57	-55",
    "	46	-57	-55",
    "	45	-57	-55",
    "Saint Vincent and the Grenadines",
    "	14	-62	-60",
    "	13	-62	-60",
    "	12	-62	-60",
    "	11	-62	-60",
    "Samoa",
    "	-12	-173	-170",
    "	-13	-173	-170",
    "	-14	-173	-170",
    "	-15	-172	-170",
    "San Marino",
    "	44	11	13",
    "	43	11	13",
    "	42	11	13",
    "Sao Tome and Principe",
    "	2	6	8",
    "	1	5	8",
    "	0	5	8",
    "	-1	5	7",
    "Saudi Arabia",
    "	33	37	40",
    "	32	35	43",
    "	31	35	44",
    "	30	33	48",
    "	29	33	49",
    "	28	33	50",
    "	27	33	51",
    "	26	33	51",
    "	25	34	52",
    "	24	35	53",
    "	23	36	56",
    "	22	37	56",
    "	21	37	56",
    "	20	37	56",
    "	19	38	56",
    "	18	39	55",
    "	17	40	52",
    "	16	40	48",
    "	15	40	48",
    "Senegal",
    "	17	-17	-12",
    "	16	-17	-11",
    "	15	-18	-10",
    "	14	-18	-10",
    "	13	-18	-10",
    "	12	-17	-10",
    "	11	-17	-10",
    "Serbia",
    "	47	18	21",
    "	46	17	22",
    "	45	17	23",
    "	44	17	23",
    "	43	17	23",
    "	42	18	23",
    "	41	19	23",
    "Seychelles",
    "	-2	54	56",
    "	-3	54	56",
    "	-4	52	56",
    "	-5	51	56",
    "	-6	51	57",
    "	-7	51	53	55	57",
    "	-8	45	48	51	53	55	57",
    "	-9	45	48",
    "	-10	45	48",
    "Sierra Leone",
    "	10	-14	-9",
    "	9	-14	-9",
    "	8	-14	-9",
    "	7	-14	-9",
    "	6	-13	-9",
    "	5	-12	-10",
    "Singapore",
    "	2	102	105",
    "	1	102	105",
    "	0	102	105",
    "Sint Maarten",
    "	19	-64	-62",
    "	18	-64	-62",
    "	17	-64	-62",
    "Slovakia",
    "	50	16	23",
    "	49	15	23",
    "	48	15	23",
    "	47	15	23",
    "	46	16	19",
    "Slovenia",
    "	47	12	17",
    "	46	12	17",
    "	45	12	17",
    "	44	12	16",
    "Solomon Islands",
    "	-5	154	158",
    "	-6	154	161",
    "	-7	154	163",
    "	-8	154	163	166	168",
    "	-9	155	168",
    "	-10	158	168",
    "	-11	158	169",
    "	-12	158	161	165	169",
    "	-13	167	169",
    "Somalia",
    "	12	47	52",
    "	11	47	52",
    "	10	47	52",
    "	9	47	52",
    "	8	45	51",
    "	7	44	51",
    "	6	44	50",
    "	5	40	50",
    "	4	40	49",
    "	3	39	49",
    "	2	39	48",
    "	1	39	47",
    "	0	39	46",
    "	-1	39	44",
    "	-2	40	42",
    "Somalia",
    "	12	42	44	46	49",
    "	11	41	49",
    "	10	41	49",
    "	9	41	49",
    "	8	42	49",
    "	7	43	49",
    "	6	45	48",
    "South Africa",
    "	-21	26	32",
    "	-22	25	32",
    "	-23	18	21	24	32",
    "	-24	18	32",
    "	-25	18	33",
    "	-26	18	33",
    "	-27	15	33",
    "	-28	15	33",
    "	-29	15	33",
    "	-30	15	32",
    "	-31	16	31",
    "	-32	16	31",
    "	-33	16	30",
    "	-34	16	28",
    "	-35	17	26",
    "	-45	36	38",
    "	-46	36	38",
    "	-47	36	38",
    "South Georgia and the South Sandwich Islands",
    "	-52	-43	-36",
    "	-53	-43	-33",
    "	-54	-43	-33",
    "	-55	-39	-33	-29	-26",
    "	-56	-35	-33	-29	-25",
    "	-57	-29	-25",
    "	-58	-28	-25",
    "	-59	-28	-25",
    "	-60	-28	-25",
    "South Korea",
    "	39	125	129",
    "	38	123	131",
    "	37	123	131",
    "	36	123	131",
    "	35	124	130",
    "	34	124	130",
    "	33	124	129",
    "	32	125	127",
    "South Sudan",
    "	13	31	34",
    "	12	31	34",
    "	11	23	34",
    "	10	23	35",
    "	9	23	35",
    "	8	23	35",
    "	7	23	35",
    "	6	23	36",
    "	5	25	36",
    "	4	25	36",
    "	3	26	35",
    "	2	29	34",
    "Spain",
    "	44	-10	0",
    "	43	-10	4",
    "	42	-10	4",
    "	41	-10	5",
    "	40	-9	5",
    "	39	-8	5",
    "	38	-8	5",
    "	37	-8	2",
    "	36	-8	1",
    "	35	-7	0",
    "	34	-6	-1",
    "Spain: Canary Islands",
    "	30	-14	-12",
    "	29	-19	-12",
    "	28	-19	-12",
    "	27	-19	-12",
    "	26	-19	-14",
    "Spratly Islands",
    "	12	113	115",
    "	11	112	115",
    "	10	112	116",
    "	9	110	116",
    "	8	110	116",
    "	7	110	116",
    "	6	112	114",
    "	5	112	114",
    "Sri Lanka",
    "	10	78	81",
    "	9	78	82",
    "	8	78	82",
    "	7	78	82",
    "	6	78	82",
    "	5	78	82",
    "	4	79	81",
    "Sudan",
    "	23	30	32",
    "	22	23	38",
    "	21	23	38",
    "	20	22	38",
    "	19	22	39",
    "	18	22	39",
    "	17	22	39",
    "	16	21	39",
    "	15	21	38",
    "	14	20	37",
    "	13	20	37",
    "	12	20	37",
    "	11	20	37",
    "	10	21	36",
    "	9	21	35",
    "	8	22	35",
    "	7	22	25",
    "Suriname",
    "	7	-56	-54",
    "	6	-58	-52",
    "	5	-59	-52",
    "	4	-59	-52",
    "	3	-59	-52",
    "	2	-59	-52",
    "	1	-58	-53",
    "	0	-57	-54",
    "Svalbard",
    "	81	15	28	30	34",
    "	80	9	34",
    "	79	9	34",
    "	78	9	31",
    "	77	9	31",
    "	76	12	26",
    "	75	14	20	23	26",
    "	74	17	20",
    "	73	17	20",
    "Sweden",
    "	70	19	21",
    "	69	16	24",
    "	68	15	24",
    "	67	13	25",
    "	66	13	25",
    "	65	11	25",
    "	64	10	25",
    "	63	10	22",
    "	62	10	21",
    "	61	11	19",
    "	60	10	20",
    "	59	10	20",
    "	58	10	20",
    "	57	10	20",
    "	56	10	20",
    "	55	11	19",
    "	54	11	15",
    "Switzerland",
    "	48	5	10",
    "	47	4	11",
    "	46	4	11",
    "	45	4	11",
    "	44	5	10",
    "Syria",
    "	38	39	43",
    "	37	35	43",
    "	36	34	43",
    "	35	34	43",
    "	34	34	42",
    "	33	34	42",
    "	32	34	40",
    "	31	34	39",
    "Taiwan",
    "	26	120	123",
    "	25	117	123",
    "	24	117	123",
    "	23	117	122",
    "	22	118	122",
    "	21	119	122",
    "	20	119	121",
    "Tajikistan",
    "	42	69	71",
    "	41	67	71",
    "	40	66	74",
    "	39	66	75",
    "	38	66	76",
    "	37	66	76",
    "	36	66	76",
    "	35	66	73",
    "Tanzania",
    "	1	29	31",
    "	0	29	36",
    "	-1	29	38",
    "	-2	29	39",
    "	-3	28	40",
    "	-4	28	40",
    "	-5	28	40",
    "	-6	28	40",
    "	-7	28	40",
    "	-8	29	40",
    "	-9	29	41",
    "	-10	30	41",
    "	-11	33	41",
    "	-12	33	40",
    "Thailand",
    "	21	98	101",
    "	20	96	102",
    "	19	96	105",
    "	18	96	105",
    "	17	96	106",
    "	16	96	106",
    "	15	97	106",
    "	14	97	106",
    "	13	97	106",
    "	12	97	103",
    "	11	97	103",
    "	10	96	103",
    "	9	96	101",
    "	8	96	101",
    "	7	97	103",
    "	6	97	103",
    "	5	98	103",
    "	4	99	102",
    "Timor-Leste",
    "	-7	123	128",
    "	-8	123	128",
    "	-9	123	128",
    "	-10	123	127",
    "Togo",
    "	12	-1	1",
    "	11	-1	2",
    "	10	-1	2",
    "	9	-1	2",
    "	8	-1	2",
    "	7	-1	2",
    "	6	-1	2",
    "	5	-1	2",
    "Tokelau",
    "	-8	-172	-170",
    "	-9	-172	-170",
    "	-10	-172	-170",
    "Tonga",
    "	-14	-176	-172",
    "	-15	-176	-172",
    "	-16	-176	-172",
    "	-17	-175	-172",
    "	-18	-176	-172",
    "	-19	-176	-172",
    "	-20	-176	-173",
    "	-21	-177	-173",
    "	-22	-177	-173",
    "	-23	-177	-175",
    "Trinidad and Tobago",
    "	12	-61	-59",
    "	11	-62	-59",
    "	10	-62	-59",
    "	9	-62	-59",
    "Tromelin Island",
    "	-14	53	55",
    "	-15	53	55",
    "	-16	53	55",
    "Tunisia",
    "	38	7	12",
    "	37	7	12",
    "	36	7	12",
    "	35	6	12",
    "	34	6	12",
    "	33	6	12",
    "	32	6	12",
    "	31	7	12",
    "	30	8	11",
    "	29	8	11",
    "Turkey",
    "	43	25	28	32	36",
    "	42	25	44",
    "	41	24	45",
    "	40	24	45",
    "	39	24	45",
    "	38	24	45",
    "	37	25	45",
    "	36	26	45",
    "	35	26	41	43	45",
    "	34	34	37",
    "Turkmenistan",
    "	43	51	61",
    "	42	51	62",
    "	41	51	63",
    "	40	51	64",
    "	39	51	67",
    "	38	51	67",
    "	37	52	67",
    "	36	52	67",
    "	35	59	65",
    "	34	60	65",
    "Turks and Caicos Islands",
    "	22	-73	-70",
    "	21	-73	-70",
    "	20	-73	-70",
    "Tuvalu",
    "	-4	175	177",
    "	-5	175	178",
    "	-6	175	179",
    "	-7	175	180",
    "	-8	176	180",
    "	-9	177	180",
    "	-10	178	180",
    "Uganda",
    "	5	32	35",
    "	4	29	35",
    "	3	29	35",
    "	2	29	36",
    "	1	28	36",
    "	0	28	36",
    "	-1	28	35",
    "	-2	28	34",
    "Ukraine",
    "	53	29	35",
    "	52	22	36",
    "	51	22	39",
    "	50	21	41",
    "	49	21	41",
    "	48	21	41",
    "	47	21	41",
    "	46	21	40",
    "	45	27	38",
    "	44	27	37",
    "	43	32	36",
    "United Arab Emirates",
    "	27	55	57",
    "	26	53	57",
    "	25	50	57",
    "	24	50	57",
    "	23	50	57",
    "	22	50	56",
    "	21	51	56",
    "United Kingdom",
    "	61	-3	1",
    "	60	-4	1",
    "	59	-8	1",
    "	58	-14	-12	-9	0",
    "	57	-14	-12	-9	0",
    "	56	-14	-12	-9	0",
    "	55	-9	1",
    "	54	-9	1",
    "	53	-9	2",
    "	52	-6	2",
    "	51	-6	2",
    "	50	-7	2",
    "	49	-7	1",
    "	48	-7	-4",
    "Uruguay",
    "	-29	-58	-54",
    "	-30	-59	-52",
    "	-31	-59	-52",
    "	-32	-59	-52",
    "	-33	-59	-52",
    "	-34	-59	-52",
    "	-35	-59	-52",
    "USA",
    "	72	-158	-153",
    "	71	-163	-141",
    "	70	-164	-140",
    "	69	-167	-140",
    "	68	-167	-140",
    "	67	-167	-140",
    "	66	-169	-140",
    "	65	-169	-140",
    "	64	-172	-140",
    "	63	-172	-140",
    "	62	-172	-140",
    "	61	-174	-138",
    "	60	-174	-171	-168	-133",
    "	59	-174	-171	-168	-132",
    "	58	-171	-131",
    "	57	-171	-168	-163	-150	-138	-129",
    "	56	-171	-168	-164	-151	-137	-128",
    "	55	-170	-152	-136	-128",
    "	54	-170	-154	-135	-128	171	173",
    "	53	-177	-158	-134	-129	171	180",
    "	52	-180	-165	171	180",
    "	51	-180	-167	171	180",
    "	50	-180	-174	-96	-93	176	180",
    "	49	-125	-86",
    "	48	-125	-84	-70	-66",
    "	47	-125	-82	-71	-66",
    "	46	-125	-81	-75	-66",
    "	45	-125	-81	-77	-65",
    "	44	-125	-65",
    "	43	-125	-65",
    "	42	-125	-68",
    "	41	-125	-68",
    "	40	-125	-68",
    "	39	-125	-71",
    "	38	-124	-73",
    "	37	-124	-73",
    "	36	-124	-74",
    "	35	-123	-74",
    "	34	-122	-74",
    "	33	-121	-75",
    "	32	-121	-76",
    "	31	-119	-78",
    "	30	-114	-79",
    "	29	-106	-79",
    "	28	-105	-79",
    "	27	-174	-172	-104	-94	-90	-88	-83	-79",
    "	26	-174	-166	-100	-95	-83	-79",
    "	25	-174	-166	-100	-96	-83	-79",
    "	24	-172	-160	-98	-96	-83	-79",
    "	23	-165	-158	-83	-79",
    "	22	-165	-155",
    "	21	-161	-154",
    "	20	-161	-153",
    "	19	-158	-153",
    "	18	-157	-153",
    "	17	-156	-154",
    "USA: Alabama",
    "	36	-89	-86",
    "	35	-89	-84",
    "	34	-89	-84",
    "	33	-89	-83",
    "	32	-89	-83",
    "	31	-89	-83",
    "	30	-89	-83",
    "	29	-89	-86",
    "USA: Alaska",
    "	72	-158	-153",
    "	71	-163	-141",
    "	70	-164	-140",
    "	69	-167	-140",
    "	68	-167	-140",
    "	67	-167	-140",
    "	66	-169	-140",
    "	65	-169	-140",
    "	64	-172	-140",
    "	63	-172	-140",
    "	62	-172	-140",
    "	61	-174	-138",
    "	60	-174	-171	-168	-133",
    "	59	-174	-171	-168	-132",
    "	58	-171	-131",
    "	57	-171	-168	-163	-150	-138	-129",
    "	56	-171	-168	-164	-151	-137	-128",
    "	55	-170	-152	-136	-128",
    "	54	-170	-154	-135	-128	171	173",
    "	53	-177	-158	-134	-129	171	180",
    "	52	-180	-165	171	180",
    "	51	-180	-167	171	180",
    "	50	-180	-174	176	180",
    "USA: Alaska, Aleutian Islands",
    "	60	-154	-149	-147	-145",
    "	59	-162	-159	-154	-149	-147	-145",
    "	58	-171	-169	-162	-159	-155	-149	-147	-145",
    "	57	-171	-168	-162	-150",
    "	56	-171	-168	-164	-151",
    "	55	-170	-152",
    "	54	-170	-154",
    "	53	-177	-158",
    "	52	-180	-165",
    "	51	-180	-167",
    "	50	-180	-174",
    "USA: Arizona",
    "	38	-115	-108",
    "	37	-115	-108",
    "	36	-115	-108",
    "	35	-115	-108",
    "	34	-115	-108",
    "	33	-115	-108",
    "	32	-115	-108",
    "	31	-115	-108",
    "	30	-114	-108",
    "USA: Arkansas",
    "	37	-95	-88",
    "	36	-95	-88",
    "	35	-95	-88",
    "	34	-95	-88",
    "	33	-95	-89",
    "	32	-95	-90",
    "USA: California",
    "	43	-125	-119",
    "	42	-125	-119",
    "	41	-125	-119",
    "	40	-125	-119",
    "	39	-125	-117",
    "	38	-124	-116",
    "	37	-124	-115",
    "	36	-124	-113",
    "	35	-123	-113",
    "	34	-122	-113",
    "	33	-121	-113",
    "	32	-121	-113",
    "	31	-119	-113",
    "USA: Colorado",
    "	42	-110	-101",
    "	41	-110	-101",
    "	40	-110	-101",
    "	39	-110	-101",
    "	38	-110	-101",
    "	37	-110	-101",
    "	36	-110	-101",
    "USA: Connecticut",
    "	43	-74	-70",
    "	42	-74	-70",
    "	41	-74	-70",
    "	40	-74	-70",
    "USA: Delaware",
    "	40	-76	-74",
    "	39	-76	-74",
    "	38	-76	-74",
    "	37	-76	-74",
    "USA: District of Columbia",
    "	39	-78	-75",
    "	38	-78	-75",
    "	37	-78	-75",
    "USA: Florida",
    "	32	-88	-84",
    "	31	-88	-80",
    "	30	-88	-79",
    "	29	-88	-79",
    "	28	-86	-79",
    "	27	-83	-79",
    "	26	-83	-79",
    "	25	-83	-79",
    "	24	-83	-79",
    "	23	-83	-79",
    "USA: Georgia",
    "	36	-84	-82",
    "	35	-86	-81",
    "	34	-86	-80",
    "	33	-86	-79",
    "	32	-86	-79",
    "	31	-86	-79",
    "	30	-86	-79",
    "	29	-86	-80",
    "USA: Hawaii",
    "	27	-174	-172",
    "	26	-174	-166",
    "	25	-174	-166",
    "	24	-172	-160",
    "	23	-165	-158",
    "	22	-165	-155",
    "	21	-161	-154",
    "	20	-161	-153",
    "	19	-158	-153",
    "	18	-157	-153",
    "	17	-156	-154",
    "USA: Idaho",
    "	49	-118	-115",
    "	48	-118	-114",
    "	47	-118	-113",
    "	46	-118	-112",
    "	45	-118	-110",
    "	44	-118	-110",
    "	43	-118	-110",
    "	42	-118	-110",
    "	41	-118	-110",
    "USA: Illinois",
    "	43	-91	-86",
    "	42	-92	-86",
    "	41	-92	-86",
    "	40	-92	-86",
    "	39	-92	-86",
    "	38	-92	-86",
    "	37	-91	-86",
    "	36	-91	-87",
    "	35	-90	-88",
    "USA: Indiana",
    "	42	-88	-83",
    "	41	-88	-83",
    "	40	-88	-83",
    "	39	-89	-83",
    "	38	-89	-83",
    "	37	-89	-83",
    "	36	-89	-85",
    "USA: Iowa",
    "	44	-97	-90",
    "	43	-97	-89",
    "	42	-97	-89",
    "	41	-97	-89",
    "	40	-97	-89",
    "	39	-96	-89",
    "USA: Kansas",
    "	41	-103	-94",
    "	40	-103	-93",
    "	39	-103	-93",
    "	38	-103	-93",
    "	37	-103	-93",
    "	36	-103	-93",
    "USA: Kentucky",
    "	40	-85	-83",
    "	39	-87	-81",
    "	38	-90	-80",
    "	37	-90	-80",
    "	36	-90	-80",
    "	35	-90	-81",
    "USA: Louisiana",
    "	34	-95	-90",
    "	33	-95	-89",
    "	32	-95	-88",
    "	31	-95	-87",
    "	30	-95	-87",
    "	29	-94	-87",
    "	28	-94	-87",
    "	27	-90	-88",
    "USA: Maine",
    "	48	-70	-66",
    "	47	-71	-66",
    "	46	-72	-66",
    "	45	-72	-65",
    "	44	-72	-65",
    "	43	-72	-65",
    "	42	-71	-68",
    "USA: Maryland",
    "	40	-80	-74",
    "	39	-80	-74",
    "	38	-80	-74",
    "	37	-78	-74",
    "	36	-77	-74",
    "USA: Massachusetts",
    "	43	-74	-69",
    "	42	-74	-68",
    "	41	-74	-68",
    "	40	-72	-68",
    "USA: Michigan",
    "	49	-90	-86",
    "	48	-91	-84",
    "	47	-91	-82",
    "	46	-91	-81",
    "	45	-91	-81",
    "	44	-89	-81",
    "	43	-88	-81",
    "	42	-88	-81",
    "	41	-88	-81",
    "	40	-88	-82",
    "USA: Minnesota",
    "	50	-96	-93",
    "	49	-98	-88",
    "	48	-98	-88",
    "	47	-98	-88",
    "	46	-98	-88",
    "	45	-97	-90",
    "	44	-97	-90",
    "	43	-97	-90",
    "	42	-97	-90",
    "USA: Mississippi",
    "	36	-91	-88",
    "	35	-92	-87",
    "	34	-92	-87",
    "	33	-92	-87",
    "	32	-92	-87",
    "	31	-92	-87",
    "	30	-92	-87",
    "	29	-90	-87",
    "USA: Missouri",
    "	41	-96	-90",
    "	40	-96	-89",
    "	39	-96	-89",
    "	38	-96	-88",
    "	37	-95	-88",
    "	36	-95	-88",
    "	35	-95	-88",
    "	34	-91	-88",
    "USA: Montana",
    "	49	-117	-103",
    "	48	-117	-103",
    "	47	-117	-103",
    "	46	-117	-103",
    "	45	-116	-103",
    "	44	-115	-103",
    "	43	-114	-110",
    "USA: Nebraska",
    "	44	-105	-97",
    "	43	-105	-95",
    "	42	-105	-94",
    "	41	-105	-94",
    "	40	-105	-94",
    "	39	-103	-94",
    "USA: Nevada",
    "	43	-121	-113",
    "	42	-121	-113",
    "	41	-121	-113",
    "	40	-121	-113",
    "	39	-121	-113",
    "	38	-121	-113",
    "	37	-120	-113",
    "	36	-119	-113",
    "	35	-118	-113",
    "	34	-116	-113",
    "USA: New Hampshire",
    "	46	-72	-70",
    "	45	-73	-69",
    "	44	-73	-69",
    "	43	-73	-69",
    "	42	-73	-69",
    "	41	-73	-69",
    "USA: New Jersey",
    "	42	-76	-73",
    "	41	-76	-72",
    "	40	-76	-72",
    "	39	-76	-72",
    "	38	-76	-73",
    "	37	-75	-73",
    "USA: New Mexico",
    "	38	-110	-102",
    "	37	-110	-102",
    "	36	-110	-102",
    "	35	-110	-102",
    "	34	-110	-102",
    "	33	-110	-102",
    "	32	-110	-102",
    "	31	-110	-102",
    "	30	-110	-105",
    "USA: New York",
    "	46	-75	-72",
    "	45	-77	-72",
    "	44	-80	-72",
    "	43	-80	-72",
    "	42	-80	-70",
    "	41	-80	-70",
    "	40	-79	-70",
    "	39	-75	-71",
    "USA: North Carolina",
    "	37	-83	-74",
    "	36	-85	-74",
    "	35	-85	-74",
    "	34	-85	-74",
    "	33	-85	-75",
    "	32	-79	-76",
    "USA: North Dakota",
    "	49	-105	-96",
    "	48	-105	-95",
    "	47	-105	-95",
    "	46	-105	-95",
    "	45	-105	-95",
    "	44	-105	-95",
    "USA: Ohio",
    "	43	-82	-79",
    "	42	-85	-79",
    "	41	-85	-79",
    "	40	-85	-79",
    "	39	-85	-79",
    "	38	-85	-79",
    "	37	-85	-80",
    "USA: Oklahoma",
    "	38	-104	-93",
    "	37	-104	-93",
    "	36	-104	-93",
    "	35	-104	-93",
    "	34	-101	-93",
    "	33	-101	-93",
    "	32	-98	-93",
    "USA: Oregon",
    "	47	-124	-115",
    "	46	-125	-115",
    "	45	-125	-115",
    "	44	-125	-115",
    "	43	-125	-115",
    "	42	-125	-115",
    "	41	-125	-116",
    "USA: Pennsylvania",
    "	43	-81	-77",
    "	42	-81	-73",
    "	41	-81	-73",
    "	40	-81	-73",
    "	39	-81	-73",
    "	38	-81	-74",
    "USA: Rhode Island",
    "	43	-72	-70",
    "	42	-72	-70",
    "	41	-72	-70",
    "	40	-72	-70",
    "USA: South Carolina",
    "	36	-84	-79",
    "	35	-84	-77",
    "	34	-84	-77",
    "	33	-84	-77",
    "	32	-83	-77",
    "	31	-82	-78",
    "USA: South Dakota",
    "	46	-105	-95",
    "	45	-105	-95",
    "	44	-105	-95",
    "	43	-105	-95",
    "	42	-105	-95",
    "	41	-99	-95",
    "USA: Tennessee",
    "	37	-90	-80",
    "	36	-91	-80",
    "	35	-91	-80",
    "	34	-91	-81",
    "	33	-90	-83",
    "USA: Texas",
    "	37	-104	-99",
    "	36	-104	-99",
    "	35	-104	-97",
    "	34	-104	-93",
    "	33	-107	-93",
    "	32	-107	-92",
    "	31	-107	-92",
    "	30	-107	-92",
    "	29	-106	-92",
    "	28	-105	-92",
    "	27	-104	-94",
    "	26	-100	-95",
    "	25	-100	-96",
    "	24	-98	-96",
    "USA: Utah",
    "	43	-115	-110",
    "	42	-115	-108",
    "	41	-115	-108",
    "	40	-115	-108",
    "	39	-115	-108",
    "	38	-115	-108",
    "	37	-115	-108",
    "	36	-115	-108",
    "USA: Vermont",
    "	46	-74	-70",
    "	45	-74	-70",
    "	44	-74	-70",
    "	43	-74	-70",
    "	42	-74	-71",
    "	41	-74	-71",
    "USA: Virginia",
    "	40	-79	-76",
    "	39	-81	-74",
    "	38	-83	-74",
    "	37	-84	-74",
    "	36	-84	-74",
    "	35	-84	-74",
    "USA: Washington",
    "	49	-125	-116",
    "	48	-125	-116",
    "	47	-125	-115",
    "	46	-125	-115",
    "	45	-125	-115",
    "	44	-123	-118",
    "USA: West Virginia",
    "	41	-81	-79",
    "	40	-83	-76",
    "	39	-83	-76",
    "	38	-83	-76",
    "	37	-83	-77",
    "	36	-83	-79",
    "USA: Wisconsin",
    "	48	-92	-88",
    "	47	-93	-87",
    "	46	-93	-85",
    "	45	-93	-85",
    "	44	-93	-85",
    "	43	-93	-85",
    "	42	-92	-86",
    "	41	-92	-86",
    "USA: Wyoming",
    "	46	-112	-103",
    "	45	-112	-103",
    "	44	-112	-103",
    "	43	-112	-103",
    "	42	-112	-103",
    "	41	-112	-103",
    "	40	-112	-103",
    "Uzbekistan",
    "	46	55	60",
    "	45	54	62",
    "	44	54	66",
    "	43	54	67	69	72",
    "	42	54	73",
    "	41	54	74",
    "	40	54	74",
    "	39	60	74",
    "	38	61	72",
    "	37	63	69",
    "	36	65	69",
    "Vanuatu",
    "	-12	165	168",
    "	-13	165	169",
    "	-14	165	169",
    "	-15	165	169",
    "	-16	165	169",
    "	-17	166	170",
    "	-18	167	170",
    "	-19	167	170",
    "	-20	168	170",
    "	-21	168	170",
    "Venezuela",
    "	13	-71	-66",
    "	12	-73	-62",
    "	11	-73	-60",
    "	10	-74	-59",
    "	9	-74	-58",
    "	8	-74	-58",
    "	7	-73	-58",
    "	6	-73	-59",
    "	5	-72	-59",
    "	4	-68	-59",
    "	3	-68	-59",
    "	2	-68	-61",
    "	1	-68	-62",
    "	0	-68	-62",
    "	-1	-67	-64",
    "Viet Nam",
    "	24	103	106",
    "	23	101	107",
    "	22	101	108",
    "	21	101	108",
    "	20	101	108",
    "	19	102	108",
    "	18	102	108",
    "	17	103	109",
    "	16	104	109",
    "	15	105	110",
    "	14	106	110",
    "	13	105	110",
    "	12	104	110",
    "	11	102	110",
    "	10	102	110",
    "	9	102	109",
    "	8	103	107",
    "	7	103	107",
    "Virgin Islands",
    "	19	-66	-63",
    "	18	-66	-63",
    "	17	-66	-63",
    "	16	-65	-63",
    "Wake Island",
    "	20	165	167",
    "	19	165	167",
    "	18	165	167",
    "Wallis and Futuna",
    "	-12	-177	-175",
    "	-13	-179	-175",
    "	-14	-179	-175",
    "	-15	-179	-176",
    "West Bank",
    "	33	33	36",
    "	32	33	36",
    "	31	33	36",
    "	30	33	36",
    "Western Sahara",
    "	28	-14	-7",
    "	27	-15	-7",
    "	26	-15	-7",
    "	25	-16	-7",
    "	24	-17	-7",
    "	23	-17	-11",
    "	22	-18	-11",
    "	21	-18	-12",
    "	20	-18	-12",
    "	19	-18	-16",
    "Yemen",
    "	19	47	53",
    "	18	42	53",
    "	17	41	54",
    "	16	41	54",
    "	15	41	54",
    "	14	41	53",
    "	13	41	55",
    "	12	41	49	51	55",
    "	11	42	46	51	55",
    "Zambia",
    "	-7	27	32",
    "	-8	27	34",
    "	-9	22	25	27	34",
    "	-10	22	34",
    "	-11	22	34",
    "	-12	20	34",
    "	-13	20	34",
    "	-14	20	34",
    "	-15	20	34",
    "	-16	20	31",
    "	-17	20	29",
    "	-18	21	28",
    "	-19	24	27",
    "Zimbabwe",
    "	-14	27	32",
    "	-15	26	33",
    "	-16	24	34",
    "	-17	24	34",
    "	-18	24	34",
    "	-19	24	34",
    "	-20	24	34",
    "	-21	25	34",
    "	-22	26	33",
    "	-23	28	32"
};
