/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Compute the natural logarithm of the binomial coefficient.
*
* @module @stdlib/math/base/special/binomcoefln
*
* @example
* var binomcoefln = require( '@stdlib/math/base/special/binomcoefln' );
*
* var v = binomcoefln( 8, 2 );
* // returns ~3.332
*
* v = binomcoefln( 0, 0 );
* // returns 0.0
*
* v = binomcoefln( -4, 2 );
* // returns ~2.302
*
* v = binomcoefln( 88, 3 );
* // returns ~11.606
*
* v = binomcoefln( NaN, 3 );
* // returns NaN
*
* v = binomcoefln( 5, NaN );
* // returns NaN
*
* v = binomcoefln( NaN, NaN );
* // returns NaN
*/

// MODULES //

var binomcoefln = require( './binomcoefln.js' );


// EXPORTS //

module.exports = binomcoefln;
