// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _math_GaussSingleIntegration_HeaderFile
#define _math_GaussSingleIntegration_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

#include <Standard_Real.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
#include <Standard_OStream.hxx>
class StdFail_NotDone;
class math_Function;



//! This class implements the integration of a function of a single variable
//! between the parameter bounds Lower and Upper.
//! Warning: Order must be inferior or equal to 61.
class math_GaussSingleIntegration 
{
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT math_GaussSingleIntegration();
  

  //! The Gauss-Legendre integration with N = Order points of integration,
  //! is done on the function F between the bounds Lower and Upper.
  Standard_EXPORT math_GaussSingleIntegration(math_Function& F, const Standard_Real Lower, const Standard_Real Upper, const Standard_Integer Order);
  

  //! The Gauss-Legendre integration with N = Order points of integration  and
  //! given tolerance = Tol is done on the function F between the bounds
  //! Lower and Upper.
  Standard_EXPORT math_GaussSingleIntegration(math_Function& F, const Standard_Real Lower, const Standard_Real Upper, const Standard_Integer Order, const Standard_Real Tol);
  
  //! returns True if all has been correctly done.
      Standard_Boolean IsDone()  const;
  
  //! returns the value of the integral.
      Standard_Real Value()  const;
  
  //! Prints information on the current state of the object.
  Standard_EXPORT   void Dump (Standard_OStream& o)  const;




protected:





private:

  
  //! perfoms  actual  computation
  Standard_EXPORT   void Perform (math_Function& F, const Standard_Real Lower, const Standard_Real Upper, const Standard_Integer Order) ;


  Standard_Real Val;
  Standard_Boolean Done;


};


#include <math_GaussSingleIntegration.lxx>





#endif // _math_GaussSingleIntegration_HeaderFile
