CORBA_INTERFACES = echo

CXXSRCS = greeting.cc eg1.cc -
          eg2_impl.cc eg2_clt.cc -
          eg3_impl.cc eg3_clt.cc -
          eg3_tieimpl.cc

# uncomment this line if your compiler is 5.5 or older:
# NoTieExample=1
.ifdef NoTieExample
.else
DIR_IDLFLAGS = -Wbtp
.endif

DIR_CXXMACROS=HAVE_STD

eg1        = eg1$(CONFIG_SUFFIX).exe
eg2_impl   = eg2_impl$(CONFIG_SUFFIX).exe
eg2_clt    = eg2_clt$(CONFIG_SUFFIX).exe
eg3_impl   = eg3_impl$(CONFIG_SUFFIX).exe
eg3_clt    = eg3_clt$(CONFIG_SUFFIX).exe

.ifdef NoTieExample
.else
eg3_tieimpl = eg3_tieimpl$(CONFIG_SUFFIX).exe
.endif

all :: $(eg1) $(eg2_impl) $(eg2_clt)  $(eg3_impl) $(eg3_clt) $(eg3_tieimpl)

clean ::
	$(RM) $(eg1) $(eg2_impl) $(eg2_clt) $(eg3_impl) $(eg3_clt) $(eg3_tieimpl)

export :: $(eg1)
	@ $(ExportExecutable)

export :: $(eg2_impl) 
	@ $(ExportExecutable)

export :: $(eg2_clt) 
	@ $(ExportExecutable)

export :: $(eg3_impl) 
	@ $(ExportExecutable)

export :: $(eg3_clt)
	@ $(ExportExecutable)

.ifdef NoTieExample
.else
export :: $(eg3_tieimpl)
	@ $(ExportExecutable)
.endif

OBJ_LIBS = $(CORBA_LIB)
OBJ_LIB_DEPEND = $(CORBA_LIB_DEPEND)

$(eg1) : eg1.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg2_impl) : eg2_impl.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg2_clt) : eg2_clt.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg3_impl) : eg3_impl.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg3_clt) : eg3_clt.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg3_tieimpl) : eg3_tieimpl.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

show ::
	show logical corbastubs
	dir corbastubs:
	dir corbastubs:*.obj
