//============================================================================
//
//   SSSS    tt          lll  lll
//  SS  SS   tt           ll   ll
//  SS     tttttt  eeee   ll   ll   aaaa
//   SSSS    tt   ee  ee  ll   ll      aa
//      SS   tt   eeeeee  ll   ll   aaaaa  --  "An Atari 2600 VCS Emulator"
//  SS  SS   tt   ee      ll   ll  aa  aa
//   SSSS     ttt  eeeee llll llll  aaaaa
//
// Copyright (c) 1995-2021 by Bradford W. Mott, Stephen Anthony
// and the Stella Team
//
// See the file "License.txt" for information on usage and redistribution of
// this file, and for a DISCLAIMER OF ALL WARRANTIES.
//
// Generated by src/tools/convbdf on Sun Mar 15 08:40:37 2020.
//============================================================================

#ifndef STELLA14X28T_FONT_DATA_HXX
#define STELLA14X28T_FONT_DATA_HXX

#include "Font.hxx"

/* Font information:
   name: ter-u28b
   facename: -xos4-Terminus-Bold-R-Normal--28-280-72-72-C-140-ISO10646-1
   w x h: 14x28
   bbx: 14 28 0 -6
   size: 95
   ascent: 22
   descent: 6
   first char: 32 (0x20)
   last char: 126 (0x7e)
   default char: 32 (0x20)
   proportional: no
   Copyright (C) 2014 Dimitar Toshkov Zhekov
*/

namespace GUI {

// Font character bitmap data.
static const uInt16 stella14x28t_font_bits[] = {  // NOLINT : too complicated to convert

/* Character 28 (0x1c):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0b0000011110000000,
0b0000111111000000,
0b0001110011100000,
0b0001100001100000,
0b0001100001100000,
0b0001110011100000,
0b0000111111000000,
0b0000011110000000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,


/* Character 29 (0x1d):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |  **  **  **  |
   |  **  **  **  |
   |  **  **  **  |
   |  **  **  **  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0b0011001100110000,
0b0011001100110000,
0b0011001100110000,
0b0011001100110000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 30 (0x1e):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 31 (0x1f):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |     ****     |
   |   ********   |
   |  **********  |
   |  **********  |
   | ************ |
   | ************ |
   | ************ |
   | ************ |
   | ************ |
   | ************ |
   |  **********  |
   |  **********  |
   |   ********   |
   |     ****     |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0b0000011110000000,
0b0001111111100000,
0b0011111111110000,
0b0011111111110000,
0b0111111111111000,
0b0111111111111000,
0b0111111111111000,
0b0111111111111000,
0b0111111111111000,
0b0111111111111000,
0b0011111111110000,
0b0011111111110000,
0b0001111111100000,
0b0000011110000000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 32 (0x20):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 33 (0x21):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 34 (0x22):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x18c0,
0x18c0,
0x18c0,
0x18c0,
0x18c0,
0x18c0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 35 (0x23):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   | ***********  |
   | ***********  |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   | ***********  |
   | ***********  |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x18c0,
0x18c0,
0x18c0,
0x18c0,
0x7ff0,
0x7ff0,
0x18c0,
0x18c0,
0x18c0,
0x18c0,
0x18c0,
0x18c0,
0x7ff0,
0x7ff0,
0x18c0,
0x18c0,
0x18c0,
0x18c0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 36 (0x24):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |   ********   |
   |  **********  |
   | ***  **  *** |
   | **   **   ** |
   | **   **      |
   | **   **      |
   | ***  **      |
   |  *********   |
   |   *********  |
   |      **  *** |
   |      **   ** |
   |      **   ** |
   | **   **   ** |
   | ***  **  *** |
   |  **********  |
   |   ********   |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x1fe0,
0x3ff0,
0x7338,
0x6318,
0x6300,
0x6300,
0x7300,
0x3fe0,
0x1ff0,
0x0338,
0x0318,
0x0318,
0x6318,
0x7338,
0x3ff0,
0x1fe0,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 37 (0x25):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |  ****    **  |
   | ******   **  |
   | **  **  **   |
   | ******  **   |
   |  ****  **    |
   |        **    |
   |       **     |
   |       **     |
   |      **      |
   |      **      |
   |     **       |
   |     **       |
   |    **        |
   |    **  ****  |
   |   **  ****** |
   |   **  **  ** |
   |  **   ****** |
   |  **    ****  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x3c30,
0x7e30,
0x6660,
0x7e60,
0x3cc0,
0x00c0,
0x0180,
0x0180,
0x0300,
0x0300,
0x0600,
0x0600,
0x0c00,
0x0cf0,
0x19f8,
0x1998,
0x31f8,
0x30f0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 38 (0x26):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |    ****      |
   |   ******     |
   |  ***  ***    |
   |  **    **    |
   |  **    **    |
   |  ***  ***    |
   |   ******     |
   |    ****      |
   |    ***       |
   |   *****   ** |
   |  *** *** *** |
   | ***   *****  |
   | **     ***   |
   | **     ***   |
   | **     ***   |
   | ***   *****  |
   |  ******* *** |
   |   *****   ** |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0f00,
0x1f80,
0x39c0,
0x30c0,
0x30c0,
0x39c0,
0x1f80,
0x0f00,
0x0e00,
0x1f18,
0x3bb8,
0x71f0,
0x60e0,
0x60e0,
0x60e0,
0x71f0,
0x3fb8,
0x1f18,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 39 (0x27):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 40 (0x28):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |       **     |
   |      **      |
   |     **       |
   |     **       |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |     **       |
   |     **       |
   |      **      |
   |       **     |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0180,
0x0300,
0x0600,
0x0600,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0600,
0x0600,
0x0300,
0x0180,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 41 (0x29):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |    **        |
   |     **       |
   |      **      |
   |      **      |
   |       **     |
   |       **     |
   |       **     |
   |       **     |
   |       **     |
   |       **     |
   |       **     |
   |       **     |
   |       **     |
   |       **     |
   |      **      |
   |      **      |
   |     **       |
   |    **        |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0c00,
0x0600,
0x0300,
0x0300,
0x0180,
0x0180,
0x0180,
0x0180,
0x0180,
0x0180,
0x0180,
0x0180,
0x0180,
0x0180,
0x0300,
0x0300,
0x0600,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 42 (0x2a):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |  ***   ***   |
   |   *** ***    |
   |    *****     |
   |     ***      |
   | ***********  |
   | ***********  |
   |     ***      |
   |    *****     |
   |   *** ***    |
   |  ***   ***   |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x38e0,
0x1dc0,
0x0f80,
0x0700,
0x7ff0,
0x7ff0,
0x0700,
0x0f80,
0x1dc0,
0x38e0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 43 (0x2b):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   | ************ |
   | ************ |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x7ff8,
0x7ff8,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 44 (0x2c):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |     **       |
   |    **        |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0300,
0x0600,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 45 (0x2d):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | ***********  |
   | ***********  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 46 (0x2e):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 47 (0x2f):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |          **  |
   |          **  |
   |         **   |
   |         **   |
   |        **    |
   |        **    |
   |       **     |
   |       **     |
   |      **      |
   |      **      |
   |     **       |
   |     **       |
   |    **        |
   |    **        |
   |   **         |
   |   **         |
   |  **          |
   |  **          |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0030,
0x0030,
0x0060,
0x0060,
0x00c0,
0x00c0,
0x0180,
0x0180,
0x0300,
0x0300,
0x0600,
0x0600,
0x0c00,
0x0c00,
0x1800,
0x1800,
0x3000,
0x3000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 48 (0x30):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **      ***  |
   | **     ****  |
   | **    *****  |
   | **   *** **  |
   | **  ***  **  |
   | ** ***   **  |
   | *****    **  |
   | ****     **  |
   | ***      **  |
   | **       **  |
   | **       **  |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6070,
0x60f0,
0x61f0,
0x63b0,
0x6730,
0x6e30,
0x7c30,
0x7830,
0x7030,
0x6030,
0x6030,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 49 (0x31):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |      **      |
   |     ***      |
   |    ****      |
   |   *****      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |   ********   |
   |   ********   |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0300,
0x0700,
0x0f00,
0x1f00,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x1fe0,
0x1fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 50 (0x32):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   |          **  |
   |         ***  |
   |        ***   |
   |       ***    |
   |      ***     |
   |     ***      |
   |    ***       |
   |   ***        |
   |  ***         |
   | ***          |
   | ***********  |
   | ***********  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6030,
0x6030,
0x0030,
0x0070,
0x00e0,
0x01c0,
0x0380,
0x0700,
0x0e00,
0x1c00,
0x3800,
0x7000,
0x7ff0,
0x7ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 51 (0x33):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   |          **  |
   |          **  |
   |          **  |
   |         ***  |
   |    *******   |
   |    *******   |
   |         ***  |
   |          **  |
   |          **  |
   |          **  |
   | **       **  |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x0030,
0x0030,
0x0030,
0x0070,
0x0fe0,
0x0fe0,
0x0070,
0x0030,
0x0030,
0x0030,
0x6030,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 52 (0x34):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |          **  |
   |         ***  |
   |        ****  |
   |       *****  |
   |      *** **  |
   |     ***  **  |
   |    ***   **  |
   |   ***    **  |
   |  ***     **  |
   | ***      **  |
   | **       **  |
   | **       **  |
   | ***********  |
   | ***********  |
   |          **  |
   |          **  |
   |          **  |
   |          **  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0030,
0x0070,
0x00f0,
0x01f0,
0x03b0,
0x0730,
0x0e30,
0x1c30,
0x3830,
0x7030,
0x6030,
0x6030,
0x7ff0,
0x7ff0,
0x0030,
0x0030,
0x0030,
0x0030,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 53 (0x35):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | ***********  |
   | ***********  |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | *********    |
   | **********   |
   |         ***  |
   |          **  |
   |          **  |
   |          **  |
   |          **  |
   | **       **  |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff0,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7fc0,
0x7fe0,
0x0070,
0x0030,
0x0030,
0x0030,
0x0030,
0x6030,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 54 (0x36):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   ********   |
   |  *********   |
   | ***          |
   | **           |
   | **           |
   | **           |
   | **           |
   | *********    |
   | **********   |
   | **      ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fe0,
0x3fe0,
0x7000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7fc0,
0x7fe0,
0x6070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 55 (0x37):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | ***********  |
   | ***********  |
   | **       **  |
   | **       **  |
   | **       **  |
   |         **   |
   |         **   |
   |        **    |
   |        **    |
   |       **     |
   |       **     |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff0,
0x6030,
0x6030,
0x6030,
0x0060,
0x0060,
0x00c0,
0x00c0,
0x0180,
0x0180,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 56 (0x38):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***     ***  |
   |  *********   |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6030,
0x6030,
0x6030,
0x7070,
0x3fe0,
0x3fe0,
0x7070,
0x6030,
0x6030,
0x6030,
0x6030,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 57 (0x39):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***      **  |
   |  **********  |
   |   *********  |
   |          **  |
   |          **  |
   |          **  |
   |          **  |
   |         ***  |
   |  *********   |
   |  ********    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7030,
0x3ff0,
0x1ff0,
0x0030,
0x0030,
0x0030,
0x0030,
0x0070,
0x3fe0,
0x3fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 58 (0x3a):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 59 (0x3b):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |     **       |
   |    **        |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0300,
0x0600,
0x0c00,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 60 (0x3c):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |         ***  |
   |        ***   |
   |       ***    |
   |      ***     |
   |     ***      |
   |    ***       |
   |   ***        |
   |  ***         |
   | ***          |
   |  ***         |
   |   ***        |
   |    ***       |
   |     ***      |
   |      ***     |
   |       ***    |
   |        ***   |
   |         ***  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0070,
0x00e0,
0x01c0,
0x0380,
0x0700,
0x0e00,
0x1c00,
0x3800,
0x7000,
0x3800,
0x1c00,
0x0e00,
0x0700,
0x0380,
0x01c0,
0x00e0,
0x0070,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 61 (0x3d):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | ***********  |
   | ***********  |
   |              |
   |              |
   |              |
   |              |
   | ***********  |
   | ***********  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 62 (0x3e):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   | ***          |
   |  ***         |
   |   ***        |
   |    ***       |
   |     ***      |
   |      ***     |
   |       ***    |
   |        ***   |
   |         ***  |
   |        ***   |
   |       ***    |
   |      ***     |
   |     ***      |
   |    ***       |
   |   ***        |
   |  ***         |
   | ***          |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7000,
0x3800,
0x1c00,
0x0e00,
0x0700,
0x0380,
0x01c0,
0x00e0,
0x0070,
0x00e0,
0x01c0,
0x0380,
0x0700,
0x0e00,
0x1c00,
0x3800,
0x7000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 63 (0x3f):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   |         ***  |
   |        ***   |
   |       ***    |
   |      ***     |
   |      **      |
   |      **      |
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6030,
0x6030,
0x0070,
0x00e0,
0x01c0,
0x0380,
0x0300,
0x0300,
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 64 (0x40):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   ********   |
   |  **********  |
   | ***      *** |
   | **        ** |
   | **    ****** |
   | **   ******* |
   | **  ***   ** |
   | **  **    ** |
   | **  **    ** |
   | **  **    ** |
   | **  **    ** |
   | **  ***   ** |
   | **   ******* |
   | **    **** * |
   | **           |
   | ***          |
   |  *********** |
   |   ********** |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fe0,
0x3ff0,
0x7038,
0x6018,
0x61f8,
0x63f8,
0x6718,
0x6618,
0x6618,
0x6618,
0x6618,
0x6718,
0x63f8,
0x61e8,
0x6000,
0x7000,
0x3ff8,
0x1ff8,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 65 (0x41):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***********  |
   | ***********  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7ff0,
0x7ff0,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 66 (0x42):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | *********    |
   | **********   |
   | **      ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **      **   |
   | *********    |
   | *********    |
   | **      **   |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **      ***  |
   | **********   |
   | *********    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7fc0,
0x7fe0,
0x6070,
0x6030,
0x6030,
0x6030,
0x6060,
0x7fc0,
0x7fc0,
0x6060,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6070,
0x7fe0,
0x7fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 67 (0x43):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **       **  |
   | **       **  |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6030,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6030,
0x6030,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 68 (0x44):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | *******      |
   | *********    |
   | **     ***   |
   | **      **   |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **      **   |
   | **     ***   |
   | *********    |
   | *******      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7f00,
0x7fc0,
0x60e0,
0x6060,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6060,
0x60e0,
0x7fc0,
0x7f00,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 69 (0x45):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | ***********  |
   | ***********  |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | ********     |
   | ********     |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | ***********  |
   | ***********  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff0,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7f80,
0x7f80,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7ff0,
0x7ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 70 (0x46):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | ***********  |
   | ***********  |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | ********     |
   | ********     |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff0,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7f80,
0x7f80,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 71 (0x47):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   | **           |
   | **           |
   | **           |
   | **   ******  |
   | **   ******  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6030,
0x6000,
0x6000,
0x6000,
0x63f0,
0x63f0,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 72 (0x48):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***********  |
   | ***********  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7ff0,
0x7ff0,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 73 (0x49):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |    ******    |
   |    ******    |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |    ******    |
   |    ******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0fc0,
0x0fc0,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0fc0,
0x0fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 74 (0x4a):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |       ****** |
   |       ****** |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   | **      **   |
   | **      **   |
   | **      **   |
   | ***    ***   |
   |  ********    |
   |   ******     |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x01f8,
0x01f8,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x6060,
0x6060,
0x6060,
0x70e0,
0x3fc0,
0x1f80,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 75 (0x4b):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | **       **  |
   | **      ***  |
   | **     ***   |
   | **    ***    |
   | **   ***     |
   | **  ***      |
   | ** ***       |
   | *****        |
   | ****         |
   | ****         |
   | *****        |
   | ** ***       |
   | **  ***      |
   | **   ***     |
   | **    ***    |
   | **     ***   |
   | **      ***  |
   | **       **  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6030,
0x6070,
0x60e0,
0x61c0,
0x6380,
0x6700,
0x6e00,
0x7c00,
0x7800,
0x7800,
0x7c00,
0x6e00,
0x6700,
0x6380,
0x61c0,
0x60e0,
0x6070,
0x6030,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 76 (0x4c):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | ***********  |
   | ***********  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7ff0,
0x7ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 77 (0x4d):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | **        ** |
   | **        ** |
   | ***      *** |
   | ****    **** |
   | *****  ***** |
   | ** ****** ** |
   | **  ****  ** |
   | **   **   ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6018,
0x6018,
0x7038,
0x7878,
0x7cf8,
0x6fd8,
0x6798,
0x6318,
0x6018,
0x6018,
0x6018,
0x6018,
0x6018,
0x6018,
0x6018,
0x6018,
0x6018,
0x6018,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 78 (0x4e):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***      **  |
   | ****     **  |
   | *****    **  |
   | ** ***   **  |
   | **  ***  **  |
   | **   *** **  |
   | **    *****  |
   | **     ****  |
   | **      ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6030,
0x6030,
0x6030,
0x6030,
0x7030,
0x7830,
0x7c30,
0x6e30,
0x6730,
0x63b0,
0x61f0,
0x60f0,
0x6070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 79 (0x4f):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 80 (0x50):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | *********    |
   | **********   |
   | **      ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **      ***  |
   | **********   |
   | *********    |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7fc0,
0x7fe0,
0x6070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6070,
0x7fe0,
0x7fc0,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 81 (0x51):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **   *** **  |
   | ***   *****  |
   |  *********   |
   |   ********   |
   |         ***  |
   |          *** |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x63b0,
0x71f0,
0x3fe0,
0x1fe0,
0x0070,
0x0038,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 82 (0x52):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | *********    |
   | **********   |
   | **      ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **      ***  |
   | **********   |
   | *********    |
   | *****        |
   | ** ***       |
   | **  ***      |
   | **   ***     |
   | **    ***    |
   | **     ***   |
   | **      ***  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7fc0,
0x7fe0,
0x6070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6070,
0x7fe0,
0x7fc0,
0x7c00,
0x6e00,
0x6700,
0x6380,
0x61c0,
0x60e0,
0x6070,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 83 (0x53):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **           |
   | **           |
   | **           |
   | ***          |
   |  ********    |
   |   ********   |
   |         ***  |
   |          **  |
   |          **  |
   |          **  |
   | **       **  |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6000,
0x6000,
0x6000,
0x7000,
0x3fc0,
0x1fe0,
0x0070,
0x0030,
0x0030,
0x0030,
0x6030,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 84 (0x54):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | ************ |
   | ************ |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff8,
0x7ff8,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 85 (0x55):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 86 (0x56):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   |  **     **   |
   |  **     **   |
   |  **     **   |
   |  **     **   |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |    ** **     |
   |    ** **     |
   |    ** **     |
   |     ***      |
   |     ***      |
   |     ***      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6030,
0x6030,
0x6030,
0x6030,
0x3060,
0x3060,
0x3060,
0x3060,
0x18c0,
0x18c0,
0x18c0,
0x18c0,
0x0d80,
0x0d80,
0x0d80,
0x0700,
0x0700,
0x0700,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 87 (0x57):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **   **   ** |
   | **  ****  ** |
   | ** ****** ** |
   | *****  ***** |
   | ****    **** |
   | ***      *** |
   | **        ** |
   | **        ** |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6018,
0x6018,
0x6018,
0x6018,
0x6018,
0x6018,
0x6018,
0x6018,
0x6018,
0x6018,
0x6318,
0x6798,
0x6fd8,
0x7cf8,
0x7878,
0x7038,
0x6018,
0x6018,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 88 (0x58):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | **       **  |
   | **       **  |
   |  **     **   |
   |  **     **   |
   |   **   **    |
   |   **   **    |
   |    ** **     |
   |    ** **     |
   |     ***      |
   |     ***      |
   |    ** **     |
   |    ** **     |
   |   **   **    |
   |   **   **    |
   |  **     **   |
   |  **     **   |
   | **       **  |
   | **       **  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6030,
0x6030,
0x3060,
0x3060,
0x18c0,
0x18c0,
0x0d80,
0x0d80,
0x0700,
0x0700,
0x0d80,
0x0d80,
0x18c0,
0x18c0,
0x3060,
0x3060,
0x6030,
0x6030,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 89 (0x59):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | **        ** |
   | **        ** |
   |  **      **  |
   |  **      **  |
   |   **    **   |
   |   **    **   |
   |    **  **    |
   |    **  **    |
   |     ****     |
   |     ****     |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6018,
0x6018,
0x3030,
0x3030,
0x1860,
0x1860,
0x0cc0,
0x0cc0,
0x0780,
0x0780,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 90 (0x5a):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | ***********  |
   | ***********  |
   |          **  |
   |          **  |
   |         ***  |
   |        ***   |
   |       ***    |
   |      ***     |
   |     ***      |
   |    ***       |
   |   ***        |
   |  ***         |
   | ***          |
   | **           |
   | **           |
   | **           |
   | ***********  |
   | ***********  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff0,
0x0030,
0x0030,
0x0070,
0x00e0,
0x01c0,
0x0380,
0x0700,
0x0e00,
0x1c00,
0x3800,
0x7000,
0x6000,
0x6000,
0x6000,
0x7ff0,
0x7ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 91 (0x5b):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |    ******    |
   |    ******    |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    **        |
   |    ******    |
   |    ******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0fc0,
0x0fc0,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0c00,
0x0fc0,
0x0fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 92 (0x5c):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |  **          |
   |  **          |
   |   **         |
   |   **         |
   |    **        |
   |    **        |
   |     **       |
   |     **       |
   |      **      |
   |      **      |
   |       **     |
   |       **     |
   |        **    |
   |        **    |
   |         **   |
   |         **   |
   |          **  |
   |          **  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x3000,
0x3000,
0x1800,
0x1800,
0x0c00,
0x0c00,
0x0600,
0x0600,
0x0300,
0x0300,
0x0180,
0x0180,
0x00c0,
0x00c0,
0x0060,
0x0060,
0x0030,
0x0030,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 93 (0x5d):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |    ******    |
   |    ******    |
   |        **    |
   |        **    |
   |        **    |
   |        **    |
   |        **    |
   |        **    |
   |        **    |
   |        **    |
   |        **    |
   |        **    |
   |        **    |
   |        **    |
   |        **    |
   |        **    |
   |    ******    |
   |    ******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0fc0,
0x0fc0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x00c0,
0x0fc0,
0x0fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 94 (0x5e):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |      *       |
   |     ***      |
   |    *****     |
   |   *** ***    |
   |  ***   ***   |
   | ***     ***  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0200,
0x0700,
0x0f80,
0x1dc0,
0x38e0,
0x7070,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 95 (0x5f):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | ***********  |
   | ***********  |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff0,
0x0000,
0x0000,
0x0000,

/* Character 96 (0x60):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |   ***        |
   |    ***       |
   |     ***      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x1c00,
0x0e00,
0x0700,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 97 (0x61):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |   ********   |
   |         ***  |
   |          **  |
   |   *********  |
   |  **********  |
   | ***      **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***      **  |
   |  **********  |
   |   *********  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x1fe0,
0x0070,
0x0030,
0x1ff0,
0x3ff0,
0x7030,
0x6030,
0x6030,
0x6030,
0x7030,
0x3ff0,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 98 (0x62):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | *********    |
   | **********   |
   | **      ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **      ***  |
   | **********   |
   | *********    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7fc0,
0x7fe0,
0x6070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6070,
0x7fe0,
0x7fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 99 (0x63):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 100 (0x64):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |          **  |
   |          **  |
   |          **  |
   |          **  |
   |          **  |
   |   *********  |
   |  **********  |
   | ***      **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***      **  |
   |  **********  |
   |   *********  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0030,
0x0030,
0x0030,
0x0030,
0x0030,
0x1ff0,
0x3ff0,
0x7030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7030,
0x3ff0,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 101 (0x65):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   | ***********  |
   | ***********  |
   | **           |
   | **           |
   | **           |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6030,
0x7ff0,
0x7ff0,
0x6000,
0x6000,
0x6000,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 102 (0x66):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |      ******  |
   |     *******  |
   |     **       |
   |     **       |
   |     **       |
   |  ********    |
   |  ********    |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x03f0,
0x07f0,
0x0600,
0x0600,
0x0600,
0x3fc0,
0x3fc0,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 103 (0x67):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |   *********  |
   |  **********  |
   | ***      **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***      **  |
   |  **********  |
   |   *********  |
   |          **  |
   |          **  |
   |         ***  |
   |  *********   |
   |  ********    |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff0,
0x7030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7030,
0x3ff0,
0x1ff0,
0x0030,
0x0030,
0x0070,
0x3fe0,
0x3fc0,
0x0000,

/* Character 104 (0x68):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | *********    |
   | **********   |
   | **      ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x7fc0,
0x7fe0,
0x6070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 105 (0x69):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |    ****      |
   |    ****      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |    ******    |
   |    ******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0f00,
0x0f00,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0fc0,
0x0fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 106 (0x6a):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |         **   |
   |         **   |
   |         **   |
   |              |
   |              |
   |       ****   |
   |       ****   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |         **   |
   |  **     **   |
   |  **     **   |
   |  ***   ***   |
   |   *******    |
   |    *****     |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0060,
0x0060,
0x0060,
0x0000,
0x0000,
0x01e0,
0x01e0,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x0060,
0x3060,
0x3060,
0x38e0,
0x1fc0,
0x0f80,
0x0000,

/* Character 107 (0x6b):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |  **          |
   |  **          |
   |  **          |
   |  **          |
   |  **          |
   |  **     ***  |
   |  **    ***   |
   |  **   ***    |
   |  **  ***     |
   |  ** ***      |
   |  *****       |
   |  ****        |
   |  *****       |
   |  ** ***      |
   |  **  ***     |
   |  **   ***    |
   |  **    ***   |
   |  **     ***  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x3000,
0x3000,
0x3000,
0x3000,
0x3000,
0x3070,
0x30e0,
0x31c0,
0x3380,
0x3700,
0x3e00,
0x3c00,
0x3e00,
0x3700,
0x3380,
0x31c0,
0x30e0,
0x3070,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 108 (0x6c):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |    ****      |
   |    ****      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |    ******    |
   |    ******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0f00,
0x0f00,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0fc0,
0x0fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 109 (0x6d):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | **********   |
   | ***********  |
   | **   **  *** |
   | **   **   ** |
   | **   **   ** |
   | **   **   ** |
   | **   **   ** |
   | **   **   ** |
   | **   **   ** |
   | **   **   ** |
   | **   **   ** |
   | **   **   ** |
   | **   **   ** |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7fe0,
0x7ff0,
0x6338,
0x6318,
0x6318,
0x6318,
0x6318,
0x6318,
0x6318,
0x6318,
0x6318,
0x6318,
0x6318,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 110 (0x6e):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | *********    |
   | **********   |
   | **      ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7fc0,
0x7fe0,
0x6070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 111 (0x6f):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 112 (0x70):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | *********    |
   | **********   |
   | **      ***  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **      ***  |
   | **********   |
   | *********    |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7fc0,
0x7fe0,
0x6070,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6070,
0x7fe0,
0x7fc0,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x0000,

/* Character 113 (0x71):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |   *********  |
   |  **********  |
   | ***      **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***      **  |
   |  **********  |
   |   *********  |
   |          **  |
   |          **  |
   |          **  |
   |          **  |
   |          **  |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1ff0,
0x3ff0,
0x7030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7030,
0x3ff0,
0x1ff0,
0x0030,
0x0030,
0x0030,
0x0030,
0x0030,
0x0000,

/* Character 114 (0x72):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | **  *******  |
   | ** ********  |
   | *****        |
   | ****         |
   | ***          |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   | **           |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x67f0,
0x6ff0,
0x7c00,
0x7800,
0x7000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x6000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 115 (0x73):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |   *******    |
   |  *********   |
   | ***     ***  |
   | **           |
   | ***          |
   |  ********    |
   |   ********   |
   |         ***  |
   |          **  |
   |          **  |
   | ***     ***  |
   |  *********   |
   |   *******    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x1fc0,
0x3fe0,
0x7070,
0x6000,
0x7000,
0x3fc0,
0x1fe0,
0x0070,
0x0030,
0x0030,
0x7070,
0x3fe0,
0x1fc0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 116 (0x74):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |  ********    |
   |  ********    |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     ******   |
   |      *****   |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x3fc0,
0x3fc0,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x07e0,
0x03e0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 117 (0x75):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***      **  |
   |  **********  |
   |   *********  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7030,
0x3ff0,
0x1ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 118 (0x76):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | **       **  |
   | **       **  |
   | **       **  |
   |  **     **   |
   |  **     **   |
   |  **     **   |
   |   **   **    |
   |   **   **    |
   |   **   **    |
   |    ** **     |
   |    ** **     |
   |     ***      |
   |     ***      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6030,
0x6030,
0x6030,
0x3060,
0x3060,
0x3060,
0x18c0,
0x18c0,
0x18c0,
0x0d80,
0x0d80,
0x0700,
0x0700,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 119 (0x77):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | **        ** |
   | **        ** |
   | **        ** |
   | **        ** |
   | **   **   ** |
   | **   **   ** |
   | **   **   ** |
   | **   **   ** |
   | **   **   ** |
   | **   **   ** |
   | ***  **  *** |
   |  **********  |
   |   ********   |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6018,
0x6018,
0x6018,
0x6018,
0x6318,
0x6318,
0x6318,
0x6318,
0x6318,
0x6318,
0x7338,
0x3ff0,
0x1fe0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 120 (0x78):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | **       **  |
   | **       **  |
   | ***     ***  |
   |  ***   ***   |
   |   *** ***    |
   |    *****     |
   |     ***      |
   |    *****     |
   |   *** ***    |
   |  ***   ***   |
   | ***     ***  |
   | **       **  |
   | **       **  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6030,
0x6030,
0x7070,
0x38e0,
0x1dc0,
0x0f80,
0x0700,
0x0f80,
0x1dc0,
0x38e0,
0x7070,
0x6030,
0x6030,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 121 (0x79):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | **       **  |
   | ***      **  |
   |  **********  |
   |   *********  |
   |          **  |
   |          **  |
   |         ***  |
   |  *********   |
   |  ********    |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x6030,
0x7030,
0x3ff0,
0x1ff0,
0x0030,
0x0030,
0x0070,
0x3fe0,
0x3fc0,
0x0000,

/* Character 122 (0x7a):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   | ***********  |
   | ***********  |
   |         ***  |
   |        ***   |
   |       ***    |
   |      ***     |
   |     ***      |
   |    ***       |
   |   ***        |
   |  ***         |
   | ***          |
   | ***********  |
   | ***********  |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x7ff0,
0x7ff0,
0x0070,
0x00e0,
0x01c0,
0x0380,
0x0700,
0x0e00,
0x1c00,
0x3800,
0x7000,
0x7ff0,
0x7ff0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 123 (0x7b):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |       ***    |
   |      ****    |
   |     ***      |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |   ***        |
   |   ***        |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     **       |
   |     ***      |
   |      ****    |
   |       ***    |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x01c0,
0x03c0,
0x0700,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x1c00,
0x1c00,
0x0600,
0x0600,
0x0600,
0x0600,
0x0600,
0x0700,
0x03c0,
0x01c0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 124 (0x7c):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 125 (0x7d):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |              |
   |              |
   |   ***        |
   |   ****       |
   |     ***      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |       ***    |
   |       ***    |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |      **      |
   |     ***      |
   |   ****       |
   |   ***        |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x0000,
0x0000,
0x1c00,
0x1e00,
0x0700,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x01c0,
0x01c0,
0x0300,
0x0300,
0x0300,
0x0300,
0x0300,
0x0700,
0x1e00,
0x1c00,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,

/* Character 126 (0x7e):
   width 14
   bbx ( 14, 28, 0, -6 )

   +--------------+
   |              |
   |              |
   |  ****    **  |
   | ******   **  |
   | **  ***  **  |
   | **   ******  |
   | **    ****   |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   |              |
   +--------------+
*/
0x0000,
0x0000,
0x3c30,
0x7e30,
0x6730,
0x63f0,
0x61e0,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
0x0000,
};

/* Exported structure definition. */
static const FontDesc stella14x28tDesc = {
  "ter-u28b",
  14,
  28,
  14, 28, 0, -6,
  22,
  28,
  99,
  stella14x28t_font_bits,
  nullptr,  /* no encode table*/
  nullptr,  /* fixed width*/
  nullptr,  /* fixed bbox*/
  32,
  sizeof(stella14x28t_font_bits)/sizeof(uInt16)
};

} // End of namespace GUI

#endif
