// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_ASSEMBLER_COND_RD_RN_RM_SHASX_A32_H_
#define VIXL_ASSEMBLER_COND_RD_RN_RM_SHASX_A32_H_

const byte kInstruction_shasx_hi_r1_r9_r5[] = {
  0x35, 0x1f, 0x39, 0x86 // shasx hi r1 r9 r5
};
const byte kInstruction_shasx_pl_r8_r6_r2[] = {
  0x32, 0x8f, 0x36, 0x56 // shasx pl r8 r6 r2
};
const byte kInstruction_shasx_hi_r5_r8_r2[] = {
  0x32, 0x5f, 0x38, 0x86 // shasx hi r5 r8 r2
};
const byte kInstruction_shasx_vc_r9_r2_r7[] = {
  0x37, 0x9f, 0x32, 0x76 // shasx vc r9 r2 r7
};
const byte kInstruction_shasx_lt_r4_r6_r3[] = {
  0x33, 0x4f, 0x36, 0xb6 // shasx lt r4 r6 r3
};
const byte kInstruction_shasx_le_r11_r6_r2[] = {
  0x32, 0xbf, 0x36, 0xd6 // shasx le r11 r6 r2
};
const byte kInstruction_shasx_cc_r8_r14_r4[] = {
  0x34, 0x8f, 0x3e, 0x36 // shasx cc r8 r14 r4
};
const byte kInstruction_shasx_le_r5_r14_r6[] = {
  0x36, 0x5f, 0x3e, 0xd6 // shasx le r5 r14 r6
};
const byte kInstruction_shasx_lt_r6_r1_r0[] = {
  0x30, 0x6f, 0x31, 0xb6 // shasx lt r6 r1 r0
};
const byte kInstruction_shasx_lt_r5_r0_r9[] = {
  0x39, 0x5f, 0x30, 0xb6 // shasx lt r5 r0 r9
};
const byte kInstruction_shasx_le_r8_r12_r7[] = {
  0x37, 0x8f, 0x3c, 0xd6 // shasx le r8 r12 r7
};
const byte kInstruction_shasx_eq_r7_r14_r6[] = {
  0x36, 0x7f, 0x3e, 0x06 // shasx eq r7 r14 r6
};
const byte kInstruction_shasx_cs_r7_r4_r6[] = {
  0x36, 0x7f, 0x34, 0x26 // shasx cs r7 r4 r6
};
const byte kInstruction_shasx_gt_r9_r6_r9[] = {
  0x39, 0x9f, 0x36, 0xc6 // shasx gt r9 r6 r9
};
const byte kInstruction_shasx_ne_r13_r9_r1[] = {
  0x31, 0xdf, 0x39, 0x16 // shasx ne r13 r9 r1
};
const byte kInstruction_shasx_ge_r13_r1_r13[] = {
  0x3d, 0xdf, 0x31, 0xa6 // shasx ge r13 r1 r13
};
const byte kInstruction_shasx_ls_r8_r10_r2[] = {
  0x32, 0x8f, 0x3a, 0x96 // shasx ls r8 r10 r2
};
const byte kInstruction_shasx_hi_r0_r13_r5[] = {
  0x35, 0x0f, 0x3d, 0x86 // shasx hi r0 r13 r5
};
const byte kInstruction_shasx_pl_r13_r7_r8[] = {
  0x38, 0xdf, 0x37, 0x56 // shasx pl r13 r7 r8
};
const byte kInstruction_shasx_ge_r4_r13_r11[] = {
  0x3b, 0x4f, 0x3d, 0xa6 // shasx ge r4 r13 r11
};
const byte kInstruction_shasx_cs_r5_r10_r5[] = {
  0x35, 0x5f, 0x3a, 0x26 // shasx cs r5 r10 r5
};
const byte kInstruction_shasx_cs_r5_r4_r3[] = {
  0x33, 0x5f, 0x34, 0x26 // shasx cs r5 r4 r3
};
const byte kInstruction_shasx_ls_r6_r14_r8[] = {
  0x38, 0x6f, 0x3e, 0x96 // shasx ls r6 r14 r8
};
const byte kInstruction_shasx_vs_r3_r8_r6[] = {
  0x36, 0x3f, 0x38, 0x66 // shasx vs r3 r8 r6
};
const byte kInstruction_shasx_vc_r7_r12_r3[] = {
  0x33, 0x7f, 0x3c, 0x76 // shasx vc r7 r12 r3
};
const byte kInstruction_shasx_ge_r1_r4_r1[] = {
  0x31, 0x1f, 0x34, 0xa6 // shasx ge r1 r4 r1
};
const byte kInstruction_shasx_cc_r4_r7_r10[] = {
  0x3a, 0x4f, 0x37, 0x36 // shasx cc r4 r7 r10
};
const byte kInstruction_shasx_cc_r2_r0_r13[] = {
  0x3d, 0x2f, 0x30, 0x36 // shasx cc r2 r0 r13
};
const byte kInstruction_shasx_vs_r9_r6_r8[] = {
  0x38, 0x9f, 0x36, 0x66 // shasx vs r9 r6 r8
};
const byte kInstruction_shasx_cs_r14_r11_r13[] = {
  0x3d, 0xef, 0x3b, 0x26 // shasx cs r14 r11 r13
};
const byte kInstruction_shasx_pl_r5_r8_r4[] = {
  0x34, 0x5f, 0x38, 0x56 // shasx pl r5 r8 r4
};
const byte kInstruction_shasx_pl_r2_r3_r7[] = {
  0x37, 0x2f, 0x33, 0x56 // shasx pl r2 r3 r7
};
const byte kInstruction_shasx_cs_r7_r12_r14[] = {
  0x3e, 0x7f, 0x3c, 0x26 // shasx cs r7 r12 r14
};
const byte kInstruction_shasx_hi_r6_r6_r1[] = {
  0x31, 0x6f, 0x36, 0x86 // shasx hi r6 r6 r1
};
const byte kInstruction_shasx_cc_r6_r9_r6[] = {
  0x36, 0x6f, 0x39, 0x36 // shasx cc r6 r9 r6
};
const byte kInstruction_shasx_ne_r12_r12_r0[] = {
  0x30, 0xcf, 0x3c, 0x16 // shasx ne r12 r12 r0
};
const byte kInstruction_shasx_cc_r9_r3_r8[] = {
  0x38, 0x9f, 0x33, 0x36 // shasx cc r9 r3 r8
};
const byte kInstruction_shasx_mi_r13_r6_r1[] = {
  0x31, 0xdf, 0x36, 0x46 // shasx mi r13 r6 r1
};
const byte kInstruction_shasx_lt_r4_r8_r6[] = {
  0x36, 0x4f, 0x38, 0xb6 // shasx lt r4 r8 r6
};
const byte kInstruction_shasx_hi_r11_r5_r9[] = {
  0x39, 0xbf, 0x35, 0x86 // shasx hi r11 r5 r9
};
const byte kInstruction_shasx_cc_r6_r10_r6[] = {
  0x36, 0x6f, 0x3a, 0x36 // shasx cc r6 r10 r6
};
const byte kInstruction_shasx_eq_r10_r10_r5[] = {
  0x35, 0xaf, 0x3a, 0x06 // shasx eq r10 r10 r5
};
const byte kInstruction_shasx_al_r5_r4_r11[] = {
  0x3b, 0x5f, 0x34, 0xe6 // shasx al r5 r4 r11
};
const byte kInstruction_shasx_pl_r11_r11_r2[] = {
  0x32, 0xbf, 0x3b, 0x56 // shasx pl r11 r11 r2
};
const byte kInstruction_shasx_ls_r6_r14_r12[] = {
  0x3c, 0x6f, 0x3e, 0x96 // shasx ls r6 r14 r12
};
const byte kInstruction_shasx_vc_r7_r7_r2[] = {
  0x32, 0x7f, 0x37, 0x76 // shasx vc r7 r7 r2
};
const byte kInstruction_shasx_eq_r10_r8_r4[] = {
  0x34, 0xaf, 0x38, 0x06 // shasx eq r10 r8 r4
};
const byte kInstruction_shasx_al_r14_r7_r2[] = {
  0x32, 0xef, 0x37, 0xe6 // shasx al r14 r7 r2
};
const byte kInstruction_shasx_cs_r3_r11_r10[] = {
  0x3a, 0x3f, 0x3b, 0x26 // shasx cs r3 r11 r10
};
const byte kInstruction_shasx_ls_r11_r4_r0[] = {
  0x30, 0xbf, 0x34, 0x96 // shasx ls r11 r4 r0
};
const byte kInstruction_shasx_hi_r11_r8_r9[] = {
  0x39, 0xbf, 0x38, 0x86 // shasx hi r11 r8 r9
};
const byte kInstruction_shasx_vs_r2_r14_r13[] = {
  0x3d, 0x2f, 0x3e, 0x66 // shasx vs r2 r14 r13
};
const byte kInstruction_shasx_al_r1_r13_r9[] = {
  0x39, 0x1f, 0x3d, 0xe6 // shasx al r1 r13 r9
};
const byte kInstruction_shasx_eq_r3_r9_r13[] = {
  0x3d, 0x3f, 0x39, 0x06 // shasx eq r3 r9 r13
};
const byte kInstruction_shasx_ge_r10_r3_r13[] = {
  0x3d, 0xaf, 0x33, 0xa6 // shasx ge r10 r3 r13
};
const byte kInstruction_shasx_pl_r8_r5_r10[] = {
  0x3a, 0x8f, 0x35, 0x56 // shasx pl r8 r5 r10
};
const byte kInstruction_shasx_vc_r8_r11_r6[] = {
  0x36, 0x8f, 0x3b, 0x76 // shasx vc r8 r11 r6
};
const byte kInstruction_shasx_eq_r0_r0_r5[] = {
  0x35, 0x0f, 0x30, 0x06 // shasx eq r0 r0 r5
};
const byte kInstruction_shasx_ne_r6_r5_r8[] = {
  0x38, 0x6f, 0x35, 0x16 // shasx ne r6 r5 r8
};
const byte kInstruction_shasx_hi_r5_r13_r3[] = {
  0x33, 0x5f, 0x3d, 0x86 // shasx hi r5 r13 r3
};
const byte kInstruction_shasx_ne_r11_r14_r14[] = {
  0x3e, 0xbf, 0x3e, 0x16 // shasx ne r11 r14 r14
};
const byte kInstruction_shasx_mi_r1_r0_r6[] = {
  0x36, 0x1f, 0x30, 0x46 // shasx mi r1 r0 r6
};
const byte kInstruction_shasx_le_r14_r8_r2[] = {
  0x32, 0xef, 0x38, 0xd6 // shasx le r14 r8 r2
};
const byte kInstruction_shasx_eq_r9_r6_r5[] = {
  0x35, 0x9f, 0x36, 0x06 // shasx eq r9 r6 r5
};
const byte kInstruction_shasx_eq_r11_r0_r13[] = {
  0x3d, 0xbf, 0x30, 0x06 // shasx eq r11 r0 r13
};
const byte kInstruction_shasx_pl_r4_r5_r14[] = {
  0x3e, 0x4f, 0x35, 0x56 // shasx pl r4 r5 r14
};
const byte kInstruction_shasx_cs_r13_r5_r13[] = {
  0x3d, 0xdf, 0x35, 0x26 // shasx cs r13 r5 r13
};
const byte kInstruction_shasx_mi_r0_r13_r8[] = {
  0x38, 0x0f, 0x3d, 0x46 // shasx mi r0 r13 r8
};
const byte kInstruction_shasx_lt_r2_r13_r3[] = {
  0x33, 0x2f, 0x3d, 0xb6 // shasx lt r2 r13 r3
};
const byte kInstruction_shasx_ls_r8_r1_r11[] = {
  0x3b, 0x8f, 0x31, 0x96 // shasx ls r8 r1 r11
};
const byte kInstruction_shasx_vc_r14_r11_r8[] = {
  0x38, 0xef, 0x3b, 0x76 // shasx vc r14 r11 r8
};
const byte kInstruction_shasx_lt_r4_r13_r12[] = {
  0x3c, 0x4f, 0x3d, 0xb6 // shasx lt r4 r13 r12
};
const byte kInstruction_shasx_eq_r2_r1_r14[] = {
  0x3e, 0x2f, 0x31, 0x06 // shasx eq r2 r1 r14
};
const byte kInstruction_shasx_eq_r9_r4_r14[] = {
  0x3e, 0x9f, 0x34, 0x06 // shasx eq r9 r4 r14
};
const byte kInstruction_shasx_hi_r10_r6_r13[] = {
  0x3d, 0xaf, 0x36, 0x86 // shasx hi r10 r6 r13
};
const byte kInstruction_shasx_ge_r12_r9_r4[] = {
  0x34, 0xcf, 0x39, 0xa6 // shasx ge r12 r9 r4
};
const byte kInstruction_shasx_le_r9_r11_r14[] = {
  0x3e, 0x9f, 0x3b, 0xd6 // shasx le r9 r11 r14
};
const byte kInstruction_shasx_ls_r0_r9_r5[] = {
  0x35, 0x0f, 0x39, 0x96 // shasx ls r0 r9 r5
};
const byte kInstruction_shasx_mi_r2_r3_r8[] = {
  0x38, 0x2f, 0x33, 0x46 // shasx mi r2 r3 r8
};
const byte kInstruction_shasx_ne_r14_r10_r14[] = {
  0x3e, 0xef, 0x3a, 0x16 // shasx ne r14 r10 r14
};
const byte kInstruction_shasx_eq_r6_r2_r10[] = {
  0x3a, 0x6f, 0x32, 0x06 // shasx eq r6 r2 r10
};
const byte kInstruction_shasx_lt_r11_r0_r12[] = {
  0x3c, 0xbf, 0x30, 0xb6 // shasx lt r11 r0 r12
};
const byte kInstruction_shasx_ne_r1_r12_r10[] = {
  0x3a, 0x1f, 0x3c, 0x16 // shasx ne r1 r12 r10
};
const byte kInstruction_shasx_cc_r1_r0_r2[] = {
  0x32, 0x1f, 0x30, 0x36 // shasx cc r1 r0 r2
};
const byte kInstruction_shasx_al_r5_r5_r7[] = {
  0x37, 0x5f, 0x35, 0xe6 // shasx al r5 r5 r7
};
const byte kInstruction_shasx_hi_r7_r13_r1[] = {
  0x31, 0x7f, 0x3d, 0x86 // shasx hi r7 r13 r1
};
const byte kInstruction_shasx_cs_r4_r4_r9[] = {
  0x39, 0x4f, 0x34, 0x26 // shasx cs r4 r4 r9
};
const byte kInstruction_shasx_eq_r14_r4_r14[] = {
  0x3e, 0xef, 0x34, 0x06 // shasx eq r14 r4 r14
};
const byte kInstruction_shasx_vs_r10_r5_r14[] = {
  0x3e, 0xaf, 0x35, 0x66 // shasx vs r10 r5 r14
};
const byte kInstruction_shasx_gt_r4_r3_r11[] = {
  0x3b, 0x4f, 0x33, 0xc6 // shasx gt r4 r3 r11
};
const byte kInstruction_shasx_ne_r14_r10_r12[] = {
  0x3c, 0xef, 0x3a, 0x16 // shasx ne r14 r10 r12
};
const byte kInstruction_shasx_vs_r2_r11_r0[] = {
  0x30, 0x2f, 0x3b, 0x66 // shasx vs r2 r11 r0
};
const byte kInstruction_shasx_ge_r5_r12_r7[] = {
  0x37, 0x5f, 0x3c, 0xa6 // shasx ge r5 r12 r7
};
const byte kInstruction_shasx_mi_r7_r14_r6[] = {
  0x36, 0x7f, 0x3e, 0x46 // shasx mi r7 r14 r6
};
const byte kInstruction_shasx_gt_r8_r3_r8[] = {
  0x38, 0x8f, 0x33, 0xc6 // shasx gt r8 r3 r8
};
const byte kInstruction_shasx_hi_r9_r14_r3[] = {
  0x33, 0x9f, 0x3e, 0x86 // shasx hi r9 r14 r3
};
const byte kInstruction_shasx_vc_r2_r11_r2[] = {
  0x32, 0x2f, 0x3b, 0x76 // shasx vc r2 r11 r2
};
const byte kInstruction_shasx_hi_r11_r7_r12[] = {
  0x3c, 0xbf, 0x37, 0x86 // shasx hi r11 r7 r12
};
const byte kInstruction_shasx_cs_r6_r4_r11[] = {
  0x3b, 0x6f, 0x34, 0x26 // shasx cs r6 r4 r11
};
const byte kInstruction_shasx_cs_r12_r5_r9[] = {
  0x39, 0xcf, 0x35, 0x26 // shasx cs r12 r5 r9
};
const byte kInstruction_shasx_ls_r5_r10_r5[] = {
  0x35, 0x5f, 0x3a, 0x96 // shasx ls r5 r10 r5
};
const byte kInstruction_shasx_ls_r0_r9_r13[] = {
  0x3d, 0x0f, 0x39, 0x96 // shasx ls r0 r9 r13
};
const byte kInstruction_shasx_lt_r3_r3_r5[] = {
  0x35, 0x3f, 0x33, 0xb6 // shasx lt r3 r3 r5
};
const byte kInstruction_shasx_mi_r0_r12_r8[] = {
  0x38, 0x0f, 0x3c, 0x46 // shasx mi r0 r12 r8
};
const byte kInstruction_shasx_pl_r3_r12_r12[] = {
  0x3c, 0x3f, 0x3c, 0x56 // shasx pl r3 r12 r12
};
const byte kInstruction_shasx_eq_r8_r12_r5[] = {
  0x35, 0x8f, 0x3c, 0x06 // shasx eq r8 r12 r5
};
const byte kInstruction_shasx_cc_r7_r8_r1[] = {
  0x31, 0x7f, 0x38, 0x36 // shasx cc r7 r8 r1
};
const byte kInstruction_shasx_hi_r2_r13_r10[] = {
  0x3a, 0x2f, 0x3d, 0x86 // shasx hi r2 r13 r10
};
const byte kInstruction_shasx_al_r7_r10_r10[] = {
  0x3a, 0x7f, 0x3a, 0xe6 // shasx al r7 r10 r10
};
const byte kInstruction_shasx_vc_r1_r12_r2[] = {
  0x32, 0x1f, 0x3c, 0x76 // shasx vc r1 r12 r2
};
const byte kInstruction_shasx_cc_r8_r5_r8[] = {
  0x38, 0x8f, 0x35, 0x36 // shasx cc r8 r5 r8
};
const byte kInstruction_shasx_ls_r3_r7_r9[] = {
  0x39, 0x3f, 0x37, 0x96 // shasx ls r3 r7 r9
};
const byte kInstruction_shasx_al_r8_r10_r8[] = {
  0x38, 0x8f, 0x3a, 0xe6 // shasx al r8 r10 r8
};
const byte kInstruction_shasx_lt_r4_r12_r10[] = {
  0x3a, 0x4f, 0x3c, 0xb6 // shasx lt r4 r12 r10
};
const byte kInstruction_shasx_ge_r10_r5_r11[] = {
  0x3b, 0xaf, 0x35, 0xa6 // shasx ge r10 r5 r11
};
const byte kInstruction_shasx_ls_r3_r14_r4[] = {
  0x34, 0x3f, 0x3e, 0x96 // shasx ls r3 r14 r4
};
const byte kInstruction_shasx_hi_r3_r6_r12[] = {
  0x3c, 0x3f, 0x36, 0x86 // shasx hi r3 r6 r12
};
const byte kInstruction_shasx_hi_r6_r0_r4[] = {
  0x34, 0x6f, 0x30, 0x86 // shasx hi r6 r0 r4
};
const byte kInstruction_shasx_al_r11_r6_r0[] = {
  0x30, 0xbf, 0x36, 0xe6 // shasx al r11 r6 r0
};
const byte kInstruction_shasx_mi_r3_r1_r9[] = {
  0x39, 0x3f, 0x31, 0x46 // shasx mi r3 r1 r9
};
const byte kInstruction_shasx_mi_r12_r13_r0[] = {
  0x30, 0xcf, 0x3d, 0x46 // shasx mi r12 r13 r0
};
const byte kInstruction_shasx_le_r1_r2_r5[] = {
  0x35, 0x1f, 0x32, 0xd6 // shasx le r1 r2 r5
};
const byte kInstruction_shasx_hi_r4_r3_r14[] = {
  0x3e, 0x4f, 0x33, 0x86 // shasx hi r4 r3 r14
};
const byte kInstruction_shasx_eq_r6_r11_r11[] = {
  0x3b, 0x6f, 0x3b, 0x06 // shasx eq r6 r11 r11
};
const byte kInstruction_shasx_cc_r14_r11_r14[] = {
  0x3e, 0xef, 0x3b, 0x36 // shasx cc r14 r11 r14
};
const byte kInstruction_shasx_hi_r4_r10_r0[] = {
  0x30, 0x4f, 0x3a, 0x86 // shasx hi r4 r10 r0
};
const byte kInstruction_shasx_cc_r7_r11_r1[] = {
  0x31, 0x7f, 0x3b, 0x36 // shasx cc r7 r11 r1
};
const byte kInstruction_shasx_mi_r14_r6_r10[] = {
  0x3a, 0xef, 0x36, 0x46 // shasx mi r14 r6 r10
};
const byte kInstruction_shasx_eq_r2_r0_r11[] = {
  0x3b, 0x2f, 0x30, 0x06 // shasx eq r2 r0 r11
};
const byte kInstruction_shasx_mi_r13_r5_r12[] = {
  0x3c, 0xdf, 0x35, 0x46 // shasx mi r13 r5 r12
};
const byte kInstruction_shasx_eq_r2_r12_r5[] = {
  0x35, 0x2f, 0x3c, 0x06 // shasx eq r2 r12 r5
};
const byte kInstruction_shasx_le_r12_r0_r2[] = {
  0x32, 0xcf, 0x30, 0xd6 // shasx le r12 r0 r2
};
const byte kInstruction_shasx_vc_r10_r10_r9[] = {
  0x39, 0xaf, 0x3a, 0x76 // shasx vc r10 r10 r9
};
const byte kInstruction_shasx_ls_r11_r11_r8[] = {
  0x38, 0xbf, 0x3b, 0x96 // shasx ls r11 r11 r8
};
const byte kInstruction_shasx_hi_r10_r11_r9[] = {
  0x39, 0xaf, 0x3b, 0x86 // shasx hi r10 r11 r9
};
const byte kInstruction_shasx_vs_r7_r12_r14[] = {
  0x3e, 0x7f, 0x3c, 0x66 // shasx vs r7 r12 r14
};
const byte kInstruction_shasx_gt_r11_r14_r12[] = {
  0x3c, 0xbf, 0x3e, 0xc6 // shasx gt r11 r14 r12
};
const byte kInstruction_shasx_vs_r0_r12_r8[] = {
  0x38, 0x0f, 0x3c, 0x66 // shasx vs r0 r12 r8
};
const byte kInstruction_shasx_al_r0_r5_r7[] = {
  0x37, 0x0f, 0x35, 0xe6 // shasx al r0 r5 r7
};
const byte kInstruction_shasx_hi_r5_r13_r8[] = {
  0x38, 0x5f, 0x3d, 0x86 // shasx hi r5 r13 r8
};
const byte kInstruction_shasx_le_r9_r9_r7[] = {
  0x37, 0x9f, 0x39, 0xd6 // shasx le r9 r9 r7
};
const byte kInstruction_shasx_cc_r4_r9_r5[] = {
  0x35, 0x4f, 0x39, 0x36 // shasx cc r4 r9 r5
};
const byte kInstruction_shasx_vs_r8_r1_r3[] = {
  0x33, 0x8f, 0x31, 0x66 // shasx vs r8 r1 r3
};
const byte kInstruction_shasx_cc_r0_r10_r12[] = {
  0x3c, 0x0f, 0x3a, 0x36 // shasx cc r0 r10 r12
};
const byte kInstruction_shasx_eq_r7_r14_r0[] = {
  0x30, 0x7f, 0x3e, 0x06 // shasx eq r7 r14 r0
};
const byte kInstruction_shasx_vs_r12_r9_r11[] = {
  0x3b, 0xcf, 0x39, 0x66 // shasx vs r12 r9 r11
};
const byte kInstruction_shasx_gt_r5_r9_r11[] = {
  0x3b, 0x5f, 0x39, 0xc6 // shasx gt r5 r9 r11
};
const byte kInstruction_shasx_cs_r14_r13_r7[] = {
  0x37, 0xef, 0x3d, 0x26 // shasx cs r14 r13 r7
};
const byte kInstruction_shasx_mi_r11_r3_r10[] = {
  0x3a, 0xbf, 0x33, 0x46 // shasx mi r11 r3 r10
};
const byte kInstruction_shasx_hi_r11_r8_r12[] = {
  0x3c, 0xbf, 0x38, 0x86 // shasx hi r11 r8 r12
};
const byte kInstruction_shasx_cs_r3_r8_r13[] = {
  0x3d, 0x3f, 0x38, 0x26 // shasx cs r3 r8 r13
};
const byte kInstruction_shasx_pl_r10_r12_r6[] = {
  0x36, 0xaf, 0x3c, 0x56 // shasx pl r10 r12 r6
};
const byte kInstruction_shasx_vc_r7_r3_r2[] = {
  0x32, 0x7f, 0x33, 0x76 // shasx vc r7 r3 r2
};
const byte kInstruction_shasx_mi_r9_r0_r8[] = {
  0x38, 0x9f, 0x30, 0x46 // shasx mi r9 r0 r8
};
const byte kInstruction_shasx_eq_r2_r13_r7[] = {
  0x37, 0x2f, 0x3d, 0x06 // shasx eq r2 r13 r7
};
const byte kInstruction_shasx_ne_r2_r14_r0[] = {
  0x30, 0x2f, 0x3e, 0x16 // shasx ne r2 r14 r0
};
const byte kInstruction_shasx_vs_r4_r10_r0[] = {
  0x30, 0x4f, 0x3a, 0x66 // shasx vs r4 r10 r0
};
const byte kInstruction_shasx_ls_r0_r2_r2[] = {
  0x32, 0x0f, 0x32, 0x96 // shasx ls r0 r2 r2
};
const byte kInstruction_shasx_cc_r1_r6_r0[] = {
  0x30, 0x1f, 0x36, 0x36 // shasx cc r1 r6 r0
};
const byte kInstruction_shasx_lt_r12_r0_r8[] = {
  0x38, 0xcf, 0x30, 0xb6 // shasx lt r12 r0 r8
};
const byte kInstruction_shasx_cc_r9_r3_r14[] = {
  0x3e, 0x9f, 0x33, 0x36 // shasx cc r9 r3 r14
};
const byte kInstruction_shasx_vs_r7_r9_r1[] = {
  0x31, 0x7f, 0x39, 0x66 // shasx vs r7 r9 r1
};
const byte kInstruction_shasx_eq_r11_r9_r14[] = {
  0x3e, 0xbf, 0x39, 0x06 // shasx eq r11 r9 r14
};
const byte kInstruction_shasx_pl_r6_r10_r4[] = {
  0x34, 0x6f, 0x3a, 0x56 // shasx pl r6 r10 r4
};
const byte kInstruction_shasx_ne_r8_r5_r6[] = {
  0x36, 0x8f, 0x35, 0x16 // shasx ne r8 r5 r6
};
const byte kInstruction_shasx_cs_r0_r6_r2[] = {
  0x32, 0x0f, 0x36, 0x26 // shasx cs r0 r6 r2
};
const byte kInstruction_shasx_eq_r11_r12_r4[] = {
  0x34, 0xbf, 0x3c, 0x06 // shasx eq r11 r12 r4
};
const byte kInstruction_shasx_lt_r14_r3_r14[] = {
  0x3e, 0xef, 0x33, 0xb6 // shasx lt r14 r3 r14
};
const byte kInstruction_shasx_le_r7_r12_r14[] = {
  0x3e, 0x7f, 0x3c, 0xd6 // shasx le r7 r12 r14
};
const byte kInstruction_shasx_hi_r2_r9_r9[] = {
  0x39, 0x2f, 0x39, 0x86 // shasx hi r2 r9 r9
};
const byte kInstruction_shasx_ne_r8_r1_r0[] = {
  0x30, 0x8f, 0x31, 0x16 // shasx ne r8 r1 r0
};
const byte kInstruction_shasx_cc_r5_r11_r2[] = {
  0x32, 0x5f, 0x3b, 0x36 // shasx cc r5 r11 r2
};
const byte kInstruction_shasx_hi_r0_r1_r2[] = {
  0x32, 0x0f, 0x31, 0x86 // shasx hi r0 r1 r2
};
const byte kInstruction_shasx_al_r4_r9_r4[] = {
  0x34, 0x4f, 0x39, 0xe6 // shasx al r4 r9 r4
};
const byte kInstruction_shasx_cs_r12_r7_r14[] = {
  0x3e, 0xcf, 0x37, 0x26 // shasx cs r12 r7 r14
};
const byte kInstruction_shasx_cc_r4_r12_r10[] = {
  0x3a, 0x4f, 0x3c, 0x36 // shasx cc r4 r12 r10
};
const byte kInstruction_shasx_al_r3_r5_r10[] = {
  0x3a, 0x3f, 0x35, 0xe6 // shasx al r3 r5 r10
};
const byte kInstruction_shasx_mi_r5_r3_r7[] = {
  0x37, 0x5f, 0x33, 0x46 // shasx mi r5 r3 r7
};
const byte kInstruction_shasx_ls_r10_r6_r2[] = {
  0x32, 0xaf, 0x36, 0x96 // shasx ls r10 r6 r2
};
const byte kInstruction_shasx_mi_r0_r12_r11[] = {
  0x3b, 0x0f, 0x3c, 0x46 // shasx mi r0 r12 r11
};
const byte kInstruction_shasx_vc_r12_r5_r6[] = {
  0x36, 0xcf, 0x35, 0x76 // shasx vc r12 r5 r6
};
const byte kInstruction_shasx_cs_r3_r9_r4[] = {
  0x34, 0x3f, 0x39, 0x26 // shasx cs r3 r9 r4
};
const byte kInstruction_shasx_ls_r4_r9_r11[] = {
  0x3b, 0x4f, 0x39, 0x96 // shasx ls r4 r9 r11
};
const byte kInstruction_shasx_le_r14_r8_r13[] = {
  0x3d, 0xef, 0x38, 0xd6 // shasx le r14 r8 r13
};
const byte kInstruction_shasx_gt_r4_r10_r8[] = {
  0x38, 0x4f, 0x3a, 0xc6 // shasx gt r4 r10 r8
};
const byte kInstruction_shasx_al_r6_r9_r9[] = {
  0x39, 0x6f, 0x39, 0xe6 // shasx al r6 r9 r9
};
const byte kInstruction_shasx_ne_r8_r5_r12[] = {
  0x3c, 0x8f, 0x35, 0x16 // shasx ne r8 r5 r12
};
const byte kInstruction_shasx_ne_r0_r4_r8[] = {
  0x38, 0x0f, 0x34, 0x16 // shasx ne r0 r4 r8
};
const byte kInstruction_shasx_mi_r7_r13_r3[] = {
  0x33, 0x7f, 0x3d, 0x46 // shasx mi r7 r13 r3
};
const byte kInstruction_shasx_cc_r11_r7_r0[] = {
  0x30, 0xbf, 0x37, 0x36 // shasx cc r11 r7 r0
};
const byte kInstruction_shasx_hi_r1_r0_r12[] = {
  0x3c, 0x1f, 0x30, 0x86 // shasx hi r1 r0 r12
};
const byte kInstruction_shasx_lt_r8_r9_r3[] = {
  0x33, 0x8f, 0x39, 0xb6 // shasx lt r8 r9 r3
};
const byte kInstruction_shasx_al_r0_r2_r1[] = {
  0x31, 0x0f, 0x32, 0xe6 // shasx al r0 r2 r1
};
const byte kInstruction_shasx_vs_r4_r3_r14[] = {
  0x3e, 0x4f, 0x33, 0x66 // shasx vs r4 r3 r14
};
const byte kInstruction_shasx_ge_r2_r11_r1[] = {
  0x31, 0x2f, 0x3b, 0xa6 // shasx ge r2 r11 r1
};
const byte kInstruction_shasx_lt_r12_r9_r6[] = {
  0x36, 0xcf, 0x39, 0xb6 // shasx lt r12 r9 r6
};
const byte kInstruction_shasx_ls_r8_r2_r7[] = {
  0x37, 0x8f, 0x32, 0x96 // shasx ls r8 r2 r7
};
const byte kInstruction_shasx_le_r8_r13_r3[] = {
  0x33, 0x8f, 0x3d, 0xd6 // shasx le r8 r13 r3
};
const byte kInstruction_shasx_eq_r11_r13_r14[] = {
  0x3e, 0xbf, 0x3d, 0x06 // shasx eq r11 r13 r14
};
const byte kInstruction_shasx_lt_r1_r6_r13[] = {
  0x3d, 0x1f, 0x36, 0xb6 // shasx lt r1 r6 r13
};
const byte kInstruction_shasx_cs_r3_r8_r11[] = {
  0x3b, 0x3f, 0x38, 0x26 // shasx cs r3 r8 r11
};
const byte kInstruction_shasx_pl_r12_r5_r4[] = {
  0x34, 0xcf, 0x35, 0x56 // shasx pl r12 r5 r4
};
const byte kInstruction_shasx_eq_r8_r7_r2[] = {
  0x32, 0x8f, 0x37, 0x06 // shasx eq r8 r7 r2
};
const byte kInstruction_shasx_ls_r2_r12_r2[] = {
  0x32, 0x2f, 0x3c, 0x96 // shasx ls r2 r12 r2
};
const byte kInstruction_shasx_le_r14_r2_r3[] = {
  0x33, 0xef, 0x32, 0xd6 // shasx le r14 r2 r3
};
const byte kInstruction_shasx_ge_r10_r11_r6[] = {
  0x36, 0xaf, 0x3b, 0xa6 // shasx ge r10 r11 r6
};
const byte kInstruction_shasx_hi_r0_r2_r2[] = {
  0x32, 0x0f, 0x32, 0x86 // shasx hi r0 r2 r2
};
const byte kInstruction_shasx_ge_r2_r0_r2[] = {
  0x32, 0x2f, 0x30, 0xa6 // shasx ge r2 r0 r2
};
const byte kInstruction_shasx_vs_r11_r14_r0[] = {
  0x30, 0xbf, 0x3e, 0x66 // shasx vs r11 r14 r0
};
const byte kInstruction_shasx_lt_r2_r0_r1[] = {
  0x31, 0x2f, 0x30, 0xb6 // shasx lt r2 r0 r1
};
const byte kInstruction_shasx_cs_r2_r5_r11[] = {
  0x3b, 0x2f, 0x35, 0x26 // shasx cs r2 r5 r11
};
const byte kInstruction_shasx_ls_r7_r14_r5[] = {
  0x35, 0x7f, 0x3e, 0x96 // shasx ls r7 r14 r5
};
const byte kInstruction_shasx_pl_r0_r0_r3[] = {
  0x33, 0x0f, 0x30, 0x56 // shasx pl r0 r0 r3
};
const byte kInstruction_shasx_ge_r6_r8_r8[] = {
  0x38, 0x6f, 0x38, 0xa6 // shasx ge r6 r8 r8
};
const byte kInstruction_shasx_le_r11_r1_r10[] = {
  0x3a, 0xbf, 0x31, 0xd6 // shasx le r11 r1 r10
};
const byte kInstruction_shasx_vs_r5_r2_r7[] = {
  0x37, 0x5f, 0x32, 0x66 // shasx vs r5 r2 r7
};
const byte kInstruction_shasx_ne_r4_r4_r8[] = {
  0x38, 0x4f, 0x34, 0x16 // shasx ne r4 r4 r8
};
const byte kInstruction_shasx_cc_r9_r14_r13[] = {
  0x3d, 0x9f, 0x3e, 0x36 // shasx cc r9 r14 r13
};
const byte kInstruction_shasx_hi_r14_r6_r3[] = {
  0x33, 0xef, 0x36, 0x86 // shasx hi r14 r6 r3
};
const byte kInstruction_shasx_al_r0_r8_r0[] = {
  0x30, 0x0f, 0x38, 0xe6 // shasx al r0 r8 r0
};
const byte kInstruction_shasx_lt_r6_r11_r1[] = {
  0x31, 0x6f, 0x3b, 0xb6 // shasx lt r6 r11 r1
};
const byte kInstruction_shasx_ge_r7_r6_r12[] = {
  0x3c, 0x7f, 0x36, 0xa6 // shasx ge r7 r6 r12
};
const byte kInstruction_shasx_cs_r4_r6_r14[] = {
  0x3e, 0x4f, 0x36, 0x26 // shasx cs r4 r6 r14
};
const byte kInstruction_shasx_cs_r7_r6_r7[] = {
  0x37, 0x7f, 0x36, 0x26 // shasx cs r7 r6 r7
};
const byte kInstruction_shasx_cs_r3_r7_r10[] = {
  0x3a, 0x3f, 0x37, 0x26 // shasx cs r3 r7 r10
};
const byte kInstruction_shasx_ne_r0_r2_r1[] = {
  0x31, 0x0f, 0x32, 0x16 // shasx ne r0 r2 r1
};
const byte kInstruction_shasx_vs_r9_r10_r13[] = {
  0x3d, 0x9f, 0x3a, 0x66 // shasx vs r9 r10 r13
};
const byte kInstruction_shasx_vc_r11_r14_r12[] = {
  0x3c, 0xbf, 0x3e, 0x76 // shasx vc r11 r14 r12
};
const byte kInstruction_shasx_ge_r14_r8_r7[] = {
  0x37, 0xef, 0x38, 0xa6 // shasx ge r14 r8 r7
};
const byte kInstruction_shasx_lt_r13_r0_r11[] = {
  0x3b, 0xdf, 0x30, 0xb6 // shasx lt r13 r0 r11
};
const byte kInstruction_shasx_lt_r14_r13_r4[] = {
  0x34, 0xef, 0x3d, 0xb6 // shasx lt r14 r13 r4
};
const byte kInstruction_shasx_al_r1_r10_r9[] = {
  0x39, 0x1f, 0x3a, 0xe6 // shasx al r1 r10 r9
};
const byte kInstruction_shasx_ge_r11_r14_r11[] = {
  0x3b, 0xbf, 0x3e, 0xa6 // shasx ge r11 r14 r11
};
const byte kInstruction_shasx_cs_r11_r4_r11[] = {
  0x3b, 0xbf, 0x34, 0x26 // shasx cs r11 r4 r11
};
const byte kInstruction_shasx_ge_r0_r14_r7[] = {
  0x37, 0x0f, 0x3e, 0xa6 // shasx ge r0 r14 r7
};
const byte kInstruction_shasx_mi_r1_r2_r9[] = {
  0x39, 0x1f, 0x32, 0x46 // shasx mi r1 r2 r9
};
const byte kInstruction_shasx_eq_r5_r12_r3[] = {
  0x33, 0x5f, 0x3c, 0x06 // shasx eq r5 r12 r3
};
const byte kInstruction_shasx_ge_r1_r5_r12[] = {
  0x3c, 0x1f, 0x35, 0xa6 // shasx ge r1 r5 r12
};
const byte kInstruction_shasx_lt_r10_r11_r4[] = {
  0x34, 0xaf, 0x3b, 0xb6 // shasx lt r10 r11 r4
};
const byte kInstruction_shasx_le_r1_r1_r5[] = {
  0x35, 0x1f, 0x31, 0xd6 // shasx le r1 r1 r5
};
const byte kInstruction_shasx_al_r9_r1_r8[] = {
  0x38, 0x9f, 0x31, 0xe6 // shasx al r9 r1 r8
};
const byte kInstruction_shasx_ne_r6_r8_r4[] = {
  0x34, 0x6f, 0x38, 0x16 // shasx ne r6 r8 r4
};
const byte kInstruction_shasx_ge_r12_r2_r9[] = {
  0x39, 0xcf, 0x32, 0xa6 // shasx ge r12 r2 r9
};
const byte kInstruction_shasx_pl_r4_r3_r10[] = {
  0x3a, 0x4f, 0x33, 0x56 // shasx pl r4 r3 r10
};
const byte kInstruction_shasx_eq_r14_r4_r11[] = {
  0x3b, 0xef, 0x34, 0x06 // shasx eq r14 r4 r11
};
const byte kInstruction_shasx_cc_r9_r7_r6[] = {
  0x36, 0x9f, 0x37, 0x36 // shasx cc r9 r7 r6
};
const byte kInstruction_shasx_ge_r12_r4_r5[] = {
  0x35, 0xcf, 0x34, 0xa6 // shasx ge r12 r4 r5
};
const byte kInstruction_shasx_hi_r2_r3_r4[] = {
  0x34, 0x2f, 0x33, 0x86 // shasx hi r2 r3 r4
};
const byte kInstruction_shasx_cs_r0_r3_r1[] = {
  0x31, 0x0f, 0x33, 0x26 // shasx cs r0 r3 r1
};
const byte kInstruction_shasx_hi_r6_r2_r8[] = {
  0x38, 0x6f, 0x32, 0x86 // shasx hi r6 r2 r8
};
const byte kInstruction_shasx_cc_r3_r14_r13[] = {
  0x3d, 0x3f, 0x3e, 0x36 // shasx cc r3 r14 r13
};
const byte kInstruction_shasx_gt_r11_r4_r7[] = {
  0x37, 0xbf, 0x34, 0xc6 // shasx gt r11 r4 r7
};
const byte kInstruction_shasx_hi_r5_r0_r12[] = {
  0x3c, 0x5f, 0x30, 0x86 // shasx hi r5 r0 r12
};
const byte kInstruction_shasx_gt_r0_r14_r14[] = {
  0x3e, 0x0f, 0x3e, 0xc6 // shasx gt r0 r14 r14
};
const byte kInstruction_shasx_hi_r9_r0_r10[] = {
  0x3a, 0x9f, 0x30, 0x86 // shasx hi r9 r0 r10
};
const byte kInstruction_shasx_vc_r7_r11_r8[] = {
  0x38, 0x7f, 0x3b, 0x76 // shasx vc r7 r11 r8
};
const byte kInstruction_shasx_pl_r11_r9_r6[] = {
  0x36, 0xbf, 0x39, 0x56 // shasx pl r11 r9 r6
};
const byte kInstruction_shasx_al_r3_r3_r7[] = {
  0x37, 0x3f, 0x33, 0xe6 // shasx al r3 r3 r7
};
const byte kInstruction_shasx_mi_r5_r7_r9[] = {
  0x39, 0x5f, 0x37, 0x46 // shasx mi r5 r7 r9
};
const byte kInstruction_shasx_cc_r11_r2_r4[] = {
  0x34, 0xbf, 0x32, 0x36 // shasx cc r11 r2 r4
};
const byte kInstruction_shasx_cc_r9_r13_r10[] = {
  0x3a, 0x9f, 0x3d, 0x36 // shasx cc r9 r13 r10
};
const byte kInstruction_shasx_al_r5_r2_r6[] = {
  0x36, 0x5f, 0x32, 0xe6 // shasx al r5 r2 r6
};
const byte kInstruction_shasx_ge_r9_r4_r6[] = {
  0x36, 0x9f, 0x34, 0xa6 // shasx ge r9 r4 r6
};
const byte kInstruction_shasx_ls_r3_r3_r4[] = {
  0x34, 0x3f, 0x33, 0x96 // shasx ls r3 r3 r4
};
const byte kInstruction_shasx_ge_r14_r1_r8[] = {
  0x38, 0xef, 0x31, 0xa6 // shasx ge r14 r1 r8
};
const byte kInstruction_shasx_ls_r7_r12_r7[] = {
  0x37, 0x7f, 0x3c, 0x96 // shasx ls r7 r12 r7
};
const byte kInstruction_shasx_al_r11_r10_r5[] = {
  0x35, 0xbf, 0x3a, 0xe6 // shasx al r11 r10 r5
};
const byte kInstruction_shasx_al_r7_r4_r6[] = {
  0x36, 0x7f, 0x34, 0xe6 // shasx al r7 r4 r6
};
const byte kInstruction_shasx_vs_r12_r4_r10[] = {
  0x3a, 0xcf, 0x34, 0x66 // shasx vs r12 r4 r10
};
const byte kInstruction_shasx_eq_r4_r4_r4[] = {
  0x34, 0x4f, 0x34, 0x06 // shasx eq r4 r4 r4
};
const byte kInstruction_shasx_vs_r6_r6_r12[] = {
  0x3c, 0x6f, 0x36, 0x66 // shasx vs r6 r6 r12
};
const byte kInstruction_shasx_pl_r9_r3_r5[] = {
  0x35, 0x9f, 0x33, 0x56 // shasx pl r9 r3 r5
};
const byte kInstruction_shasx_eq_r6_r5_r13[] = {
  0x3d, 0x6f, 0x35, 0x06 // shasx eq r6 r5 r13
};
const byte kInstruction_shasx_cc_r8_r2_r12[] = {
  0x3c, 0x8f, 0x32, 0x36 // shasx cc r8 r2 r12
};
const byte kInstruction_shasx_le_r4_r2_r0[] = {
  0x30, 0x4f, 0x32, 0xd6 // shasx le r4 r2 r0
};
const byte kInstruction_shasx_lt_r7_r9_r8[] = {
  0x38, 0x7f, 0x39, 0xb6 // shasx lt r7 r9 r8
};
const byte kInstruction_shasx_le_r4_r7_r11[] = {
  0x3b, 0x4f, 0x37, 0xd6 // shasx le r4 r7 r11
};
const byte kInstruction_shasx_eq_r5_r7_r5[] = {
  0x35, 0x5f, 0x37, 0x06 // shasx eq r5 r7 r5
};
const byte kInstruction_shasx_vc_r10_r7_r12[] = {
  0x3c, 0xaf, 0x37, 0x76 // shasx vc r10 r7 r12
};
const byte kInstruction_shasx_eq_r7_r10_r6[] = {
  0x36, 0x7f, 0x3a, 0x06 // shasx eq r7 r10 r6
};
const byte kInstruction_shasx_pl_r1_r12_r2[] = {
  0x32, 0x1f, 0x3c, 0x56 // shasx pl r1 r12 r2
};
const byte kInstruction_shasx_le_r14_r6_r6[] = {
  0x36, 0xef, 0x36, 0xd6 // shasx le r14 r6 r6
};
const byte kInstruction_shasx_ne_r3_r8_r8[] = {
  0x38, 0x3f, 0x38, 0x16 // shasx ne r3 r8 r8
};
const byte kInstruction_shasx_eq_r4_r12_r8[] = {
  0x38, 0x4f, 0x3c, 0x06 // shasx eq r4 r12 r8
};
const byte kInstruction_shasx_ge_r11_r2_r3[] = {
  0x33, 0xbf, 0x32, 0xa6 // shasx ge r11 r2 r3
};
const byte kInstruction_shasx_hi_r12_r6_r11[] = {
  0x3b, 0xcf, 0x36, 0x86 // shasx hi r12 r6 r11
};
const byte kInstruction_shasx_cs_r4_r5_r10[] = {
  0x3a, 0x4f, 0x35, 0x26 // shasx cs r4 r5 r10
};
const byte kInstruction_shasx_ge_r10_r2_r10[] = {
  0x3a, 0xaf, 0x32, 0xa6 // shasx ge r10 r2 r10
};
const byte kInstruction_shasx_ge_r5_r14_r6[] = {
  0x36, 0x5f, 0x3e, 0xa6 // shasx ge r5 r14 r6
};
const byte kInstruction_shasx_gt_r13_r7_r5[] = {
  0x35, 0xdf, 0x37, 0xc6 // shasx gt r13 r7 r5
};
const byte kInstruction_shasx_ge_r13_r4_r12[] = {
  0x3c, 0xdf, 0x34, 0xa6 // shasx ge r13 r4 r12
};
const byte kInstruction_shasx_lt_r8_r10_r14[] = {
  0x3e, 0x8f, 0x3a, 0xb6 // shasx lt r8 r10 r14
};
const byte kInstruction_shasx_le_r4_r3_r13[] = {
  0x3d, 0x4f, 0x33, 0xd6 // shasx le r4 r3 r13
};
const byte kInstruction_shasx_pl_r0_r9_r0[] = {
  0x30, 0x0f, 0x39, 0x56 // shasx pl r0 r9 r0
};
const byte kInstruction_shasx_eq_r2_r3_r1[] = {
  0x31, 0x2f, 0x33, 0x06 // shasx eq r2 r3 r1
};
const byte kInstruction_shasx_vc_r0_r0_r3[] = {
  0x33, 0x0f, 0x30, 0x76 // shasx vc r0 r0 r3
};
const byte kInstruction_shasx_mi_r10_r8_r11[] = {
  0x3b, 0xaf, 0x38, 0x46 // shasx mi r10 r8 r11
};
const byte kInstruction_shasx_mi_r5_r14_r14[] = {
  0x3e, 0x5f, 0x3e, 0x46 // shasx mi r5 r14 r14
};
const byte kInstruction_shasx_gt_r5_r11_r2[] = {
  0x32, 0x5f, 0x3b, 0xc6 // shasx gt r5 r11 r2
};
const byte kInstruction_shasx_al_r4_r7_r11[] = {
  0x3b, 0x4f, 0x37, 0xe6 // shasx al r4 r7 r11
};
const TestResult kReferenceshasx[] = {
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r1_r9_r5),
    kInstruction_shasx_hi_r1_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r8_r6_r2),
    kInstruction_shasx_pl_r8_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r5_r8_r2),
    kInstruction_shasx_hi_r5_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r9_r2_r7),
    kInstruction_shasx_vc_r9_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r4_r6_r3),
    kInstruction_shasx_lt_r4_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r11_r6_r2),
    kInstruction_shasx_le_r11_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r8_r14_r4),
    kInstruction_shasx_cc_r8_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r5_r14_r6),
    kInstruction_shasx_le_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r6_r1_r0),
    kInstruction_shasx_lt_r6_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r5_r0_r9),
    kInstruction_shasx_lt_r5_r0_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r8_r12_r7),
    kInstruction_shasx_le_r8_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r7_r14_r6),
    kInstruction_shasx_eq_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r7_r4_r6),
    kInstruction_shasx_cs_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_gt_r9_r6_r9),
    kInstruction_shasx_gt_r9_r6_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r13_r9_r1),
    kInstruction_shasx_ne_r13_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r13_r1_r13),
    kInstruction_shasx_ge_r13_r1_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r8_r10_r2),
    kInstruction_shasx_ls_r8_r10_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r0_r13_r5),
    kInstruction_shasx_hi_r0_r13_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r13_r7_r8),
    kInstruction_shasx_pl_r13_r7_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r4_r13_r11),
    kInstruction_shasx_ge_r4_r13_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r5_r10_r5),
    kInstruction_shasx_cs_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r5_r4_r3),
    kInstruction_shasx_cs_r5_r4_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r6_r14_r8),
    kInstruction_shasx_ls_r6_r14_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r3_r8_r6),
    kInstruction_shasx_vs_r3_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r7_r12_r3),
    kInstruction_shasx_vc_r7_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r1_r4_r1),
    kInstruction_shasx_ge_r1_r4_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r4_r7_r10),
    kInstruction_shasx_cc_r4_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r2_r0_r13),
    kInstruction_shasx_cc_r2_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r9_r6_r8),
    kInstruction_shasx_vs_r9_r6_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r14_r11_r13),
    kInstruction_shasx_cs_r14_r11_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r5_r8_r4),
    kInstruction_shasx_pl_r5_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r2_r3_r7),
    kInstruction_shasx_pl_r2_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r7_r12_r14),
    kInstruction_shasx_cs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r6_r6_r1),
    kInstruction_shasx_hi_r6_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r6_r9_r6),
    kInstruction_shasx_cc_r6_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r12_r12_r0),
    kInstruction_shasx_ne_r12_r12_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r9_r3_r8),
    kInstruction_shasx_cc_r9_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r13_r6_r1),
    kInstruction_shasx_mi_r13_r6_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r4_r8_r6),
    kInstruction_shasx_lt_r4_r8_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r11_r5_r9),
    kInstruction_shasx_hi_r11_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r6_r10_r6),
    kInstruction_shasx_cc_r6_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r10_r10_r5),
    kInstruction_shasx_eq_r10_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r5_r4_r11),
    kInstruction_shasx_al_r5_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r11_r11_r2),
    kInstruction_shasx_pl_r11_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r6_r14_r12),
    kInstruction_shasx_ls_r6_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r7_r7_r2),
    kInstruction_shasx_vc_r7_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r10_r8_r4),
    kInstruction_shasx_eq_r10_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r14_r7_r2),
    kInstruction_shasx_al_r14_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r3_r11_r10),
    kInstruction_shasx_cs_r3_r11_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r11_r4_r0),
    kInstruction_shasx_ls_r11_r4_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r11_r8_r9),
    kInstruction_shasx_hi_r11_r8_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r2_r14_r13),
    kInstruction_shasx_vs_r2_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r1_r13_r9),
    kInstruction_shasx_al_r1_r13_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r3_r9_r13),
    kInstruction_shasx_eq_r3_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r10_r3_r13),
    kInstruction_shasx_ge_r10_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r8_r5_r10),
    kInstruction_shasx_pl_r8_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r8_r11_r6),
    kInstruction_shasx_vc_r8_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r0_r0_r5),
    kInstruction_shasx_eq_r0_r0_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r6_r5_r8),
    kInstruction_shasx_ne_r6_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r5_r13_r3),
    kInstruction_shasx_hi_r5_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r11_r14_r14),
    kInstruction_shasx_ne_r11_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r1_r0_r6),
    kInstruction_shasx_mi_r1_r0_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r14_r8_r2),
    kInstruction_shasx_le_r14_r8_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r9_r6_r5),
    kInstruction_shasx_eq_r9_r6_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r11_r0_r13),
    kInstruction_shasx_eq_r11_r0_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r4_r5_r14),
    kInstruction_shasx_pl_r4_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r13_r5_r13),
    kInstruction_shasx_cs_r13_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r0_r13_r8),
    kInstruction_shasx_mi_r0_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r2_r13_r3),
    kInstruction_shasx_lt_r2_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r8_r1_r11),
    kInstruction_shasx_ls_r8_r1_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r14_r11_r8),
    kInstruction_shasx_vc_r14_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r4_r13_r12),
    kInstruction_shasx_lt_r4_r13_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r2_r1_r14),
    kInstruction_shasx_eq_r2_r1_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r9_r4_r14),
    kInstruction_shasx_eq_r9_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r10_r6_r13),
    kInstruction_shasx_hi_r10_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r12_r9_r4),
    kInstruction_shasx_ge_r12_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r9_r11_r14),
    kInstruction_shasx_le_r9_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r0_r9_r5),
    kInstruction_shasx_ls_r0_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r2_r3_r8),
    kInstruction_shasx_mi_r2_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r14_r10_r14),
    kInstruction_shasx_ne_r14_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r6_r2_r10),
    kInstruction_shasx_eq_r6_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r11_r0_r12),
    kInstruction_shasx_lt_r11_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r1_r12_r10),
    kInstruction_shasx_ne_r1_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r1_r0_r2),
    kInstruction_shasx_cc_r1_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r5_r5_r7),
    kInstruction_shasx_al_r5_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r7_r13_r1),
    kInstruction_shasx_hi_r7_r13_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r4_r4_r9),
    kInstruction_shasx_cs_r4_r4_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r14_r4_r14),
    kInstruction_shasx_eq_r14_r4_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r10_r5_r14),
    kInstruction_shasx_vs_r10_r5_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_gt_r4_r3_r11),
    kInstruction_shasx_gt_r4_r3_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r14_r10_r12),
    kInstruction_shasx_ne_r14_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r2_r11_r0),
    kInstruction_shasx_vs_r2_r11_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r5_r12_r7),
    kInstruction_shasx_ge_r5_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r7_r14_r6),
    kInstruction_shasx_mi_r7_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_gt_r8_r3_r8),
    kInstruction_shasx_gt_r8_r3_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r9_r14_r3),
    kInstruction_shasx_hi_r9_r14_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r2_r11_r2),
    kInstruction_shasx_vc_r2_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r11_r7_r12),
    kInstruction_shasx_hi_r11_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r6_r4_r11),
    kInstruction_shasx_cs_r6_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r12_r5_r9),
    kInstruction_shasx_cs_r12_r5_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r5_r10_r5),
    kInstruction_shasx_ls_r5_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r0_r9_r13),
    kInstruction_shasx_ls_r0_r9_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r3_r3_r5),
    kInstruction_shasx_lt_r3_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r0_r12_r8),
    kInstruction_shasx_mi_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r3_r12_r12),
    kInstruction_shasx_pl_r3_r12_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r8_r12_r5),
    kInstruction_shasx_eq_r8_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r7_r8_r1),
    kInstruction_shasx_cc_r7_r8_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r2_r13_r10),
    kInstruction_shasx_hi_r2_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r7_r10_r10),
    kInstruction_shasx_al_r7_r10_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r1_r12_r2),
    kInstruction_shasx_vc_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r8_r5_r8),
    kInstruction_shasx_cc_r8_r5_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r3_r7_r9),
    kInstruction_shasx_ls_r3_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r8_r10_r8),
    kInstruction_shasx_al_r8_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r4_r12_r10),
    kInstruction_shasx_lt_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r10_r5_r11),
    kInstruction_shasx_ge_r10_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r3_r14_r4),
    kInstruction_shasx_ls_r3_r14_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r3_r6_r12),
    kInstruction_shasx_hi_r3_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r6_r0_r4),
    kInstruction_shasx_hi_r6_r0_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r11_r6_r0),
    kInstruction_shasx_al_r11_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r3_r1_r9),
    kInstruction_shasx_mi_r3_r1_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r12_r13_r0),
    kInstruction_shasx_mi_r12_r13_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r1_r2_r5),
    kInstruction_shasx_le_r1_r2_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r4_r3_r14),
    kInstruction_shasx_hi_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r6_r11_r11),
    kInstruction_shasx_eq_r6_r11_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r14_r11_r14),
    kInstruction_shasx_cc_r14_r11_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r4_r10_r0),
    kInstruction_shasx_hi_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r7_r11_r1),
    kInstruction_shasx_cc_r7_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r14_r6_r10),
    kInstruction_shasx_mi_r14_r6_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r2_r0_r11),
    kInstruction_shasx_eq_r2_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r13_r5_r12),
    kInstruction_shasx_mi_r13_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r2_r12_r5),
    kInstruction_shasx_eq_r2_r12_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r12_r0_r2),
    kInstruction_shasx_le_r12_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r10_r10_r9),
    kInstruction_shasx_vc_r10_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r11_r11_r8),
    kInstruction_shasx_ls_r11_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r10_r11_r9),
    kInstruction_shasx_hi_r10_r11_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r7_r12_r14),
    kInstruction_shasx_vs_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_gt_r11_r14_r12),
    kInstruction_shasx_gt_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r0_r12_r8),
    kInstruction_shasx_vs_r0_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r0_r5_r7),
    kInstruction_shasx_al_r0_r5_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r5_r13_r8),
    kInstruction_shasx_hi_r5_r13_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r9_r9_r7),
    kInstruction_shasx_le_r9_r9_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r4_r9_r5),
    kInstruction_shasx_cc_r4_r9_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r8_r1_r3),
    kInstruction_shasx_vs_r8_r1_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r0_r10_r12),
    kInstruction_shasx_cc_r0_r10_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r7_r14_r0),
    kInstruction_shasx_eq_r7_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r12_r9_r11),
    kInstruction_shasx_vs_r12_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_gt_r5_r9_r11),
    kInstruction_shasx_gt_r5_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r14_r13_r7),
    kInstruction_shasx_cs_r14_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r11_r3_r10),
    kInstruction_shasx_mi_r11_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r11_r8_r12),
    kInstruction_shasx_hi_r11_r8_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r3_r8_r13),
    kInstruction_shasx_cs_r3_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r10_r12_r6),
    kInstruction_shasx_pl_r10_r12_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r7_r3_r2),
    kInstruction_shasx_vc_r7_r3_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r9_r0_r8),
    kInstruction_shasx_mi_r9_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r2_r13_r7),
    kInstruction_shasx_eq_r2_r13_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r2_r14_r0),
    kInstruction_shasx_ne_r2_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r4_r10_r0),
    kInstruction_shasx_vs_r4_r10_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r0_r2_r2),
    kInstruction_shasx_ls_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r1_r6_r0),
    kInstruction_shasx_cc_r1_r6_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r12_r0_r8),
    kInstruction_shasx_lt_r12_r0_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r9_r3_r14),
    kInstruction_shasx_cc_r9_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r7_r9_r1),
    kInstruction_shasx_vs_r7_r9_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r11_r9_r14),
    kInstruction_shasx_eq_r11_r9_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r6_r10_r4),
    kInstruction_shasx_pl_r6_r10_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r8_r5_r6),
    kInstruction_shasx_ne_r8_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r0_r6_r2),
    kInstruction_shasx_cs_r0_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r11_r12_r4),
    kInstruction_shasx_eq_r11_r12_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r14_r3_r14),
    kInstruction_shasx_lt_r14_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r7_r12_r14),
    kInstruction_shasx_le_r7_r12_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r2_r9_r9),
    kInstruction_shasx_hi_r2_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r8_r1_r0),
    kInstruction_shasx_ne_r8_r1_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r5_r11_r2),
    kInstruction_shasx_cc_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r0_r1_r2),
    kInstruction_shasx_hi_r0_r1_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r4_r9_r4),
    kInstruction_shasx_al_r4_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r12_r7_r14),
    kInstruction_shasx_cs_r12_r7_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r4_r12_r10),
    kInstruction_shasx_cc_r4_r12_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r3_r5_r10),
    kInstruction_shasx_al_r3_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r5_r3_r7),
    kInstruction_shasx_mi_r5_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r10_r6_r2),
    kInstruction_shasx_ls_r10_r6_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r0_r12_r11),
    kInstruction_shasx_mi_r0_r12_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r12_r5_r6),
    kInstruction_shasx_vc_r12_r5_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r3_r9_r4),
    kInstruction_shasx_cs_r3_r9_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r4_r9_r11),
    kInstruction_shasx_ls_r4_r9_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r14_r8_r13),
    kInstruction_shasx_le_r14_r8_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_gt_r4_r10_r8),
    kInstruction_shasx_gt_r4_r10_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r6_r9_r9),
    kInstruction_shasx_al_r6_r9_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r8_r5_r12),
    kInstruction_shasx_ne_r8_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r0_r4_r8),
    kInstruction_shasx_ne_r0_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r7_r13_r3),
    kInstruction_shasx_mi_r7_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r11_r7_r0),
    kInstruction_shasx_cc_r11_r7_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r1_r0_r12),
    kInstruction_shasx_hi_r1_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r8_r9_r3),
    kInstruction_shasx_lt_r8_r9_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r0_r2_r1),
    kInstruction_shasx_al_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r4_r3_r14),
    kInstruction_shasx_vs_r4_r3_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r2_r11_r1),
    kInstruction_shasx_ge_r2_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r12_r9_r6),
    kInstruction_shasx_lt_r12_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r8_r2_r7),
    kInstruction_shasx_ls_r8_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r8_r13_r3),
    kInstruction_shasx_le_r8_r13_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r11_r13_r14),
    kInstruction_shasx_eq_r11_r13_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r1_r6_r13),
    kInstruction_shasx_lt_r1_r6_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r3_r8_r11),
    kInstruction_shasx_cs_r3_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r12_r5_r4),
    kInstruction_shasx_pl_r12_r5_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r8_r7_r2),
    kInstruction_shasx_eq_r8_r7_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r2_r12_r2),
    kInstruction_shasx_ls_r2_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r14_r2_r3),
    kInstruction_shasx_le_r14_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r10_r11_r6),
    kInstruction_shasx_ge_r10_r11_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r0_r2_r2),
    kInstruction_shasx_hi_r0_r2_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r2_r0_r2),
    kInstruction_shasx_ge_r2_r0_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r11_r14_r0),
    kInstruction_shasx_vs_r11_r14_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r2_r0_r1),
    kInstruction_shasx_lt_r2_r0_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r2_r5_r11),
    kInstruction_shasx_cs_r2_r5_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r7_r14_r5),
    kInstruction_shasx_ls_r7_r14_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r0_r0_r3),
    kInstruction_shasx_pl_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r6_r8_r8),
    kInstruction_shasx_ge_r6_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r11_r1_r10),
    kInstruction_shasx_le_r11_r1_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r5_r2_r7),
    kInstruction_shasx_vs_r5_r2_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r4_r4_r8),
    kInstruction_shasx_ne_r4_r4_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r9_r14_r13),
    kInstruction_shasx_cc_r9_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r14_r6_r3),
    kInstruction_shasx_hi_r14_r6_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r0_r8_r0),
    kInstruction_shasx_al_r0_r8_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r6_r11_r1),
    kInstruction_shasx_lt_r6_r11_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r7_r6_r12),
    kInstruction_shasx_ge_r7_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r4_r6_r14),
    kInstruction_shasx_cs_r4_r6_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r7_r6_r7),
    kInstruction_shasx_cs_r7_r6_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r3_r7_r10),
    kInstruction_shasx_cs_r3_r7_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r0_r2_r1),
    kInstruction_shasx_ne_r0_r2_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r9_r10_r13),
    kInstruction_shasx_vs_r9_r10_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r11_r14_r12),
    kInstruction_shasx_vc_r11_r14_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r14_r8_r7),
    kInstruction_shasx_ge_r14_r8_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r13_r0_r11),
    kInstruction_shasx_lt_r13_r0_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r14_r13_r4),
    kInstruction_shasx_lt_r14_r13_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r1_r10_r9),
    kInstruction_shasx_al_r1_r10_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r11_r14_r11),
    kInstruction_shasx_ge_r11_r14_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r11_r4_r11),
    kInstruction_shasx_cs_r11_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r0_r14_r7),
    kInstruction_shasx_ge_r0_r14_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r1_r2_r9),
    kInstruction_shasx_mi_r1_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r5_r12_r3),
    kInstruction_shasx_eq_r5_r12_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r1_r5_r12),
    kInstruction_shasx_ge_r1_r5_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r10_r11_r4),
    kInstruction_shasx_lt_r10_r11_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r1_r1_r5),
    kInstruction_shasx_le_r1_r1_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r9_r1_r8),
    kInstruction_shasx_al_r9_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r6_r8_r4),
    kInstruction_shasx_ne_r6_r8_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r12_r2_r9),
    kInstruction_shasx_ge_r12_r2_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r4_r3_r10),
    kInstruction_shasx_pl_r4_r3_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r14_r4_r11),
    kInstruction_shasx_eq_r14_r4_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r9_r7_r6),
    kInstruction_shasx_cc_r9_r7_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r12_r4_r5),
    kInstruction_shasx_ge_r12_r4_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r2_r3_r4),
    kInstruction_shasx_hi_r2_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r0_r3_r1),
    kInstruction_shasx_cs_r0_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r6_r2_r8),
    kInstruction_shasx_hi_r6_r2_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r3_r14_r13),
    kInstruction_shasx_cc_r3_r14_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_gt_r11_r4_r7),
    kInstruction_shasx_gt_r11_r4_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r5_r0_r12),
    kInstruction_shasx_hi_r5_r0_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_gt_r0_r14_r14),
    kInstruction_shasx_gt_r0_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r9_r0_r10),
    kInstruction_shasx_hi_r9_r0_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r7_r11_r8),
    kInstruction_shasx_vc_r7_r11_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r11_r9_r6),
    kInstruction_shasx_pl_r11_r9_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r3_r3_r7),
    kInstruction_shasx_al_r3_r3_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r5_r7_r9),
    kInstruction_shasx_mi_r5_r7_r9,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r11_r2_r4),
    kInstruction_shasx_cc_r11_r2_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r9_r13_r10),
    kInstruction_shasx_cc_r9_r13_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r5_r2_r6),
    kInstruction_shasx_al_r5_r2_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r9_r4_r6),
    kInstruction_shasx_ge_r9_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r3_r3_r4),
    kInstruction_shasx_ls_r3_r3_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r14_r1_r8),
    kInstruction_shasx_ge_r14_r1_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ls_r7_r12_r7),
    kInstruction_shasx_ls_r7_r12_r7,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r11_r10_r5),
    kInstruction_shasx_al_r11_r10_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r7_r4_r6),
    kInstruction_shasx_al_r7_r4_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r12_r4_r10),
    kInstruction_shasx_vs_r12_r4_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r4_r4_r4),
    kInstruction_shasx_eq_r4_r4_r4,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vs_r6_r6_r12),
    kInstruction_shasx_vs_r6_r6_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r9_r3_r5),
    kInstruction_shasx_pl_r9_r3_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r6_r5_r13),
    kInstruction_shasx_eq_r6_r5_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cc_r8_r2_r12),
    kInstruction_shasx_cc_r8_r2_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r4_r2_r0),
    kInstruction_shasx_le_r4_r2_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r7_r9_r8),
    kInstruction_shasx_lt_r7_r9_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r4_r7_r11),
    kInstruction_shasx_le_r4_r7_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r5_r7_r5),
    kInstruction_shasx_eq_r5_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r10_r7_r12),
    kInstruction_shasx_vc_r10_r7_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r7_r10_r6),
    kInstruction_shasx_eq_r7_r10_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r1_r12_r2),
    kInstruction_shasx_pl_r1_r12_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r14_r6_r6),
    kInstruction_shasx_le_r14_r6_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ne_r3_r8_r8),
    kInstruction_shasx_ne_r3_r8_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r4_r12_r8),
    kInstruction_shasx_eq_r4_r12_r8,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r11_r2_r3),
    kInstruction_shasx_ge_r11_r2_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_hi_r12_r6_r11),
    kInstruction_shasx_hi_r12_r6_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_cs_r4_r5_r10),
    kInstruction_shasx_cs_r4_r5_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r10_r2_r10),
    kInstruction_shasx_ge_r10_r2_r10,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r5_r14_r6),
    kInstruction_shasx_ge_r5_r14_r6,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_gt_r13_r7_r5),
    kInstruction_shasx_gt_r13_r7_r5,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_ge_r13_r4_r12),
    kInstruction_shasx_ge_r13_r4_r12,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_lt_r8_r10_r14),
    kInstruction_shasx_lt_r8_r10_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_le_r4_r3_r13),
    kInstruction_shasx_le_r4_r3_r13,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_pl_r0_r9_r0),
    kInstruction_shasx_pl_r0_r9_r0,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_eq_r2_r3_r1),
    kInstruction_shasx_eq_r2_r3_r1,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_vc_r0_r0_r3),
    kInstruction_shasx_vc_r0_r0_r3,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r10_r8_r11),
    kInstruction_shasx_mi_r10_r8_r11,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_mi_r5_r14_r14),
    kInstruction_shasx_mi_r5_r14_r14,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_gt_r5_r11_r2),
    kInstruction_shasx_gt_r5_r11_r2,
  },
  {
    ARRAY_SIZE(kInstruction_shasx_al_r4_r7_r11),
    kInstruction_shasx_al_r4_r7_r11,
  },
};

#endif  // VIXL_ASSEMBLER_COND_RD_RN_RM_SHASX_A32_H_
