
# NGINX Plus by HTTP

## Overview

This template is designed to monitor NGINX Plus by Zabbix that works without any external scripts.
 Most of the metrics are collected in one go, thanks to Zabbix bulk data collection.

 > The monitoring data of the live activity is generated by the [NGINX Plus API](http://nginx.org/en/docs/http/ngx_http_api_module.html).


## Tested versions

This template has been tested on:

- NGINX Plus, version 1.19.10

## Requirements

For Zabbix version: 6.0 and higher.

## Setup

> See [Zabbix template operation](https://www.zabbix.com/documentation/6.0/manual/config/templates_out_of_the_box/http) for basic instructions.

1. Enable the NGINX Plus API.
> Refer to the [vendor documentation](https://www.nginx.com/products/nginx/live-activity-monitoring/).
2. Set the {$NGINX.API.ENDPOINT} such as `<scheme>://<host>:<port>/<location>/`.

**Note** that depending on the number of zones and upstreams discovery operation may be expensive. 
Therefore, use the following filters with these macros:

- {$NGINX.LLD.FILTER.HTTP.ZONE.MATCHES}
- {$NGINX.LLD.FILTER.HTTP.ZONE.NOT_MATCHES}
- {$NGINX.LLD.FILTER.HTTP.LOCATION.ZONE.MATCHES}
- {$NGINX.LLD.FILTER.HTTP.LOCATION.ZONE.NOT_MATCHES}
- {$NGINX.LLD.FILTER.HTTP.UPSTREAM.MATCHES}
- {$NGINX.LLD.FILTER.HTTP.UPSTREAM.NOT_MATCHES}
- {$NGINX.LLD.FILTER.STREAM.ZONE.MATCHES}
- {$NGINX.LLD.FILTER.STREAM.ZONE.NOT_MATCHES}
- {$NGINX.LLD.FILTER.STREAM.UPSTREAM.MATCHES}
- {$NGINX.LLD.FILTER.STREAM.UPSTREAM.NOT_MATCHES}
- {$NGINX.LLD.FILTER.RESOLVER.MATCHES}
- {$NGINX.LLD.FILTER.RESOLVER.NOT_MATCHES}



## Configuration

No specific Zabbix configuration is required.

### Macros used

|Name|Description|Default|
|----|-----------|-------|
|{$NGINX.API.ENDPOINT} |<p>NGINX Plus API URL in the format `<scheme>://<host>:<port>/<location>/`.</p> |`` |
|{$NGINX.DROP_RATE.MAX.WARN} |<p>The critical rate of the dropped connections for a  trigger expression.</p> |`1` |
|{$NGINX.HTTP.UPSTREAM.4XX.MAX.WARN} |<p>The maximum percentage of errors with the status code `4xx` (for a trigger expression).</p> |`5` |
|{$NGINX.HTTP.UPSTREAM.5XX.MAX.WARN} |<p>The maximum percentage of errors with the status code `5xx` (for a trigger expression).</p> |`5` |
|{$NGINX.LLD.FILTER.HTTP.LOCATION.ZONE.MATCHES} |<p>The filter to include the necessary discovered HTTP location zones.</p> |`.*` |
|{$NGINX.LLD.FILTER.HTTP.LOCATION.ZONE.NOT_MATCHES} |<p>The filter to exclude discovered HTTP location zones.</p> |`CHANGE_IF_NEEDED` |
|{$NGINX.LLD.FILTER.HTTP.UPSTREAM.MATCHES} |<p>The filter to include the necessary discovered HTTP upstreams.</p> |`.*` |
|{$NGINX.LLD.FILTER.HTTP.UPSTREAM.NOT_MATCHES} |<p>The filter to exclude discovered HTTP upstreams.</p> |`CHANGE_IF_NEEDED` |
|{$NGINX.LLD.FILTER.HTTP.ZONE.MATCHES} |<p>The filter to include the necessary discovered HTTP server zones.</p> |`.*` |
|{$NGINX.LLD.FILTER.HTTP.ZONE.NOT_MATCHES} |<p>The filter to exclude discovered HTTP server zones.</p> |`CHANGE_IF_NEEDED` |
|{$NGINX.LLD.FILTER.RESOLVER.MATCHES} |<p>The filter to include the necessary discovered `Resolvers`.</p> |`.*` |
|{$NGINX.LLD.FILTER.RESOLVER.NOT_MATCHES} |<p>The filter to exclude discovered `Resolvers`.</p> |`CHANGE_IF_NEEDED` |
|{$NGINX.LLD.FILTER.STREAM.UPSTREAM.MATCHES} |<p>The filter to include the necessary discovered upstreams of the "stream" directive.</p> |`.*` |
|{$NGINX.LLD.FILTER.STREAM.UPSTREAM.NOT_MATCHES} |<p>The filter to exclude discovered upstreams of the "stream" directive</p> |`CHANGE_IF_NEEDED` |
|{$NGINX.LLD.FILTER.STREAM.ZONE.MATCHES} |<p>The filter to include discovered server zones of the "stream" directive.</p> |`.*` |
|{$NGINX.LLD.FILTER.STREAM.ZONE.NOT_MATCHES} |<p>The filter to exclude discovered server zones of the "stream" directive.</p> |`CHANGE_IF_NEEDED` |

### Template links

There are no template links in this template.

### Discovery rules

|Name|Description|Type|Key and additional info|
|----|-----------|----|----|
|HTTP location zones discovery |<p>-</p> |DEPENDENT |nginx.http.location_zones.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p><p>**Filter**:</p>AND <p>- {#NAME} MATCHES_REGEX `{$NGINX.LLD.FILTER.HTTP.LOCATION.ZONE.MATCHES}`</p><p>- {#NAME} NOT_MATCHES_REGEX `{$NGINX.LLD.FILTER.HTTP.LOCATION.ZONE.NOT_MATCHES}`</p> |
|HTTP server zones discovery |<p>-</p> |DEPENDENT |nginx.http.server_zones.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p><p>**Filter**:</p>AND <p>- {#NAME} MATCHES_REGEX `{$NGINX.LLD.FILTER.HTTP.ZONE.MATCHES}`</p><p>- {#NAME} NOT_MATCHES_REGEX `{$NGINX.LLD.FILTER.HTTP.ZONE.NOT_MATCHES}`</p> |
|HTTP upstream peers discovery |<p>-</p> |DEPENDENT |nginx.http.upstream.peers.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p><p>**Filter**:</p>AND <p>- {#UPSTREAM} MATCHES_REGEX `{$NGINX.LLD.FILTER.HTTP.UPSTREAM.MATCHES}`</p><p>- {#UPSTREAM} NOT_MATCHES_REGEX `{$NGINX.LLD.FILTER.HTTP.UPSTREAM.NOT_MATCHES}`</p> |
|HTTP upstreams discovery |<p>-</p> |DEPENDENT |nginx.http.upstreams.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p><p>**Filter**:</p>AND <p>- {#NAME} MATCHES_REGEX `{$NGINX.LLD.FILTER.HTTP.UPSTREAM.MATCHES}`</p><p>- {#NAME} NOT_MATCHES_REGEX `{$NGINX.LLD.FILTER.HTTP.UPSTREAM.NOT_MATCHES}`</p> |
|Resolvers discovery |<p>-</p> |DEPENDENT |nginx.resolvers.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p><p>**Filter**:</p>AND <p>- {#NAME} MATCHES_REGEX `{$NGINX.LLD.FILTER.RESOLVER.MATCHES}`</p><p>- {#NAME} NOT_MATCHES_REGEX `{$NGINX.LLD.FILTER.RESOLVER.NOT_MATCHES}`</p> |
|Stream server zones discovery |<p>-</p> |DEPENDENT |nginx.stream.server_zones.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p><p>**Filter**:</p>AND <p>- {#NAME} MATCHES_REGEX `{$NGINX.LLD.FILTER.STREAM.ZONE.MATCHES}`</p><p>- {#NAME} NOT_MATCHES_REGEX `{$NGINX.LLD.FILTER.STREAM.ZONE.NOT_MATCHES}`</p> |
|Stream upstream peers discovery |<p>-</p> |DEPENDENT |nginx.stream.upstream.peers.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p><p>**Filter**:</p>AND <p>- {#UPSTREAM} MATCHES_REGEX `{$NGINX.LLD.FILTER.STREAM.UPSTREAM.MATCHES}`</p><p>- {#UPSTREAM} NOT_MATCHES_REGEX `{$NGINX.LLD.FILTER.STREAM.UPSTREAM.NOT_MATCHES}`</p> |
|Stream upstreams discovery |<p>-</p> |DEPENDENT |nginx.stream.upstreams.discovery<p>**Preprocessing**:</p><p>- JAVASCRIPT: `The text is too long. Please see the template.`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p><p>**Filter**:</p>AND <p>- {#NAME} MATCHES_REGEX `{$NGINX.LLD.FILTER.STREAM.UPSTREAM.MATCHES}`</p><p>- {#NAME} NOT_MATCHES_REGEX `{$NGINX.LLD.FILTER.STREAM.UPSTREAM.NOT_MATCHES}`</p> |

### Items collected

|Group|Name|Description|Type|Key and additional info|
|-----|----|-----------|----|---------------------|
|Nginx |Nginx: Get info error |<p>The description of NGINX errors.</p> |DEPENDENT |nginx.info.error<p>**Preprocessing**:</p><p>- JSONPATH: `$.error.text`</p><p>⛔️ON_FAIL: `CUSTOM_VALUE -> `</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `1h`</p> |
|Nginx |Nginx: Version |<p>A version number of NGINX.</p> |DEPENDENT |nginx.info.version<p>**Preprocessing**:</p><p>- JSONPATH: `$.version`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Nginx |Nginx: Address |<p>The address of the server that accepted status request.</p> |DEPENDENT |nginx.info.address<p>**Preprocessing**:</p><p>- JSONPATH: `$.address`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Nginx |Nginx: Generation |<p>The total number of configuration reloads.</p> |DEPENDENT |nginx.info.generation<p>**Preprocessing**:</p><p>- JSONPATH: `$.generation`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `30m`</p> |
|Nginx |Nginx: Uptime |<p>The server uptime.</p> |DEPENDENT |nginx.info.uptime<p>**Preprocessing**:</p><p>- JSONPATH: `$.load_timestamp`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p><p>- JAVASCRIPT: `return Math.floor((Date.now() - new Date(value)) / 1000);`</p> |
|Nginx |Nginx: Connections accepted, rate |<p>The total number of accepted client connections per second.</p> |DEPENDENT |nginx.connections.accepted.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.accepted`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Connections dropped |<p>The total number of dropped client connections.</p> |DEPENDENT |nginx.connections.dropped<p>**Preprocessing**:</p><p>- JSONPATH: `$.dropped`</p> |
|Nginx |Nginx: Connections active |<p>The current number of active client connections.</p> |DEPENDENT |nginx.connections.active<p>**Preprocessing**:</p><p>- JSONPATH: `$.active`</p> |
|Nginx |Nginx: Connections idle |<p>The current number of idle client connections.</p> |DEPENDENT |nginx.connections.idle<p>**Preprocessing**:</p><p>- JSONPATH: `$.idle`</p> |
|Nginx |Nginx: SSL handshakes, rate |<p>The total number of successful SSL handshakes per second.</p> |DEPENDENT |nginx.ssl.handshakes.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.handshakes`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: SSL handshakes failed, rate |<p>The total number of failed SSL handshakes per second.</p> |DEPENDENT |nginx.ssl.handshakes_failed.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.handshakes_failed`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: SSL session reuses, rate |<p>The total number of session reuses during SSL handshake per second.</p> |DEPENDENT |nginx.ssl.session_reuses.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.session_reuses`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Requests total, rate |<p>The total number of client requests per second.</p> |DEPENDENT |nginx.requests.total.rate<p>**Preprocessing**:</p><p>- JSONPATH: `$.total`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Requests current |<p>The current number of client requests.</p> |DEPENDENT |nginx.requests.current<p>**Preprocessing**:</p><p>- JSONPATH: `$.current`</p> |
|Nginx |Nginx: HTTP server zone [{#NAME}]: Raw data |<p>The raw data of the HTTP server zone with the name `{#NAME}` .</p> |DEPENDENT |nginx.http.server_zones.raw[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$['{#NAME}']`</p> |
|Nginx |Nginx: HTTP server zone [{#NAME}]: Processing |<p>The number of client requests that are currently being processed.</p> |DEPENDENT |nginx.http.server_zones.processing[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.processing`</p> |
|Nginx |Nginx: HTTP server zone [{#NAME}]: Requests, rate |<p>The total number of client requests received from clients per second.</p> |DEPENDENT |nginx.http.server_zones.requests.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.requests`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP server zone [{#NAME}]: Responses 1xx, rate |<p>The number of responses with `1xx` status code per second.</p> |DEPENDENT |nginx.http.server_zones.responses.1xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.1xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP server zone [{#NAME}]: Responses 2xx, rate |<p>The number of responses with `2xx` status code per second.</p> |DEPENDENT |nginx.http.server_zones.responses.2xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.2xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP server zone [{#NAME}]: Responses 3xx, rate |<p>The number of responses with `3xx` status code per second.</p> |DEPENDENT |nginx.http.server_zones.responses.3xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.3xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP server zone [{#NAME}]: Responses 4xx, rate |<p>The number of responses with `4xx` status code per second.</p> |DEPENDENT |nginx.http.server_zones.responses.4xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.4xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP server zone [{#NAME}]: Responses 5xx, rate |<p>The number of responses with `5xx` status code per second.</p> |DEPENDENT |nginx.http.server_zones.responses.5xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.5xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP server zone [{#NAME}]: Responses total, rate |<p>The total number of responses sent to clients per second.</p> |DEPENDENT |nginx.http.server_zones.responses.total.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.total`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP server zone [{#NAME}]: Discarded, rate |<p>The total number of requests completed without sending a response per second.</p> |DEPENDENT |nginx.http.server_zones.discarded.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.discarded`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP server zone [{#NAME}]: Received, rate |<p>The total number of bytes received from clients per second.</p> |DEPENDENT |nginx.http.server_zones.received.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.received`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP server zone [{#NAME}]: Sent, rate |<p>The total number of bytes sent to clients per second.</p> |DEPENDENT |nginx.http.server_zones.sent.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.sent`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP location zone [{#NAME}]: Raw data |<p>The raw data of the location zone with the name `{#NAME}`.</p> |DEPENDENT |nginx.http.location_zones.raw[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$['{#NAME}']`</p> |
|Nginx |Nginx: HTTP location zone [{#NAME}]: Requests, rate |<p>The total number of client requests received from clients per second.</p> |DEPENDENT |nginx.http.location_zones.requests.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.requests`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP location zone [{#NAME}]: Responses 1xx, rate |<p>The number of responses with `1xx` status code per second.</p> |DEPENDENT |nginx.http.location_zones.responses.1xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.1xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP location zone [{#NAME}]: Responses 2xx, rate |<p>The number of responses with `2xx` status code per second.</p> |DEPENDENT |nginx.http.location_zones.responses.2xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.2xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP location zone [{#NAME}]: Responses 3xx, rate |<p>The number of responses with `3xx` status code per second.</p> |DEPENDENT |nginx.http.location_zones.responses.3xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.3xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP location zone [{#NAME}]: Responses 4xx, rate |<p>The number of responses with `4xx` status code per second.</p> |DEPENDENT |nginx.http.location_zones.responses.4xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.4xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP location zone [{#NAME}]: Responses 5xx, rate |<p>The number of responses with `5xx` status code per second.</p> |DEPENDENT |nginx.http.location_zones.responses.5xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.5xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP location zone [{#NAME}]: Responses total, rate |<p>The total number of responses sent to clients per second.</p> |DEPENDENT |nginx.http.location_zones.responses.total.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.total`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP location zone [{#NAME}]: Discarded, rate |<p>The total number of requests completed without sending a response per second.</p> |DEPENDENT |nginx.http.location_zones.discarded.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.discarded`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP location zone [{#NAME}]: Received, rate |<p>The total number of bytes received from clients per second.</p> |DEPENDENT |nginx.http.location_zones.received.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.received`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP location zone [{#NAME}]: Sent, rate |<p>The total number of bytes sent to clients per second.</p> |DEPENDENT |nginx.http.location_zones.sent.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.sent`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP upstream [{#NAME}]: Raw data |<p>The raw data of the HTTP upstream with the name `{#NAME}`.</p> |DEPENDENT |nginx.http.upstreams.raw[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$['{#NAME}']`</p> |
|Nginx |Nginx: HTTP upstream [{#NAME}]: Keepalive |<p>The current number of idle keepalive connections.</p> |DEPENDENT |nginx.http.upstreams.keepalive[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.keepalive`</p> |
|Nginx |Nginx: HTTP upstream [{#NAME}]: Zombies |<p>The current number of servers removed from the group but still processing active client requests.</p> |DEPENDENT |nginx.http.upstreams.zombies[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.zombies`</p> |
|Nginx |Nginx: HTTP upstream [{#NAME}]: Zone |<p>The name of the shared memory zone that keeps the group's configuration and run-time state.</p> |DEPENDENT |nginx.http.upstreams.zone[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.zone`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Raw data |<p>The raw data of the HTTP upstream with the name `[{#UPSTREAM}]`and peer with the name`[{#PEER}]`.</p> |DEPENDENT |nginx.http.upstream.peer.raw[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$['{#UPSTREAM}'].peers[?(@.server == '{#PEER}')].first()`</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: State |<p>The current state, which may be one of “up”, “draining”, “down”, “unavail”, “checking”, and “unhealthy”.</p> |DEPENDENT |nginx.http.upstream.peer.state[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.state`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Active |<p>The current number of active connections.</p> |DEPENDENT |nginx.http.upstream.peer.active[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.active`</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Requests, rate |<p>The total number of client requests forwarded to this server per second.</p> |DEPENDENT |nginx.http.upstream.peer.requests.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.requests`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Responses 1xx, rate |<p>The number of responses with `1xx` status code per second.</p> |DEPENDENT |nginx.http.upstream.peer.responses.1xx.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.1xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Responses 2xx, rate |<p>The number of responses with `2xx` status code per second.</p> |DEPENDENT |nginx.http.upstream.peer.responses.2xx.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.2xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Responses 3xx, rate |<p>The number of responses with `3xx` status code per second.</p> |DEPENDENT |nginx.http.upstream.peer.responses.3xx.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.3xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Responses 4xx, rate |<p>The number of responses with `4xx` status code per second.</p> |DEPENDENT |nginx.http.upstream.peer.responses.4xx.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.4xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Responses 5xx, rate |<p>The number of responses with `5xx` status code per second.</p> |DEPENDENT |nginx.http.upstream.peer.responses.5xx.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.5xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Responses total, rate |<p>The total number of responses obtained from this server.</p> |DEPENDENT |nginx.http.upstream.peer.responses.total.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.total`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Sent, rate |<p>The total number of bytes sent to this server per second.</p> |DEPENDENT |nginx.http.upstream.peer.sent.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.sent`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Received, rate |<p>The total number of bytes received from this server per second.</p> |DEPENDENT |nginx.http.upstream.peer.received.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.received`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Fails, rate |<p>The total number of unsuccessful attempts to communicate with the server per second.</p> |DEPENDENT |nginx.http.upstream.peer.fails.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.fails`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Unavail |<p>Displays how many times the server has become unavailable for client requests (the state - “unavail”) due to the number of unsuccessful attempts reaching the `max_fails` threshold.</p> |DEPENDENT |nginx.http.upstream.peer.unavail.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.unavail`</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Header time |<p>The average time to get the response header from the server.</p> |DEPENDENT |nginx.http.upstream.peer.header_time.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.header_time`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Response time |<p>The average time to get the full response from the server.</p> |DEPENDENT |nginx.http.upstream.peer.response_time.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.response_time`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Health checks, check |<p>The total number of health check requests made.</p> |DEPENDENT |nginx.http.upstream.peer.health_checks.checks[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.health_checks.checks`</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Health checks, fails |<p>The number of failed health checks.</p> |DEPENDENT |nginx.http.upstream.peer.health_checks.fails[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.health_checks.fails`</p> |
|Nginx |Nginx: HTTP upstream [{#UPSTREAM}] peer [{#PEER}]: Health checks, unhealthy |<p>Displays how many times the server has become `unhealthy` (the state - “unhealthy”.</p> |DEPENDENT |nginx.http.upstream.peer.health_checks.unhealthy[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.health_checks.unhealthy`</p> |
|Nginx |Nginx: Stream server zone [{#NAME}]: Raw data |<p>The raw data of server zone with the name `{#NAME}`, configured in the "stream" directive.</p> |DEPENDENT |nginx.stream.server_zones.raw[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$['{#NAME}']`</p> |
|Nginx |Nginx: Stream server zone [{#NAME}]: Processing |<p>The number of client connections that are currently being processed.</p> |DEPENDENT |nginx.stream.server_zones.processing[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.processing`</p> |
|Nginx |Nginx: Stream server zone [{#NAME}]: Connections, rate |<p>The total number of connections accepted from clients per second.</p> |DEPENDENT |nginx.stream.server_zones.connections.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.connections`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Stream server zone [{#NAME}]: Sessions 2xx, rate |<p>The total number of sessions completed with status code `2xx` per second.</p> |DEPENDENT |nginx.stream.server_zones.sessions.2xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.sessions.2xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Stream server zone [{#NAME}]: Sessions 4xx, rate |<p>The total number of sessions completed with status code `4xx` per second.</p> |DEPENDENT |nginx.stream.server_zones.sessions.4xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.sessions.4xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Stream server zone [{#NAME}]: Sessions 5xx, rate |<p>The total number of sessions completed with status code `5xx` per second.</p> |DEPENDENT |nginx.stream.server_zones.sessions.5xx.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.sessions.5xx`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Stream server zone [{#NAME}]: Sessions total, rate |<p>The total number of completed client sessions per second.</p> |DEPENDENT |nginx.stream.server_zones.sessions.total.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.sessions.total`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Stream server zone [{#NAME}]: Discarded, rate |<p>The total number of connections completed without creating a session per second.</p> |DEPENDENT |nginx.stream.server_zones.discarded.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.discarded`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Stream server zone [{#NAME}]: Received, rate |<p>The total number of bytes received from clients per second.</p> |DEPENDENT |nginx.stream.server_zones.received.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.received`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Stream server zone [{#NAME}]: Sent, rate |<p>The total number of bytes sent to clients per second.</p> |DEPENDENT |nginx.stream.server_zones.sent.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.sent`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Stream upstream [{#NAME}]: Raw data |<p>The raw data of the upstream with the name `[{#UPSTREAM}]`, configured in the "stream" directive.</p> |DEPENDENT |nginx.stream.upstreams.raw[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$['{#NAME}']`</p> |
|Nginx |Nginx: Stream upstream [{#NAME}]: Zombies |<p>-</p> |DEPENDENT |nginx.stream.upstreams.zombies[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.zombies`</p> |
|Nginx |Nginx: Stream upstream [{#NAME}]: Zone |<p>-</p> |DEPENDENT |nginx.stream.upstreams.zone[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.zone`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: Raw data |<p>The raw data of the upstream with the name `[{#UPSTREAM}]`and peer with the name`[{#PEER}]`, configured in the "stream" directive.</p> |DEPENDENT |nginx.stream.upstream.peer.raw[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$['{#UPSTREAM}'].peers[?(@.server == '{#PEER}')].first()`</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: State |<p>The current state, which may be one of “up”, “draining”, “down”, “unavail”, “checking”, and “unhealthy”.</p> |DEPENDENT |nginx.stream.upstream.peer.state[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.state`</p><p>- DISCARD_UNCHANGED_HEARTBEAT: `3h`</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: Active |<p>The current number of connections.</p> |DEPENDENT |nginx.stream.upstream.peer.active[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.active`</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: Sent, rate |<p>The total number of bytes sent to this server per second.</p> |DEPENDENT |nginx.stream.upstream.peer.sent.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.sent`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: Received, rate |<p>The total number of bytes received from this server per second.</p> |DEPENDENT |nginx.stream.upstream.peer.received.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.received`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: Fails, rate |<p>The total number of unsuccessful attempts to communicate with the server per second.</p> |DEPENDENT |nginx.stream.upstream.peer.fails.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.fails`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: Unavail |<p>Displays how many times the server has  become unavailable for client requests (the state - “unavail”) due to the number of unsuccessful attempts reaching the `max_fails` threshold.</p> |DEPENDENT |nginx.stream.upstream.peer.unavail.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.unavail`</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: Connections |<p>The total number of client connections forwarded to this server.</p> |DEPENDENT |nginx.stream.upstream.peer.connections.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.connections`</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: Connect time |<p>The average time to connect to the upstream server.</p> |DEPENDENT |nginx.stream.upstream.peer.connect_time.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.connect_time`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: First byte time |<p>The average time to receive the first byte of data.</p> |DEPENDENT |nginx.stream.upstream.peer.first_byte_time.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.first_byte_time`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: Response time |<p>The average time to receive the last byte of data.</p> |DEPENDENT |nginx.stream.upstream.peer.response_time.rate[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.response_time`</p><p>⛔️ON_FAIL: `DISCARD_VALUE -> `</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: Health checks, check |<p>The total number of health check requests made.</p> |DEPENDENT |nginx.stream.upstream.peer.health_checks.checks[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.health_checks.checks`</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: Health checks, fails |<p>The number of failed health checks.</p> |DEPENDENT |nginx.stream.upstream.peer.health_checks.fails[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.health_checks.fails`</p> |
|Nginx |Nginx: Stream upstream [{#UPSTREAM}] peer [{#PEER}]: Health checks, unhealthy |<p>Displays how many times the server has become `unhealthy` (the state - “unhealthy”).</p> |DEPENDENT |nginx.stream.upstream.peer.health_checks.unhealthy[{#UPSTREAM},{#PEER}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.health_checks.unhealthy`</p> |
|Nginx |Nginx: Resolver [{#NAME}]: Raw data |<p>The raw data of the `Resolver` with the name `{#NAME}`.</p> |DEPENDENT |nginx.resolvers.raw[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$['{#NAME}']`</p> |
|Nginx |Nginx: Resolver [{#NAME}]: Requests name, rate |<p>The total number of requests to resolve names to addresses per second.</p> |DEPENDENT |nginx.resolvers.requests.name.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.requests.name`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Resolver [{#NAME}]: Requests srv, rate |<p>The total number of requests to resolve SRV records per second.</p> |DEPENDENT |nginx.resolvers.requests.srv.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.requests.srv`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Resolver [{#NAME}]: Requests addr, rate |<p>The total number of requests to resolve addresses to names per second.</p> |DEPENDENT |nginx.resolvers.requests.addr.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.requests.addr`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Resolver [{#NAME}]: Responses noerror, rate |<p>The total number of successful responses per second.</p> |DEPENDENT |nginx.resolvers.responses.noerror.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.noerror`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Resolver [{#NAME}]: Responses formerr, rate |<p>The total number of `FORMERR` (format error) responses per second.</p> |DEPENDENT |nginx.resolvers.responses.formerr.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.formerr`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Resolver [{#NAME}]: Responses servfail, rate |<p>The total number of `SERVFAIL` (server failure) responses per second.</p> |DEPENDENT |nginx.resolvers.responses.servfail.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.servfail`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Resolver [{#NAME}]: Responses nxdomain, rate |<p>The total number of `NXDOMAIN` (host not found) responses per second.</p> |DEPENDENT |nginx.resolvers.responses.nxdomain.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.nxdomain`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Resolver [{#NAME}]: Responses notimp, rate |<p>The total number of `NOTIMP` (unimplemented) responses per second.</p> |DEPENDENT |nginx.resolvers.responses.notimp.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.notimp`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Resolver [{#NAME}]: Responses refused, rate |<p>The total number of `REFUSED` (operation refused) responses per second.</p> |DEPENDENT |nginx.resolvers.responses.refused.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.refused`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Resolver [{#NAME}]: Responses timedout, rate |<p>The total number of timed out requests per second.</p> |DEPENDENT |nginx.resolvers.responses.timedout.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.timedout`</p><p>- CHANGE_PER_SECOND</p> |
|Nginx |Nginx: Resolver [{#NAME}]: Responses unknown, rate |<p>The total number of requests completed with an unknown error per second.</p> |DEPENDENT |nginx.resolvers.responses.unknown.rate[{#NAME}]<p>**Preprocessing**:</p><p>- JSONPATH: `$.responses.unknown`</p><p>- CHANGE_PER_SECOND</p> |
|Zabbix raw items |Nginx: Get info |<p>Return status of the NGINX running instance.</p> |HTTP_AGENT |nginx.info |
|Zabbix raw items |Nginx: Get connections |<p>Returns the statistics of client connections.</p> |HTTP_AGENT |nginx.connections |
|Zabbix raw items |Nginx: Get SSL |<p>Returns the SSL statistics.</p> |HTTP_AGENT |nginx.ssl |
|Zabbix raw items |Nginx: Get requests |<p>Returns the status of the client's HTTP requests.</p> |HTTP_AGENT |nginx.requests |
|Zabbix raw items |Nginx: Get HTTP zones |<p>Returns the status information for each HTTP server zone.</p> |HTTP_AGENT |nginx.http.server_zones |
|Zabbix raw items |Nginx: Get HTTP location zones |<p>Returns the status information for each HTTP location zone.</p> |HTTP_AGENT |nginx.http.location_zones |
|Zabbix raw items |Nginx: Get HTTP upstreams |<p>Returns the status of each HTTP upstream server group and its servers.</p> |HTTP_AGENT |nginx.http.upstreams |
|Zabbix raw items |Nginx: Get Stream server zones |<p>Returns the status information for each server zone configured in the "stream" directive.</p> |HTTP_AGENT |nginx.stream.server_zones |
|Zabbix raw items |Nginx: Get Stream upstreams |<p>Returns status of each stream upstream server group and its servers.</p> |HTTP_AGENT |nginx.stream.upstreams |
|Zabbix raw items |Nginx: Get resolvers |<p>Returns the status information for each Resolver zone.</p> |HTTP_AGENT |nginx.resolvers |

### Triggers

|Name|Description|Expression|Severity|Dependencies and additional info|
|----|-----------|----|----|----|
|Nginx: Server response error |<p>-</p> |`length(last(/NGINX Plus by HTTP/nginx.info.error))>0` |HIGH | |
|Nginx: Version has changed |<p>Nginx version has changed. Acknowledge to close manually.</p> |`last(/NGINX Plus by HTTP/nginx.info.version,#1)<>last(/NGINX Plus by HTTP/nginx.info.version,#2) and length(last(/NGINX Plus by HTTP/nginx.info.version))>0` |INFO |<p>Manual close: YES</p> |
|Nginx: Host has been restarted |<p>Uptime is less than 10 minutes.</p> |`last(/NGINX Plus by HTTP/nginx.info.uptime)<10m` |INFO |<p>Manual close: YES</p> |
|Nginx: Failed to fetch info data |<p>Zabbix has not received any data for metrics for the last 30 minutes</p> |`nodata(/NGINX Plus by HTTP/nginx.info.uptime,30m)=1` |WARNING |<p>Manual close: YES</p> |
|Nginx: High connections drop rate |<p>The rate of dropped connections is greater than `{$NGINX.DROP_RATE.MAX.WARN}` for the last 5 minutes.</p> |`min(/NGINX Plus by HTTP/nginx.connections.dropped,5m) > {$NGINX.DROP_RATE.MAX.WARN}` |WARNING | |
|Nginx: HTTP upstream server is not in UP or DOWN state. |<p>-</p> |`find(/NGINX Plus by HTTP/nginx.http.upstream.peer.state[{#UPSTREAM},{#PEER}],,"like","up")=0 and find(/NGINX Plus by HTTP/nginx.http.upstream.peer.state[{#UPSTREAM},{#PEER}],,"like","down")=0` |WARNING | |
|Nginx: Too many HTTP requests with code 4xx |<p>-</p> |`sum(/NGINX Plus by HTTP/nginx.http.upstream.peer.responses.4xx.rate[{#UPSTREAM},{#PEER}],5m) > (sum(/NGINX Plus by HTTP/nginx.http.upstream.peer.responses.total.rate[{#UPSTREAM},{#PEER}],5m)*({$NGINX.HTTP.UPSTREAM.4XX.MAX.WARN}/100))` |WARNING | |
|Nginx: Too many HTTP requests with code 5xx |<p>-</p> |`sum(/NGINX Plus by HTTP/nginx.http.upstream.peer.responses.5xx.rate[{#UPSTREAM},{#PEER}],5m) > (sum(/NGINX Plus by HTTP/nginx.http.upstream.peer.responses.total.rate[{#UPSTREAM},{#PEER}],5m)*({$NGINX.HTTP.UPSTREAM.5XX.MAX.WARN}/100))` |HIGH | |
|Nginx: Stream upstream server is not in UP or DOWN state. |<p>-</p> |`find(/NGINX Plus by HTTP/nginx.stream.upstream.peer.state[{#UPSTREAM},{#PEER}],,"like","up")=0 and find(/NGINX Plus by HTTP/nginx.stream.upstream.peer.state[{#UPSTREAM},{#PEER}],,"like","down")=0` |WARNING | |

## Feedback

Please report any issues with the template at https://support.zabbix.com.

You can also provide feedback, discuss the template, or ask for help at [ZABBIX forums](https://www.zabbix.com/forum/zabbix-suggestions-and-feedback).

