// ----------------------------------------------------------------------------
//
//  Copyright (C) 2008-2017 Fons Adriaensen <fons@linuxaudio.org>
//    
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
// ----------------------------------------------------------------------------


#ifndef __KMETERDSP_H
#define	__KMETERDSP_H


class Kmeterdsp
{
public:

    Kmeterdsp (void);
    ~Kmeterdsp (void);

    void process (float *p, int n);  
    void read (float *rms, float *dpk);

    static void init (int fsamp, int fsize, float hold, float fall);

private:

    float          _z1;          // filter state
    float          _z2;          // filter state
    float          _rms;         // max rms value since last read()
    float          _dpk;         // current digital peak value
    int            _cnt;	 // digital peak hold counter
    bool           _flag;        // flag set by read(), resets _rms


    static int     _hold;        // number of JACK periods to hold peak value
    static float   _fall;        // per period fallback multiplier for peak value
    static float   _omega;       // ballistics filter constant.
};


#endif
