<?php
/**
 * View to display errors occured during backup
 *
 * This file is part of Zoph.
 *
 * Zoph is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Zoph is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with Zoph; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @package Zoph
 * @author Jeroen Roos
 */

namespace backup\view;

use conf\conf;
use template\block;
use template\template;
use web\request;
use web\view\view;

/**
 * View to display errors occured during backup
 */
class error extends view implements \view {
    private $msg;

    /**
     * Create view
     * @param request web request
     */
    public function __construct(request $request, string $msg) {
        $this->request=$request;
        $this->vars=$request->getRequestVars();
        $this->msg = $msg;
    }

    /**
     * Output view
     */
    public function view() : block {
        $tpl = new block("main", array(
            "title" => $this->getTitle()
        ));
        $tpl->addBlock(new block("message", array(
            "class" => "error",
            "title" => translate("Error occured during backup"),
            "text"  => $this->msg
        )));

        $tpl->addActionlinks(array(
            translate("return")    => "backup.php"
        ));
        return $tpl;
    }

    /**
     * Get the title for this view
     */
    public function getTitle() : string {
        return translate("Error");
    }

}
