#!/bin/sh
# $Id: rdwr.sh,v 1.4 2004/12/29 23:39:55 ca Exp $
# Copyright (c) 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# display disk usage statistics
# run test program t-readwrite, use iostat
#

test -s stop && exit 1              

DISK=${DISK:-wd2}
FILE=file
SYNC=""
OPTS="-w"
PT=.
READ=true
IOS="-I -D"

while getopts bD:I:sf:p: FLAG
do
  case "${FLAG}" in
    b) READ=false
	OPTS="-b";;
    D) DISK="${OPTARG}";;
    f) FILE="${OPTARG}";;
    I) IOS="${OPTARG}";;
    s) SYNC="-s";;
    p) PT="${OPTARG}";;
    ?)
       echo "$0: unknown option ${FLAG}"
       echo "$0: options:"
       echo "-b       perform write/read in a single invocation"
       echo "-f name  use name instead of ${FILE}"
       echo "-s       sync file after write"
       echo "-p path  use path for program instead of ${PT}"
       exit 1
       ;;
  esac
done
shift `expr ${OPTIND} - 1`

iostat ${IOS} ${DISK}
${PT}/t-readwrite ${OPTS} ${SYNC} ${FILE}
iostat ${IOS} ${DISK}
if ${READ}
then
  ${PT}/t-readwrite ${FILE}
  iostat ${IOS} ${DISK}
fi
rm -f ${FILE}
iostat ${IOS} ${DISK}
exit 0
