/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-xtextify.c,v 1.4 2004/12/29 23:47:30 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/test.h"
#include "sm/str.h"
#include "sm/io.h"

#define SMAXLEN	64	/* don't change, see below: "too long" */
#define SNORLEN	32

#define XISOK SM_TEST(strncmp(b, (char *) sm_str_data(s), sm_str_getlen(s)) == 0)

static void
test_harness(void)
{
	sm_str_P s;
	sm_ret_T ret;
	char *b;

	s = sm_str_new(NULL, SNORLEN, SMAXLEN);
	SM_TEST(s != NULL);

	b = "abc";
	sm_str_clr(s);
	ret = xtextify(b, "", s);
	SM_TEST(ret == SM_SUCCESS);
	XISOK;

	b = "abcdefghijklmnopqrstuvwxyz";
	sm_str_clr(s);
	ret = xtextify(b, "", s);
	SM_TEST(ret == SM_SUCCESS);
	XISOK;

	b = "abc+";
	sm_str_clr(s);
	ret = xtextify(b, "", s);
	SM_TEST(ret == SM_SUCCESS);
	b = "abc+2B";
	XISOK;

	b = "abc\\";
	sm_str_clr(s);
	ret = xtextify(b, "", s);
	SM_TEST(ret == SM_SUCCESS);
	b = "abc+5C";
	XISOK;

	b = "abc+\\";
	sm_str_clr(s);
	ret = xtextify(b, "", s);
	SM_TEST(ret == SM_SUCCESS);
	b = "abc+2B+5C";
	XISOK;

	b = "abc+\\abc(";
	sm_str_clr(s);
	ret = xtextify(b, "", s);
	SM_TEST(ret == SM_SUCCESS);
	b = "abc+2B+5Cabc+28";
	XISOK;

	b = "abc+\\abc()";
	sm_str_clr(s);
	ret = xtextify(b, "", s);
	SM_TEST(ret == SM_SUCCESS);
	b = "abc+2B+5Cabc+28)";
	XISOK;

	b = "abc+\\abc()";
	sm_str_clr(s);
	ret = xtextify(b, ")", s);
	SM_TEST(ret == SM_SUCCESS);
	b = "abc+2B+5Cabc+28+29";
	XISOK;

	b = "abc+\\abc()<>";
	sm_str_clr(s);
	ret = xtextify(b, ")", s);
	SM_TEST(ret == SM_SUCCESS);
	b = "abc+2B+5Cabc+28+29<>";
	XISOK;

	b = "abc+\\abc()<>";
	sm_str_clr(s);
	ret = xtextify(b, ")<>", s);
	SM_TEST(ret == SM_SUCCESS);
	b = "abc+2B+5Cabc+28+29+3C+3E";
	XISOK;

	b = "0123456789012345678901234567890123456789abc+\\abc()<>";
	sm_str_clr(s);
	ret = xtextify(b, ")<>", s);
	SM_TEST(sm_is_err(ret));	/* result too long */

	sm_str_free(s);
}

int
main(int argc, char *argv[])
{
	sm_test_begin(argc, argv, "test xtextify");
	test_harness();
	return sm_test_end();
}
