#!/bin/sh
# $Id: t-bounce-1.sh,v 1.23 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test bounces; including text of bounces delivered via lmtp to smtps3
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
OK1="t-bounce-1-1.ok"
OUT1="t-bounce-1-1.out"
OK2="t-bounce-1-2.ok"
OUT2="t-bounce-1-2.out"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
aliase3: <553@local.dom>
553: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

# ----------------------------------------
# 2 failed recipients;
# permanent failure from SMTP sink; create two bounces (-O D=1); check content
# Note: due to the "randomness" of the scheduler the bounces can be in
# any order, hence both need to be compared against both "OK" files.
TEST=1
if echo " ${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
${CAT} > ${OK1} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<554@local.host>
Remote-MTA: 127.0.0.1
Reason:
554 whatever
EOF

${CAT} > ${OK2} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Undeliverable mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA. I'm sorry to inform you that a mail
from you could not be delivered. See below for details.

Recipient:
<553@local.dom>
Expanded from:
<aliase3@local.dom>
Remote-MTA: ${SM_LMTPIPV4D}
Reason:
553 whatever
EOF

if ${SHELL} ${SD}/smtp1.sh -3 lmtpsock -Ssender@local.dom -R"554@local.host -Raliase3@local.dom" -i 10 -E 1 -X 1 -A 1 -s 10 -Q '-O D=1'
then

  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^during RCPT/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT1}
  else
     ERR=true
  fi

  if test -s ${B2}
  then
     ${EGREP} -v '^Date: ' ${B2} |\
	 ${SED} -e '/^during RCPT/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT2}
  else
     ERR=true
  fi

  if ${ERR}
  then
    :
  else
    if ${DIFF} -w ${OK2} ${OUT2} >/dev/null
    then
      if ${DIFF} -w ${OK1} ${OUT1} >/dev/null
      then
        :
      else
        ERR=true
      fi
    else
      if ${DIFF} -w ${OK1} ${OUT2} >/dev/null
      then
        if ${DIFF} -w ${OK2} ${OUT1} >/dev/null
        then
          :
        else
          ERR=true
        fi
      else
        ERR=true
      fi
    fi

  fi

else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi

fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
