#!/bin/sh
# $Id: t-delay-0.sh,v 1.12 2005/10/21 18:02:19 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test delay message; including text of bounces delivered via lmtp to smtps3
# run smtp1.sh with different parameters
# ----------------------------------------
#
test -s stop && exit 1
#

if test X"${SM_NO_SLOW_TEST}" != "X"
then
  echo "$0: SKIPPED due to SM_NO_SLOW_TEST"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../chkmts
fi
. ${SD}/common.sh

I=""
ERRS=0
OK="t-delay-0.ok"
OUT="t-delay-0.out"
TMP="t-delay-0.tmp"
EDBROK="t-delay-0.edbr"

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# cd to working directory for alias file!
cd ../qmgr || exit 1

if ./qmgr -VVV 2>/dev/null | ${GREP} SM_DELAYED_DSN >/dev/null
then
  :
else
  echo "$0: qmgr not compiled with SM_DELAYED_DSN; test SKIPPED"
  exit 0
fi

# create aliases
${CAT} > ${ALI} <<EOF
abuse:	local:
postmaster:	local:
user:	local:
sender: local:
EOF
# create map
rm -f ${ALIMAP}
${MM} < ${ALI}
rm -f ${MTMAP}

# run some test programs

# ----------------------------------------
# temporary failure from SMTP sink; create a warning DSN; check content
TEST=1
if echo "${SKIP} X" | ${GREP} -v " ${TEST} " > /dev/null
then
ERR=false
${CAT} > ${EDBROK} <<EOF
got transaction
	mail=<sender@local.dom>
	rcpts_tot=2
	rcpts_left=1
	rcpts_temp=1
	rcpts_perm=0
	state=0
	aqt_rcpts_ar=0
got recipient
	rcpt=<451@local.host>
	aqr_rcpt_idx=0
	aqr_da_idx=0
	aqr_status=451
EOF
if ${SHELL} ${SD}/smtp1.sh -O ${EDBROK} -3 lmtpsock -Ssender@local.dom -R451@local.host -Q '-M 20 -T w=5' -i 8 -s 30 -E 2 -X 0 -A 1
then
  if test -s ${B1}
  then
     ${EGREP} -v '^Date: ' ${B1} |\
	 ${SED} -e '/^Received:/,$d' \
		-e 's/
$//' -e 's/Mailer-Daemon@.*/Mailer-Daemon@/' > ${OUT}

     ${CAT} > ${OK} <<EOF
Return-Path: <>
From: Mailer-Daemon@
Subject: Delayed mail
To: <sender@local.dom>

Hi! This is the sendmail X MTA.
A mail from you has not yet been successfully delivered.
It will be tried again, so you do not need to resend it!
See below for details.

Recipient:
<451@local.host>
Remote-MTA: 127.0.0.1
Reason:
451 whatever
during RCPT


Your original mail follows:
EOF
    if ${DIFF} -w ${OK} ${OUT} >/dev/null
    then
      ls ?/S0* > ${TMP}
      if test -s ${TMP}
      then
        :
        # check defedb: must have an entry?
      else
        ${VERBOSE} && echo "$0: missing CDB entry"
        ERR=true
      fi
    else
      ERR=true
    fi

  else
     ERR=true
  fi
else
  ERR=true
fi
if ${ERR}
then
   echo "$0: test ${TEST} failed"
   ERRS=`expr ${ERRS} + 1 `
   test X"${SM_STOPONERROR}" != X && exit 1
fi
fi


# ----------------------------------------
# end
if test "${ERRS}" = "0"
then
  rm -f ${EDBROK}
  exit 0
else
  echo "${ERRS} error(s)"
  exit 1
fi
