/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: batv.h,v 1.3 2005/04/30 16:01:09 ca Exp $
 */

#ifndef SM_BATV_H
#define SM_BATV_H 1
#include "sm/generic.h"
#include "sm/types.h"
#include "sm/str.h"
#include "sm/sha.h"
#include "sm/batvcnf.h"

#if HAVE_SHA1
# ifndef SM_USE_BATV
#  define SM_USE_BATV	1
# endif
# else
# if SM_USE_BATV
   ERROR cannot use BATV without SHA
# endif
#endif

#define BATV_SIG_LEN	6
typedef char	batv_T[BATV_SIG_LEN + 1], *batv_P;
/* + 1: terminating '\0' */

/* BATV usage flags */
#define BATV_REJ_UNTAGGED	0x0001
#define BATV_ALWAYSUSE		0x0002
#define BATV_USE_IF_MARKED	0x0004

#if SM_USE_BATV
sm_ret_T	 sm_batv_sign(const char *_address, uint _days, uint _key, batv_cnf_P _batv_cnf, batv_P _batv_sig);
sm_ret_T	 sm_batv_sign1(const char *_address, uint _key, batv_cnf_P _batv_cnf, batv_P _batv_sig);
sm_ret_T	 sm_batv_vrfy(sm_str_P _address, batv_cnf_P _batv_cnf);

sm_ret_T	sm_batv_saddr(sm_str_P _address, uint _key, batv_cnf_P _batv_cnf, sm_str_P _batvaddr);
sm_ret_T	 sm_batv_getkey(uint _key, batv_cnf_P _batv_cnf, batv_key_P *_pbatv_key);
#endif /* SM_USE_BATV */

#endif /* SM_BATV_H */
