/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: ssocc.h,v 1.10 2005/10/24 22:43:18 ca Exp $
 */

#ifndef SM_SSOCC_H
#define SM_SSOCC_H 1

#include "sm/generic.h"
#include "sm/magic.h"
#include "sm/types.h"
#include "sm/pthread.h"
#include "sm/net.h"
#include "sm/bhtable.h"
#include "sm/queue.h"
#include "sm/ssoccstr.h"
#include "sm/connctl.h"

#ifndef SSOCC_CHECK
# define SSOCC_CHECK	1
#endif

typedef SIMPLEQ_HEAD(, ssocc_entry_S)	ssocc_entry_hd_T, *ssocc_entry_hd_P;

struct ssocc_ctx_S
{
#if SSOCC_CHECK
	sm_magic_T	 sm_magic;
#endif
	pthread_mutex_t	 ssocc_mutex;

	/* switch to RSC as for DA? */
	bht_P		 ssocc_ht;	/* open connections in SMTPS */
	ssocc_entry_hd_T ssocc_fl_hd;	/* list of free SMTPS OCC entries */

	/* connection rate control context */
	connctx_P	 ssocc_cctx;
};

/* SMTP Server (open) Connection Cache entry */
struct ssocc_entry_S
{
#if SSOCC_CHECK
	sm_magic_T	 sm_magic;
#endif
/*
	pthread_mutex_t	 ssocce_mutex;
*/
	ipv4_T		 ssocce_srv_ipv4;	/* XXX HACK! */

#if 0
	uint		 ssocce_flags;

	/* concurrency control: initial, current, maximum */
	uint		 ssocce_init_conc;
	uint		 ssocce_cur_conc;
	uint		 ssocce_max_conc;
#endif /* 0 */

	uint		 ssocce_open_se;	/* # of open sessions */
#if 0
	uint		 ssocce_open_ta;	/* # of open transaction */
#endif
	time_T		 ssocce_last_conn;	/* time of last connect */

	SIMPLEQ_ENTRY(ssocc_entry_S)	 ssocc_fl;	/* next free entry */
};

#if 0
/* SSOCC entry flags */
#define SSOCCE_FL_NONE		0x0000	/* guess */
#define SSOCCE_FL_USED		0x0001	/* in use */

/* TA is waiting, inform scheduler when a transaction is done */
#define SSOCCE_FL_TA_WAIT		0x0002

#define SSOCCE_SET_FLAG(ssocc_entry, fl)	(ssocc_entry)->ssocce_flags |= (fl)
#define SSOCCE_CLR_FLAG(ssocc_entry, fl)	(ssocc_entry)->ssocce_flags &= ~(fl)
#define SSOCCE_IS_FLAG(ssocc_entry, fl)	(((ssocc_entry)->ssocce_flags & (fl)) != 0)
#endif /* 0 */

#define SSOCCFL_INIT(ssocc_fl_hd)	SIMPLEQ_INIT(ssocc_fl_hd)
#define SSOCCFL_FIRST(ssocc_fl_hd)	SIMPLEQ_FIRST(ssocc_fl_hd)
#define SSOCCFL_END(ssocc_fl_hd)	SIMPLEQ_END(ssocc_fl_hd)
#define SSOCCFL_EMPTY(ssocc_fl_hd)	SIMPLEQ_EMPTY(ssocc_fl_hd)
#define SSOCCFL_NEXT(ssocc_entry)		SIMPLEQ_NEXT(ssocc_entry, ssocc_fl)
#define SSOCCFL_PRE(ssocc_fl_hd, ssocc_entry) SIMPLEQ_INSERT_HEAD(ssocc_fl_hd, ssocc_entry, ssocc_fl)
#define SSOCCFL_APP(ssocc_fl_hd, ssocc_entry) SIMPLEQ_INSERT_TAIL(ssocc_fl_hd, ssocc_entry, ssocc_fl)
#define SSOCCFL_REMOVE(ssocc_fl_hd) SIMPLEQ_REMOVE_HEAD(ssocc_fl_hd, ssocc_fl)

#if SSOCC_CHECK
# define SM_IS_SSOCC(ssocc_ctx)	SM_REQUIRE_ISA((ssocc_ctx), SM_SSOCC_MAGIC)
# define SM_IS_SSOCCE(ssocc_entry) SM_REQUIRE_ISA((ssocc_entry), SM_SSOCCE_MAGIC)
#else
# define SM_IS_SSOCC(ssocc_ctx)	SM_REQUIRE((ssocc_entry) != NULL)
# define SM_IS_SSOCCE(ssocc_entry)	SM_REQUIRE((ssocc_entry) != NULL)
#endif

sm_ret_T ssocc_entry_free(ssocc_ctx_P _ssocc_ctx, ssocc_entry_P _ssocc_entry, thr_lock_T _lockit);
sm_ret_T ssocc_entry_new(ssocc_ctx_P _ssocc_ctx, ipv4_T _ipv4, ssocc_entry_P *_pssocc_entry, thr_lock_T _lockit);
sm_ret_T ssocc_entry_find(ssocc_ctx_P _ssocc_ctx, ipv4_T _ipv4, ssocc_entry_P *_pssocc_entry, thr_lock_T _lockit);

#endif /* SM_SSOCC_H */
