/*
 * Copyright (c) 2003, 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-edbc-0.c,v 1.12 2004/09/08 23:01:49 ca Exp $")

#include "t-edbc.h"

static void
test(void)
{
	int a;
	rcpt_id_T rcpt_ids[MAX_KEYS];
	sm_ret_T ret;

	sm_memzero(&edbc_node_search, sizeof(edbc_node_search));
	sm_memzero(&edbc_tnode, sizeof(edbc_tnode));
	ECNL_INIT(&(edbc_tnode.ectn_hd));
	ECNL_APP(&(edbc_tnode.ectn_hd), &edbc_node_search);

	ret = edbc_open(&edbc_ctx, 0, 0);
	SM_TEST(ret == SM_SUCCESS);
	if (ret != SM_SUCCESS)
		return;

	for (a = 0; a < MAX_KEYS; a++)
	{
		next_try[a] = a;
		added[a] = false;
		sm_snprintf(rcpt_ids[a], sizeof(rcpt_ids[a]),
			SMTP_RCPTID_FORMAT, "rcpt-id-filler-text", a);
	}

	next_try[1] = 9;
	next_try[6] = 5;
	next_try[7] = 5;
	next_try[9] = 5;
	next_try[10] = 11;
	next_try[12] = 10;

	intree();
	TINS(3);
	TINS(5);
	TINS(1);
	TINS(10);
	TINS(4);
	TINS(12);
	TINS(2);
	TINS(9);
	TINS(8);
	TINS(7);
	TINS(11);
	TINS(6);

	print_tree(edbc_ctx);

	/* finds time == 11, 2 entries */
	edbc_tnode_ret = edbct_last(edbc_ctx);
	SM_TEST(edbc_tnode_ret != NULL);
	SM_TEST(ECNL_FIRST(&(edbc_tnode_ret->ectn_hd))->ecn_next_try == 11);
	ret = edbct_rm(edbc_ctx, edbc_tnode_ret);
	SM_TEST(ret == SM_SUCCESS);
	Entries -= 2;
	added[11] = false;
	INTREE(11);
	intree();
	print_tree(edbc_ctx);

	/* finds time == 10 */
	edbc_tnode_ret = edbct_last(edbc_ctx);
	SM_TEST(edbc_tnode_ret != NULL);
	SM_TEST(ECNL_FIRST(&(edbc_tnode_ret->ectn_hd))->ecn_next_try == 10);
	ret = edbct_rm(edbc_ctx, edbc_tnode_ret);
	SM_TEST(ret == SM_SUCCESS);
	Entries--;
	added[10] = false;
	INTREE(10);
	intree();
	print_tree(edbc_ctx);

	/* finds time == 9 */
	edbc_tnode_ret = edbct_last(edbc_ctx);
	SM_TEST(edbc_tnode_ret != NULL);
	SM_TEST(ECNL_FIRST(&(edbc_tnode_ret->ectn_hd))->ecn_next_try == 9);
	ret = edbct_rm(edbc_ctx, edbc_tnode_ret);
	SM_TEST(ret == SM_SUCCESS);
	Entries--;
	added[9] = false;
	INTREE(9);
	intree();
	print_tree(edbc_ctx);

	/* finds time == 8 */
	edbc_tnode_ret = edbct_last(edbc_ctx);
	SM_TEST(edbc_tnode_ret != NULL);
	SM_TEST(ECNL_FIRST(&(edbc_tnode_ret->ectn_hd))->ecn_next_try == 8);
	ret = edbct_rm(edbc_ctx, edbc_tnode_ret);
	SM_TEST(ret == SM_SUCCESS);
	Entries--;
	added[8] = false;
	INTREE(8);
	intree();
	print_tree(edbc_ctx);

	/* finds time == 5 */
	edbc_tnode_ret = edbct_last(edbc_ctx);
	SM_TEST(edbc_tnode_ret != NULL);
	SM_TEST(ECNL_FIRST(&(edbc_tnode_ret->ectn_hd))->ecn_next_try == 5);
	ret = edbct_rm(edbc_ctx, edbc_tnode_ret);
	SM_TEST(ret == SM_SUCCESS);
	Entries -= 4;
	added[5] = false;
	INTREE(5);
	intree();
	print_tree(edbc_ctx);

	/* finds time == 4 */
	edbc_tnode_ret = edbct_last(edbc_ctx);
	SM_TEST(edbc_tnode_ret != NULL);
	SM_TEST(ECNL_FIRST(&(edbc_tnode_ret->ectn_hd))->ecn_next_try == 4);
	ret = edbct_rm(edbc_ctx, edbc_tnode_ret);
	SM_TEST(ret == SM_SUCCESS);
	Entries--;
	added[4] = false;
	INTREE(4);
	intree();
	print_tree(edbc_ctx);

	/* finds time == 3 */
	edbc_tnode_ret = edbct_last(edbc_ctx);
	SM_TEST(edbc_tnode_ret != NULL);
	SM_TEST(ECNL_FIRST(&(edbc_tnode_ret->ectn_hd))->ecn_next_try == 3);
	ret = edbct_rm(edbc_ctx, edbc_tnode_ret);
	SM_TEST(ret == SM_SUCCESS);
	Entries--;
	added[3] = false;
	INTREE(3);
	intree();
	print_tree(edbc_ctx);

	/* finds time == 2 */
	edbc_tnode_ret = edbct_last(edbc_ctx);
	SM_TEST(edbc_tnode_ret != NULL);
	SM_TEST(ECNL_FIRST(&(edbc_tnode_ret->ectn_hd))->ecn_next_try == 2);
	ret = edbct_rm(edbc_ctx, edbc_tnode_ret);
	SM_TEST(ret == SM_SUCCESS);
	Entries--;
	added[2] = false;
	INTREE(2);
	intree();
	print_tree(edbc_ctx);

	edbc_tnode_ret = edbct_last(edbc_ctx);
	SM_TEST(edbc_tnode_ret == NULL);

	print_tree2(edbc_ctx);

  error:
	edbc_close(edbc_ctx);
	return;
}

int
main(int argc, char *argv[])
{
	sm_test_begin(argc, argv, "test edbc 0");
	test();
	return sm_test_end();
}
