/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_IDSTR(id, "@(#)$Id: t-idbr-1.c,v 1.9 2005/10/14 22:48:30 ca Exp $")

#include "sm/io.h"
#include "sm/mta.h"
#include "sm/ibdb.h"
#include "sm/cdb.h"
#include "sm/qmgr.h"
#include "sm/memops.h"
#include "sm/bhtable.h"
#include "sm/test.h"
#include <stdio.h>

/*
**  Test program to read IBDB sequence numbers, i.e., for ibdbf_get_seq()
*/

#define FNAME	"ibd"
#define IBDBSIZE	8192
#define MAX_STR_SZ	256

static int debug = 0;

/*
**  TESTIDBR -- read IBDB sequence numbers
**
**	Parameters:
**		none.
**
**	Returns:
**		usual sm_error code.
*/

static sm_ret_T
testidbr(void)
{
	uint32_t first, last;
	sm_ret_T ret;

	ret = ibdbf_get_seq(FNAME, IBDB_OFL_WRITE, &first, &last);
	SM_TEST(ret == SM_SUCCESS);
	if (ret != SM_SUCCESS)
		return ret;
	printf("first: %u\n", first);
	printf("last: %u\n", last);
	return ret;
}

static void
usage(const char *prg)
{
	fprintf(stderr, "usage: %s [options]\n", prg);
	fprintf(stderr, "-d n	set debug level\n");
	exit(1);
}

int
main(int argc, char *argv[])
{
	int c;
	sm_ret_T ret;

	debug = 0;
	while ((c = getopt(argc, argv, "d:m:")) != -1)
	{
		switch (c)
		{
		  case 'd':
			debug = strtol(optarg, NULL, 0);
			break;
		  default:
			usage(argv[0]);
			return(1);
		}
	}

	sm_test_begin(argc, argv, "test sm_idbr_1");
	ret = testidbr();
	return sm_test_end();
}
