#!/bin/sh
# $Id: t-idbr-1.sh,v 1.10 2005/05/31 21:03:57 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# test program to read IBDB sequence numbers (first and last)
# Uses t-idbr-1.c
# ------------------------------------------------------------
#
test -s stop && exit 1
#
SD=`dirname $0`
. ${SD}/../chkmts/common.sh

IBDB_F='ibd0000003'
IBDB_M='ibd0000009'
IBDB_L='ibd0000090'
ERRS=0
OUT=ibdr-1.out
OK=ibdr-1.ok

P=t-idbr-1

rm -rf ${IBDBDIR} ${OUT} ${OK}

if ${VALGRIND} ./${P} >/dev/null 2>&1
then
  # must fail...
  ERRS=`expr ${ERRS} + 1 `
fi

test -d ${IBDBDIR} || mkdir -p ${IBDBDIR}

if ${VALGRIND} ./${P} >/dev/null 2>&1
then
  # still fails since there is no file
  ERRS=`expr ${ERRS} + 1 `
fi

touch ${IBDBDIR}/${IBDB_F}
cat >${OK} <<EOF
first: 3
last: 3
EOF
if ${VALGRIND} ./${P} > ${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

touch ${IBDBDIR}/${IBDB_L}
cat >${OK} <<EOF
first: 3
last: 90
EOF
if ${VALGRIND} ./${P} > ${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

touch ${IBDBDIR}/${IBDB_M}
cat >${OK} <<EOF
first: 3
last: 90
EOF
if ${VALGRIND} ./${P} > ${OUT}
then
  if diff ${OK} ${OUT}
  then
    :
  else
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ERRS=`expr ${ERRS} + 1 `
fi

rm -rf ${IBDBDIR} ${OUT} ${OK}

exit ${ERRS}
