/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: cstrcmp.c,v 1.3 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "sm/cstr.h"

/*
**  SM_CSTR_CMP -- Compare two cstrings
**
**	Parameters:
**		s1 -- first string
**		s2 -- second string
**
**	Returns:
**		0: strings are equal
**		<0: 1. string < 2. string
**		>0: 1. string > 2. string
*/

int
sm_cstr_cmp(const sm_cstr_P s1, const sm_cstr_P s2)
{
	int d, r;
	uint l;

	SM_IS_CSTR(s1);
	SM_IS_CSTR(s2);
	l = s1->sm_cstr_len;
	if (l > s2->sm_cstr_len)
	{
		d = 1;
		l = s2->sm_cstr_len;
	}
	else if (l == s2->sm_cstr_len)
		d = 0;
	else
		d = -1;
	r = sm_memcmp(s1->sm_cstr_base, s2->sm_cstr_base, l);
	if (r == 0)
		r = d;
	return r;
}
